/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.db.AccountRecord;
import org.opengts.db.AclEntry;
import org.opengts.db.Audit;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBException;
import org.opengts.util.ClientSocketThread;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DCServerFactory {
    public static final String DCSERVERS_DIR = "dcservers";
    public static final String DCSERVER_XML = "dcservers.xml";
    private static File LoadedDCServerXMLFile = null;
    public static boolean DEFAULT_WARN_PORT_CONFLICT = true;
    public static String DCSNAME_SERVLET_PREFIX = "w-";
    public static final String PROP_Attribute_ = "Attribute.";
    public static final String PROP_Attribute_InputOffset = "Attribute.inputOffset";
    public static final String PROP_Attribute_OutputOffset = "Attribute.outputOffset";
    public static final String PROP_DCServer_ = "DCServer.";
    public static final String PROP_dcs_ = "dcs.";
    public static final String PROP_Command_ = "Command.";
    public static final String PROP_command_ = "command.";
    public static final String PROP_Properties_ = "Properties.";
    public static final String PROP_DCServer_name = "DCServer.name";
    public static final String CMDTYPE_ALL = "all";
    public static final String CMDTYPE_MAP = "map";
    public static final String CMDTYPE_ADMIN = "admin";
    public static final String CMDTYPE_GARMIN = "garmin";
    public static final String CMDTYPE_SYSADMIN = "sysadmin";
    public static final String NONE_NAME = "none";
    public static final String OPENDMTP_NAME = "gtsdmtp";
    public static final String ASTRA_NAME = "astra";
    public static final String LANTRIX_NAME = "lantrix";
    public static final String ICARE_NAME = "icare";
    public static final String SIPGEAR_NAME = "sipgear";
    public static final String TEMPLATE_NAME = "template";
    public static final String ASPICORE_NAME = "aspicore";
    public static final String TK10X_NAME = "tk10x";
    public static final String TAIP_NAME = "taip";
    public static final String MEITRACK_NAME = "meitrack";
    public static final String MEITRACK_MVT_NAME = "mvt";
    public static final String AUTOLEADER_NAME = "autoleader";
    public static final String BOFAN_NAME = "bofan";
    public static final String CALAMP_NAME = "calamp";
    public static final String DCT_NAME = "dct";
    public static final String GL100_NAME = "gl100";
    public static final String PATROLSCAN_NAME = "patrolscan";
    public static final String GT06_NAME = "gt06";
    public static final String HPLOW_NAME = "hplow";
    public static final String SKYPATROL_NAME = "skypatrol";
    public static final String FALCOM_NAME = "falcom";
    public static final String TLT2H_NAME = "tlt2h";
    public static final String TRAXS4_NAME = "traxs4";
    public static final String TT8750_NAME = "tt8750";
    public static final String TT8850_NAME = "tt8850";
    public static final String TZONE_NAME = "tzone";
    public static final String VT3CLON_NAME = "vt3clon";
    public static final String WONDEPROUD_NAME = "wondeproud";
    public static final String SANAV_NAME = "sanav";
    public static final String AGORABEE_NAME = "agorabee";
    public static final String WONDE_NAME = "wonde";
    public static final String LAIPAC_NAME = "laipac";
    public static final String INTELLITRAC_NAME = "intellitrac";
    public static final String INTELLITRAC_A_NAME = "intraca";
    public static final String ANTX_NAME = "antx";
    public static final String MEGASTEK_NAME = "megastek";
    public static final String ARKNAV35_NAME = "arknav35";
    public static final String SNROVER9_NAME = "snrover9";
    public static final String QINETIQ_NAME = "qinetiq";
    public static final String PICCOLO_NAME = "piccolo";
    public static final String BIGWATCHER_NAME = "bigwatcher";
    public static final String MOREY_NAME = "morey";
    public static final String EWING_NAME = "ewing";
    public static final String GT95_NAME = "gt95";
    public static final String T880X_NAME = "t880x";
    public static final String K611_NAME = "k611";
    public static final String GT68_NAME = "gt68";
    public static final String ENFORA_NAME = "enfora";
    public static final String GOTOP680_NAME = "gotop680";
    public static final String RVCT03_NAME = "rvct03";
    public static final String MEITRACK2_NAME = "meitrack2";
    public static final String RVCT04_NAME = "rvct04";
    public static final String ELOC_NAME = "eloc";
    public static final String QGL200_NAME = "qgl200";
    public static final String QGV100_NAME = "qgv100";
    public static final String QGV200_NAME = "qgv200";
    public static final String QGV300_NAME = "qgv300";
    public static final String SCATLITE_NAME = "scatlite";
    public static final String SCVL2000_NAME = "scvl2000";
    public static final String QGT500_NAME = "qgt500";
    public static final String QGL500_NAME = "qgl500";
    public static final String TZAVL05_NAME = "tzavl05";
    public static final String TZAVL08_NAME = "tzavl08";
    public static final String ANTARES_NAME = "antares";
    public static final String ATRACK_NAME = "atrack";
    public static final String WEBTECH_NAME = "webtech";
    public static final String TELTONIKA_NAME = "teltonika";
    public static final String TELGH3000_NAME = "telgh3000";
    public static final String JT600_NAME = "jt600";
    public static final String PGT3000_NAME = "pgt3000";
    public static final String POINTER_NAME = "pointer";
    public static final String CITGT02_NAME = "citgt02";
    public static final String CITGT06_NAME = "citgt06";
    public static final String TOUCAN_NAME = "toucan";
    public static final String GOSAFE_NAME = "gosafe";
    public static final String GOS777_NAME = "gos777";
    public static final String GOS9800_NAME = "gos9800";
    public static final String SENDUM_NAME = "sendum";
    public static final String CLEARCOMM_NAME = "clearcomm";
    public static final String MAESTRO_NAME = "maestro";
    public static final String JSCRT803_NAME = "jscrt803";
    public static final String TRIMTRAC_NAME = "trimtrac";
    public static final String SIERRA_NAME = "sierra";
    public static final String XIRGO_NAME = "xirgo";
    public static final String GLOBALSAT_NAME = "globalsat";
    public static final String STARSNAV_NAME = "starsnav";
    public static final String BLUETREE_NAME = "bluetree";
    public static final String MAJID_NAME = "majid";
    public static final String IRIDIUM_NAME = "iridium";
    public static final String AXONN_NAME = "axonn";
    public static final String FA888_NAME = "fa888";
    public static final String GSSPOT_NAME = "w-gsspot";
    public static final String GEOFORCE_NAME = "w-geoforce";
    public static final String PARATEL_NAME = "w-paratel";
    public static final String DELORME_NAME = "w-delorme";
    public static final String GTSGEN1_NAME = "gtsgen_1";
    public static final String GTSGEN2_NAME = "gtsgen_2";
    public static final String UPLOAD_NAME = "upload";
    private static final String StaticMethod_LoadName = "DCServerFactory_LoadName";
    private static String LoadServerNameOnly = null;
    public static final String CMDARG_ACCOUNT = "account";
    public static final String CMDARG_DEVICE = "device";
    public static final String CMDARG_USER = "user";
    public static final String CMDARG_UNIQUE = "unique";
    public static final String CMDARG_CMDTYPE = "cmdtype";
    public static final String CMDARG_CMDNAME = "cmdname";
    public static final String CMDARG_ARG = "arg";
    public static final String CMDARG_SERVER = "server";
    public static final String RESPONSE_SERVER = "server";
    public static final String RESPONSE_RESULT = "result";
    public static final String RESPONSE_MESSAGE = "message";
    private static final String TAG_DCServerConfig = "DCServerConfig";
    private static final String TAG_DCServer = "DCServer";
    private static final String TAG_Description = "Description";
    private static final String TAG_ModelNames = "ModelNames";
    private static final String TAG_Attributes = "Attributes";
    private static final String TAG_UniqueIDPrefix = "UniqueIDPrefix";
    private static final String TAG_GlobalProperties = "GlobalProperties";
    private static final String TAG_Properties = "Properties";
    private static final String TAG_Property = "Property";
    private static final String TAG_EventCodeMap = "EventCodeMap";
    private static final String TAG_Code = "Code";
    private static final String TAG_Commands = "Commands";
    private static final String TAG_Command = "Command";
    private static final String TAG_Type = "Type";
    private static final String TAG_AclName = "AclName";
    private static final String TAG_String = "String";
    private static final String TAG_StatusCode = "StatusCode";
    private static final String TAG_ExpectAckCode = "ExpectAckCode";
    private static final String TAG_ListenPorts = "ListenPorts";
    private static final String TAG_Include = "Include";
    private static final String TAG_Arg = "Arg";
    private static final String TAG_State = "State";
    private static final String ATTR_remoteLogging = "remoteLogging";
    public static final String ATTR_bindAddress = "bindAddress";
    private static final String ATTR_backlog = "backlog";
    private static final String ATTR_name = "name";
    private static final String ATTR_save = "save";
    private static final String ATTR_readOnly = "readOnly";
    private static final String ATTR_id = "id";
    private static final String ATTR_key = "key";
    private static final String ATTR_trim = "trim";
    public static final String ATTR_enabled = "enabled";
    private static final String ATTR_dispatchHost = "dispatchHost";
    private static final String ATTR_dispatchPort = "dispatchPort";
    private static final String ATTR_ssl = "ssl";
    private static final String ATTR_tcpPort = "tcpPort";
    private static final String ATTR_udpPort = "udpPort";
    private static final String ATTR_satPort = "satPort";
    private static final String ATTR_active = "active";
    private static final String ATTR_dir = "dir";
    private static final String ATTR_file = "file";
    private static final String ATTR_optional = "optional";
    private static final String ATTR_data = "data";
    private static final String ATTR_protocol = "protocol";
    private static final String ATTR_udpMaxAge = "udpMaxAge";
    private static final String ATTR_queue = "queue";
    private static final String ATTR_arg = "arg";
    private static final String ATTR_expectAck = "expectAck";
    private static final String ATTR_acl = "acl";
    private static final String ATTR_hasArgs = "hasArgs";
    private static final String ATTR_includeDir = "includeDir";
    private static final String ATTR_sessionVar = "sessionVar";
    private static final String ATTR_defaultValue = "defaultValue";
    private static final String ATTR_length = "length";
    private static final String ATTR_warnPortConflict = "warnPortConflict";
    private static final String ATTR_default = "default";
    public static final String ATTR_rtPropPrefix = "rtPropPrefix";
    public static final String ATTR_mask = "mask";
    public static final String ATTR_index = "index";
    private static RTProperties GlobalProperties = null;
    private static Map<Integer, DCServerConfig> TCPPortMap = null;
    private static Map<Integer, DCServerConfig> UDPPortMap = null;
    public static String BIND_ADDRESS = null;
    public static int LISTEN_BACKLOG = -1;
    public static int PORT_OFFSET = 0;
    public static String INCLUDE_DIR = null;
    public static String GTS_HOME = null;
    private static HashMap<String, DCServerConfig> dcServerMap;
    private static Vector<String> missingServerList;
    private static boolean _didInit;
    private static String lastNotFoundDCS;
    private static boolean ClassUnassignedDevices_init;
    private static Class ClassUnassignedDevices;
    public static final String[] ARG_udpPort;
    public static final String[] ARG_tcpPort;
    public static final String[] ARG_satPort;
    public static final String[] ARG_commandPort;
    public static final String CFG_TrackServer_class = ".TrackServer.class";
    public static final String CFG_CommandPacketHandler_class = ".CommandPacketHandler.class";
    public static final String CFG_ClientPacketHandler_class = ".ClientPacketHandler.class";
    public static final String CFG_uniquePrefix = ".uniquePrefix";
    public static final String CFG_uniqueIdPrefix = ".uniqueIdPrefix";
    public static final String CFG_tcpPort = ".tcpPort";
    public static final String CFG_udpPort = ".udpPort";
    public static final String CFG_satPort = ".satPort";
    public static final String CFG_port = ".port";
    public static final String CFG_commandPort = ".commandPort";
    public static final String CFG_commandProtocol = ".commandProtocol";
    public static final String CFG_ackResponsePort = ".ackResponsePort";
    public static final String CFG_clientCommandPort = ".clientCommandPort";
    public static final String CFG_clientCommandPort_udp = ".clientCommandPort.udp";
    public static final String CFG_clientCommandPort_tcp = ".clientCommandPort.tcp";
    public static final String CFG_tcpIdleTimeoutMS = ".tcpIdleTimeoutMS";
    public static final String CFG_tcpPacketTimeoutMS = ".tcpPacketTimeoutMS";
    public static final String CFG_tcpSessionTimeoutMS = ".tcpSessionTimeoutMS";
    public static final String CFG_udpIdleTimeoutMS = ".udpIdleTimeoutMS";
    public static final String CFG_udpPacketTimeoutMS = ".udpPacketTimeoutMS";
    public static final String CFG_udpSessionTimeoutMS = ".udpSessionTimeoutMS";
    public static final String CFG_minimumSpeedKPH = ".minimumSpeedKPH";
    public static final String CFG_estimateOdometer = ".estimateOdometer";
    public static final String CFG_ignoreDeviceOdometer = ".ignoreDeviceOdometer";
    public static final String CFG_maximumHDOP = ".maximumHDOP";
    public static final String CFG_checkLastOdometer = ".checkLastOdometer";
    public static final String CFG_simulateGeozones = ".simulateGeozones";
    public static final String CFG_geozoneSkipOldEvents = ".geozoneSkipOldEvents";
    public static final String CFG_simulateDigitalInputs = ".simulateDigitalInputs";
    public static final String CFG_minimumMovedMeters = ".minimumMovedMeters";
    public static final String CFG_saveRawDataPackets = ".saveRawDataPackets";
    public static final String CFG_startStopSupported = ".startStopSupported";
    public static final String CFG_statusLocationInMotion = ".statusLocationInMotion";
    public static final String CFG_ignoreInvalidGPSFlag = ".ignoreInvalidGPSFlag";
    public static final String CFG_ignoreEventsWithInvalidGPS = ".ignoreEventsWithInvalidGPS";
    public static final String CFG_useLastValidGPSLocation = ".useLastValidGPSLocation";
    public static final String CFG_useAltCurrentTimestamp = ".useAltCurrentTimestamp";
    public static final String CFG_initialPacket = ".initialPacket";
    public static final String CFG_finalPacket = ".finalPacket";
    public static final String CFG_saveSessionStatistics = ".saveSessionStatistics";
    public static final String CFG_batteryLevelRange = ".batteryLevelRange";
    public static final String CFG_startStopStatusCodes = ".startStopStatusCodes";
    public static final String CFG_debugMode = ".debugMode";
    public static final String CFG_showURL = ".showURL";
    public static final String CFG_commandAckBit_ = ".commandAckBit.";
    private static final String[] ARG_LIST;
    private static final String[] ARG_LOOKUP;
    private static final String[] ARG_SERVER;
    private static final String[] ARG_ACCOUNT;
    private static final String[] ARG_DEVICE;
    private static final String[] ARG_CMDTYPE;
    private static final String[] ARG_CMDNAME;
    private static final String[] ARG_ARG;
    private static final String[] ARG_RESULT_CODE;
    private static final String[] ARG_EVENT_CODE_MAP;

    public static boolean isCommandTypeAll(String type) {
        if (StringTools.isBlank((String)type)) {
            return true;
        }
        return type.equalsIgnoreCase(CMDTYPE_ALL);
    }

    public static String Garmin_getStopStatusDescription(Locale locale, int stopStatus) {
        I18N i18n = I18N.getI18N(DCServerFactory.class, (Locale)locale);
        switch (stopStatus) {
            case 100: {
                return i18n.getString("DCServerFactory.garminStopStatus.active", "Active");
            }
            case 101: {
                return i18n.getString("DCServerFactory.garminStopStatus.done", "Done");
            }
            case 102: {
                return i18n.getString("DCServerFactory.garminStopStatus.unreadInactive", "Unread Inactive");
            }
            case 103: {
                return i18n.getString("DCServerFactory.garminStopStatus.readInactive", "Read Inactive");
            }
            case 104: {
                return i18n.getString("DCServerFactory.garminStopStatus.deleted", "Deleted");
            }
        }
        return i18n.getString("DCServerFactory.garminStopStatus.unknown", "Unknown");
    }

    public static String GetSpecificDCServerName() {
        return LoadServerNameOnly;
    }

    public static boolean HasSpecificDCServerName() {
        return !StringTools.isBlank((String)LoadServerNameOnly);
    }

    public static void SetSpecificDCServerName(String name) {
        String n = StringTools.trim((String)name);
        LoadServerNameOnly = StringTools.isBlank((String)n) || n.equals("*") ? null : n;
    }

    public static void InitSpecificDCServerName() {
        if (DCServerFactory.HasSpecificDCServerName()) {
            return;
        }
        String dcsName = RTConfig.getString((String)PROP_DCServer_name, null);
        if (!StringTools.isBlank((String)dcsName)) {
            DCServerFactory.SetSpecificDCServerName(dcsName);
            return;
        }
        Object mainClass = RTConfig.getProperty((String)"%mainClass", null);
        if (mainClass instanceof Class) {
            try {
                MethodAction ma = new MethodAction((Object)((Class)mainClass), StaticMethod_LoadName);
                Object rtn = ma.invoke();
                if (rtn != null) {
                    if (rtn instanceof String[]) {
                        Object[] dcsn = (String[])rtn;
                        if (!ListTools.isEmpty((Object[])dcsn)) {
                            DCServerFactory.SetSpecificDCServerName((String)dcsn[0]);
                            return;
                        }
                    } else {
                        if (rtn instanceof String) {
                            DCServerFactory.SetSpecificDCServerName((String)rtn);
                            return;
                        }
                        Print.logInfo((String)("Unrecognized return type: " + StringTools.className((Object)rtn)), (Object[])new Object[0]);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean isValidPort(int[] port) {
        if (ListTools.isEmpty((int[])port)) {
            return false;
        }
        for (int i = 0; i < port.length; ++i) {
            if (DCServerFactory.isValidPort(port[i])) continue;
            return false;
        }
        return true;
    }

    public static File getServerJarFile(String name) {
        if (StringTools.isBlank((String)name)) {
            return null;
        }
        String gtsHome = !StringTools.isBlank((String)GTS_HOME) ? GTS_HOME : ".";
        String jarPath = gtsHome + File.separator + "build" + File.separator + "lib" + File.separator;
        File serverJar = new File(jarPath + name + ".jar");
        return serverJar.isFile() ? serverJar : null;
    }

    public static boolean serverJarExists(String name) {
        File serverJar = DCServerFactory.getServerJarFile(name);
        if (serverJar != null) {
            return true;
        }
        if (StringTools.isBlank((String)GTS_HOME)) {
            // empty if block
        }
        return false;
    }

    public static ResultCode GetResultCode(String code, ResultCode dft) {
        if (StringTools.isBlank((String)code)) {
            return dft;
        }
        return (ResultCode)EnumTools.getValueOf(ResultCode.class, (String)code, (Enum)dft);
    }

    private static File _getDCServerXMLFile() {
        File cfgFile = RTConfig.getLoadedConfigFile();
        if (cfgFile != null) {
            return new File(cfgFile.getParentFile(), DCSERVER_XML);
        }
        return null;
    }

    private static Document _getDocument(File xmlFile) {
        if (xmlFile == null) {
            Print.logError((String)("DCServer XML file not specified: " + xmlFile), (Object[])new Object[0]);
            return null;
        }
        if (!xmlFile.exists()) {
            Print.logError((String)("DCServer XML file does not exist: " + xmlFile), (Object[])new Object[0]);
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xmlFile);
        }
        catch (ParserConfigurationException pce) {
            Print.logException((String)"Parse error: ", (Throwable)pce);
        }
        catch (SAXException se) {
            Print.logException((String)"Parse error: ", (Throwable)se);
        }
        catch (IOException ioe) {
            Print.logException((String)"Parse error: ", (Throwable)ioe);
        }
        return doc;
    }

    public static void loadDCServerXML(File xmlFile) {
        GlobalProperties = new RTProperties();
        TCPPortMap = new OrderedMap();
        UDPPortMap = new OrderedMap();
        try {
            OrderedSet<DCServerConfig> dcsSet = DCServerFactory._loadDCServerXML(xmlFile, 0);
            if (!ListTools.isEmpty(dcsSet)) {
                for (DCServerConfig dcs : dcsSet) {
                    DCServerFactory.addDCS(dcs);
                }
            }
        }
        catch (Throwable t) {
            Print.logException((String)"Unable to load DCServerFactory XML", (Throwable)t);
        }
        if (GlobalProperties != null) {
            RTConfig.setProperties((RTProperties)GlobalProperties);
        }
        GlobalProperties = null;
        TCPPortMap = null;
        UDPPortMap = null;
    }

    private static OrderedSet<DCServerConfig> _loadDCServerXML(File xmlFile, int recurseLvl) {
        File parentDir;
        Document xmlDoc;
        if (xmlFile == null) {
            xmlFile = DCServerFactory._getDCServerXMLFile();
        }
        if (recurseLvl == 0) {
            LoadedDCServerXMLFile = xmlFile;
        }
        if (xmlFile == null || !xmlFile.isFile()) {
            String dcsFileName;
            File origFile = xmlFile;
            File cfgDir = RTConfig.getLoadedConfigDir();
            String dcsName = DCServerFactory.GetSpecificDCServerName();
            if (!StringTools.isBlank((String)dcsName) && cfgDir != null && (xmlFile = FileTools.findFile((File)cfgDir, (String[])new String[]{dcsFileName = "dcserver_" + dcsName + ".xml", "dcservers/" + dcsFileName})) == null) {
                Print.logWarn((String)("DCServerConfig XML file not found: " + dcsFileName), (Object[])new Object[0]);
            }
            if (xmlFile == null || !xmlFile.isFile()) {
                if (RTConfig.isWebApp() && !BasicPrivateLabel.isTrackServlet()) {
                    Print.logInfo((String)("DCServerConfig XML file not loaded: " + origFile), (Object[])new Object[0]);
                } else {
                    Print.logError((String)("DCServerConfig XML file does not exist: " + origFile), (Object[])new Object[0]);
                }
                return null;
            }
        }
        if ((xmlDoc = DCServerFactory._getDocument(xmlFile)) == null) {
            Print.logError((String)"Unable to create DCServerConfig XML 'Document' (syntax errors?)", (Object[])new Object[0]);
            return null;
        }
        Element dcsDef = xmlDoc.getDocumentElement();
        if (!dcsDef.getTagName().equalsIgnoreCase(TAG_DCServerConfig)) {
            Print.logError((String)("[" + xmlFile + "] Invalid root tag ID: " + dcsDef.getTagName()), (Object[])new Object[0]);
            return null;
        }
        if (recurseLvl == 0) {
            BIND_ADDRESS = XMLTools.getAttribute((Element)dcsDef, (String)ATTR_bindAddress, (String)BIND_ADDRESS, (boolean)true);
            BIND_ADDRESS = StringTools.blankDefault((String)RTConfig.getString((String)ATTR_bindAddress, null), (String)BIND_ADDRESS);
            LISTEN_BACKLOG = XMLTools.getAttributeInt((Element)dcsDef, (String)ATTR_backlog, (int)LISTEN_BACKLOG, (boolean)true);
            INCLUDE_DIR = XMLTools.getAttribute((Element)dcsDef, (String)ATTR_includeDir, (String)INCLUDE_DIR, (boolean)true);
        }
        if ((parentDir = xmlFile.getParentFile()) != null) {
            try {
                File dir;
                parentDir = dir = parentDir.getCanonicalFile();
            }
            catch (Throwable th) {
                // empty catch block
            }
        }
        OrderedSet dcserverSet = new OrderedSet(true);
        HashSet<String> dcserverNames = new HashSet<String>();
        NodeList dcsChildNodes = dcsDef.getChildNodes();
        for (int dcsn = 0; dcsn < dcsChildNodes.getLength(); ++dcsn) {
            Node dcsChildNode = dcsChildNodes.item(dcsn);
            if (!(dcsChildNode instanceof Element)) continue;
            String dcsNodeName = dcsChildNode.getNodeName();
            Element dcsChildElem = (Element)dcsChildNode;
            if (dcsNodeName.equalsIgnoreCase(TAG_DCServer)) {
                DCServerConfig s;
                Integer port;
                Element dcsTag = dcsChildElem;
                String dcsName = XMLTools.getAttribute((Element)dcsTag, (String)ATTR_name, null, (boolean)false);
                String dcsProto = XMLTools.getAttribute((Element)dcsTag, (String)ATTR_protocol, null, (boolean)false);
                String dcsRLog = XMLTools.getAttribute((Element)dcsTag, (String)ATTR_remoteLogging, null, (boolean)false);
                boolean setGlobalProperties = false;
                String specDCN = DCServerFactory.GetSpecificDCServerName();
                if (!StringTools.isBlank((String)specDCN)) {
                    if (!specDCN.equals(dcsName)) continue;
                    setGlobalProperties = true;
                }
                if (dcserverNames.contains(dcsName)) {
                    Print.logInfo((String)("Ignoring duplicate DCServer [" + recurseLvl + "]: " + dcsName), (Object[])new Object[0]);
                    continue;
                }
                dcserverNames.add(dcsName);
                boolean active = XMLTools.getAttributeBoolean((Element)dcsTag, (String)ATTR_active, (boolean)true, (boolean)false);
                if (!active) {
                    Print.logDebug((String)("Inactive DCServer [" + recurseLvl + "]: " + dcsName), (Object[])new Object[0]);
                    continue;
                }
                Print.logDebug((String)("Parsing DCServer [" + recurseLvl + "]: " + dcsName), (Object[])new Object[0]);
                DCServerConfig dcs = new DCServerConfig();
                dcs.setName(dcsName);
                dcs.setConfigFile(xmlFile);
                dcs.setCommandProtocol(dcsProto);
                dcs.setRemoteLogging(dcsRLog);
                boolean warnPortConflict = DEFAULT_WARN_PORT_CONFLICT;
                NodeList childNodes = dcsTag.getChildNodes();
                for (int c = 0; c < childNodes.getLength(); ++c) {
                    Node dcsNode = childNodes.item(c);
                    if (!(dcsNode instanceof Element)) continue;
                    String nodeName = dcsNode.getNodeName();
                    Element dcsElem = (Element)dcsNode;
                    if (nodeName.equalsIgnoreCase(TAG_Description)) {
                        String desc = XMLTools.getNodeText((Node)dcsElem, (String)" ", (boolean)false);
                        desc = RTConfig.getString((String)(PROP_DCServer_ + dcsName + ".description"), (String)desc);
                        dcs.setDescription(desc);
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_ModelNames)) {
                        String[] modelNames = StringTools.split((String)XMLTools.getNodeText((Node)dcsElem, (String)"\n", (boolean)false), (char)'\n');
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_Attributes)) {
                        RTProperties attr = new RTProperties(XMLTools.getNodeText((Node)dcsElem, (String)" ", (boolean)false));
                        long flagAttr = DCServerConfig.GetAttributeFlags(attr);
                        dcs.setAttributeFlags(flagAttr);
                        RTProperties rtProps = dcs.getDefaultProperties();
                        for (Object rtk : attr.getPropertyKeys()) {
                            Object rtv = attr.getProperty(rtk, null);
                            String attrKey = PROP_Attribute_ + rtk;
                            String[] dcsAttrKey = new String[]{PROP_DCServer_ + dcsName + "." + attrKey, PROP_dcs_ + dcsName + "." + attrKey};
                            if (RTConfig.hasProperty((String[])dcsAttrKey)) {
                                rtv = RTConfig.getProperty((String[])dcsAttrKey, (Object)rtv);
                            }
                            rtProps.setProperty((Object)attrKey, rtv);
                        }
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_UniqueIDPrefix)) {
                        String uidPfx = XMLTools.getNodeText((Node)dcsElem, (String)",", (boolean)false);
                        dcs.setUniquePrefix(StringTools.parseStringArray((String)uidPfx, (char)','));
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_ListenPorts)) {
                        warnPortConflict = XMLTools.getAttributeBoolean((Element)dcsElem, (String)ATTR_warnPortConflict, (boolean)DEFAULT_WARN_PORT_CONFLICT, (boolean)false);
                        InetAddress bindAddr = null;
                        String bindAddrName = XMLTools.getAttribute((Element)dcsElem, (String)ATTR_bindAddress, null, (boolean)false);
                        try {
                            if (!StringTools.isBlank((String)bindAddrName)) {
                                bindAddr = InetAddress.getByName(bindAddrName);
                            }
                        }
                        catch (Throwable th) {
                            Print.logException((String)("Unable to locate Bind Address: " + bindAddrName), (Throwable)th);
                            bindAddr = null;
                        }
                        dcs.setUseSSL(XMLTools.getAttributeBoolean((Element)dcsElem, (String)ATTR_ssl, (boolean)false));
                        dcs.setTcpPorts(bindAddr, DCServerFactory.parsePorts(XMLTools.getAttribute((Element)dcsElem, (String)ATTR_tcpPort, null, (boolean)false)), true);
                        dcs.setUdpPorts(bindAddr, DCServerFactory.parsePorts(XMLTools.getAttribute((Element)dcsElem, (String)ATTR_udpPort, null, (boolean)false)), true);
                        dcs.setSatPorts(bindAddr, DCServerFactory.parsePorts(XMLTools.getAttribute((Element)dcsElem, (String)ATTR_satPort, null, (boolean)false)), true);
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_GlobalProperties)) {
                        if (!setGlobalProperties || GlobalProperties == null) continue;
                        RTProperties rtProps = GlobalProperties;
                        NodeList propList = XMLTools.getChildElements((Node)dcsElem, (String)TAG_Property);
                        for (int p = 0; p < propList.getLength(); ++p) {
                            Node propNode = propList.item(p);
                            if (!(propNode instanceof Element)) continue;
                            Element propElem = (Element)propNode;
                            String key = XMLTools.getAttribute((Element)propElem, (String)ATTR_key, null, (boolean)false);
                            boolean valTrim = XMLTools.getAttributeBoolean((Element)propElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                            if (!StringTools.isBlank((String)key)) {
                                String val = StringTools.trim((String)XMLTools.getNodeText((Node)propElem, (String)(valTrim ? " " : null), (boolean)false));
                                rtProps.setProperty((Object)key, (Object)val);
                                continue;
                            }
                            Print.logWarn((String)"Undefined Property key ignored.", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_Properties)) {
                        String propID = XMLTools.getAttribute((Element)dcsElem, (String)ATTR_id, null, (boolean)false);
                        RTProperties rtProps = dcs.getProperties(propID, true);
                        NodeList propList = XMLTools.getChildElements((Node)dcsElem, (String)TAG_Property);
                        for (int p = 0; p < propList.getLength(); ++p) {
                            Node propNode = propList.item(p);
                            if (!(propNode instanceof Element)) continue;
                            Element propElem = (Element)propNode;
                            String key = XMLTools.getAttribute((Element)propElem, (String)ATTR_key, null, (boolean)false);
                            boolean valTrim = XMLTools.getAttributeBoolean((Element)propElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                            if (!StringTools.isBlank((String)key)) {
                                String dcsPropKey = null;
                                if (key.startsWith(dcsName + ".")) {
                                    dcsPropKey = key;
                                    key = key.substring((dcsName + ".").length());
                                } else {
                                    dcsPropKey = dcsName + "." + key;
                                }
                                String dcsPropVal = StringTools.trim((String)XMLTools.getNodeText((Node)propElem, (String)(valTrim ? " " : null), (boolean)false));
                                String[] rtPropKey = new String[]{PROP_DCServer_ + dcsName + "." + key, PROP_DCServer_ + dcsName + "." + PROP_Properties_ + key, PROP_dcs_ + dcsName + "." + key, PROP_dcs_ + dcsName + "." + PROP_Properties_ + key};
                                if (RTConfig.hasProperty((String[])rtPropKey)) {
                                    dcsPropVal = RTConfig.getString((String[])rtPropKey, (String)dcsPropVal);
                                }
                                rtProps.setProperty((Object)dcsPropKey, (Object)dcsPropVal);
                                continue;
                            }
                            Print.logWarn((String)"Undefined Property key ignored.", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_EventCodeMap)) {
                        boolean ecEnabled = XMLTools.getAttributeBoolean((Element)dcsElem, (String)ATTR_enabled, (boolean)true, (boolean)false);
                        HashMap<Object, DCServerConfig.EventCode> codeMap = new HashMap<Object, DCServerConfig.EventCode>();
                        NodeList codeList = XMLTools.getChildElements((Node)dcsElem, (String)TAG_Code);
                        for (int eci = 0; eci < codeList.getLength(); ++eci) {
                            Node codeNode = codeList.item(eci);
                            if (!(codeNode instanceof Element)) continue;
                            Element codeElem = (Element)codeNode;
                            String dataStr = XMLTools.getAttribute((Element)codeElem, (String)ATTR_data, null, (boolean)false);
                            String keyStr = StringTools.trim((String)XMLTools.getAttribute((Element)codeElem, (String)ATTR_key, (String)"", (boolean)false));
                            if (!StringTools.isBlank((String)keyStr)) {
                                int sci;
                                int keyInt = StringTools.isInt((String)keyStr, (boolean)true) ? StringTools.parseInt((String)keyStr, (int)-1) : -1;
                                Object keyObj = keyInt >= 0 ? new Integer(keyInt) : keyStr.toLowerCase();
                                String valStr = XMLTools.getNodeText((Node)codeElem, (String)" ", (boolean)false);
                                int sc = -1;
                                sc = StringTools.isBlank((String)valStr) || valStr.equalsIgnoreCase("ignore") ? -1 : (valStr.equalsIgnoreCase(ATTR_default) || valStr.equalsIgnoreCase(NONE_NAME) ? 0 : ((sci = StringTools.parseInt((String)valStr, (int)-1)) < 0 ? -1 : (sci == 0 ? 0 : sci)));
                                codeMap.put(keyObj, new DCServerConfig.EventCode(keyInt, sc, dataStr));
                                continue;
                            }
                            Print.logWarn((String)("Invalid Code key ignored: " + keyStr), (Object[])new Object[0]);
                        }
                        dcs.setEventCodeEnabled(ecEnabled);
                        dcs.setEventCodeMap(codeMap);
                        continue;
                    }
                    if (nodeName.equalsIgnoreCase(TAG_Commands)) {
                        String cmdHost = XMLTools.getAttribute((Element)dcsElem, (String)ATTR_dispatchHost, null, (boolean)false);
                        String cmdPortS = XMLTools.getAttribute((Element)dcsElem, (String)ATTR_dispatchPort, (String)"", (boolean)false);
                        int cmdPort = "sms".equalsIgnoreCase(cmdPortS) ? -1 : StringTools.parseInt((String)cmdPortS, (int)-1);
                        dcs.setCommandDispatcherHost(cmdHost);
                        dcs.setCommandDispatcherPort(cmdPort, true);
                        cmdPort = dcs.getCommandDispatcherPort();
                        NodeList commandsNodes = dcsElem.getChildNodes();
                        for (int cmi = 0; cmi < commandsNodes.getLength(); ++cmi) {
                            Node cmdNode = commandsNodes.item(cmi);
                            if (!(cmdNode instanceof Element)) continue;
                            Element cmdElem = (Element)cmdNode;
                            String cmdTagName = cmdNode.getNodeName();
                            if (cmdTagName.equalsIgnoreCase(TAG_AclName)) {
                                String aclName = XMLTools.getNodeText((Node)cmdElem, (String)"");
                                String aclDftStr = XMLTools.getAttribute((Element)cmdElem, (String)ATTR_default, null, (boolean)false);
                                AclEntry.AccessLevel aclDft = AclEntry.parseAccessLevel(aclDftStr, AclEntry.AccessLevel.WRITE);
                                dcs.setCommandsAclName(aclName, aclDft);
                                continue;
                            }
                            if (!cmdTagName.equalsIgnoreCase(TAG_Command)) continue;
                            String cmdName = XMLTools.getAttribute((Element)cmdElem, (String)ATTR_name, null, (boolean)false);
                            String cmdEnableS = XMLTools.getAttribute((Element)cmdElem, (String)ATTR_enabled, (String)"", (boolean)false).toLowerCase();
                            boolean cmdEnable = cmdEnableS.equals("") ? true : StringTools.parseBoolean((String)cmdEnableS, (boolean)false);
                            boolean cmdDiscard = !cmdEnable && !cmdEnableS.equals("hidden");
                            String enabledKey1 = PROP_Command_ + cmdName + "." + ATTR_enabled;
                            String enabledKey2 = PROP_command_ + cmdName + "." + ATTR_enabled;
                            String[] rtPropKey = new String[]{PROP_DCServer_ + dcsName + "." + enabledKey1, PROP_DCServer_ + dcsName + "." + enabledKey2, PROP_dcs_ + dcsName + "." + enabledKey1, PROP_dcs_ + dcsName + "." + enabledKey2};
                            if (BasicPrivateLabelLoader.SAVE_I18N_STRINGS) {
                                cmdEnable = true;
                                cmdDiscard = false;
                            } else if (RTConfig.hasProperty((String[])rtPropKey)) {
                                if (cmdEnable = RTConfig.getBoolean((String[])rtPropKey, (boolean)cmdEnable)) {
                                    cmdDiscard = false;
                                }
                            } else if (dcs.getDefaultProperties().hasProperty((Object)enabledKey1)) {
                                cmdEnable = dcs.getDefaultProperties().getBoolean(enabledKey1, cmdEnable);
                                if (cmdEnable) {
                                    cmdDiscard = false;
                                }
                            } else if (dcs.getDefaultProperties().hasProperty((Object)enabledKey2) && (cmdEnable = dcs.getDefaultProperties().getBoolean(enabledKey2, cmdEnable))) {
                                cmdDiscard = false;
                            }
                            if (cmdEnable || !cmdDiscard) {
                                boolean hasArgs = XMLTools.getAttributeBoolean((Element)cmdElem, (String)ATTR_hasArgs, (boolean)false, (boolean)false);
                                boolean expectAck = XMLTools.getAttributeBoolean((Element)cmdElem, (String)ATTR_expectAck, (boolean)false, (boolean)false);
                                String aclName = XMLTools.getAttribute((Element)cmdElem, (String)ATTR_acl, null, (boolean)false);
                                String[] cmdTypes = null;
                                String cmdDesc = null;
                                String cmdAclName = !StringTools.isBlank((String)aclName) ? aclName : AclEntry.CreateAclName(dcs.getCommandsAclName(), cmdName);
                                AclEntry.AccessLevel cmdAclDft = AclEntry.AccessLevel.WRITE;
                                String cmdString = "";
                                String cmdProto = "";
                                long maxUdpAge = -1L;
                                boolean allowQueue = false;
                                int cmdSCode = 0;
                                int expAckCode = 0;
                                long stateMask = 0L;
                                boolean stateVal = false;
                                Vector<DCServerConfig.CommandArg> cmdArgList = new Vector<DCServerConfig.CommandArg>();
                                NodeList cmdSubNodes = cmdElem.getChildNodes();
                                for (int s2 = 0; s2 < cmdSubNodes.getLength(); ++s2) {
                                    Node cmdSubNode = cmdSubNodes.item(s2);
                                    if (!(cmdSubNode instanceof Element)) continue;
                                    String cmdNodeName = cmdSubNode.getNodeName();
                                    Element cmdSubElem = (Element)cmdSubNode;
                                    if (cmdNodeName.equalsIgnoreCase(TAG_Type)) {
                                        String typ = XMLTools.getNodeText((Node)cmdSubElem, (String)",");
                                        cmdTypes = StringTools.parseStringArray((String)typ, (char)',');
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_Description)) {
                                        cmdDesc = XMLTools.getNodeText((Node)cmdSubElem, (String)" ");
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_AclName)) {
                                        cmdAclName = XMLTools.getNodeText((Node)cmdSubElem, (String)"");
                                        String aclDftStr = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_default, null, (boolean)false);
                                        cmdAclDft = AclEntry.parseAccessLevel(aclDftStr, AclEntry.AccessLevel.WRITE);
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_String)) {
                                        cmdProto = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_protocol, (String)"", (boolean)false);
                                        maxUdpAge = XMLTools.getAttributeInt((Element)cmdSubElem, (String)ATTR_udpMaxAge, (int)0, (boolean)false);
                                        allowQueue = XMLTools.getAttributeBoolean((Element)cmdSubElem, (String)ATTR_queue, (boolean)false, (boolean)false);
                                        cmdString = XMLTools.getNodeText((Node)cmdSubElem, (String)"");
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_StatusCode)) {
                                        String scStr = XMLTools.getNodeText((Node)cmdSubElem, (String)"");
                                        int sc = StringTools.parseInt((String)scStr, (int)-1);
                                        cmdSCode = sc > 0 ? sc : 0;
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_ExpectAckCode)) {
                                        String scStr = XMLTools.getNodeText((Node)cmdSubElem, (String)"");
                                        int sc = StringTools.parseInt((String)scStr, (int)-1);
                                        if (sc >= 0) {
                                            expAckCode = sc;
                                            expectAck = true;
                                            continue;
                                        }
                                        expAckCode = 0;
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_Arg)) {
                                        String argName = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_name, null, (boolean)false);
                                        String argVar = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_sessionVar, null, (boolean)false);
                                        String argDftVal = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_defaultValue, null, (boolean)false);
                                        boolean argROnly = XMLTools.getAttributeBoolean((Element)cmdSubElem, (String)ATTR_readOnly, (boolean)false, (boolean)false);
                                        String argDesc = StringTools.trim((String)XMLTools.getNodeText((Node)cmdSubElem, (String)" "));
                                        DCServerConfig.CommandArg cmdArg = new DCServerConfig.CommandArg(argName, argDesc, argROnly, argVar, argDftVal);
                                        String argLen = XMLTools.getAttribute((Element)cmdSubElem, (String)ATTR_length, null, (boolean)false);
                                        if (!StringTools.isBlank((String)argLen)) {
                                            int maxLen;
                                            int[] len = StringTools.parseInt((Object[])StringTools.split((String)argLen, (char)','), (int)0);
                                            int dispLen = len.length > 0 && len[0] > 0 ? len[0] : 70;
                                            int n = maxLen = len.length > 1 && len[1] > 0 ? len[1] : dispLen;
                                            if (maxLen < dispLen) {
                                                maxLen = dispLen;
                                            }
                                            cmdArg.setLength(dispLen, maxLen);
                                        }
                                        cmdArgList.add(cmdArg);
                                        hasArgs = true;
                                        continue;
                                    }
                                    if (cmdNodeName.equalsIgnoreCase(TAG_State)) {
                                        int bitNdx;
                                        stateMask = XMLTools.getAttributeLong((Element)cmdSubElem, (String)ATTR_mask, (long)0L, (boolean)false);
                                        if (stateMask == 0L && (bitNdx = XMLTools.getAttributeInt((Element)cmdSubElem, (String)ATTR_index, (int)-1, (boolean)false)) >= 0) {
                                            stateMask = bitNdx << 1;
                                        }
                                        stateVal = StringTools.parseBoolean((String)XMLTools.getNodeText((Node)cmdSubElem, (String)"", (boolean)false), (boolean)false);
                                        continue;
                                    }
                                    Print.logWarn((String)("Unrecognized Command sub-tag: " + cmdNodeName), (Object[])new Object[0]);
                                }
                                if (cmdPort > 0 || "sms".equalsIgnoreCase(cmdProto) || StringTools.startsWithIgnoreCase((String)cmdProto, (String)"sms:")) {
                                    dcs.addCommand(cmdName, cmdDesc, cmdEnable, cmdTypes, cmdAclName, cmdAclDft, cmdString, hasArgs, cmdArgList, cmdProto, maxUdpAge, allowQueue, expectAck, expAckCode, stateMask, stateVal, cmdSCode);
                                    Print.logDebug((String)("Added command [" + dcs.getName() + "]: " + cmdName + " (enabled=" + cmdEnable + ")"), (Object[])new Object[0]);
                                    continue;
                                }
                                Print.logWarn((String)("[" + dcs.getName() + "] Command ignored (not an SMS protocol command): " + cmdName), (Object[])new Object[0]);
                                continue;
                            }
                            Print.logDebug((String)("Command disabled [" + dcs.getName() + "]: " + cmdName), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    Print.logError((String)("[" + xmlFile + "] Unrecognized tag name: " + nodeName), (Object[])new Object[0]);
                }
                if (TCPPortMap != null) {
                    int[] tcpPorts = dcs.getTcpPorts();
                    if (!ListTools.isEmpty((int[])tcpPorts)) {
                        for (int p = 0; p < tcpPorts.length; ++p) {
                            port = new Integer(tcpPorts[p]);
                            if (TCPPortMap.containsKey(port)) {
                                s = TCPPortMap.get(port);
                                if (!warnPortConflict || s.getName().equals(dcs.getName())) continue;
                                Print.logWarn((String)("[" + xmlFile.getName() + ":" + dcs.getName() + "] TCP Port Conflict: " + port + " (see '" + s.getName() + "')"), (Object[])new Object[0]);
                                continue;
                            }
                            TCPPortMap.put(port, dcs);
                        }
                    }
                } else {
                    Print.logWarn((String)"TCPPortMap is null!", (Object[])new Object[0]);
                }
                if (UDPPortMap != null) {
                    int[] udpPorts = dcs.getUdpPorts();
                    if (!ListTools.isEmpty((int[])udpPorts)) {
                        for (int p = 0; p < udpPorts.length; ++p) {
                            port = new Integer(udpPorts[p]);
                            if (UDPPortMap.containsKey(port)) {
                                s = UDPPortMap.get(port);
                                if (!warnPortConflict || s.getName().equals(dcs.getName())) continue;
                                Print.logWarn((String)("[" + xmlFile.getName() + ":" + dcs.getName() + "] UDP Port Conflict: " + port + " (see '" + s.getName() + "')"), (Object[])new Object[0]);
                                continue;
                            }
                            UDPPortMap.put(port, dcs);
                        }
                    }
                } else {
                    Print.logWarn((String)"UDPPortMap is null!", (Object[])new Object[0]);
                }
                dcserverSet.add((Object)dcs);
                continue;
            }
            if (!dcsNodeName.equalsIgnoreCase(TAG_Include)) continue;
            Element inclTag = dcsChildElem;
            boolean optional = XMLTools.getAttributeBoolean((Element)inclTag, (String)ATTR_optional, (boolean)false, (boolean)false);
            String inclFileStr = inclTag.getAttribute(ATTR_file);
            if (StringTools.isBlank((String)inclFileStr)) {
                Print.logError((String)"Invalid 'Include' (blank file)", (Object[])new Object[0]);
                continue;
            }
            String inclDirStr = inclTag.getAttribute(ATTR_dir);
            File inclDir = null;
            if (!StringTools.isBlank((String)inclDirStr)) {
                inclDir = new File(inclDirStr);
            } else if (!StringTools.isBlank((String)INCLUDE_DIR)) {
                inclDir = new File(INCLUDE_DIR);
            }
            boolean isGlob = inclFileStr.indexOf("*") >= 0;
            Vector<File> inclFileList = new Vector<File>();
            if (inclDir != null && inclDir.isAbsolute()) {
                if (isGlob) {
                    Object[] files = FileTools.getFiles((File)inclDir, (String)inclFileStr, (boolean)false);
                    if (ListTools.size((Object[])files) > 0) {
                        ListTools.toList((Object[])files, inclFileList);
                    }
                } else {
                    File file = new File(inclDir, inclFileStr);
                    if (file.isFile()) {
                        inclFileList.add(file);
                    }
                }
            } else if (parentDir != null) {
                if (isGlob) {
                    File dir;
                    Object[] files;
                    if (inclDir != null && ListTools.size((Object[])(files = FileTools.getFiles((File)(dir = new File(parentDir, inclDir.toString())), (String)inclFileStr, (boolean)false))) > 0) {
                        ListTools.toList((Object[])files, inclFileList);
                    }
                    if (ListTools.size((Object[])(files = FileTools.getFiles((File)(dir = parentDir), (String)inclFileStr, (boolean)false))) > 0) {
                        ListTools.toList((Object[])files, inclFileList);
                    }
                } else {
                    File dir;
                    File file;
                    File inclFile = null;
                    if (inclFile == null && inclDir != null && (file = new File(dir = new File(parentDir, inclDir.toString()), inclFileStr)).isFile()) {
                        inclFileList.add(file);
                    }
                    if (inclFile == null && (file = new File(dir = parentDir, inclFileStr)).isFile()) {
                        inclFileList.add(file);
                    }
                    if (FileTools.isFile(inclFile)) {
                        inclFileList.add(inclFile);
                    }
                }
            }
            if (ListTools.size(inclFileList) > 0) {
                for (File inclFile : inclFileList) {
                    try {
                        if (inclFile.getCanonicalPath().equals(xmlFile.getCanonicalPath())) {
                            Print.logWarn((String)("Recursive Include ignored: " + inclFile.getCanonicalPath()), (Object[])new Object[0]);
                            continue;
                        }
                        OrderedSet<DCServerConfig> inclDscSet = DCServerFactory._loadDCServerXML(inclFile, recurseLvl + 1);
                        if (ListTools.isEmpty(inclDscSet)) continue;
                        for (DCServerConfig dcs : inclDscSet) {
                            if (dcserverSet.contains((Object)dcs)) continue;
                            dcserverSet.add((Object)dcs);
                        }
                    }
                    catch (Throwable th) {
                        Print.logException((String)("Error while including file: " + inclFile), (Throwable)th);
                    }
                }
                continue;
            }
            if (optional) continue;
            Print.logError((String)("Include file not found: " + inclFileStr), (Object[])new Object[0]);
        }
        return dcserverSet;
    }

    private static int[] parsePorts(String portStr) {
        if (!StringTools.isBlank((String)portStr)) {
            Object[] portArr = StringTools.split((String)portStr, (char)',');
            int[] portInt = StringTools.parseInt((Object[])portArr, (int)-1);
            if (!ListTools.isEmpty((int[])portInt)) {
                int i = 0;
                while (i < portInt.length) {
                    if (portInt[i] <= 0) {
                        Print.logError((String)("Invalid port specification: " + portStr), (Object[])new Object[0]);
                        return null;
                    }
                    int n = i++;
                    portInt[n] = portInt[n] + PORT_OFFSET;
                }
                return portInt;
            }
            Print.logError((String)("Invalid port specification: " + portStr), (Object[])new Object[0]);
            return null;
        }
        return null;
    }

    private static HashMap<String, DCServerConfig> _DCServerMap(boolean dispError) {
        if (dcServerMap == null) {
            if (dispError && (BasicPrivateLabel.isTrackServlet() || RTConfig.isCommandLine())) {
                if (DCServerFactory.HasSpecificDCServerName()) {
                    String dcsName = DCServerFactory.GetSpecificDCServerName();
                    Print.logStackTrace((String)("DCServerConfig not initialized! ['" + dcsName + "' not found?]"));
                } else {
                    Print.logStackTrace((String)"DCServerConfig not initialized!");
                }
            }
            dcServerMap = new HashMap();
        }
        return dcServerMap;
    }

    public static void init() {
        if (!_didInit) {
            DCServerFactory._startupInit();
            SMSOutboundGateway._startupInit();
        }
    }

    private static void _startupInit() {
        Print.logDebug((String)"DCServerFactory initializing ...", (Object[])new Object[0]);
        _didInit = true;
        if (!RTConfig.isInitialized()) {
            Print.logError((String)"**** DCServerFactory init: Runtime configuration has not been properly initialized ***", (Object[])new Object[0]);
        }
        if (StringTools.isBlank((String)(GTS_HOME = System.getenv("GTS_HOME")))) {
            Print.logWarn((String)"Environment variable 'GTS_HOME' not defined", (Object[])new Object[0]);
        }
        DCServerFactory.InitSpecificDCServerName();
        if (DCServerFactory.HasSpecificDCServerName()) {
            Print.logDebug((String)("Loading only DCServer name: " + DCServerFactory.GetSpecificDCServerName()), (Object[])new Object[0]);
        }
        DCServerFactory.loadDCServerXML(null);
        if (StringTools.isBlank((String)BIND_ADDRESS)) {
            ServerSocketThread.setBindAddress(null);
        } else {
            try {
                InetAddress localBA = InetAddress.getByName(BIND_ADDRESS);
                Print.logDebug((String)("ServerSocketThread Local Bind Address: " + localBA), (Object[])new Object[0]);
                ServerSocketThread.setBindAddress((InetAddress)localBA);
            }
            catch (UnknownHostException uhe) {
                Print.logError((String)("Local Bind Address Unknown Host: " + BIND_ADDRESS), (Object[])new Object[0]);
                ServerSocketThread.setBindAddress(null);
            }
        }
        if (LISTEN_BACKLOG > 0) {
            Print.logDebug((String)("ServerSocketThread Listen Backlog: " + LISTEN_BACKLOG), (Object[])new Object[0]);
            ServerSocketThread.setListenBacklog((int)LISTEN_BACKLOG);
        }
    }

    public static DCServerConfig addDCS(String name, String desc, int[] tcpPorts, int[] udpPorts, int commandPort, long flags, String ... uniqPfx) {
        if (StringTools.isBlank((String)name)) {
            return null;
        }
        if (DCServerFactory._DCServerMap(false).containsKey(name)) {
            Print.logDebug((String)("Ignoring duplicate DCServer: " + name), (Object[])new Object[0]);
            return null;
        }
        if (!DCServerFactory.serverJarExists(name)) {
            Set serverKeys = RTConfig.getPropertyKeys((String)(name + "."), (boolean)false);
            if (!ListTools.isEmpty((Collection)serverKeys)) {
                if (missingServerList == null) {
                    missingServerList = new Vector();
                }
                missingServerList.add(name);
            }
            Print.logDebug((String)"Server jar not found: %s", (Object[])new Object[]{name});
            if (!RTConfig.isWebApp()) {
                return null;
            }
        }
        DCServerConfig dcs = new DCServerConfig(name, desc, tcpPorts, udpPorts, commandPort, flags, uniqPfx);
        return DCServerFactory.addDCS(dcs);
    }

    private static DCServerConfig addDCS(DCServerConfig dcs) {
        if (dcs == null) {
            return null;
        }
        String name = dcs.getName();
        if (StringTools.isBlank((String)name)) {
            return null;
        }
        if (DCServerFactory._DCServerMap(false).containsKey(name)) {
            Print.logDebug((String)("Ignoring duplicate DCServer: " + name), (Object[])new Object[0]);
            return null;
        }
        DCServerFactory._DCServerMap(false).put(name, dcs);
        return dcs;
    }

    public static DCServerConfig _getServerConfig(String name) {
        return DCServerFactory._DCServerMap(true).get(name);
    }

    public static DCServerConfig getServerConfig(String name) {
        return DCServerFactory.getServerConfig(name, false);
    }

    public static DCServerConfig getServerConfig(String name, boolean warn) {
        if (StringTools.isBlank((String)name)) {
            if (warn) {
                Print.logError((String)"DCServerConfig name is blank", (Object[])new Object[0]);
            }
            return null;
        }
        DCServerConfig dcs = DCServerFactory._getServerConfig(name);
        if (dcs == null) {
            if (warn) {
                StringBuffer m = new StringBuffer();
                m.append("DCServerConfig not found: ").append(name);
                if (LoadedDCServerXMLFile != null) {
                    m.append(" [Not defined in ");
                    m.append(LoadedDCServerXMLFile);
                    m.append("?]");
                }
                Print.logWarn((String)m.toString(), (Object[])new Object[0]);
            }
            return null;
        }
        return dcs;
    }

    public static String getServerConfigDescription(String serverName) {
        if (!StringTools.isBlank((String)serverName)) {
            DCServerConfig dcs = DCServerFactory.getServerConfig(serverName);
            if (dcs != null) {
                return dcs.getDescription();
            }
            if (lastNotFoundDCS == null || !lastNotFoundDCS.equals(serverName)) {
                Print.logWarn((String)("DCS not found: " + serverName), (Object[])new Object[0]);
                lastNotFoundDCS = serverName;
            }
            return "(" + serverName + ")";
        }
        return "";
    }

    public static boolean hasServerConfig(String name) {
        if (StringTools.isBlank((String)name)) {
            return false;
        }
        return DCServerFactory._DCServerMap(false).containsKey(name);
    }

    public static List<DCServerConfig> getServerConfigList(boolean inclAll) {
        Vector<DCServerConfig> list = new Vector<DCServerConfig>();
        for (DCServerConfig dcs : DCServerFactory._DCServerMap(true).values()) {
            String n = dcs.getName();
            if (!inclAll && !DCServerFactory.serverJarExists(n)) continue;
            list.add(dcs);
        }
        return list;
    }

    public static boolean hasUndefinedServers() {
        return !ListTools.isEmpty(missingServerList);
    }

    public static List<String> getUndefinedServerList() {
        return missingServerList;
    }

    public static boolean supportsCommandDispatcher(String serverName) {
        return DCServerFactory.getCommandDispatcherPort(serverName) > 0;
    }

    public static boolean supportsCommandDispatcher(Device device) {
        if (device == null) {
            return false;
        }
        return DCServerFactory.supportsCommandDispatcher(device.getDeviceCode());
    }

    public static boolean hasDigitalInputs(String serverName) {
        DCServerConfig dcs = DCServerFactory.getServerConfig(serverName);
        return dcs != null ? dcs.hasDigitalInputs() : false;
    }

    public static boolean hasDigitalOutputs(String serverName) {
        DCServerConfig dcs = DCServerFactory.getServerConfig(serverName);
        return dcs != null ? dcs.hasDigitalOutputs() : false;
    }

    public static int getPort(int port) {
        return port > 0 ? port + PORT_OFFSET : 0;
    }

    public static int[] getPorts(int ... ports) {
        if (!ListTools.isEmpty((int[])ports)) {
            int[] newPorts = new int[ports.length];
            for (int i = 0; i < ports.length; ++i) {
                newPorts[i] = DCServerFactory.getPort(ports[i]);
            }
            return newPorts;
        }
        return new int[0];
    }

    private static int GP(int port) {
        return DCServerFactory.getPort(port);
    }

    private static int[] GP(int ... ports) {
        return DCServerFactory.getPorts(ports);
    }

    public static String getCommandResultID(RTProperties r) {
        return r != null ? r.getString(RESPONSE_RESULT, "") : null;
    }

    public static ResultCode getCommandResultCode(RTProperties r) {
        if (r == null) {
            return ResultCode.UNKNOWN;
        }
        String rid = DCServerFactory.getCommandResultID(r);
        if (StringTools.isBlank((String)rid)) {
            return ResultCode.SUCCESS;
        }
        ResultCode rc = DCServerFactory.GetResultCode(rid, null);
        if (rc == null) {
            return ResultCode.UNKNOWN;
        }
        return rc;
    }

    public static boolean isCommandResultOK(RTProperties r) {
        if (r != null) {
            String rid = DCServerFactory.getCommandResultID(r);
            if (StringTools.isBlank((String)rid)) {
                return true;
            }
            ResultCode rsID = DCServerFactory.GetResultCode(rid, null);
            return rsID != null ? rsID.isSuccess() : false;
        }
        return false;
    }

    public static boolean isCommandResultOK(ResultCode rid) {
        if (rid != null) {
            return rid.isSuccess();
        }
        return false;
    }

    public static String getCommandResultMessage(RTProperties r) {
        return r != null ? r.getString(RESPONSE_MESSAGE, "") : null;
    }

    public static void __setRunningDCS(String name) {
        if (!DCServerFactory.__isRunningDCS()) {
            String n = name != null ? ": " + name : "";
            RTConfig.getRuntimeConstantProperties().setBoolean("%DCServer.isRunningInDCS", true);
        }
    }

    public static boolean __isRunningDCS() {
        return RTConfig.getRuntimeConstantProperties().getBoolean("%DCServer.isRunningInDCS", false);
    }

    private static ResultCode _SendSMSCommand(String handlerName, Device device, String commandStr) {
        if (device == null) {
            return ResultCode.INVALID_DEVICE;
        }
        Account account = device.getAccount();
        if (account == null || !account.getSmsEnabled()) {
            return ResultCode.NOT_AUTHORIZED;
        }
        String smsHandler = StringTools.blankDefault((String)handlerName, (String)SMSOutboundGateway.GetDefaultGatewayName());
        SMSOutboundGateway smsgw = SMSOutboundGateway.GetSMSGateway(smsHandler);
        if (smsgw == null) {
            Print.logError((String)("SMS gateway handler not found: " + smsHandler), (Object[])new Object[0]);
            return ResultCode.INVALID_PROTO;
        }
        Print.logDebug((String)("CommandString: [" + device.getAccountID() + "/" + device.getDeviceID() + "] " + commandStr), (Object[])new Object[0]);
        ResultCode result = smsgw.sendSMSCommand(device, commandStr);
        return result != null ? result : ResultCode.INVALID_COMMAND;
    }

    public static ResultCode SendSMSCommand(String handlerName, Device device, String commandStr) {
        String dcsCtx;
        boolean isDCS = DCServerFactory.__isRunningDCS();
        String string = dcsCtx = isDCS ? "(DCS Context) " : "(UI Context) ";
        if (device == null) {
            return ResultCode.INVALID_DEVICE;
        }
        if (device.exceedsMaxPingCount()) {
            Print.logWarn((String)(dcsCtx + "Account/Device exceeded maximum allowed pings."), (Object[])new Object[0]);
            return ResultCode.OVER_LIMIT;
        }
        Account account = device.getAccount();
        if (account == null || !account.getSmsEnabled()) {
            return ResultCode.NOT_AUTHORIZED;
        }
        ResultCode resp = DCServerFactory._SendSMSCommand(handlerName, device, commandStr);
        if (DCServerFactory.__isRunningDCS()) {
            Print.logInfo((String)(dcsCtx + "SMS Response: " + (Object)((Object)resp)), (Object[])new Object[0]);
        } else if (device != null && DCServerFactory.isCommandResultOK(resp)) {
            Print.logInfo((String)(dcsCtx + "Incrementing Device PingCount (SMS) ..."), (Object[])new Object[0]);
            device.incrementPingCount(DateTime.getCurrentTimeSec(), true, true);
            String acctID = device.getAccountID();
            String userID = RTConfig.getString((String)"session.user", (String)"");
            String devID = device.getDeviceID();
            String ipAddr = RTConfig.getString((String)"session.ipAddress", (String)"");
            String cmdStr = "Command: " + commandStr;
            Audit.deviceCommand(acctID, userID, devID, ipAddr, cmdStr);
        } else {
            Print.logInfo((String)(dcsCtx + "SMS Response: " + (Object)((Object)resp)), (Object[])new Object[0]);
        }
        return resp;
    }

    public static int getCommandDispatcherPort(String serverName) {
        DCServerConfig dcs = DCServerFactory.getServerConfig(serverName);
        return dcs != null ? dcs.getCommandDispatcherPort() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RTProperties _sendServerCommand(String serverName, Device device, String cmdType, String cmdName, String[] cmdArgs) {
        if (device == null && !cmdType.equalsIgnoreCase("internal")) {
            Print.logError((String)"Device is null", (Object[])new Object[0]);
            return null;
        }
        String accountID = device != null ? device.getAccountID() : "";
        String deviceID = device != null ? device.getDeviceID() : "";
        String uniqueID = device != null ? device.getUniqueID() : "";
        DCServerConfig dcs = DCServerFactory.getServerConfig(serverName);
        if (dcs == null) {
            Print.logError((String)"DCServerConfig not found: %s", (Object[])new Object[]{serverName});
            return null;
        }
        RTProperties rtCmd = DCServerFactory.createRTProperties(accountID, deviceID, uniqueID, cmdType, cmdName, cmdArgs);
        String cmdStr = rtCmd.toString();
        byte[] cmdData = (cmdStr + "\n").getBytes();
        String cmdHost = dcs.getCommandDispatcherHost(device);
        int cmdPort = dcs.getCommandDispatcherPort();
        if (cmdPort <= 0) {
            DCServerConfig.Command command = dcs.getCommand(cmdName);
            if (command == null) {
                Print.logError((String)"[%s] Command not supported: %s", (Object[])new Object[]{serverName, cmdName});
                return null;
            }
            if (!command.isCommandProtocolSMS()) {
                Print.logError((String)"[%s] Command port not supported", (Object[])new Object[]{serverName});
                return null;
            }
            String commandStr = command.getCommandString(device, cmdArgs);
            String protoHndlr = command.getCommandProtocolHandler();
            ResultCode result = DCServerFactory._SendSMSCommand(protoHndlr, device, commandStr);
            CommandPacketHandler.setResult(rtCmd, result);
            return rtCmd;
        }
        Print.logInfo((String)"[%s] Sending command to '%s:%d' ==> %s", (Object[])new Object[]{serverName, cmdHost, cmdPort, cmdStr});
        RTProperties response = null;
        ClientSocketThread cst = new ClientSocketThread(cmdHost, cmdPort);
        try {
            cst.openSocket();
            cst.socketWriteBytes(cmdData);
            String resp = cst.socketReadLine();
            Print.logInfo((String)"[%s] Command Response: %s", (Object[])new Object[]{serverName, resp});
            response = new RTProperties(resp);
        }
        catch (ConnectException ce) {
            Print.logError((String)("[" + serverName + "] Unable to connect to server: " + ce.getMessage()), (Object[])new Object[0]);
        }
        catch (Throwable t) {
            Print.logException((String)("[" + serverName + "] Server Command Error"), (Throwable)t);
        }
        finally {
            cst.closeSocket();
        }
        return response;
    }

    public static RTProperties sendServerCommand(Device device, String cmdType, String cmdName, String[] cmdArgs) {
        String dcsCtx;
        boolean isDCS = DCServerFactory.__isRunningDCS();
        String string = dcsCtx = isDCS ? "(DCS Context) " : "(UI Context) ";
        if (device == null) {
            Print.logWarn((String)(dcsCtx + "Device is null"), (Object[])new Object[0]);
            return null;
        }
        String acctID = device.getAccountID();
        String devID = device.getDeviceID();
        String unqID = device.getUniqueID();
        String server = device.getDeviceCode();
        if (StringTools.isBlank((String)server)) {
            Print.logWarn((String)(dcsCtx + "DeviceCode is null/blank"), (Object[])new Object[0]);
            ResultCode result = ResultCode.INVALID_SERVER;
            RTProperties resp = DCServerFactory.createRTProperties(acctID, devID, unqID, cmdType, cmdName, cmdArgs);
            resp.setString(RESPONSE_RESULT, result.getCode());
            resp.setString(RESPONSE_MESSAGE, result.toString());
            return resp;
        }
        if (device.exceedsMaxPingCount()) {
            Print.logWarn((String)(dcsCtx + "Account/Device exceeded maximum allowed pings."), (Object[])new Object[0]);
            ResultCode result = ResultCode.OVER_LIMIT;
            RTProperties resp = DCServerFactory.createRTProperties(acctID, devID, unqID, cmdType, cmdName, cmdArgs);
            resp.setString(RESPONSE_RESULT, result.getCode());
            resp.setString(RESPONSE_MESSAGE, result.toString());
            return resp;
        }
        RTProperties resp = DCServerFactory._sendServerCommand(server, device, cmdType, cmdName, cmdArgs);
        if (device != null && DCServerFactory.isCommandResultOK(resp)) {
            Print.logInfo((String)(dcsCtx + "Incrementing Device PingCount ..."), (Object[])new Object[0]);
            device.incrementPingCount(DateTime.getCurrentTimeSec(), true, true);
            String userID = RTConfig.getString((String)"session.user", (String)"");
            String ipAddr = RTConfig.getString((String)"session.ipAddress", (String)"");
            String cmdStr = "Command: " + cmdName;
            if (!ListTools.isEmpty((Object[])cmdArgs)) {
                cmdStr = cmdStr + "(" + StringTools.join((String[])cmdArgs, (String)",") + ")";
            }
            Audit.deviceCommand(acctID, userID, devID, ipAddr, cmdStr);
        } else {
            Print.logInfo((String)(dcsCtx + "Response: " + resp), (Object[])new Object[0]);
        }
        return resp;
    }

    public static RTProperties createRTProperties(String accountID, String deviceID, String uniqueID, String cmdType, String cmdName, String[] cmdArgs) {
        RTProperties rtCmd = new RTProperties();
        rtCmd.setString(CMDARG_ACCOUNT, accountID);
        rtCmd.setString(CMDARG_DEVICE, deviceID);
        rtCmd.setString(CMDARG_UNIQUE, uniqueID);
        rtCmd.setString(CMDARG_CMDTYPE, cmdType);
        rtCmd.setString(CMDARG_CMDNAME, cmdName);
        if (!ListTools.isEmpty((Object[])cmdArgs)) {
            for (int i = 0; i < cmdArgs.length && cmdArgs[i] != null; ++i) {
                String argKey = "arg" + i;
                String argVal = cmdArgs[i];
                rtCmd.setString(argKey, argVal);
            }
        }
        return rtCmd;
    }

    public static String createTcpSessionID(Device device) {
        if (device == null) {
            return null;
        }
        String tsi = device.getAccountID() + "/" + device.getDeviceID();
        device.setLastTcpSessionID(tsi);
        return tsi;
    }

    public static String getTcpSessionID(Device device) {
        if (device == null) {
            return null;
        }
        if (device.hasLastTcpSessionID()) {
            return device.getLastTcpSessionID();
        }
        return DCServerFactory.createTcpSessionID(device);
    }

    public static double calculateOdometerKM(EventData prevEvent, GeoPoint toPoint) {
        if (prevEvent != null && prevEvent.isValidGeoPoint() && GeoPoint.isValid((GeoPoint)toPoint)) {
            double deltaKM = toPoint.kilometersToPoint(prevEvent.getGeoPoint());
            return prevEvent.getOdometerKM() + deltaKM;
        }
        return 0.0;
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, String ipAddr, boolean isDuplex, double lat, double lon, String data) {
        if (!ClassUnassignedDevices_init) {
            ClassUnassignedDevices_init = true;
            try {
                ClassUnassignedDevices = Class.forName("org.opengts.extra.tables.UnassignedDevices");
            }
            catch (Throwable th) {
                return false;
            }
        }
        if (ClassUnassignedDevices == null) {
            return false;
        }
        try {
            MethodAction unasDev = new MethodAction((Object)ClassUnassignedDevices, "add", new Class[]{String.class, String.class, String.class, Boolean.TYPE, Double.TYPE, Double.TYPE, String.class});
            unasDev.invoke(new Object[]{dcName, mobID, ipAddr, isDuplex, lat, lon, data});
            return true;
        }
        catch (Throwable th) {
            Print.logException((String)"Adding UnassignedDevices", (Throwable)th);
            return false;
        }
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, GeoPoint geoPoint) {
        return DCServerFactory.addUnassignedDevice(dcName, mobID, null, true, geoPoint, null);
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, String ipAddr, boolean isDuplex, GeoPoint geoPoint) {
        return DCServerFactory.addUnassignedDevice(dcName, mobID, null, true, geoPoint, null);
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, String ipAddr, boolean isDuplex, GeoPoint geoPoint, String data) {
        double lat = geoPoint != null ? geoPoint.getLatitude() : 0.0;
        double lon = geoPoint != null ? geoPoint.getLongitude() : 0.0;
        return DCServerFactory.addUnassignedDevice(dcName, mobID, null, true, lat, lon, data);
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, double lat, double lon) {
        return DCServerFactory.addUnassignedDevice(dcName, mobID, null, true, lat, lon, null);
    }

    public static boolean addUnassignedDevice(String dcName, String mobID, String ipAddr, boolean isDuplex, double lat, double lon) {
        return DCServerFactory.addUnassignedDevice(dcName, mobID, ipAddr, isDuplex, lat, lon, null);
    }

    public static EventData getPreviousEventData(Device device, long fixtime) {
        if (device != null) {
            try {
                long startTime = -1L;
                long endTime = fixtime - 1L;
                EventData[] ed = EventData.getRangeEvents(device.getAccountID(), device.getDeviceID(), startTime, endTime, null, true, EventData.LimitType.LAST, 1L, true, null);
                if (ed != null && ed.length > 0) {
                    return ed[0];
                }
                return null;
            }
            catch (DBException dbe) {
                return null;
            }
        }
        return null;
    }

    public static void checkMemoryUsage() {
        OSTools.checkMemoryUsage((boolean)false);
    }

    public static Device loadDeviceByAccountDeviceID(String accountID, String deviceID) {
        try {
            Account account = Account.getAccount(accountID);
            if (account == null) {
                Print.logWarn((String)("!!!AccountID not found!: " + accountID), (Object[])new Object[0]);
                return null;
            }
            if (!account.isActive()) {
                Print.logWarn((String)("Account is inactive: " + accountID), (Object[])new Object[0]);
                return null;
            }
            Device device = Device.getDevice(account, deviceID);
            if (device == null) {
                Print.logWarn((String)("!!!DeviceID not found!: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                return null;
            }
            if (!device.isActive()) {
                Print.logWarn((String)("Device is inactive: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                return null;
            }
            return device;
        }
        catch (Throwable dbe) {
            Print.logError((String)("Exception getting Device: " + accountID + "/" + deviceID + " [" + dbe + "]"), (Object[])new Object[0]);
            return null;
        }
    }

    public static Device _loadDeviceByPrefixedModemID(String[] prefix, String modemID) {
        return DCServerFactory._loadDeviceByPrefixedModemID(prefix, modemID, false, null, null, true, null);
    }

    public static Device _loadDeviceByPrefixedModemID(String[] prefix, String modemID, String serverID, String ipAddress, boolean isDuplex, GeoPoint geoPoint) {
        return DCServerFactory._loadDeviceByPrefixedModemID(prefix, modemID, true, serverID, ipAddress, isDuplex, geoPoint);
    }

    public static Device _loadDeviceByPrefixedModemID(String[] prefix, String modemID, boolean saveUnassigned, String serverID, String ipAddress, boolean isDuplex, GeoPoint geoPoint) {
        Device device = null;
        if (StringTools.isBlank((String)modemID)) {
            Print.logWarn((String)"!!!Specified MobileID is blank/null", (Object[])new Object[0]);
            return null;
        }
        String uniqueID = "";
        try {
            if (ListTools.isEmpty((Object[])prefix)) {
                uniqueID = modemID;
                device = Transport.loadDeviceByUniqueID(uniqueID);
            } else {
                uniqueID = prefix[0] + modemID;
                for (int u = 0; u < prefix.length; ++u) {
                    String pfxid = prefix[u] + modemID;
                    device = Transport.loadDeviceByUniqueID(pfxid);
                    if (device == null) continue;
                    uniqueID = pfxid;
                    break;
                }
            }
            if (device == null) {
                Print.logWarn((String)("!!!UniqueID not found!: " + uniqueID + " [" + StringTools.join((String[])prefix, (String)",") + "]"), (Object[])new Object[0]);
                if (saveUnassigned) {
                    DCServerFactory.addUnassignedDevice(serverID, modemID, ipAddress, isDuplex, geoPoint, null);
                }
                return null;
            }
            if (!device.getAccount().isActive() || !device.isActive()) {
                String a = device.getAccountID();
                String d = device.getDeviceID();
                Print.logWarn((String)("Account/Device is inactive: " + a + "/" + d + " [" + uniqueID + "]"), (Object[])new Object[0]);
                return null;
            }
            device.setModemID(modemID);
            return device;
        }
        catch (Throwable dbe) {
            Print.logError((String)("Exception getting Device: " + uniqueID + " [" + dbe + "]"), (Object[])new Object[0]);
            return null;
        }
    }

    private static void _lookupUniqueID(List<Device> devList, DCServerConfig dcs, String uniqueID, Set<String> uidTried) {
        String[] uidPfx;
        String[] stringArray;
        if (dcs != null) {
            stringArray = dcs.getUniquePrefix();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        for (String pfx : uidPfx = stringArray) {
            String uid = pfx + uniqueID;
            if (uidTried != null && uidTried.contains(uid)) continue;
            try {
                uidTried.add(uid);
                Device device = Transport.loadDeviceByUniqueID(uid);
                if (device == null) continue;
                devList.add(device);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error retrieving Device by UniqueID", (Throwable)dbe);
            }
        }
    }

    public static Device[] lookupUniqueID(String mobileID) {
        if (StringTools.isBlank((String)mobileID)) {
            return new Device[0];
        }
        Vector<Device> devList = new Vector<Device>();
        HashSet<String> uidTried = new HashSet<String>();
        DCServerFactory._lookupUniqueID(devList, null, mobileID, uidTried);
        HashMap<String, DCServerConfig> dcsMap = DCServerFactory._DCServerMap(false);
        for (String dcsName : dcsMap.keySet()) {
            DCServerFactory._lookupUniqueID(devList, dcsMap.get(dcsName), mobileID, uidTried);
        }
        return devList.toArray(new Device[devList.size()]);
    }

    public static String getUniquePrefixString(String[] pfx) {
        if (ListTools.isEmpty((Object[])pfx)) {
            return "<blank>";
        }
        StringBuffer sb = new StringBuffer();
        String[] list = new String[pfx.length];
        for (int i = 0; i < pfx.length; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (StringTools.isBlank((String)pfx[i]) || pfx[i].equals("*")) {
                sb.append("<blank>");
                continue;
            }
            sb.append("\"").append(pfx[i]).append("\"");
        }
        return sb.toString();
    }

    public static String[] CONFIG_TrackServerAdapterClass(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_TrackServer_class, name + CFG_TrackServer_class};
    }

    public static String[] CONFIG_CommandPacketHandlerClass(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_CommandPacketHandler_class, name + CFG_CommandPacketHandler_class};
    }

    public static String[] CONFIG_ClientPacketHandlerClass(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_ClientPacketHandler_class, name + CFG_ClientPacketHandler_class};
    }

    public static String[] CONFIG_tcpPort(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_tcpPort, PROP_DCServer_ + name + CFG_port, name + CFG_tcpPort, name + CFG_port};
    }

    public static String[] CONFIG_udpPort(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_udpPort, PROP_DCServer_ + name + CFG_port, name + CFG_udpPort, name + CFG_port};
    }

    public static String[] CONFIG_satPort(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_satPort, name + CFG_satPort};
    }

    public static String[] CONFIG_commandPort(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_commandPort, name + CFG_commandPort};
    }

    public static String[] CONFIG_commandProtocol(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_commandProtocol, name + CFG_commandProtocol};
    }

    public static String[] CONFIG_clientCommandPort_udp(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_clientCommandPort_udp, PROP_DCServer_ + name + CFG_clientCommandPort, name + CFG_clientCommandPort_udp, name + CFG_clientCommandPort};
    }

    public static String[] CONFIG_clientCommandPort_tcp(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_clientCommandPort_tcp, PROP_DCServer_ + name + CFG_clientCommandPort, name + CFG_clientCommandPort_tcp, name + CFG_clientCommandPort};
    }

    public static String[] CONFIG_ackResponsePort(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_ackResponsePort, name + CFG_ackResponsePort};
    }

    public static String[] CONFIG_tcpIdleTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_tcpIdleTimeoutMS, name + CFG_tcpIdleTimeoutMS};
    }

    public static String[] CONFIG_tcpPacketTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_tcpPacketTimeoutMS, name + CFG_tcpPacketTimeoutMS};
    }

    public static String[] CONFIG_tcpSessionTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_tcpSessionTimeoutMS, name + CFG_tcpSessionTimeoutMS};
    }

    public static String[] CONFIG_udpIdleTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_udpIdleTimeoutMS};
    }

    public static String[] CONFIG_udpPacketTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_udpPacketTimeoutMS};
    }

    public static String[] CONFIG_udpSessionTimeoutMS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_udpSessionTimeoutMS};
    }

    public static String[] CONFIG_uniquePrefix(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_uniquePrefix, PROP_DCServer_ + name + CFG_uniqueIdPrefix, name + CFG_uniquePrefix, name + CFG_uniqueIdPrefix};
    }

    public static String[] CONFIG_minimumMovedMeters(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_minimumMovedMeters, name + CFG_minimumMovedMeters};
    }

    public static String[] CONFIG_minimumSpeedKPH(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_minimumSpeedKPH, name + CFG_minimumSpeedKPH};
    }

    public static String[] CONFIG_estimateOdometer(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_estimateOdometer, name + CFG_estimateOdometer};
    }

    public static String[] CONFIG_ignoreDeviceOdometer(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_ignoreDeviceOdometer, name + CFG_ignoreDeviceOdometer};
    }

    public static String[] CONFIG_simulateGeozones(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_simulateGeozones, name + CFG_simulateGeozones};
    }

    public static String[] CONFIG_geozoneSkipOldEvents(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_geozoneSkipOldEvents, name + CFG_geozoneSkipOldEvents};
    }

    public static String[] CONFIG_maximumHDOP(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_maximumHDOP, name + CFG_maximumHDOP};
    }

    public static String[] CONFIG_checkLastOdometer(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_checkLastOdometer, name + CFG_checkLastOdometer};
    }

    public static String[] CONFIG_simulateDigitalInputs(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_simulateDigitalInputs, name + CFG_simulateDigitalInputs};
    }

    public static String[] CONFIG_startStopSupported(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_startStopSupported, name + CFG_startStopSupported};
    }

    public static String[] CONFIG_saveRawDataPackets(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_saveRawDataPackets, name + CFG_saveRawDataPackets};
    }

    public static String[] CONFIG_statusLocationInMotion(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_statusLocationInMotion, name + CFG_statusLocationInMotion};
    }

    public static String[] CONFIG_ignoreInvalidGPSFlag(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_ignoreInvalidGPSFlag, name + CFG_ignoreInvalidGPSFlag};
    }

    public static String[] CONFIG_ignoreEventsWithInvalidGPS(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_ignoreEventsWithInvalidGPS, name + CFG_ignoreEventsWithInvalidGPS};
    }

    public static String[] CONFIG_useLastValidGPSLocation(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_useLastValidGPSLocation, name + CFG_useLastValidGPSLocation};
    }

    public static String[] CONFIG_useAltCurrentTimestamp(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_useAltCurrentTimestamp, name + CFG_useAltCurrentTimestamp};
    }

    public static String[] CONFIG_initialPacket(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_initialPacket, name + CFG_initialPacket};
    }

    public static String[] CONFIG_finalPacket(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_finalPacket, name + CFG_finalPacket};
    }

    public static String[] CONFIG_saveSessionStatistics(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_saveSessionStatistics, name + CFG_saveSessionStatistics};
    }

    public static String[] CONFIG_batteryLevelRange(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_batteryLevelRange, name + CFG_batteryLevelRange};
    }

    public static String[] CONFIG_startStopStatusCodes(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_startStopStatusCodes, name + CFG_startStopStatusCodes};
    }

    public static String[] CONFIG_debugMode(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_debugMode, name + CFG_debugMode};
    }

    public static String[] CONFIG_showURL(String name) {
        return new String[]{PROP_DCServer_ + name + CFG_showURL, name + CFG_showURL};
    }

    public static String[] CONFIG_commandAckBit(String name, String bitName) {
        return new String[]{PROP_DCServer_ + name + CFG_commandAckBit_ + bitName, name + CFG_commandAckBit_ + bitName};
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + DCServerFactory.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"'Lookup' Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -lookup=<mobileID>      A device mobile-id", (Object[])new Object[0]);
        Print.logInfo((String)"'Send' Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -server=<serverID>      The DCS id", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<accountID>    The account id", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<deviceID>      The device id", (Object[])new Object[0]);
        Print.logInfo((String)"  -cmdType=<command>      The command [send|query|ping|output|config]", (Object[])new Object[0]);
        Print.logInfo((String)"  -cmdName=<name>         The command name (if any)", (Object[])new Object[0]);
        Print.logInfo((String)"  -arg=<arg>              The command argument", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String server = RTConfig.getString((String[])ARG_SERVER, (String)"");
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String deviceID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        String cmdType = RTConfig.getString((String[])ARG_CMDTYPE, (String)"");
        String cmdName = RTConfig.getString((String[])ARG_CMDNAME, (String)"");
        String cmdArg0 = RTConfig.getString((String[])ARG_ARG, (String)"");
        String resCode = RTConfig.getString((String[])ARG_RESULT_CODE, (String)"");
        String[] cmdArgs = new String[]{cmdArg0};
        if (RTConfig.hasProperty((String[])ARG_RESULT_CODE)) {
            String code = RTConfig.getString((String[])ARG_RESULT_CODE, (String)"");
            ResultCode rc = DCServerFactory.GetResultCode(code, null);
            Print.sysPrintln((String)("Result Code: " + (Object)((Object)rc)), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_EVENT_CODE_MAP)) {
            String dcsName = !StringTools.isBlank((String)server) ? server : RTConfig.getString((String[])ARG_EVENT_CODE_MAP, (String)"");
            DCServerConfig dcs = DCServerFactory.getServerConfig(dcsName);
            if (dcs == null) {
                Print.sysPrintln((String)("ERROR - DCS not found: " + dcsName), (Object[])new Object[0]);
                System.exit(1);
            }
            dcs.printEventCodeMap();
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            List<DCServerConfig> list = DCServerFactory.getServerConfigList(true);
            for (DCServerConfig dcs : list) {
                Print.sysPrintln((String)(dcs.getName() + ":"), (Object[])new Object[0]);
                Object[] jarPath = dcs.getRunningJarPath();
                if (!ListTools.isEmpty((Object[])jarPath)) {
                    if (jarPath.length == 1) {
                        Print.sysPrintln((String)("  Jar: " + jarPath[0]), (Object[])new Object[0]);
                        File logPath = DCServerConfig.getLogFilePath((File)jarPath[0]);
                        Print.sysPrintln((String)("  Log: " + logPath + (logPath.isFile() ? "  [exists]" : "  [not-found]")), (Object[])new Object[0]);
                        continue;
                    }
                    for (int i = 0; i < jarPath.length; ++i) {
                        Print.sysPrintln((String)("  " + (i + 1) + ") Jar: " + jarPath[i]), (Object[])new Object[0]);
                        File logPath = DCServerConfig.getLogFilePath((File)jarPath[i]);
                        Print.sysPrintln((String)("     Log: " + logPath + (logPath.isFile() ? "  [exists]" : "  [not-found]")), (Object[])new Object[0]);
                    }
                    continue;
                }
                Print.sysPrintln((String)"  not running", (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LOOKUP)) {
            String uid = RTConfig.getString((String[])ARG_LOOKUP, null);
            if (!StringTools.isBlank((String)uid)) {
                Object[] dev = DCServerFactory.lookupUniqueID(uid);
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)"Device UniqueID Lookup:", (Object[])new Object[0]);
                if (!ListTools.isEmpty((Object[])dev)) {
                    for (Object d : dev) {
                        Print.sysPrintln((String)("   Found: [" + ((Device)d).getUniqueID() + "] " + ((AccountRecord)((Object)d)).getAccountID() + "/" + ((DeviceRecord)((Object)d)).getDeviceID()), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"   None Found", (Object[])new Object[0]);
                }
                Print.sysPrintln((String)"", (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)"Missing IMEI/Mobile ID", (Object[])new Object[0]);
                DCServerFactory.usage();
            }
            System.exit(0);
        }
        if (StringTools.isBlank((String)server)) {
            Print.sysPrintln((String)"ERROR: server missing", (Object[])new Object[0]);
            DCServerFactory.usage();
        }
        Print.logDebug((String)"Checking DCServerConfig existance: %s", (Object[])new Object[]{server});
        DCServerConfig dcs = DCServerFactory.getServerConfig(server);
        if (dcs == null) {
            Print.sysPrintln((String)"ERROR: Invalid server id: %s", (Object[])new Object[]{server});
            DCServerFactory.usage();
        }
        if (StringTools.isBlank((String)cmdType)) {
            Print.sysPrintln((String)"ERROR: command type missing", (Object[])new Object[0]);
            DCServerFactory.usage();
        }
        if (cmdType.equalsIgnoreCase("internal")) {
            RTProperties stResp = DCServerFactory._sendServerCommand(server, null, cmdType, cmdName, cmdArgs);
            if (stResp == null) {
                Print.sysPrintln((String)"Unable to send internal command", (Object[])new Object[0]);
                System.exit(2);
            }
            Print.sysPrintln((String)("Internal Command Response: " + stResp), (Object[])new Object[0]);
            System.exit(0);
        }
        if (StringTools.isBlank((String)accountID) || StringTools.isBlank((String)deviceID)) {
            Print.sysPrintln((String)"ERROR: account/device missing", (Object[])new Object[0]);
            DCServerFactory.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                DCServerFactory.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        Device device = null;
        try {
            device = Device.getDevice(account, deviceID, false);
            if (device == null) {
                Print.logError((String)("Device-ID does not exist: " + accountID + "/" + deviceID), (Object[])new Object[0]);
                DCServerFactory.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error getting Device: " + accountID + "/" + deviceID), (Throwable)dbe);
            System.exit(99);
        }
        RTProperties resp = DCServerFactory._sendServerCommand(server, device, cmdType, cmdName, cmdArgs);
        if (resp == null) {
            Print.sysPrintln((String)"Unable to send command", (Object[])new Object[0]);
            System.exit(2);
        }
        Print.sysPrintln((String)("Command Response: " + resp), (Object[])new Object[0]);
    }

    static {
        missingServerList = null;
        _didInit = false;
        lastNotFoundDCS = null;
        ClassUnassignedDevices_init = false;
        ClassUnassignedDevices = null;
        ARG_udpPort = new String[]{ATTR_udpPort, "udp", "port"};
        ARG_tcpPort = new String[]{ATTR_tcpPort, "tcp", "port"};
        ARG_satPort = new String[]{ATTR_satPort, "sat"};
        ARG_commandPort = new String[]{"commandPort", "command", "cmd"};
        ARG_LIST = new String[]{"list"};
        ARG_LOOKUP = new String[]{"lookup", "find"};
        ARG_SERVER = new String[]{"server", "dcs"};
        ARG_ACCOUNT = new String[]{CMDARG_ACCOUNT, "acct"};
        ARG_DEVICE = new String[]{CMDARG_DEVICE, "dev"};
        ARG_CMDTYPE = new String[]{"cmdType", "ct"};
        ARG_CMDNAME = new String[]{"cmdName", "cn"};
        ARG_ARG = new String[]{"arg", "a"};
        ARG_RESULT_CODE = new String[]{"resultCode", "rc"};
        ARG_EVENT_CODE_MAP = new String[]{"eventCodeMap", "ecm"};
    }

    public static enum ResultCode implements EnumTools.StringLocale,
    EnumTools.StringValue
    {
        SUCCESS("OK000", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.successful", (String)"Successful")),
        COMMAND_QUEUED("OK001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.commandQueued", (String)"Command Queued")),
        INVALID_ACCOUNT("AC001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidAccount", (String)"Invalid Account")),
        INVALID_DEVICE("DV001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidDevice", (String)"Invalid Device")),
        INVALID_SERVER("SR001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidServer", (String)"Invalid Server")),
        NOT_AUTHORIZED("AU001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.notAuthorized", (String)"Not Authorized")),
        OVER_LIMIT("AU002", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.overLimit", (String)"Over Limit")),
        INVALID_COMMAND("CM001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidCommand", (String)"Invalid command")),
        INVALID_ARG("CM002", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidArgument", (String)"Invalid command/argument")),
        INVALID_TYPE("CM003", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidType", (String)"Invalid command type")),
        EMPTY_REQUEST("CM004", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.emptyRequest", (String)"Imvalid/Empty request")),
        NOT_SUPPORTED("CM005", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.notSupported", (String)"Not Supported by Device")),
        UNKNOWN_HOST("HP001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidHost", (String)"Invalid host")),
        TRANSMIT_FAIL("TX001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.transmitFail", (String)"Transmit failure")),
        NO_SESSION("TX002", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.noActiveSession", (String)"No Active Session Found")),
        OFFLINE("TX007", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.deviceOffline", (String)"Device Offline")),
        AGED_ROUTE("TX011", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.agedRoute", (String)"Return route too old (UDP)")),
        INVALID_PROTO("PR001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidProtocol", (String)"Invalid Protocol")),
        INVALID_SMS("PR002", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidSmsSpec", (String)"Invalid SMS specification")),
        INVALID_PACKET("PK001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidPacket", (String)"Invalid Packet")),
        INVALID_EMAIL_FR("EM001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidEMailFrom", (String)"Invalid EMail 'From' address")),
        INVALID_EMAIL_TO("EM002", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.invalidEMailTo", (String)"Invalid EMail 'To' address")),
        INTERNAL_ERROR("XX001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.internalError", (String)"Internal Error")),
        GATEWAY_ERROR("GW001", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayError", (String)"Gateway Error")),
        GATEWAY_CONFIG("GW010", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayConfig", (String)"Gateway Config")),
        GATEWAY_ACCOUNT("GW011", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayAccount", (String)"Gateway Account")),
        GATEWAY_USER("GW012", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayUser", (String)"Gateway User")),
        GATEWAY_DEVICE("GW013", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayDevice", (String)"Gateway Device")),
        GATEWAY_HOST("GW014", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayHost", (String)"Gateway Host")),
        GATEWAY_PORT("GW015", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayPort", (String)"Gateway Port")),
        GATEWAY_CONNECT("GW021", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayConnect", (String)"Gateway Connect")),
        GATEWAY_AUTH("GW031", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayAuth", (String)"Gateway Authentication Failed")),
        GATEWAY_SERVICE("GW032", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.gatewayService", (String)"Gateway Service Failed")),
        UNKNOWN("UN000", I18N.getString(DCServerFactory.class, (String)"DCServerFactory.result.unknownResult", (String)"Unknown Result"));

        private String cc = null;
        private I18N.Text aa = null;

        private ResultCode(String c, I18N.Text a) {
            this.cc = c;
            this.aa = a;
        }

        public String getStringValue() {
            return this.cc;
        }

        public String getCode() {
            return this.cc;
        }

        public String getMessage() {
            return this.aa.toString();
        }

        public String getMessage(Locale loc) {
            return this.aa.toString(loc);
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)SUCCESS);
        }

        public boolean isSuccess() {
            return this.equals((Object)SUCCESS) || this.equals((Object)COMMAND_QUEUED);
        }
    }
}

