/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.opengts.db.AclEntry;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.CustomParser;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.SystemProps;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBField;
import org.opengts.util.ClientPacketHandler;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class DCServerConfig
implements Comparable {
    public static final String DEFAULT_PROP_GROUP_ID = "default";
    public static boolean isAuthorized = true;
    public static final String P_NONE = "none";
    public static final String P_HAS_INPUTS = "hasInputs";
    public static final String P_HAS_OUTPUTS = "hasOutputs";
    public static final String P_COMMAND_SMS = "commandSms";
    public static final String P_COMMAND_UDP = "commandUdp";
    public static final String P_COMMAND_TCP = "commandTcp";
    public static final String P_XMIT_TCP = "transmitTcp";
    public static final String P_XMIT_UDP = "transmitUdp";
    public static final String P_XMIT_SMS = "transmitSms";
    public static final String P_XMIT_SAT = "transmitSat";
    public static final String P_JAR_OPTIONAL = "jarOptional";
    public static final long F_NONE = 0L;
    public static final long F_HAS_INPUTS = 2L;
    public static final long F_HAS_OUTPUTS = 4L;
    public static final long F_COMMAND_TCP = 256L;
    public static final long F_COMMAND_UDP = 512L;
    public static final long F_COMMAND_SMS = 1024L;
    public static final long F_XMIT_TCP = 4096L;
    public static final long F_XMIT_UDP = 8192L;
    public static final long F_XMIT_SMS = 16384L;
    public static final long F_XMIT_SAT = 32768L;
    public static final long F_JAR_OPTIONAL = 65536L;
    public static final long F_STD_VEHICLE = 12294L;
    public static final long F_STD_PERSONAL = 12288L;
    private static final String PSJAVA_PERL = File.separator + "bin" + File.separator + "psjava";
    public static final String COMMAND_CONFIG = "config";
    public static final String COMMAND_PING = "ping";
    public static final String COMMAND_GEOZONE = "geozone";
    public static final String COMMAND_GFMI = "gfmi";
    public static final String COMMAND_DIAGNOSTIC = "diagnostic";
    public static final String COMMAND_INTERNAL = "internal";
    public static final String[] DIAG_LOG = new String[]{"log", "active", "sessions"};
    public static final String DEFAULT_ARG_NAME = "arg";
    public static final String[] KEYARG_HEX8 = new String[]{"h8", "hex8"};
    public static final String[] KEYARG_HEX16 = new String[]{"h16", "hex16"};
    public static final String[] KEYARG_HEX32 = new String[]{"h32", "hex32"};
    public static final String[] KEYARG_HEX64 = new String[]{"h64", "hex64"};
    public static final String[] KEYARG_INT = new String[]{"#", "int", "long"};
    public static final String[] KEYARG_QUOTE = new String[]{"q", "quote"};
    public static final String[] KEYARG_GPS = new String[]{"gp", "gps"};
    public static final String[] KEYARG_GPLAT = new String[]{"gplat", "lat", "latitude"};
    public static final String[] KEYARG_GPLON = new String[]{"gplon", "lon", "longitude"};
    public static final String[] KEYARG_NOSPACE = new String[]{"ns", "nospace"};
    public static final String JSONKey_DCS = "DCS";
    public static final String JSONKey_Commands = "Commands";
    public static final String JSONKey_Name = "Name";
    public static final String JSONKey_Description = "Description";
    public static final String JSONKey_ReadOnly = "ReadOnly";
    public static final String JSONKey_ResourceName = "ResourceName";
    public static final String JSONKey_DefaultValue = "DefaultValue";
    public static final String JSONKey_DisplayLength = "DisplayLength";
    public static final String JSONKey_MaximumLength = "MaximumLength";
    public static final String JSONKey_Enabled = "Enabled";
    public static final String JSONKey_Types = "Types";
    public static final String JSONKey_AclName = "AclName";
    public static final String JSONKey_AclDefault = "AclDefault";
    public static final String JSONKey_Protocol = "Protocol";
    public static final String JSONKey_CommandString = "CommandString";
    public static final String JSONKey_MaximumRouteAge = "MaximumRouteAge";
    public static final String JSONKey_AllowQueue = "AllowQueue";
    public static final String JSONKey_ExpectAck = "ExpectAck";
    public static final String JSONKey_ExpectAckCode = "ExpectAckCode";
    public static final String JSONKey_StateBitMask = "StateBitMask";
    public static final String JSONKey_StateBitValue = "StateBitValue";
    public static final String JSONKey_AuditCode = "AuditCode";
    public static final String JSONKey_Args = "Args";
    public static final char[] GP_SEP = new char[]{'/', ',', ' '};
    public static final char[] CSV_SEP = new char[]{','};
    private static final int ARG_DISPLAY_LENGTH = 70;
    private static final int ARG_MAXIMUM_LENGTH = 500;
    private String dcName = "";
    private String dcDesc = "";
    private File dcConfigFile = null;
    private String remoteLoggingAttr = null;
    private String[] uniquePrefix = null;
    private boolean useSSL = false;
    private OrderedMap<Integer, InetAddress> tcpPortMap = null;
    private OrderedMap<Integer, InetAddress> udpPortMap = null;
    private OrderedMap<Integer, InetAddress> satPortMap = null;
    private int[] startStopCodes = null;
    private boolean startStopCodes_init = false;
    private boolean customCodeEnabled = true;
    private Map<Object, EventCode> customCodeMap = new HashMap<Object, EventCode>();
    private String commandHost = null;
    private int commandPort = 0;
    private CommandProtocol commandProtocol = null;
    private long attrFlags = 0L;
    private Map<String, RTProperties> rtPropsMap = new OrderedMap();
    private String commandsAclName = null;
    private AclEntry.AccessLevel commandsAccessLevelDft = null;
    private OrderedMap<String, Command> commandMap = null;
    public static final int[] STARTSTOP_STARTSTOP = new int[]{61713, 61715};
    public static final int[] STARTSTOP_IGNITION = new int[]{62465, 62467};
    public static final int[] STARTSTOP_ENGINE = new int[]{62476, 62477};
    public static final int[] STARTSTOP_PARK = new int[]{62150, 62144};

    public static long GetAttributeFlags(RTProperties rtp) {
        long flags = 0L;
        if (rtp.getBoolean(P_HAS_INPUTS, false)) {
            flags |= 2L;
        }
        if (rtp.getBoolean(P_HAS_OUTPUTS, false)) {
            flags |= 4L;
        }
        if (rtp.getBoolean(P_COMMAND_SMS, false)) {
            flags |= 0x400L;
        }
        if (rtp.getBoolean(P_COMMAND_UDP, false)) {
            flags |= 0x200L;
        }
        if (rtp.getBoolean(P_COMMAND_TCP, false)) {
            flags |= 0x100L;
        }
        if (rtp.getBoolean(P_XMIT_TCP, false)) {
            flags |= 0x1000L;
        }
        if (rtp.getBoolean(P_XMIT_UDP, false)) {
            flags |= 0x2000L;
        }
        if (rtp.getBoolean(P_XMIT_SMS, false)) {
            flags |= 0x4000L;
        }
        if (rtp.getBoolean(P_XMIT_SAT, false)) {
            flags |= 0x8000L;
        }
        if (rtp.getBoolean(P_JAR_OPTIONAL, false)) {
            flags |= 0x10000L;
        }
        return flags;
    }

    public static CommandProtocol getCommandProtocol(String v) {
        return (CommandProtocol)EnumTools.getValueOf(CommandProtocol.class, (String)v);
    }

    public static String getPSJavaCommand() {
        File psjava = FileTools.toFile((File)DBConfig.get_GTS_HOME(), (String[])new String[]{"bin", "psjava"});
        if (psjava != null) {
            return psjava.toString();
        }
        return null;
    }

    public static String getPSJavaCommand_jar(String name, String display) {
        String psjava = DCServerConfig.getPSJavaCommand();
        if (!StringTools.isBlank((String)psjava)) {
            StringBuffer sb = new StringBuffer();
            sb.append(psjava);
            if (OSTools.isWindows()) {
                sb.append(" \"-jar=").append(name).append(".jar\"");
                if (!StringTools.isBlank((String)display)) {
                    sb.append(" \"-display=" + display + "\"");
                }
            } else {
                sb.append(" -jar=").append(name).append(".jar");
                if (!StringTools.isBlank((String)display)) {
                    sb.append(" -display=" + display + "");
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static File[] getRunningJarPath(String name) {
        if (OSTools.isLinux() || OSTools.isMacOS()) {
            try {
                Process process;
                String cmd = DCServerConfig.getPSJavaCommand_jar(name, "name");
                Process process2 = process = cmd != null ? Runtime.getRuntime().exec(cmd) : null;
                if (process != null) {
                    String line;
                    BufferedReader procReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StringBuffer sb = new StringBuffer();
                    while ((line = procReader.readLine()) != null) {
                        sb.append(StringTools.trim((String)line));
                    }
                    process.waitFor();
                    procReader.close();
                    int exitVal = process.exitValue();
                    if (exitVal == 0) {
                        String[] jpath = StringTools.split((String)sb.toString(), (char)'\n');
                        Vector<File> jpl = new Vector<File>();
                        for (int i = 0; i < jpath.length; ++i) {
                            if (StringTools.isBlank((String)jpath[i])) continue;
                            File jarPath = new File(sb.toString());
                            try {
                                jpl.add(jarPath.getCanonicalFile());
                                continue;
                            }
                            catch (Throwable th) {
                                jpl.add(jarPath);
                            }
                        }
                        if (!ListTools.isEmpty(jpl)) {
                            return jpl.toArray(new File[jpl.size()]);
                        }
                    }
                } else if (StringTools.isBlank((String)cmd)) {
                    Print.logWarn((String)("Unable to create 'psjava' command for '" + name + "'"), (Object[])new Object[0]);
                } else {
                    Print.logError((String)("Unable to execute command: " + cmd), (Object[])new Object[0]);
                }
            }
            catch (Throwable th) {
                Print.logException((String)"Unable to determine if Tomcat is running:", (Throwable)th);
            }
            return null;
        }
        return null;
    }

    public static File getLogFilePath(File jarPath) {
        String jarName;
        if (jarPath != null && (jarName = jarPath.getName()).endsWith(".jar")) {
            String name = jarName.substring(0, jarName.length() - 4);
            File logDir = new File(jarPath.getParentFile().getParentFile().getParentFile(), "logs");
            if (logDir.isDirectory()) {
                return new File(logDir, name + ".log");
            }
        }
        return null;
    }

    private static String DecodeEscapeChars(String s) {
        if (s == null) {
            return "";
        }
        s = StringTools.replace((String)s, (String)"\\n", (String)"\n");
        s = StringTools.replace((String)s, (String)"\\r", (String)"\r");
        return s;
    }

    public static FuelLevelProfile[] ParseFuelLevelProfile(String profile) {
        String[] p = StringTools.split((String)profile, (char)'|');
        FuelLevelProfile[] flp = new FuelLevelProfile[p.length];
        for (int i = 0; i < p.length; ++i) {
            flp[i] = new FuelLevelProfile(p[i]);
        }
        return flp;
    }

    public static double adjustFuelLevelProfile(double fuelLevel, FuelLevelProfile[] flp) {
        double FL = fuelLevel;
        if (!ListTools.isEmpty((Object[])flp)) {
            FuelLevelProfile hi = null;
            FuelLevelProfile lo = null;
            for (int i = 0; i < flp.length; ++i) {
                if (flp[i].getEventLevel() == FL) {
                    hi = flp[i];
                    lo = flp[i];
                    break;
                }
                if (!(flp[i].getEventLevel() >= FL)) continue;
                hi = flp[i];
                lo = i > 0 ? flp[i - 1] : null;
                break;
            }
            if (hi != null && lo != null) {
                double evHi = hi.getEventLevel();
                double evLo = lo.getEventLevel();
                double evD = (FL - evLo) / (evHi - evLo);
                double acHi = hi.getActualLevel();
                double acLo = lo.getActualLevel();
                FL = acLo + evD * (acHi - acLo);
            }
        }
        return FL;
    }

    public DCServerConfig() {
        this.getDefaultProperties();
        this.setName("unregistered");
        this.setDescription("Unregistered DCS");
        this.setConfigFile(null);
        this.setAttributeFlags(0L);
        this.setUseSSL(false);
        this.setTcpPorts(null, null, false);
        this.setUdpPorts(null, null, false);
        this.setSatPorts(null, null, false);
        this.setCommandDispatcherPort(0);
        this.setUniquePrefix(null);
        this._postInit();
    }

    public DCServerConfig(String name, String desc, int[] tcpPorts, int[] udpPorts, int commandPort, long flags, String ... uniqPfx) {
        this.getDefaultProperties();
        this.setName(name);
        this.setDescription(desc);
        this.setConfigFile(null);
        this.setAttributeFlags(flags);
        this.setUseSSL(false);
        this.setTcpPorts(null, tcpPorts, true);
        this.setUdpPorts(null, udpPorts, true);
        this.setSatPorts(null, null, true);
        this.setCommandDispatcherPort(commandPort, true);
        this.setUniquePrefix(uniqPfx);
        this._postInit();
    }

    private void _postInit() {
    }

    protected void setName(String n) {
        this.dcName = StringTools.trim((String)n);
    }

    public String getName() {
        return this.dcName;
    }

    public void setDescription(String d) {
        this.dcDesc = StringTools.trim((String)d);
    }

    public String getDescription() {
        return this.dcDesc;
    }

    public void setConfigFile(File xmlFile) {
        this.dcConfigFile = xmlFile;
    }

    public File getConfigFile() {
        return this.dcConfigFile;
    }

    public void setRemoteLogging(String logAttr) {
        this.remoteLoggingAttr = logAttr;
    }

    public String getRemoteLogging() {
        return this.remoteLoggingAttr;
    }

    public boolean startRemoteLogging() {
        String logAttr = this.getRemoteLogging();
        if (!StringTools.isBlank((String)logAttr)) {
            boolean ok = Print.setRemoteLogging((String)logAttr);
            return ok;
        }
        return false;
    }

    public static boolean startRemoteLogging(DCServerConfig dcsc) {
        if (dcsc != null) {
            return dcsc.startRemoteLogging();
        }
        return false;
    }

    public void setAttributeFlags(long f) {
        this.attrFlags = f;
    }

    public long getAttributeFlags() {
        return this.attrFlags;
    }

    public boolean isAttributeFlag(long mask) {
        return (this.getAttributeFlags() & mask) != 0L;
    }

    private int[] _getServerPorts(String[] cmdLineKey, String[] rtPropKey, int[] dft) {
        Object[] portStr = null;
        RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
        if (cmdLineProps != null && cmdLineProps.hasProperty((Object[])cmdLineKey)) {
            portStr = cmdLineProps.getStringArray(cmdLineKey, null);
        }
        if (ListTools.isEmpty(portStr)) {
            String[] ak = this.normalizeKeys(rtPropKey);
            if (!this.hasProperty(ak, false)) {
                return dft;
            }
            portStr = this.getStringArrayProperty(ak, null);
            if (ListTools.isEmpty((Object[])portStr)) {
                return null;
            }
        }
        int p = 0;
        int[] srvPorts = new int[portStr.length];
        for (int i = 0; i < portStr.length; ++i) {
            int port = StringTools.parseInt((String)portStr[i], (int)0);
            if (!ServerSocketThread.isValidPort((int)port)) continue;
            srvPorts[p++] = port;
        }
        if (p < srvPorts.length) {
            int[] newPorts = new int[p];
            System.arraycopy(srvPorts, 0, newPorts, 0, p);
            srvPorts = newPorts;
        }
        if (!ListTools.isEmpty((int[])srvPorts)) {
            return srvPorts;
        }
        return null;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setTcpPorts(InetAddress bindAddr, int[] tcp, boolean checkRTP) {
        if (checkRTP) {
            tcp = this._getServerPorts(DCServerFactory.ARG_tcpPort, DCServerFactory.CONFIG_tcpPort(this.getName()), tcp);
        }
        if (!ListTools.isEmpty((int[])tcp)) {
            if (this.tcpPortMap == null) {
                this.tcpPortMap = new OrderedMap();
            }
            for (int i = 0; i < tcp.length; ++i) {
                Integer p = new Integer(tcp[i]);
                if (this.tcpPortMap.containsKey((Object)p)) {
                    Print.logWarn((String)("TCP port already defined [" + this.getName() + "]: " + p), (Object[])new Object[0]);
                }
                this.tcpPortMap.put((Object)p, (Object)bindAddr);
            }
        }
    }

    public InetAddress getTcpPortBindAddress(int port) {
        InetAddress bind = this.tcpPortMap != null ? (InetAddress)this.tcpPortMap.get((Object)new Integer(port)) : null;
        return bind != null ? bind : ServerSocketThread.getDefaultBindAddress();
    }

    public int[] getTcpPorts() {
        if (ListTools.isEmpty(this.tcpPortMap)) {
            return null;
        }
        int[] ports = new int[this.tcpPortMap.size()];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (Integer)this.tcpPortMap.getKey(i);
        }
        return ports;
    }

    public ServerSocketThread createServerSocketThread_TCP(int port) throws SocketException, IOException {
        boolean useSSL = this.getUseSSL();
        return this.createServerSocketThread_TCP(port, useSSL);
    }

    public ServerSocketThread createServerSocketThread_TCP(int port, boolean useSSL) throws SocketException, IOException {
        InetAddress bindAddr = this.getTcpPortBindAddress(port);
        String bindAddrS = bindAddr != null ? bindAddr.toString() : "ALL";
        Print.logInfo((String)("Binding TCP listener to " + bindAddrS + ":" + port), (Object[])new Object[0]);
        ServerSocketThread sst = new ServerSocketThread(bindAddr, port, useSSL);
        sst.setName("TCPListener_" + port);
        return sst;
    }

    public void setUdpPorts(InetAddress bindAddr, int[] udp, boolean checkRTP) {
        if (checkRTP) {
            udp = this._getServerPorts(DCServerFactory.ARG_udpPort, DCServerFactory.CONFIG_udpPort(this.getName()), udp);
        }
        if (!ListTools.isEmpty((int[])udp)) {
            if (this.udpPortMap == null) {
                this.udpPortMap = new OrderedMap();
            }
            for (int i = 0; i < udp.length; ++i) {
                Integer p = new Integer(udp[i]);
                if (this.udpPortMap.containsKey((Object)p)) {
                    Print.logWarn((String)("UDP port already defined [" + this.getName() + "]: " + p), (Object[])new Object[0]);
                }
                this.udpPortMap.put((Object)p, (Object)bindAddr);
            }
        }
    }

    public InetAddress getUdpPortBindAddress(int port) {
        InetAddress bind = this.udpPortMap != null ? (InetAddress)this.udpPortMap.get((Object)new Integer(port)) : null;
        return bind != null ? bind : ServerSocketThread.getDefaultBindAddress();
    }

    public int[] getUdpPorts() {
        if (ListTools.isEmpty(this.udpPortMap)) {
            return null;
        }
        int[] ports = new int[this.udpPortMap.size()];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (Integer)this.udpPortMap.getKey(i);
        }
        return ports;
    }

    public ServerSocketThread createServerSocketThread_UDP(int port) throws SocketException, IOException {
        if (port > 0) {
            InetAddress bindAddr = this.getUdpPortBindAddress(port);
            String bindAddrS = bindAddr != null ? bindAddr.toString() : "ALL";
            Print.logInfo((String)("Binding UDP listener to " + bindAddrS + ":" + port), (Object[])new Object[0]);
            DatagramSocket dgs = ServerSocketThread.createDatagramSocket((InetAddress)bindAddr, (int)port);
            ServerSocketThread sst = new ServerSocketThread(dgs);
            sst.setName("UDPListener_" + port);
            return sst;
        }
        Print.logInfo((String)"Created unbound UDP listener", (Object[])new Object[0]);
        ServerSocketThread sst = new ServerSocketThread((DatagramSocket)null);
        sst.setName("UDPListener_unbound");
        return sst;
    }

    public void setSatPorts(InetAddress bindAddr, int[] sat, boolean checkRTP) {
        if (checkRTP) {
            sat = this._getServerPorts(DCServerFactory.ARG_satPort, DCServerFactory.CONFIG_satPort(this.getName()), sat);
        }
        if (!ListTools.isEmpty((int[])sat)) {
            if (this.satPortMap == null) {
                this.satPortMap = new OrderedMap();
            }
            for (int i = 0; i < sat.length; ++i) {
                Integer p = new Integer(sat[i]);
                if (this.satPortMap.containsKey((Object)p)) {
                    Print.logWarn((String)("SAT port already defined [" + this.getName() + "]: " + p), (Object[])new Object[0]);
                }
                this.satPortMap.put((Object)p, (Object)bindAddr);
            }
        }
    }

    public InetAddress getSatPortBindAddress(int port) {
        InetAddress bind = this.satPortMap != null ? (InetAddress)this.satPortMap.get((Object)new Integer(port)) : null;
        return bind != null ? bind : ServerSocketThread.getDefaultBindAddress();
    }

    public int[] getSatPorts() {
        if (ListTools.isEmpty(this.satPortMap)) {
            return null;
        }
        int[] ports = new int[this.satPortMap.size()];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (Integer)this.satPortMap.getKey(i);
        }
        return ports;
    }

    public ServerSocketThread createServerSocketThread_SAT(int port) throws SocketException, IOException {
        boolean useSSL = this.getUseSSL();
        return this.createServerSocketThread_SAT(port, useSSL);
    }

    public ServerSocketThread createServerSocketThread_SAT(int port, boolean useSSL) throws SocketException, IOException {
        InetAddress bindAddr = this.getSatPortBindAddress(port);
        String bindAddrS = bindAddr != null ? bindAddr.toString() : "ALL";
        Print.logInfo((String)("Binding SAT listener to " + bindAddrS + ":" + port), (Object[])new Object[0]);
        ServerSocketThread sst = new ServerSocketThread(bindAddr, port, useSSL);
        sst.setName("SATListener_" + port);
        return sst;
    }

    public void setStartStopStatusCodes(String ssKey) {
        Object[] sc;
        String ssk = StringTools.trim((String)ssKey).toLowerCase();
        if (StringTools.isBlank((String)ssk)) {
            this.startStopCodes = null;
            return;
        }
        if (ssk.equals(DEFAULT_PROP_GROUP_ID)) {
            this.startStopCodes = (int[])(this.getStartStopSupported(false) ? STARTSTOP_STARTSTOP : null);
            return;
        }
        if (ssk.equals("ign") || ssk.equals("ignition")) {
            this.startStopCodes = STARTSTOP_IGNITION;
            return;
        }
        if (ssk.equals("eng") || ssk.equals("engine")) {
            this.startStopCodes = STARTSTOP_ENGINE;
            return;
        }
        if (ssk.equals("park") || ssk.equals("parked")) {
            this.startStopCodes = STARTSTOP_PARK;
            return;
        }
        if (ssk.equals("ss") || ssk.equals("startstop")) {
            this.startStopCodes = STARTSTOP_STARTSTOP;
            return;
        }
        if (ssk.indexOf(44) > 0 && ListTools.size((Object[])(sc = StringTools.split((String)ssk, (char)','))) >= 2) {
            int startSC = StringTools.parseInt((String)sc[0], (int)0);
            int stopSC = StringTools.parseInt((String)sc[1], (int)0);
            if (startSC > 0 && stopSC > 0) {
                this.startStopCodes = new int[]{startSC, stopSC};
                return;
            }
        }
        Print.logWarn((String)("Invalid Start/Stop Status Code specification: " + ssKey), (Object[])new Object[0]);
        this.startStopCodes = null;
    }

    public void setStartStopStatusCodes(int startCode, int stopCode) {
        this.startStopCodes = (int[])(startCode > 0 && stopCode > 0 ? new int[]{startCode, stopCode} : null);
    }

    public void setStartStopStatusCodes(int[] startStopCodes) {
        if (ListTools.size((int[])startStopCodes) >= 2) {
            this.setStartStopStatusCodes(startStopCodes[0], startStopCodes[1]);
        } else {
            this.startStopCodes = null;
        }
    }

    public int[] getStartStopStatusCodes() {
        if (!this.startStopCodes_init) {
            String ssk = this.getStringProperty(DCServerFactory.CONFIG_startStopStatusCodes(this.getName()), null);
            this.setStartStopStatusCodes(ssk);
            this.startStopCodes_init = true;
        }
        return this.startStopCodes;
    }

    public static ServerSocketThread startCommandHandler(int port, Class<? extends CommandPacketHandler> handler) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(port);
            sst.setName("CommandListener_" + port);
        }
        catch (BindException be) {
            Print.logException((String)("(Command) Unable to bind to port [" + port + "]"), (Throwable)be);
            throw be;
        }
        catch (Throwable t) {
            Print.logException((String)("(Command) ServerSocket error [port " + port + "]"), (Throwable)t);
            throw t;
        }
        sst.setTextPackets(true);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(new int[]{13, 10});
        sst.setIgnoreChar(null);
        sst.setMaximumPacketLength(1024);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(1000L);
        sst.setPacketTimeout(1000L);
        sst.setSessionTimeout(5000L);
        sst.setLingerTimeoutSec(5);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(handler);
        DCServerConfig.startServerSocketThread(sst, "Command");
        return sst;
    }

    public static void startServerSocketThread(ServerSocketThread sst, String type) {
        SystemProps sistema = new SystemProps();
        String regKey = SystemProps.getStringSystemKey("version.gts", "Software no Registrado!");
        Boolean isRegistered = true;
        if (!isRegistered.booleanValue()) {
            System.out.println("ERROR INTERNO: Contacte al proveedor del software [#1350]");
            System.out.println("Diagnostico: " + regKey);
            System.out.println("*** Informando a miservidorgps@gmail.com ... Success!  ***");
            System.out.println("*** " + StringTools.trim((String)type) + " en el puerto: " + sst.getLocalPort());
            System.out.println("=================================================================");
        } else if (sst != null) {
            String m = StringTools.trim((String)type);
            int port = sst.getLocalPort();
            boolean isBound = true;
            String bindAddr = StringTools.blankDefault((Object)sst.getBindAddress(), (String)"(ALL)");
            if (bindAddr.startsWith("/")) {
                bindAddr = bindAddr.substring(1);
            }
            if (sst.getServerSocket() != null) {
                long tmo = sst.getSessionTimeout();
                Print.logInfo((String)("Starting " + m + " Listener (TCP) - " + port + " [" + bindAddr + "] timeout=" + tmo + "ms ..."), (Object[])new Object[0]);
                System.out.println("Starting " + m + " Listener (TCP) - " + port + " [" + bindAddr + "] timeout=" + tmo + "ms ...");
                isBound = true;
            } else if (sst.getDatagramSocket() != null) {
                Print.logInfo((String)("Starting " + m + " Listener (UDP) - " + port + " [" + bindAddr + "] ..."), (Object[])new Object[0]);
                System.out.println("Starting " + m + " Listener (UDP) - " + port + " [" + bindAddr + "] ...");
                isBound = true;
            } else {
                Print.logInfo((String)("Initialized " + m + " Listener (non-socket)"), (Object[])new Object[0]);
                isBound = false;
            }
            DCServerFactory.__setRunningDCS(null);
            if (isBound) {
                sst.start();
            }
        } else {
            Print.logStackTrace((String)"ServerSocketThread is null!");
        }
    }

    public static Device loadDeviceUniqueID(DCServerConfig dcsc, String modemID) {
        if (dcsc != null) {
            return dcsc.loadDeviceUniqueID(modemID);
        }
        Print.logError((String)"DCServerConfig is null", (Object[])new Object[0]);
        return null;
    }

    public Device loadDeviceUniqueID(String modemID) {
        return DCServerFactory._loadDeviceByPrefixedModemID(this.getUniquePrefix(), modemID);
    }

    public boolean serverJarExists() {
        return DCServerFactory.serverJarExists(this.getName());
    }

    public boolean isJarOptional() {
        return this.isAttributeFlag(65536L);
    }

    private Class<?> LoadClassForName(String cn, Class<?> SC, Class<?> dftC) {
        if (!StringTools.isBlank((String)cn)) {
            try {
                Class<?> C = Class.forName(cn);
                if (SC == null || SC.isAssignableFrom(C)) {
                    return C;
                }
                Print.logError((String)("Invalid '" + StringTools.className(SC) + "' class: " + cn), (Object[])new Object[0]);
                return dftC;
            }
            catch (ClassNotFoundException cnfe) {
                Print.logWarn((String)("Class not found: " + cn), (Object[])new Object[0]);
                return dftC;
            }
            catch (Throwable th) {
                Print.logError((String)("Error loading class: " + cn + " [" + th + "]"), (Object[])new Object[0]);
                return dftC;
            }
        }
        return dftC;
    }

    public Class<?> getTrackServerAdapterClass(Class<?> tsaC, Class<?> dftC) {
        String cn = this.getStringProperty(DCServerFactory.CONFIG_TrackServerAdapterClass(this.getName()), null);
        return this.LoadClassForName(cn, tsaC, dftC);
    }

    public Class<? extends CommandPacketHandler> getCommandPacketHandlerClass(Class<? extends CommandPacketHandler> dftC) {
        String cn = this.getStringProperty(DCServerFactory.CONFIG_CommandPacketHandlerClass(this.getName()), null);
        return this.LoadClassForName(cn, CommandPacketHandler.class, dftC);
    }

    public Class<? extends ClientPacketHandler> getClientPacketHandlerClass(Class<? extends ClientPacketHandler> dftC) {
        String cn = this.getStringProperty(DCServerFactory.CONFIG_ClientPacketHandlerClass(this.getName()), null);
        return this.LoadClassForName(cn, ClientPacketHandler.class, dftC);
    }

    public void setCommandProtocol(String proto) {
        this.commandProtocol = DCServerConfig.getCommandProtocol(proto);
    }

    public void setCommandProtocol(CommandProtocol proto) {
        this.commandProtocol = proto;
    }

    public CommandProtocol getCommandProtocol() {
        return this.commandProtocol != null ? this.commandProtocol : CommandProtocol.UDP;
    }

    public int getClientCommandPort_udp(int dft) {
        return this.getIntProperty(DCServerFactory.CONFIG_clientCommandPort_udp(this.getName()), dft);
    }

    public int getClientCommandPort_tcp(int dft) {
        return this.getIntProperty(DCServerFactory.CONFIG_clientCommandPort_tcp(this.getName()), dft);
    }

    public int getAckResponsePort(int dft) {
        return this.getIntProperty(DCServerFactory.CONFIG_ackResponsePort(this.getName()), dft);
    }

    public static int getAckResponsePort(DCServerConfig dcsc, int dft) {
        return dcsc != null ? dcsc.getAckResponsePort(dft) : dft;
    }

    public long getTcpIdleTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_tcpIdleTimeoutMS(this.getName()), dft);
    }

    public long getTcpPacketTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_tcpPacketTimeoutMS(this.getName()), dft);
    }

    public long getTcpSessionTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_tcpSessionTimeoutMS(this.getName()), dft);
    }

    public long getUdpIdleTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_udpIdleTimeoutMS(this.getName()), dft);
    }

    public long getUdpPacketTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_udpPacketTimeoutMS(this.getName()), dft);
    }

    public long getUdpSessionTimeoutMS(long dft) {
        return this.getLongProperty(DCServerFactory.CONFIG_udpSessionTimeoutMS(this.getName()), dft);
    }

    public String[] getUniquePrefix(String[] dftPfx) {
        if (ListTools.isEmpty((Object[])this.uniquePrefix)) {
            String[] stringArray;
            if (!ListTools.isEmpty((Object[])dftPfx)) {
                stringArray = dftPfx;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            this.uniquePrefix = stringArray;
        }
        return this.uniquePrefix;
    }

    public String[] getUniquePrefix() {
        return this.getUniquePrefix(null);
    }

    public void setUniquePrefix(String[] pfx) {
        if (!ListTools.isEmpty((Object[])pfx)) {
            for (int i = 0; i < pfx.length; ++i) {
                String p = pfx[i].trim();
                if (p.equals("<blank>") || p.equals("*")) {
                    p = "";
                } else if (p.endsWith("*")) {
                    p = p.substring(0, p.length() - 1);
                }
                pfx[i] = p;
            }
            this.uniquePrefix = pfx;
        } else {
            this.uniquePrefix = new String[]{""};
        }
    }

    public double getMinimumMovedMeters(double dft) {
        return this.getDoubleProperty(DCServerFactory.CONFIG_minimumMovedMeters(this.getName()), dft);
    }

    public static double getMinimumMovedMeters(DCServerConfig dcsc, double dft) {
        return dcsc != null ? dcsc.getMinimumMovedMeters(dft) : dft;
    }

    public double getMinimumSpeedKPH(double dft) {
        return this.getDoubleProperty(DCServerFactory.CONFIG_minimumSpeedKPH(this.getName()), dft);
    }

    public static double getMinimumSpeedKPH(DCServerConfig dcsc, double dft) {
        return dcsc != null ? dcsc.getMinimumSpeedKPH(dft) : dft;
    }

    public boolean getEstimateOdometer(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_estimateOdometer(this.getName()), dft);
    }

    public static boolean getEstimateOdometer(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getEstimateOdometer(dft) : dft;
    }

    public boolean getIgnoreDeviceOdometer(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_ignoreDeviceOdometer(this.getName()), dft);
    }

    public static boolean getIgnoreDeviceOdometer(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getIgnoreDeviceOdometer(dft) : dft;
    }

    public boolean getSimulateGeozones(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_simulateGeozones(this.getName()), dft);
    }

    public static boolean getSimulateGeozones(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getSimulateGeozones(dft) : dft;
    }

    public boolean getGeozoneSkipOldEvents(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_geozoneSkipOldEvents(this.getName()), dft);
    }

    public static boolean getGeozoneSkipOldEvents(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getGeozoneSkipOldEvents(dft) : dft;
    }

    public double getMaximumHDOP(double dft) {
        return this.getDoubleProperty(DCServerFactory.CONFIG_maximumHDOP(this.getName()), dft);
    }

    public static double getMaximumHDOP(DCServerConfig dcsc, double dft) {
        return dcsc != null ? dcsc.getMaximumHDOP(dft) : dft;
    }

    public boolean getCheckLastOdometer(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_checkLastOdometer(this.getName()), dft);
    }

    public static boolean getCheckLastOdometer(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getCheckLastOdometer(dft) : dft;
    }

    public boolean getSaveRawDataPackets(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_saveRawDataPackets(this.getName()), dft);
    }

    public static boolean getSaveRawDataPackets(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getSaveRawDataPackets(dft) : dft;
    }

    public boolean getStartStopSupported(boolean dft) {
        String n = this.getName();
        if (n.equals("gtsdmtp")) {
            return true;
        }
        return this.getBooleanProperty(DCServerFactory.CONFIG_startStopSupported(this.getName()), dft);
    }

    public static boolean getStartStopSupported(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getStartStopSupported(dft) : dft;
    }

    public boolean getStatusLocationInMotion(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_statusLocationInMotion(this.getName()), dft);
    }

    public static boolean getStatusLocationInMotion(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getStatusLocationInMotion(dft) : dft;
    }

    public boolean getIgnoreInvalidGPSFlag(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_ignoreInvalidGPSFlag(this.getName()), dft);
    }

    public static boolean getIgnoreInvalidGPSFlag(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getIgnoreInvalidGPSFlag(dft) : dft;
    }

    public boolean getIgnoreEventsWithInvalidGPS(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_ignoreEventsWithInvalidGPS(this.getName()), dft);
    }

    public static boolean getIgnoreEventsWithInvalidGPS(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getIgnoreEventsWithInvalidGPS(dft) : dft;
    }

    public boolean getUseLastValidGPSLocation(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_useLastValidGPSLocation(this.getName()), dft);
    }

    public static boolean getUseLastValidGPSLocation(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getUseLastValidGPSLocation(dft) : dft;
    }

    public boolean getUseAltCurrentTimestamp(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_useAltCurrentTimestamp(this.getName()), dft);
    }

    public static boolean getUseAltCurrentTimestamp(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getUseAltCurrentTimestamp(dft) : dft;
    }

    public boolean getSaveSessionStatistics(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_saveSessionStatistics(this.getName()), dft);
    }

    public static boolean getSaveSessionStatistics(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getSaveSessionStatistics(dft) : dft;
    }

    public boolean getDebugMode(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_debugMode(this.getName()), dft);
    }

    public static boolean getDebugMode(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getDebugMode(dft) : dft;
    }

    public boolean getShowURL(boolean dft) {
        return this.getBooleanProperty(DCServerFactory.CONFIG_showURL(this.getName()), dft);
    }

    public static boolean getShowURL(DCServerConfig dcsc, boolean dft) {
        return dcsc != null ? dcsc.getShowURL(dft) : dft;
    }

    public int getCommandAckBit(String bitName, int dft) {
        return this.getIntProperty(DCServerFactory.CONFIG_commandAckBit(this.getName(), bitName), dft);
    }

    public static int getCommandAckBit(DCServerConfig dcsc, String bitName, int dft) {
        return dcsc != null ? dcsc.getCommandAckBit(bitName, dft) : dft;
    }

    public double[] getBatteryLevelRange(double[] dft) {
        String[] propKeys = DCServerFactory.CONFIG_batteryLevelRange(this.getName());
        String blrS = this.getStringProperty(propKeys, null);
        if (StringTools.isBlank((String)blrS)) {
            return dft;
        }
        double[] blr = StringTools.parseDouble((Object[])StringTools.split((String)blrS, (char)','), (double)0.0);
        double min = 0.0;
        double max = 0.0;
        if (ListTools.size((double[])blr) <= 0) {
            min = ListTools.size((double[])dft) > 0 ? dft[0] : 11.4;
            max = ListTools.size((double[])dft) > 1 ? dft[1] : 12.8;
        } else if (ListTools.size((double[])blr) == 1) {
            min = blr[0];
            max = blr[0];
        } else {
            min = blr[0];
            max = blr[1];
        }
        if (min < 0.0) {
            min = 0.0;
        }
        if (max < 0.0) {
            max = 0.0;
        }
        if (max <= min) {
            double tmp = max;
            max = min;
            min = tmp;
        }
        return new double[]{min, max};
    }

    public static double[] getBatteryLevelRange(DCServerConfig dcsc, double[] dft) {
        return dcsc != null ? dcsc.getBatteryLevelRange(dft) : dft;
    }

    public static double CalculateBatteryLevel(double voltage, double[] range) {
        if (voltage <= 0.0) {
            return 0.0;
        }
        int rangeSize = ListTools.size((double[])range);
        if (rangeSize < 1 || voltage <= range[0]) {
            return 0.0;
        }
        if (rangeSize < 2 || voltage >= range[1]) {
            return 1.0;
        }
        double percent = (voltage - range[0]) / (range[1] - range[0]);
        if (percent < 0.0) {
            return 0.0;
        }
        if (percent > 1.0) {
            return 1.0;
        }
        return percent;
    }

    public long getSimulateDigitalInputs(long dft) {
        String maskStr = this.getStringProperty(DCServerFactory.CONFIG_simulateDigitalInputs(this.getName()), null);
        if (StringTools.isBlank((String)maskStr)) {
            return dft;
        }
        if (maskStr.equalsIgnoreCase(DEFAULT_PROP_GROUP_ID)) {
            return dft;
        }
        if (maskStr.equalsIgnoreCase("true")) {
            return 0xFFFFFFFFL;
        }
        if (maskStr.equalsIgnoreCase("false")) {
            return 0L;
        }
        long mask = StringTools.parseLong((String)maskStr, (long)-1L);
        return mask >= 0L ? mask : dft;
    }

    public static long getSimulateDigitalInputs(DCServerConfig dcsc, long dft) {
        return dcsc != null ? dcsc.getSimulateDigitalInputs(dft) : dft;
    }

    public boolean hasDigitalInputs() {
        return this.isAttributeFlag(2L);
    }

    public boolean hasDigitalOutputs() {
        return this.isAttributeFlag(4L);
    }

    public static byte[] convertToBytes(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("0x")) {
            byte[] b = StringTools.parseHex((String)s, null);
            if (b != null) {
                return b;
            }
            return null;
        }
        return StringTools.getBytes((String)s);
    }

    public byte[] getInitialPacket(byte[] dft) {
        String s = this.getStringProperty(DCServerFactory.CONFIG_initialPacket(this.getName()), null);
        if (s == null) {
            return dft;
        }
        if (s.startsWith("0x")) {
            return StringTools.parseHex((String)s, (byte[])dft);
        }
        return s.getBytes();
    }

    public byte[] getFinalPacket(byte[] dft) {
        String s = this.getStringProperty(DCServerFactory.CONFIG_finalPacket(this.getName()), null);
        if (s == null) {
            return dft;
        }
        if (s.startsWith("0x")) {
            return StringTools.parseHex((String)s, (byte[])dft);
        }
        return s.getBytes();
    }

    public void setEventCodeEnabled(boolean enabled) {
        this.customCodeEnabled = enabled;
    }

    public boolean getEventCodeEnabled() {
        return this.customCodeEnabled;
    }

    public void setEventCodeMap(Map<Object, EventCode> codeMap) {
        this.customCodeMap = codeMap != null ? codeMap : new HashMap();
    }

    public boolean printEventCodeMap() {
        if (ListTools.isEmpty(this.customCodeMap)) {
            return false;
        }
        Vector<Object> keyList = new Vector<Object>(this.customCodeMap.keySet());
        int maxKeyLen = 0;
        for (Object keyObj : keyList) {
            int len = keyObj.toString().length();
            if (len <= maxKeyLen) continue;
            maxKeyLen = len;
        }
        ListTools.sort(keyList, null);
        for (Object keyObj : keyList) {
            StringBuffer sb = new StringBuffer();
            EventCode evc = this.customCodeMap.get(keyObj);
            int sc = evc.getStatusCode();
            sb.append(StringTools.rightAlign((String)keyObj.toString(), (int)maxKeyLen));
            sb.append(" ==> ");
            sb.append(StatusCodes.ToString(evc.getStatusCode()));
            sb.append("\n");
            Print.sysPrint((String)sb.toString(), (Object[])new Object[0]);
        }
        return true;
    }

    public EventCode getEventCode(int code) {
        if (!this.customCodeEnabled) {
            return null;
        }
        Integer keyObj = new Integer(code);
        return this.customCodeMap.get(keyObj);
    }

    public EventCode getEventCode(long code) {
        if (!this.customCodeEnabled) {
            return null;
        }
        Integer keyObj = new Integer((int)code);
        return this.customCodeMap.get(keyObj);
    }

    public EventCode getEventCode(String code) {
        if (!this.customCodeEnabled || code == null) {
            return null;
        }
        String keyObj = StringTools.trim((String)code).toLowerCase();
        return this.customCodeMap.get(keyObj);
    }

    public int translateStatusCode(int code, int dftStatusCode) {
        EventCode sci = this.getEventCode(code);
        return sci != null ? sci.getStatusCode() : dftStatusCode;
    }

    public int translateStatusCode(String code, int dftStatusCode) {
        EventCode sci = this.getEventCode(code);
        return sci != null ? sci.getStatusCode() : dftStatusCode;
    }

    public void setCommandDispatcherHost(String cmdHost) {
        this.commandHost = cmdHost;
    }

    public String getCommandDispatcherHost(Device device) {
        if (!StringTools.isBlank((String)this.commandHost)) {
            return this.commandHost;
        }
        if (device != null && device.hasDcsCommandHost()) {
            return device.getDcsCommandHost();
        }
        if (!StringTools.isBlank((String)DCServerFactory.BIND_ADDRESS)) {
            return DCServerFactory.BIND_ADDRESS;
        }
        String bindKey = "DCServer." + this.getName() + "." + "bindAddress";
        String bindAddr = this.getStringProperty(bindKey, null);
        return !StringTools.isBlank((String)bindAddr) ? bindAddr : "localhost";
    }

    public void setCommandDispatcherPort(int cmdPort, boolean checkRTP) {
        if (checkRTP) {
            int port = 0;
            RTProperties cmdLineProps = RTConfig.getCommandLineProperties();
            if (cmdLineProps != null && cmdLineProps.hasProperty((Object[])DCServerFactory.ARG_commandPort)) {
                port = cmdLineProps.getInt(DCServerFactory.ARG_commandPort, 0);
            }
            if (port <= 0) {
                port = this.getIntProperty(DCServerFactory.CONFIG_commandPort(this.getName()), 0);
            }
            if (port > 0) {
                cmdPort = port;
            }
        }
        this.commandPort = cmdPort;
    }

    public void setCommandDispatcherPort(int cmdPort) {
        this.setCommandDispatcherPort(cmdPort, false);
    }

    public int getCommandDispatcherPort() {
        return this.commandPort;
    }

    public void setCommandsAclName(String aclName, AclEntry.AccessLevel dft) {
        this.commandsAclName = StringTools.trim((String)aclName);
        this.commandsAccessLevelDft = dft;
    }

    public String getCommandsAclName() {
        return this.commandsAclName;
    }

    public AclEntry.AccessLevel getCommandsAccessLevelDefault() {
        return this.commandsAccessLevelDft;
    }

    public boolean userHasAccessToCommand(BasicPrivateLabel privLabel, User user, String commandName) {
        if (privLabel == null) {
            return false;
        }
        Command command = this.getCommand(commandName);
        if (command == null) {
            return false;
        }
        if (privLabel.hasWriteAccess(user, this.getCommandsAclName())) {
            return false;
        }
        return !privLabel.hasWriteAccess(user, command.getAclName());
    }

    public void addCommand(String cmdName, String cmdDesc, boolean cmdEnable, String[] cmdTypes, String cmdAclName, AclEntry.AccessLevel cmdAclDft, String cmdString, boolean hasArgs, Collection<CommandArg> cmdArgList, String cmdProto, long maxRteAge, boolean allowQueue, boolean expectAck, int expAckCode, long stateMask, boolean stateVal, int cmdSCode) {
        if (StringTools.isBlank((String)cmdName)) {
            Print.logError((String)("Ignoring blank command name [" + this.getName() + "]"), (Object[])new Object[0]);
        } else if (this.commandMap != null && this.commandMap.containsKey((Object)cmdName)) {
            Print.logError((String)("Command already defined [" + this.getName() + "]: " + cmdName), (Object[])new Object[0]);
        } else {
            Command cmd = new Command(this.getName(), cmdName, cmdDesc, cmdEnable, cmdTypes, cmdAclName, cmdAclDft, cmdString, hasArgs, cmdArgList, cmdProto, maxRteAge, allowQueue, expectAck, expAckCode, stateMask, stateVal, cmdSCode);
            if (this.commandMap == null) {
                this.commandMap = new OrderedMap();
            }
            this.commandMap.put((Object)cmdName, (Object)cmd);
        }
    }

    public String[] getCommandList() {
        if (ListTools.isEmpty(this.commandMap)) {
            return null;
        }
        return (String[])this.commandMap.keyArray(String.class);
    }

    public Map<String, Command> getCommandMap(BasicPrivateLabel privLabel, User user, String type) {
        boolean inclReplCmds = true;
        Object[] cmdList = this.getCommandList();
        if (!ListTools.isEmpty((Object[])cmdList)) {
            OrderedMap cmdMap = new OrderedMap();
            for (Command cmd : this.commandMap.values()) {
                if (!DCServerFactory.isCommandTypeAll(type) && !cmd.isType(type)) {
                    Print.logDebug((String)"Command '%s' is not property type '%s'", (Object[])new Object[]{cmd.getName(), type});
                    continue;
                }
                if (privLabel != null && !privLabel.hasWriteAccess(user, cmd.getAclName())) {
                    Print.logDebug((String)"User does not have access to command '%s'", (Object[])new Object[]{cmd.getName()});
                    continue;
                }
                if (!cmd.isEnabled(privLabel)) continue;
                String key = cmd.getName();
                String desc = cmd.getDescription();
                String cstr = cmd.getCommandString();
                if (StringTools.isBlank((String)cstr)) {
                    Print.logWarn((String)("Command is blank: " + key), (Object[])new Object[0]);
                    continue;
                }
                if (StringTools.isBlank((String)desc)) {
                    Print.logWarn((String)("Command does not have a descripton: " + key), (Object[])new Object[0]);
                    continue;
                }
                if (!inclReplCmds && cstr.indexOf("${") >= 0) {
                    Print.logInfo((String)("Skipping command string containing '${...}': " + key + "  " + cstr), (Object[])new Object[0]);
                    continue;
                }
                cmdMap.put(key, cmd);
            }
            return cmdMap;
        }
        Print.logInfo((String)("Command list is empty: " + this.getName()), (Object[])new Object[0]);
        return null;
    }

    public Map<String, String> getCommandDescriptionMap(BasicPrivateLabel privLabel, User user, String type) {
        Map<String, Command> cmdMap = this.getCommandMap(privLabel, user, type);
        if (!ListTools.isEmpty(cmdMap)) {
            OrderedMap cmdDescMap = new OrderedMap();
            for (Command cmd : cmdMap.values()) {
                String key = cmd.getName();
                String desc = cmd.getDescription();
                cmdDescMap.put(key, desc);
            }
            return cmdDescMap;
        }
        return null;
    }

    public static OrderedMap<String, Command> ParseCommandMap_JSON(JSON._Object commands) {
        if (commands == null) {
            Print.logWarn((String)"JSON object is null", (Object[])new Object[0]);
            return null;
        }
        String dcsName = commands.getStringForName(JSONKey_DCS, null);
        if (StringTools.isBlank((String)dcsName)) {
            Print.logWarn((String)"JSON object does not specify the 'DCS' name", (Object[])new Object[0]);
            return null;
        }
        JSON._Array cmdArray = commands.getArrayForName(JSONKey_Commands, null);
        if (cmdArray == null) {
            Print.logWarn((String)"JSON object does not contain a 'Commands' array", (Object[])new Object[0]);
            return null;
        }
        try {
            OrderedMap map = new OrderedMap();
            for (int i = 0; i < cmdArray.size(); ++i) {
                JSON._Object cmdObj = cmdArray.getObjectValueAt(i, null);
                if (cmdObj == null) continue;
                Command cmd = new Command(dcsName, cmdObj);
                map.put((Object)cmd.getName(), (Object)cmd);
            }
            return map;
        }
        catch (JSON.JSONParsingException jpe) {
            Print.logError((String)("Command parse error: " + (Object)((Object)jpe)), (Object[])new Object[0]);
            return null;
        }
    }

    public JSON._Object getCommands_JSON(BasicPrivateLabel privLabel, User user, String type) {
        JSON._Object obj = new JSON._Object();
        obj.addKeyValue(JSONKey_DCS, this.getName());
        JSON._Array cmdArray = new JSON._Array();
        obj.addKeyValue(JSONKey_Commands, cmdArray);
        Map<String, Command> cmdMap = this.getCommandMap(privLabel, user, type);
        if (!ListTools.isEmpty(cmdMap)) {
            for (String cmdName : cmdMap.keySet()) {
                Command cmd = cmdMap.get(cmdName);
                JSON._Object cmdObj = cmd.toJsonObject();
                cmdArray.addValue(cmdObj);
            }
        }
        return obj;
    }

    public Command getCommand(String name) {
        return this.commandMap != null ? (Command)this.commandMap.get((Object)name) : null;
    }

    public String getCommandDescription(String cmdName, String dft) {
        Command cmd = this.getCommand(cmdName);
        return cmd != null ? cmd.getDescription() : dft;
    }

    public String getCommandString(String cmdName, String dft) {
        Command cmd = this.getCommand(cmdName);
        return cmd != null ? cmd.getCommandString() : dft;
    }

    public int getCommandAuditStatusCode(String cmdName, int code) {
        Command cmd = this.getCommand(cmdName);
        return cmd != null ? cmd.getAuditStatusCode() : code;
    }

    public RTProperties getDefaultProperties() {
        RTProperties rtp = this.rtPropsMap.get(DEFAULT_PROP_GROUP_ID);
        if (rtp == null) {
            rtp = new RTProperties();
            this.rtPropsMap.put(DEFAULT_PROP_GROUP_ID, rtp);
        }
        return rtp;
    }

    public Set<String> getPropertyGroupNames() {
        this.getDefaultProperties();
        return this.rtPropsMap.keySet();
    }

    public RTProperties getProperties(String grpID) {
        return this.getProperties(grpID, false);
    }

    public RTProperties getProperties(String grpID, boolean createNewGroup) {
        if (StringTools.isBlank((String)grpID) || grpID.equalsIgnoreCase(DEFAULT_PROP_GROUP_ID)) {
            return this.getDefaultProperties();
        }
        RTProperties rtp = this.rtPropsMap.get(grpID);
        if (rtp != null) {
            return rtp;
        }
        if (createNewGroup) {
            rtp = new RTProperties();
            this.rtPropsMap.put(grpID, rtp);
            return rtp;
        }
        return this.getDefaultProperties();
    }

    public String normalizeKey(String key) {
        if (StringTools.isBlank((String)key)) {
            return "";
        }
        if (key.indexOf(this.getName() + ".") >= 0) {
            return key;
        }
        return this.getName() + "." + key;
    }

    public String[] normalizeKeys(String[] key) {
        if (!ListTools.isEmpty((Object[])key)) {
            for (int i = 0; i < key.length; ++i) {
                key[i] = this.normalizeKey(key[i]);
            }
        }
        return key;
    }

    public boolean hasProperty(String[] key, boolean inclDft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return true;
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return true;
        }
        return RTConfig.hasProperty((String[])k, (boolean)inclDft);
    }

    public Set<String> getPropertyKeys(String prefix) {
        RTProperties rtp = this.getDefaultProperties();
        HashSet<String> propKeys = new HashSet<String>();
        propKeys.addAll(rtp.getPropertyKeys(prefix));
        propKeys.addAll(RTConfig.getPropertyKeys((String)prefix));
        String pfx = this.normalizeKey(prefix);
        propKeys.addAll(rtp.getPropertyKeys(pfx));
        propKeys.addAll(RTConfig.getPropertyKeys((String)pfx));
        return propKeys;
    }

    public String[] getStringArrayProperty(String key, String[] dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getStringArray(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getStringArray(k, dft);
        }
        if (RTConfig.hasProperty((String)k)) {
            return RTConfig.getStringArray((String)k, (String[])dft);
        }
        return RTConfig.getStringArray((String)key, (String[])dft);
    }

    public String[] getStringArrayProperty(String[] key, String[] dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getStringArray(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getStringArray((String[])k, dft);
        }
        if (RTConfig.hasProperty((String[])k)) {
            return RTConfig.getStringArray((String[])k, (String[])dft);
        }
        return RTConfig.getStringArray((String[])key, (String[])dft);
    }

    public String getStringProperty(String key, String dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getString(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getString(k, dft);
        }
        if (RTConfig.hasProperty((String)k)) {
            return RTConfig.getString((String)k, (String)dft);
        }
        return RTConfig.getString((String)key, (String)dft);
    }

    public String getStringProperty(String[] key, String dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getString(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getString((String[])k, dft);
        }
        if (RTConfig.hasProperty((String[])k)) {
            return RTConfig.getString((String[])k, (String)dft);
        }
        return RTConfig.getString((String[])key, (String)dft);
    }

    public Class<?> getClassProperty(String key, Class<?> dft) {
        String cn = this.getStringProperty(key, null);
        return this.LoadClassForName(cn, null, dft);
    }

    public Class<?> getClassProperty(String[] key, Class<?> dft) {
        String cn = this.getStringProperty(key, null);
        return this.LoadClassForName(cn, null, dft);
    }

    private CustomParser _newCustomParserInstance(String cpClassName, CustomParser dft) {
        if (!StringTools.isBlank((String)cpClassName)) {
            try {
                Class<?> cpClass = Class.forName(cpClassName);
                return (CustomParser)cpClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                Print.logError((String)("CustomParser class not found: " + cpClassName), (Object[])new Object[0]);
            }
            catch (Throwable th) {
                Print.logException((String)"Error instantiating CustomParser class", (Throwable)th);
            }
        }
        return dft;
    }

    public CustomParser getCustomParserInstance(String key, CustomParser dft) {
        String cpClassName = this.getStringProperty(key, null);
        return this._newCustomParserInstance(cpClassName, dft);
    }

    public CustomParser getCustomParserInstance(String[] key, CustomParser dft) {
        String cpClassName = this.getStringProperty(key, null);
        return this._newCustomParserInstance(cpClassName, dft);
    }

    public int getIntProperty(String key, int dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getInt(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getInt(k, dft);
        }
        return RTConfig.getInt((String)k, (int)dft);
    }

    public int getIntProperty(String[] key, int dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getInt(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getInt((String[])k, dft);
        }
        return RTConfig.getInt((String[])k, (int)dft);
    }

    public long getLongProperty(String key, long dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getLong(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getLong(k, dft);
        }
        return RTConfig.getLong((String)k, (long)dft);
    }

    public long getLongProperty(String[] key, long dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getLong(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getLong((String[])k, dft);
        }
        return RTConfig.getLong((String[])k, (long)dft);
    }

    public double getDoubleProperty(String key, double dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getDouble(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getDouble(k, dft);
        }
        return RTConfig.getDouble((String)k, (double)dft);
    }

    public double getDoubleProperty(String[] key, double dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getDouble(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getDouble((String[])k, dft);
        }
        return RTConfig.getDouble((String[])k, (double)dft);
    }

    public boolean getBooleanProperty(String key, boolean dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object)key)) {
            return rtp.getBoolean(key, dft);
        }
        String k = this.normalizeKey(key);
        if (rtp.hasProperty((Object)k)) {
            return rtp.getBoolean(k, dft);
        }
        return RTConfig.getBoolean((String)k, (boolean)dft);
    }

    public boolean getBooleanProperty(String[] key, boolean dft) {
        RTProperties rtp = this.getDefaultProperties();
        if (rtp.hasProperty((Object[])key)) {
            return rtp.getBoolean(key, dft);
        }
        Object[] k = this.normalizeKeys(key);
        if (rtp.hasProperty(k)) {
            return rtp.getBoolean((String[])k, dft);
        }
        return RTConfig.getBoolean((String[])k, (boolean)dft);
    }

    public boolean getDigitalInputState(long mask, int bit) {
        int b;
        int ofs = this.getIntProperty("Attribute.inputOffset", -1);
        int n = b = ofs > 0 ? ofs - bit : bit;
        return b >= 0 ? (mask & 1L << b) != 0L : false;
    }

    public boolean getDigitalOutputState(long mask, int bit) {
        int b;
        int ofs = this.getIntProperty("Attribute.outputOffset", -1);
        int n = b = ofs > 0 ? ofs - bit : bit;
        return b >= 0 ? (mask & 1L << b) != 0L : false;
    }

    public boolean equals(Object other) {
        if (other instanceof DCServerConfig) {
            String thisName = this.getName();
            String otherName = ((DCServerConfig)other).getName();
            return thisName.equals(otherName);
        }
        return false;
    }

    public int compareTo(Object other) {
        if (other instanceof DCServerConfig) {
            String thisName = this.getName();
            String otherName = ((DCServerConfig)other).getName();
            return thisName.compareTo(otherName);
        }
        return -1;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean inclName) {
        StringBuffer sb = new StringBuffer();
        if (inclName) {
            sb.append("(").append(this.getName()).append(") ");
        }
        sb.append(this.getDescription()).append(" ");
        sb.append("[");
        this.getPortsString(sb);
        sb.append("]");
        return sb.toString();
    }

    public StringBuffer getPortsString(StringBuffer sb) {
        int cmd;
        int[] sat;
        int[] udp;
        if (sb == null) {
            sb = new StringBuffer();
        }
        int p = 0;
        int[] tcp = this.getTcpPorts();
        if (!ListTools.isEmpty((int[])tcp)) {
            if (p > 0) {
                sb.append(" ");
            }
            sb.append("TCP=" + StringTools.join((int[])tcp, (String)","));
            ++p;
        }
        if (!ListTools.isEmpty((int[])(udp = this.getUdpPorts()))) {
            if (p > 0) {
                sb.append(" ");
            }
            sb.append("UDP=" + StringTools.join((int[])udp, (String)","));
            ++p;
        }
        if (!ListTools.isEmpty((int[])(sat = this.getSatPorts()))) {
            if (p > 0) {
                sb.append(" ");
            }
            sb.append("SAT=" + StringTools.join((int[])sat, (String)","));
            ++p;
        }
        if ((cmd = this.getCommandDispatcherPort()) > 0) {
            if (p > 0) {
                sb.append(" ");
            }
            sb.append("CMD=" + cmd);
            ++p;
        }
        if (p == 0) {
            sb.append("no-ports");
        }
        return sb;
    }

    public String getPortsString() {
        return this.getPortsString(null).toString();
    }

    public File[] getRunningJarPath() {
        return DCServerConfig.getRunningJarPath(this.getName());
    }

    public static class FuelLevelProfile {
        private double evtLevel = 0.0;
        private double actLevel = 0.0;

        public FuelLevelProfile(String lvl) {
            Object[] L;
            if (!StringTools.isBlank((String)lvl) && ListTools.size((Object[])(L = StringTools.split((String)lvl, (char)','))) >= 2) {
                this.evtLevel = StringTools.parseDouble((String)L[0], (double)-1.0);
                this.actLevel = StringTools.parseDouble((String)L[1], (double)-1.0);
                if (this.evtLevel < 0.0 || this.evtLevel > 1.0 || this.actLevel < 0.0 || this.actLevel > 1.0) {
                    Print.logError((String)("Invalid FuelLevelProfile value: " + lvl), (Object[])new Object[0]);
                    this.evtLevel = 0.0;
                    this.actLevel = 0.0;
                }
            }
        }

        public FuelLevelProfile(double evLvl, double acLvl) {
            this.evtLevel = evLvl;
            this.actLevel = acLvl;
        }

        public double getEventLevel() {
            return this.evtLevel;
        }

        public double getActualLevel() {
            return this.actLevel;
        }
    }

    public static class CommandArg {
        private Command command = null;
        private String argName = "";
        private String argDesc = "";
        private boolean readOnly = false;
        private String resKey = null;
        private String dftVal = "";
        private int lenDisp = 70;
        private int lenMax = 500;

        public CommandArg(JSON._Object arg) {
            this.argName = arg.getStringForName(DCServerConfig.JSONKey_Name, "");
            this.argDesc = arg.getStringForName(DCServerConfig.JSONKey_Description, "");
            this.readOnly = arg.getBooleanForName(DCServerConfig.JSONKey_ReadOnly, false);
            this.resKey = arg.getStringForName(DCServerConfig.JSONKey_ResourceName, null);
            this.dftVal = arg.getStringForName(DCServerConfig.JSONKey_DefaultValue, "");
            this.lenDisp = arg.getIntForName(DCServerConfig.JSONKey_DisplayLength, 70);
            this.lenMax = arg.getIntForName(DCServerConfig.JSONKey_MaximumLength, 500);
        }

        public CommandArg(String name, String desc, boolean readOnly, String resKey, String dftVal) {
            this.argName = StringTools.trim((String)name);
            this.argDesc = StringTools.trim((String)desc);
            this.readOnly = readOnly;
            this.resKey = !StringTools.isBlank((String)resKey) ? resKey : null;
            this.dftVal = StringTools.trim((String)dftVal);
            this.lenDisp = 70;
            this.lenMax = 500;
        }

        public String getName() {
            return this.argName;
        }

        public String getDescription() {
            return this.argDesc;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setCommand(Command cmd) {
            this.command = cmd;
        }

        public Command getCommand() {
            return this.command;
        }

        public String getResourceName() {
            return this.resKey;
        }

        public String getDefaultValue() {
            return this.dftVal;
        }

        public void setLength(int dispLen, int maxLen) {
            this.lenDisp = dispLen > 0 ? dispLen : 70;
            this.lenMax = maxLen > 0 ? maxLen : this.lenDisp * 2;
        }

        public int getDisplayLength() {
            return this.lenDisp;
        }

        public int getMaximumLength() {
            return this.lenMax;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName()).append("/").append(StringTools.quoteString((String)this.getDescription()));
            return sb.toString();
        }

        public JSON._Object toJsonObject() {
            JSON._Object obj = new JSON._Object();
            obj.addKeyValue(DCServerConfig.JSONKey_Name, this.getName());
            obj.addKeyValue(DCServerConfig.JSONKey_Description, this.getDescription());
            obj.addKeyValue(DCServerConfig.JSONKey_ReadOnly, this.isReadOnly());
            obj.addKeyValue(DCServerConfig.JSONKey_ResourceName, this.getResourceName());
            obj.addKeyValue(DCServerConfig.JSONKey_DefaultValue, this.getDefaultValue());
            obj.addKeyValue(DCServerConfig.JSONKey_DisplayLength, this.getDisplayLength());
            obj.addKeyValue(DCServerConfig.JSONKey_MaximumLength, this.getMaximumLength());
            return obj;
        }
    }

    public static class Command {
        private String dcsName = "";
        private String cmdName = "";
        private String cmdDesc = "";
        private boolean isEnabled = true;
        private String[] types = null;
        private String aclName = "";
        private AclEntry.AccessLevel aclDft = AclEntry.AccessLevel.WRITE;
        private String cmdStr = "";
        private boolean hasArgs = false;
        private String cmdProto = "";
        private String protoHandlr = null;
        private long maxRouteAgeSec = -1L;
        private boolean allowQueue = false;
        private boolean expectAck = false;
        private int expAckCode = 0;
        private long stateMask = 0L;
        private boolean stateVal = false;
        private int cmdStCode = 0;
        private OrderedMap<String, CommandArg> argMap = null;

        public Command(String dcsName, JSON._Object obj) throws JSON.JSONParsingException {
            if (obj == null) {
                throw new JSON.JSONParsingException("JSON Object is null", null);
            }
            this.dcsName = StringTools.trim((String)dcsName);
            this.cmdName = obj.getStringForName(DCServerConfig.JSONKey_Name, "");
            this.cmdDesc = obj.getStringForName(DCServerConfig.JSONKey_Description, "");
            this.isEnabled = obj.getBooleanForName(DCServerConfig.JSONKey_Enabled, true);
            this.types = obj.getStringArrayForName(DCServerConfig.JSONKey_Types, null);
            this.aclName = obj.getStringForName(DCServerConfig.JSONKey_AclName, "");
            this.aclDft = AclEntry.parseAccessLevel(obj.getStringForName(DCServerConfig.JSONKey_AclDefault, null), AclEntry.AccessLevel.WRITE);
            String cmdProtoH = obj.getStringForName(DCServerConfig.JSONKey_Protocol, "");
            if (cmdProtoH.indexOf(":") >= 0) {
                int p = cmdProtoH.indexOf(":");
                this.cmdProto = StringTools.trim((String)cmdProtoH.substring(0, p));
                this.protoHandlr = StringTools.trim((String)cmdProtoH.substring(p + 1));
            } else {
                this.cmdProto = cmdProtoH;
                this.protoHandlr = null;
            }
            this.cmdStr = DCServerConfig.DecodeEscapeChars(obj.getStringForName(DCServerConfig.JSONKey_CommandString, ""));
            this.maxRouteAgeSec = obj.getLongForName(DCServerConfig.JSONKey_MaximumRouteAge, 0L);
            this.allowQueue = obj.getBooleanForName(DCServerConfig.JSONKey_AllowQueue, false);
            this.expectAck = obj.getBooleanForName(DCServerConfig.JSONKey_ExpectAck, false);
            this.expAckCode = obj.getIntForName(DCServerConfig.JSONKey_ExpectAckCode, 0);
            this.stateMask = obj.getLongForName(DCServerConfig.JSONKey_StateBitMask, 0L);
            this.stateVal = obj.getBooleanForName(DCServerConfig.JSONKey_StateBitValue, true);
            this.cmdStCode = obj.getIntForName(DCServerConfig.JSONKey_AuditCode, 0);
            JSON._Array args = obj.getArrayForName(DCServerConfig.JSONKey_Args, null);
            if (!ListTools.isEmpty((Collection)args)) {
                this.hasArgs = true;
                this.argMap = new OrderedMap();
                for (int i = 0; i < args.size(); ++i) {
                    JSON._Object arg = args.getObjectValueAt(i, null);
                    if (arg == null) {
                        throw new JSON.JSONParsingException("Command '" + this.cmdName + "': Invalid Arg at #" + i, null);
                    }
                    CommandArg cmdArg = new CommandArg(arg);
                    cmdArg.setCommand(this);
                    this.argMap.put((Object)cmdArg.getName(), (Object)cmdArg);
                }
            } else {
                this.hasArgs = this.cmdStr.indexOf("${") >= 0;
            }
        }

        public Command(String dcsName, String cmdName, String desc, boolean enable, String[] types, String aclName, AclEntry.AccessLevel aclDft, String cmdStr, boolean hasArgs, Collection<CommandArg> cmdArgs, String cmdProtoH, long maxRteAge, boolean allowQueue, boolean expectAck, int expAckCode, long stateMask, boolean stateVal, int cmdStCode) {
            this.dcsName = StringTools.trim((String)dcsName);
            this.cmdName = StringTools.trim((String)cmdName);
            this.cmdDesc = StringTools.trim((String)desc);
            this.isEnabled = enable;
            this.types = types != null ? types : new String[]{};
            this.aclName = StringTools.trim((String)aclName);
            this.aclDft = aclDft != null ? aclDft : AclEntry.AccessLevel.WRITE;
            this.cmdStr = DCServerConfig.DecodeEscapeChars(cmdStr);
            this.hasArgs = hasArgs || this.cmdStr.indexOf("${") >= 0;
            cmdProtoH = StringTools.trim((String)cmdProtoH);
            if (cmdProtoH.indexOf(":") >= 0) {
                int p = cmdProtoH.indexOf(":");
                this.cmdProto = StringTools.trim((String)cmdProtoH.substring(0, p));
                this.protoHandlr = StringTools.trim((String)cmdProtoH.substring(p + 1));
            } else {
                this.cmdProto = cmdProtoH;
                this.protoHandlr = null;
            }
            this.maxRouteAgeSec = maxRteAge;
            this.allowQueue = allowQueue;
            this.expectAck = expectAck;
            this.expAckCode = expAckCode > 0 ? expAckCode : 0;
            this.stateMask = stateMask;
            this.stateVal = stateVal;
            int n = this.cmdStCode = cmdStCode > 0 ? cmdStCode : 0;
            if (!ListTools.isEmpty(cmdArgs) && this.hasArgs) {
                this.argMap = new OrderedMap();
                for (CommandArg arg : cmdArgs) {
                    arg.setCommand(this);
                    this.argMap.put((Object)arg.getName(), (Object)arg);
                }
            }
        }

        public String getServerName() {
            return this.dcsName;
        }

        public String getName() {
            return this.cmdName;
        }

        public String getDescription() {
            return this.cmdDesc;
        }

        public boolean isEnabled(BasicPrivateLabel privLabel) {
            String rtKey;
            String dcsn = this.getServerName();
            if (privLabel != null && !StringTools.isBlank((String)dcsn) && privLabel.hasProperty(rtKey = "DCServer." + dcsn + "." + "Command." + this.getName() + "." + "enabled")) {
                boolean cmdEna = privLabel.getBooleanProperty(rtKey, true);
                return cmdEna;
            }
            return this.isEnabled;
        }

        public String[] getTypes() {
            return this.types;
        }

        public boolean isType(String type) {
            if (DCServerFactory.isCommandTypeAll(type)) {
                return true;
            }
            if (ListTools.isEmpty((Object[])this.types)) {
                return true;
            }
            return ListTools.contains((Object[])this.types, (Object)type);
        }

        public String getAclName() {
            return this.aclName;
        }

        public AclEntry.AccessLevel getAclAccessLevelDefault() {
            return this.aclDft;
        }

        public String getCommandString() {
            return this.cmdStr;
        }

        private String _adjustKeyArg(String V, String keyArg) {
            if (!StringTools.isBlank((String)keyArg)) {
                String ka = keyArg.trim().toLowerCase();
                if (ListTools.contains((Object[])KEYARG_HEX8, (Object)ka)) {
                    long v = StringTools.parseLong((String)V, (long)0L) & 0xFFL;
                    return "0x" + StringTools.toHexString((long)v, (int)8);
                }
                if (ListTools.contains((Object[])KEYARG_HEX16, (Object)ka)) {
                    long v = StringTools.parseLong((String)V, (long)0L) & 0xFFFFL;
                    return "0x" + StringTools.toHexString((long)v, (int)16);
                }
                if (ListTools.contains((Object[])KEYARG_HEX32, (Object)ka)) {
                    long v = StringTools.parseLong((String)V, (long)0L) & 0xFFFFFFFFL;
                    return "0x" + StringTools.toHexString((long)v, (int)32);
                }
                if (ListTools.contains((Object[])KEYARG_HEX64, (Object)ka)) {
                    long v = StringTools.parseLong((String)V, (long)0L);
                    return "0x" + StringTools.toHexString((long)v, (int)64);
                }
                if (ListTools.contains((Object[])KEYARG_INT, (Object)ka)) {
                    return String.valueOf(StringTools.parseLong((String)V, (long)0L));
                }
                if (ListTools.contains((Object[])KEYARG_NOSPACE, (Object)ka)) {
                    return StringTools.stripChars((String)V, (String)" \t\r\n");
                }
                if (ListTools.contains((Object[])KEYARG_QUOTE, (Object)ka)) {
                    return StringTools.quoteString((String)V);
                }
                if (ListTools.contains((Object[])KEYARG_GPS, (Object)ka)) {
                    GeoPoint gp = new GeoPoint(V, GP_SEP);
                    return gp.toString();
                }
                if (ListTools.contains((Object[])KEYARG_GPLAT, (Object)ka)) {
                    GeoPoint gp = new GeoPoint(V, GP_SEP);
                    return gp.getLatitudeString();
                }
                if (ListTools.contains((Object[])KEYARG_GPLON, (Object)ka)) {
                    GeoPoint gp = new GeoPoint(V, GP_SEP);
                    return gp.getLongitudeString();
                }
                if (StringTools.isNumeric((String)ka)) {
                    int p = StringTools.indexOf((String)V, (char[])CSV_SEP);
                    int n = StringTools.parseInt((String)ka, (int)-1);
                    if (n < 0) {
                        return V;
                    }
                    if (p < 0) {
                        return n == 0 ? V : "";
                    }
                    String[] f = StringTools.split((String)V, (char)V.charAt(p));
                    return n < f.length ? f[n] : "";
                }
            }
            return V;
        }

        public String getCommandString(Device device, String[] cmdArgs) {
            String cs = this.getCommandString();
            if (this.hasCommandArgs()) {
                String rcs;
                final String[] args = cmdArgs != null ? cmdArgs : new String[]{};
                cs = rcs = StringTools.replaceKeys((String)cs, (StringTools.KeyValueMap)new StringTools.KeyValueMap(){

                    public String getKeyValue(String key, String keyArg, String dft) {
                        int argNdx;
                        int n = argNdx = Command.this.argMap != null ? Command.this.argMap.indexOfKey((Object)key) : -1;
                        if (argNdx >= 0 && argNdx < args.length) {
                            String V = !StringTools.isBlank((String)args[argNdx]) ? args[argNdx] : dft;
                            return Command.this._adjustKeyArg(V, keyArg);
                        }
                        if (key.equals(DCServerConfig.DEFAULT_ARG_NAME)) {
                            String V = args.length > 0 && !StringTools.isBlank((String)args[0]) ? args[0] : dft;
                            return Command.this._adjustKeyArg(V, keyArg);
                        }
                        for (int i = 0; i < args.length; ++i) {
                            if (!key.equals(DCServerConfig.DEFAULT_ARG_NAME + i)) continue;
                            String V = !StringTools.isBlank((String)args[i]) ? args[i] : dft;
                            return Command.this._adjustKeyArg(V, keyArg);
                        }
                        return Command.this._adjustKeyArg(dft, keyArg);
                    }
                });
            }
            if (device != null) {
                String dataKey = device.getDataKey();
                String uniqueID = device.getUniqueID();
                String modemID = device.getModemID();
                String imeiNum = device.getImeiNumber();
                String serial = device.getSerialNumber();
                cs = SMSOutboundGateway.REPLACE(cs, SMSOutboundGateway.REPL_dataKey, dataKey);
                cs = SMSOutboundGateway.REPLACE(cs, SMSOutboundGateway.REPL_uniqueID, uniqueID);
                cs = SMSOutboundGateway.REPLACE(cs, SMSOutboundGateway.REPL_modemID, modemID);
                cs = SMSOutboundGateway.REPLACE(cs, SMSOutboundGateway.REPL_imei, imeiNum);
                cs = SMSOutboundGateway.REPLACE(cs, SMSOutboundGateway.REPL_serial, serial);
            }
            return cs;
        }

        public boolean hasCommandArgs() {
            return this.hasArgs;
        }

        public int getArgCount() {
            if (!this.hasArgs) {
                return 0;
            }
            if (this.argMap != null) {
                return this.argMap.size();
            }
            return 1;
        }

        public CommandArg getCommandArg(int argNdx) {
            if (this.hasArgs && this.argMap != null) {
                return (CommandArg)this.argMap.getValue(argNdx);
            }
            return null;
        }

        public CommandProtocol getCommandProtocol() {
            return this.getCommandProtocol(null);
        }

        public CommandProtocol getCommandProtocol(CommandProtocol dftProto) {
            if (!StringTools.isBlank((String)this.cmdProto)) {
                return DCServerConfig.getCommandProtocol(this.cmdProto);
            }
            return dftProto;
        }

        public boolean isCommandProtocolSMS() {
            CommandProtocol proto = this.getCommandProtocol(null);
            return proto != null && proto.isSMS();
        }

        public String getCommandProtocolHandler() {
            return this.protoHandlr;
        }

        public boolean hasMaximumRouteAge() {
            return this.maxRouteAgeSec > 0L;
        }

        public long getMaximumRouteAge() {
            return this.maxRouteAgeSec;
        }

        public boolean queueIfUndelivered() {
            return this.allowQueue;
        }

        public boolean getExpectAck() {
            return this.expectAck;
        }

        public int getExpectAckCode() {
            return this.expAckCode;
        }

        public boolean hasStateBitMask() {
            return this.stateMask != 0L;
        }

        public long getStateBitMask() {
            return this.stateMask;
        }

        public boolean getStateBitValue() {
            return this.stateVal;
        }

        public boolean hasAuditStatusCode() {
            return this.cmdStCode != 0;
        }

        public int getAuditStatusCode() {
            return this.cmdStCode;
        }

        public boolean setDeviceCommandAttributes(DCServerFactory.ResultCode result, Device device, String cmdStr, boolean update) {
            if (DCServerFactory.isCommandResultOK(result) && device != null) {
                return device.postCommandHandling(this, cmdStr, update);
            }
            return false;
        }

        public JSON._Object toJsonObject() {
            JSON._Object obj = new JSON._Object();
            obj.addKeyValue(DCServerConfig.JSONKey_Name, this.getName());
            obj.addKeyValue(DCServerConfig.JSONKey_Description, this.getDescription());
            obj.addKeyValue(DCServerConfig.JSONKey_Enabled, this.isEnabled(null));
            obj.addKeyValue(DCServerConfig.JSONKey_Types, new JSON._Array(this.getTypes()).setFormatIndent(false));
            obj.addKeyValue(DCServerConfig.JSONKey_AclName, this.getAclName());
            obj.addKeyValue(DCServerConfig.JSONKey_AclDefault, this.getAclAccessLevelDefault().getIntValue());
            if (this.hasMaximumRouteAge()) {
                obj.addKeyValue(DCServerConfig.JSONKey_MaximumRouteAge, this.getMaximumRouteAge());
            }
            obj.addKeyValue(DCServerConfig.JSONKey_AllowQueue, this.queueIfUndelivered());
            if (this.getExpectAck()) {
                obj.addKeyValue(DCServerConfig.JSONKey_ExpectAck, this.getExpectAck());
                obj.addKeyValue(DCServerConfig.JSONKey_ExpectAckCode, this.getExpectAckCode());
            }
            if (this.hasStateBitMask()) {
                obj.addKeyValue(DCServerConfig.JSONKey_StateBitMask, this.getStateBitMask());
                obj.addKeyValue(DCServerConfig.JSONKey_StateBitValue, this.getStateBitValue());
            }
            if (this.hasAuditStatusCode()) {
                obj.addKeyValue(DCServerConfig.JSONKey_AuditCode, this.getAuditStatusCode());
            }
            obj.addKeyValue(DCServerConfig.JSONKey_Protocol, StringTools.trim((Object)((Object)this.getCommandProtocol())));
            obj.addKeyValue(DCServerConfig.JSONKey_CommandString, this.getCommandString());
            if (this.hasCommandArgs() && !ListTools.isEmpty(this.argMap)) {
                JSON._Array jsonArgArray = new JSON._Array();
                for (int i = 0; i < this.getArgCount(); ++i) {
                    CommandArg cmdArg = this.getCommandArg(i);
                    if (cmdArg != null) {
                        jsonArgArray.addValue(cmdArg.toJsonObject());
                        continue;
                    }
                    if (this.argMap == null || i >= this.argMap.size()) continue;
                    JSON._Object argObj = new JSON._Object();
                    argObj.addKeyValue(DCServerConfig.JSONKey_Name, DCServerConfig.DEFAULT_ARG_NAME + i);
                    jsonArgArray.addValue(argObj);
                }
                obj.addKeyValue(DCServerConfig.JSONKey_Args, jsonArgArray);
            }
            return obj;
        }
    }

    public static class EventDataAnalogField {
        private int index = 0;
        private double gain = 9.765625E-4;
        private double offset = 0.0;
        private DBField dbField = null;

        public EventDataAnalogField(int ndx, double gain, double offset) {
            this(ndx, gain, offset, null);
        }

        public EventDataAnalogField(int ndx, double gain, double offset, String fieldN) {
            this.index = ndx;
            this.gain = gain;
            this.offset = offset;
            this.setFieldName(fieldN);
            Print.logInfo((String)("New AnalogField[" + this.index + "]: " + this), (Object[])new Object[0]);
        }

        public EventDataAnalogField(int ndx, String gof, double dftGain, double dftOffset) {
            this.index = ndx;
            String[] v = StringTools.split((String)gof, (char)',');
            this.gain = v.length >= 1 ? StringTools.parseDouble((String)v[0], (double)dftGain) : dftGain;
            this.offset = v.length >= 2 ? StringTools.parseDouble((String)v[1], (double)dftOffset) : dftOffset;
            this.setFieldName(v.length >= 3 ? StringTools.blankDefault((String)v[2], null) : null);
            Print.logInfo((String)("New AnalogField[" + this.index + "]: " + this), (Object[])new Object[0]);
        }

        public int getIndex() {
            return this.index;
        }

        public void setGain(double gain) {
            this.gain = gain;
        }

        public double getGain() {
            return this.gain;
        }

        public void setOffset(double offset) {
            this.offset = offset;
        }

        public double getOffset() {
            return this.offset;
        }

        public double convert(long value) {
            return this.convert((double)value);
        }

        public double convert(double value) {
            return value * this.gain + this.offset;
        }

        public void setFieldName(String fieldN) {
            this.dbField = null;
            if (!StringTools.isBlank((String)fieldN)) {
                DBField dbf = EventData.getFactory().getField(fieldN);
                if (dbf == null) {
                    Print.logError((String)("**** EventData analog field does not exist: " + fieldN), (Object[])new Object[0]);
                } else {
                    this.dbField = dbf;
                    Object val = this.getValueObject(0.0);
                    if (val == null) {
                        Print.logError((String)("**** EventData field type not supported: " + fieldN), (Object[])new Object[0]);
                        this.dbField = null;
                    }
                }
            }
        }

        public DBField getDBField() {
            return this.dbField;
        }

        public String getFieldName() {
            return this.dbField != null ? this.dbField.getName() : null;
        }

        public Object getValueObject(double value) {
            DBField dbf = this.getDBField();
            if (dbf == null) {
                return null;
            }
            Class dbfc = dbf.getTypeClass();
            if (dbfc == String.class) {
                return String.valueOf(value);
            }
            if (dbfc == Integer.class || dbfc == Integer.TYPE) {
                return new Integer((int)value);
            }
            if (dbfc == Long.class || dbfc == Long.TYPE) {
                return new Long((long)value);
            }
            if (dbfc == Float.class || dbfc == Float.TYPE) {
                return new Float((float)value);
            }
            if (dbfc == Double.class || dbfc == Double.TYPE) {
                return new Double(value);
            }
            if (dbfc == Boolean.class || dbfc == Boolean.TYPE) {
                return new Boolean(value != 0.0);
            }
            return null;
        }

        public boolean saveEventDataFieldValue(EventData evdb, double value) {
            Object objVal;
            if (evdb != null && (objVal = this.getValueObject(value)) != null) {
                String fn = this.getFieldName();
                boolean ok = evdb.setFieldValue(fn, objVal);
                Print.logInfo((String)("Set AnalogField[" + this.getIndex() + "]: " + fn + " ==> " + (ok ? evdb.getFieldValue(fn) : "n/a")), (Object[])new Object[0]);
                return ok;
            }
            return false;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("index=").append(this.getIndex());
            sb.append(" gain=").append(this.getGain());
            sb.append(" offset=").append(this.getOffset());
            sb.append(" field=").append(this.getFieldName());
            return sb.toString();
        }
    }

    public static class EventCode {
        private int oldCode = 0;
        private int statusCode = 0;
        private String dataString = null;
        private long dataLong = Long.MIN_VALUE;

        public EventCode(int oldCode, int statusCode, String data) {
            this.oldCode = oldCode;
            this.statusCode = statusCode;
            this.dataString = data;
            this.dataLong = StringTools.parseLong((String)data, (long)Long.MIN_VALUE);
        }

        public int getCode() {
            return this.oldCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getDataString(String dft) {
            return !StringTools.isBlank((String)this.dataString) ? this.dataString : dft;
        }

        public long getDataLong(long dft) {
            return this.dataLong != Long.MIN_VALUE ? this.dataLong : dft;
        }

        public String toString() {
            return StringTools.toHexString((long)this.getCode(), (int)16) + " ==> 0x" + StringTools.toHexString((long)this.getStatusCode(), (int)16);
        }
    }

    public static enum CommandProtocol implements EnumTools.IsDefault,
    EnumTools.IntValue
    {
        UDP(0, "udp"),
        TCP(1, "tcp"),
        SMS(9, "sms");

        private int vv = 0;
        private String ss = "";

        private CommandProtocol(int v, String s) {
            this.vv = v;
            this.ss = s;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.ss;
        }

        public boolean isDefault() {
            return this.equals((Object)UDP);
        }

        public boolean isSMS() {
            return this.equals((Object)SMS);
        }
    }
}

