/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.opengts.StartupInit;
import org.opengts.Version;
import org.opengts.db.AccountRecord;
import org.opengts.db.AclEntry;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.SystemProps;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.StringTools;

public class DBConfig {
    private static final String DEFAULT_DB_NAME = "gts";
    private static final String PACKAGE_OPENGTS_ = "org.opengts.";
    private static final String PACKAGE_TABLES_ = "org.opengts.db.tables.";
    private static final String PACKAGE_DMTP_ = "org.opengts.db.dmtp.";
    public static final String PACKAGE_OPT = "org.opengts.opt";
    public static final String PACKAGE_OPT_ = "org.opengts.opt.";
    public static final String PACKAGE_OPT_AUDIT_ = "org.opengts.opt.audit.";
    public static final String PACKAGE_OPT_WAR_ = "org.opengts.opt.war.";
    public static final String PACKAGE_EXTRA_ = "org.opengts.extra.";
    private static final String PACKAGE_EXTRA_TABLES = "org.opengts.extra.tables";
    public static final String PACKAGE_EXTRA_TABLES_ = "org.opengts.extra.tables.";
    public static final String PACKAGE_EXTRA_DBTOOLS_ = "org.opengts.extra.dbtools.";
    public static final String PACKAGE_EXTRA_WAR_ = "org.opengts.extra.war.";
    public static final String PACKAGE_RULE_ = "org.opengts.rule.";
    public static final String PACKAGE_RULE_UTIL_ = "org.opengts.rule.util.";
    private static final String PACKAGE_RULE_TABLES = "org.opengts.rule.tables";
    public static final String PACKAGE_RULE_TABLES_ = "org.opengts.rule.tables.";
    public static final String CLASS_RULE_EventRuleFactory = "org.opengts.rule.EventRuleFactory";
    public static final String PACKAGE_BCROSS_ = "org.opengts.bcross.";
    public static final String PACKAGE_BCROSS_TABLES = "org.opengts.bcross.tables";
    public static final String PACKAGE_BCROSS_TABLES_ = "org.opengts.bcross.tables.";
    public static final String PACKAGE_WAR_ = "org.opengts.war.";
    public static final String PACKAGE_WAR_TRACK_ = "org.opengts.war.track.";
    public static final String AUTHKEYS_CONF = "authkeys.conf";
    private static final String[] SCHEMA_HEADER = new String[]{"This document contains database schema information for the tables defined within the OpenGTS system.  Optional tables (if any) will be indicated by the term \"[optional]\" next to the table name.", "", "Additional information may be obtained by examining the source module for the specified class.", "", "The schema listing below should match the installed configuration, however, there may still be minor differences depending on the specific version installed, or changes that have been made to the configuration.  The current schema configuration can be generated from the actual database configuration by executing the following command: ", "(executed from within the OpenGTS directory)", "", "   bin/dbAdmin.pl -schema", "", "Or, on Windows:", "", "   bin\\dbConfig.bat -schema"};
    private static final boolean DEFAULT_DEVICE_AUTHORIZATION = true;
    public static final String PROP_DCSServer_isRunningInDCS = "%DCServer.isRunningInDCS";
    public static final String PROP_ServiceAccount_ID = "ServiceAccount.ID";
    public static final String PROP_ServiceAccount_Name = "ServiceAccount.Name";
    public static final String PROP_ServiceAccount_Attr = "ServiceAccount.Attr";
    public static final String PROP_ServiceAccount_Key = "ServiceAccount.Key";
    public static final String PROP_StartupInit_class = "StartupInit.class";
    public static final String PROP_Account_smsEnabled = "Account.smsEnabled";
    public static final String PROP_Device_pastDate_action = "Device.pastDate.action";
    public static final String PROP_Device_pastDate_maximumSec = "Device.pastDate.maximumSec";
    public static final String PROP_Device_futureDate_action = "Device.futureDate.action";
    public static final String PROP_Device_futureDate_maximumSec = "Device.futureDate.maximumSec";
    public static final String PROP_Device_invalidSpeed_action = "Device.invalidSpeed.action";
    public static final String PROP_Device_invalidSpeed_maximumKPH = "Device.invalidSpeed.maximumKPH";
    public static final String PROP_Device_checkLastOdometer = "Device.checkLastOdometer";
    public static final String PROP_Device_maximumOdometerKM = "Device.maximumOdometerKM";
    public static final String PROP_Device_maximumRuntimeHours = "Device.maximumRuntimeHours";
    public static final String PROP_Device_keyedSimPhoneNumber = "Device.keyedSimPhoneNumber";
    public static final String PROP_Device_keyedLastNotifyTime = "Device.keyedLastNotifyTime";
    public static final String PROP_Device_checkNotifySelector = "Device.checkNotifySelector";
    public static final String PROP_Device_checkNotifySelector_ENRE = "Device.checkNotifySelector.ENRE";
    public static final String PROP_Device_maintenanceOdometerCount = "Device.maintenanceOdometerCount";
    public static final String PROP_Device_checkLastEventIgnitionState = "Device.checkLastEventIgnitionState";
    public static final String PROP_Device_simulateEngineHours = "Device.simulateEngineHours";
    public static final String PROP_Device_saveEventDriverID = "Device.saveEventDriverID";
    public static final String PROP_Device_updateEventWithGeozoneLoc = "Device.updateEventWithGeozoneLoc";
    public static final String PROP_Device_logMissingColumns = "Device.logMissingColumns";
    public static final String PROP_Device_checkAccountAllowNotify = "Device.checkAccountAllowNotify";
    public static final String PROP_Device_eventsPerSecond = "Device.eventsPerSecond";
    public static final String PROP_Device_maintenanceDescriptionKM_0 = "Device.maintenanceDescriptionKM.0";
    public static final String PROP_Device_maintenanceDescriptionKM_1 = "Device.maintenanceDescriptionKM.1";
    public static final String PROP_DeviceInfo_DeviceCmdAlternate_ = "DeviceInfo.DeviceCmdAlternate.";
    public static final String PROP_EventData_keyedAccountDeviceTime = "EventData.keyedAccountDeviceTime";
    public static final String PROP_EventData_keyedCreationTime = "EventData.keyedCreationTime";
    public static final String PROP_EventData_logMissingColumns = "EventData.logMissingColumns";
    public static final String PROP_EventData_odometerOffsetType = "EventData.odometerOffsetType";
    public static final String PROP_Geozone_dftRadius_pointRadius = "Geozone.dftRadius.pointRadius";
    public static final String PROP_Geozone_dftRadius_polygon = "Geozone.dftRadius.polygon";
    public static final String PROP_Geozone_dftRadius_sweptPointRadius = "Geozone.dftRadius.sweptPointRadius";
    public static final String PROP_RuleList_includeGroupRules = "RuleList.includeGroupRules";
    public static final String PROP_FuelRegister_installFuelManager = "FuelRegister.installFuelManager";
    public static final String PROP_FuelRegister_ignoreNegativeFuelLevels = "FuelRegister.ignoreNegativeFuelLevels";
    public static final String PROP_FuelRegister_ignoreZeroFuelLevels = "FuelRegister.ignoreZeroFuelLevels";
    public static final String PROP_FuelRegister_ignoreWhileMoving = "FuelRegister.ignoreWhileMoving";
    public static final String PROP_FuelRegister_levelIncreaseThreshold = "FuelRegister.levelIncreaseThreshold";
    public static final String PROP_FuelRegister_levelDecreaseThreshold = "FuelRegister.levelDecreaseThreshold";
    public static final String PROP_PendingCommands_keyedSendState = "PendingCommands.keyedSendState";
    public static final String PROP_track_baseURI = "track.baseURI";
    public static final String PROP_track_requireCookies = "track.requireCookies";
    public static final String PROP_track_js_directory = "track.js.directory";
    public static final String PROP_track_offlineFile = "track.offlineFile";
    public static final String PROP_track_enableService = "track.enableService";
    public static final String PROP_track_service_customCommandHandler = "track.service.customCommandHandler";
    public static final String PROP_track_service_commandEnabled_ = "track.service.commandEnabled.";
    public static final String PROP_track_service_authKey = "track.service.authKey";
    public static final String PROP_track_service_AccessControlAllowOrigin = "track.service.AccessControlAllowOrigin";
    public static final String PROP_track_updateLastLoginTime_user = "track.updateLastLoginTime.user";
    public static final String PROP_track_updateLastLoginTime_account = "track.updateLastLoginTime.account";
    public static final String PROP_SubdivisionProvider_class = "SubdivisionProvider.class";
    public static final String PROP_EventFunctionMapFactory_class = "EventFunctionMapFactory.class";
    public static final String PROP_EventIdentifierMapFactory_class = "EventIdentifierMapFactory.class";
    public static final String PROP_Transport_queryEnabled = "Transport.queryEnabled";
    public static final String PROP_UniqueXID_queryEnabled = "UniqueXID.queryEnabled";
    public static final String PROP_db_defaultDeviceAuthorization = "db.defaultDeviceAuthorization";
    public static final String PROP_db_defaultDeviceAuthorization_ = "db.defaultDeviceAuthorization.";
    public static final String PROP_sysAdmin_account = "sysAdmin.account";
    public static final String PROP_GoogleKML_pushpinBaseURL = "GoogleKML.pushpinBaseURL";
    protected static RTKey.Entry[] runtimeKeys = new RTKey.Entry[]{new RTKey.Entry("Custom GTS Properties"), new RTKey.Entry("ServiceAccount.ID", (Object)"opengts", "ServiceAccount ID"), new RTKey.Entry("ServiceAccount.Name", (Object)"OpenGTS", "ServiceAccount Name"), new RTKey.Entry("ServiceAccount.Attr", (Object)"", "ServiceAccount Attributes"), new RTKey.Entry("ServiceAccount.Key", (Object)"", "ServiceAccount Key"), new RTKey.Entry("StartupInit.class", null, "Startup Initialization class"), new RTKey.Entry("Device.futureDate.action", (Object)"", "Future Date Action"), new RTKey.Entry("Device.futureDate.maximumSec", -1L, "Future Date Maximm Seconds"), new RTKey.Entry("Device.invalidSpeed.action", (Object)"", "Invalid Speed Action"), new RTKey.Entry("Device.invalidSpeed.maximumKPH", 0.0, "Future Date Maximm Seconds"), new RTKey.Entry("Device.maximumOdometerKM", 1000000.0, "Maximum Odometer value"), new RTKey.Entry("Device.maximumRuntimeHours", 262800.0, "Maximum Runtime hours value"), new RTKey.Entry("EventData.keyedCreationTime", false, "Keyed 'EventData.creationTime'"), new RTKey.Entry("Geozone.dftRadius.pointRadius", 3000, "Default Point Radius"), new RTKey.Entry("Geozone.dftRadius.polygon", 500, "Default Polygon Radius"), new RTKey.Entry("Geozone.dftRadius.sweptPointRadius", 1000, "Default SweptPoint Radius"), new RTKey.Entry("RuleList.includeGroupRules", false, "Include DeviceGroup rules"), new RTKey.Entry("FuelRegister.installFuelManager", false, "Install FuelRegister/FuelManager"), new RTKey.Entry("FuelRegister.ignoreNegativeFuelLevels", true, "Ignore Negative Fuel Levels"), new RTKey.Entry("FuelRegister.ignoreZeroFuelLevels", true, "Ignore Zero Fuel Levels"), new RTKey.Entry("FuelRegister.ignoreWhileMoving", false, "Ignore Fuel Levels While Moving"), new RTKey.Entry("FuelRegister.levelIncreaseThreshold", 0.5, "FuelLevel 'increase' threshold"), new RTKey.Entry("FuelRegister.levelDecreaseThreshold", 0.3, "FuelLevel 'decrease' threshold"), new RTKey.Entry("track.baseURI", null, "'Track' Base URI"), new RTKey.Entry("track.requireCookies", true, "'Track' Require Enabled Cookies"), new RTKey.Entry("track.js.directory", (Object)"./js", "'Track' JavaScript Directory"), new RTKey.Entry("track.offlineFile", null, "'Track' Offline File"), new RTKey.Entry("track.enableService", false, "'Track' Enable 'Service'"), new RTKey.Entry("track.service.customCommandHandler", null, "'Service' custom command handler"), new RTKey.Entry("SubdivisionProvider.class", null, "SubdivisionProvider class"), new RTKey.Entry("EventFunctionMapFactory.class", null, "EventFunctionMapFactory subclass"), new RTKey.Entry("EventIdentifierMapFactory.class", null, "EventIdentifierMapFactory subclass"), new RTKey.Entry("Transport.queryEnabled", false, "Enable DB Transport query"), new RTKey.Entry("UniqueXID.queryEnabled", false, "Enable DB UniqueXID query"), new RTKey.Entry("db.defaultDeviceAuthorization", true, "Default Device Authoirization"), new RTKey.Entry("sysAdmin.account", (Object)"", "System Admin Account ID")};
    public static final String env_GTS_HOME = "GTS_HOME";
    private static boolean _didPreInit = false;
    private static boolean _didPostInit = false;
    private static boolean _didServletInit = false;
    private static final String[] ARG_INIT_TABLES = new String[]{"initTables"};
    private static final String[] ARG_ACCOUNT = new String[]{"account"};
    private static final String[] ARG_NEW_ACCOUNT = new String[]{"newAccount", "account"};
    private static final String[] ARG_NEW_DEVICE = new String[]{"newDevice"};
    private static final String[] ARG_TREE = new String[]{"tree"};
    public static final String[] ARG_SCHEMA = new String[]{"schema"};
    private static final String[] ARG_CREATE_SYSADMIN = new String[]{"createSysAdmin"};
    public static final String[] ARG_STATUS = new String[]{"status"};
    public static final String[] ARG_WHERE = new String[]{"where"};

    public static final String AUTHKEY_DCS_CONF(String dcs) {
        return "authkey_" + dcs + ".conf";
    }

    public static boolean hasExtraPackage() {
        return Package.getPackage(PACKAGE_EXTRA_TABLES) != null;
    }

    public static boolean hasRulePackage() {
        return Package.getPackage(PACKAGE_RULE_TABLES) != null;
    }

    public static boolean hasBCrossPackage() {
        return Package.getPackage(PACKAGE_BCROSS_TABLES) != null;
    }

    public static boolean hasOptPackage() {
        return Package.getPackage(PACKAGE_OPT) != null;
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static boolean GetDefaultDeviceAuthorization(String acctID) {
        String idKey;
        if (!StringTools.isBlank((String)acctID) && RTConfig.hasProperty((String)(idKey = PROP_db_defaultDeviceAuthorization_ + acctID))) {
            return RTConfig.getBoolean((String)idKey, (boolean)true);
        }
        return RTConfig.getBoolean((String)PROP_db_defaultDeviceAuthorization, (boolean)true);
    }

    public static File get_GTS_HOME() {
        String gtsStr = System.getenv(env_GTS_HOME);
        if (!StringTools.isBlank((String)gtsStr)) {
            try {
                File gtsDir = new File(gtsStr);
                return gtsDir.getCanonicalFile();
            }
            catch (Throwable th) {
                Print.logWarn((String)"Error attempting to obtain GTS_HOME environment varable", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static boolean check_GTS_HOME() {
        File dir;
        File gtsDir = null;
        File curDir = null;
        try {
            String gtsStr = System.getenv(env_GTS_HOME);
            if (StringTools.isBlank((String)gtsStr)) {
                Print.logWarn((String)"GTS_HOME environment variable is not defined", (Object[])new Object[0]);
                return false;
            }
            gtsDir = new File(gtsStr);
            try {
                gtsDir = dir = gtsDir.getCanonicalFile();
            }
            catch (Throwable th) {}
        }
        catch (Throwable th) {
            Print.logWarn((String)"Error attempting to obtain GTS_HOME environment varable", (Object[])new Object[0]);
            return false;
        }
        try {
            String curStr = System.getProperty("user.dir", "");
            if (StringTools.isBlank((String)curStr)) {
                Print.logWarn((String)"'user.dir' system property is not defined", (Object[])new Object[0]);
                return false;
            }
            curDir = new File(curStr);
            try {
                curDir = dir = curDir.getCanonicalFile();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable th) {
            Print.logWarn((String)"Error attempting to determine current directory", (Object[])new Object[0]);
            return false;
        }
        if (!curDir.equals(gtsDir)) {
            Print.logWarn((String)"Warning: GTS_HOME directory does not match current directory!", (Object[])new Object[0]);
            Print.logWarn((String)("GTS_HOME   : " + gtsDir), (Object[])new Object[0]);
            Print.logWarn((String)("Current Dir: " + curDir), (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public static void addTableFactories() {
        String[] workZoneTables;
        String[] bcrossTables;
        String[] ruleTables;
        String[] dmtpTables;
        String[] extraTables;
        String[] standardTables;
        for (String tableClassName : standardTables = new String[]{"org.opengts.db.tables.Account", "org.opengts.db.tables.AccountString", "org.opengts.db.tables.User", "org.opengts.db.tables.UserAcl", "org.opengts.db.tables.GroupList", "org.opengts.db.tables.Device", "org.opengts.db.tables.Transport", "org.opengts.db.tables.UniqueXID", "org.opengts.db.tables.DeviceGroup", "org.opengts.db.tables.DeviceList", "org.opengts.db.tables.Driver", "org.opengts.db.tables.EventData", "org.opengts.db.tables.Geozone", "org.opengts.db.tables.Resource", "org.opengts.db.tables.Role", "org.opengts.db.tables.RoleAcl", "org.opengts.db.tables.StatusCode", "org.opengts.db.tables.SystemProps"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)true);
        }
        for (String tableClassName : extraTables = new String[]{"org.opengts.extra.tables.Antx", "org.opengts.extra.tables.Entity", "org.opengts.extra.tables.ReportJob", "org.opengts.extra.tables.SessionStats", "org.opengts.extra.tables.UnassignedDevices", "org.opengts.extra.tables.PendingCommands", "org.opengts.extra.tables.PointsOfInterest", "org.opengts.extra.tables.SystemAudit"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)false);
        }
        for (String tableClassName : dmtpTables = new String[]{"org.opengts.db.dmtp.EventTemplate", "org.opengts.db.dmtp.PendingPacket", "org.opengts.db.dmtp.Property", "org.opengts.db.dmtp.Diagnostic"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)false);
        }
        for (String tableClassName : ruleTables = new String[]{"org.opengts.rule.tables.Rule", "org.opengts.rule.tables.RuleList", "org.opengts.rule.tables.RuleTrigger", "org.opengts.rule.tables.GeoCorridor", "org.opengts.rule.tables.GeoCorridorList", "org.opengts.rule.tables.NotifyQueue", "org.opengts.rule.tables.FuelRegister"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)false);
        }
        for (String tableClassName : bcrossTables = new String[]{"org.opengts.bcross.tables.BorderCrossing"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)false);
        }
        for (String tableClassName : workZoneTables = new String[]{"org.opengts.extra.tables.WorkOrder", "org.opengts.extra.tables.WorkOrderSample", "org.opengts.extra.tables.WorkZone", "org.opengts.extra.tables.WorkZoneList"}) {
            DBAdmin.addTableFactory((String)tableClassName, (boolean)false);
        }
    }

    private static void _initDBFactories(Object startupInit) {
        if (startupInit instanceof DBFactory.CustomFactoryHandler) {
            DBFactory.setCustomFactoryHandler((DBFactory.CustomFactoryHandler)((DBFactory.CustomFactoryHandler)startupInit));
        }
        if (startupInit instanceof DBInitialization) {
            try {
                ((DBInitialization)startupInit).addTableFactories();
            }
            catch (Throwable th) {
                Print.logException((String)"'<DBConfig.DBInitialization>.addTableFactories' failed!", (Throwable)th);
            }
        } else {
            DBConfig.addTableFactories();
        }
        if (DBAdmin.getTableFactoryCount() <= 0) {
            Print.logStackTrace((String)"No DBFactory classes have been registered!!");
        }
        DBFactory.setCustomFactoryHandler(null);
    }

    private static boolean _dbPreInit() {
        if (_didPreInit) {
            return false;
        }
        _didPreInit = true;
        RTKey.addRuntimeEntries((RTKey.Entry[])runtimeKeys);
        Version.initVersionProperty();
        return true;
    }

    private static boolean _dbPostInit() {
        if (_didPostInit) {
            return false;
        }
        _didPostInit = true;
        String dbName = RTConfig.getString((String)"db.sql.dbname", null);
        if (dbName == null || dbName.equals("") || dbName.equals("?")) {
            RTConfig.setString((String)"db.sql.dbname", (String)DEFAULT_DB_NAME);
        }
        StartupInit startupInit = null;
        String initClassName = RTConfig.getString((String)PROP_StartupInit_class);
        if (!StringTools.isBlank((String)initClassName)) {
            try {
                Class<?> cfgClass = Class.forName(initClassName);
                startupInit = cfgClass.newInstance();
            }
            catch (Throwable th) {
                Print.logException((String)("Unable to load Startup initializer: " + initClassName), (Throwable)th);
                startupInit = new StartupInit();
            }
        } else {
            startupInit = new StartupInit();
        }
        if (startupInit instanceof DBInitialization) {
            ((DBInitialization)startupInit).preInitialization();
        }
        DBConfig._initDBFactories(startupInit);
        BasicPrivateLabelLoader.loadPrivateLabelXML();
        if (startupInit instanceof DBInitialization) {
            ((DBInitialization)startupInit).postInitialization();
        }
        DCServerFactory.init();
        Collection<String> bplList = BasicPrivateLabelLoader.getPrivateLabelNames(true);
        for (String bplName : bplList) {
            BasicPrivateLabel bpl = BasicPrivateLabelLoader.getPrivateLabel(bplName);
            AclEntry[] acls = bpl.getAllAclEntries();
            char[] dcsSep = new char[]{':', '.'};
            int pfxLen = "acl.dcs.".length();
            for (AclEntry aclEntry : acls) {
                int p;
                String dcsName;
                DCServerConfig dcs;
                String aclName = aclEntry.getName();
                if (!aclName.startsWith("acl.dcs.") || (dcs = DCServerFactory.getServerConfig(dcsName = aclName.substring(pfxLen, (p = StringTools.indexOf((String)aclName, (int)pfxLen, (char[])dcsSep)) >= 0 ? p : aclName.length()))) != null) continue;
                bpl.removeAclEntry(aclName);
            }
        }
        Vector<AclEntry> dcsAclList = null;
        List<DCServerConfig> dcsList = DCServerFactory.getServerConfigList(false);
        if (!ListTools.isEmpty(dcsList)) {
            AclEntry.AccessLevel[] accLvlValues = new AclEntry.AccessLevel[]{AclEntry.AccessLevel.NONE, AclEntry.AccessLevel.WRITE};
            for (DCServerConfig dcs : dcsList) {
                Object[] cmdNames = dcs.getCommandList();
                if (ListTools.isEmpty((Object[])cmdNames)) continue;
                for (Object cn : cmdNames) {
                    DCServerConfig.Command cmd = dcs.getCommand((String)cn);
                    String aclName = cmd.getAclName();
                    I18N.Text aclDesc = new I18N.Text("${dcsDesc} (" + cmd.getDescription() + ")");
                    AclEntry.AccessLevel aclDft = cmd.getAclAccessLevelDefault();
                    AclEntry aclEntry = new AclEntry(aclName, aclDesc, accLvlValues, aclDft);
                    if (dcsAclList == null) {
                        dcsAclList = new Vector<AclEntry>();
                    }
                    dcsAclList.add(aclEntry);
                }
            }
        }
        if (!ListTools.isEmpty(dcsAclList)) {
            for (String bplName : bplList) {
                BasicPrivateLabel bpl = BasicPrivateLabelLoader.getPrivateLabel(bplName);
                OrderedMap aclMap = null;
                for (AclEntry aclEntry : dcsAclList) {
                    String aclName = aclEntry.getName();
                    if (bpl.hasAclEntry(aclName)) continue;
                    if (aclMap == null) {
                        aclMap = new OrderedMap();
                    }
                    aclMap.put(aclName, aclEntry);
                }
                if (ListTools.isEmpty(aclMap)) continue;
                bpl.addAclMap(null, (Map<String, AclEntry>)aclMap);
            }
        }
        return true;
    }

    public static void servletInit(Properties srvCtxProps) {
        if (_didServletInit) {
            return;
        }
        _didServletInit = true;
        RTConfig.setWebApp((boolean)true);
        DBConfig._dbPreInit();
        if (srvCtxProps == null) {
            Print.logWarn((String)"*** Servlet RTConfigContextListener was not configured propertly", (Object[])new Object[0]);
        }
        RTConfig.setServletContextProperties((Map)srvCtxProps);
        if (RTConfig.isDebugMode()) {
            Print.setLogLevel((int)6);
            Print.setLogHeaderLevel((int)6);
        }
        DBConfig._dbPostInit();
    }

    public static int cmdLineInit(String[] argv, boolean interactive) {
        boolean didPreInit = DBConfig._dbPreInit();
        int nextArg = RTConfig.setCommandLineArgs((String[])argv);
        if (interactive) {
            Print.setLogFile(null);
            if (RTConfig.isDebugMode()) {
                Print.setLogLevel((int)6);
                Print.setLogHeaderLevel((int)6);
            } else {
                Print.setLogHeaderLevel((int)3);
            }
            RTConfig.setBoolean((String)"log.include.date", (boolean)false);
            RTConfig.setBoolean((String)"log.include.frame", (boolean)true);
        } else if (RTConfig.isDebugMode()) {
            Print.setLogLevel((int)6);
            Print.setLogHeaderLevel((int)6);
        }
        if (didPreInit) {
            DBConfig._dbPostInit();
        }
        return nextArg;
    }

    public static String getServiceAccountID(String dft) {
        return RTConfig.getString((String)PROP_ServiceAccount_ID, (String)dft);
    }

    public static String getServiceAccountName(String dft) {
        return RTConfig.getString((String)PROP_ServiceAccount_Name, (String)dft);
    }

    public static String getServiceAccountAttributes(String dft) {
        return RTConfig.getString((String)PROP_ServiceAccount_Attr, (String)dft);
    }

    private static void usage(String msg, boolean exit) {
        if (!StringTools.isBlank((String)msg)) {
            Print.sysPrintln((String)msg, (Object[])new Object[0]);
        }
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + DBConfig.class.getName() + " [-rootUser=<user> [-rootPass=<password>]] {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  Validating tables/columns:", (Object[])new Object[0]);
        Print.sysPrintln((String)"     -tables[=<flags(below)>]", (Object[])new Object[0]);
        Print.sysPrintln((String)"         't' - create missing tables [default]", (Object[])new Object[0]);
        Print.sysPrintln((String)"         'c' - add missing columns", (Object[])new Object[0]);
        Print.sysPrintln((String)"         'a' - alter columns with changed types", (Object[])new Object[0]);
        Print.sysPrintln((String)"         'w' - display warnings", (Object[])new Object[0]);
        Print.sysPrintln((String)"         'u' - check column character-encoding (must be used with 'a' or 'w')", (Object[])new Object[0]);
        Print.sysPrintln((String)"         's' - show columns", (Object[])new Object[0]);
        Print.sysPrintln((String)"  Loading tables from a CSV file:", (Object[])new Object[0]);
        Print.sysPrintln((String)"     -load=<TableName>[.csv] -dir=<Source_Dir> [-overwrite]", (Object[])new Object[0]);
        Print.sysPrintln((String)"  Displaying the DB schema:", (Object[])new Object[0]);
        Print.sysPrintln((String)"     -schema[=<TableName>]", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        if (exit) {
            System.exit(1);
        }
    }

    private static void _displayDependencyTree(int level, DBFactory fact) {
        if (fact != null) {
            String lvlStr = StringTools.replicateString((String)"  ", (int)level);
            Print.sysPrintln((String)(lvlStr + "- " + fact.getUntranslatedTableName()), (Object[])new Object[0]);
            DBFactory[] children = fact.getChildFactories();
            for (int i = 0; i < children.length; ++i) {
                DBFactory child = children[i];
                DBConfig._displayDependencyTree(level + 1, children[i]);
            }
        }
    }

    public static int _main(String[] argv) {
        String acctID;
        int execCmd;
        DBAdmin.DBAdminExec dbExecStatus;
        DBConfig.cmdLineInit(argv, true);
        if (Print.getLogLevel() < 3) {
            Print.setLogLevel((int)3);
        }
        Print.sysPrintln((String)("Version: " + Version.getVersion()), (Object[])new Object[0]);
        if (!RTConfig.hasProperty((String[])DBAdmin.ARG_ROOT_USER)) {
            RTConfig.setString((String)DBAdmin.ARG_ROOT_USER[0], (String)"root");
            RTConfig.setString((String)DBAdmin.ARG_ROOT_PASS[0], (String)"");
        } else if (!RTConfig.hasProperty((String[])DBAdmin.ARG_ROOT_PASS)) {
            RTConfig.setString((String)DBAdmin.ARG_ROOT_PASS[0], (String)"");
        }
        if (RTConfig.hasProperty((String[])ARG_INIT_TABLES)) {
            RTConfig.setBoolean((String)DBAdmin.ARG_CREATE_DB[0], (boolean)true);
            RTConfig.setBoolean((String)DBAdmin.ARG_GRANT[0], (boolean)true);
            if (!RTConfig.hasProperty((String[])DBAdmin.ARG_TABLES)) {
                String tableOptions = RTConfig.getString((String[])ARG_INIT_TABLES, (String)"");
                RTConfig.setString((String)DBAdmin.ARG_TABLES[0], (String)tableOptions);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_ACCOUNT)) {
            String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
            DBWhere dwh = new DBWhere(Account.getFactory());
            RTConfig.setString((String)DBAdmin.ARG_WHERE[0], (String)dwh.WHERE_(dwh.EQ("accountID", (Object)accountID)));
        }
        if (RTConfig.hasProperty((String[])ARG_SCHEMA)) {
            String schemaTable = RTConfig.getString((String[])ARG_SCHEMA, null);
            DBAdmin.printTableSchema((int)95, (String[])SCHEMA_HEADER, (String)schemaTable);
            return 0;
        }
        if (RTConfig.hasProperty((String[])ARG_STATUS)) {
            String statusTable = RTConfig.getString((String[])ARG_STATUS, null);
            try {
                DBFactory dbf = DBFactory.getFactoryByName((String)statusTable);
                if (dbf == null) {
                    throw new DBException("Table not found: " + statusTable);
                }
                String where = RTConfig.getString((String[])ARG_WHERE, (String)"");
                long startMS = System.currentTimeMillis();
                long rowCnt = dbf.getRecordCount(where, true);
                long endMS = System.currentTimeMillis();
                long deltaMS = endMS - startMS;
                String rowCntS = null;
                rowCntS = rowCnt < 0L ? "n/a" : (!dbf.isMySQLInnoDB() ? String.valueOf(rowCnt) : (StringTools.isBlank((String)where) ? "~" + rowCnt : rowCnt + " [where " + where + "]"));
                Print.sysPrintln((String)("Table  : " + statusTable), (Object[])new Object[0]);
                Print.sysPrintln((String)("Engine : " + dbf.getIndexType()), (Object[])new Object[0]);
                Print.sysPrintln((String)("Rows   : " + rowCntS), (Object[])new Object[0]);
                Print.sysPrintln((String)("Time   : " + deltaMS + " ms"), (Object[])new Object[0]);
                return 0;
            }
            catch (DBException dbe) {
                Print.logException((String)"Table Status", (Throwable)dbe);
                return 99;
            }
        }
        if (RTConfig.hasProperty((String[])DBAdmin.ARG_TABLES)) {
            String options = RTConfig.getString((String[])DBAdmin.ARG_TABLES, (String)"").trim().toLowerCase();
            String utableName = RTConfig.getString((String[])DBAdmin.ARG_TABLENAME, null);
            if (StringTools.isBlank((String)utableName) && options.indexOf("x") >= 0) {
                RTConfig.setString((String)DBAdmin.ARG_TABLENAME[0], (String)"EventData");
            }
        }
        if ((dbExecStatus = DBAdmin.execCommands()) == null || dbExecStatus.equals((Object)DBAdmin.DBAdminExec.ERROR)) {
            return 1;
        }
        if (!dbExecStatus.equals((Object)DBAdmin.DBAdminExec.WARN) && dbExecStatus.equals((Object)DBAdmin.DBAdminExec.EXIT)) {
            return 0;
        }
        int n = execCmd = dbExecStatus.equals((Object)DBAdmin.DBAdminExec.NONE) ? 0 : 1;
        if (RTConfig.hasProperty((String[])DBAdmin.ARG_TABLES)) {
            ++execCmd;
            SystemProps.updateVersions();
        }
        if (RTConfig.hasProperty((String[])ARG_CREATE_SYSADMIN)) {
            ++execCmd;
            String sysAdminAcct = AccountRecord.getSystemAdminAccountID();
            String sysAdminPass = StringTools.blankDefault((String)RTConfig.getString((String[])ARG_CREATE_SYSADMIN, null), (String)"syspass");
            Print.sysPrintln((String)("Creating '" + sysAdminAcct + "' Account ..."), (Object[])new Object[0]);
            try {
                if (StringTools.isBlank((String)sysAdminAcct)) {
                    Print.sysPrintln((String)"  WARNING: No SysAdmin Account-ID defined!", (Object[])new Object[0]);
                } else if (Account.exists(sysAdminAcct)) {
                    Print.sysPrintln((String)("  WARNING: SysAdmin account already exists: " + sysAdminAcct), (Object[])new Object[0]);
                } else {
                    Account.createNewAccount(null, sysAdminAcct, sysAdminPass);
                    Print.sysPrintln((String)("  Created 'sysadmin' Account with password: " + sysAdminPass), (Object[])new Object[0]);
                }
            }
            catch (Throwable th) {
                Print.logException((String)"Error creating 'sysadmin' account", (Throwable)th);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_NEW_ACCOUNT)) {
            ++execCmd;
            acctID = RTConfig.getString((String[])ARG_NEW_ACCOUNT, null);
            if (!StringTools.isBlank((String)acctID)) {
                try {
                    Account.createNewAccount(null, acctID, "*blank*");
                    Print.sysPrintln((String)("Created account:" + acctID), (Object[])new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logException((String)("Error creating account: " + acctID), (Throwable)dbe);
                }
            } else {
                Print.sysPrintln((String)"WARNING: New Account name not specified. Account creation ignored.", (Object[])new Object[0]);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_NEW_DEVICE)) {
            ++execCmd;
            acctID = RTConfig.getString((String[])ARG_NEW_ACCOUNT, null);
            if (acctID != null && !acctID.equals("")) {
                String devID = RTConfig.getString((String[])ARG_NEW_DEVICE, null);
                if (devID != null && !devID.equals("")) {
                    try {
                        Account account = Account.getAccount(acctID);
                        if (account == null) {
                            throw new DBException("Account not found");
                        }
                        Device.createNewDevice(account, devID, null);
                        Print.sysPrintln((String)("Created device: " + acctID + "," + devID), (Object[])new Object[0]);
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Error creating account:device: " + acctID + "," + devID), (Throwable)dbe);
                    }
                } else {
                    Print.sysPrintln((String)"WARNING: New Device name not specified. Device creation ignored.", (Object[])new Object[0]);
                }
            } else {
                Print.sysPrintln((String)"WARNING: New Account name not specified. Device creation ignored.", (Object[])new Object[0]);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_TREE)) {
            ++execCmd;
            Print.sysPrintln((String)"Table dependency tree:", (Object[])new Object[0]);
            DBConfig._displayDependencyTree(0, DBAdmin.getTableFactory((String)Account.TABLE_NAME()));
        }
        if (execCmd <= 0) {
            DBConfig.usage("", false);
            return 1;
        }
        return 0;
    }

    public static void main(String[] argv) {
        System.exit(DBConfig._main(argv));
    }

    public static interface DBInitialization {
        public void preInitialization();

        public void addTableFactories();

        public void postInitialization();
    }
}

