/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.net.InetAddress;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public abstract class CommandPacketHandler
extends AbstractClientPacketHandler {
    public static final String ARG_ACCOUNT = "account";
    public static final String ARG_DEVICE = "device";
    public static final String ARG_USER = "user";
    public static final String ARG_CMDTYPE = "cmdtype";
    public static final String ARG_CMDNAME = "cmdname";
    public static final String[] ARG_ARG0 = new String[]{"arg0", "arg"};
    public static final String ARG_ARG1 = "arg1";
    public static final String ARG_ARG2 = "arg2";
    public static final String ARG_ARG3 = "arg3";
    public static final String ARG_ARG4 = "arg4";
    public static final String ARG_ARG5 = "arg5";
    public static final String ARG_ARG6 = "arg6";
    public static final String ARG_ARG7 = "arg7";
    public static final String ARG_ARG8 = "arg8";
    public static final String ARG_ARG9 = "arg9";
    public static final String[] CMD_ARGS = new String[]{ARG_ARG0[0], "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7", "arg8", "arg9"};
    public static final String ARG_SERVER = "server";
    public static final String ARG_IP = "ip";
    public static final String ARG_PHONE = "phone";
    public static final String ARG_LASTCONNECT = "lastConnect";
    public static final String ARG_RESULT = "result";
    public static final String ARG_MESSAGE = "message";
    public static final String INTERNCMD_COMMANDS = "%COMMANDS%";
    public static final String INTERNCMD_STACKTRACE = "%STACKTRACE%";
    public static final String INTERNCMD_SESSIONS = "%SESSIONS%";
    private boolean terminate = false;
    private long sessionStartTime = 0L;
    private InetAddress inetAddress = null;
    private String ipAddress = null;
    private static Thread.State[] ThreadStateSortOrder = new Thread.State[]{Thread.State.RUNNABLE, Thread.State.NEW, Thread.State.WAITING, Thread.State.TIMED_WAITING, Thread.State.BLOCKED, Thread.State.TERMINATED};

    public static RTProperties setResult(RTProperties rtp, DCServerFactory.ResultCode result) {
        return CommandPacketHandler._setResult(1, rtp, result);
    }

    private static RTProperties _setResult(int frame, RTProperties rtp, DCServerFactory.ResultCode result) {
        if (rtp != null && result != null) {
            rtp.setString(ARG_RESULT, result.getCode());
            rtp.setString(ARG_MESSAGE, result.toString());
            if (!result.isSuccess()) {
                String msg = "Command Error: " + result.getCode() + " - " + result.getMessage();
                Print._log((int)2, (int)(frame + 1), (String)msg, (Object[])new Object[0]);
            }
        }
        return rtp;
    }

    protected static byte[] RESULT(RTProperties rtp, DCServerFactory.ResultCode result) {
        CommandPacketHandler._setResult(1, rtp, result);
        return (rtp.toString() + "\n").getBytes();
    }

    public abstract String getServerName();

    public abstract DCServerFactory.ResultCode handleCommand(Device var1, String var2, String var3, String[] var4);

    public int getResponsePort() {
        return super.getLocalPort();
    }

    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        this.sessionStartTime = DateTime.getCurrentTimeSec();
        this.inetAddress = inetAddr;
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        Print.logInfo((String)("---- Begin Command Packet Handler: " + this.ipAddress), (Object[])new Object[0]);
    }

    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        Print.logInfo((String)("---- End Command Packet Handler: " + this.ipAddress), (Object[])new Object[0]);
        try {
            Thread.sleep(10L);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    public void setTerminateSession() {
        this.terminate = true;
    }

    public boolean getTerminateSession() {
        return this.terminate;
    }

    public boolean terminateSession() {
        return this.getTerminateSession();
    }

    public byte[] getHandlePacket(byte[] pktBytes) {
        if (!ListTools.isEmpty((byte[])pktBytes)) {
            String cmd = StringTools.toStringValue((byte[])pktBytes);
            this.setTerminateSession();
            return this.parseCommand(cmd);
        }
        return null;
    }

    public static RTProperties EncodeCommand(String cmdType, String cmdName, String[] cmdArgs) {
        RTProperties cmdRTP = new RTProperties();
        cmdRTP.setName("Command");
        cmdRTP.setString(ARG_CMDTYPE, cmdType);
        cmdRTP.setString(ARG_CMDNAME, cmdName);
        if (!ListTools.isEmpty((Object[])cmdArgs)) {
            for (int i = 0; i < cmdArgs.length; ++i) {
                if (cmdArgs[i] == null) continue;
                cmdRTP.setString(CMD_ARGS[i], cmdArgs[i]);
            }
        }
        return cmdRTP;
    }

    private byte[] parseCommand(String cmd) {
        int maxNdx;
        RTProperties rtCmd = new RTProperties(cmd);
        Print.logInfo((String)("Command: " + rtCmd), (Object[])new Object[0]);
        String accountID = rtCmd.getString(ARG_ACCOUNT, null);
        String deviceID = rtCmd.getString(ARG_DEVICE, null);
        String userID = rtCmd.getString(ARG_USER, null);
        String cmdType = rtCmd.getString(ARG_CMDTYPE, null);
        String cmdName = rtCmd.getString(ARG_CMDNAME, null);
        String cmdArg0 = rtCmd.getString(ARG_ARG0, null);
        String cmdArg1 = rtCmd.getString(ARG_ARG1, null);
        String cmdArg2 = rtCmd.getString(ARG_ARG2, null);
        String cmdArg3 = rtCmd.getString(ARG_ARG3, null);
        String cmdArg4 = rtCmd.getString(ARG_ARG4, null);
        String cmdArg5 = rtCmd.getString(ARG_ARG5, null);
        String cmdArg6 = rtCmd.getString(ARG_ARG6, null);
        String cmdArg7 = rtCmd.getString(ARG_ARG7, null);
        String cmdArg8 = rtCmd.getString(ARG_ARG8, null);
        String cmdArg9 = rtCmd.getString(ARG_ARG9, null);
        Account account = null;
        if (!StringTools.isBlank((String)accountID)) {
            accountID = accountID.trim();
            try {
                account = Account.getAccount(accountID);
            }
            catch (DBException dbe) {
                if (dbe.isCauseCommunicationsException()) {
                    Print.logWarn((String)"CommunicationsException while reading Account (trying again) ...", (Object[])new Object[0]);
                    try {
                        account = Account.getAccount(accountID);
                    }
                    catch (DBException dbe2) {
                        Print.logError((String)("Unable to read Account: " + (Object)((Object)dbe2)), (Object[])new Object[0]);
                        account = null;
                    }
                }
                Print.logError((String)("Unable to read Account: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                account = null;
            }
            if (account == null) {
                Print.logError((String)"Account not found: '%s'", (Object[])new Object[]{accountID});
                return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.INVALID_ACCOUNT);
            }
            Print.logDebug((String)"Found Account: [%s] %s", (Object[])new Object[]{account.getAccountID(), account.getDescription()});
        }
        User user = null;
        if (account != null && !StringTools.isBlank((String)userID)) {
            userID = userID.trim();
            try {
                user = User.getUser(account, userID);
            }
            catch (DBException dbe) {
                if (dbe.isCauseCommunicationsException()) {
                    Print.logWarn((String)"CommunicationsException while reading Device (trying again) ...", (Object[])new Object[0]);
                    try {
                        user = User.getUser(account, userID);
                    }
                    catch (DBException dbe2) {
                        Print.logError((String)("Unable to read User: " + (Object)((Object)dbe2)), (Object[])new Object[0]);
                        user = null;
                    }
                }
                Print.logError((String)("Unable to read User: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                user = null;
            }
        }
        Device device = null;
        if (account != null && !StringTools.isBlank((String)deviceID)) {
            deviceID = deviceID.trim();
            try {
                device = Device.getDevice(account, deviceID);
            }
            catch (DBException dbe) {
                if (dbe.isCauseCommunicationsException()) {
                    Print.logWarn((String)"CommunicationsException while reading Device (trying again) ...", (Object[])new Object[0]);
                    try {
                        device = Device.getDevice(account, deviceID);
                    }
                    catch (DBException dbe2) {
                        Print.logError((String)("Unable to read Device: " + (Object)((Object)dbe2)), (Object[])new Object[0]);
                        device = null;
                    }
                }
                Print.logError((String)("Unable to read Device: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                device = null;
            }
        }
        if (cmdType != null && cmdType.equalsIgnoreCase("internal")) {
            cmdName = StringTools.trim((String)cmdName);
            String dcsName = this.getServerName();
            DCServerConfig dcs = DCServerFactory.getServerConfig(dcsName);
            if (cmdName.equalsIgnoreCase(INTERNCMD_COMMANDS)) {
                if (dcs == null) {
                    Print.logError((String)("DCS not found: " + dcsName), (Object[])new Object[0]);
                    return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.NOT_SUPPORTED);
                }
                BasicPrivateLabel privLabel = Account.getPrivateLabel(account);
                CommandPacketHandler._setResult(0, rtCmd, DCServerFactory.ResultCode.SUCCESS);
                StringBuffer sb = new StringBuffer();
                sb.append(rtCmd.toString()).append("\n");
                JSON._Object cmdJson = dcs.getCommands_JSON(privLabel, user, cmdType);
                if (cmdJson != null) {
                    sb.append(cmdJson.toString());
                    sb.append("\n");
                }
                return sb.toString().getBytes();
            }
            if (cmdName.equalsIgnoreCase(INTERNCMD_STACKTRACE)) {
                List thList = null;
                Map<Thread, StackTraceElement[]> stMap = null;
                try {
                    stMap = Thread.getAllStackTraces();
                    thList = ListTools.toList(stMap.keySet(), new Vector());
                    ListTools.sort((List)thList, (Comparator)new Comparator<Thread>(){

                        @Override
                        public int compare(Thread t1, Thread t2) {
                            int th2State;
                            if (t1 == t2) {
                                return 0;
                            }
                            if (t1 == null) {
                                return 1;
                            }
                            if (t2 == null) {
                                return -1;
                            }
                            int th1State = ListTools.indexOf((Object[])ThreadStateSortOrder, (Object)((Object)t1.getState()));
                            if (th1State == (th2State = ListTools.indexOf((Object[])ThreadStateSortOrder, (Object)((Object)t2.getState())))) {
                                ThreadGroup g1 = t1.getThreadGroup();
                                ThreadGroup g2 = t2.getThreadGroup();
                                int groupComp = g1.getName().compareTo(g2.getName());
                                if (groupComp == 0) {
                                    return t1.getName().compareTo(t2.getName());
                                }
                                return groupComp;
                            }
                            return th1State < th2State ? -1 : 1;
                        }
                    });
                }
                catch (Throwable th) {
                    Print.logException((String)("Thread Stacktrace Error: " + dcsName), (Throwable)th);
                    return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.NOT_SUPPORTED);
                }
                StringBuffer sb = new StringBuffer();
                String SEPnl = "----------------------------------------------------------------\n";
                CommandPacketHandler._setResult(0, rtCmd, DCServerFactory.ResultCode.SUCCESS);
                sb.append(rtCmd.toString()).append("\n");
                sb.append(SEPnl);
                sb.append("DCS: ").append(dcsName).append("\n");
                sb.append(OSTools.getMemoryUsageStringMb()).append("\n");
                sb.append(SEPnl);
                ThreadPool.GetThreadPoolState((StringBuffer)sb);
                int thNdx = 0;
                for (Thread th : thList) {
                    StackTraceElement[] st = stMap.get(th);
                    ThreadGroup thGroup = th.getThreadGroup();
                    String name = StringTools.quoteString((String)(thGroup.getName() + ":" + th.getName()));
                    long thID = th.getId();
                    boolean thAlive = th.isAlive();
                    Thread.State thState = th.getState();
                    int thPri = th.getPriority();
                    sb.append(SEPnl);
                    sb.append(thNdx++).append(") ");
                    sb.append("Thread: ");
                    sb.append(StringTools.trim((Object)((Object)thState)));
                    sb.append(" Name=").append(name);
                    sb.append(", ID=").append(thID);
                    sb.append(", Priority=").append(thPri);
                    if (!thAlive) {
                        sb.append("(dead)");
                    }
                    sb.append("\n");
                    for (int f = 0; f < st.length; ++f) {
                        sb.append("  ");
                        sb.append(f).append(") ");
                        String className = st[f].getClassName();
                        String fileName = st[f].getFileName();
                        int lineNumber = st[f].getLineNumber();
                        String methodName = st[f].getMethodName();
                        sb.append(st[f].toString());
                        sb.append("\n");
                    }
                }
                String s = sb.toString();
                return s.getBytes();
            }
            if (cmdName.equalsIgnoreCase(INTERNCMD_SESSIONS)) {
                try {
                    String tsaName = "org.opengts.opt.servers.TrackServerAdapter";
                    Class<?> tsaClass = Class.forName(tsaName);
                    MethodAction maTsaSessLog = new MethodAction(tsaClass, "GetActiveSessionsLog", new Class[]{StringBuffer.class});
                    String SEPnl = "----------------------------------------------------------------\n";
                    CommandPacketHandler._setResult(0, rtCmd, DCServerFactory.ResultCode.SUCCESS);
                    StringBuffer sb = new StringBuffer();
                    sb.append(rtCmd.toString()).append("\n");
                    sb.append(SEPnl);
                    sb.append("DCS: ").append(dcsName).append("\n");
                    sb.append(OSTools.getMemoryUsageStringMb()).append("\n");
                    sb.append(SEPnl);
                    maTsaSessLog.invoke(new Object[]{sb});
                    String s = sb.toString();
                    return s.getBytes();
                }
                catch (Throwable th) {
                    Print.logError((String)("Active Sessions Error [" + dcsName + "] " + th), (Object[])new Object[0]);
                    return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.NOT_SUPPORTED);
                }
            }
            Print.logError((String)("Invalid Internal Command: Type=" + cmdType + ", Name=" + cmdName), (Object[])new Object[0]);
            return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.INVALID_COMMAND);
        }
        if (StringTools.isBlank((String)cmdType)) {
            Print.logError((String)("Invalid Command: Type=" + cmdType + ", Name=" + cmdName), (Object[])new Object[0]);
            return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.INVALID_COMMAND);
        }
        if (device == null) {
            Print.logError((String)"Device not found: '%s/%s'", (Object[])new Object[]{accountID, deviceID});
            return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.INVALID_DEVICE);
        }
        Print.logDebug((String)"Found Device: [%s:%s] %s", (Object[])new Object[]{device.getDeviceID(), device.getUniqueID(), device.getDescription()});
        rtCmd.setString(ARG_SERVER, device.getDeviceCode());
        String[] cmdArgs = new String[]{cmdArg0, cmdArg1, cmdArg2, cmdArg3, cmdArg4, cmdArg5, cmdArg6, cmdArg7, cmdArg8, cmdArg9};
        for (maxNdx = cmdArgs.length - 1; maxNdx >= 0 && cmdArgs[maxNdx] == null; --maxNdx) {
        }
        if (maxNdx < 0) {
            cmdArgs = new String[]{};
        } else if (maxNdx < cmdArgs.length - 1) {
            String[] newArgs = new String[maxNdx + 1];
            System.arraycopy(cmdArgs, 0, newArgs, 0, newArgs.length);
            cmdArgs = newArgs;
        }
        DCServerFactory.ResultCode result = this.handleCommand(device, cmdType, cmdName, cmdArgs);
        if (result != null) {
            return CommandPacketHandler.RESULT(rtCmd, result);
        }
        return CommandPacketHandler.RESULT(rtCmd, DCServerFactory.ResultCode.INVALID_COMMAND);
    }

    public static boolean validateAddress(String addr) {
        try {
            return SendMail.validateAddress((String)addr);
        }
        catch (Throwable t) {
            Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
            return false;
        }
    }

    public static boolean validateAddresses(String addrs) {
        try {
            return SendMail.validateAddresses((String)addrs);
        }
        catch (Throwable t) {
            Print.logWarn((String)("SendMail error: " + t), (Object[])new Object[0]);
            return false;
        }
    }

    public static String getFromEmailCommand(Account account) {
        return CommandPacketHandler.getFromEmailCommand(Account.getPrivateLabel(account));
    }

    public static String getFromEmailCommand(BasicPrivateLabel bpl) {
        if (bpl != null) {
            String email = bpl.getEMailAddress("command");
            return bpl.getSmtpProperties().getUserEmail(email);
        }
        return SendMail.getDefaultUserEmail(null);
    }
}

