/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.db.AclEntry;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.PasswordHandler;
import org.opengts.db.StatusCodes;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicPrivateLabelLoader {
    public static boolean ALLOW_DOMAIN_INCLUDE = true;
    private static int DomainIncludeRecursionLevel = 0;
    public static boolean ALWAYS_LOAD_WAR_PRIVATELABEL = true;
    public static final String CLASS_Track = "org.opengts.war.track.Track";
    public static final String CLASS_Service = "org.opengts.extra.war.service.Service";
    public static final String CLASS_Celltrac = "org.opengts.opt.war.celltrac.Celltrac";
    public static final String CLASS_PrivateLabelLoader = "org.opengts.war.tools.PrivateLabelLoader";
    public static final String PRIVATE_LABEL_XML = "private.xml";
    public static final String TAG_LogMessage = "LogMessage";
    public static final String TAG_PrivateLabels = "PrivateLabels";
    public static final String TAG_SupportedLocales = "SupportedLocales";
    public static final String TAG_Locale = "Locale";
    public static final String TAG_TimeZones = "TimeZones";
    public static final String TAG_Domain = "Domain";
    public static final String TAG_Include = "Include";
    public static final String TAG_BaseURL = "BaseURL";
    public static final String TAG_Alias = "Alias";
    public static final String TAG_DefaultLoginAccount = "DefaultLoginAccount";
    public static final String TAG_DefaultLoginUser = "DefaultLoginUser";
    public static final String TAG_PageTitle = "PageTitle";
    public static final String TAG_Copyright = "Copyright";
    public static final String TAG_DateFormat = "DateFormat";
    public static final String TAG_TimeFormat = "TimeFormat";
    public static final String TAG_MapProvider = "MapProvider";
    public static final String TAG_Legend = "Legend";
    public static final String TAG_IconSelector = "IconSelector";
    public static final String TAG_PasswordHandler = "PasswordHandler";
    public static final String TAG_ReverseGeocodeProvider = "ReverseGeocodeProvider";
    public static final String TAG_GeocodeProvider = "GeocodeProvider";
    public static final String TAG_MobileLocationProvider = "MobileLocationProvider";
    public static final String TAG_I18N = "I18N";
    public static final String TAG_String = "String";
    public static final String TAG_Properties = "Properties";
    public static final String TAG_PropertyGroup = "PropertyGroup";
    public static final String TAG_Property = "Property";
    public static final String TAG_Pushpins = "Pushpins";
    public static final String TAG_Pushpin = "Pushpin";
    public static final String TAG_EMailAddresses = "EMailAddresses";
    public static final String TAG_EMailAddress = "EMailAddress";
    public static final String TAG_StatusCodes = "StatusCodes";
    public static final String TAG_StatusCode = "StatusCode";
    public static final String TAG_Acls = "Acls";
    public static final String TAG_Acl = "Acl";
    public static final String TAG_JSPEntries = "JSPEntries";
    public static final String TAG_JSP = "JSP";
    public static final String TAG_WebPages = "WebPages";
    public static final String TAG_MenuGroup = "MenuGroup";
    public static final String TAG_Title = "Title";
    public static final String TAG_Description = "Description";
    public static final String TAG_Page = "Page";
    public static final String TAG_Link = "Link";
    public static final String TAG_NavigationDescription = "NavigationDescription";
    public static final String TAG_NavigationTab = "NavigationTab";
    public static final String TAG_MenuDescription = "MenuDescription";
    public static final String TAG_MenuHelp = "MenuHelp";
    public static final String TAG_IconImage = "IconImage";
    public static final String TAG_ButtonImage = "ButtonImage";
    public static final String TAG_ButtonImageAlt = "ButtonImageAlt";
    public static final String TAG_AclName = "AclName";
    public static final String TAG_Reports = "Reports";
    public static final String TAG_Report = "Report";
    public static final String TAG_Options = "Options";
    public static final String TAG_Select = "Select";
    public static final String TAG_EventNotificationEMail = "EventNotificationEMail";
    public static final String TAG_Subject = "Subject";
    public static final String TAG_Body = "Body";
    public static final String TAG_PredefinedRuleActions = "PredefinedRuleActions";
    public static final String TAG_RuleAction = "RuleAction";
    public static final String TAG_ActionCommand = "ActionCommand";
    public static final String TAG_PointsOfInterest = "PointsOfInterest";
    public static final String TAG_POI = "POI";
    public static final String TAG_MapShapes = "MapShapes";
    public static final String TAG_Shape = "Shape";
    public static final String TAG_Points = "Points";
    public static final String ATTR_i18nPackage = "i18nPackage";
    public static final String ATTR_enabled = "enabled";
    public static final String ATTR_dir = "dir";
    public static final String ATTR_altDir = "altDir";
    public static final String ATTR_file = "file";
    public static final String ATTR_host = "host";
    public static final String ATTR_restricted = "restricted";
    public static final String ATTR_allowLogin = "allowLogin";
    public static final String ATTR_accountLogin = "accountLogin";
    public static final String ATTR_userLogin = "userLogin";
    public static final String ATTR_emailLogin = "emailLogin";
    public static final String ATTR_showPassword = "showPassword";
    public static final String ATTR_class = "class";
    public static final String ATTR_jsp = "jsp";
    public static final String ATTR_jspFile = "jspFile";
    public static final String ATTR_jspName = "jspName";
    public static final String ATTR_cssDir = "cssDir";
    public static final String ATTR_iconDir = "iconDir";
    public static final String ATTR_buttonDir = "buttonDir";
    public static final String ATTR_url = "url";
    public static final String ATTR_target = "target";
    public static final String ATTR_demo = "demo";
    public static final String ATTR_id = "id";
    public static final String ATTR_name = "name";
    public static final String ATTR_code = "code";
    public static final String ATTR_clear = "clear";
    public static final String ATTR_iconName = "iconName";
    public static final String ATTR_domainName = "domainName";
    public static final String ATTR_access = "access";
    public static final String ATTR_default = "default";
    public static final String ATTR_maximum = "maximum";
    public static final String ATTR_values = "values";
    public static final String ATTR_value = "value";
    public static final String ATTR_hidden = "hidden";
    public static final String ATTR_aclName = "aclName";
    public static final String ATTR_optional = "optional";
    public static final String ATTR_ignoreDuplicates = "ignoreDuplicates";
    public static final String ATTR_navigation = "navigation";
    public static final String ATTR_description = "description";
    public static final String ATTR_desc = "desc";
    public static final String ATTR_help = "help";
    public static final String ATTR_sort = "sort";
    public static final String ATTR_type = "type";
    public static final String ATTR_keyPrefix = "keyPrefix";
    public static final String ATTR_key = "key";
    public static final String ATTR_trim = "trim";
    public static final String ATTR_failover = "failover";
    public static final String ATTR_rtPropPrefix = "rtPropPrefix";
    public static final String ATTR_rtKey = "rtKey";
    public static final String ATTR_loggedIn = "loggedIn";
    public static final String ATTR_locale = "locale";
    public static final String ATTR_from = "from";
    public static final String ATTR_useAsDefault = "useAsDefault";
    public static final String ATTR_i18n = "i18n";
    public static final String ATTR_active = "active";
    public static final String ATTR_menuBar = "menuBar";
    public static final String ATTR_topMenu = "topMenu";
    public static final String ATTR_baseURL = "baseURL";
    public static final String ATTR_only = "only";
    public static final String ATTR_sysAdminOnly = "sysAdminOnly";
    public static final String ATTR_geocode = "geocode";
    public static final String ATTR_icon = "icon";
    public static final String ATTR_button = "button";
    public static final String ATTR_altButton = "altButton";
    public static final String ATTR_image = "image";
    public static final String ATTR_eval = "eval";
    public static final String ATTR_alias = "alias";
    public static final String ATTR_iconSize = "iconSize";
    public static final String ATTR_iconHotspot = "iconHotspot";
    public static final String ATTR_iconAnchor = "iconAnchor";
    public static final String ATTR_iconOffset = "iconOffset";
    public static final String ATTR_shadow = "shadow";
    public static final String ATTR_shadowSize = "shadowSize";
    public static final String ATTR_back = "back";
    public static final String ATTR_backSize = "backSize";
    public static final String ATTR_backOffset = "backOffset";
    public static final String ATTR_ruleFactoryName = "ruleFactoryName";
    public static final String ATTR_radius = "radius";
    public static final String ATTR_color = "color";
    public static final String ATTR_zoom = "zoom";
    public static final String ATTR_includeDefault = "includeDefault";
    private static OutputHandler outputHandler = null;
    protected static boolean _isTrackServlet = false;
    protected static BasicPrivateLabelLoader privateLabelLoader = null;
    private static ThreadLocal<BasicPrivateLabel> threadPrivateLabel = new ThreadLocal();
    private HashMap<String, BasicPrivateLabel> privateLabelMap = null;
    private BasicPrivateLabel defaultPrivateLabel = null;
    private boolean hasParsingWarnings = false;
    private boolean hasParsingErrors = false;
    public static boolean SAVE_I18N_STRINGS = false;
    public static Set<I18N.Text> I18N_STRINGS = null;
    public static Map<String, I18N.Text> I18N_STRINGS_MAP = null;

    public static void setOutputHandler(OutputHandler output) {
        outputHandler = output;
    }

    private static void _printOutputHandler(String h, String msg, Object ... args) {
        StringBuffer logMsg = new StringBuffer();
        if (h != null) {
            logMsg.append("[").append(h).append("] ");
        }
        if (msg != null) {
            if (args != null && args.length > 0) {
                try {
                    logMsg.append(String.format(msg, args));
                }
                catch (Throwable th) {
                    System.out.println("ERROR: [" + msg + "] " + th);
                    logMsg.append(msg);
                }
            } else {
                logMsg.append(msg);
            }
            if (!msg.endsWith("\n")) {
                logMsg.append("\n");
            }
        } else {
            logMsg.append("\n");
        }
        if (outputHandler != null) {
            outputHandler.privateLabelOutput(logMsg.toString());
        } else {
            Print.sysPrintln((String)logMsg.toString(), (Object[])new Object[0]);
        }
    }

    protected static void printError(String msg, Object ... args) {
        if (outputHandler != null) {
            if (Print.getLogLevel() >= 2) {
                BasicPrivateLabelLoader._printOutputHandler("ERROR", msg, args);
            }
        } else {
            Print.logError((String)msg, (Object[])args);
        }
    }

    protected static void printWarn(String msg, Object ... args) {
        if (outputHandler != null) {
            if (Print.getLogLevel() >= 3) {
                BasicPrivateLabelLoader._printOutputHandler("WARN", msg, args);
            }
        } else {
            Print.logWarn((String)msg, (Object[])args);
        }
    }

    protected static void printInfo(String msg, Object ... args) {
        if (outputHandler != null) {
            if (Print.getLogLevel() >= 4) {
                BasicPrivateLabelLoader._printOutputHandler("INFO", msg, args);
            }
        } else {
            Print.logInfo((String)msg, (Object[])args);
        }
    }

    protected static void printDebug(String msg, Object ... args) {
        if (outputHandler != null) {
            if (Print.getLogLevel() >= 5) {
                BasicPrivateLabelLoader._printOutputHandler("DEBUG", msg, args);
            }
        } else {
            Print.logDebug((String)msg, (Object[])args);
        }
    }

    public static void setTrackServlet_debugOnly() {
        BasicPrivateLabelLoader.setTrackServlet();
    }

    private static void setTrackServlet() {
        _isTrackServlet = true;
        BasicPrivateLabel.setTrackServlet_loaderOnly();
    }

    public static boolean isTrackServlet() {
        return _isTrackServlet;
    }

    protected static BasicPrivateLabelLoader _getInstance() {
        if (privateLabelLoader == null) {
            if (!BasicPrivateLabelLoader.isTrackServlet() && RTConfig.isWebApp()) {
                String[] cn = new String[]{CLASS_Track, CLASS_Service, CLASS_Celltrac};
                for (int i = 0; i < cn.length; ++i) {
                    try {
                        Class.forName(cn[i]);
                        BasicPrivateLabelLoader.setTrackServlet();
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (!BasicPrivateLabelLoader.isTrackServlet()) {
                    BasicPrivateLabelLoader.printInfo("Not a 'Track/Service' servlet", new Object[0]);
                }
            }
            if (ALWAYS_LOAD_WAR_PRIVATELABEL || BasicPrivateLabelLoader.isTrackServlet()) {
                try {
                    Class<?> pllClass = Class.forName(CLASS_PrivateLabelLoader);
                    privateLabelLoader = (BasicPrivateLabelLoader)pllClass.newInstance();
                }
                catch (Throwable th) {
                    if (BasicPrivateLabelLoader.isTrackServlet()) {
                        BasicPrivateLabelLoader.printError("PrivateLabelLoader not found, using BasicPrivateLabelLoader", new Object[0]);
                        Print.logException((String)"org.opengts.war.tools.PrivateLabelLoader not found, using BasicPrivateLabelLoader", (Throwable)th);
                    } else {
                        BasicPrivateLabelLoader.printDebug("Loading default BasicPrivateLabelLoader", new Object[0]);
                    }
                    privateLabelLoader = new BasicPrivateLabelLoader();
                }
            } else {
                privateLabelLoader = new BasicPrivateLabelLoader();
            }
            BasicPrivateLabelLoader.printDebug("PrivateLabelLoader class: " + StringTools.className((Object)privateLabelLoader), new Object[0]);
        }
        return privateLabelLoader;
    }

    public static Class getInstanceClass() {
        return BasicPrivateLabelLoader._getInstance().getClass();
    }

    public static File getPrivateXMLFile() {
        return BasicPrivateLabelLoader._getInstance()._getPrivateXMLFile();
    }

    public static int loadPrivateLabelXML() {
        return BasicPrivateLabelLoader._getInstance()._resetLoadDefaultXML();
    }

    public static int loadPrivateLabelXML(File xmlFile) {
        return BasicPrivateLabelLoader._getInstance()._resetLoadXML(xmlFile);
    }

    public static void setThreadPrivateLabel(BasicPrivateLabel bpl) {
        threadPrivateLabel.set(bpl);
    }

    public static BasicPrivateLabel getThreadPrivateLabel() {
        BasicPrivateLabel bpl = threadPrivateLabel.get();
        return bpl instanceof BasicPrivateLabel ? bpl : null;
    }

    protected static boolean _isAttributeActive(String active, String name) {
        if (StringTools.isBlank((String)active)) {
            return false;
        }
        if (StringTools.isBoolean((String)active, (boolean)true)) {
            return StringTools.parseBoolean((String)active, (boolean)false);
        }
        return active.equalsIgnoreCase(name);
    }

    protected BasicPrivateLabel createPrivateLabel(File xmlFile, String hostName) {
        return new BasicPrivateLabel(hostName);
    }

    protected File _getPrivateXMLFile() {
        File cfgFile = RTConfig.getLoadedConfigFile();
        if (cfgFile == null) {
            BasicPrivateLabelLoader.printError("Unable to locate parent config file directory", new Object[0]);
            this._setHasParsingErrors(cfgFile);
            return null;
        }
        File xmlFile = new File(cfgFile.getParentFile(), PRIVATE_LABEL_XML);
        return xmlFile;
    }

    protected int _resetLoadDefaultXML() {
        File xmlFile = this._getPrivateXMLFile();
        return this._resetLoadXML(xmlFile);
    }

    protected int _resetLoadXML(File xmlFile) {
        boolean isReload = this.privateLabelMap != null;
        this.privateLabelMap = null;
        this.defaultPrivateLabel = null;
        this.hasParsingErrors = false;
        RTProperties dftProps = null;
        RTProperties ovrProps = new RTProperties();
        int count = this._loadXML(xmlFile, dftProps, ovrProps, null, null, false);
        if (count == 0) {
            BasicPrivateLabelLoader.printError("Error loading: " + xmlFile, new Object[0]);
            this._setHasParsingErrors(xmlFile);
        } else if (this.defaultPrivateLabel == null) {
            BasicPrivateLabelLoader.printWarn("No default Domain has been defined (ie. host=\"*\"): " + xmlFile, new Object[0]);
            this._setHasParsingWarnings(xmlFile);
        } else if (isReload) {
            BasicPrivateLabelLoader.printDebug("Reloaded: " + xmlFile, new Object[0]);
        } else {
            BasicPrivateLabelLoader.printDebug("Loaded: " + xmlFile, new Object[0]);
        }
        return count;
    }

    protected int _loadXML(File xmlFile, RTProperties dftProps, RTProperties ovrProps, OrderedMap<String, Object> dftPushpinMap, OrderedMap<String, String> dftLegend, boolean ignoreDuplicates) {
        OrderedSet timeZones;
        OrderedMap<String, I18N.Text> locales;
        Document xmlDoc;
        BasicPrivateLabelLoader.printDebug("Loading PrivateLabel xml file: " + xmlFile, new Object[0]);
        Document document = xmlDoc = xmlFile != null ? XMLTools.getDocument((File)xmlFile) : null;
        if (xmlDoc == null) {
            BasicPrivateLabelLoader.printError("Unable to create XML Document from file: " + xmlFile, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return 0;
        }
        Element privLabels = xmlDoc.getDocumentElement();
        if (!privLabels.getTagName().equalsIgnoreCase(TAG_PrivateLabels)) {
            BasicPrivateLabelLoader.printError("Missing 'PrivateLabels' tag", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return 0;
        }
        String i18nPkgName = XMLTools.getAttribute((Element)privLabels, (String)ATTR_i18nPackage, null, (boolean)false);
        if (StringTools.isBlank((String)i18nPkgName)) {
            i18nPkgName = BasicPrivateLabelLoader.class.getPackage().getName();
        }
        if (!ListTools.isEmpty(locales = this.parseTag_SupportedLocales(xmlFile, i18nPkgName, privLabels))) {
            BasicPrivateLabel.SetSupportedLocalesMap(locales);
        }
        if ((timeZones = this.parseTag_Timezones(privLabels)) == null) {
            timeZones = new OrderedSet();
        }
        RTProperties globalProps = new RTProperties(dftProps);
        NodeList propsNodes = XMLTools.getChildElements((Node)privLabels, (String)TAG_Properties);
        for (int p = 0; p < propsNodes.getLength(); ++p) {
            Element props = (Element)propsNodes.item(p);
            this.parseTag_Properties(xmlFile, (RTConfig.PropertySetter)globalProps, props, null, null, true);
        }
        globalProps.setProperties(ovrProps);
        globalProps.removeProperties(RTConfig.getConfigFileProperties());
        boolean isGlobalPushpins = dftPushpinMap == null;
        dftPushpinMap = new OrderedMap(dftPushpinMap);
        NodeList ppNodes = XMLTools.getChildElements((Node)privLabels, (String)TAG_Pushpins);
        for (int p = 0; p < ppNodes.getLength(); ++p) {
            Element ppn = (Element)ppNodes.item(p);
            OrderedMap<String, Object> ppMap = this.parseTAG_Pushpins(xmlFile, null, ppn, null, isGlobalPushpins);
            if (ListTools.isEmpty(ppMap)) continue;
            dftPushpinMap.putAll(ppMap);
        }
        if (BasicPrivateLabelLoader.isTrackServlet()) {
            NodeList iconSelNodes = XMLTools.getChildElements((Node)privLabels, (String)TAG_IconSelector);
            for (int n = 0; n < iconSelNodes.getLength(); ++n) {
                Element isn = (Element)iconSelNodes.item(n);
            }
        }
        dftLegend = new OrderedMap(dftLegend);
        if (BasicPrivateLabelLoader.isTrackServlet()) {
            NodeList legendNodes = XMLTools.getChildElements((Node)privLabels, (String)TAG_Legend);
            for (int n = 0; n < legendNodes.getLength(); ++n) {
                Element attrElem = (Element)legendNodes.item(n);
                String legType = XMLTools.getAttribute((Element)attrElem, (String)ATTR_type, (String)"", (boolean)false);
                String legend = StringTools.replace((String)XMLTools.getNodeText((Node)attrElem, (String)"\n", (boolean)true), (String)"\\n", (String)"\n").trim();
                if (!StringTools.isBlank((String)legend)) {
                    dftLegend.put((Object)legType, (Object)legend);
                    continue;
                }
                String refName = "<Global>" + xmlFile.getName();
                legend = this.parseLegendHTML(refName, null, dftPushpinMap, legType, attrElem);
                if (!StringTools.isBlank((String)legend)) {
                    dftLegend.put((Object)legType, (Object)legend);
                    continue;
                }
                legend = this.parseLegendHTML(refName, null, dftPushpinMap, legType, null);
                if (StringTools.isBlank((String)legend)) continue;
                dftLegend.put((Object)legType, (Object)legend);
            }
        }
        int count = 0;
        NodeList domainList = XMLTools.getChildElements((Node)privLabels, (String)TAG_Domain);
        for (int d = 0; d < domainList.getLength(); ++d) {
            Element domain = (Element)domainList.item(d);
            this.parseTag_Domain(xmlFile, i18nPkgName, domain, null, globalProps, (OrderedSet<String>)timeZones, (OrderedMap<String, Object>)dftPushpinMap, (OrderedMap<String, String>)dftLegend, ignoreDuplicates);
            ++count;
        }
        NodeList includeList = XMLTools.getChildElements((Node)privLabels, (String)TAG_Include);
        if (includeList.getLength() > 0 && DomainIncludeRecursionLevel > 0) {
            BasicPrivateLabelLoader.printError("Included files cannot contain an 'Include' tag: " + xmlFile, new Object[0]);
            this._setHasParsingErrors(xmlFile);
        } else {
            ++DomainIncludeRecursionLevel;
            for (int i = 0; i < includeList.getLength(); ++i) {
                File file;
                File file2;
                File dir;
                Element include = (Element)includeList.item(i);
                boolean enabled = XMLTools.getAttributeBoolean((Element)include, (String)ATTR_enabled, (boolean)true, (boolean)false);
                if (!enabled) continue;
                String inclName = XMLTools.getAttribute((Element)include, (String)ATTR_name, (String)"", (boolean)false);
                boolean optional = XMLTools.getAttributeBoolean((Element)include, (String)ATTR_optional, (boolean)false, (boolean)false);
                boolean ignDups = ignoreDuplicates || XMLTools.getAttributeBoolean((Element)include, (String)ATTR_ignoreDuplicates, (boolean)false, (boolean)false);
                String includeFile = XMLTools.getAttribute((Element)include, (String)ATTR_file, null, (boolean)false);
                if (StringTools.isBlank((String)includeFile)) {
                    BasicPrivateLabelLoader.printError("Include 'file' not specified [" + inclName + "]:" + xmlFile, new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                    continue;
                }
                if (!ALLOW_DOMAIN_INCLUDE && !includeFile.equals("private_release.xml")) {
                    BasicPrivateLabelLoader.printInfo("Skipping include [" + inclName + "]:" + includeFile, new Object[0]);
                    continue;
                }
                RTProperties inclProps = new RTProperties(globalProps);
                NodeList propList = include.getChildNodes();
                for (int e = 0; e < propList.getLength(); ++e) {
                    Node propNode = propList.item(e);
                    if (!(propNode instanceof Element)) continue;
                    Element propElem = (Element)propNode;
                    String propName = propNode.getNodeName();
                    if (propName.equalsIgnoreCase(TAG_Property)) {
                        String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)propElem, (String)ATTR_key, null, (boolean)false));
                        if (!StringTools.isBlank((String)key)) {
                            boolean valTrim = XMLTools.getAttributeBoolean((Element)propElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                            inclProps.setProperty((Object)key, (Object)XMLTools.getNodeText((Node)propElem, (String)(valTrim ? "\\n" : null), (boolean)true));
                            continue;
                        }
                        BasicPrivateLabelLoader.printWarn("Undefined property key ignored [" + inclName + "].", new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                        continue;
                    }
                    if (propName.equalsIgnoreCase(TAG_LogMessage)) {
                        this.parseTag_LogMessage(xmlFile, null, propElem);
                        continue;
                    }
                    BasicPrivateLabelLoader.printError("Invalid tag name [" + inclName + "]: " + propName + " [expecting " + TAG_Property + "]", new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                }
                inclProps.setProperties(ovrProps);
                inclProps.removeProperties(RTConfig.getConfigFileProperties());
                String includeDir = XMLTools.getAttribute((Element)include, (String)ATTR_dir, null, (boolean)false);
                File inclDir = !StringTools.isBlank((String)includeDir) ? new File(includeDir) : null;
                String altIncludeDir = XMLTools.getAttribute((Element)include, (String)ATTR_altDir, null, (boolean)false);
                File altInclDir = !StringTools.isBlank((String)altIncludeDir) ? new File(altIncludeDir) : null;
                File parentDir = xmlFile.getParentFile();
                if (parentDir != null) {
                    try {
                        File dir2;
                        parentDir = dir2 = parentDir.getCanonicalFile();
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                Vector<String> filesChecked = new Vector<String>();
                File inclFile = null;
                if (inclFile == null && parentDir != null && inclDir != null) {
                    dir = new File(parentDir, inclDir.toString());
                    file2 = new File(dir, includeFile);
                    filesChecked.add(file2.toString());
                    if (file2.isFile()) {
                        inclFile = file2;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Relative] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile == null && parentDir != null && altInclDir != null) {
                    dir = new File(parentDir, altInclDir.toString());
                    file2 = new File(dir, includeFile);
                    filesChecked.add(file2.toString());
                    if (file2.isFile()) {
                        inclFile = file2;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Relative] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile == null && parentDir != null) {
                    file = new File(parentDir, includeFile);
                    filesChecked.add(file.toString());
                    if (file.isFile()) {
                        inclFile = file;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Relative] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile == null && inclDir != null) {
                    file = new File(inclDir, includeFile);
                    filesChecked.add(file.toString());
                    if (file.isFile()) {
                        inclFile = file;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Absolute] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile == null && altInclDir != null) {
                    file = new File(altInclDir, includeFile);
                    filesChecked.add(file.toString());
                    if (file.isFile()) {
                        inclFile = file;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Absolute] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile == null && parentDir != null) {
                    file = new File(includeFile);
                    filesChecked.add(file.toString());
                    if (file.isFile()) {
                        inclFile = file;
                        if (RTConfig.isWebApp()) {
                            Print.logDebug((String)("[Absolute] Include [" + inclName + "]: " + inclFile), (Object[])new Object[0]);
                        }
                    }
                }
                if (inclFile != null && inclFile.isFile()) {
                    try {
                        String inclFilePath = inclFile.getCanonicalPath();
                        if (inclFilePath.equals(xmlFile.getCanonicalPath())) {
                            BasicPrivateLabelLoader.printWarn("Recursive Include ignored [" + inclName + "]: " + inclFile.getCanonicalPath(), new Object[0]);
                            this._setHasParsingWarnings(xmlFile);
                            continue;
                        }
                        int cnt = this._loadXML(inclFile, null, inclProps, (OrderedMap<String, Object>)dftPushpinMap, (OrderedMap<String, String>)dftLegend, ignDups);
                        count += cnt;
                    }
                    catch (Throwable th) {
                        BasicPrivateLabelLoader.printError("Error while including file: " + inclFile, new Object[0]);
                        Print.logException((String)("Error while including file [" + inclName + "]: " + inclFile), (Throwable)th);
                    }
                    continue;
                }
                if (optional) continue;
                BasicPrivateLabelLoader.printWarn("Include file not found [" + inclName + "]: " + includeFile, new Object[0]);
                this._setHasParsingWarnings(xmlFile);
            }
            --DomainIncludeRecursionLevel;
        }
        return count;
    }

    protected OrderedMap<String, I18N.Text> parseTag_SupportedLocales(File xmlFile, String i18nPkgName, Element elemNode) {
        OrderedMap supportedLocales = null;
        NodeList supportedLocalesNodes = XMLTools.getChildElements((Node)elemNode, (String)TAG_SupportedLocales);
        for (int sl = 0; sl < supportedLocalesNodes.getLength(); ++sl) {
            Element slTag = (Element)supportedLocalesNodes.item(sl);
            NodeList localeNodes = XMLTools.getChildElements((Node)slTag, (String)TAG_Locale);
            for (int lo = 0; lo < localeNodes.getLength(); ++lo) {
                Element locTag = (Element)localeNodes.item(lo);
                String locID = XMLTools.getAttribute((Element)locTag, (String)ATTR_id, null, (boolean)false);
                String i18nKey = XMLTools.getAttribute((Element)locTag, (String)ATTR_i18n, null, (boolean)false);
                String locName = StringTools.trim((String)XMLTools.getNodeText((Node)locTag, (String)" ", (boolean)false));
                I18N.Text locText = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPkgName, i18nKey, locName);
                if (supportedLocales == null) {
                    supportedLocales = new OrderedMap();
                }
                supportedLocales.put((Object)locID, (Object)locText);
            }
        }
        return supportedLocales;
    }

    protected OrderedSet<String> parseTag_Timezones(Element elemNode) {
        OrderedSet timeZones = null;
        NodeList timeZonesNodes = XMLTools.getChildElements((Node)elemNode, (String)TAG_TimeZones);
        for (int tzl = 0; tzl < timeZonesNodes.getLength(); ++tzl) {
            Element tmzsTag = (Element)timeZonesNodes.item(tzl);
            String timeZoneIDs = XMLTools.getNodeText((Node)tmzsTag, null, (boolean)false);
            String[] tmz = StringTools.parseStringArray((String)timeZoneIDs, (String)" \t\r\n");
            for (int i = 0; i < tmz.length; ++i) {
                String t = tmz[i].trim();
                if (t.equals("")) continue;
                if (timeZones == null) {
                    timeZones = new OrderedSet();
                }
                timeZones.add((Object)t);
            }
        }
        return timeZones;
    }

    protected void parseTag_Domain(File xmlFile, String i18nPkgName, Element domain, RTProperties backstopProps, RTProperties overrideProps, OrderedSet<String> timeZones, OrderedMap<String, Object> dftPushpinMap, OrderedMap<String, String> dftLegend, boolean ignoreDuplicates) {
        boolean popOverrideProps = false;
        if (overrideProps != null) {
            RTConfig.pushTemporaryProperties((RTProperties)overrideProps);
            popOverrideProps = true;
        }
        String domainName = XMLTools.getAttribute((Element)domain, (String)ATTR_name, null, (boolean)true);
        String hostName = XMLTools.getAttribute((Element)domain, (String)ATTR_host, null, (boolean)true);
        String className = XMLTools.getAttribute((Element)domain, (String)ATTR_class, null, (boolean)false);
        boolean acctLogin = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_accountLogin, (boolean)true, (boolean)true);
        boolean userLogin = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_userLogin, (boolean)true, (boolean)true);
        boolean emailLogin = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_emailLogin, (boolean)false, (boolean)true);
        boolean showPassword = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_showPassword, (boolean)true, (boolean)true);
        boolean isDemo = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_demo, (boolean)false, (boolean)true);
        boolean allowLogin = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_allowLogin, (boolean)true, (boolean)true);
        boolean restricted = XMLTools.getAttributeBoolean((Element)domain, (String)ATTR_restricted, (boolean)false, (boolean)true);
        String localeStr = XMLTools.getAttribute((Element)domain, (String)ATTR_locale, null, (boolean)true);
        if (StringTools.isBlank((String)domainName)) {
            BasicPrivateLabelLoader.printError("Domain 'name' attribute not specified", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        RTProperties i18nStr = new RTProperties();
        RTConfig.pushTemporaryProperties((RTProperties)i18nStr);
        i18nStr.setString("Domain.name", domainName);
        i18nStr.setString("Domain.host", hostName);
        i18nStr.setString("Domain.locale", localeStr);
        OrderedSet<String> domainTMZ = this.parseTag_Timezones(domain);
        if (domainTMZ == null) {
            domainTMZ = timeZones;
        }
        dftPushpinMap = new OrderedMap(dftPushpinMap);
        dftLegend = new OrderedMap(dftLegend);
        BasicPrivateLabel pl = this.createPrivateLabel(xmlFile, className, hostName);
        pl.setDomainName(domainName);
        pl.setAccountLogin(acctLogin);
        pl.setUserLogin(userLogin);
        pl.setAllowEmailLogin(emailLogin);
        pl.setShowPassword(showPassword);
        pl.setEnableDemo(isDemo);
        pl.setRestricted(restricted);
        pl.setLocaleString(localeStr);
        pl.setTimeZones(domainTMZ);
        pl.setRTProperties(backstopProps);
        pl.pushRTProperties();
        if (!allowLogin) {
            pl.setProperty(ATTR_allowLogin, Boolean.FALSE);
        }
        NodeList attrList = domain.getChildNodes();
        for (int c = 0; c < attrList.getLength(); ++c) {
            Node attrNode = attrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_BaseURL)) {
                this.parseTag_BaseURL(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Alias)) {
                this.parseTag_Alias(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_DefaultLoginAccount)) {
                pl.setDefaultLoginAccount(XMLTools.getNodeText((Node)attrElem, (String)"", (boolean)true));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_DefaultLoginUser)) {
                pl.setDefaultLoginUser(XMLTools.getNodeText((Node)attrElem, (String)"", (boolean)true));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_PageTitle)) {
                String ttlDft = XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)true);
                String i18nKey = XMLTools.getAttribute((Element)attrElem, (String)ATTR_i18n, null, (boolean)false);
                if (!StringTools.isBlank((String)i18nKey)) {
                    I18N.Text pageTitle = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPkgName, i18nKey, ttlDft);
                    this._validateI18NText(xmlFile, pageTitle);
                    pl.setPageTitle(pageTitle);
                    continue;
                }
                pl.setPageTitle(ttlDft);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_DateFormat)) {
                String dateFmt = XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)true);
                if (StringTools.isBlank((String)dateFmt)) {
                    dateFmt = BasicPrivateLabel.getDefaultDateFormat();
                }
                pl.setDateFormat(dateFmt);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_TimeFormat)) {
                String timeFmt = XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)true);
                if (StringTools.isBlank((String)timeFmt)) {
                    timeFmt = BasicPrivateLabel.getDefaultTimeFormat();
                }
                pl.setTimeFormat(timeFmt);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Copyright)) {
                pl.setCopyright(XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)true));
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_PasswordHandler)) {
                this.parseTag_PasswordHandler(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_ReverseGeocodeProvider)) {
                this.parseTag_ReverseGeocodeProvider(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_GeocodeProvider)) {
                this.parseTag_GeocodeProvider(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_MobileLocationProvider)) {
                this.parseTag_MobileLocationProvider(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_I18N)) {
                this.parseTag_I18N(xmlFile, i18nPkgName, pl, attrElem, i18nStr);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Properties)) {
                this.parseTag_Properties(xmlFile, pl, attrElem, null, null, false);
                pl.setRTProperties(overrideProps);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_EMailAddresses)) {
                this.parseTag_EMailAddresses(xmlFile, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_StatusCodes)) {
                this.parseTag_StatusCodes(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Acls)) {
                this.parseTag_Acls(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_EventNotificationEMail)) {
                this.parseTag_EventNotificationEMail(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_PredefinedRuleActions)) {
                this.parseTag_PredefinedRuleActions(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Pushpins)) {
                OrderedMap<String, Object> ppMap = this.parseTAG_Pushpins(xmlFile, pl, attrElem, null, false);
                if (ListTools.isEmpty(ppMap)) continue;
                dftPushpinMap.putAll(ppMap);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Legend)) {
                String refName;
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                String legType = XMLTools.getAttribute((Element)attrElem, (String)ATTR_type, (String)"", (boolean)false);
                boolean useDefault = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_includeDefault, (boolean)false, (boolean)false);
                String legendHtml = null;
                if (useDefault) {
                    if (dftLegend.containsKey((Object)legType)) {
                        legendHtml = (String)dftLegend.get((Object)legType);
                    } else {
                        refName = "<Domain>" + xmlFile.getName() + ":" + domainName;
                        legendHtml = this.parseLegendHTML(refName, pl.getLocale(), dftPushpinMap, legType, null);
                    }
                }
                if (StringTools.isBlank(legendHtml) && StringTools.isBlank((String)(legendHtml = StringTools.replace((String)XMLTools.getNodeText((Node)attrElem, (String)"\n", (boolean)true), (String)"\\n", (String)"\n").trim()))) {
                    refName = "<Domain>" + xmlFile.getName() + ":" + domainName;
                    legendHtml = this.parseLegendHTML(refName, pl.getLocale(), dftPushpinMap, legType, attrElem);
                }
                if (StringTools.isBlank(legendHtml)) continue;
                dftLegend.put((Object)legType, (Object)legendHtml);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_MapProvider)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_MapProvider(xmlFile, i18nPkgName, pl, attrElem, (OrderedMap<String, Object>)dftPushpinMap, (OrderedMap<String, String>)dftLegend);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_JSPEntries)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_JSPEntries(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_WebPages)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_WebPages(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_Reports)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_Reports(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_PointsOfInterest)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_PointsOfInterest(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_MapShapes)) {
                if (!BasicPrivateLabelLoader.isTrackServlet()) continue;
                this.parseTag_MapShapes(xmlFile, i18nPkgName, pl, attrElem);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid/Unrecognized tag name: " + attrName, new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        pl.popRTProperties();
        pl.postInitialization();
        this._addPrivateLabel(xmlFile, pl, ignoreDuplicates);
        RTConfig.popTemporaryProperties((RTProperties)i18nStr);
        if (popOverrideProps) {
            RTConfig.popTemporaryProperties((RTProperties)overrideProps);
        }
    }

    protected boolean isValidHostname(String host) {
        String h = StringTools.trim((String)host);
        if (StringTools.isBlank((String)h)) {
            return false;
        }
        if (h.equals("example.com")) {
            return false;
        }
        return !h.endsWith(".example.com");
    }

    protected void parseTag_BaseURL(File xmlFile, BasicPrivateLabel pl, Element attrElem) {
        String baseURL = XMLTools.getNodeText((Node)attrElem, (String)"", (boolean)true);
        if (!StringTools.isBlank((String)baseURL)) {
            if (!pl.hasDefaultBaseURL()) {
                pl.setDefaultBaseURL(baseURL);
            } else {
                BasicPrivateLabelLoader.printWarn("Default BaseURL already defined [ignoring " + baseURL + "]", new Object[0]);
                this._setHasParsingWarnings(xmlFile);
            }
        }
    }

    protected void parseTag_Alias(File xmlFile, BasicPrivateLabel pl, Element attrElem) {
        String aliasHost = StringTools.trim((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_host, (String)"", (boolean)true)).toLowerCase();
        if (this.isValidHostname(aliasHost)) {
            String aliasDesc = XMLTools.getNodeText((Node)attrElem, (String)"", (boolean)true).toLowerCase();
            pl.addHostAlias(aliasHost, aliasDesc);
        }
    }

    protected void parseTag_I18N(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element attrElem, RTProperties i18nStr) {
        NodeList propList = attrElem.getChildNodes();
        for (int e = 0; e < propList.getLength(); ++e) {
            Node propNode = propList.item(e);
            if (!(propNode instanceof Element)) continue;
            Element propElem = (Element)propNode;
            String propName = propNode.getNodeName();
            if (propName.equalsIgnoreCase(TAG_String)) {
                this.parseTag_String(xmlFile, i18nPkgName, pl, propElem, i18nStr);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + propName + " [expecting " + TAG_String + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
    }

    protected void parseTag_String(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element attrElem, RTProperties i18nStr) {
        String i18nKey = XMLTools.getAttribute((Element)attrElem, (String)ATTR_i18n, null, (boolean)false);
        if (!StringTools.isBlank((String)i18nKey)) {
            String key = XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, null, (boolean)false);
            if (StringTools.isBlank((String)key)) {
                key = i18nKey;
            }
            String dftText = XMLTools.getNodeText((Node)attrElem, (String)"\\n", (boolean)true);
            I18N.Text i18nText = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPkgName, i18nKey, dftText);
            String text = i18nText.toString(pl.getLocale());
            i18nStr.setString(key, text);
            pl.setI18NTextProperty(key, i18nText);
        } else {
            BasicPrivateLabelLoader.printWarn("Undefined String key/i18n ignored.", new Object[0]);
            this._setHasParsingWarnings(xmlFile);
        }
    }

    protected void parseTag_Properties(File xmlFile, RTConfig.PropertySetter ps, Element attrElem, String keyPrefix, String rtPrefix, boolean defaultRTPOverride) {
        String prefix = StringTools.trim((String)keyPrefix) + StringTools.trim((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_keyPrefix, null, (boolean)true));
        String rtPropPrefix = StringTools.trim((String)rtPrefix) + StringTools.blankDefault((String)StringTools.trim((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_rtPropPrefix, null, (boolean)true)), (String)prefix);
        if (StringTools.isBlank((String)rtPropPrefix)) {
            rtPropPrefix = defaultRTPOverride ? "" : null;
        }
        NodeList propList = attrElem.getChildNodes();
        for (int e = 0; e < propList.getLength(); ++e) {
            Node propNode = propList.item(e);
            if (!(propNode instanceof Element)) continue;
            Element propElem = (Element)propNode;
            String propName = propNode.getNodeName();
            if (propName.equalsIgnoreCase(TAG_PropertyGroup)) {
                this.parseTag_Properties(xmlFile, ps, propElem, prefix, rtPropPrefix, defaultRTPOverride);
                continue;
            }
            if (propName.equalsIgnoreCase(TAG_Property)) {
                this.parseTag_Property(xmlFile, ps, propElem, prefix, rtPropPrefix);
                continue;
            }
            if (propName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, null, propElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + propName + " [expecting " + TAG_Property + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
    }

    protected void parseTag_Property(File xmlFile, RTConfig.PropertySetter ps, Element attrElem, String prefix, String rtPropPrefix) {
        String v;
        boolean valTrim;
        String k = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, (String)"", (boolean)false));
        if (StringTools.isBlank((String)k)) {
            BasicPrivateLabelLoader.printWarn("Undefined property key ignored.", new Object[0]);
            this._setHasParsingWarnings(xmlFile);
            return;
        }
        String key = StringTools.trim((String)prefix) + k;
        String rtKey = null;
        if (rtPropPrefix != null) {
            String rtk = StringTools.trim((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_rtKey, null, (boolean)false));
            rtKey = StringTools.trim((String)rtPropPrefix) + (!StringTools.isBlank((String)rtk) ? rtk : k);
        }
        String val = XMLTools.getNodeText((Node)attrElem, (String)((valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_trim, (boolean)true, (boolean)false)) ? "\\n" : null), (boolean)true);
        if (!StringTools.isBlank(rtKey) && (v = RTConfig.getString(rtKey, null)) != null) {
            val = v;
        }
        ps.setProperty((Object)key, (Object)val);
    }

    protected void parseTag_EMailAddresses(File xmlFile, BasicPrivateLabel pl, Element listAttrElem) {
        String domain = StringTools.trim((String)XMLTools.getAttribute((Element)listAttrElem, (String)ATTR_domainName, null, (boolean)true));
        if (StringTools.isBlank((String)domain)) {
            domain = "example.com";
        }
        NodeList emailAttrList = listAttrElem.getChildNodes();
        for (int e = 0; e < emailAttrList.getLength(); ++e) {
            Node emailAttrNode = emailAttrList.item(e);
            if (!(emailAttrNode instanceof Element)) continue;
            Element emailAttrElem = (Element)emailAttrNode;
            String emailAttrName = emailAttrNode.getNodeName();
            if (emailAttrName.equalsIgnoreCase(TAG_EMailAddress)) {
                String type = XMLTools.getAttribute((Element)emailAttrElem, (String)ATTR_type, null, (boolean)false);
                String emailAddr = XMLTools.getNodeText((Node)emailAttrElem, (String)" ", (boolean)true).trim();
                if (StringTools.isBlank((String)emailAddr)) continue;
                if (emailAddr.indexOf("@") < 0) {
                    emailAddr = emailAddr + "@" + domain;
                }
                if (this.isValidEMailAddress(emailAddr)) {
                    pl.setEMailAddress(type, emailAddr);
                    continue;
                }
                BasicPrivateLabelLoader.printError("Invalid EMail address '" + emailAddr + "'", new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (emailAttrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, emailAttrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + emailAttrName + " [expecting " + TAG_EMailAddress + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
    }

    protected boolean isValidEMailAddress(String emailAddr) {
        if (StringTools.isBlank((String)emailAddr)) {
            return false;
        }
        if (emailAddr.indexOf("@") <= 0 || emailAddr.endsWith("@")) {
            return false;
        }
        return emailAddr.indexOf(" ") < 0 && emailAddr.indexOf(",") < 0;
    }

    protected void parseTag_StatusCodes(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element listAttrElem) {
        NodeList scAttrList = listAttrElem.getChildNodes();
        boolean only = StringTools.parseBoolean((String)XMLTools.getAttribute((Element)listAttrElem, (String)ATTR_only, null, (boolean)false), (boolean)false);
        int scCount = 0;
        for (int c = 0; c < scAttrList.getLength(); ++c) {
            Node scAttrNode = scAttrList.item(c);
            if (!(scAttrNode instanceof Element)) continue;
            Element scAttrElem = (Element)scAttrNode;
            String scAttrName = scAttrNode.getNodeName();
            if (scAttrName.equalsIgnoreCase(TAG_StatusCode)) {
                String codeStr = XMLTools.getAttribute((Element)scAttrElem, (String)ATTR_code, null, (boolean)false);
                int code = StringTools.parseInt((String)codeStr, (int)0);
                String name = XMLTools.getAttribute((Element)scAttrElem, (String)ATTR_name, null, (boolean)false);
                String iconName = XMLTools.getAttribute((Element)scAttrElem, (String)ATTR_iconName, null, (boolean)false);
                String i18nKey = XMLTools.getAttribute((Element)scAttrElem, (String)ATTR_i18n, null, (boolean)false);
                String dftDesc = StringTools.trim((String)XMLTools.getNodeText((Node)scAttrElem, (String)" ", (boolean)true));
                I18N.Text i18nText = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPkgName, i18nKey, dftDesc);
                if (code > 0) {
                    this._validateI18NText(xmlFile, i18nText);
                    StatusCodes.Code sc = new StatusCodes.Code(code, name, i18nText);
                    if (!StringTools.isBlank((String)iconName)) {
                        sc.setIconName(iconName);
                    }
                    pl.addStatusCode(sc);
                    ++scCount;
                    continue;
                }
                BasicPrivateLabelLoader.printError("Code missing or Invalid: " + codeStr, new Object[0]);
                this._setHasParsingErrors(xmlFile);
                continue;
            }
            if (scAttrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, scAttrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + scAttrName + " [expecting " + TAG_StatusCode + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        pl.setStatusCodeOnly(only && scCount > 0);
    }

    protected void parseTag_PasswordHandler(File xmlFile, BasicPrivateLabel pl, Element phAttrElem) {
        String phName = XMLTools.getAttribute((Element)phAttrElem, (String)ATTR_name, null, (boolean)false);
        String phClassName = XMLTools.getAttribute((Element)phAttrElem, (String)ATTR_class, null, (boolean)false);
        if (StringTools.isBlank((String)phClassName)) {
            BasicPrivateLabelLoader.printError("PasswordHandler 'class' not specified.", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String rtPropPrefix = XMLTools.getAttribute((Element)phAttrElem, (String)ATTR_rtPropPrefix, null, (boolean)true);
        RTProperties rtProps = new RTProperties();
        NodeList propAttrList = phAttrElem.getChildNodes();
        for (int c = 0; c < propAttrList.getLength(); ++c) {
            Node attrNode = propAttrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_Property)) {
                String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, null, (boolean)false));
                String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_rtKey, null, (boolean)false), (String)key);
                if (!StringTools.isBlank((String)key)) {
                    String v;
                    boolean valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                    String val = XMLTools.getNodeText((Node)attrElem, (String)(valTrim ? "" : null), (boolean)true);
                    if (!StringTools.isBlank((String)rtPropPrefix) && (v = RTConfig.getString((String)(rtPropPrefix + rtKey), null)) != null) {
                        val = v;
                    }
                    rtProps.setProperty((Object)key, (Object)val);
                    continue;
                }
                BasicPrivateLabelLoader.printWarn("Undefined property key ignored.", new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + attrName + " [expecting " + TAG_Property + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        PasswordHandler pwh = null;
        try {
            Class<?> pwhClass = Class.forName(phClassName);
            MethodAction ma = new MethodAction(pwhClass, new Class[]{String.class, RTProperties.class});
            pwh = (PasswordHandler)ma.invoke(new Object[]{phName, rtProps});
        }
        catch (ClassNotFoundException cnfe) {
            BasicPrivateLabelLoader.printError("PasswordHandler class not found: " + phClassName, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        catch (Throwable t) {
            BasicPrivateLabelLoader.printError("PasswordHandler creation error: " + phClassName + " [" + t, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        pl.setPasswordHandler(pwh);
    }

    protected void parseTag_ReverseGeocodeProvider(File xmlFile, BasicPrivateLabel pl, Element rgpAttrElem) {
        ReverseGeocodeProvider rgp;
        String rpName = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_name, null, (boolean)false);
        if (StringTools.isBlank((String)rpName)) {
            BasicPrivateLabelLoader.printError("ReverseGeocodeProvider 'name' not specified.", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String activeStr = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_active, null, (boolean)true);
        boolean active = BasicPrivateLabelLoader._isAttributeActive(activeStr, rpName);
        String rpClassName = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_class, null, (boolean)false);
        if (StringTools.isBlank((String)rpClassName)) {
            if (active) {
                BasicPrivateLabelLoader.printError("ReverseGeocodeProvider 'class' not specified.", new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        boolean useAsGeocoder = XMLTools.getAttributeBoolean((Element)rgpAttrElem, (String)ATTR_geocode, (boolean)false, (boolean)false);
        String rtPropPrefix = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_rtPropPrefix, null, (boolean)true);
        RTProperties rtProps = new RTProperties();
        NodeList propAttrList = rgpAttrElem.getChildNodes();
        for (int c = 0; c < propAttrList.getLength(); ++c) {
            Node attrNode = propAttrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_Property)) {
                String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, null, (boolean)false));
                String rtKey = StringTools.blankDefault((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_rtKey, null, (boolean)false), (String)key);
                if (!StringTools.isBlank((String)key)) {
                    String v;
                    boolean valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                    String val = XMLTools.getNodeText((Node)attrElem, (String)(valTrim ? "" : null), (boolean)true);
                    if (!StringTools.isBlank((String)rtPropPrefix) && (v = RTConfig.getString((String)(rtPropPrefix + rtKey), null)) != null) {
                        val = v;
                    }
                    rtProps.setProperty((Object)key, (Object)val);
                    continue;
                }
                BasicPrivateLabelLoader.printWarn("Undefined property key ignored.", new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + attrName + " [expecting " + TAG_Property + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        String rpKey = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_key, null, (boolean)true);
        ReverseGeocodeProvider failoverRGP = null;
        String failover = XMLTools.getAttribute((Element)rgpAttrElem, (String)ATTR_failover, null, (boolean)true);
        if (!StringTools.isBlank((String)failover)) {
            rgp = pl.getReverseGeocodeProvider(failover);
            if (rgp != null) {
                failoverRGP = rgp;
            } else {
                BasicPrivateLabelLoader.printError("ReverseGeocodeProvider failover not defined: " + failover, new Object[0]);
                this._setHasParsingErrors(xmlFile);
                failover = null;
            }
        }
        rgp = null;
        try {
            Class<?> rgpClass = Class.forName(rpClassName);
            MethodAction ma = new MethodAction(rgpClass, new Class[]{String.class, String.class, RTProperties.class});
            rgp = (ReverseGeocodeProvider)ma.invoke(new Object[]{rpName, rpKey, rtProps});
            if (failoverRGP != null) {
                Print.logDebug((String)("[" + rgp.getName() + "] Setting failover RGP: " + failoverRGP.getName()), (Object[])new Object[0]);
                rgp.setFailoverReverseGeocodeProvider(failoverRGP);
            }
        }
        catch (ClassNotFoundException cnfe) {
            if (active) {
                BasicPrivateLabelLoader.printError("ReverseGeocodeProvider class not found: " + rpClassName, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        catch (Throwable t) {
            if (active) {
                BasicPrivateLabelLoader.printError("ReverseGeocodeProvider creation error: " + rpClassName + " [" + t, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        pl.addReverseGeocodeProvider(rgp, active);
        if (active && useAsGeocoder) {
            if (rgp instanceof GeocodeProvider) {
                pl.addGeocodeProvider((GeocodeProvider)((Object)rgp), active);
            } else {
                BasicPrivateLabelLoader.printError("'geocode' specified, and ReverseGeocodeProvider is not a GeocodeProvider: " + rpName, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
        }
    }

    protected void parseTag_GeocodeProvider(File xmlFile, BasicPrivateLabel pl, Element gpAttrElem) {
        String gpName = XMLTools.getAttribute((Element)gpAttrElem, (String)ATTR_name, null, (boolean)false);
        if (StringTools.isBlank((String)gpName)) {
            BasicPrivateLabelLoader.printError("GeocodeProvider 'name' not specified.", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String activeStr = XMLTools.getAttribute((Element)gpAttrElem, (String)ATTR_active, null, (boolean)true);
        boolean active = BasicPrivateLabelLoader._isAttributeActive(activeStr, gpName);
        String gpClassName = XMLTools.getAttribute((Element)gpAttrElem, (String)ATTR_class, null, (boolean)false);
        if (StringTools.isBlank((String)gpClassName)) {
            if (active) {
                BasicPrivateLabelLoader.printError("GeocodeProvider 'class' not specified.", new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        RTProperties rtProps = new RTProperties();
        NodeList propAttrList = gpAttrElem.getChildNodes();
        for (int c = 0; c < propAttrList.getLength(); ++c) {
            Node attrNode = propAttrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_Property)) {
                String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, null, (boolean)false));
                if (!StringTools.isBlank((String)key)) {
                    boolean valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                    rtProps.setProperty((Object)key, (Object)XMLTools.getNodeText((Node)attrElem, (String)(valTrim ? "" : null), (boolean)true));
                    continue;
                }
                BasicPrivateLabelLoader.printWarn("Undefined property key ignored.", new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + attrName + " [expecting " + TAG_Property + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        String gpKey = XMLTools.getAttribute((Element)gpAttrElem, (String)ATTR_key, null, (boolean)true);
        GeocodeProvider gp = null;
        try {
            Class<?> gpClass = Class.forName(gpClassName);
            MethodAction ma = new MethodAction(gpClass, new Class[]{String.class, String.class, RTProperties.class});
            gp = (GeocodeProvider)ma.invoke(new Object[]{gpName, gpKey, rtProps});
        }
        catch (ClassNotFoundException cnfe) {
            if (active) {
                BasicPrivateLabelLoader.printError("GeocodeProvider class not found: " + gpClassName, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        catch (Throwable t) {
            if (active) {
                BasicPrivateLabelLoader.printError("GeocodeProvider creation error: " + gpClassName + " [" + t, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            return;
        }
        pl.addGeocodeProvider(gp, active);
    }

    protected void parseTag_MobileLocationProvider(File xmlFile, BasicPrivateLabel pl, Element mpAttrElem) {
        String mpName = XMLTools.getAttribute((Element)mpAttrElem, (String)ATTR_name, null, (boolean)false);
        if (StringTools.isBlank((String)mpName)) {
            BasicPrivateLabelLoader.printError("MobileLocationProvider 'name' not specified.", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        String active = XMLTools.getAttribute((Element)mpAttrElem, (String)ATTR_active, null, (boolean)true);
        if (!BasicPrivateLabelLoader._isAttributeActive(active, mpName)) {
            return;
        }
        String mpClassName = XMLTools.getAttribute((Element)mpAttrElem, (String)ATTR_class, null, (boolean)false);
        if (StringTools.isBlank((String)mpClassName)) {
            BasicPrivateLabelLoader.printError("MobileLocationProvider 'class' not specified.", new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        RTProperties rtProps = new RTProperties();
        NodeList propAttrList = mpAttrElem.getChildNodes();
        for (int c = 0; c < propAttrList.getLength(); ++c) {
            Node attrNode = propAttrList.item(c);
            if (!(attrNode instanceof Element)) continue;
            String attrName = attrNode.getNodeName();
            Element attrElem = (Element)attrNode;
            if (attrName.equalsIgnoreCase(TAG_Property)) {
                String key = this._adjustPropertyKey(xmlFile, XMLTools.getAttribute((Element)attrElem, (String)ATTR_key, null, (boolean)false));
                if (!StringTools.isBlank((String)key)) {
                    boolean valTrim = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_trim, (boolean)true, (boolean)false);
                    rtProps.setProperty((Object)key, (Object)XMLTools.getNodeText((Node)attrElem, (String)(valTrim ? "" : null), (boolean)true));
                    continue;
                }
                BasicPrivateLabelLoader.printWarn("Undefined property key ignored.", new Object[0]);
                this._setHasParsingWarnings(xmlFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(TAG_LogMessage)) {
                this.parseTag_LogMessage(xmlFile, pl, attrElem);
                continue;
            }
            BasicPrivateLabelLoader.printError("Invalid tag name: " + attrName + " [expecting " + TAG_Property + "]", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        String mpKey = XMLTools.getAttribute((Element)mpAttrElem, (String)ATTR_key, null, (boolean)true);
        MobileLocationProvider mp = null;
        try {
            Class<?> mpClass = Class.forName(mpClassName);
            MethodAction ma = new MethodAction(mpClass, new Class[]{String.class, String.class, RTProperties.class});
            mp = (MobileLocationProvider)ma.invoke(new Object[]{mpName, mpKey, rtProps});
        }
        catch (ClassNotFoundException cnfe) {
            BasicPrivateLabelLoader.printError("MobileLocationProvider class not found: " + mpClassName, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        catch (Throwable t) {
            BasicPrivateLabelLoader.printError("MobileLocationProvider creation error: " + mpClassName + " [" + t, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return;
        }
        pl.addMobileLocationProvider(mp);
    }

    private AclEntry.AccessLevel[] _parseAccessLevelValues(File xmlFile, String strList) {
        Object[] v = StringTools.split((String)strList, (char)',');
        if (ListTools.isEmpty((Object[])v)) {
            return AclEntry.GetValueListForMaximumAccessLevel(AclEntry.AccessLevel.ALL);
        }
        if (v.length == 1) {
            AclEntry.AccessLevel acc = AclEntry.parseAccessLevel((String)v[0], AclEntry.AccessLevel.ALL);
            return AclEntry.GetValueListForMaximumAccessLevel(acc);
        }
        AclEntry.AccessLevel lastValue = null;
        Vector<AclEntry.AccessLevel> values = new Vector<AclEntry.AccessLevel>();
        for (int i = 0; i < v.length; ++i) {
            AclEntry.AccessLevel acc = AclEntry.parseAccessLevel((String)v[i], AclEntry.AccessLevel.ALL);
            if (lastValue == null || lastValue.getIntValue() < acc.getIntValue()) {
                values.add(acc);
            } else if (lastValue.getIntValue() != acc.getIntValue()) {
                BasicPrivateLabelLoader.printError("Invalid AccessLevel list specified: " + strList, new Object[0]);
                this._setHasParsingErrors(xmlFile);
            }
            lastValue = acc;
        }
        return values.toArray(new AclEntry.AccessLevel[values.size()]);
    }

    protected void parseTag_Acls(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element acls) {
        String rtPropPrefix = XMLTools.getAttribute((Element)acls, (String)ATTR_rtPropPrefix, null, (boolean)true);
        AclEntry.AccessLevel dftAccess = AclEntry.parseAccessLevel(XMLTools.getAttribute((Element)acls, (String)ATTR_default, null, (boolean)false), null);
        OrderedMap aclMap = new OrderedMap();
        NodeList aclList = XMLTools.getChildElements((Node)acls, (String)TAG_Acl);
        for (int r = 0; r < aclList.getLength(); ++r) {
            Element aclElem = (Element)aclList.item(r);
            String aclName = XMLTools.getAttribute((Element)aclElem, (String)ATTR_name, null, (boolean)false);
            if (!StringTools.isBlank((String)aclName)) {
                String aclPropKey = rtPropPrefix != null ? rtPropPrefix + aclName.replace('.', '_').replace(':', '_') : null;
                String accValues = XMLTools.getAttribute((Element)aclElem, (String)ATTR_values, null, (boolean)false);
                if (StringTools.isBlank((String)accValues)) {
                    accValues = XMLTools.getAttribute((Element)aclElem, (String)ATTR_maximum, null, (boolean)false);
                }
                AclEntry.AccessLevel[] valAcc = this._parseAccessLevelValues(xmlFile, accValues);
                String accDefault = XMLTools.getAttribute((Element)aclElem, (String)ATTR_default, null, (boolean)false);
                if (!StringTools.isBlank((String)aclPropKey)) {
                    String oldDft = accDefault;
                    String newDft = RTConfig.getString((String)aclPropKey, null);
                    if (newDft != null) {
                        accDefault = StringTools.trim((String)newDft);
                    }
                }
                AclEntry.AccessLevel dftAcc = AclEntry.parseAccessLevel(accDefault, dftAccess);
                String i18nKey = XMLTools.getAttribute((Element)aclElem, (String)ATTR_i18n, null, (boolean)false);
                String descDft = XMLTools.getNodeText((Node)aclElem, (String)"\\n", (boolean)false);
                I18N.Text aclDesc = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPkgName, i18nKey, descDft);
                this._validateI18NText(xmlFile, aclDesc);
                AclEntry ae = new AclEntry(aclName.trim(), aclDesc, valAcc, dftAcc);
                ae.setHidden(XMLTools.getAttributeBoolean((Element)aclElem, (String)ATTR_hidden, (boolean)false, (boolean)false));
                aclMap.put(aclName.trim(), ae);
                continue;
            }
            BasicPrivateLabelLoader.printWarn("Domain '%s' Acl missing 'name'", pl.getName());
            this._setHasParsingWarnings(xmlFile);
        }
        pl.addAclMap(dftAccess, (Map<String, AclEntry>)aclMap);
    }

    protected void parseTag_EventNotificationEMail(File xmlFile, String i18nPackage, BasicPrivateLabel pl, Element attrElem) {
        String emailFrom = XMLTools.getAttribute((Element)attrElem, (String)ATTR_from, null, (boolean)true);
        if (!this.isValidEMailAddress(emailFrom)) {
            BasicPrivateLabelLoader.printError("Invalid EMail address '" + emailFrom + "'", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        boolean useAsDefault = XMLTools.getAttributeBoolean((Element)attrElem, (String)ATTR_useAsDefault, (boolean)false, (boolean)true);
        I18N.Text emailSubj = null;
        I18N.Text emailBody = null;
        NodeList emailNodes = attrElem.getChildNodes();
        for (int n = 0; n < emailNodes.getLength(); ++n) {
            String i18nKey;
            Node emailNode = emailNodes.item(n);
            if (!(emailNode instanceof Element)) continue;
            String nodeName = emailNode.getNodeName();
            Element nodeElem = (Element)emailNode;
            if (nodeName.equalsIgnoreCase(TAG_Subject)) {
                i18nKey = XMLTools.getAttribute((Element)nodeElem, (String)ATTR_i18n, null, (boolean)false);
                String subjDft = XMLTools.getNodeText((Node)nodeElem, (String)"\\n", (boolean)false);
                emailSubj = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPackage, i18nKey, subjDft);
                this._validateI18NText(xmlFile, emailSubj);
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_Body)) {
                i18nKey = XMLTools.getAttribute((Element)nodeElem, (String)ATTR_i18n, null, (boolean)false);
                String bodyText = XMLTools.getNodeText((Node)nodeElem, null, (boolean)false);
                String[] body = XMLTools.parseLines((String)bodyText);
                for (int i = 0; i < body.length; ++i) {
                    body[i] = body[i].trim();
                }
                String bodyDft = StringTools.join((String[])body, (char)'\n');
                emailBody = BasicPrivateLabelLoader.parseI18N(xmlFile, i18nPackage, i18nKey, bodyDft);
                this._validateI18NText(xmlFile, emailBody);
                continue;
            }
            if (!nodeName.equalsIgnoreCase(TAG_LogMessage)) continue;
            this.parseTag_LogMessage(xmlFile, pl, nodeElem);
        }
        pl.setEventNotificationEMail(emailFrom, emailSubj, emailBody, useAsDefault);
    }

    protected void parseTag_PredefinedRuleActions(File xmlFile, String i18nPackage, BasicPrivateLabel pl, Element attrElem) {
    }

    protected OrderedMap<String, Object> parseTAG_Pushpins(File xmlFile, BasicPrivateLabel pl, Element attrElem, OrderedMap<String, Object> dftPushpinMap, boolean isGlobalPushpins) {
        return null;
    }

    protected void parseTag_LogMessage(File xmlFile, BasicPrivateLabel pl, Element attrElem) {
        String type = StringTools.trim((String)XMLTools.getAttribute((Element)attrElem, (String)ATTR_type, (String)"debug", (boolean)true)).toLowerCase();
        String text = XMLTools.getNodeText((Node)attrElem, (String)" ", (boolean)true);
        if (!type.equals("debug") || RTConfig.isDebugMode()) {
            Print._writeLog((int)1, (String)("PrivateLabel: " + xmlFile + "\n"));
            Print._writeLog((int)1, (String)("  LogMessage: " + text + "\n"));
        }
    }

    protected void parseTag_MapProvider(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element attrElem, OrderedMap<String, Object> dftPushpinMap, OrderedMap<String, String> dftLegend) {
    }

    protected String parseLegendHTML(String refName, Locale locale, OrderedMap pushpinMap, String legendType, Element legendElem) {
        return null;
    }

    protected void parseTag_JSPEntries(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element jspFiles) {
    }

    protected void parseTag_WebPages(File xmlFile, String i18nPkgName, BasicPrivateLabel pl, Element webPages) {
    }

    protected void parseTag_Reports(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element reports) {
    }

    protected void parseTag_PointsOfInterest(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element pois) {
    }

    protected void parseTag_MapShapes(File xmlFile, String i18nPkgName, BasicPrivateLabel bpl, Element mapShps) {
    }

    public static String getURLHostName(String urlStr) {
        if (urlStr != null) {
            try {
                URL url = new URL(urlStr);
                String host = url.getHost();
                return host != null ? host : "";
            }
            catch (MalformedURLException mfue) {
                BasicPrivateLabelLoader.printWarn("Invalid URL format: " + urlStr, new Object[0]);
                return "";
            }
        }
        return null;
    }

    public static BasicPrivateLabel getPrivateLabelForURL(URL url) {
        BasicPrivateLabelLoader bpll = BasicPrivateLabelLoader._getInstance();
        if (url != null) {
            BasicPrivateLabel host_bpl;
            String hostName = StringTools.trim((String)url.getHost());
            String path = url.getPath();
            if (path.startsWith("/")) {
                int p = path.indexOf("/", 1);
                String hp = hostName + (p > 0 ? path.substring(0, p) : path);
                BasicPrivateLabel bpl = bpll._getPrivateLabel(hp, null);
                if (bpl != null) {
                    return bpl;
                }
            }
            if ((host_bpl = bpll._getPrivateLabel(hostName, null)) != null) {
                return host_bpl;
            }
            int x = hostName.indexOf(".");
            if (x >= 0 && x < hostName.lastIndexOf(".")) {
                String accountID = hostName.substring(0, x);
                String domainName = hostName.substring(x + 1);
                BasicPrivateLabel domain_bpl = bpll._getPrivateLabel(domainName, null);
                if (domain_bpl != null) {
                    return domain_bpl;
                }
            }
        }
        return bpll._getPrivateLabel(null);
    }

    public static BasicPrivateLabel getPrivateLabel(String name) {
        return BasicPrivateLabelLoader._getInstance()._getPrivateLabel(name);
    }

    public static BasicPrivateLabel getDefaultPrivateLabel() {
        return BasicPrivateLabelLoader._getInstance()._getPrivateLabel(null);
    }

    public static Collection<String> getPrivateLabelNames() {
        return BasicPrivateLabelLoader.getPrivateLabelNames(false);
    }

    public static Collection<String> getPrivateLabelNames(boolean nameOnly) {
        Vector<String> list;
        block4: {
            list = new Vector<String>();
            Map<String, BasicPrivateLabel> privLblMap = BasicPrivateLabelLoader._getInstance().getPrivateLabelMap();
            if (privLblMap == null) break block4;
            if (nameOnly) {
                Iterator<String> i = privLblMap.keySet().iterator();
                while (i.hasNext()) {
                    BasicPrivateLabel pbl = privLblMap.get(i.next());
                    String name = pbl.getName();
                    if (StringTools.isBlank((String)name) || list.contains(name)) continue;
                    list.add(name);
                }
            } else {
                Iterator<String> i = privLblMap.keySet().iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
            }
        }
        return list;
    }

    public static boolean hasParsingWarnings() {
        return BasicPrivateLabelLoader._getInstance().hasParsingWarnings;
    }

    protected void _setHasParsingWarnings(File xmlFile) {
        this.hasParsingWarnings = true;
    }

    public static boolean hasParsingErrors() {
        return BasicPrivateLabelLoader._getInstance().hasParsingErrors;
    }

    protected void _setHasParsingErrors(File xmlFile) {
        this.hasParsingErrors = true;
    }

    protected I18N.Text _validateI18NText(File xmlFile, I18N.Text text) {
        if (text == null) {
            BasicPrivateLabelLoader.printError("I18N is null ...", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        } else if (!text.hasKey()) {
            BasicPrivateLabelLoader.printError("I18N text is missing a 'key' specification", new Object[0]);
            this._setHasParsingErrors(xmlFile);
        } else if (!StringTools.isValidID((String)text.getKey(), (char[])new char[]{'.', '_'})) {
            BasicPrivateLabelLoader.printError("I18N text 'key' is invalid: " + text.getKey(), new Object[0]);
            this._setHasParsingErrors(xmlFile);
        }
        return text;
    }

    protected String _adjustPropertyKey(File xmlFile, String key) {
        if (key == null || key.length() == 0) {
            return key;
        }
        String oldKey = key;
        key = StringTools.stripChars((String)key, (String)" \n\r\t");
        while ((key = key.trim()).endsWith("=")) {
            key = key.substring(0, key.length() - 1);
        }
        if (!key.equals(oldKey)) {
            BasicPrivateLabelLoader.printWarn("Property key invalid: \"" + oldKey + "\"", new Object[0]);
            this._setHasParsingWarnings(xmlFile);
        }
        return key;
    }

    public static boolean hasDefaultPrivateLabel() {
        return BasicPrivateLabelLoader._getInstance().defaultPrivateLabel != null;
    }

    private BasicPrivateLabel _getPrivateLabel(String hostName) {
        return this._getPrivateLabel(hostName, this.defaultPrivateLabel);
    }

    private BasicPrivateLabel _getPrivateLabel(String name, BasicPrivateLabel dftPrivLabel) {
        if (name != null && this.privateLabelMap != null) {
            BasicPrivateLabel plbl = this.privateLabelMap.get(StringTools.trim((String)name));
            return plbl != null ? plbl : dftPrivLabel;
        }
        return dftPrivLabel;
    }

    protected void _addPrivateLabel(File xmlFile, BasicPrivateLabel privLabel, boolean ignoreDuplicates) {
        if (privLabel != null) {
            List<String> hostAliasList;
            if (this.privateLabelMap == null) {
                this.privateLabelMap = new HashMap();
            }
            HashMap<String, BasicPrivateLabel> tempPLMap = new HashMap<String, BasicPrivateLabel>();
            String host = StringTools.trim((String)privLabel.getHostName());
            if (StringTools.isBlank((String)host)) {
                host = "*";
                privLabel.setHostName(host);
            }
            tempPLMap.put(host, privLabel);
            String domainName = privLabel.getDomainName();
            if (!StringTools.isBlank((String)domainName) && !tempPLMap.containsKey(domainName)) {
                tempPLMap.put(domainName, privLabel);
            }
            if (!ListTools.isEmpty(hostAliasList = privLabel.getHostAliasNames())) {
                for (String hostAlias : hostAliasList) {
                    if (StringTools.isBlank((String)hostAlias) || tempPLMap.containsKey(hostAlias)) continue;
                    tempPLMap.put(hostAlias, privLabel);
                }
            }
            boolean hasDuplicates = false;
            for (String hostAlias : tempPLMap.keySet()) {
                if (!this.privateLabelMap.containsKey(hostAlias)) continue;
                if (ignoreDuplicates) {
                    BasicPrivateLabelLoader.printWarn("Domain Host/Alias already defined: [" + xmlFile + " : " + privLabel.getName() + "] " + hostAlias, new Object[0]);
                    this._setHasParsingWarnings(xmlFile);
                } else {
                    BasicPrivateLabelLoader.printError("Domain Host/Alias already defined: [" + xmlFile + " : " + privLabel.getName() + "] " + hostAlias, new Object[0]);
                    this._setHasParsingErrors(xmlFile);
                }
                hasDuplicates = true;
            }
            if (!hasDuplicates) {
                if (tempPLMap.containsKey("*")) {
                    if (this.defaultPrivateLabel == null) {
                        this.defaultPrivateLabel = privLabel;
                    } else {
                        BasicPrivateLabelLoader.printWarn("Default host already defined: [" + xmlFile + ":" + privLabel.getName() + "] " + host, new Object[0]);
                        this._setHasParsingWarnings(xmlFile);
                    }
                }
                this.privateLabelMap.putAll(tempPLMap);
            }
        }
    }

    protected Map<String, BasicPrivateLabel> getPrivateLabelMap() {
        return this.privateLabelMap;
    }

    protected BasicPrivateLabel createPrivateLabel(File xmlFile, String className, String hostName) {
        if (StringTools.isBlank((String)className)) {
            return this.createPrivateLabel(xmlFile, hostName);
        }
        try {
            Class<?> labelClass = Class.forName(className);
            BasicPrivateLabel pl = (BasicPrivateLabel)labelClass.newInstance();
            if (hostName != null) {
                pl.setHostName(hostName);
            }
            return pl;
        }
        catch (Throwable t) {
            BasicPrivateLabelLoader.printError("BasicPrivateLabel creation error: " + className + " [" + t, new Object[0]);
            this._setHasParsingErrors(xmlFile);
            return this.createPrivateLabel(xmlFile, hostName);
        }
    }

    protected static I18N.Text parseI18N(File xmlFile, String pkgName, String i18nKey, String dftStr) {
        return BasicPrivateLabelLoader.parseI18N(xmlFile, pkgName, i18nKey, dftStr, true);
    }

    protected static I18N.Text parseI18N(File xmlFile, String pkgName, String i18nKey, String dftStr, boolean showError) {
        if (StringTools.isBlank((String)i18nKey) && StringTools.isBlank((String)dftStr)) {
            return null;
        }
        I18N.Text text = I18N.parseText((String)pkgName, (String)i18nKey, (String)dftStr.trim(), (boolean)showError);
        if (SAVE_I18N_STRINGS && !StringTools.isBlank((String)i18nKey)) {
            String textKey;
            if (I18N_STRINGS == null) {
                I18N_STRINGS = new OrderedSet();
                I18N_STRINGS_MAP = new OrderedMap();
            }
            if (!I18N_STRINGS_MAP.containsKey(textKey = text.getKey())) {
                I18N_STRINGS.add(text);
                I18N_STRINGS_MAP.put(textKey, text);
            } else {
                I18N.Text oldText = I18N_STRINGS_MAP.get(textKey);
                if (!text.equals((Object)oldText)) {
                    BasicPrivateLabelLoader.printInfo("I18N: key already defined (different value) - " + textKey, new Object[0]);
                }
            }
        }
        return text;
    }

    public static void main(String[] argv) {
        File xmlFile;
        RTConfig.setCommandLineArgs((String[])argv);
        RTConfig.setDebugMode((boolean)true);
        Print.setLogLevel((int)6);
        Print.setLogHeaderLevel((int)6);
        if (RTConfig.hasProperty((String)ATTR_url)) {
            String urlStr = RTConfig.getString((String)ATTR_url, (String)"");
            try {
                URL url = new URL(urlStr);
                String host = StringTools.trim((String)url.getHost());
                String path = url.getPath();
                Print.sysPrintln((String)"Host=%s  Path=%s", (Object[])new Object[]{host, path});
                if (path.startsWith("/")) {
                    int p = path.indexOf("/", 1);
                    String hp = host + (p > 0 ? path.substring(0, p) : path);
                    Print.sysPrintln((String)"HostPath=%s", (Object[])new Object[]{hp});
                }
            }
            catch (Throwable th) {
                Print.logException((String)"Bad URL", (Throwable)th);
            }
            System.exit(1);
        }
        if ((xmlFile = RTConfig.getFile((String)"xml", null)) != null) {
            BasicPrivateLabelLoader._getInstance()._resetLoadXML(xmlFile);
        } else {
            BasicPrivateLabelLoader._getInstance()._resetLoadDefaultXML();
        }
        BasicPrivateLabel privateLabel = BasicPrivateLabelLoader.getPrivateLabel("*");
        Print.sysPrintln((String)("Found default BasicPrivateLabel: " + (privateLabel != null)), (Object[])new Object[0]);
    }

    public static interface OutputHandler {
        public void privateLabelOutput(String var1);
    }
}

