/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.db.AccountRecord;
import org.opengts.db.AclEntry;
import org.opengts.db.GeneralPasswordHandler;
import org.opengts.db.PasswordHandler;
import org.opengts.db.PoiProvider;
import org.opengts.db.PredefinedRuleAction;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Role;
import org.opengts.db.tables.RoleAcl;
import org.opengts.db.tables.User;
import org.opengts.db.tables.UserAcl;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class BasicPrivateLabel
implements RTConfig.PropertySetter {
    public static final String EMAIL_TYPE_DEFAULT = "default";
    public static final String EMAIL_TYPE_PASSWORD = "password";
    public static final String EMAIL_TYPE_ACCOUNTS = "accounts";
    public static final String EMAIL_TYPE_SUPPORT = "support";
    public static final String EMAIL_TYPE_NOTIFY = "notify";
    public static final String EMAIL_TYPE_COMMAND = "command";
    public static final String TIMEZONE_CONF = "timezones.conf";
    public static final String ALL_HOSTS = "*";
    public static final String DEFAULT_HOST = "*";
    private static final String DEFAULT_TITLE = "Example GPS Tracking";
    private static final String DEFAULT_EMAIL_ADDRESS = null;
    private static final boolean ACTIVE_REVERSE_GEOCODE_PROVIDER_ONLY = true;
    private static final boolean ACTIVE_GEOCODE_PROVIDER_ONLY = true;
    public static final String LAF_PageTitle = "PageTitle";
    public static final String LAF_Copyright = "Copyright";
    public static final String LAF_JSPEntry_ = "JSPEntry.";
    public static final String LAF_JSPEntry_Default = "JSPEntry.default";
    public static final String LAF_Banner_Width = "banner.width";
    public static final String LAF_Banner_Style = "banner.style";
    public static final String LAF_Banner_ImageSource = "banner.imageSource";
    public static final String LAF_Banner_ImageWidth = "banner.imageWidth";
    public static final String LAF_Banner_ImageHeight = "banner.imageHeight";
    public static final String LAF_Banner_AnchorLink = "banner.anchorLink";
    public static final String LAF_Background_Color = "Background.color";
    public static final String LAF_Background_Image = "Background.image";
    public static final String LAF_Background_Position = "Background.position";
    public static final String LAF_Background_Repeat = "Background.repeat";
    public static final String LAF_ContentCell_Color = "ContentCell.color";
    public static final String LAF_IconMenu_GroupTitle_Color = "IconMenu.groupTitle.color";
    public static final String PROP_Track_ValidateIDs = "track.validateIDs";
    public static final String PROP_Track_editAfterNew = "track.editAfterNew";
    public static final String PROP_Track_enableAuthenticationService = "track.enableAuthenticationService";
    public static final String PROP_Track_forwardToSecureAccess = "track.forwardToSecureAccess";
    public static final String PROP_NewAccount_authCodeMask = "newAccount.authCodeMask";
    public static final String PROP_AccountLogin_showLoginLink = "accountLogin.showLoginLink";
    public static final String PROP_AccountLogin_showLocaleSelection = "accountLogin.showLocaleSelection";
    public static final String PROP_AccountLogin_legacyLAF = "accountLogin.legacyLAF";
    public static final String PROP_MenuBar_openOnMouseOver = "menuBar.openOnMouseOver";
    public static final String PROP_MenuBar_usePullDownMenus = "menuBar.usePullDownMenus";
    public static final String PROP_MenuBar_includeTextAnchor = "menuBar.includeTextAnchor";
    public static final String PROP_TopMenu_menuType = "topMenu.menuType";
    public static final String PROP_TopMenu_showHeader = "topMenu.showHeader";
    public static final String PROP_TopMenu_maximumIconsPerRow = "topMenu.maximumIconsPerRow";
    public static final String PROP_TopMenu_showMenuDescription = "topMenu.showMenuDescription";
    public static final String PROP_TopMenu_showMenuHelp = "topMenu.showMenuHelp";
    public static final String PROP_DriverInfo_showDeviceID = "driverInfo.showDeviceID";
    public static final String PROP_DriverInfo_showDateCalendar = "driverInfo.showDateCalendar";
    public static final String PROP_DeviceInfo_allowNewDevice = "deviceInfo.allowNewDevice";
    public static final String PROP_DeviceInfo_allowEditServerID = "deviceInfo.allowEditServerID";
    public static final String PROP_DeviceInfo_showDateCalendar = "deviceInfo.showDateCalendar";
    public static final String PROP_DeviceInfo_showNotificationFields = "deviceInfo.showNotificationFields";
    public static final String PROP_DeviceInfo_showPropertiesButton = "deviceInfo.showPropertiesButton";
    public static final String PROP_DeviceInfo_showSmsButton = "deviceInfo.showSmsButton";
    public static final String PROP_DeviceInfo_showNotes = "deviceInfo.showNotes";
    public static final String PROP_DeviceInfo_showFixedLocation = "deviceInfo.showFixedLocation";
    public static final String PROP_DeviceInfo_showExpectedAcks = "deviceInfo.showExpectedAcks";
    public static final String PROP_DeviceInfo_showMaintenanceOdometer = "deviceInfo.showMaintenanceOdometer";
    public static final String PROP_DeviceInfo_showMaintenanceHours = "deviceInfo.showMaintenanceHours";
    public static final String PROP_DeviceInfo_showMaintenanceNotes = "deviceInfo.showMaintenanceNotes";
    public static final String PROP_DeviceInfo_showReminderMessage = "deviceInfo.showReminderMessage";
    public static final String PROP_DeviceInfo_showServiceTime = "deviceInfo.showServiceTime";
    public static final String PROP_DeviceInfo_showIgnitionIndex = "deviceInfo.showIgnitionIndex";
    public static final String PROP_DeviceInfo_maximumIgnitionIndex = "deviceInfo.maximumIgnitionIndex";
    public static final String PROP_DeviceInfo_showInputState_ = "deviceInfo.showInputState.";
    public static final String PROP_DeviceInfo_showOutputState_ = "deviceInfo.showOutputState.";
    public static final String PROP_DeviceInfo_showCommandState_ = "deviceInfo.showCommandState.";
    public static final String PROP_DeviceInfo_showPushpinID = "deviceInfo.showPushpinID";
    public static final String PROP_DeviceInfo_showPushpinChooser = "deviceInfo.showPushpinChooser";
    public static final String PROP_DeviceInfo_showDisplayColor = "deviceInfo.showDisplayColor";
    public static final String PROP_DeviceInfo_showDataKey = "deviceInfo.showDataKey";
    public static final String PROP_DeviceInfo_optimizeUpdateDevice = "deviceInfo.optimizeUpdateDevice";
    public static final String PROP_DeviceInfo_showDcsPropertiesID = "deviceInfo.showDcsPropertiesID";
    public static final String PROP_DeviceInfo_showDcsConfigString = "deviceInfo.showDcsConfigString";
    public static final String PROP_DeviceInfo_showPreferredGroupID = "deviceInfo.showPreferredGroupID";
    public static final String PROP_DeviceInfo_showAssignedUserID = "deviceInfo.showAssignedUserID";
    public static final String PROP_DeviceInfo_showHoursOfOperation = "deviceInfo.showHoursOfOperation";
    public static final String PROP_DeviceInfo_showFaultCodes = "deviceInfo.showFaultCodes";
    public static final String PROP_DeviceInfo_SMS_useDeviceSMSCommands = "deviceInfo.sms.useDeviceSMSCommands";
    public static final String PROP_DeviceInfo_uniqueSimPhoneNumber = "deviceInfo.uniqueSimPhoneNumber";
    public static final String PROP_DeviceInfo_custom_ = "deviceInfo.custom.";
    public static final String PROP_GroupInfo_showPropertiesButton = "groupInfo.showPropertiesButton";
    public static final String PROP_GroupInfo_deviceListSortBy = "groupInfo.deviceListSortBy";
    public static final String PROP_TrackMap_calendarAction = "trackMap.calendarAction";
    public static final String PROP_TrackMap_calendarDateOnLoad = "trackMap.calendarDateOnLoad";
    public static final String PROP_TrackMap_showTimezoneSelection = "trackMap.showTimezoneSelection";
    public static final String PROP_TrackMap_mapUpdateOnLoad = "trackMap.mapUpdateOnLoad";
    public static final String PROP_TrackMap_autoUpdateRecenter = "trackMap.autoUpdateRecenter";
    public static final String PROP_TrackMap_showUpdateAll = "trackMap.showUpdateAll";
    public static final String PROP_TrackMap_showUpdateLast = "trackMap.showUpdateLast";
    public static final String PROP_TrackMap_showPushpinReplay = "trackMap.showPushpinReplay";
    public static final String PROP_TrackMap_showLocationDetails = "trackMap.showLocationDetails";
    public static final String PROP_TrackMap_detailAscending = "trackMap.detailAscending";
    public static final String PROP_TrackMap_detailCenterPushpin = "trackMap.detailCenterPushpin";
    public static final String PROP_TrackMap_includeStatusCodeColor = "trackMap.includeStatusCodeColor";
    public static final String PROP_TrackMap_useRouteDisplayColor = "trackMap.useRouteDisplayColor";
    public static final String PROP_TrackMap_sortableLocationDetails = "trackMap.sortableLocationDetails";
    public static final String PROP_TrackMap_limitType = "trackMap.limitType";
    public static final String PROP_TrackMap_fleetDeviceEventCount = "trackMap.fleetDeviceEventCount";
    public static final String PROP_TrackMap_showFleetMapDevicePushpin = "trackMap.showFleetMapDevicePushpin";
    public static final String PROP_TrackMap_showCursorLocation = "trackMap.showCursorLocation";
    public static final String PROP_TrackMap_showDistanceRuler = "trackMap.showDistanceRuler";
    public static final String PROP_TrackMap_showLocateNow = "trackMap.showLocateNow";
    public static final String PROP_TrackMap_showDeviceLink = "trackMap.showDeviceLink";
    public static final String PROP_TrackMap_showLegend = "trackMap.showLegend";
    public static final String PROP_TrackMap_pageLinks = "trackMap.pageLinks";
    public static final String PROP_TrackMap_showGoogleKML = "trackMap.showGoogleKML";
    public static final String PROP_TrackMap_mapControlLocation = "trackMap.mapControlLocation";
    public static final String PROP_TrackMap_mapControlCollapsible = "trackMap.mapControlCollapsible";
    public static final String PROP_TrackMap_mapControlCollapseOnLoad = "trackMap.mapControlCollapseOnLoad";
    public static final String PROP_TrackMap_enableGeocode = "trackMap.enableGeocode";
    public static final String PROP_TrackMap_enableGeocode_country = "trackMap.enableGeocode.country";
    public static final String PROP_TrackMap_showBatteryLevel = "trackMap.showBatteryLevel";
    public static final String PROP_TrackMap_showAllContainedGeozones = "trackMap.showAllContainedGeozones";
    public static final String PROP_TrackMap_showNearbyGeozones = "trackMap.showNearbyGeozones";
    public static final String PROP_TrackMap_lastDevicePushpin_device = "trackMap.lastDevicePushpin.device";
    public static final String PROP_TrackMap_lastDevicePushpin_fleet = "trackMap.lastDevicePushpin.fleet";
    public static final String PROP_FullMap_calendarAction = "fullMap.calendarAction";
    public static final String PROP_FullMap_calendarDateOnLoad = "fullMap.calendarDateOnLoad";
    public static final String PROP_FullMap_showTimezoneSelection = "fullMap.showTimezoneSelection";
    public static final String PROP_FullMap_mapUpdateOnLoad = "fullMap.mapUpdateOnLoad";
    public static final String PROP_FullMap_autoUpdateRecenter = "fullMap.autoUpdateRecenter";
    public static final String PROP_FullMap_showUpdateAll = "fullMap.showUpdateAll";
    public static final String PROP_FullMap_showUpdateLast = "fullMap.showUpdateLast";
    public static final String PROP_FullMap_showPushpinReplay = "fullMap.showPushpinReplay";
    public static final String PROP_FullMap_detailAscending = "fullMap.detailAscending";
    public static final String PROP_FullMap_detailCenterPushpin = "fullMap.detailCenterPushpin";
    public static final String PROP_FullMap_useRouteDisplayColor = "fullMap.useRouteDisplayColor";
    public static final String PROP_FullMap_limitType = "fullMap.limitType";
    public static final String PROP_FullMap_fleetDeviceEventCount = "fullMap.fleetDeviceEventCount";
    public static final String PROP_FullMap_showFleetMapDevicePushpin = "fullMap.showFleetMapDevicePushpin";
    public static final String PROP_FullMap_showCursorLocation = "fullMap.showCursorLocation";
    public static final String PROP_FullMap_showDistanceRuler = "fullMap.showDistanceRuler";
    public static final String PROP_FullMap_showLocateNow = "fullMap.showLocateNow";
    public static final String PROP_FullMap_showDeviceLink = "fullMap.showDeviceLink";
    public static final String PROP_FullMap_showLegend = "fullMap.showLegend";
    public static final String PROP_FullMap_pageLinks = "fullMap.pageLinks";
    public static final String PROP_FullMap_showGoogleKML = "fullMap.showGoogleKML";
    public static final String PROP_FullMap_mapControlLocation = "fullMap.mapControlLocation";
    public static final String PROP_FullMap_mapControlCollapsible = "fullMap.mapControlCollapsible";
    public static final String PROP_FullMap_enableGeocode = "fullMap.enableGeocode";
    public static final String PROP_FullMap_enableGeocode_country = "fullMap.enableGeocode.country";
    public static final String PROP_FullMap_showBatteryLevel = "fullMap.showBatteryLevel";
    public static final String PROP_FullMap_showAllContainedGeozones = "fullMap.showAllContainedGeozones";
    public static final String PROP_FullMap_lastDevicePushpin_device = "fullMap.lastDevicePushpin.device";
    public static final String PROP_FullMap_lastDevicePushpin_fleet = "fullMap.lastDevicePushpin.fleet";
    public static final String PROP_ReportMenu_useMapDates = "reportMenu.useMapDates";
    public static final String PROP_ReportMenu_showTimezoneSelection = "reportMenu.showTimezoneSelection";
    public static final String PROP_ReportMenu_enableReportEmail = "reportMenu.enableReportEmail";
    public static final String PROP_ReportMenu_enableReportSchedule = "reportMenu.enableReportSchedule";
    public static final String PROP_ReportMenu_customFormatURL = "reportMenu.customFormatURL";
    public static final String PROP_ReportDisplay_showGoogleKML = "reportDisplay.showGoogleKML";
    public static final String PROP_UserInfo_allowDuplicateContactEmail = "userInfo.allowDuplicateContactEmail";
    public static final String PROP_UserInfo_showAccessControlList = "userInfo.showAccessControlList";
    public static final String PROP_UserInfo_showPreferredDeviceID = "userInfo.showPreferredDeviceID";
    public static final String PROP_UserInfo_showAddressFields = "userInfo.showAddressFields";
    public static final String PROP_UserInfo_showOfficeLocation = "userInfo.showOfficeLocation";
    public static final String PROP_UserInfo_showPassword = "userInfo.showPassword";
    public static final String PROP_UserInfo_authorizedGroupCount = "userInfo.authorizedGroupCount";
    public static final String PROP_UserInfo_showNotes = "userInfo.showNotes";
    public static final String PROP_UserInfo_custom_ = "userInfo.custom.";
    public static final String PROP_ZoneInfo_mapControlLocation = "zoneInfo.mapControlLocation";
    public static final String PROP_ZoneInfo_enableGeocode = "zoneInfo.enableGeocode";
    public static final String PROP_ZoneInfo_enableGeocode_country = "zoneInfo.enableGeocode.country";
    public static final String PROP_ZoneInfo_showOverlapPriority = "zoneInfo.showOverlapPriority";
    public static final String PROP_ZoneInfo_showReverseGeocodeZone = "zoneInfo.showReverseGeocodeZone";
    public static final String PROP_ZoneInfo_showArriveDepartZone = "zoneInfo.showArriveDepartZone";
    public static final String PROP_ZoneInfo_showAssignedDeviceGroup = "zoneInfo.showAssignedDeviceGroup";
    public static final String PROP_ZoneInfo_showAutoNotify = "zoneInfo.showAutoNotify";
    public static final String PROP_ZoneInfo_showClientUploadZone = "zoneInfo.showClientUploadZone";
    public static final String PROP_ZoneInfo_showShapeColor = "zoneInfo.showShapeColor";
    public static final String PROP_ZoneInfo_showSpeedLimit = "zoneInfo.showSpeedLimit";
    public static final String PROP_ZoneInfo_showCorridorID = "zoneInfo.showCorridorID";
    public static final String PROP_ZoneInfo_showPurposeID = "zoneInfo.showPurposeID";
    public static final String PROP_ZoneInfo_zonePurposeList = "zoneInfo.zonePurposeList";
    public static final String PROP_ZoneInfo_maximumDisplayedVertices = "zoneInfo.maximumDisplayedVertices";
    public static final String PROP_CorridorInfo_mapControlLocation = "corridorInfo.mapControlLocation";
    public static final String PROP_CorridorInfo_showShapeColor = "corridorInfo.showShapeColor";
    public static final String PROP_CorridorInfo_enableGeocode = "corridorInfo.enableGeocode";
    public static final String PROP_CorridorInfo_enableGeocode_country = "corridorInfo.enableGeocode.country";
    public static final String PROP_CorridorInfo_pointCount = "corridorInfo.pointCount";
    public static final String PROP_RuleInfo_showEMailWrapper = "ruleInfo.showEMailWrapper";
    public static final String PROP_RuleInfo_showSysRulesOnly = "ruleInfo.showSysRulesOnly";
    public static final String PROP_RuleInfo_showSysRules = "ruleInfo.showSysRules";
    public static final String PROP_RuleInfo_showCronRules = "ruleInfo.showCronRules";
    public static final String PROP_RuleInfo_ruleTagList = "ruleInfo.ruleTagList";
    public static final String PROP_RuleInfo_showTriggerActions = "ruleInfo.showTriggerActions";
    public static final String PROP_RuleInfo_showPredefinedActions = "ruleInfo.showPredefinedActions";
    public static final String PROP_DeviceChooser_sortBy = "deviceChooser.sortBy";
    public static final String PROP_DeviceChooser_useTable = "deviceChooser.useTable";
    public static final String PROP_DeviceChooser_idPosition = "deviceChooser.idPosition";
    public static final String PROP_DeviceChooser_search = "deviceChooser.search";
    public static final String PROP_DeviceChooser_matchContains = "deviceChooser.matchContains";
    public static final String PROP_DeviceChooser_singleItemTextField = "deviceChooser.singleItemTextField";
    public static final String PROP_DeviceChooser_includeListHtml = "deviceChooser.includeListHtml";
    public static final String PROP_DeviceChooser_extraDebugEntries = "deviceChooser.extraDebugEntries";
    public static final String PROP_WorkZoneInfo_mapControlLocation = "WorkZoneInfo.mapControlLocation";
    public static final String PROP_StatusCodeInfo_showIconSelector = "statusCodeInfo.showIconSelector";
    public static final String PROP_StatusCodeInfo_showPushpinChooser = "statusCodeInfo.showPushpinChooser";
    public static final String PROP_DeviceAlerts_refreshInterval = "deviceAlerts.refreshInterval";
    public static final String PROP_DeviceAlerts_mapPageName = "deviceAlerts.mapPageName";
    public static final String PROP_DeviceAlerts_showAllDevices = "deviceAlerts.showAllDevices";
    public static final String PROP_DeviceAlerts_maxActiveAlertAge = "deviceAlerts.maxActiveAlertAge";
    public static final String PROP_EntityAdmin_entityType = "entityAdmin.entityType";
    public static final String PROP_SysAdminAccounts_showPasswords = "sysAdminAccounts.showPasswords";
    public static final String PROP_SysAdminAccounts_accountProperties = "sysAdminAccounts.accountProperties";
    public static final String PROP_SysAdminAccounts_showAccountManager = "sysAdminAccounts.showAccountManager";
    public static final String PROP_SysAdminAccounts_showRetainEvents = "sysAdminAccounts.showRetainEvents";
    public static final String PROP_SysAdminAccounts_showDataPushURL = "sysAdminAccounts.showDataPushURL";
    public static final String PROP_SysAdminAccounts_showNotes = "sysAdminAccounts.showNotes";
    public static final String PROP_SysAccountsLogin_enableLogin = "sysAccountsLogin.enableLogin";
    public static final String PROP_SysAccountsLogin_passcode = "sysAccountsLogin.passcode";
    public static final String PROP_SysAccountsLogin_enableReturn = "sysAccountsLogin.enableReturn";
    public static final String PROP_SysAccountsLogin_enableReturn_timeout = "sysAccountsLogin.enableReturn.timeout";
    public static final String PROP_SysAdminInfo_showEventCount = "sysAdminInfo.showEventCount";
    public static final String PROP_SysAdminInfo_showEventsPerSecond = "sysAdminInfo.showEventsPerSecond";
    public static final String PROP_Calendar_firstDayOfWeek = "calendar.firstDayOfWeek";
    public static final String PROP_Calendar_timeTextField = "calendar.timeTextField";
    public static final String PROP_Banner_width = "banner.width";
    public static final String PROP_Banner_style = "banner.style";
    public static final String PROP_Banner_imageSource = "banner.imageSource";
    public static final String PROP_Banner_imageWidth = "banner.imageWidth";
    public static final String PROP_Banner_imageHeight = "banner.imageHeight";
    public static final String PROP_Banner_imageLink = "banner.imageLink";
    protected static boolean _isTrackServlet = false;
    private String primaryHostName = "*";
    private List<String> hostAliasList = null;
    private String domainName = null;
    private String defaultBaseURL = null;
    private boolean acctLogin = true;
    private boolean userLogin = false;
    private boolean allowEmailLogin = false;
    private String defaultLoginAccount = null;
    private String defaultLoginUser = null;
    private boolean isRestricted = false;
    private String localeStr = null;
    private String dateFormat = null;
    private String timeFormat = null;
    private boolean showPassword = true;
    private boolean enableDemo = true;
    private OrderedMap<String, Object> rtPropMap = new OrderedMap();
    private RTProperties rtProps = new RTProperties(this.rtPropMap);
    private OrderedSet<String> timeZonesList = null;
    private String[] timeZonesArray = null;
    private PasswordHandler passwordHandler = null;
    private ReverseGeocodeProvider activeRevgeoProvider = null;
    private OrderedMap<String, ReverseGeocodeProvider> revgeoProvider = null;
    private GeocodeProvider activeGeocodeProvider = null;
    private OrderedMap<String, GeocodeProvider> geocodeProvider = null;
    private OrderedMap<String, MobileLocationProvider> mobLocProvider = null;
    private AclEntry.AccessLevel dftAccLevel = null;
    private OrderedMap<String, AclEntry> privateAclMap = null;
    private AclEntry[] allAclEntries = null;
    private String eventNotifyFrom = null;
    private I18N.Text eventNotifySubj = null;
    private I18N.Text eventNotifyBody = null;
    private boolean eventNotifyDefault = false;
    private SendMail.SmtpProperties smtpProperties = null;
    private boolean statusCodeOnly = false;
    private Map<Integer, StatusCodes.Code> statusCodes = null;
    private PredefinedRuleAction[] predefRuleActions = null;
    private static OrderedMap<String, I18N.Text> SupportedLocales = null;
    private static boolean didInitAllTimeZones = false;
    private static String[] allTimeZones = null;
    private static boolean MERGE_ACL_ENTRIES = true;

    public static void setTrackServlet_loaderOnly() {
        _isTrackServlet = true;
    }

    public static boolean isTrackServlet() {
        return _isTrackServlet;
    }

    protected BasicPrivateLabel() {
    }

    public BasicPrivateLabel(String host) {
        this();
        this.setHostName(host);
    }

    public void postInitialization() {
        String name;
        if (ListTools.size(this.revgeoProvider) > 1) {
            this.revgeoProvider.clear();
            if (this.activeRevgeoProvider != null) {
                name = this.activeRevgeoProvider.getName().toLowerCase();
                this.revgeoProvider.put((Object)name, (Object)this.activeRevgeoProvider);
            }
        }
        if (ListTools.size(this.geocodeProvider) > 1) {
            this.geocodeProvider.clear();
            if (this.activeGeocodeProvider != null) {
                name = this.activeGeocodeProvider.getName().toLowerCase();
                this.geocodeProvider.put((Object)name, (Object)this.activeGeocodeProvider);
            }
        }
    }

    public void setDefaultBaseURL(String baseURL) {
        this.defaultBaseURL = !StringTools.isBlank((String)baseURL) ? baseURL : null;
    }

    public boolean hasDefaultBaseURL() {
        return !StringTools.isBlank((String)this.defaultBaseURL);
    }

    public String getDefaultBaseURL() {
        return this.defaultBaseURL;
    }

    public String toString() {
        return this.getHostName();
    }

    public void setHostName(String host) {
        this.primaryHostName = StringTools.isBlank((String)host) ? null : host.trim();
    }

    public String getHostName() {
        return this.primaryHostName != null ? this.primaryHostName : "*";
    }

    public void addHostAlias(String host, String desc) {
        if (!StringTools.isBlank((String)host)) {
            if (this.hostAliasList == null) {
                this.hostAliasList = new Vector<String>();
            }
            String h = host.trim();
            this.hostAliasList.add(h);
        }
    }

    public List<String> getHostAliasNames() {
        return this.hostAliasList;
    }

    public void setDomainName(String name) {
        if (StringTools.isBlank((String)name)) {
            this.domainName = null;
        } else {
            this.domainName = name.trim();
            this.setProperty("session.name", this.domainName);
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getName() {
        String name = this.getDomainName();
        if (!StringTools.isBlank((String)name)) {
            return name;
        }
        return this.getHostName();
    }

    public void setAccountLogin(boolean acctLogin) {
        this.acctLogin = acctLogin;
    }

    public boolean getAccountLogin() {
        return this.acctLogin;
    }

    public void setUserLogin(boolean userLogin) {
        this.userLogin = userLogin;
    }

    public boolean getUserLogin() {
        return this.userLogin;
    }

    public void setAllowEmailLogin(boolean emailLogin) {
        this.allowEmailLogin = emailLogin;
    }

    public boolean getAllowEmailLogin() {
        return this.allowEmailLogin;
    }

    public void setDefaultLoginAccount(String defaultAccount) {
        this.defaultLoginAccount = defaultAccount;
    }

    public String getDefaultLoginAccount() {
        if (!StringTools.isBlank((String)this.defaultLoginAccount)) {
            return this.defaultLoginAccount;
        }
        return "";
    }

    public void setDefaultLoginUser(String defaultUser) {
        this.defaultLoginUser = defaultUser;
    }

    public String getDefaultLoginUser() {
        if (!StringTools.isBlank((String)this.defaultLoginUser)) {
            return this.defaultLoginUser;
        }
        return User.getAdminUserID();
    }

    public void setPasswordHandler(PasswordHandler pwh) {
        if (pwh instanceof GeneralPasswordHandler && ((GeneralPasswordHandler)pwh).getDebugCheckPassword()) {
            Print.logInfo((String)("Setting PasswordHandler [" + this.getName() + "] : " + pwh), (Object[])new Object[0]);
        }
        this.passwordHandler = pwh;
    }

    public PasswordHandler getPasswordHandler() {
        if (this.passwordHandler != null) {
            return this.passwordHandler;
        }
        return Account.getDefaultPasswordHandler();
    }

    public static boolean HasSupportedLocalesMap() {
        return !ListTools.isEmpty(SupportedLocales);
    }

    public static void SetSupportedLocalesMap(OrderedMap<String, I18N.Text> localeMap) {
        if (!ListTools.isEmpty(localeMap) && ListTools.isEmpty(SupportedLocales)) {
            SupportedLocales = localeMap;
        }
    }

    public static Map<String, String> GetSupportedLocaleMap(Locale locale) {
        OrderedMap map = new OrderedMap();
        if (!ListTools.isEmpty(SupportedLocales)) {
            for (String locID : SupportedLocales.keySet()) {
                String locDesc = ((I18N.Text)SupportedLocales.get((Object)locID)).toString(locale);
                map.put((Object)locID, (Object)locDesc);
            }
        } else {
            Print.logWarn((String)"No 'SupportedLocales' defined in 'private.xml'", (Object[])new Object[0]);
        }
        return map;
    }

    public void setLocaleString(String localeStr) {
        this.localeStr = localeStr;
        this.setProperty("session.locale", this.localeStr);
        this.setProperty("locale", this.localeStr);
    }

    public String getLocaleString() {
        String ls = RTConfig.getString((String)"session.locale", (String)this.localeStr);
        return ls != null ? ls : "";
    }

    public Locale getLocale() {
        return I18N.getLocale((String)this.getLocaleString());
    }

    public I18N getI18N(Class clazz) {
        return I18N.getI18N((Class)clazz, (Locale)this.getLocale());
    }

    public I18N getI18N(Package pkg) {
        return I18N.getI18N((Package)pkg, (Locale)this.getLocale());
    }

    public void setDateFormat(String dateFmt) {
        this.dateFormat = !StringTools.isBlank((String)dateFmt) ? dateFmt : null;
    }

    public String getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = BasicPrivateLabel.getDefaultDateFormat();
        }
        return this.dateFormat;
    }

    public DateTime.DateStringFormat getDateStringFormat() {
        return this.getDateStringFormat(this.getDateFormat());
    }

    public DateTime.DateStringFormat getDateStringFormat(String dateFormat) {
        String df = StringTools.trim((String)dateFormat).toLowerCase();
        String[] dt = StringTools.parseStringArray((String)df, (String)"/- ");
        if (dt.length >= 2) {
            if (dt[0].startsWith("yy") && dt[1].startsWith("mm")) {
                return DateTime.DateStringFormat.YMD;
            }
            if (dt[0].startsWith("mm") && dt[1].startsWith("dd")) {
                return DateTime.DateStringFormat.MDY;
            }
            if (dt[0].startsWith("dd") && dt[1].startsWith("mm")) {
                return DateTime.DateStringFormat.DMY;
            }
        } else if (dt.length == 1) {
            if (dt[0].startsWith("yy")) {
                return DateTime.DateStringFormat.YMD;
            }
            if (dt[0].startsWith("mm")) {
                return DateTime.DateStringFormat.MDY;
            }
            if (dt[0].startsWith("dd")) {
                return DateTime.DateStringFormat.DMY;
            }
        }
        Print.logWarn((String)("Unable to properly determine date format: " + dateFormat), (Object[])new Object[0]);
        return DateTime.DateStringFormat.YMD;
    }

    public boolean isDateFormatYMD() {
        DateTime.DateStringFormat dsf = this.getDateStringFormat();
        return DateTime.DateStringFormat.YMD.equals((Object)dsf);
    }

    public boolean isDateFormatMDY() {
        DateTime.DateStringFormat dsf = this.getDateStringFormat();
        return DateTime.DateStringFormat.MDY.equals((Object)dsf);
    }

    public boolean isDateFormatDMY() {
        DateTime.DateStringFormat dsf = this.getDateStringFormat();
        return DateTime.DateStringFormat.DMY.equals((Object)dsf);
    }

    public String getDateStringFormatText(Locale locale) {
        I18N i18n = I18N.getI18N(BasicPrivateLabel.class, (Locale)locale);
        switch (this.getDateStringFormat()) {
            case MDY: {
                return i18n.getString("BasicPrivateLabel.dateFormatMDY", "(mm/dd/yyyy)");
            }
            case DMY: {
                return i18n.getString("BasicPrivateLabel.dateFormatDMY", "(dd/yyyy/mm)");
            }
            case YMD: {
                return i18n.getString("BasicPrivateLabel.dateFormatYMD", "(yyyy/mm/dd)");
            }
        }
        return i18n.getString("BasicPrivateLabel.dateFormatYMD", "(yyyy/mm/dd)");
    }

    public static String getDefaultDateFormat() {
        String fmt = RTConfig.getString((String)"locale.dateFormat", (String)"yyyy/MM/dd");
        return fmt != null && !fmt.equals("") ? fmt : "yyyy/MM/dd";
    }

    public void setTimeFormat(String timeFmt) {
        this.timeFormat = !StringTools.isBlank((String)timeFmt) ? timeFmt : null;
    }

    public String getTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = BasicPrivateLabel.getDefaultTimeFormat();
        }
        return this.timeFormat;
    }

    public static String getDefaultTimeFormat() {
        String fmt = RTConfig.getString((String)"locale.timeFormat", (String)"HH:mm:ss");
        return fmt != null && !fmt.equals("") ? fmt : "HH:mm:ss";
    }

    public void setRestricted(boolean restricted) {
        this.isRestricted = restricted;
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public void setShowPassword(boolean showPass) {
        this.showPassword = showPass;
    }

    public boolean getShowPassword() {
        return this.showPassword;
    }

    public void setEnableDemo(boolean isDemo) {
        this.enableDemo = isDemo;
    }

    public boolean getEnableDemo() {
        return this.enableDemo;
    }

    public void clearTimeZones() {
        this.timeZonesList = null;
        this.timeZonesArray = null;
    }

    public void setTimeZones(OrderedSet<String> tmz) {
        this.clearTimeZones();
        this.timeZonesList = new OrderedSet(tmz);
    }

    public void setTimeZones(List<String> tmz) {
        this.clearTimeZones();
        this.timeZonesList = new OrderedSet(tmz);
    }

    public void setTimeZones(String[] tmz) {
        this.clearTimeZones();
        this.timeZonesList = new OrderedSet();
        if (tmz != null) {
            for (int i = 0; i < tmz.length; ++i) {
                String tz = tmz[i].trim();
                if (tz.equals("")) continue;
                this.timeZonesList.add((Object)tz);
            }
        }
    }

    public List<String> getTimeZonesList() {
        if (this.timeZonesList == null) {
            this.clearTimeZones();
            this.timeZonesList = new OrderedSet();
        }
        return this.timeZonesList;
    }

    public String[] getTimeZonesArray() {
        List<String> tmzl = this.getTimeZonesList();
        return tmzl.toArray(new String[tmzl.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTimeZones() {
        if (this.timeZonesArray == null) {
            List<String> tzList;
            List<String> list = tzList = this.getTimeZonesList();
            synchronized (list) {
                if (this.timeZonesArray == null) {
                    this.timeZonesArray = tzList.toArray(new String[tzList.size()]);
                }
            }
        }
        return this.timeZonesArray;
    }

    public static String[] getAllTimeZones() {
        if (!didInitAllTimeZones) {
            didInitAllTimeZones = true;
            File cfgFile = RTConfig.getLoadedConfigFile();
            if (cfgFile != null) {
                File tmzFile = new File(cfgFile.getParentFile(), TIMEZONE_CONF);
                allTimeZones = DateTime.readTimeZones((File)tmzFile);
            }
        }
        return allTimeZones;
    }

    public void setPageTitle(I18N.Text text) {
        this.setI18NTextProperty(LAF_PageTitle, text);
    }

    public void setPageTitle(String text) {
        this.setStringProperty(LAF_PageTitle, text);
    }

    public String getPageTitle() {
        return this.getI18NTextString(LAF_PageTitle, DEFAULT_TITLE);
    }

    public void addReverseGeocodeProvider(ReverseGeocodeProvider rgp, boolean active) {
        if (rgp != null) {
            if (this.revgeoProvider == null) {
                this.revgeoProvider = new OrderedMap();
            }
            if (active) {
                if (this.activeRevgeoProvider == null) {
                    this.activeRevgeoProvider = rgp;
                }
                this.revgeoProvider.put((Object)rgp.getName().toLowerCase(), (Object)rgp);
            } else {
                this.revgeoProvider.put((Object)rgp.getName().toLowerCase(), (Object)rgp);
            }
        }
    }

    public ReverseGeocodeProvider getReverseGeocodeProvider() {
        return this.activeRevgeoProvider;
    }

    public ReverseGeocodeProvider getReverseGeocodeProvider(String name) {
        if (name != null && this.revgeoProvider != null) {
            return (ReverseGeocodeProvider)this.revgeoProvider.get((Object)name.toLowerCase());
        }
        return null;
    }

    public void addGeocodeProvider(GeocodeProvider gp, boolean active) {
        if (gp != null) {
            if (this.geocodeProvider == null) {
                this.geocodeProvider = new OrderedMap();
            }
            if (active) {
                if (this.activeGeocodeProvider == null) {
                    this.activeGeocodeProvider = gp;
                }
                this.geocodeProvider.put((Object)gp.getName().toLowerCase(), (Object)gp);
            } else {
                this.geocodeProvider.put((Object)gp.getName().toLowerCase(), (Object)gp);
            }
        }
    }

    public GeocodeProvider getGeocodeProvider() {
        return this.activeGeocodeProvider;
    }

    public GeocodeProvider getGeocodeProvider(String name) {
        if (name != null && this.geocodeProvider != null) {
            return (GeocodeProvider)this.geocodeProvider.get((Object)name.toLowerCase());
        }
        return null;
    }

    public void addMobileLocationProvider(MobileLocationProvider mp) {
        if (mp != null) {
            if (this.mobLocProvider == null) {
                this.mobLocProvider = new OrderedMap();
            }
            this.mobLocProvider.put((Object)mp.getName().toLowerCase(), (Object)mp);
        }
    }

    public MobileLocationProvider getMobileLocationProvider() {
        if (this.mobLocProvider != null && this.mobLocProvider.size() > 0) {
            return (MobileLocationProvider)this.mobLocProvider.getValue(0);
        }
        return null;
    }

    public MobileLocationProvider getMobileLocationProvider(String name) {
        if (name != null && this.mobLocProvider != null) {
            return (MobileLocationProvider)this.mobLocProvider.get((Object)name.toLowerCase());
        }
        return null;
    }

    public int getPushpinIconIndex(String pushpinID, int dftIndex) {
        return this.getPushpinIconIndex(null, pushpinID, dftIndex);
    }

    public int getPushpinIconIndex(String mapProviderID, String pushpinID, int dftIndex) {
        return dftIndex;
    }

    public void setCopyright(String copyright) {
        String c = copyright != null ? copyright.trim() : null;
        this.setStringProperty(LAF_Copyright, c);
    }

    public String getCopyright() {
        String copyright = this.getStringProperty(LAF_Copyright, null);
        if (copyright != null) {
            return copyright;
        }
        return "Copyright (C) " + this.getPageTitle();
    }

    public void addAclMap(AclEntry.AccessLevel dftAccess, Map<String, AclEntry> aclMap) {
        if (this.dftAccLevel == null && dftAccess != null) {
            this.dftAccLevel = dftAccess;
        }
        if (this.privateAclMap == null) {
            this.privateAclMap = new OrderedMap(aclMap);
        } else if (MERGE_ACL_ENTRIES) {
            for (String aclName : aclMap.keySet()) {
                String pan;
                AclEntry aclEntry = aclMap.get(aclName);
                int matchNdx = -1;
                int matchLen = 0;
                String matchName = null;
                for (int i = 0; i < this.privateAclMap.size(); ++i) {
                    pan = (String)this.privateAclMap.getKey(i);
                    int diffLen = StringTools.diff((String)pan, (String)aclName);
                    if (diffLen <= matchLen) continue;
                    matchLen = diffLen;
                    matchNdx = i;
                    matchName = aclName.substring(0, diffLen);
                }
                if (matchNdx >= 0) {
                    int insertNdx = matchNdx;
                    for (insertNdx = matchNdx; insertNdx < this.privateAclMap.size() && (pan = (String)this.privateAclMap.getKey(insertNdx)).startsWith(matchName); ++insertNdx) {
                    }
                    this.privateAclMap.put(insertNdx, (Object)aclName, (Object)aclEntry);
                    continue;
                }
                this.privateAclMap.put((Object)aclName, (Object)aclEntry);
            }
        } else {
            this.privateAclMap.putAll(aclMap);
        }
        this.allAclEntries = null;
    }

    public AclEntry.AccessLevel getMaximumAccessLevel(String aclName) {
        if (this.privateAclMap != null) {
            AclEntry acl = (AclEntry)this.privateAclMap.get((Object)aclName);
            return acl != null ? acl.getMaximumAccessLevel() : AclEntry.AccessLevel.ALL;
        }
        return AclEntry.AccessLevel.ALL;
    }

    public AclEntry.AccessLevel getDefaultAccessLevel() {
        return this.dftAccLevel != null ? this.dftAccLevel : AclEntry.AccessLevel.ALL;
    }

    public AclEntry.AccessLevel getDefaultAccessLevel(String aclName) {
        if (this.privateAclMap != null) {
            AclEntry acl = (AclEntry)this.privateAclMap.get((Object)aclName);
            return acl != null ? acl.getDefaultAccessLevel() : this.getDefaultAccessLevel();
        }
        return this.getDefaultAccessLevel();
    }

    public AclEntry getAclEntry(String aclName) {
        if (this.privateAclMap != null && !StringTools.isBlank((String)aclName)) {
            return (AclEntry)this.privateAclMap.get((Object)aclName);
        }
        return null;
    }

    public AclEntry removeAclEntry(String aclName) {
        if (this.privateAclMap != null && !StringTools.isBlank((String)aclName)) {
            AclEntry acl = (AclEntry)this.privateAclMap.remove((Object)aclName);
            if (acl != null) {
                this.allAclEntries = null;
            }
            return acl;
        }
        return null;
    }

    public boolean hasAclEntry(String aclName) {
        return this.getAclEntry(aclName) != null;
    }

    public AclEntry[] getAllAclEntries() {
        if (this.allAclEntries == null) {
            if (this.privateAclMap != null) {
                this.allAclEntries = new AclEntry[this.privateAclMap.size()];
                int a = 0;
                Iterator i = this.privateAclMap.values().iterator();
                while (i.hasNext()) {
                    this.allAclEntries[a++] = (AclEntry)i.next();
                }
            } else {
                this.allAclEntries = new AclEntry[0];
            }
        }
        return this.allAclEntries;
    }

    public AclEntry.AccessLevel getAccessLevel(Role role, String aclName) {
        AclEntry aclEntry = this.getAclEntry(aclName);
        AclEntry.AccessLevel dft = aclEntry != null ? aclEntry.getDefaultAccessLevel() : this.getDefaultAccessLevel();
        AclEntry.AccessLevel acl = role != null ? RoleAcl.getAccessLevel(role, aclName, dft) : dft;
        return acl;
    }

    public AclEntry.AccessLevel getAccessLevel(User user, String aclName) {
        if (User.isAdminUser(user)) {
            AclEntry aclEntry = this.getAclEntry(aclName);
            return aclEntry != null ? aclEntry.getMaximumAccessLevel() : AclEntry.AccessLevel.ALL;
        }
        if (user == null) {
            return AclEntry.AccessLevel.NONE;
        }
        AclEntry.AccessLevel acl = UserAcl.getAccessLevel(user, aclName, null);
        if (acl == null) {
            acl = this.getAccessLevel(user.getRole(), aclName);
        }
        int maxAccessLevel = user.getMaxAccessLevel();
        if (acl != null && acl.getIntValue() > maxAccessLevel) {
            acl = AclEntry.getAccessLevel(maxAccessLevel);
        }
        return acl;
    }

    public boolean hasAllAccess(User user, String aclName) {
        return AclEntry.okAll(this.getAccessLevel(user, aclName));
    }

    public boolean hasWriteAccess(User user, String aclName) {
        return AclEntry.okWrite(this.getAccessLevel(user, aclName));
    }

    public boolean hasReadAccess(User user, String aclName) {
        return AclEntry.okRead(this.getAccessLevel(user, aclName));
    }

    public void setEventNotificationEMail(String emailFrom, I18N.Text emailSubj, I18N.Text emailBody, boolean useAsDefault) {
        this.eventNotifyFrom = this.getSmtpProperties().getUserEmail(emailFrom);
        this.eventNotifySubj = emailSubj;
        this.eventNotifyBody = emailBody;
        this.eventNotifyDefault = useAsDefault && (emailSubj != null || emailBody != null);
        this.setEMailAddress(EMAIL_TYPE_NOTIFY, this.eventNotifyFrom);
    }

    public String getEventNotificationFrom() {
        return this.getSmtpProperties().getUserEmail(this.eventNotifyFrom);
    }

    public boolean hasEventNotificationEMail() {
        return this.eventNotifySubj != null || this.eventNotifyBody != null;
    }

    public String getEventNotificationSubject() {
        if (this.eventNotifySubj != null) {
            return this.eventNotifySubj.toString(this.getLocale());
        }
        return null;
    }

    public String getEventNotificationBody() {
        if (this.eventNotifyBody != null) {
            return this.eventNotifyBody.toString(this.getLocale());
        }
        return null;
    }

    public boolean getEventNotificationDefault() {
        return this.eventNotifyDefault;
    }

    public void setEMailAddress(String type, String emailAddr) {
        if (!SendMail.IsBlankEmailAddress((String)emailAddr)) {
            emailAddr = StringTools.trim((String)emailAddr);
            if (StringTools.isBlank((String)type) || type.equals(EMAIL_TYPE_DEFAULT)) {
                this.setProperty("EMailAddress", emailAddr);
            } else {
                this.setProperty("EMailAddress_" + type, emailAddr);
                if (!this.hasProperty("EMailAddress")) {
                    this.setProperty("EMailAddress", emailAddr);
                }
            }
        }
    }

    public String getEMailAddress(String type) {
        String email = null;
        if (StringTools.isBlank((String)type) || type.equals(EMAIL_TYPE_DEFAULT)) {
            email = this.getStringProperty("EMailAddress", null);
            if (email == null) {
                email = DEFAULT_EMAIL_ADDRESS;
            }
        } else {
            email = this.getStringProperty("EMailAddress_" + type, null);
            if (email == null && (email = this.getStringProperty("EMailAddress", null)) == null) {
                email = DEFAULT_EMAIL_ADDRESS;
            }
        }
        return this.getSmtpProperties().getUserEmail(email);
    }

    public String[] getEMailAddresses() {
        Vector<String> list = new Vector<String>();
        for (String key : this.rtPropMap.keySet()) {
            if (!key.startsWith("EMailAddress")) continue;
            list.add(this.getStringProperty(key, "?"));
        }
        return list.toArray(new String[list.size()]);
    }

    public void setSmtpProperties(SendMail.SmtpProperties smtpProps) {
        this.smtpProperties = smtpProps;
    }

    public SendMail.SmtpProperties getSmtpProperties() {
        if (this.smtpProperties == null) {
            RTProperties bpRTP = this.getRTProperties();
            RTProperties smtpRTP = new RTProperties();
            for (String smtpKey : RTKey.SMTP_PROPERTIES) {
                String domKey = this.getName() + "." + smtpKey;
                if (bpRTP.hasProperty((Object)domKey)) {
                    smtpRTP.setProperty((Object)smtpKey, bpRTP.getProperty((Object)domKey, (Object)""));
                    continue;
                }
                if (!bpRTP.hasProperty((Object)smtpKey)) continue;
                smtpRTP.setProperty((Object)smtpKey, bpRTP.getProperty((Object)smtpKey, (Object)""));
            }
            this.smtpProperties = new SendMail.SmtpProperties(smtpRTP);
        }
        return this.smtpProperties;
    }

    public boolean globalValidateIDs() {
        return this.getBooleanProperty(PROP_Track_ValidateIDs, true);
    }

    public boolean globalEditAfterNew() {
        return this.getBooleanProperty(PROP_Track_editAfterNew, true);
    }

    public void setRTProperties(RTProperties rtp) {
        if (rtp != null) {
            this.rtProps.setProperties(rtp);
        }
    }

    public RTProperties getRTProperties() {
        return this.rtProps;
    }

    public void pushRTProperties() {
        RTConfig.pushTemporaryProperties((RTProperties)this.rtProps);
    }

    public void popRTProperties() {
        RTConfig.popTemporaryProperties((RTProperties)this.rtProps);
    }

    public void printProperties() {
        this.printProperties(null);
    }

    public void printProperties(String msg) {
        String m = !StringTools.isBlank((String)msg) ? "[" + this.getName() + "] " + msg : "PrivateLabel Properties: " + this.getName();
        this.rtProps.printProperties(m);
    }

    public void setProperty(Object key, Object value) {
        String k = StringTools.trim((Object)key);
        if (value != null) {
            this.rtPropMap.put((Object)k, value);
        } else {
            this.rtPropMap.remove((Object)k);
        }
    }

    public void setStringProperty(String key, String value) {
        this.setProperty(key, value);
    }

    public void setI18NTextProperty(String key, I18N.Text value) {
        this.setProperty(key, value);
    }

    public Object getProperty(String key) {
        String k = key != null ? key : "";
        Object obj = this.rtPropMap.get((Object)k);
        return obj;
    }

    public Collection<String> getPropertyKeys(String keyPrefix) {
        return this.rtProps.getPropertyKeys(keyPrefix);
    }

    public boolean hasProperty(String key) {
        return key != null ? this.rtPropMap.containsKey((Object)key) : false;
    }

    public String getStringProperty(String key, String dft) {
        Object v;
        RTProperties rtp = RTConfig.getTemporaryProperties((String)key);
        if (rtp != null && (v = rtp.getProperty((Object)key, null)) instanceof String) {
            return v.toString();
        }
        Object obj = this.getProperty(key);
        return obj != null ? obj.toString() : dft;
    }

    public String getI18NTextString(String key, String dft) {
        Object v;
        RTProperties rtp = RTConfig.getTemporaryProperties((String)key);
        if (rtp != null && (v = rtp.getProperty((Object)key, null)) instanceof String) {
            return v.toString();
        }
        Object obj = this.getProperty(key);
        if (obj instanceof I18N.Text) {
            return ((I18N.Text)obj).toString(this.getLocale());
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return dft;
    }

    public double getDoubleProperty(String key, double dft) {
        Object obj = this.getProperty(key);
        return obj != null ? StringTools.parseDouble((Object)obj, (double)dft) : dft;
    }

    public long getLongProperty(String key, long dft) {
        Object obj = this.getProperty(key);
        return obj != null ? StringTools.parseLong((Object)obj, (long)dft) : dft;
    }

    public int getIntProperty(String key, int dft) {
        Object obj = this.getProperty(key);
        return obj != null ? StringTools.parseInt((Object)obj, (int)dft) : dft;
    }

    public boolean getBooleanProperty(String key, boolean dft) {
        Object obj = this.getProperty(key);
        return obj != null ? StringTools.parseBoolean((String)obj.toString(), (boolean)dft) : dft;
    }

    public void setStatusCodeOnly(boolean only) {
        this.statusCodeOnly = only;
    }

    public boolean getStatusCodeOnly() {
        return this.statusCodeOnly && this.statusCodes != null;
    }

    public void addStatusCode(StatusCodes.Code code) {
        if (code != null) {
            if (this.statusCodes == null) {
                this.statusCodes = new HashMap<Integer, StatusCodes.Code>();
            }
            this.statusCodes.put(new Integer(code.getCode()), code);
        }
    }

    public Map<Integer, StatusCodes.Code> getCustomStatusCodeMap() {
        return this.statusCodes;
    }

    public OrderedMap<Integer, String> getStatusCodeDescriptionMap() {
        Locale locale = this.getLocale();
        OrderedMap descMap = this.getStatusCodeOnly() ? new OrderedMap() : StatusCodes.GetDescriptionMap(locale);
        Map<Integer, StatusCodes.Code> csc = this.getCustomStatusCodeMap();
        if (csc != null) {
            for (Integer sci : csc.keySet()) {
                StatusCodes.Code c = csc.get(sci);
                descMap.put((Object)sci, (Object)c.getDescription(locale));
            }
        }
        return descMap;
    }

    public OrderedSet<Integer> getStatusCodeList() {
        Locale locale = this.getLocale();
        OrderedSet codeSet = this.getStatusCodeOnly() ? new OrderedSet() : StatusCodes.GetStatusCodeList();
        Map<Integer, StatusCodes.Code> csc = this.getCustomStatusCodeMap();
        if (csc != null) {
            for (Integer sci : csc.keySet()) {
                codeSet.add((Object)sci);
            }
        }
        return codeSet;
    }

    public StatusCodes.Code getStatusCode(Integer code) {
        if (this.statusCodes != null) {
            return this.statusCodes.get(code);
        }
        return null;
    }

    public StatusCodes.Code getStatusCode(int code) {
        if (this.statusCodes != null) {
            return this.statusCodes.get(new Integer(code));
        }
        return null;
    }

    public void setPredefinedRulesActions(PredefinedRuleAction[] predefRuleAct) {
        this.predefRuleActions = predefRuleAct;
    }

    public PredefinedRuleAction[] getPredefinedRulesActions() {
        return this.predefRuleActions;
    }

    public List<PoiProvider> getPointsOfInterest() {
        return null;
    }

    public boolean isSystemAccountsLoginEnabled(String acctID) {
        String enableLogin = this.getStringProperty(PROP_SysAccountsLogin_enableLogin, null);
        if (StringTools.isBlank((String)enableLogin)) {
            return false;
        }
        if (enableLogin.equalsIgnoreCase(AccountRecord.getSystemAdminAccountID()) ? !AccountRecord.isSystemAdminAccountID(acctID) : !StringTools.parseBoolean((String)enableLogin, (boolean)false)) {
            return false;
        }
        String loginPasscode = this.getStringProperty(PROP_SysAccountsLogin_passcode, "");
        return !StringTools.isBlank((String)loginPasscode);
    }

    public String getSystemAccountsLoginPasscode(String acctID) {
        String loginPasscode = this.getStringProperty(PROP_SysAccountsLogin_passcode, "");
        return this.isSystemAccountsLoginEnabled(acctID) ? loginPasscode : "";
    }

    public boolean isSystemAccountsLoginReturnEnabled(String acctID) {
        if (!this.isSystemAccountsLoginEnabled(acctID)) {
            return false;
        }
        String enableReturn = this.getStringProperty(PROP_SysAccountsLogin_enableReturn, null);
        if (StringTools.isBlank((String)enableReturn)) {
            return false;
        }
        return !(enableReturn.equalsIgnoreCase(AccountRecord.getSystemAdminAccountID()) ? !AccountRecord.isSystemAdminAccountID(acctID) : !StringTools.parseBoolean((String)enableReturn, (boolean)false));
    }

    public long getSystemAccountsLoginReturnTimeout(String acctID) {
        long returnTO = this.getLongProperty(PROP_SysAccountsLogin_enableReturn_timeout, 300L);
        return this.isSystemAccountsLoginReturnEnabled(acctID) ? returnTO : 0L;
    }
}

