/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import org.opengts.util.DateTime;
import org.opengts.util.Print;

public class Audit {
    public static final int GROUP_UNKNOWN = 0;
    public static final int GROUP_LOGIN = 256;
    public static final int GROUP_EMAIL = 512;
    public static final int GROUP_DB = 768;
    public static final int GROUP_DEVCMD = 1536;
    public static final int AUDIT_UNKNOWN = 0;
    public static final int AUDIT_LOGIN_OK = 256;
    public static final int AUDIT_LOGOUT = 272;
    public static final int AUDIT_EMAIL_NOTIFY = 513;
    public static final int AUDIT_DEVICE_COMMAND = 1537;
    private static AuditHandler auditHandler = null;

    public static String GetAuditName(int auditCode) {
        switch (auditCode) {
            case 0: {
                return "Unknown";
            }
            case 256: {
                return "User Login OK";
            }
            case 272: {
                return "User Logout";
            }
            case 513: {
                return "Email Notification";
            }
        }
        return "Undefined";
    }

    public static void SetAuditHandler(AuditHandler sah) {
        auditHandler = sah;
    }

    public static void AddAudit(String accountID, long auditTime, int auditCode, String userID, String deviceID, String ipAddress, String privateLabelName, String notes) {
        if (auditHandler != null) {
            auditHandler.addAuditEntry(accountID, auditTime, auditCode, userID, deviceID, ipAddress, privateLabelName, notes);
        }
    }

    public static void userLoginOK(String acctID, String userID, String ipAddr, String bplName) {
        long nowTimeSec = DateTime.getCurrentTimeSec();
        Print.logInfo((String)("Login: Time=" + nowTimeSec + " Domain=" + bplName + " Account=" + acctID + " User=" + userID + " IP=" + ipAddr), (Object[])new Object[0]);
        Audit.AddAudit(acctID, nowTimeSec, 256, userID, null, ipAddr, bplName, null);
    }

    public static void ruleNotification(String acctID, String devID, String toEMail, String subject, String body) {
        long nowTimeSec = DateTime.getCurrentTimeSec();
        Print.logInfo((String)("Rule EMail: Time=" + nowTimeSec + " Account=" + acctID), (Object[])new Object[0]);
        Audit.AddAudit(acctID, nowTimeSec, 513, null, devID, null, null, null);
    }

    public static void deviceCommand(String acctID, String userID, String devID, String ipAddr, String cmdStr) {
        long nowTimeSec = DateTime.getCurrentTimeSec();
        Print.logInfo((String)("Device Command: Time=" + nowTimeSec + " Acct=" + acctID + " User=" + userID + " Dev=" + devID + " Cmd=" + cmdStr), (Object[])new Object[0]);
        Audit.AddAudit(acctID, nowTimeSec, 1537, userID, devID, ipAddr, null, cmdStr);
    }

    public static interface AuditHandler {
        public void addAuditEntry(String var1, long var2, int var4, String var5, String var6, String var7, String var8, String var9);
    }
}

