/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.Locale;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.StringTools;

public class AclEntry
implements Cloneable {
    public static final String ACL_DCS_ = "acl.dcs.";
    public static final String ACL_DCS_DESC = "${dcsDesc}";
    public static final String ACL_SERVICE_ = "acl.service.";
    private static final AccessLevel[] ACCESS_VALUES_NONE = new AccessLevel[]{AccessLevel.NONE};
    private static final AccessLevel[] ACCESS_VALUES_READ = new AccessLevel[]{AccessLevel.NONE, AccessLevel.READ};
    private static final AccessLevel[] ACCESS_VALUES_WRITE = new AccessLevel[]{AccessLevel.NONE, AccessLevel.READ, AccessLevel.WRITE};
    private static final AccessLevel[] ACCESS_VALUES_ALL = new AccessLevel[]{AccessLevel.NONE, AccessLevel.READ, AccessLevel.WRITE, AccessLevel.ALL};
    public static final String SUBACL_SEPARATOR = ":";
    private String aclName = "";
    private I18N.Text aclDesc = null;
    private AccessLevel[] values = ACCESS_VALUES_ALL;
    private AccessLevel maxLevel = AccessLevel.ALL;
    private AccessLevel dftLevel = AccessLevel.NONE;
    private boolean isHidden = false;

    public static AccessLevel getAccessLevel(int accessLevel) {
        return (AccessLevel)EnumTools.getValueOf(AccessLevel.class, (int)accessLevel);
    }

    public static AccessLevel getAccessLevel(String accessLevel, Locale locale) {
        return (AccessLevel)EnumTools.getValueOf(AccessLevel.class, (String)accessLevel, (Locale)locale);
    }

    public static AccessLevel parseAccessLevel(String accStr, AccessLevel dft) {
        int accInt = StringTools.parseInt((String)accStr, (int)(dft != null ? dft.getIntValue() : AccessLevel.READ.getIntValue()));
        if (accInt > AccessLevel.ALL.getIntValue()) {
            accInt = AccessLevel.ALL.getIntValue();
        } else if (accInt < AccessLevel.NONE.getIntValue()) {
            accInt = AccessLevel.NONE.getIntValue();
        }
        return (AccessLevel)EnumTools.getValueOf(AccessLevel.class, (int)accInt);
    }

    public static AccessLevel[] GetValueListForMaximumAccessLevel(AccessLevel maxAcc) {
        if (maxAcc == null) {
            return ACCESS_VALUES_ALL;
        }
        switch (maxAcc) {
            case NONE: {
                return ACCESS_VALUES_NONE;
            }
            case READ: {
                return ACCESS_VALUES_READ;
            }
            case WRITE: {
                return ACCESS_VALUES_WRITE;
            }
        }
        return ACCESS_VALUES_ALL;
    }

    public static boolean okRead(AccessLevel level) {
        return level != null && AclEntry.okRead(level.getIntValue());
    }

    public static boolean okRead(int level) {
        return level >= AccessLevel.READ.getIntValue();
    }

    public static boolean okWrite(AccessLevel level) {
        return level != null && AclEntry.okWrite(level.getIntValue());
    }

    public static boolean okWrite(int level) {
        return level >= AccessLevel.WRITE.getIntValue();
    }

    public static boolean okAll(AccessLevel level) {
        return level != null && AclEntry.okAll(level.getIntValue());
    }

    public static boolean okAll(int level) {
        return level >= AccessLevel.ALL.getIntValue();
    }

    public static String CreateAclName(String aclName, String subAcl) {
        if (StringTools.isBlank((String)aclName)) {
            return "";
        }
        if (StringTools.isBlank((String)subAcl)) {
            return aclName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(aclName);
        sb.append(SUBACL_SEPARATOR);
        sb.append(subAcl);
        return sb.toString();
    }

    public static String[] ParseAclName(String aclName) {
        if (StringTools.isBlank((String)aclName)) {
            return new String[]{"", ""};
        }
        int p = aclName.indexOf(SUBACL_SEPARATOR);
        if (p < 0) {
            return new String[]{aclName, ""};
        }
        return new String[]{aclName.substring(0, p), aclName.substring(p + 1)};
    }

    public AclEntry(String name, I18N.Text desc, AccessLevel[] values, AccessLevel dftLvl) {
        this.aclName = name != null ? name : "";
        this.aclDesc = desc;
        this.values = !ListTools.isEmpty((Object[])values) ? values : ACCESS_VALUES_ALL;
        this.maxLevel = this.values[this.values.length - 1];
        this.setDefaultAccessLevel(dftLvl);
    }

    public AclEntry(String name, I18N.Text desc, AccessLevel maxLvl, AccessLevel dftLvl) {
        this.aclName = name != null ? name : "";
        this.aclDesc = desc;
        this.maxLevel = maxLvl != null ? maxLvl : AccessLevel.ALL;
        this.values = AclEntry.GetValueListForMaximumAccessLevel(this.maxLevel);
        this.setDefaultAccessLevel(dftLvl);
    }

    public AclEntry(AclEntry aclEntry) {
        if (aclEntry != null) {
            this.aclName = aclEntry.aclName != null ? aclEntry.aclName : "";
            this.aclDesc = aclEntry.aclDesc;
            this.values = aclEntry.values;
            this.maxLevel = aclEntry.maxLevel;
            this.dftLevel = aclEntry.dftLevel;
        }
    }

    public String getName() {
        return this.aclName;
    }

    public String getDescription(Locale loc) {
        String k_dcsDesc;
        int p;
        if (this.aclDesc == null) {
            return "";
        }
        String aclDesc = this.aclDesc.toString(loc);
        if (this.aclName.startsWith(ACL_DCS_) && (p = aclDesc.indexOf(k_dcsDesc = ACL_DCS_DESC)) >= 0) {
            int c = this.aclName.indexOf(SUBACL_SEPARATOR);
            String dcs_n = c > 0 ? this.aclName.substring(ACL_DCS_.length(), c) : this.aclName.substring(ACL_DCS_.length());
            DCServerConfig dcs_c = DCServerFactory.getServerConfig(dcs_n);
            String dcs_d = dcs_c != null ? dcs_c.getDescription() : dcs_n.toUpperCase();
            aclDesc = aclDesc.substring(0, p) + dcs_d + aclDesc.substring(p + k_dcsDesc.length());
        }
        return aclDesc;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public AccessLevel[] getAccessLevelValues() {
        if (this.values != null) {
            return this.values;
        }
        if (this.maxLevel != null) {
            return AclEntry.GetValueListForMaximumAccessLevel(this.maxLevel);
        }
        return ACCESS_VALUES_ALL;
    }

    public AccessLevel getMaximumAccessLevel() {
        if (this.maxLevel != null) {
            return this.maxLevel;
        }
        if (!ListTools.isEmpty((Object[])this.values)) {
            return this.values[this.values.length - 1];
        }
        return AccessLevel.ALL;
    }

    public void setDefaultAccessLevel(AccessLevel dft) {
        if (dft != null) {
            this.dftLevel = dft;
            AccessLevel maxLvl = this.getMaximumAccessLevel();
            if (this.dftLevel.getIntValue() > maxLvl.getIntValue()) {
                this.dftLevel = maxLvl;
            }
        } else {
            this.dftLevel = this.getMaximumAccessLevel();
        }
    }

    public AccessLevel getDefaultAccessLevel() {
        return this.dftLevel != null ? this.dftLevel : AccessLevel.NONE;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object other) {
        if (other instanceof AclEntry) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public Object clone() {
        return new AclEntry(this);
    }

    public static enum AccessLevel implements EnumTools.StringLocale,
    EnumTools.IntValue,
    EnumTools.IsDefault
    {
        UNDEFINED(-1, I18N.getString(AclEntry.class, (String)"AclEntry.access.undefined", (String)"Undefined")),
        NONE(0, I18N.getString(AclEntry.class, (String)"AclEntry.access.none", (String)"None")),
        READ(1, I18N.getString(AclEntry.class, (String)"AclEntry.access.readView", (String)"Read/View")),
        WRITE(2, I18N.getString(AclEntry.class, (String)"AclEntry.access.writeEdit", (String)"Write/Edit")),
        ALL(3, I18N.getString(AclEntry.class, (String)"AclEntry.access.newDelete", (String)"New/Delete"));

        private int vv = 0;
        private I18N.Text aa = null;

        private AccessLevel(int v, I18N.Text a) {
            this.vv = v;
            this.aa = a;
        }

        public int getIntValue() {
            return this.vv;
        }

        public String toString() {
            return this.aa.toString();
        }

        public String toString(Locale loc) {
            return this.aa.toString(loc);
        }

        public boolean isDefault() {
            return this.equals((Object)NONE);
        }

        public boolean okRead() {
            return this.getIntValue() >= READ.getIntValue();
        }

        public boolean okWrite() {
            return this.getIntValue() >= WRITE.getIntValue();
        }

        public boolean okAll() {
            return this.getIntValue() >= ALL.getIntValue();
        }

        public boolean isUndefined() {
            return this.equals((Object)UNDEFINED);
        }
    }
}

