/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.db;

import java.util.Locale;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class AccountRecord<RT extends DBRecord>
extends DBRecord<RT> {
    public static final String FLD_accountID = "accountID";
    public static final String FLD_isActive = "isActive";
    public static final String FLD_displayName = "displayName";
    public static final String FLD_notes = "notes";
    private Account account = null;
    private static long _setAccountError = 0L;

    public static String GetSimpleLocalString(String v, Locale loc) {
        I18N i18n = I18N.getI18N(AccountRecord.class, (Locale)loc);
        if (StringTools.isBlank((String)v)) {
            return v;
        }
        if (v.equalsIgnoreCase("yes")) {
            return i18n.getString("AccountRecord.yes", "Yes");
        }
        if (v.equalsIgnoreCase("no")) {
            return i18n.getString("AccountRecord.no", "No");
        }
        if (v.equalsIgnoreCase("true")) {
            return i18n.getString("AccountRecord.true", "True");
        }
        if (v.equalsIgnoreCase("false")) {
            return i18n.getString("AccountRecord.false", "False");
        }
        if (v.equalsIgnoreCase("on")) {
            return i18n.getString("AccountRecord.on", "On");
        }
        if (v.equalsIgnoreCase("off")) {
            return i18n.getString("AccountRecord.off", "Off");
        }
        if (v.equalsIgnoreCase("enable")) {
            return i18n.getString("AccountRecord.enable", "Enable");
        }
        if (v.equalsIgnoreCase("disable")) {
            return i18n.getString("AccountRecord.disable", "Disable");
        }
        if (v.equalsIgnoreCase("enabled")) {
            return i18n.getString("AccountRecord.enabled", "Enabled");
        }
        if (v.equalsIgnoreCase("disabled")) {
            return i18n.getString("AccountRecord.disabled", "Disabled");
        }
        if (v.equalsIgnoreCase("enter")) {
            return i18n.getString("AccountRecord.enter", "Enter");
        }
        if (v.equalsIgnoreCase("exit")) {
            return i18n.getString("AccountRecord.exit", "Exit");
        }
        if (v.equalsIgnoreCase("login")) {
            return i18n.getString("AccountRecord.login", "Login");
        }
        if (v.equalsIgnoreCase("logout")) {
            return i18n.getString("AccountRecord.logout", "Logout");
        }
        return v;
    }

    protected static DBField newField_accountID(boolean priKey) {
        return AccountRecord.newField_accountID(priKey, null);
    }

    protected static DBField newField_accountID(boolean priKey, String xAttr) {
        I18N.Text title = I18N.getString(AccountRecord.class, (String)"AccountRecord.fld.accountID", (String)"Account ID");
        String attr = (priKey ? "key=true" : "edit=2") + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_accountID, String.class, DBField.TYPE_ACCT_ID(), title, attr);
    }

    protected static DBField newField_isActive() {
        return AccountRecord.newField_isActive(null);
    }

    protected static DBField newField_isActive(String xAttr) {
        I18N.Text title = I18N.getString(AccountRecord.class, (String)"AccountRecord.fld.isActive", (String)"Is Active");
        String attr = "edit=2" + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_isActive, Boolean.TYPE, "BOOLEAN", title, attr);
    }

    protected static DBField newField_displayName() {
        return AccountRecord.newField_displayName(null);
    }

    protected static DBField newField_displayName(String xAttr) {
        I18N.Text title = I18N.getString(AccountRecord.class, (String)"AccountRecord.fld.displayName", (String)"Display Name");
        String attr = "edit=2 utf8=true" + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_displayName, String.class, DBField.TYPE_STRING((int)40), title, attr);
    }

    protected static DBField newField_notes() {
        return AccountRecord.newField_notes(null);
    }

    protected static DBField newField_notes(String xAttr) {
        I18N.Text title = I18N.getString(AccountRecord.class, (String)"AccountRecord.fld.notes", (String)"Notes");
        String attr = "edit=2 editor=textArea utf8=true" + (StringTools.isBlank((String)xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_notes, String.class, "TEXT", title, attr);
    }

    public static String getFilteredID(String id) {
        return AccountRecord.getFilteredID(id, false, false);
    }

    public static String getFilteredID(String id, boolean nullOnError, boolean lowerCase) {
        if (StringTools.isBlank((String)id)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                sb.append(ch);
                continue;
            }
            if (ch == '_' || ch == '-' || ch == '.' || ch == '@') {
                sb.append(ch);
                continue;
            }
            if (!nullOnError) continue;
            return null;
        }
        String s = sb.toString();
        if (StringTools.isBlank((String)s)) {
            return null;
        }
        return lowerCase ? s.toLowerCase() : s;
    }

    public static boolean isValidID(String id) {
        return AccountRecord.getFilteredID(id, true, false) != null;
    }

    public AccountRecord() {
    }

    public AccountRecord(AccountKey<RT> key) {
        super(key);
    }

    public final String getAccountID() {
        String acctID;
        String v = (String)this.getKeyValue(FLD_accountID);
        String string = acctID = v != null ? v : "";
        if (StringTools.isBlank((String)acctID)) {
            Print.logWarn((String)"Account ID is blank: ", (Object[])new Object[0]);
            Print.logWarn((String)this.getRecordKey().getKeyValues().toString(), (Object[])new Object[0]);
            Print.logWarn((String)this.getRecordKey().getFieldValues().toString(), (Object[])new Object[0]);
        }
        return acctID;
    }

    private final void setAccountID(String v) {
        this.setKeyValue(FLD_accountID, v != null ? v : "");
    }

    public final boolean isSystemAdmin() {
        return AccountRecord.isSystemAdminAccountID(this.getAccountID());
    }

    public static String getSystemAdminAccountID() {
        return StringTools.trim((String)RTConfig.getString((String)"sysAdmin.account"));
    }

    public static boolean hasSystemAdminAccountID() {
        return !StringTools.isBlank((String)AccountRecord.getSystemAdminAccountID());
    }

    public static boolean isSystemAdminAccountID(String acctID) {
        if (StringTools.isBlank((String)acctID)) {
            return false;
        }
        String sysAdminAcctID = AccountRecord.getSystemAdminAccountID();
        if (StringTools.isBlank((String)sysAdminAcctID)) {
            return false;
        }
        return acctID.equalsIgnoreCase(sysAdminAcctID);
    }

    public static boolean isSystemAdmin(Account account) {
        if (account == null) {
            return false;
        }
        return account.isSystemAdmin();
    }

    public static Account getSystemAdminAccount() throws DBException {
        String sysAdminAcctID = AccountRecord.getSystemAdminAccountID();
        if (StringTools.isBlank((String)sysAdminAcctID)) {
            return null;
        }
        return Account.getAccount(sysAdminAcctID);
    }

    public static Account createSystemAdminAccount(String password) throws DBException {
        String sysAdminAcctID = AccountRecord.getSystemAdminAccountID();
        if (StringTools.isBlank((String)sysAdminAcctID)) {
            return null;
        }
        Account sysAdmin = Account.getAccount(sysAdminAcctID, true);
        if (!StringTools.isBlank((String)password)) {
            sysAdmin.setDecodedPassword(null, password);
        }
        sysAdmin.save();
        return sysAdmin;
    }

    public static boolean isAccountManager(Account account) {
        if (account == null) {
            return false;
        }
        return account.isAccountManager();
    }

    public final boolean getIsActive() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isActive);
        return v != null ? v : false;
    }

    public final void setIsActive(boolean v) {
        this.setFieldValue(FLD_isActive, v);
    }

    public final boolean isActive() {
        return this.getIsActive();
    }

    public final String getDisplayName() {
        String v = (String)this.getFieldValue(FLD_displayName);
        return v != null ? v : "";
    }

    public final void setDisplayName(String v) {
        this.setFieldValue(FLD_displayName, v != null ? v : "");
    }

    public String getNotes() {
        String v = (String)this.getFieldValue(FLD_notes);
        return v != null ? v : "";
    }

    public void setNotes(String v) {
        this.setFieldValue(FLD_notes, v != null ? v : "");
    }

    public final boolean hasAccount() {
        if (this instanceof Account) {
            return true;
        }
        return this.account != null;
    }

    public final Account getAccount() {
        if (this instanceof Account) {
            return (Account)this;
        }
        if (this.account == null) {
            String acctID = this.getAccountID();
            if (!StringTools.isBlank((String)acctID)) {
                Print.logDebug((String)("[Optimize] Retrieving Account record: " + acctID), (Object[])new Object[0]);
                try {
                    this.account = Account.getAccount(acctID);
                    if (this.account == null) {
                        Print.logError((String)("Account not found: " + acctID), (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Account not found: " + acctID), (Object[])new Object[0]);
                    this.account = null;
                }
            } else {
                Print.logError((String)("Account not defined: " + StringTools.className((Object)((Object)this))), (Object[])new Object[0]);
            }
        }
        return this.account;
    }

    public final void setAccount(Account acct) {
        if (this instanceof Account) {
            if (this != acct) {
                Print.logError((String)("'this' is already an Account: " + this.getAccountID()), (Object[])new Object[0]);
            }
        } else if (acct == null) {
            this.account = null;
        } else if (!this.getAccountID().equals(acct.getAccountID())) {
            String msg = "Account IDs do not match: " + this.getAccountID() + " != " + acct.getAccountID();
            if (++_setAccountError < 4L) {
                Print.logStackTrace((String)msg);
            } else {
                Print.logError((String)msg, (Object[])new Object[0]);
            }
            this.account = null;
        } else {
            this.account = acct;
        }
    }

    public final String getAccountDescription() {
        Account acct = this.getAccount();
        return acct != null ? acct.getDescription() : this.getAccountID();
    }

    public void setRuntimeDefaultValues() {
        BasicPrivateLabel privLbl;
        if (!(this instanceof Account) && this.hasAccount() && (privLbl = this.getAccount().getPrivateLabel()) != null) {
            DBRecordKey rk = this.getRecordKey();
            String tableName = rk.getUntranslatedTableName();
            DBField[] fld = rk.getFields();
            for (int i = 0; i < fld.length; ++i) {
                String fn = fld[i].getName();
                String[] dk = this.getDefaultFieldValueKey(fn);
                String val = null;
                for (int p = 0; p < dk.length; ++p) {
                    if (!privLbl.hasProperty(dk[p])) continue;
                    val = privLbl.getStringProperty(dk[p], null);
                    break;
                }
                if (val == null && RTConfig.hasProperty((String[])dk)) {
                    val = RTConfig.getString((String[])dk, null);
                }
                if (val == null) continue;
                if (!fld[i].isPrimaryKey()) {
                    this.setFieldValue(fn, fld[i].parseStringValue(val));
                    continue;
                }
                Print.logError((String)("Refusing to set a default value for a primary key field: " + fn), (Object[])new Object[0]);
            }
            return;
        }
        super.setRuntimeDefaultValues();
    }

    public static abstract class AccountKey<RT extends DBRecord>
    extends DBRecordKey<RT> {
    }
}

