/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.cellid.opencellid;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.cellid.MobileLocationProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OpenCellID
extends MobileLocationProviderAdapter
implements MobileLocationProvider {
    private static final String MOBILE_LOCATION_URI = "http://www.opencellid.org/cell/get";
    private static final String VERSION = "0.1.1";
    private static final String PROP_timeoutMS = "timeoutMS";
    private static final long DefaultServiceTimeout = 5000L;
    private static final String TAG_rsp = "rsp";
    private static final String TAG_cell = "cell";
    private static final String ATTR_stat = "stat";
    private static final String ATTR_nbSamples = "nbSamples";
    private static final String ATTR_mnc = "mnc";
    private static final String ATTR_lac = "lac";
    private static final String ATTR_cellId = "cellId";
    private static final String ATTR_mcc = "mcc";
    private static final String ATTR_lat = "lat";
    private static final String ATTR_lon = "lon";
    private static final String ATTR_range = "range";

    private static Document _getMobileLocateXML(String url, long timeoutMS) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)((int)timeoutMS));
            InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF-8");
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding("UTF-8");
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (UnknownHostException uhe) {
            Print.logError((String)("Unable to resolve host: " + uhe), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    private static String _getCellLocationURL(CellTower servCT, CellTower[] nborCT, String key) {
        if (servCT == null) {
            Print.logWarn((String)"Null CellTower specified", (Object[])new Object[0]);
            return null;
        }
        if (StringTools.isBlank((String)key)) {
            Print.logError((String)"Required 'key' is not specified", (Object[])new Object[0]);
            return null;
        }
        URIArg url = new URIArg(MOBILE_LOCATION_URI);
        url.addArg("key", key);
        url.addArg("cellid", servCT.getCellTowerID());
        url.addArg(ATTR_mnc, servCT.getMobileNetworkCode());
        url.addArg(ATTR_mcc, servCT.getMobileCountryCode());
        url.addArg(ATTR_lac, servCT.getLocationAreaCode());
        return url.toString();
    }

    private static MobileLocation _getMobileLocation(CellTower servCT, CellTower[] nborCT, String key, long timeoutMS) {
        String url = OpenCellID._getCellLocationURL(servCT, nborCT, key);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        Print.logDebug((String)("CellTower loc URL: " + url), (Object[])new Object[0]);
        Document xmlDoc = OpenCellID._getMobileLocateXML(url, timeoutMS);
        if (xmlDoc == null) {
            return null;
        }
        double latitude = 999.0;
        double longitude = 999.0;
        double range = 0.0;
        Element rsp = xmlDoc.getDocumentElement();
        if (rsp.getTagName().equalsIgnoreCase(TAG_rsp)) {
            String stat = StringTools.blankDefault((String)XMLTools.getAttribute((Element)rsp, (String)ATTR_stat, (String)"", (boolean)false), (String)"ok");
            if (stat.equalsIgnoreCase("ok")) {
                NodeList nodeList = rsp.getChildNodes();
                for (int a = 0; a < nodeList.getLength(); ++a) {
                    Node node = nodeList.item(a);
                    if (!(node instanceof Element)) continue;
                    Element elem = (Element)node;
                    String name = elem.getNodeName();
                    if (name.equalsIgnoreCase(TAG_cell)) {
                        latitude = StringTools.parseDouble((String)XMLTools.getAttribute((Element)elem, (String)ATTR_lat, null, (boolean)false), (double)0.0);
                        longitude = StringTools.parseDouble((String)XMLTools.getAttribute((Element)elem, (String)ATTR_lon, null, (boolean)false), (double)0.0);
                        range = StringTools.parseDouble((String)XMLTools.getAttribute((Element)elem, (String)ATTR_range, null, (boolean)false), (double)0.0);
                        Print.logInfo((String)("MobileLocation: " + latitude + "/" + longitude + " range=" + range + " m"), (Object[])new Object[0]);
                        continue;
                    }
                    Print.logWarn((String)("Unexpected tag 'rsp->" + name + "' [expected '" + TAG_cell + "']"), (Object[])new Object[0]);
                }
            } else {
                Print.logWarn((String)("Tag 'rsp' specified unexpected response: " + stat), (Object[])new Object[0]);
            }
        } else {
            Print.logWarn((String)"Expected tag 'rsp' not found", (Object[])new Object[0]);
        }
        if (GeoPoint.isValid((double)latitude, (double)longitude)) {
            return new MobileLocation(latitude, longitude, range);
        }
        return null;
    }

    public OpenCellID(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public MobileLocation getMobileLocation(CellTower servCT, CellTower[] nborCT) {
        long tmoMS = this.getProperties().getLong(PROP_timeoutMS, 5000L);
        return OpenCellID._getMobileLocation(servCT, nborCT, this.getAuthorization(), tmoMS);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)"UTF-8");
        CellTower ct = new CellTower();
        ct.setCellTowerID(565110);
        ct.setMobileNetworkCode(8);
        ct.setMobileCountryCode(240);
        ct.setLocationAreaCode(318);
        String key = RTConfig.getString((String)"key", (String)"");
        OpenCellID mobLoc = new OpenCellID("opencellid", key, null);
        MobileLocation ml = mobLoc.getMobileLocation(ct, null);
        Print.logInfo((String)("Mobile Location: " + ml), (Object[])new Object[0]);
    }
}

