/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.cellid.google;

import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.cellid.MobileLocationProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class GoogleMobileService
extends MobileLocationProviderAdapter
implements MobileLocationProvider {
    private static final String MOBILE_SERVICE_URI = "http://www.google.com/glm/mmap";
    private static final String VERSION = "0.1.2";
    private static final String PROP_timeoutMS = "timeoutMS";
    private static final long DefaultServiceTimeout = 5000L;

    private static byte[] encodeRequest(CellTower cti) {
        if (cti == null) {
            return null;
        }
        int mcc = cti.getMobileCountryCode();
        int mnc = cti.getMobileNetworkCode();
        int cid = cti.getCellTowerID();
        int lac = cti.getLocationAreaCode();
        return GoogleMobileService.encodeRequest(mcc, mnc, cid, lac);
    }

    private static byte[] encodeRequest(int mcc, int mnc, int cid, int lac) {
        boolean isUMTS = cid > 65535;
        int cidLen = cid > 65536 ? 5 : 3;
        Payload p = new Payload();
        p.writeUInt(14, 2);
        p.writeZeroFill(8);
        p.writeZeroFill(2);
        p.writeZeroFill(2);
        p.writeZeroFill(2);
        p.writeUInt(27, 1);
        p.writeUInt(mnc, 4);
        p.writeUInt(mcc, 4);
        p.writeZeroFill(3);
        p.writeUInt(cidLen, 1);
        p.writeZeroFill(2);
        p.writeUInt(cid, 4);
        p.writeUInt(lac, 4);
        p.writeUInt(mnc, 4);
        p.writeUInt(mcc, 4);
        p.writeUInt(255, 1);
        p.writeUInt(255, 1);
        p.writeUInt(255, 1);
        p.writeUInt(255, 1);
        p.writeZeroFill(4);
        byte[] b = p.getBytes();
        Print.logInfo((String)("Request length: " + b.length), (Object[])new Object[0]);
        return b;
    }

    private static GeoPoint decodeLocation(byte[] data) {
        if (data == null) {
            Print.logWarn((String)"Response is null", (Object[])new Object[0]);
            return null;
        }
        Print.logInfo((String)("Response length: " + data.length), (Object[])new Object[0]);
        Print.logInfo((String)("Response: " + StringTools.toHexString((byte[])data)), (Object[])new Object[0]);
        Print.logInfo((String)("Response: " + StringTools.toStringValue((byte[])data, (char)'.')), (Object[])new Object[0]);
        if (data.length < 7) {
            return null;
        }
        Payload p = new Payload(data);
        long optCode1 = p.readULong(2, 0L);
        long optCode2 = p.readULong(1, 0L);
        long success = p.readULong(4, 0L);
        if (success != 0L) {
            Print.logWarn((String)("Google Mobile Service Error: " + success), (Object[])new Object[0]);
        }
        double latitude = (double)p.readLong(4, 0L) / 1000000.0;
        double longitude = (double)p.readLong(4, 0L) / 1000000.0;
        return new GeoPoint(latitude, longitude);
    }

    public static MobileLocation _getMobileLocation(int mcc, int mnc, int cid, int lac, long timeout) {
        if (mcc > 0 || mnc > 0) {
            try {
                byte[] req = GoogleMobileService.encodeRequest(mcc, mnc, cid, lac);
                byte[] rsp = HTMLTools.readPage_POST((String)MOBILE_SERVICE_URI, (String)HTMLTools.MIME_BINARY(), (byte[])req, (int)((int)timeout));
                GeoPoint gp = GoogleMobileService.decodeLocation(rsp);
                return new MobileLocation(gp);
            }
            catch (Throwable th) {
                Print.logException((String)"Google Mobile API Error", (Throwable)th);
                return null;
            }
        }
        return null;
    }

    public static MobileLocation _getMobileLocation(CellTower servCT, CellTower[] nborCT, long timeoutMS) {
        if (servCT == null) {
            return null;
        }
        int mcc = servCT.getMobileCountryCode();
        int mnc = servCT.getMobileNetworkCode();
        int cid = servCT.getCellTowerID();
        int lac = servCT.getLocationAreaCode();
        return GoogleMobileService._getMobileLocation(mcc, mnc, cid, lac, timeoutMS);
    }

    public GoogleMobileService(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public MobileLocation getMobileLocation(CellTower servCT, CellTower[] nborCT) {
        long tmoMS = this.getProperties().getLong(PROP_timeoutMS, 5000L);
        return GoogleMobileService._getMobileLocation(servCT, nborCT, tmoMS);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        int mcc = RTConfig.getInt((String)"mcc", (int)-1);
        int mnc = RTConfig.getInt((String)"mnc", (int)-1);
        int cid = RTConfig.getInt((String)"cid", (int)-1);
        int lac = RTConfig.getInt((String)"lac", (int)-1);
        CellTower cti = new CellTower(mcc, mnc, -1, cid, lac, -1, -1);
        MobileLocation ml = GoogleMobileService._getMobileLocation(cti, null, -1L);
        Print.logInfo((String)("Mobile Location: " + ml), (Object[])new Object[0]);
    }
}

