/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.cellid;

import org.opengts.cellid.CellTower;
import org.opengts.cellid.MobileLocation;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.TriState;

public abstract class MobileLocationProviderAdapter {
    public static final String PROP_MobileLocationProvider_ = "MobileLocationProvider.";
    public static final String _PROP_isEnabled = ".isEnabled";
    private String name = null;
    private TriState isEnabled = TriState.UNKNOWN;
    private String accessKey = null;
    private RTProperties properties = null;
    private static final String[] ARG_HELP = new String[]{"helo"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_PLN = new String[]{"privateLabelName", "pln", "pl"};
    private static final String[] ARG_CID = new String[]{"cid", "cellID"};
    private static final String[] ARG_MCC = new String[]{"mcc"};
    private static final String[] ARG_MNC = new String[]{"mnc"};
    private static final String[] ARG_LAC = new String[]{"lac"};

    public MobileLocationProviderAdapter(String name, String key, RTProperties rtProps) {
        this.setName(name);
        this.setAuthorization(key);
        this.setProperties(rtProps);
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    public String getName() {
        return this.name != null ? this.name : "";
    }

    public boolean isEnabled() {
        if (this.isEnabled.isUnknown()) {
            String key = PROP_MobileLocationProvider_ + this.getName() + _PROP_isEnabled;
            if (RTConfig.getBoolean((String)key, (boolean)true)) {
                this.isEnabled = TriState.TRUE;
            } else {
                this.isEnabled = TriState.FALSE;
                Print.logWarn((String)("MobileLocationProvider disabled: " + this.getName()), (Object[])new Object[0]);
            }
        }
        return this.isEnabled.isTrue();
    }

    public void setAuthorization(String key) {
        this.accessKey = key;
    }

    public String getAuthorization() {
        return this.accessKey;
    }

    public void setProperties(RTProperties rtProps) {
        this.properties = rtProps;
    }

    public RTProperties getProperties() {
        if (this.properties == null) {
            this.properties = new RTProperties();
        }
        return this.properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        String auth = this.getAuthorization();
        if (!StringTools.isBlank((String)auth)) {
            sb.append(" [");
            sb.append(auth);
            sb.append("]");
        }
        return sb.toString();
    }

    public abstract MobileLocation getMobileLocation(CellTower var1, CellTower[] var2);

    private static void usage() {
        String n = MobileLocationProviderAdapter.class.getName();
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Description:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   Mobile Location Testing Tool ...", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("   java ... " + n + " -pln=<name> -cid=<CID> -mnc=<MNC> -mcc=<MCC> -lac=<LAC>"), (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -pln=<name>    PrivateLabel name/host", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -cid=<CID>     Cell Tower ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -mcc=<id>      Mobile Country Code", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -mnc=<id>      Mobile Network Code", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -lac=<id>      Location Area Code", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        if (RTConfig.hasProperty((String[])ARG_HELP)) {
            MobileLocationProviderAdapter.usage();
        }
        int cid = RTConfig.getInt((String[])ARG_CID, (int)565110);
        int mcc = RTConfig.getInt((String[])ARG_MCC, (int)240);
        int mnc = RTConfig.getInt((String[])ARG_MNC, (int)8);
        int lac = RTConfig.getInt((String[])ARG_LAC, (int)318);
        CellTower ct = new CellTower();
        ct.setCellTowerID(cid);
        ct.setMobileCountryCode(mcc);
        ct.setMobileNetworkCode(mnc);
        ct.setLocationAreaCode(lac);
        BasicPrivateLabel privLabel = null;
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        if (!StringTools.isBlank((String)accountID)) {
            Account acct = null;
            try {
                acct = Account.getAccount(accountID);
                if (acct == null) {
                    Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                    MobileLocationProviderAdapter.usage();
                }
                privLabel = acct.getPrivateLabel();
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
                System.exit(99);
            }
        } else {
            String pln = RTConfig.getString((String[])ARG_PLN, (String)"default");
            if (StringTools.isBlank((String)pln)) {
                Print.sysPrintln((String)"ERROR: Must specify '-account=<Account>'", (Object[])new Object[0]);
                MobileLocationProviderAdapter.usage();
            } else {
                privLabel = BasicPrivateLabelLoader.getPrivateLabel(pln);
                if (privLabel == null) {
                    Print.sysPrintln((String)"ERROR: PrivateLabel name not found: %s", (Object[])new Object[]{pln});
                    MobileLocationProviderAdapter.usage();
                }
            }
        }
        MobileLocationProvider mlp = privLabel.getMobileLocationProvider();
        if (mlp == null) {
            Print.sysPrintln((String)"ERROR: No MobileLocationProvider for PrivateLabel: %s", (Object[])new Object[]{privLabel.getName()});
            System.exit(99);
        } else if (!mlp.isEnabled()) {
            Print.sysPrintln((String)("WARNING: MobileLocationProvider disabled: " + mlp.getName()), (Object[])new Object[0]);
            System.exit(0);
        }
        MobileLocation ml = mlp.getMobileLocation(ct, null);
        Print.logInfo((String)("Mobile Location: " + ml), (Object[])new Object[0]);
    }
}

