/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.cellid;

import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.RTProperties;

public class MobileLocation
implements GeoPointProvider {
    public static final String ARG_GPS = "gps";
    public static final String ARG_ACC = "acc";
    private GeoPoint geoPoint = null;
    private double accuracyM = 0.0;

    private MobileLocation() {
    }

    public MobileLocation(MobileLocation other) {
        if (other != null) {
            this.setGeoPoint(other.getGeoPoint());
            this.setAccuracy(other.getAccuracy());
        }
    }

    public MobileLocation(double lat, double lon) {
        this(lat, lon, 0.0);
    }

    public MobileLocation(double lat, double lon, double accuracy) {
        this(GeoPoint.isValid((double)lat, (double)lon) ? new GeoPoint(lat, lon) : GeoPoint.INVALID_GEOPOINT, accuracy);
    }

    public MobileLocation(GeoPoint geoPoint) {
        this(geoPoint, 0.0);
    }

    public MobileLocation(GeoPoint geoPoint, double accuracy) {
        this.geoPoint = GeoPoint.isValid((GeoPoint)geoPoint) ? geoPoint : GeoPoint.INVALID_GEOPOINT;
        this.accuracyM = accuracy;
    }

    public void setGeoPoint(GeoPoint gps) {
        this.geoPoint = gps;
    }

    public boolean hasGeoPoint() {
        return GeoPoint.isValid((GeoPoint)this.geoPoint);
    }

    public GeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public boolean isValid() {
        return GeoPoint.isValid((GeoPoint)this.geoPoint);
    }

    public void setAccuracy(double meters) {
        this.accuracyM = meters > 0.0 ? meters : 0.0;
    }

    public boolean hasAccuracy() {
        return this.accuracyM > 0.0;
    }

    public double getAccuracy() {
        return this.accuracyM;
    }

    public RTProperties getRTProperties(RTProperties rtp) {
        if (rtp == null) {
            rtp = new RTProperties();
        }
        rtp.setString(ARG_GPS, this.getGeoPoint().toString());
        rtp.setLong(ARG_ACC, Math.round(this.getAccuracy()));
        return rtp;
    }

    public String toString() {
        return this.getRTProperties(null).toString();
    }
}

