/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.cellid;

import org.opengts.cellid.MobileLocation;
import org.opengts.util.GeoPoint;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class CellTower {
    public static final String ARG_MCC = "mcc";
    public static final String ARG_MNC = "mnc";
    public static final String ARG_LAC = "lac";
    public static final String ARG_CID = "cid";
    public static final String ARG_TAV = "tav";
    public static final String ARG_RAT = "rat";
    public static final String ARG_RXLEV = "rxlev";
    public static final String ARG_ARFCN = "arfcn";
    private String cellTowerName = null;
    private MobileLocation cellLocation = null;
    private int cellTowerID = -1;
    private int radioAccessTechnology = -1;
    private int mobileCountryCode = -1;
    private int mobileNetworkCode = -1;
    private int locationAreaCode = -1;
    private int arfChannelNumber = -1;
    private int receptionLevel = -1;
    private int timingAdvance = -1;

    public CellTower() {
        this._init(-1, -1, -1, -1, -1, -1, -1, -1);
    }

    public CellTower(CellTower other) {
        if (other != null) {
            this._init(other.getRadioAccessTechnology(), other.getMobileCountryCode(), other.getMobileNetworkCode(), other.getTimingAdvance(), other.getCellTowerID(), other.getLocationAreaCode(), other.getAbsoluteRadioFrequencyChannelNumber(), other.getReceptionLevel());
            this.setName(other.getName());
            if (other.hasMobileLocation()) {
                this.setMobileLocation(new MobileLocation(other.getMobileLocation()));
            }
        }
    }

    public CellTower(int mcc, int mnc, int tav, int cid, int lac, int arfcn, int rxlev) {
        this._init(-1, mcc, mnc, tav, cid, lac, arfcn, rxlev);
    }

    public CellTower(int rat, int mcc, int mnc, int tav, int cid, int lac, int arfcn, int rxlev) {
        this._init(rat, mcc, mnc, tav, cid, lac, arfcn, rxlev);
    }

    public CellTower(int cid, int lac, int arfcn, int rxlev) {
        this._init(-1, -1, -1, -1, cid, lac, arfcn, rxlev);
    }

    public CellTower(String cidStr) {
        this(new RTProperties(cidStr));
    }

    public CellTower(RTProperties cidp) {
        if (cidp != null) {
            int rat = cidp.getInt(ARG_RAT, -1);
            int mcc = cidp.getInt(ARG_MCC, -1);
            int mnc = cidp.getInt(ARG_MNC, -1);
            int tav = cidp.getInt(ARG_TAV, -1);
            int cid = cidp.getInt(ARG_CID, -1);
            int lac = cidp.getInt(ARG_LAC, -1);
            int arfcn = cidp.getInt(ARG_ARFCN, -1);
            int rxlev = cidp.getInt(ARG_RXLEV, -1);
            this._init(rat, mcc, mnc, tav, cid, lac, arfcn, rxlev);
        }
    }

    private void _init(int rat, int mcc, int mnc, int tav, int cid, int lac, int arfcn, int rxlev) {
        this.radioAccessTechnology = rat;
        this.mobileCountryCode = mcc;
        this.mobileNetworkCode = mnc;
        this.timingAdvance = tav;
        this.cellTowerID = cid;
        this.locationAreaCode = lac;
        this.arfChannelNumber = arfcn;
        this.receptionLevel = rxlev;
    }

    public boolean isValid() {
        return this.getCellTowerID() > 0;
    }

    public void setName(String name) {
        this.cellTowerName = !StringTools.isBlank((String)name) ? name.trim() : null;
    }

    public String getName() {
        return this.cellTowerName;
    }

    public void setMobileLocation(MobileLocation mobLoc) {
        this.cellLocation = mobLoc;
    }

    public void setMobileLocation(GeoPoint gp, double accuracy) {
        if (this.cellLocation != null) {
            this.cellLocation.setGeoPoint(gp);
            this.cellLocation.setAccuracy(accuracy);
        } else {
            this.cellLocation = new MobileLocation(gp, accuracy);
        }
    }

    public MobileLocation getMobileLocation() {
        return this.cellLocation;
    }

    public boolean hasMobileLocation() {
        return this.cellLocation != null;
    }

    public void setRadioAccessTechnology(int rat) {
        this.radioAccessTechnology = rat;
    }

    public int getRadioAccessTechnology() {
        return this.radioAccessTechnology;
    }

    public boolean hasRadioAccessTechnology() {
        return this.radioAccessTechnology >= 0;
    }

    public String getRadioAccessTechnologyString() {
        return this.hasRadioAccessTechnology() ? String.valueOf(this.getRadioAccessTechnology()) : "";
    }

    public void setMobileCountryCode(int mcc) {
        this.mobileCountryCode = mcc;
    }

    public int getMobileCountryCode() {
        return this.mobileCountryCode;
    }

    public boolean hasMobileCountryCode() {
        return this.mobileCountryCode >= 0;
    }

    public String getMobileCountryCodeString() {
        return this.hasMobileCountryCode() ? String.valueOf(this.getMobileCountryCode()) : "";
    }

    public void setMobileNetworkCode(int mnc) {
        this.mobileNetworkCode = mnc;
    }

    public int getMobileNetworkCode() {
        return this.mobileNetworkCode;
    }

    public boolean hasMobileNetworkCode() {
        return this.mobileNetworkCode >= 0;
    }

    public String getMobileNetworkCodeString() {
        return this.hasMobileNetworkCode() ? String.valueOf(this.getMobileNetworkCode()) : "";
    }

    public void setTimingAdvance(int tav) {
        this.timingAdvance = tav;
    }

    public int getTimingAdvance() {
        return this.timingAdvance;
    }

    public boolean hasTimingAdvance() {
        return this.timingAdvance >= 0;
    }

    public String getTimingAdvanceString() {
        return this.hasTimingAdvance() ? String.valueOf(this.getTimingAdvance()) : "";
    }

    public void setCellTowerID(int cid) {
        this.cellTowerID = cid;
    }

    public int getCellTowerID() {
        return this.cellTowerID;
    }

    public boolean hasCellTowerID() {
        return this.cellTowerID >= 0;
    }

    public String getCellTowerIDString() {
        return this.hasCellTowerID() ? String.valueOf(this.getCellTowerID()) : "";
    }

    public void setLocationAreaCode(int lac) {
        this.locationAreaCode = lac;
    }

    public int getLocationAreaCode() {
        return this.locationAreaCode;
    }

    public boolean hasLocationAreaCode() {
        return this.locationAreaCode >= 0;
    }

    public String getLocationAreaCodeString() {
        return this.hasLocationAreaCode() ? String.valueOf(this.getLocationAreaCode()) : "";
    }

    public void setAbsoluteRadioFrequencyChannelNumber(int arfcn) {
        this.arfChannelNumber = arfcn;
    }

    public int getAbsoluteRadioFrequencyChannelNumber() {
        return this.arfChannelNumber;
    }

    public boolean hasAbsoluteRadioFrequencyChannelNumber() {
        return this.arfChannelNumber >= 0;
    }

    public String getAbsoluteRadioFrequencyChannelNumberString() {
        return this.hasAbsoluteRadioFrequencyChannelNumber() ? String.valueOf(this.getAbsoluteRadioFrequencyChannelNumber()) : "";
    }

    public void setReceptionLevel(int rxlev) {
        this.receptionLevel = rxlev;
    }

    public int getReceptionLevel() {
        return this.receptionLevel;
    }

    public boolean hasReceptionLevel() {
        return this.receptionLevel >= 0;
    }

    public String getReceptionLevelString() {
        return this.hasReceptionLevel() ? String.valueOf(this.getReceptionLevel()) : "";
    }

    public RTProperties getRTProperties(RTProperties cidp) {
        if (cidp == null) {
            cidp = new RTProperties();
        }
        if (this.hasRadioAccessTechnology()) {
            cidp.setInt(ARG_RAT, this.getRadioAccessTechnology());
        } else {
            cidp.removeProperty((Object)ARG_RAT);
        }
        if (this.hasMobileCountryCode()) {
            cidp.setInt(ARG_MCC, this.getMobileCountryCode());
        } else {
            cidp.removeProperty((Object)ARG_MCC);
        }
        if (this.hasMobileNetworkCode()) {
            cidp.setInt(ARG_MNC, this.getMobileNetworkCode());
        } else {
            cidp.removeProperty((Object)ARG_MNC);
        }
        if (this.hasTimingAdvance()) {
            cidp.setInt(ARG_TAV, this.getTimingAdvance());
        } else {
            cidp.removeProperty((Object)ARG_TAV);
        }
        if (this.hasCellTowerID()) {
            cidp.setInt(ARG_CID, this.getCellTowerID());
        } else {
            cidp.removeProperty((Object)ARG_CID);
        }
        if (this.hasLocationAreaCode()) {
            cidp.setInt(ARG_LAC, this.getLocationAreaCode());
        } else {
            cidp.removeProperty((Object)ARG_LAC);
        }
        if (this.hasAbsoluteRadioFrequencyChannelNumber()) {
            cidp.setInt(ARG_ARFCN, this.getAbsoluteRadioFrequencyChannelNumber());
        } else {
            cidp.removeProperty((Object)ARG_ARFCN);
        }
        if (this.hasReceptionLevel()) {
            cidp.setInt(ARG_RXLEV, this.getReceptionLevel());
        } else {
            cidp.removeProperty((Object)ARG_RXLEV);
        }
        if (this.hasMobileLocation()) {
            this.getMobileLocation().getRTProperties(cidp);
        } else {
            cidp.removeProperty((Object)"gps");
            cidp.removeProperty((Object)"acc");
        }
        return cidp;
    }

    public String toString() {
        return this.getRTProperties(null).toString();
    }

    public boolean equals(Object other) {
        if (other instanceof CellTower) {
            CellTower oct = (CellTower)other;
            if (this.cellTowerID != oct.cellTowerID) {
                return false;
            }
            if (this.radioAccessTechnology != oct.radioAccessTechnology) {
                return false;
            }
            if (this.mobileCountryCode != oct.mobileCountryCode) {
                return false;
            }
            if (this.mobileNetworkCode != oct.mobileNetworkCode) {
                return false;
            }
            if (this.locationAreaCode != oct.locationAreaCode) {
                return false;
            }
            if (this.arfChannelNumber != oct.arfChannelNumber) {
                return false;
            }
            if (this.receptionLevel != oct.receptionLevel) {
                return false;
            }
            return this.timingAdvance == oct.timingAdvance;
        }
        return false;
    }
}

