/*
 * Decompiled with CFR 0.152.
 */
package org.opengts;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.opengts.util.DateTime;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;

public class Version {
    public static final String COPYRIGHT = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
    private static final String VERSION = "2.5.3-B05";
    public static final String GTS_ENTERPRISE_PREFIX = "E";
    public static final String COMPILED_VERSION = "E2.5.3-B05";
    private static final long COMPILE_TIMESTAMP = 1415031708L;
    private static final long PACKAGE_TIMESTAMP = 1381278982L;
    public static final String SERVICE_ACCOUNT_ID = "mutinda";

    public static void initVersionProperty() {
        RTProperties constantProps = RTConfig.getRuntimeConstantProperties();
        if (!constantProps.hasProperty((Object)"%version")) {
            constantProps.setProperty((Object)"%version", (Object)Version.getVersion());
        }
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static String getVersion() {
        return COMPILED_VERSION;
    }

    public static long getPackageTimestamp() {
        return 1381278982L;
    }

    public static long getCompileTimestamp() {
        return 1415031708L;
    }

    public static String getCompileTime() {
        return new DateTime(1415031708L).toString();
    }

    public static String getServiceAccountID() {
        String sai = RTConfig.getString((String)"ServiceAccount.ID", (String)"?");
        return sai.equals(SERVICE_ACCOUNT_ID) ? sai : sai + "[" + SERVICE_ACCOUNT_ID + "]";
    }

    public static String getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(COPYRIGHT).append("\n");
        sb.append("Version: ").append(Version.getVersion()).append(" [").append(Version.getServiceAccountID()).append("]").append("\n");
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz", Locale.US);
        String dfmt = dateFmt.format(new Date(1381278982000L));
        sb.append("Package: [1381278982] " + dfmt + "\n");
        dfmt = dateFmt.format(new Date(1415031708000L));
        sb.append("Compile: [1415031708] " + dfmt + "\n");
        return sb.toString();
    }

    public static void main(String[] argv) {
        if (argv.length > 0 && argv[0].equals("-info")) {
            System.out.println(Version.getInfo());
        } else if (argv.length > 0 && argv[0].equals("-package")) {
            System.out.println(Version.getPackageTimestamp());
        } else if (argv.length > 0 && argv[0].equals("-compile")) {
            System.out.println(Version.getCompileTimestamp());
        } else {
            System.out.println(Version.getVersion());
        }
    }
}

