/*
 * Decompiled with CFR 0.152.
 */
package org.opengts;

import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.Version;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.EventDataProvider;
import org.opengts.db.EventUtil;
import org.opengts.db.GeneralPasswordHandler;
import org.opengts.db.PasswordHandler;
import org.opengts.db.RuleFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class StartupInit
implements DBConfig.DBInitialization,
DBFactory.CustomFactoryHandler {
    private String PROP_RuleFactory_class = "RuleFactory.class";
    private String PROP_PasswordHandler_class = "PasswordHandler.class";
    private String[] PROP_OptionalEventFields_FleetMap = new String[]{"OptionalEventFields.FleetMap", "OptionalEventFields.GroupMap", "OptionalEventFields.Device"};
    private String[] PROP_OptionalEventFields_DeviceMap = new String[]{"OptionalEventFields.DeviceMap", "OptionalEventFields.EventData"};
    private boolean didInitRuleFactory = false;
    private RuleFactory ruleFactoryInstance = null;
    private static final String KEY_fuelLevel = "fuelLevel";
    private static final String KEY_fuelLevelVolume = "fuelLevelVolume";
    private static final String KEY_elapsedTimeStopped = "elapsedTimeStopped";
    private static final String KEY_geozoneName = "geozoneName";
    private static final String KEY_lastFuelLevel = "lastFuelLevel";
    private static final String KEY_lastFuelLevelVolume = "lastFuelLevelVolume";

    public StartupInit() {
        RTProperties cfgFileProps = RTConfig.getConfigFileProperties();
        String userAgent = cfgFileProps.getString("http.userAgent", null, false);
        if (StringTools.isBlank((String)userAgent)) {
            cfgFileProps.setString("http.userAgent", "OpenGTS/" + Version.getVersion());
        }
    }

    @Override
    public void preInitialization() {
        if (RTConfig.isWebApp()) {
            OSTools.printMemoryUsage();
        }
    }

    @Override
    public void addTableFactories() {
        RuleFactory rf;
        DBConfig.addTableFactories();
        if (!Device.hasRuleFactory() && (rf = this._getRuleFactoryInstance()) != null) {
            Device.setRuleFactory(rf);
            Print.logInfo((String)("RuleFactory installed: " + StringTools.className((Object)rf)), (Object[])new Object[0]);
        }
        EventUtil.OptionalEventFields optEvFlds = this.createOptionalEventFieldsHandler();
        EventUtil.setOptionalEventFieldHandler(optEvFlds);
        Print.logDebug((String)("Installed OptionalEventFieldHandler: " + StringTools.className((Object)optEvFlds)), (Object[])new Object[0]);
    }

    private RuleFactory _getRuleFactoryInstance() {
        if (this.ruleFactoryInstance != null) {
            return this.ruleFactoryInstance;
        }
        if (this.didInitRuleFactory) {
            return null;
        }
        this.didInitRuleFactory = true;
        Class<?> rfClass = null;
        String rfClassName = RTConfig.getString((String)this.PROP_RuleFactory_class, null);
        try {
            String rfcName = !StringTools.isBlank((String)rfClassName) ? rfClassName : "org.opengts.extra.rule.RuleFactoryLite";
            rfClass = Class.forName(rfcName);
            rfClassName = rfcName;
        }
        catch (Throwable th) {
            if (!StringTools.isBlank((String)rfClassName)) {
                Print.logException((String)("Unable to locate RuleFactory class: " + rfClassName), (Throwable)th);
            }
            return null;
        }
        try {
            this.ruleFactoryInstance = (RuleFactory)rfClass.newInstance();
            return this.ruleFactoryInstance;
        }
        catch (Throwable th) {
            Print.logException((String)("Unable to instantiate RuleFactory: " + rfClassName), (Throwable)th);
            return null;
        }
    }

    protected EVField[] parseFields(DBFactory factory, String[] flda) {
        if (factory == null) {
            return null;
        }
        if (ListTools.isEmpty((Object[])flda)) {
            return null;
        }
        Vector<EVField> fldList = new Vector<EVField>();
        for (int i = 0; i < flda.length; ++i) {
            String n = StringTools.trim((String)flda[i]);
            if (StringTools.isBlank((String)n)) continue;
            DBField dfld = factory.getField(n);
            fldList.add(dfld != null ? new EVField(dfld) : new EVField(n));
        }
        return !ListTools.isEmpty(fldList) ? fldList.toArray(new EVField[fldList.size()]) : null;
    }

    protected EventUtil.OptionalEventFields createOptionalEventFieldsHandler() {
        boolean useEventDataToResolveFields = true;
        final EVField[] optFleetFields = this.parseFields(Device.getFactory(), RTConfig.getStringArray((String[])this.PROP_OptionalEventFields_FleetMap, null));
        final EVField[] optVehicFields = this.parseFields(EventData.getFactory(), RTConfig.getStringArray((String[])this.PROP_OptionalEventFields_DeviceMap, null));
        return new EventUtil.OptionalEventFields(){

            @Override
            public int getOptionalEventFieldCount(boolean isFleet) {
                if (isFleet) {
                    return ListTools.size((Object[])optFleetFields);
                }
                return ListTools.size((Object[])optVehicFields);
            }

            @Override
            public String getOptionalEventFieldTitle(int ndx, boolean isFleetMap, Locale locale) {
                if (ndx < 0) {
                    return "";
                }
                I18N i18n = I18N.getI18N(StartupInit.class, (Locale)locale);
                if (isFleetMap) {
                    if (ndx >= ListTools.size((Object[])optFleetFields)) {
                        return "";
                    }
                    String name = optFleetFields[ndx].getName();
                    if (name.equalsIgnoreCase("linkURL")) {
                        DBField dbfld = optFleetFields[ndx].getDBField();
                        return dbfld.getTitle(locale);
                    }
                    String val = EventData.getKeyFieldTitle(name, "", locale);
                    return StringTools.trim((Object)val);
                }
                if (ndx >= ListTools.size((Object[])optVehicFields)) {
                    return "";
                }
                String name = optVehicFields[ndx].getName();
                String val = EventData.getKeyFieldTitle(name, "", locale);
                return StringTools.trim((Object)val);
            }

            @Override
            public String getOptionalEventFieldValue(int ndx, boolean isFleetMap, Locale locale, EventDataProvider edp) {
                if (ndx < 0) {
                    return "";
                }
                if (!(edp instanceof EventData)) {
                    return "";
                }
                EventData event = (EventData)edp;
                Account account = event.getAccount();
                Device device = event.getDevice();
                if (account == null || device == null) {
                    return "";
                }
                if (isFleetMap) {
                    if (ndx >= ListTools.size((Object[])optFleetFields)) {
                        return "";
                    }
                    String name = optFleetFields[ndx].getName();
                    if (name.equalsIgnoreCase("linkURL")) {
                        String url = device.getLinkURL();
                        if (!StringTools.isBlank((String)url)) {
                            String desc = device.getLinkDescription();
                            if (StringTools.isBlank((String)desc)) {
                                BasicPrivateLabel bpl = Account.getPrivateLabel(account);
                                I18N i18n = I18N.getI18N(StartupInit.class, (Locale)bpl.getLocale());
                                desc = i18n.getString("StartupInit.info.link", "Link");
                            }
                            String a = "<a href='" + url + "' target='_blank'>" + desc + "</a>";
                            return a;
                        }
                        return "";
                    }
                    BasicPrivateLabel bpl = Account.getPrivateLabel(account);
                    String val = event.getKeyFieldValue(name, "", bpl);
                    return StringTools.trim((Object)val);
                }
                if (ndx >= ListTools.size((Object[])optVehicFields)) {
                    return "";
                }
                String name = optVehicFields[ndx].getName();
                BasicPrivateLabel bpl = Account.getPrivateLabel(account);
                String val = event.getKeyFieldValue(name, "", bpl);
                return StringTools.trim((Object)val);
            }
        };
    }

    @Override
    public void postInitialization() {
        StatusCodes.initStatusCodes(null);
        this.initPasswordHandler();
    }

    protected void initPasswordHandler() {
        String phClassName = RTConfig.getString((String)this.PROP_PasswordHandler_class, null);
        if (!StringTools.isBlank((String)phClassName)) {
            if (phClassName.equalsIgnoreCase("md5")) {
                RTProperties rtp = new RTProperties();
                rtp.setString("passwordEncoding", "md5");
                GeneralPasswordHandler pwh = new GeneralPasswordHandler(rtp);
                Account.setDefaultPasswordHandler(pwh);
            } else if (phClassName.equalsIgnoreCase("md5plain")) {
                RTProperties rtp = new RTProperties();
                rtp.setString("passwordEncoding", "md5plain");
                GeneralPasswordHandler pwh = new GeneralPasswordHandler(rtp);
                Account.setDefaultPasswordHandler(pwh);
            } else if (phClassName.equalsIgnoreCase("default")) {
                GeneralPasswordHandler pwh = new GeneralPasswordHandler();
                Account.setDefaultPasswordHandler(pwh);
            } else {
                try {
                    Class<?> phClass = Class.forName(phClassName);
                    PasswordHandler pwh = (PasswordHandler)phClass.newInstance();
                    Account.setDefaultPasswordHandler(pwh);
                }
                catch (Throwable th) {
                    Print.logException((String)("Unable to instantiate PasswordHandler: " + phClassName), (Throwable)th);
                }
            }
        }
    }

    public <T extends DBRecord<T>> DBFactory<T> createDBFactory(String tableName, DBField[] field, DBFactory.KeyType keyType, Class<T> rcdClass, Class<? extends DBRecordKey<T>> keyClass, boolean editable, boolean viewable) {
        return null;
    }

    public List<DBField> selectFields(DBFactory factory, List<DBField> fields) {
        String tblName = factory.getUntranslatedTableName();
        if (tblName.equalsIgnoreCase(Account.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.Account.AddressFieldInfo", false, Account.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.MapLegendFieldInfo", false, Account.MapLegendFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.AccountManagerInfo", false, Account.AccountManagerInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.DataPushInfo", false, Account.DataPushInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(User.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.User.AddressFieldInfo", false, User.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.User.ExtraFieldInfo", false, User.ExtraFieldInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(Device.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.Device.NotificationFieldInfo", false, Device.NotificationFieldInfo);
            boolean devGC = DBConfig.hasRulePackage();
            this.addDBFields(tblName, fields, "startupInit.Device.GeoCorridorFieldInfo", devGC, Device.GeoCorridorFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.FixedLocationFieldInfo", false, Device.FixedLocationFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.LinkFieldInfo", false, Device.LinkFieldInfo);
            boolean devBC = Account.SupportsBorderCrossing();
            this.addDBFields(tblName, fields, "startupInit.Device.BorderCrossingFieldInfo", devBC, Device.BorderCrossingFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.MaintOdometerFieldInfo", false, Device.MaintOdometerFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.WorkOrderInfo", false, Device.WorkOrderInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.DataPushInfo", false, Device.DataPushInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(DeviceGroup.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.DeviceGroup.WorkOrderInfo", false, DeviceGroup.WorkOrderInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(EventData.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.EventData.AutoIncrementIndex", false, EventData.AutoIncrementIndex);
            this.addDBFields(tblName, fields, "startupInit.EventData.CreationTimeMillisecond", false, EventData.CreationTimeMillisecond);
            this.addDBFields(tblName, fields, "startupInit.EventData.AddressFieldInfo", false, EventData.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.GPSFieldInfo", false, EventData.GPSFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.CustomFieldInfo", false, EventData.CustomFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.GarminFieldInfo", false, EventData.GarminFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.CANBUSFieldInfo", false, EventData.CANBUSFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.AtmosphereFieldInfo", false, EventData.AtmosphereFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.ThermoFieldInfo", false, EventData.ThermoFieldInfo, 4);
            this.addDBFields(tblName, fields, "startupInit.EventData.AnalogFieldInfo", false, EventData.AnalogFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.EndOfDaySummary", false, EventData.EndOfDaySummary);
            this.addDBFields(tblName, fields, "startupInit.EventData.ServingCellTowerData", false, EventData.ServingCellTowerData);
            this.addDBFields(tblName, fields, "startupInit.EventData.NeighborCellTowerData", false, EventData.NeighborCellTowerData);
            this.addDBFields(tblName, fields, "startupInit.EventData.WorkZoneGridData", false, EventData.WorkZoneGridData);
            this.addDBFields(tblName, fields, "startupInit.EventData.LeaseRentalData", false, EventData.LeaseRentalData);
            return fields;
        }
        if (tblName.equalsIgnoreCase(Geozone.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.Geozone.PriorityFieldInfo", false, Geozone.PriorityFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Geozone.CorridorFieldInfo", false, Geozone.CorridorFieldInfo);
            return fields;
        }
        return fields;
    }

    protected void addDBFields(String tblName, List<DBField> tblFields, String key, boolean defaultAdd, DBField[] customFields) {
        this.addDBFields(tblName, tblFields, key, defaultAdd, customFields, -1);
    }

    protected void addDBFields(String tblName, List<DBField> tblFields, String key, boolean defaultAdd, DBField[] customFields, int maxCount) {
        boolean addFields = false;
        if (StringTools.isBlank((String)key)) {
            addFields = defaultAdd;
        } else if (maxCount >= 0) {
            int valInt;
            String keyVal = RTConfig.getString((String)key, null);
            int n = valInt = StringTools.isInt((String)keyVal, (boolean)true) ? StringTools.parseInt((String)keyVal, (int)-1) : -1;
            if (valInt > 0) {
                maxCount = valInt;
                addFields = true;
            } else {
                addFields = maxCount > 0 ? RTConfig.getBoolean((String)key, (boolean)defaultAdd) : false;
            }
        } else {
            addFields = RTConfig.getBoolean((String)key, (boolean)defaultAdd);
        }
        if (addFields) {
            int cnt = maxCount >= 0 && maxCount <= customFields.length ? maxCount : customFields.length;
            for (int i = 0; i < cnt; ++i) {
                tblFields.add(customFields[i]);
            }
        }
    }

    private static class EVField {
        private String name = "";
        private DBField field = null;

        public EVField(String name) {
            this.name = StringTools.trim((String)name);
            this.field = null;
        }

        public EVField(DBField field) {
            this.name = field != null ? field._getName() : "";
            this.field = field;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasDBField() {
            return this.field != null;
        }

        public DBField getDBField() {
            return this.field;
        }
    }
}

