/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class WinTools {
    public static boolean isWindowFocused(Window w) {
        if (w == null) {
            return false;
        }
        if (w.isFocused()) {
            return true;
        }
        Window[] childWin = w.getOwnedWindows();
        if (childWin != null && childWin.length > 0) {
            for (int i = 0; i < childWin.length; ++i) {
                if (!WinTools.isWindowFocused(childWin[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static Window getParentWindow(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Window) {
            return (Window)c;
        }
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, c);
    }

    public static Dialog getParentDialog(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Dialog) {
            return (Dialog)c;
        }
        return (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, c);
    }

    public static Frame getParentFrame(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Frame) {
            return (Frame)c;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
    }
}

