/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.WindowConstants;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFrame;
import org.opengts.util.Print;

public class VWindow
extends JWindow
implements WindowConstants {
    private VBox contentBox = null;
    private JPanel buttonBox = null;
    private JPanel buttonBoxFiller = null;
    private boolean buttonBoxDivider = true;
    private boolean exitOnHide = false;
    private boolean isModal = false;
    private boolean modalBlock = false;
    private Map<String, Object> attributeMap = null;
    private static boolean SET_INVISIBLE_WHILE_RESIZING = true;
    private int isSettingBounds = 0;

    public VWindow() {
        this((Object)null);
    }

    public VWindow(Object owner) {
        this.initVWindow();
    }

    protected void initVWindow() {
        this.contentBox = new VBox(null, null, false);
        this.contentBox.setGBCX(0.5, 0, 1);
        this.contentBox.setGBCY(0.0, -1, 1);
        this.setContentPane(this.contentBox);
        this.initComponentListener();
        this.initWindowListener();
    }

    protected void initComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowMoved();
                }
            }

            @Override
            public void componentResized(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowResized();
                }
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowHidden();
                }
            }
        });
    }

    protected void windowMoved() {
    }

    protected void windowResized() {
    }

    protected void windowHidden() {
    }

    protected void initWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowOpened();
                }
            }

            @Override
            public void windowIconified(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowIconified();
                }
            }

            @Override
            public void windowDeiconified(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowDeiconified();
                }
            }
        });
    }

    protected void windowOpened() {
    }

    protected void windowIconified() {
    }

    protected void windowDeiconified() {
    }

    public VBox getContentBox() {
        return this.contentBox;
    }

    public void setModal(boolean modal) {
        this.isModal = modal;
    }

    public boolean isModal() {
        return this.isModal;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Container container = this.getContentPane();
        if (container instanceof JPanel) {
            ((JPanel)container).setBackground(color);
            ((JPanel)container).setOpaque(true);
        }
    }

    public void maximizeOnScreen() {
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(0, 0, scr.width, scr.height);
    }

    public void centerOnScreen(Dimension winSize, Dimension offset) {
        if (winSize == null || winSize.width <= 0 || winSize.height <= 0) {
            int w = winSize != null ? winSize.width : -1;
            int h = winSize != null ? winSize.height : -1;
            this.pack();
            winSize = new Dimension(this.getPreferredSize());
            if (w > 0) {
                winSize.width = w;
            }
            if (h > 0) {
                winSize.height = h;
            }
        }
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (scr.width - winSize.width) / 2;
        int y = (scr.height - winSize.height) / 2;
        if (offset != null) {
            x += offset.width;
            y += offset.height;
        }
        this.setBounds(x, y, winSize.width, winSize.height);
    }

    public void centerOnScreen(Dimension winSize) {
        this.centerOnScreen(winSize, null);
    }

    public void centerOnScreen(int width, int height, int ofsWidth, int ofsHeight) {
        this.centerOnScreen(new Dimension(width, height), new Dimension(ofsWidth, ofsHeight));
    }

    public void centerOnScreen(int width, int height) {
        this.centerOnScreen(new Dimension(width, height), null);
    }

    public void centerOnScreen() {
        this.centerOnScreen(this.getSize(), null);
    }

    public boolean isSettingBounds() {
        return this.isSettingBounds > 0;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle r = this.getBounds();
        if (x != r.x || y != r.y || w != r.width || h != r.height) {
            ++this.isSettingBounds;
            boolean wasVisible = false;
            if (SET_INVISIBLE_WHILE_RESIZING && this.isVisible()) {
                Print.logDebug((String)"Setting window invisible before moving ...", (Object[])new Object[0]);
                wasVisible = true;
                this.setVisible(false);
            }
            super.setBounds(x, y, w, h);
            if (SET_INVISIBLE_WHILE_RESIZING && wasVisible) {
                this.setVisible(true);
            }
            --this.isSettingBounds;
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (!this.isSettingBounds()) {
            Print.logStackTrace((String)("Reshaping: " + x + "/" + y));
        }
        super.reshape(x, y, width, height);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void show() {
        if (this.isModal()) {
            this.showModal();
        } else {
            super.show();
        }
    }

    public void showModal() {
        super.show();
        this.modalBlock = true;
        while (this.modalBlock && this.processModalEvents()) {
        }
    }

    @Override
    public void hide() {
        this.modalBlock = false;
        super.hide();
        if (this.exitOnHide) {
            System.exit(0);
        }
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    private boolean processModalEvents() {
        try {
            AWTEvent event;
            boolean eventOK;
            EventQueue theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            do {
                event = theQueue.getNextEvent();
                eventOK = true;
                int eventID = event.getID();
                if ((eventID < 500 || eventID > 507) && (eventID < 1001 || eventID > 1001)) continue;
                Object src = event.getSource();
                if (src instanceof Component) {
                    Component c;
                    for (c = (Component)src; c != this && c != null; c = c.getParent()) {
                    }
                    if (c == this) continue;
                    eventOK = false;
                    this._consumeEvent(theQueue, event);
                    continue;
                }
                Print.logDebug((String)("Source: " + src), (Object[])new Object[0]);
            } while (!eventOK);
            this._dispatchEvent(theQueue, event);
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
        catch (Throwable t) {
            Print.logException((String)"Processing Modal events", (Throwable)t);
            return true;
        }
    }

    private void _consumeEvent(EventQueue theQueue, AWTEvent event) {
        Print.logDebug((String)("Consume event: " + event), (Object[])new Object[0]);
    }

    private void _dispatchEvent(EventQueue theQueue, AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else {
            System.err.println("unable to dispatch event: " + event);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent we) {
        super.processWindowEvent(we);
    }

    private Map<String, Object> getAttrMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    public void setAttribute(String key, Object val) {
        if (key != null) {
            if (val != null) {
                this.getAttrMap().put(key, val);
            } else {
                this.getAttrMap().remove(key);
            }
        }
    }

    public Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public Object getAttribute(String key, Object dftValue) {
        if (key != null) {
            Object obj = this.getAttrMap().get(key);
            return obj != null ? obj : dftValue;
        }
        return dftValue;
    }

    public static void showTestComponent(Component c) {
        VWindow frame = new VWindow();
        frame.centerOnScreen(400, 400);
        VBox container = frame.getContentBox();
        container.setGBCY(0.5, 0, 1);
        container.add(c, container.getDefaultGBC());
        frame.setVisible(true);
    }

    public static void main(String[] argv) {
        SET_INVISIBLE_WHILE_RESIZING = false;
        VWindow win = new VWindow();
        win.maximizeOnScreen();
        win.setVisible(true);
        try {
            Thread.sleep(5000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }
}

