/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VTree;
import org.opengts.util.Print;

public class VTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    protected JPopupMenu popupMenu = null;
    protected VPopupMenuProvider popupProvider = null;
    protected Component view = null;
    protected Icon leafIcon = null;
    protected Icon disabledLeafIcon = null;
    protected Icon openIcon = null;
    protected Icon closedIcon = null;
    protected Color enabledColor = null;
    protected Color disabledColor = Color.gray;
    protected boolean isParentEnabled = true;
    protected boolean isEnabled = true;
    protected String toolTipText = null;

    public VTreeNode() {
    }

    public VTreeNode(Object usrObj) {
        super(usrObj);
    }

    public VTreeNode(Object usrObj, boolean allowChildren) {
        super(usrObj, allowChildren);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode tnode = this.getChildAt(i);
            if (!(tnode instanceof VTreeNode)) continue;
            ((VTreeNode)tnode).setParentEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled && this.isParentEnabled;
    }

    protected void setParentEnabled(boolean enabled) {
        this.isParentEnabled = enabled;
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        super.setParent(newParent);
        if (newParent instanceof VTreeNode) {
            boolean parentEnabled = ((VTreeNode)newParent).isEnabled();
            this.setEnabled(parentEnabled);
        }
    }

    @Override
    public TreeNode getParent() {
        return super.getParent();
    }

    @Override
    public void setAllowsChildren(boolean allows) {
        super.setAllowsChildren(allows);
    }

    @Override
    public boolean getAllowsChildren() {
        return super.getAllowsChildren();
    }

    public VTreeNode[] getChildren() {
        int len = this.getChildCount();
        VTreeNode[] children = new VTreeNode[len];
        for (int i = 0; i < len; ++i) {
            children[i] = (VTreeNode)this.getChildAt(i);
        }
        return children;
    }

    public boolean hasChildren() {
        return this.getChildCount() > 0;
    }

    public int getInsertionIndex(Object userObj, Comparator<Object> comparator) {
        VTreeNode node;
        Object nodeObj;
        int insertIndex;
        int childCount = this.getChildCount();
        if (comparator == null) {
            return childCount;
        }
        for (insertIndex = 0; insertIndex < childCount && comparator.compare(userObj, nodeObj = (node = (VTreeNode)this.getChildAt(insertIndex)).getUserObject()) > 0; ++insertIndex) {
        }
        return insertIndex;
    }

    public boolean containsChild(VTreeNode childNode) {
        if (childNode != null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TreeNode tnode = this.getChildAt(i);
                if (childNode != tnode && !childNode.equals(tnode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TreeNode getChildAt(int index) {
        try {
            return super.getChildAt(index);
        }
        catch (ArrayIndexOutOfBoundsException aioe) {
            Print.logError((String)("[ROOT] Invalid child node index: " + index), (Object[])new Object[0]);
            return null;
        }
    }

    public Object[] getChildObjects() {
        return null;
    }

    public void populateChildren(VTree tree) {
        Object[] children = this.getChildObjects();
        if (children != null) {
            tree.addUserObjects(this, children, true);
        }
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    @Override
    public void removeFromParent() {
        super.removeFromParent();
    }

    public void setPopupMenu(JPopupMenu pum) {
        this.popupMenu = pum;
    }

    public void setPopupMenuProvider(VPopupMenuProvider pmp) {
        this.popupProvider = pmp;
    }

    public VPopupMenuProvider getPopupMenuProvider() {
        return this.popupProvider;
    }

    public JPopupMenu getPopupMenu() {
        if (this.isEnabled()) {
            if (this.popupMenu != null) {
                return this.popupMenu;
            }
            if (this.popupProvider != null) {
                return this.popupProvider.getPopupMenu();
            }
            return null;
        }
        return null;
    }

    public void setCustomView(Component c) {
        this.view = c;
    }

    public Component getCustomView() {
        return this.isEnabled() ? this.view : null;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public boolean equals(Object other) {
        if (other instanceof VTreeNode) {
            if (this == other) {
                return true;
            }
            Object objThis = this.getUserObject();
            Object objThat = ((VTreeNode)other).getUserObject();
            if (objThis == null && objThat == null) {
                return this.toString().equals(other.toString());
            }
            if (objThis == objThat) {
                return true;
            }
            if (objThis == null || objThat == null) {
                return false;
            }
            return objThis.equals(objThat);
        }
        return false;
    }

    public int compareTo(Object other) {
        String s2;
        if (other == null) {
            throw new NullPointerException("'compareTo' cannot take a 'null' argument");
        }
        if (this.equals(other)) {
            return 0;
        }
        String s1 = this.toString();
        int c = s1.compareTo(s2 = other.toString());
        if (c != 0) {
            return c;
        }
        return 1;
    }

    public void setDisabledLeafIcon(Icon icon) {
        this.disabledLeafIcon = icon;
    }

    public Icon getDisabledLeafIcon() {
        return this.disabledLeafIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getLeafIcon(boolean enabled) {
        if (enabled) {
            return this.getLeafIcon();
        }
        Icon icon = this.getDisabledLeafIcon();
        return icon != null ? icon : this.getLeafIcon();
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getRendererIcon(JTree tree, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        if (isLeaf) {
            return this.getLeafIcon(this.isEnabled());
        }
        if (isExpanded) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }

    public String getRendererText(JTree tree, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        return this.toString();
    }

    public Color getRendererTextColor(JTree tree, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        return this.isEnabled() ? this.getEnabledColor() : this.getDisabledColor();
    }

    public void setEnabledColor(Color foreground) {
        this.enabledColor = foreground;
    }

    public Color getEnabledColor() {
        return this.enabledColor;
    }

    public void setDisabledColor(Color foreground) {
        this.disabledColor = foreground;
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    @Override
    public String toString() {
        Object obj = this.getUserObject();
        return obj != null ? obj.toString() : super.toString();
    }
}

