/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VTreeCellRenderer;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class VTree
extends VBox
implements TreeExpansionListener,
TreeSelectionListener,
TreeWillExpandListener {
    private JTree treeView = null;
    private Comparator<Object> orderComparator = null;
    private List<VTreeSelectionListener> changeListeners = new Vector<VTreeSelectionListener>();

    public VTree(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.treeView = new VJTree();
        ToolTipManager.sharedInstance().registerComponent(this.treeView);
        this.treeView.setToolTipText(title != null ? title : "tree");
        this.treeView.addTreeExpansionListener(this);
        this.treeView.addTreeSelectionListener(this);
        this.treeView.addTreeWillExpandListener(this);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        JScrollPane scrollPane = new JScrollPane(this.treeView);
        this.add((Component)scrollPane, this.getDefaultGBC());
    }

    public JTree getJTree() {
        return this.treeView;
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getJTree().setCellRenderer(renderer);
    }

    public Iterator getChildrenIterator(DefaultMutableTreeNode parent) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        final Enumeration<TreeNode> e = parent.children();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getDepthFirstIterator(DefaultMutableTreeNode parent) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        final Enumeration<TreeNode> e = parent.depthFirstEnumeration();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public DefaultMutableTreeNode findUserObjectNode(DefaultMutableTreeNode parent, Object userObj) {
        if (userObj != null) {
            Iterator i = this.getDepthFirstIterator(parent);
            while (i.hasNext()) {
                DefaultMutableTreeNode dmtn;
                Object obj;
                Object n = i.next();
                if (!(n instanceof DefaultMutableTreeNode) || userObj != (obj = (dmtn = (DefaultMutableTreeNode)n).getUserObject()) && !userObj.equals(obj)) continue;
                return dmtn;
            }
        }
        return null;
    }

    public void setOrderComparator(Comparator<Object> comparator) {
        this.orderComparator = comparator;
    }

    public Comparator<Object> getOrderComparator() {
        return this.orderComparator;
    }

    public VTreeModel getTreeModel() {
        return (VTreeModel)this.treeView.getModel();
    }

    public VTreeNode getRootNode() {
        return (VTreeNode)this.getTreeModel().getRoot();
    }

    protected VTreeNode createTreeNode(Object userObj, boolean allowsChildren) {
        return new VTreeNode(userObj, allowsChildren);
    }

    public VTreeNode insertNode(VTreeNode parent, VTreeNode child, int ndx) {
        if (child != null) {
            if (parent == null) {
                parent = this.getRootNode();
            }
            if (ndx < 0) {
                ndx = parent.getInsertionIndex(child, this.getOrderComparator());
            }
            if (!parent.containsChild(child)) {
                this.getTreeModel().insertNodeInto(child, parent, ndx);
                if (parent == this.getRootNode() && !this.isNodeExpanded(parent)) {
                    this.setNodeExpanded(parent, true);
                }
            }
        }
        return child;
    }

    public VTreeNode addNode(VTreeNode parent, VTreeNode child) {
        return this.insertNode(parent, child, -1);
    }

    public void addNodes(VTreeNode parent, VTreeNode[] childNode) {
        if (childNode != null) {
            if (parent == null) {
                parent = this.getRootNode();
            }
            int c = 0;
            int[] childNdx = new int[childNode.length];
            for (int i = 0; i < childNode.length; ++i) {
                if (parent.containsChild(childNode[i])) continue;
                int ndx = parent.getInsertionIndex(childNode[i], this.getOrderComparator());
                parent.insert(childNode[i], ndx);
                for (int z = 0; z < c; ++z) {
                    if (childNdx[z] < ndx) continue;
                    int n = z;
                    childNdx[n] = childNdx[n] + 1;
                }
                childNdx[c++] = ndx;
            }
            if (c < childNdx.length) {
                int[] newChildNdx = new int[c];
                System.arraycopy(childNdx, 0, newChildNdx, 0, c);
                Arrays.sort(newChildNdx);
                childNdx = newChildNdx;
            }
            try {
                this.getTreeModel().nodeStructureChanged(parent);
            }
            catch (ArrayIndexOutOfBoundsException aie) {
                Print.logException((String)"Node insertion error", (Throwable)aie);
            }
        }
    }

    public VTreeNode removeNode(TreeNode parent, VTreeNode child) {
        if (child != null) {
            int ndx;
            if (parent == null) {
                parent = child.getParent();
            }
            if ((ndx = this.getTreeModel().getIndexOfChild(parent, child)) >= 0) {
                child.removeFromParent();
                this.getTreeModel().nodesWereRemoved(parent, new int[]{ndx}, new Object[]{child});
            }
        }
        return child;
    }

    public VTreeNode insertUserObject(VTreeNode parent, Object userObj, boolean allowsChildren, int ndx) {
        return this.insertNode(parent, this.createTreeNode(userObj, allowsChildren), ndx);
    }

    public VTreeNode addUserObject(VTreeNode parent, Object userObj, boolean allowsChildren) {
        return this.insertUserObject(parent, userObj, allowsChildren, -1);
    }

    public void addUserObjects(VTreeNode parent, Object[] userObj, boolean allowsChildren) {
        if (userObj != null) {
            VTreeNode[] childNode = new VTreeNode[userObj.length];
            for (int i = 0; i < userObj.length; ++i) {
                childNode[i] = this.createTreeNode(userObj[i], allowsChildren);
            }
            this.addNodes(parent, childNode);
        }
    }

    public void setNodes(VTreeNode parent, VTreeNode[] childNode) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        if (!parent.getAllowsChildren()) {
            parent.setAllowsChildren(true);
        }
        parent.removeAllChildren();
        if (childNode != null) {
            for (int i = 0; i < childNode.length; ++i) {
                int ndx = parent.getInsertionIndex(childNode[i], this.getOrderComparator());
                parent.insert(childNode[i], ndx);
            }
        }
        this.getTreeModel().nodeStructureChanged(parent);
    }

    public void setUserObjects(VTreeNode parent, Object[] userObj, boolean allowsChildren) {
        if (userObj != null) {
            VTreeNode[] childNode = new VTreeNode[userObj.length];
            for (int i = 0; i < userObj.length; ++i) {
                childNode[i] = this.createTreeNode(userObj[i], allowsChildren);
            }
            this.setNodes(parent, childNode);
        }
    }

    public boolean isNodeExpanded(VTreeNode node) {
        if (node == null) {
            node = this.getRootNode();
        }
        TreePath path = new TreePath(node.getPath());
        return this.treeView.isExpanded(path);
    }

    public void setNodeExpanded(VTreeNode node, boolean expand) {
        if (node == null) {
            node = this.getRootNode();
        }
        TreePath path = new TreePath(node.getPath());
        if (expand) {
            this.treeView.expandPath(path);
        } else {
            this.treeView.collapsePath(path);
        }
    }

    public void setExpandAll(VTreeNode node, boolean expand) {
        if (node != null) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                VTreeNode child = (VTreeNode)node.getChildAt(i);
                this.setExpandAll(child, expand);
            }
            this.setNodeExpanded(node, expand);
        }
    }

    public void updateExpandedChildren(VTreeNode parent) {
        if (parent == null) {
            parent = this.getRootNode();
        }
        Iterator i = this.getDepthFirstIterator(parent);
        while (i.hasNext()) {
            VTreeNode node = (VTreeNode)i.next();
            if (!this.isNodeExpanded(node)) continue;
            node.populateChildren(this);
        }
    }

    public void setSelectedNode(DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.treeView.setSelectionPath(path);
        }
    }

    public void setSelectedUserObject(Object obj) {
        this.setSelectedNode(this.findUserObjectNode(null, obj));
    }

    public VTreeNode getSelectedNode() {
        TreePath path = this.treeView.getSelectionPath();
        return path != null ? (VTreeNode)path.getLastPathComponent() : null;
    }

    public Object getSelectedUserObject() {
        VTreeNode node = this.getSelectedNode();
        return node != null ? node.getUserObject() : null;
    }

    public VTreeNode getNodeAtPoint(Point p) {
        Object node;
        JTree jv = this.getJTree();
        Point jp = SwingUtilities.convertPoint(this, p, jv);
        TreePath selPath = jv.getPathForLocation(jp.x, jp.y);
        Object object = node = selPath != null ? selPath.getLastPathComponent() : null;
        if (node instanceof VTreeNode) {
            return (VTreeNode)node;
        }
        return null;
    }

    public VTreeNode getNodeAtPoint(MouseEvent me) {
        return this.getNodeAtPoint(new Point(me.getX(), me.getY()));
    }

    @Override
    public void selectItemAt(Point p) {
        Object node;
        JTree jv = this.getJTree();
        Point jp = SwingUtilities.convertPoint(this, p, jv);
        TreePath selPath = jv.getPathForLocation(jp.x, jp.y);
        Object object = node = selPath != null ? selPath.getLastPathComponent() : null;
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
            jv.setSelectionPath(new TreePath(dmtn.getPath()));
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
        TreePath path = e.getPath();
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        VTreeNode node = (VTreeNode)path.getLastPathComponent();
        node.populateChildren(this);
    }

    public void addSelectionListener(VTreeSelectionListener tsl) {
        if (tsl != null && !this.changeListeners.contains(tsl)) {
            this.changeListeners.add(tsl);
        }
    }

    public void removeSelectionListener(VTreeSelectionListener tsl) {
        this.changeListeners.remove(tsl);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        for (VTreeSelectionListener tsl : this.changeListeners) {
            tsl.selectionChanged(this);
        }
    }

    protected void doubleClickedNode(Object node) {
        this.fireAction();
    }

    public void nodeChanged(VTreeNode node) {
        this.getTreeModel().nodeChanged(node);
    }

    public VContextMenu setContextMenu(final JPopupMenu dftPopup) {
        return this.setContextMenu(new VPopupMenuProvider(){

            @Override
            public JPopupMenu getPopupMenu() {
                VTreeNode node = VTree.this.getSelectedNode();
                JPopupMenu nodePopup = node != null ? node.getPopupMenu() : null;
                return nodePopup != null ? nodePopup : dftPopup;
            }
        });
    }

    public VContextMenu setContextMenu(VPopupMenuProvider popupProv) {
        return VContextMenu.setContextMenu((JComponent)this.getJTree(), popupProv);
    }

    public VContextMenu getContextMenu() {
        return VContextMenu.getContextMenu(this.getJTree());
    }

    public class VTreeRootNode
    extends VTreeNode {
        public VTreeRootNode() {
            super("[ROOT]", true);
        }

        @Override
        public TreeNode getChildAt(int index) {
            try {
                return super.getChildAt(index);
            }
            catch (ArrayIndexOutOfBoundsException aioe) {
                Print.logError((String)("[ROOT] Invalid child node index: " + index), (Object[])new Object[0]);
                return null;
            }
        }
    }

    public class VTreeModel
    extends DefaultTreeModel {
        public VTreeModel(TreeNode root) {
            super(root);
        }
    }

    public class VJTree
    extends JTree {
        public VJTree(VTreeRootNode rootNode, boolean rootVisible) {
            this.setModel(new VTreeModel(rootNode));
            this.setRootVisible(rootVisible);
            this.setShowsRootHandles(true);
            this.setCellRenderer(new VTreeCellRenderer());
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        TreePath selPath = VJTree.this.getPathForLocation(me.getX(), me.getY());
                        Object node = selPath != null ? selPath.getLastPathComponent() : null;
                        VJTree.this.doubleClickedNode(node);
                    }
                }
            };
            this.addMouseListener(ml);
        }

        public VJTree() {
            this(vTree.new VTreeRootNode(), false);
        }

        protected void doubleClickedNode(Object node) {
            VTree.this.doubleClickedNode(node);
        }

        public VTree getVTree() {
            return VTree.this;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            block2: {
                try {
                    super.processMouseEvent(e);
                }
                catch (Throwable t) {
                    if (t instanceof NullPointerException && !RTConfig.isDebugMode()) break block2;
                    Print.logException((String)"Trapped Exception", (Throwable)t);
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            String toolTip;
            VTreeNode node = VTree.this.getNodeAtPoint(me);
            if (node != null && (toolTip = node.getToolTipText()) != null && !toolTip.equals("")) {
                return toolTip;
            }
            return super.getToolTipText(me);
        }
    }

    public static interface VTreeSelectionListener {
        public void selectionChanged(VTree var1);
    }
}

