/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.util.StringTools;

public class VToggleButton
extends JToggleButton
implements ActionListener {
    private Dimension preferredSize = null;
    private Color selectedForeground = Color.black;

    public VToggleButton() {
        this(null, null, null, null);
    }

    public VToggleButton(String text) {
        this(text, null, null, null);
    }

    public VToggleButton(ActionTarget at) {
        this(at.getTitle(), at.getListener(), at.getCommand());
    }

    public VToggleButton(String text, ActionListener al) {
        this(text, null, al, text);
    }

    public VToggleButton(String text, ActionListener al, String actionCmd) {
        this(text, null, al, actionCmd);
    }

    public VToggleButton(Icon icon, ActionListener al, String actionCmd) {
        this(null, icon, al, actionCmd);
    }

    public VToggleButton(String text, Icon icon, ActionListener al) {
        this(text, icon, al, text);
    }

    public VToggleButton(String text, Icon icon, ActionListener al, String actionCmd) {
        super(text);
        this.setActionCommand(actionCmd != null ? actionCmd : text);
        if (icon != null) {
            this.setIcon(icon);
        }
        if (al != null) {
            this.addActionListener(al);
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            super.setText("");
        } else if (text.indexOf("\n") >= 0) {
            String htmlText = "<html><center>" + StringTools.htmlFilterText((Object)text) + "</center></html>";
            super.setText(htmlText);
        } else {
            super.setText(text);
        }
    }

    public JToggleButton getToggleButton() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.doClick();
    }

    public void setReadOnly(boolean flag) {
        this.setEnabled(!flag);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.preferredSize == null) {
            return ps;
        }
        Dimension d = new Dimension(this.preferredSize);
        if (d.width < 0) {
            d.width = ps.width;
        }
        if (d.height < 0) {
            d.height = ps.height;
        }
        return d;
    }

    @Override
    public void setPreferredSize(Dimension ps) {
        this.preferredSize = ps;
    }

    public void setPreferredWidth(int w) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.width = w;
    }

    public void setPreferredHeight(int h) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.height = h;
    }

    @Override
    public void setModel(ButtonModel model) {
        super.setModel(new CustomToggleButtonModel(model));
    }

    @Override
    public void setSelected(boolean sel) {
        super.setSelected(sel);
    }

    public void setSelectedForegroundColor(Color color) {
        this.selectedForeground = color;
    }

    public void setFontSize(int ptSize) {
        Font font = this.getFont();
        if (font != null) {
            this.setFont(font.deriveFont((float)ptSize));
        }
    }

    public void setPlainFont() {
        Font font = this.getFont();
        if (font != null) {
            this.setFont(font.deriveFont(0));
        }
    }

    public void setPlainFont(int ptSize) {
        this.setFontSize(ptSize);
        this.setPlainFont();
    }

    public void setBoldFont() {
        Font font = this.getFont();
        if (font != null) {
            this.setFont(font.deriveFont(1));
        }
    }

    public void setBoldFont(int ptSize) {
        this.setFontSize(ptSize);
        this.setBoldFont();
    }

    public class CustomToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        public CustomToggleButtonModel(ButtonModel otherModel) {
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            if (this.isSelected()) {
                VToggleButton.this.setBoldFont();
                VToggleButton.this.setForeground(VToggleButton.this.selectedForeground);
            } else {
                VToggleButton.this.setPlainFont();
                VToggleButton.this.setForeground(Color.black);
            }
        }
    }
}

