/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VFiller;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VTextField
extends VBox {
    public static final Color READONLY_BACKGROUND_COLOR = new Color(220, 220, 220);
    public static final Color FORMATTED_FOREGROUND_COLOR = new Color(0, 50, 50);
    public static final String TYPE_STANDARD = "standard";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_FORMATTED = "formatted";
    public static final String CHAR_DIGIT = "0123456789";
    public static final String CHAR_INTEGER = "0123456789-";
    public static final String CHAR_LONG = "0123456789-";
    public static final String CHAR_DOUBLE = "0123456789-.";
    public static final String CHAR_LOWER = "abcdefghijklmnopqrstuvwxyz";
    public static final String CHAR_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CHAR_ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String CHAR_HEX = "0123456789ABCDEF";
    private JTextField textField = null;
    private VFiller textFiller = null;
    private int textFieldX = 0;
    private Color editableBackground = Color.white;
    private Color readOnlyBackground = Color.lightGray;
    private char arraySeparatorChar = (char)124;
    private FocusListener selectAllOnFocusListener = null;
    private static final String MASK_CHARS = "#ULA?*H";
    private VMaskFormatter maskFormatter = null;
    private char colWidthChar = '\u0000';
    private int colWidth = 0;

    public static VTextField TextField(int columns) {
        VTextField tf = new VTextField(columns);
        return tf;
    }

    public static VTextField TextField() {
        VTextField tf = new VTextField();
        return tf;
    }

    public static VTextField LongField(int columns) {
        VTextField tf = new VTextField(null, null, false, TYPE_FORMATTED);
        tf.getJTextField().setFont(VBox.FONT_MONOSPACED_PLAIN);
        tf.setFormatMask(StringTools.replicateString((String)"*", (int)columns), "0123456789-");
        tf.setColumns(columns);
        return tf;
    }

    public static VTextField DoubleField(int columns) {
        VTextField tf = new VTextField(null, null, false, TYPE_FORMATTED);
        tf.getJTextField().setFont(VBox.FONT_MONOSPACED_PLAIN);
        tf.setFormatMask(StringTools.replicateString((String)"*", (int)columns), CHAR_DOUBLE);
        tf.setColumns(columns);
        return tf;
    }

    public static VTextField HexField(int columns) {
        VTextField tf = new VTextField(null, null, false, TYPE_FORMATTED);
        tf.getJTextField().setFont(VBox.FONT_MONOSPACED_PLAIN);
        tf.setFormatMask(StringTools.replicateString((String)"H", (int)columns), CHAR_HEX);
        tf.setColumns(columns);
        return tf;
    }

    public VTextField() {
        this(false);
    }

    public VTextField(int columns) {
        this(false, columns);
    }

    public VTextField(boolean isPassword) {
        this(isPassword, -1);
    }

    public VTextField(boolean isPassword, int columns) {
        this(null, null, false, isPassword);
        this.setColumns(columns);
    }

    public VTextField(String title, String label, boolean bordered) {
        this(title, label, bordered, false);
    }

    public VTextField(String title, String label, boolean bordered, boolean isPassword) {
        this(title, label, bordered, isPassword ? TYPE_PASSWORD : TYPE_STANDARD);
    }

    public VTextField(String title, String label, boolean bordered, String fieldType) {
        super(title, label, bordered);
        this.textField = this.createTextField(fieldType);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VTextField.this.setDirty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VTextField.this.setDirty();
            }
        });
        super.setComponentListeners(this.textField);
        this.setGBCX(0.5, this.textFieldX++, 1, 0, 0);
        this.setGBCY(0.0, 0, 1, 0, 0);
        this.add((Component)this.textField, this.getDefaultGBC());
    }

    protected JTextField createTextField(String fieldType) {
        JTextField txtFld = null;
        txtFld = fieldType.equalsIgnoreCase(TYPE_PASSWORD) ? new VJPasswordField() : (fieldType.equalsIgnoreCase(TYPE_FORMATTED) ? new VJFormattedTextField() : new VJTextField());
        return txtFld;
    }

    public JTextField getJTextField() {
        return this.textField;
    }

    public VTextField setSelectAllOnFocus() {
        final JTextField jtf = this.getJTextField();
        if (this.selectAllOnFocusListener == null) {
            this.selectAllOnFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    jtf.selectAll();
                    String selText = jtf.getSelectedText();
                    Print.logInfo((String)("Selection: " + selText), (Object[])new Object[0]);
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            jtf.addFocusListener(this.selectAllOnFocusListener);
        }
        return this;
    }

    @Override
    protected int getLabelAnchor() {
        return 17;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
        if (this.textFiller != null) {
            this.textFiller.setBackground(color);
        }
    }

    public char getArraySeparatorChar() {
        return this.arraySeparatorChar;
    }

    public void setArraySeparatorChar(char c) {
        this.arraySeparatorChar = c;
    }

    public void setFormatMask(String mask, String validChars) {
        if (!(this.textField instanceof JFormattedTextField)) {
            Print.logError((String)"Warning: TextField may not support formatting (TYPE_FORMATTED required)", (Object[])new Object[0]);
        }
        try {
            this.maskFormatter = mask != null ? new VMaskFormatter(mask, validChars) : new VMaskFormatter(validChars);
            this.setFormatter(this.maskFormatter);
        }
        catch (ParseException pe) {
            Print.logError((String)("ParseException - " + pe), (Object[])new Object[0]);
        }
    }

    protected void setFormatter(JFormattedTextField.AbstractFormatter formatter) {
        if (this.textField instanceof JFormattedTextField) {
            JFormattedTextField tf = (JFormattedTextField)this.textField;
            tf.setFormatterFactory(new DefaultFormatterFactory(formatter));
        } else {
            Print.logError((String)"TextField is not a JFormattedTextField", (Object[])new Object[0]);
        }
    }

    protected String _forceMaskCompliance(String text) {
        if (this.maskFormatter == null) {
            return text;
        }
        String validChars = this.maskFormatter.getValidCharacters();
        String t = StringTools.stripChars((String)text, (String)validChars, (int)0);
        t = StringTools.stripChars((String)t, (char)this.maskFormatter.getPlaceholderCharacter());
        StringBuffer sb = new StringBuffer();
        String m = this.maskFormatter.getMask();
        if (m != null) {
            int tx = 0;
            for (int mx = 0; mx < m.length(); ++mx) {
                char txch;
                char mxch = m.charAt(mx);
                char ph = this.maskFormatter._getPlaceholderCharacter(mx);
                char c = txch = tx < t.length() ? t.charAt(tx) : ph;
                if (MASK_CHARS.indexOf(mxch) < 0) {
                    sb.append(mxch);
                    if (txch != mxch) continue;
                    ++tx;
                    continue;
                }
                if (txch == ph) {
                    sb.append(txch);
                    ++tx;
                    continue;
                }
                if (this._isValidCharForMask(mxch, txch)) {
                    sb.append(txch);
                    ++tx;
                    continue;
                }
                sb.append(ph);
                ++tx;
            }
        }
        return sb.toString();
    }

    protected boolean _isValidCharForMask(char maskChar, char v) {
        if (this.maskFormatter == null) {
            return true;
        }
        if (maskChar == '*') {
            return this.maskFormatter.getValidCharacters().indexOf(v) >= 0;
        }
        if (maskChar == '#') {
            return Character.isDigit(v);
        }
        if (maskChar == 'U') {
            return Character.isLetter(v);
        }
        if (maskChar == 'L') {
            return Character.isLetter(v);
        }
        if (maskChar == 'A') {
            return Character.isLetterOrDigit(v);
        }
        if (maskChar == '?') {
            return Character.isLetter(v);
        }
        if (maskChar == 'H') {
            if (v >= '0' && v <= '9') {
                return true;
            }
            if (v >= 'A' && v <= 'F') {
                return true;
            }
            return v >= 'a' && v <= 'f';
        }
        return false;
    }

    public void setColumns(int cols) {
        this.setColumns(cols, '\u0000');
    }

    public void setColumns(int cols, char charTemplate) {
        this.setColumns(cols, charTemplate, true);
    }

    public void setColumns(int cols, boolean addFiller) {
        this.setColumns(cols, '\u0000', addFiller);
    }

    public void setColumns(int cols, char charTemplate, boolean addFiller) {
        if (cols > 0) {
            this.setColumnWidthCharacter(charTemplate);
            this.textField.setColumns(cols);
            Dimension textFldSize = (Dimension)this.textField.getPreferredSize().clone();
            this.textField.setMaximumSize(textFldSize);
            this.textField.setMinimumSize(textFldSize);
            if (addFiller) {
                this.addTrailingFiller();
            }
        }
    }

    protected void addTrailingFiller() {
        if (this.textFiller == null) {
            GridBagLayout gbl = this.getContainerLayout();
            GridBagConstraints textGbc = (GridBagConstraints)gbl.getConstraints(this.textField).clone();
            textGbc.weightx = 0.0;
            textGbc.fill = 0;
            textGbc.anchor = 17;
            gbl.setConstraints(this.textField, textGbc);
            int xCol = 5;
            this.textFiller = new VFiller();
            this.textFiller.setBackground(this.getBackground());
            GridBagConstraints fillGbc = VTextField.NewGBC();
            fillGbc.anchor = 10;
            VTextField.SetGBCX(fillGbc, 0.5, xCol, 1);
            VTextField.SetGBCY(fillGbc, 0.5, 0, 1);
            this.add((Component)this.textFiller, fillGbc);
        }
    }

    @Override
    public void setMaximumSize(Dimension size) {
        super.setMaximumSize(size);
    }

    @Override
    public String getText() {
        if (this.textField instanceof JFormattedTextField) {
            String t = this.textField.getText();
            if (this.maskFormatter != null && t.equals(this.maskFormatter.getPlaceholder())) {
                t = "";
            }
            return t;
        }
        if (this.textField instanceof JPasswordField) {
            return this.textField.getText();
        }
        return this.textField.getText().trim();
    }

    @Override
    public void setText(String txt) {
        String t;
        String string = t = txt != null ? txt : "";
        if (this.textField instanceof JFormattedTextField) {
            String ft = this._forceMaskCompliance(t);
            this.textField.setText(ft);
            String newText = this.textField.getText();
            if (!ft.equals(newText) && !"".equals(newText)) {
                Print.logError((String)("Formatted Text mismatch! (" + t + ") " + ft + " => " + newText), (Object[])new Object[0]);
            }
        } else {
            this.textField.setText(t.trim());
        }
    }

    @Override
    public Object getValue() {
        if (this.textField instanceof JFormattedTextField) {
            JFormattedTextField tf = (JFormattedTextField)this.textField;
            Object v = tf.getValue();
            if (v == null) {
                v = "";
            }
            if (this.maskFormatter != null && v.equals(this.maskFormatter.getPlaceholder())) {
                v = "";
            }
            return v;
        }
        return this.getText();
    }

    public int getIntValue(int dft) {
        return StringTools.parseInt((String)this.getText(), (int)dft);
    }

    public long getLongValue(long dft) {
        return StringTools.parseLong((String)this.getText(), (long)dft);
    }

    public double getDoubleValue(double dft) {
        return StringTools.parseDouble((String)this.getText(), (double)dft);
    }

    @Override
    public void setValue(Object val) {
        String t = "";
        if (val == null) {
            t = "";
        } else if (val instanceof String) {
            t = (String)val;
        } else if (val instanceof String[]) {
            String[] v = (String[])val;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < v.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(this.getArraySeparatorChar());
                }
                sb.append(v[i]);
            }
            t = sb.toString();
        } else if (val instanceof List) {
            StringBuffer sb = new StringBuffer();
            Iterator i = ((List)val).iterator();
            while (i.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(this.getArraySeparatorChar());
                }
                sb.append(i.next().toString());
            }
            t = sb.toString();
        } else {
            t = val.toString();
        }
        if (this.textField instanceof JFormattedTextField) {
            JFormattedTextField tf = (JFormattedTextField)this.textField;
            String ft = this._forceMaskCompliance(t);
            tf.setValue(ft);
        } else {
            this.textField.setText(t.trim());
        }
    }

    public void setValue(int val) {
        this.setValue(String.valueOf(val));
    }

    public void setValue(long val) {
        this.setValue(String.valueOf(val));
    }

    public void setValue(double val) {
        this.setValue(String.valueOf(val));
    }

    @Override
    protected void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        this.textField.setEditable(!R);
        if (this.isEnabled()) {
            this.textField.setBackground(R ? READONLY_BACKGROUND_COLOR : Color.white);
        }
    }

    @Override
    protected void enabledStateChanged(boolean enabled) {
        if (this.textField != null) {
            boolean E = enabled && this._isEnabled();
            this.textField.setEnabled(E);
            if (!this.isReadOnly()) {
                this.textField.setBackground(E ? Color.white : Color.lightGray);
            }
        }
    }

    public void addButton(VButton vbtn) {
        VButton btn = vbtn;
        Insets margin = new Insets(1, 0, 1, 0);
        btn.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        Dimension maxDim = (Dimension)this.textField.getPreferredSize().clone();
        maxDim.width = btn.getPreferredSize().width;
        btn.setPreferredSize(maxDim);
        btn.setMaximumSize(maxDim);
        btn.setMinimumSize(maxDim);
        GridBagConstraints gbc = VTextField.NewGBC();
        gbc.fill = 3;
        gbc.anchor = 17;
        VTextField.SetGBCX(gbc, 0.0, this.textFieldX++, 1, 4, 0);
        VTextField.SetGBCY(gbc, 0.5, 0, 1, 0, 0);
        this.add((Component)btn, gbc);
        int textHeight = this.textField.getPreferredSize().height;
        this.setMinimumHeight(textHeight);
    }

    public void addButton(String text, ActionListener al) {
        this.addButton(new VButton(text, al));
    }

    protected void resetColumnWidth() {
        this.colWidth = 0;
    }

    public void setColumnWidthCharacter(char widthChar) {
        this.colWidthChar = widthChar;
        this.resetColumnWidth();
    }

    public int getColumnWidth() {
        if (this.colWidthChar != '\u0000') {
            if (this.colWidth == 0) {
                FontMetrics metrics = this.getFontMetrics(this.textField.getFont());
                this.colWidth = metrics.charWidth(this.colWidthChar) + 1;
            }
            return this.colWidth;
        }
        return -1;
    }

    @Override
    public void setPreferredSize(Dimension s) {
        super.setPreferredSize(s);
        if (s != null && s.height > 20) {
            Print.logStackTrace((String)"Here!");
        }
    }

    protected class VJPasswordField
    extends JPasswordField {
        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (VTextField.this != null) {
                VTextField.this.resetColumnWidth();
            }
        }

        @Override
        public int getColumnWidth() {
            int width = VTextField.this.getColumnWidth();
            return width > 0 ? width : super.getColumnWidth();
        }

        @Override
        public void setText(String text) {
            super.setText(text);
        }

        @Override
        protected Document createDefaultModel() {
            return super.createDefaultModel();
        }
    }

    protected class VJFormattedTextField
    extends JFormattedTextField {
        public VJFormattedTextField() {
            this.setFocusLostBehavior(0);
            this.setForeground(FORMATTED_FOREGROUND_COLOR);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (VTextField.this != null) {
                VTextField.this.resetColumnWidth();
            }
        }

        @Override
        public int getColumnWidth() {
            int width = VTextField.this.getColumnWidth();
            return width > 0 ? width : super.getColumnWidth();
        }

        @Override
        public void replaceSelection(String content) {
            try {
                super.replaceSelection(content);
            }
            catch (Throwable t) {
                Print.logError((String)("VJFormattedTextField - caught " + t), (Object[])new Object[0]);
            }
        }

        @Override
        public void setText(String text) {
            super.setText(text);
        }

        @Override
        protected Document createDefaultModel() {
            return super.createDefaultModel();
        }
    }

    protected class VJTextField
    extends JTextField {
        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (VTextField.this != null) {
                VTextField.this.resetColumnWidth();
            }
        }

        @Override
        public int getColumnWidth() {
            int width = VTextField.this.getColumnWidth();
            return width > 0 ? width : super.getColumnWidth();
        }

        @Override
        public void setText(String text) {
            super.setText(text);
        }

        @Override
        protected Document createDefaultModel() {
            return super.createDefaultModel();
        }
    }

    protected class VMaskFormatter
    extends MaskFormatter {
        public VMaskFormatter(String validChars) throws ParseException {
            this._init(validChars);
        }

        public VMaskFormatter(String mask, String validChars) throws ParseException {
            super(mask);
            this._init(validChars);
        }

        protected void _init(String validChars) {
            this.setCommitsOnValidEdit(true);
            this.setPlaceholder(this._createPlaceholderString());
            this.setValidCharacters(validChars);
        }

        @Override
        public void setValidCharacters(String chars) {
            if (chars != null) {
                char ph = this.getPlaceholderCharacter();
                if (chars.indexOf(ph) < 0) {
                    chars = chars + String.valueOf(ph);
                }
                super.setValidCharacters(chars);
            }
        }

        @Override
        public Object stringToValue(String s) throws ParseException {
            return super.stringToValue(s);
        }

        @Override
        public String valueToString(Object v) throws ParseException {
            return super.valueToString(v);
        }

        public String _createPlaceholderString() {
            StringBuffer sb = new StringBuffer();
            String m = this.getMask();
            if (m != null) {
                for (int mx = 0; mx < m.length(); ++mx) {
                    char mch = m.charAt(mx);
                    if (mch == '#' || mch == 'H') {
                        sb.append('0');
                        continue;
                    }
                    if (mch == 'U') {
                        sb.append('A');
                        continue;
                    }
                    if (mch == 'L' || mch == 'A' || mch == '?') {
                        sb.append('a');
                        continue;
                    }
                    if (mch == '*') {
                        sb.append(this.getPlaceholderCharacter());
                        continue;
                    }
                    sb.append(mch);
                }
            }
            return sb.toString();
        }

        protected char _getPlaceholderCharacter(int x) {
            String ph = this.getPlaceholder();
            if (ph != null && x < ph.length()) {
                return ph.charAt(x);
            }
            return this.getPlaceholderCharacter();
        }
    }
}

