/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.opengts.opt.ui.VBox;
import org.opengts.util.Print;

public class VTextArea
extends VBox {
    public static final Color READONLY_BACKGROUND_COLOR = new Color(245, 245, 245);
    private VTextInterface textArea = this.createTextArea();
    private JScrollPane scrollPane = null;
    private boolean encodedText = true;

    public VTextArea(int rows) {
        this(null, null, false);
        this.setRows(rows);
    }

    public VTextArea(int rows, int columns) {
        this(null, null, false);
        this.setRows(rows);
        this.setColumns(columns);
    }

    public VTextArea() {
        this(null, null, false);
    }

    public VTextArea(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VTextArea.this.setDirty();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VTextArea.this.setDirty();
            }
        });
        super.setComponentListeners((Component)((Object)this.textArea));
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        this.scrollPane = new JScrollPane((Component)((Object)this.textArea));
        this.add((Component)this.scrollPane, this.getDefaultGBC());
    }

    public VTextInterface getTextInterface() {
        return this.textArea;
    }

    public void setRows(int rows) {
        this.textArea.setRows(rows);
        this.setMinimumHeight(this.getPreferredSize().height);
    }

    public void setColumns(int cols) {
        this.textArea.setColumns(cols);
        this.setMinimumWidth(this.getPreferredSize().width);
    }

    public void setLineWrap(boolean wrap) {
        this.textArea.setLineWrap(wrap);
        this.textArea.setWrapStyleWord(true);
    }

    public void setVerticalScrolling(boolean enable) {
        if (enable) {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        }
    }

    public void setHorizontalScrolling(boolean enable) {
        if (enable) {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
        }
    }

    public int getLineCount() {
        return this.textArea.getLineCount();
    }

    public void setLineCount(int lineCount) {
        if (lineCount <= 0) {
            this.textArea.setText("");
        } else {
            int lc = this.getLineCount();
            if (lineCount < lc) {
                try {
                    int end = this.textArea.getLineEndOffset(lc - lineCount - 1);
                    this.textArea.replaceRange("", 0, end);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public void setEncodedText(boolean flag) {
        this.encodedText = flag;
    }

    public boolean isEncodedText() {
        return this.encodedText;
    }

    public static String encodeText(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int c = 0; c < text.length(); ++c) {
            char ch = text.charAt(c);
            if (ch == '\\') {
                sb.append("\\");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\t') {
                sb.append("\\t");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String decodeText(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer sb = new StringBuffer();
        for (int c = 0; c < len; ++c) {
            char ch = text.charAt(c);
            if (ch == '\\' && c + 1 < len) {
                char ch2;
                if ((ch2 = text.charAt(++c)) == '\\') {
                    sb.append("\\");
                    continue;
                }
                if (ch2 == 'n') {
                    sb.append("\n");
                    continue;
                }
                if (ch2 == 'r' || ch2 != 't') continue;
                sb.append("\t");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public void insertTextAtCursor(String text) {
        int pos = this.textArea.getCaretPosition();
        if (text != null) {
            if (this.isEncodedText()) {
                this.textArea.insert(VTextArea.decodeText(text), pos);
                this.fireAction();
            } else {
                this.textArea.insert(text, pos);
                this.fireAction();
            }
        }
    }

    public void appendText(String text) {
        this.appendText(text, false);
    }

    public void appendText(String text, boolean moveCaret) {
        if (text != null) {
            String tx = this.isEncodedText() ? VTextArea.decodeText(text) : text;
            this.textArea.append(tx);
            if (moveCaret) {
                try {
                    int caretPos = this.textArea.getText().length();
                    this.textArea.setCaretPosition(caretPos);
                }
                catch (Throwable th) {
                    // empty catch block
                }
            }
        }
    }

    public void print(String text) {
        this.appendText(text, true);
    }

    public void println(String text) {
        this.appendText(text, true);
        this.appendText("\n", true);
    }

    @Override
    public void setValue(Object text) {
        String t1 = text != null ? text.toString() : "";
        String t2 = this.isEncodedText() ? VTextArea.decodeText(t1) : t1;
        int caretPos = Math.min(t2.length(), this.textArea.getCaretPosition());
        this.textArea.setText(t2);
        try {
            this.textArea.setCaretPosition(caretPos);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    @Override
    public Object getValue() {
        String t = this.textArea.getText().trim();
        return this.isEncodedText() ? VTextArea.encodeText(t) : t;
    }

    public void setTextFont(Font f) {
        this.textArea.setFont(f);
    }

    public int getTextLength() {
        return this.textArea.getText().length();
    }

    public void setTextLength(int textLen) {
        if (textLen <= 0) {
            this.textArea.setText("");
        } else {
            int tl = this.getTextLength();
            if (textLen < tl) {
                try {
                    int delLen = this.textArea.getLineEndOffset(this.textArea.getLineOfOffset(tl - textLen));
                    this.textArea.replaceRange("", 0, delLen);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public void setCursorPosition(int caretPos) {
        try {
            int maxLen = this.textArea.getText().length();
            if (caretPos < 0 || caretPos > maxLen) {
                caretPos = maxLen;
            }
            this.textArea.setCaretPosition(caretPos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void copyToClipboard() {
        String text = this.textArea.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(text);
        clipboard.setContents(ss, ss);
    }

    @Override
    public void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        this.textArea.setEditable(!R);
        if (this.isEnabled()) {
            this.textArea.setBackground(R ? READONLY_BACKGROUND_COLOR : Color.white);
        }
    }

    @Override
    protected void enabledStateChanged(boolean enabled) {
        if (this.textArea != null) {
            boolean E = enabled && this._isEnabled();
            this.textArea.setEnabled(E);
            if (!this.isReadOnly()) {
                this.textArea.setBackground(E ? Color.white : Color.lightGray);
            }
        }
    }

    protected VTextInterface createTextArea() {
        return new VJTextArea();
    }

    protected static class VJTextPane
    extends JTextPane
    implements VTextInterface {
        @Override
        public void setRows(int rows) {
        }

        @Override
        public void setColumns(int cols) {
        }

        @Override
        public void setLineWrap(boolean wrap) {
        }

        @Override
        public void setWrapStyleWord(boolean wrap) {
        }

        @Override
        public void insert(String text, int pos) {
            StyledDocument doc = this.getStyledDocument();
            try {
                doc.insertString(pos, text, null);
            }
            catch (BadLocationException lde) {
                Print.logError((String)("Unable to insert text at this location: " + pos), (Object[])new Object[0]);
            }
        }

        @Override
        public void append(String text) {
            StyledDocument doc = this.getStyledDocument();
            try {
                doc.insertString(doc.getLength(), text, null);
            }
            catch (BadLocationException lde) {
                Print.logError((String)("Unable to append text to this location: " + doc.getLength()), (Object[])new Object[0]);
            }
        }

        @Override
        public void replaceRange(String str, int start, int end) {
        }

        @Override
        public int getLineCount() {
            return -1;
        }

        @Override
        public int getLineEndOffset(int line) throws BadLocationException {
            return -1;
        }

        @Override
        public int getLineOfOffset(int ofs) throws BadLocationException {
            return -1;
        }

        @Override
        public StyledDocument getStyledDocument() {
            return super.getStyledDocument();
        }
    }

    protected static class VJTextArea
    extends JTextArea
    implements VTextInterface {
        public VJTextArea() {
            this.setMargin(new Insets(2, 4, 2, 0));
        }

        @Override
        public void setRows(int rows) {
            super.setRows(rows);
        }

        @Override
        public int getLineCount() {
            return super.getLineCount();
        }

        @Override
        public int getLineEndOffset(int line) throws BadLocationException {
            return super.getLineEndOffset(line);
        }

        @Override
        public int getLineOfOffset(int ofs) throws BadLocationException {
            return super.getLineOfOffset(ofs);
        }
    }

    public static interface VTextInterface {
        public Document getDocument();

        public void setRows(int var1);

        public void setColumns(int var1);

        public void setLineWrap(boolean var1);

        public void setWrapStyleWord(boolean var1);

        public int getLineCount();

        public int getLineEndOffset(int var1) throws BadLocationException;

        public int getLineOfOffset(int var1) throws BadLocationException;

        public int getCaretPosition();

        public void setCaretPosition(int var1);

        public void insert(String var1, int var2);

        public void append(String var1);

        public void replaceRange(String var1, int var2, int var3);

        public void setText(String var1);

        public String getText();

        public void setFont(Font var1);

        public void setEditable(boolean var1);

        public void setEnabled(boolean var1);

        public void setBackground(Color var1);

        public void setForeground(Color var1);
    }
}

