/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VTable
extends VBox {
    public static final String ACTION_2CLICK = "vtable.doubleclick";
    private static final Color CELL_READONLY_COLOR = new Color(240, 240, 240);
    private static final String COLUMN_KEY_SORT_ASCENDING = "column.sort.ascending";
    private static final String COLUMN_KEY_SORT_DESCENDING = "column.sort.decending";
    private static final int MAX_COLUMNS = 16;
    private static VTableCellRenderer GenericRenderer = null;
    private static VTableCellRenderer NumericRenderer = null;
    private static VBooleanRenderer BooleanRenderer = null;
    private static VTableCellEditor GenericEditor = null;
    private static VTableCellEditor NumericEditor = null;
    private static VTableCellEditor BooleanEditor = null;
    private VTableView tableView = null;
    private JScrollPane scrollView = null;
    private Map<String, Integer> columnIndexMap = null;
    private boolean headerMouseDown = false;
    private boolean columnWasResized = false;
    private VColumnResizedListener columnResizedListener = null;
    private String rtPropertyKey = null;
    private static final String COLUMN_WIDTH_SEPARATOR = ":";
    private Vector<Object> selectionComponents = new Vector();
    private boolean _didEnable2Click = false;
    private static final boolean DEFAULT_ALLOW_REORDERING = false;

    public VTable(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.tableView = this.createJTableView(this.createTableModel());
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        this.scrollView = new JScrollPane(this.tableView);
        this.add((Component)this.scrollView, this.getDefaultGBC());
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    VTable.this._selectionChangeHandler(lse);
                }
            }
        });
        this.tableView.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                VTable.this.headerMouseDown = true;
                VTable.this.columnWasResized = false;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                VTable.this.headerMouseDown = false;
                if (VTable.this.columnWasResized) {
                    VTable.this.columnsWereResized();
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                int viewColNdx = VTable.this.tableView.getColumnModel().getColumnIndexAtX(me.getX());
                int modelColNdx = viewColNdx >= 0 ? VTable.this.tableView.convertColumnIndexToModel(viewColNdx) : -1;
                int mouseBtn = me.getButton();
                if (mouseBtn == 1) {
                    VTable.this._sortSelectedColumn(modelColNdx);
                } else if (mouseBtn == 3) {
                    // empty if block
                }
            }
        });
        this.setTableRenderers();
        this.setTableEditors();
    }

    protected void setTableRenderers() {
        if (GenericRenderer == null) {
            GenericRenderer = new VTableCellRenderer();
        }
        if (NumericRenderer == null) {
            NumericRenderer = new VNumericRenderer();
        }
        if (BooleanRenderer == null) {
            BooleanRenderer = new VBooleanRenderer();
        }
        this.tableView.setDefaultRenderer(Object.class, new VTableCellRenderer());
        this.tableView.setDefaultRenderer(Number.class, new VNumericRenderer());
        this.tableView.setDefaultRenderer(Float.class, null);
        this.tableView.setDefaultRenderer(Double.class, null);
        this.tableView.setDefaultRenderer(Boolean.class, new VBooleanRenderer());
        this.tableView.setDefaultRenderer(Date.class, null);
    }

    protected void setTableEditors() {
        if (GenericEditor == null) {
            GenericEditor = new VTableCellEditor(new JTextField());
        }
        if (NumericEditor == null) {
            NumericEditor = new VNumericEditor();
        }
        if (BooleanEditor == null) {
            BooleanEditor = new VBooleanEditor();
        }
        this.tableView.setDefaultEditor(Object.class, GenericEditor);
        this.tableView.setDefaultEditor(Number.class, NumericEditor);
        this.tableView.setDefaultEditor(Boolean.class, BooleanEditor);
    }

    public VTableView getTableView() {
        return this.tableView;
    }

    public JTable getJTable() {
        return this.getTableView();
    }

    public void setRTPropertyKey(String key) {
        this.rtPropertyKey = key != null && !key.equals("") ? key : null;
    }

    public String getRTPropertyKey() {
        return this.rtPropertyKey;
    }

    public boolean hasRTPropertyKey() {
        String rtk = this.getRTPropertyKey();
        return rtk != null && !rtk.equals("");
    }

    public VContextMenu setContextMenu(JPopupMenu popup) {
        return VContextMenu.setContextMenu((JComponent)this.tableView, popup);
    }

    public VContextMenu setContextMenu(VPopupMenuProvider popupProv) {
        return VContextMenu.setContextMenu((JComponent)this.tableView, popupProv);
    }

    public VContextMenu getContextMenu() {
        return VContextMenu.getContextMenu(this.tableView);
    }

    public JPopupMenu getPopupMenu() {
        return VContextMenu.getPopupMenu(this.tableView);
    }

    private Map<String, Integer> _columnWidthPropertyMap(String colWid) {
        if (colWid != null && !colWid.equals("")) {
            HashMap<String, Integer> widthMap = new HashMap<String, Integer>();
            String[] cw = StringTools.parseArray((String)colWid, (char)' ');
            for (int i = 0; i < cw.length; ++i) {
                int p = cw[i].indexOf(COLUMN_WIDTH_SEPARATOR);
                if (p < 0) continue;
                String key = cw[i].substring(0, p);
                int wid = StringTools.parseInt((String)cw[i].substring(p + 1), (int)0);
                if (key.equals("") || wid <= 0) continue;
                widthMap.put(key, new Integer(wid));
            }
            return widthMap;
        }
        return null;
    }

    private boolean _hasMapColumnWidth(Map<String, Integer> widthMap, String colName) {
        String cn;
        return widthMap != null && colName != null && widthMap.containsKey(cn = StringTools.replaceWhitespace((String)colName, (char)'_'));
    }

    private int _getMapColumnWidth(Map<String, Integer> widthMap, String colName, int dftWidth) {
        Integer intObj;
        String cn;
        if (widthMap != null && colName != null && widthMap.containsKey(cn = StringTools.replaceWhitespace((String)colName, (char)'_')) && (intObj = widthMap.get(cn)) instanceof Integer) {
            return intObj;
        }
        return dftWidth;
    }

    public void setColumnWidthProperties(String colWid) {
        Map<String, Integer> widthMap = this._columnWidthPropertyMap(colWid);
        for (int c = 0; c < this.getColumnCount(); ++c) {
            String colName = this.getTableModel().getColumnName(c);
            int colWidth = this._getMapColumnWidth(widthMap, colName, 0);
            if (colWidth > 0) {
                int viewColNdx = this.tableView.convertColumnIndexToView(c);
                TableColumn tc = this.tableView.getColumnModel().getColumn(viewColNdx);
                tc.setWidth(colWidth);
                continue;
            }
            Print.logWarn((String)("Column not found: " + colName), (Object[])new Object[0]);
        }
    }

    public String getColumnWidthProperties() {
        return this.getColumnWidthProperties(1);
    }

    public String getColumnWidthProperties(int mult) {
        if (mult <= 0) {
            mult = 1;
        }
        StringBuffer sb = new StringBuffer();
        String[] colWidthProp = new String[this.getColumnCount()];
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String colName = this.getTableModel().getColumnName(c);
            int viewColNdx = this.tableView.convertColumnIndexToView(c);
            TableColumn tc = this.tableView.getColumnModel().getColumn(viewColNdx);
            int colWidth = tc.getWidth() * mult;
            sb.append(colName.replace(' ', '_')).append(COLUMN_WIDTH_SEPARATOR).append(colWidth);
        }
        return sb.toString();
    }

    protected void columnsWereResized() {
        if (this.columnResizedListener != null) {
            this.columnResizedListener.tableColumnsResized(this);
        }
    }

    public void setColumnsResizedListener(VColumnResizedListener crl) {
        this.columnResizedListener = crl;
    }

    public TableColumn getTableColumn(int modelColNdx) {
        if (modelColNdx >= 0 && modelColNdx < this.getColumnCount()) {
            int viewColNdx = this.tableView.convertColumnIndexToView(modelColNdx);
            return this.tableView.getColumnModel().getColumn(viewColNdx);
        }
        return null;
    }

    public void setColumnCellRenderer(int modelColNdx, TableCellRenderer renderer) {
        TableColumn tblCol = this.getTableColumn(modelColNdx);
        tblCol.setCellRenderer(renderer);
    }

    public VTableModel getTableModel() {
        VTableModel model = (VTableModel)this.tableView.getModel();
        return model;
    }

    public void setTableModel(VTableModel model) {
        this.tableView.setModel(model);
    }

    public void setTableColumns(VColumnInfo[] colInfo) {
        this.setTableColumns(colInfo, null);
    }

    public void setTableColumns(VColumnInfo[] colInfo, String colWidthProps) {
        int i;
        String colName;
        HashMap<String, Integer> colNdxMap = new HashMap<String, Integer>();
        String[] colNames = new String[colInfo.length];
        for (int i2 = 0; i2 < colInfo.length; ++i2) {
            String id = colInfo[i2].getColumnID();
            if (id != null && !id.equals("")) {
                colNdxMap.put(id, new Integer(i2));
            }
            colNames[i2] = colInfo[i2].getColumnName();
        }
        this.setColumnIndexMap(colNdxMap);
        this.setColumnNames(colNames);
        Map<String, Integer> widthMap = this._columnWidthPropertyMap(colWidthProps);
        if (widthMap != null) {
            for (int i3 = 0; i3 < colInfo.length; ++i3) {
                colName = colInfo[i3].getColumnName();
                if (this._hasMapColumnWidth(widthMap, colName)) continue;
                Print.logInfo((String)("Column missing from column width override properties: " + colName), (Object[])new Object[0]);
                widthMap = null;
                break;
            }
        }
        for (i = 0; i < colInfo.length; ++i) {
            colName = colInfo[i].getColumnName();
            int dftWidth = colInfo[i].getColumnWidth();
            int colWidth = this._getMapColumnWidth(widthMap, colName, dftWidth);
            TableColumn tc = this.getTableColumn(i);
            if (colWidth <= 0) {
                colWidth = this.getPreferredColumnWidth(i);
            }
            tc.setPreferredWidth(colWidth * 10);
            tc.setWidth(colWidth);
        }
        for (i = 0; i < colInfo.length; ++i) {
            this.setColumnSortable(i, colInfo[i].getColumnSortAscending(), colInfo[i].getColumnSortDescending());
        }
    }

    public void setColumnNames(String[] colNames) {
        this.getTableModel().setColumnNames(colNames);
        this.tableView.createDefaultColumnsFromModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tblCol = this.getTableColumn(i);
            tblCol.setHeaderRenderer(new VHeaderRenderer(this.tableView.getTableHeader()));
        }
    }

    public void setColumnIcon(int modelColNdx, Icon icon) {
        TableCellRenderer renderer;
        TableColumn tblCol = this.getTableColumn(modelColNdx);
        if (tblCol != null && (renderer = tblCol.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)renderer).setIcon(icon);
        }
    }

    public void setColumnEditable(int col, boolean isEditable) {
        this.getTableModel().setColumnEditable(col, isEditable);
    }

    public void setColumnEditable(int[] col, boolean isEditable) {
        this.getTableModel().setColumnEditable(col, isEditable);
    }

    public boolean isCellEditable(int row, int col) {
        return this.getTableModel().isCellEditable(row, col);
    }

    public int getColumnCount() {
        return this.tableView.getColumnCount();
    }

    public int getPreferredColumnWidth(int c) {
        VTableView tbl = this.tableView;
        int minWidth = 0;
        int cnt = this.getRowCount();
        for (int r = 0; r < cnt; ++r) {
            VTableRow row = this.getRow(r);
            Object val = row.getColumnValue(c);
            TableCellRenderer rend = tbl.getCellRenderer(r, c);
            Component cmp = rend.getTableCellRendererComponent(tbl, val, false, false, r, c);
            Dimension d = cmp.getPreferredSize();
            if (minWidth >= d.width) continue;
            minWidth = d.width;
        }
        return minWidth;
    }

    public void setPreferredColumnWidth(int modelColNdx, int width) {
        TableColumn tc = this.getTableColumn(modelColNdx);
        if (width <= 0) {
            width = this.getPreferredColumnWidth(modelColNdx);
        }
        tc.setPreferredWidth(width);
    }

    public int getColumnIndex(String id) {
        Integer ndxObj;
        if (this.columnIndexMap != null && (ndxObj = this.columnIndexMap.get(id)) instanceof Number) {
            return ((Number)ndxObj).intValue();
        }
        return -1;
    }

    public void setColumnIndexMap(Map<String, Integer> indexMap) {
        this.columnIndexMap = indexMap;
    }

    public void setColumnHidden(int modelColNdx, boolean hidden) {
        TableColumnModel tcm = this.tableView.getColumnModel();
        if (tcm instanceof VTableColumnModel) {
            VTableColumnModel vtcm = (VTableColumnModel)tcm;
            vtcm.setColumnHidden(modelColNdx, hidden);
        }
    }

    public int getMinimumTableWidth() {
        VTableView tbl = this.tableView;
        if (tbl.isMinimumSizeSet()) {
            Dimension ms = tbl.getMinimumSize();
            return ms.width;
        }
        return -1;
    }

    public void setMinimumTableWidth(int width) {
        VTableView tbl = this.tableView;
        tbl.setMinimumWidth(width);
        int colCount = this.getColumnCount();
        double oldTotalColWidth = 0.0;
        for (int c = 0; c < colCount; ++c) {
            TableColumn tc = this.getTableColumn(c);
            oldTotalColWidth += (double)tc.getPreferredWidth();
        }
        double dblWidth = width;
        int newTotalColWidth = 0;
        for (int c = 0; c < colCount; ++c) {
            TableColumn tc = this.getTableColumn(c);
            int newWidth = (int)Math.round(dblWidth * (double)tc.getMaxWidth() / oldTotalColWidth);
            newTotalColWidth += newWidth;
            tc.setPreferredWidth(newWidth);
        }
    }

    private void _addSelectionEnabledComponent(Object comp) {
        if (!this.selectionComponents.contains(comp)) {
            this.selectionComponents.add(comp);
            this._setEnabled(comp, this.tableView.getSelectedRow() >= 0);
        }
    }

    public void addSelectionEnabledComponent(Component comp) {
        this._addSelectionEnabledComponent(comp);
    }

    public void addSelectionEnabledComponent(AbstractButton ab, String actionCmd) {
        this._addSelectionEnabledComponent(new EnablementWrapper(ab, actionCmd));
    }

    public void addSelectionEnabledComponent(JMenuBar mb, String actionCmd) {
        this._addSelectionEnabledComponent(new EnablementWrapper(mb, actionCmd));
    }

    public void removeSelectionEnabledComponent(Component comp) {
        this.selectionComponents.remove(comp);
    }

    private void _selectionChangeHandler(ListSelectionEvent lse) {
        boolean hasSel = this.tableView.getSelectedRow() >= 0;
        Iterator<Object> i = this.selectionComponents.iterator();
        while (i.hasNext()) {
            this._setEnabled(i.next(), hasSel);
        }
    }

    private void _setEnabled(Object obj, boolean enabled) {
        if (obj instanceof EnablementWrapper) {
            ((EnablementWrapper)obj).setEnabled(enabled);
        } else if (obj instanceof Component) {
            ((Component)obj).setEnabled(enabled);
        }
    }

    public void addListSelectionListener(ListSelectionListener lse) {
        ListSelectionModel selModel = this.tableView.getSelectionModel();
        selModel.addListSelectionListener(lse);
    }

    public void removeListSelectionListener(ListSelectionListener lse) {
        ListSelectionModel selModel = this.tableView.getSelectionModel();
        selModel.removeListSelectionListener(lse);
    }

    public void setAllowMultipleRowSelection(boolean allow) {
        this.tableView.setSelectionMode(allow ? 2 : 0);
    }

    private void _enableDoubleClickTrigger() {
        if (!this._didEnable2Click) {
            this.tableView.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int rowNdx;
                    if (e.getClickCount() == 2 && (rowNdx = VTable.this.tableView.rowAtPoint(e.getPoint())) >= 0) {
                        VTableRow row = VTable.this.getRow(rowNdx);
                        ActionEvent ae = new ActionEvent(row, 1001, VTable.ACTION_2CLICK);
                        VTable.this.fireActionEvent(ae);
                    }
                }
            });
            this._didEnable2Click = true;
        }
    }

    @Override
    public void addActionListener(ActionListener al) {
        this._enableDoubleClickTrigger();
        super.addActionListener(al);
    }

    public <T extends VTableRow> List<T> getTableData() {
        return this.getTableModel().getTableData();
    }

    public <T extends VTableRow> void setTableData(List<T> data) {
        VTableModel model = this.getTableModel();
        VTableRow[] row = this.getSelectedRows();
        model.setTableData(data);
        if (row != null) {
            this.setSelectedRows(row);
        }
        this.repaint();
    }

    public void setTableData(VTableRow[] data) {
        this.setTableData(ListTools.toList((Object[])data));
    }

    public void clearTableData() {
        this.setTableData((List)null);
    }

    public int getRowCount() {
        return this.tableView.getRowCount();
    }

    public int getRow(VTableRow row) {
        return this.getTableModel().getRow(row);
    }

    public VTableRow getRow(int row) {
        return this.getTableModel().getRow(row);
    }

    public void addRow(VTableRow rowVal) {
        this.getTableModel().addRow(rowVal);
    }

    public void insertRow(int row, VTableRow rowVal) {
        this.getTableModel().insertRow(row, rowVal);
    }

    public void removeRow(int row) {
        this.getTableModel().removeRow(row);
    }

    public Object[] getRowObjects() {
        int rowCnt = this.getRowCount();
        Object[] rowObj = new Object[rowCnt];
        for (int i = 0; i < rowCnt; ++i) {
            VTableRow row = this.getRow(i);
            rowObj[i] = row.getRowObject();
        }
        return rowObj;
    }

    public int getRowIndexAtPoint(Point p) {
        return this.tableView.rowAtPoint(p);
    }

    public int getRowIndexAtPoint(MouseEvent me) {
        return this.getRowIndexAtPoint(new Point(me.getX(), me.getY()));
    }

    public VTableRow getRowAtPoint(Point p) {
        return this.getRow(this.getRowIndexAtPoint(p));
    }

    public VTableRow getRowAtPoint(MouseEvent me) {
        return this.getRowAtPoint(new Point(me.getX(), me.getY()));
    }

    public boolean isRowSelected(int row) {
        return this.tableView.isRowSelected(row);
    }

    public boolean isRowSelected(VTableRow row) {
        return this.isRowSelected(this.getRow(row));
    }

    public int getSelectedRowIndex() {
        return this.tableView.getSelectedRow();
    }

    public int[] getSelectedRowIndexes() {
        return this.tableView.getSelectedRows();
    }

    public Object getSelectedRowObject() {
        VTableRow row = this.getSelectedRow();
        return row != null ? row.getRowObject() : null;
    }

    public Object[] getSelectedRowObjects() {
        VTableRow[] rows = this.getSelectedRows();
        if (rows != null && rows.length > 0) {
            Object[] rowObj = new Object[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                rowObj[i] = rows[i].getRowObject();
            }
            return rowObj;
        }
        return null;
    }

    public VTableRow getSelectedRow() {
        int row = this.getSelectedRowIndex();
        return row >= 0 ? this.getRow(row) : null;
    }

    public VTableRow[] getSelectedRows() {
        int[] row = this.getSelectedRowIndexes();
        if (row != null && row.length > 0) {
            VTableRow[] tblRow = new VTableRow[row.length];
            for (int i = 0; i < row.length; ++i) {
                tblRow[i] = this.getRow(row[i]);
            }
            return tblRow;
        }
        return null;
    }

    public void setSelectedRow(VTableRow row) {
        int rowNdx = this.getRow(row);
        this.setSelectedRow(rowNdx);
    }

    public void setSelectedRow(int row) {
        this.setSelectedRows(row, row);
    }

    public void setSelectedRows(int rowStr, int rowEnd) {
        if (rowStr < 0) {
            this.clearSelection();
        } else {
            if (rowEnd < rowStr) {
                rowEnd = rowStr;
            }
            this.tableView.setRowSelectionInterval(rowStr, rowEnd);
        }
    }

    public void setSelectedRows(VTableRow[] rows) {
        if (rows == null || rows.length == 0) {
            this.clearSelection();
        } else {
            int[] rowNdx = new int[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                rowNdx[i] = this.getRow(rows[i]);
            }
            this.setSelectedRows(rowNdx);
        }
    }

    public void setSelectedRows(int[] rows) {
        if (rows == null || rows.length == 0) {
            this.clearSelection();
        } else {
            this.tableView.setSelectedRows(rows);
        }
    }

    public int getSelectedColumnIndex() {
        return this.tableView.getSelectedColumn();
    }

    public void clearSelection() {
        this.tableView.clearSelection();
    }

    protected VTableView createJTableView(VTableModel model) {
        return new VTableView(model);
    }

    protected VTableModel createTableModel() {
        return new VTableModel();
    }

    public boolean isColumnSortableAscending(int colNdx) {
        VTableModel model = this.getTableModel();
        if (colNdx < 0) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!model.getColumnBoolean(colNdx, COLUMN_KEY_SORT_ASCENDING, false)) continue;
                return true;
            }
            return false;
        }
        return model.getColumnBoolean(colNdx, COLUMN_KEY_SORT_ASCENDING, false);
    }

    public void setColumnSortableAscending(int colNdx, boolean state) {
        VTableModel model = this.getTableModel();
        if (colNdx < 0) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                model.setColumnBoolean(i, COLUMN_KEY_SORT_ASCENDING, state);
            }
        } else if (colNdx < this.getColumnCount()) {
            model.setColumnBoolean(colNdx, COLUMN_KEY_SORT_ASCENDING, state);
        } else {
            Print.logWarn((String)("Invalid column index: " + colNdx), (Object[])new Object[0]);
        }
    }

    public boolean isColumnSortableDescending(int colNdx) {
        VTableModel model = this.getTableModel();
        if (colNdx < 0) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!model.getColumnBoolean(colNdx, COLUMN_KEY_SORT_DESCENDING, false)) continue;
                return true;
            }
            return false;
        }
        return model.getColumnBoolean(colNdx, COLUMN_KEY_SORT_DESCENDING, false);
    }

    public void setColumnSortableDescending(int colNdx, boolean state) {
        VTableModel model = this.getTableModel();
        if (colNdx < 0) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                model.setColumnBoolean(i, COLUMN_KEY_SORT_DESCENDING, state);
            }
        } else if (colNdx < this.getColumnCount()) {
            model.setColumnBoolean(colNdx, COLUMN_KEY_SORT_DESCENDING, state);
        } else {
            Print.logWarn((String)("Invalid column index: " + colNdx), (Object[])new Object[0]);
        }
    }

    public boolean isColumnSortable(int colNdx) {
        if (this.isColumnSortableAscending(colNdx)) {
            return true;
        }
        return this.isColumnSortableDescending(colNdx);
    }

    public void setColumnSortable(int colNdx, boolean state) {
        this.setColumnSortable(colNdx, state, state);
    }

    public void setColumnSortable(int colNdx, boolean ascending, boolean descending) {
        this.setColumnSortableAscending(colNdx, ascending);
        this.setColumnSortableDescending(colNdx, descending);
    }

    protected Icon getSortIcon(boolean ascending) {
        String imageName = ascending ? "com/sun/java/swing/plaf/motif/icons/ScrollDownArrow.gif" : "com/sun/java/swing/plaf/motif/icons/ScrollUpArrow.gif";
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        URL imageURL = scl.getResource(imageName);
        if (imageURL == null) {
            imageURL = ClassLoader.getSystemResource(imageName);
        }
        if (imageURL != null) {
            return new ImageIcon(imageURL);
        }
        Print.logError((String)("Image not found: " + imageName), (Object[])new Object[0]);
        return null;
    }

    private void _sortSelectedColumn(int modelCol) {
        VTableModel model = this.getTableModel();
        if (modelCol < 0) {
            for (int col = 0; col < this.getColumnCount(); ++col) {
                if (!this.isColumnSortable(col)) continue;
                this.setColumnIcon(col, null);
            }
            model.sortByColumn(null);
            this.repaint();
            return;
        }
        boolean supportsAscending = model.getColumnBoolean(modelCol, COLUMN_KEY_SORT_ASCENDING, false);
        boolean supportsDescending = model.getColumnBoolean(modelCol, COLUMN_KEY_SORT_DESCENDING, false);
        if (!supportsAscending && !supportsDescending) {
            return;
        }
        boolean newSortAscending = true;
        if (modelCol == model.getSortedColumn()) {
            boolean isAscending = model.isSortedAscending();
            if (isAscending) {
                if (!supportsDescending) {
                    return;
                }
                newSortAscending = false;
            } else {
                if (!supportsAscending) {
                    return;
                }
                newSortAscending = true;
            }
        } else {
            newSortAscending = supportsAscending;
        }
        for (int col = 0; col < this.getColumnCount(); ++col) {
            if (!this.isColumnSortable(col)) continue;
            this.setColumnIcon(col, null);
        }
        this.sortByColumn(modelCol, newSortAscending);
    }

    protected void sortByColumn(int modelCol, boolean ascending) {
        this.getTableModel().sortByColumn(this.getColumnSortComparator(modelCol, ascending));
        this.setColumnIcon(modelCol, this.getSortIcon(ascending));
        this.repaint();
    }

    protected VColumnComparator getColumnSortComparator(int colNdx, boolean ascending) {
        return new VColumnComparator(colNdx, ascending);
    }

    public static class VColumnInfo {
        private String colId = null;
        private String colName = null;
        private int colWidth = 0;
        private boolean sortAsc = false;
        private boolean sortDesc = false;

        public VColumnInfo(String id, String name, int width, boolean sort) {
            this(id, name, width, sort, sort);
        }

        public VColumnInfo(String id, String name, int width, boolean ascending, boolean descending) {
            this.colId = id;
            this.colName = name;
            this.colWidth = width;
            this.sortAsc = ascending;
            this.sortDesc = descending;
        }

        public VColumnInfo(String name, int width, boolean sort) {
            this(null, name, width, sort);
        }

        public String getColumnID() {
            return this.colId;
        }

        public String getColumnName() {
            return this.colName;
        }

        public int getColumnWidth() {
            return this.colWidth;
        }

        public boolean getColumnSort() {
            return this.sortAsc || this.sortDesc;
        }

        public boolean getColumnSortAscending() {
            return this.sortAsc;
        }

        public boolean getColumnSortDescending() {
            return this.sortDesc;
        }
    }

    public static class VTextAreaEditor2
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextArea editor = new JTextArea();
        private JScrollPane scrollPane = new JScrollPane(this.editor);

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSel, int row, int column) {
            this.editor.setText(value != null ? value.toString() : "");
            return this.scrollPane;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getText();
        }
    }

    public static class VTextAreaEditor
    extends VTableCellEditor {
        public VTextAreaEditor() {
            super(new JTextArea());
        }
    }

    public static class VTextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        private Color readOnlyBack = null;

        public VTextAreaRenderer(Color readOnly) {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public VTextAreaRenderer() {
            this(CELL_READONLY_COLOR);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean isSel, boolean hasFocus, int row, int col) {
            Color background;
            this.setFont(tbl.getFont());
            this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
            this.setText(value != null ? value.toString() : "");
            Color foreground = tbl.getForeground();
            Color color = background = tbl.isCellEditable(row, col) || this.readOnlyBack == null ? tbl.getBackground() : this.readOnlyBack;
            if (isSel) {
                foreground = tbl.getSelectionForeground();
                background = ColorTools.mix((Color)background, (Color)tbl.getSelectionBackground(), (float)0.7f);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            this.setOpaque(true);
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public static class VPasswordEditor
    extends VTableCellEditor {
        public VPasswordEditor() {
            super(new JPasswordField());
        }
    }

    public static class VPasswordRenderer
    extends VTableCellRenderer {
        public VPasswordRenderer(Color readOnly) {
            super(readOnly);
        }

        public VPasswordRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int row, int col) {
            String passwd = StringTools.replicateString((String)"*", (int)val.toString().length());
            super.getTableCellRendererComponent(tbl, passwd, isSel, focus, row, col);
            return this;
        }
    }

    public static class VTimeEditor
    extends VTableCellEditor {
        public VTimeEditor() {
            super(new JTextField());
        }
    }

    public static class VTimeRenderer
    extends VTableCellRenderer {
        public VTimeRenderer(Color readOnly) {
            super(readOnly);
        }

        public VTimeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int row, int col) {
            if (val == null) {
                val = "0";
            }
            long time = 0L;
            if (val instanceof Long) {
                time = (Long)val;
            } else if (val instanceof Integer) {
                time = ((Integer)val).longValue();
            } else if (val instanceof String && Character.isDigit(((String)val).charAt(0))) {
                time = StringTools.parseLong((String)val.toString(), (long)0L);
            }
            String dateVal = time > 0L ? new DateTime(time).toString() : "";
            super.getTableCellRendererComponent(tbl, dateVal, isSel, focus, row, col);
            return this;
        }
    }

    public static class VBooleanEditor
    extends VTableCellEditor {
        public VBooleanEditor() {
            super(new JCheckBox());
            ((JCheckBox)this.getComponent()).setHorizontalAlignment(0);
        }
    }

    public static class VBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private Color readOnlyBack = null;

        public VBooleanRenderer(Color readOnly) {
            this.setReadOnlyBackgroundColor(readOnly);
            this.setHorizontalAlignment(0);
        }

        public VBooleanRenderer() {
            this(CELL_READONLY_COLOR);
        }

        public void setReadOnlyBackgroundColor(Color color) {
            this.readOnlyBack = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean isSel, boolean hasFocus, int row, int col) {
            Color bg;
            Color color = bg = tbl.isCellEditable(row, col) || this.readOnlyBack == null ? tbl.getBackground() : this.readOnlyBack;
            if (isSel) {
                bg = ColorTools.mix((Color)bg, (Color)tbl.getSelectionBackground(), (float)0.7f);
            }
            this.setBackground(bg);
            this.setForeground(isSel ? tbl.getSelectionForeground() : tbl.getForeground());
            this.setOpaque(true);
            if (value == null) {
                this.setSelected(false);
            } else if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            } else {
                String b = value.toString();
                boolean bval = b.equalsIgnoreCase("true") || b.equalsIgnoreCase("yes");
                this.setSelected(bval);
            }
            return this;
        }
    }

    public static class VNumericEditor
    extends VTableCellEditor {
        public VNumericEditor() {
            super(new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    public static class VNumericRenderer
    extends VTableCellRenderer {
        public VNumericRenderer(Color readOnly) {
            super(readOnly);
            this.setHorizontalAlignment(4);
        }

        public VNumericRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class VTableCellEditor
    extends DefaultCellEditor {
        private Class<?> valueClass = null;

        public VTableCellEditor(JCheckBox checkBox) {
            super(checkBox);
            checkBox.setHorizontalAlignment(0);
            this._initFocusListener(checkBox);
        }

        public VTableCellEditor(JComboBox comboBox) {
            super(comboBox);
            this._initFocusListener(comboBox);
        }

        public VTableCellEditor(JTextField textField, int alignment) {
            super(textField);
            textField.setHorizontalAlignment(alignment);
            this._initFocusListener(textField);
        }

        public VTableCellEditor(JTextField textField) {
            this(textField, 2);
        }

        public VTableCellEditor(final JTextArea textArea) {
            super(new JTextField());
            this.editorComponent = new JScrollPane(textArea);
            this.clickCountToStart = 2;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                @Override
                public void setValue(Object value) {
                    textArea.setText(value != null ? value.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return textArea.getText();
                }
            };
            this._initFocusListener(textArea);
        }

        protected void _initFocusListener(final Component c) {
            c.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    ActionEvent ae = new ActionEvent(c, 1001, "");
                    VTableCellEditor.this.delegate.actionPerformed(ae);
                }
            });
        }

        @Override
        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSel, int row, int col) {
            this.valueClass = value != null ? value.getClass() : String.class;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSel, row, col);
        }

        @Override
        public Object getCellEditorValue() {
            Object value = super.getCellEditorValue();
            if (value == null) {
                return value;
            }
            if (this.valueClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (this.valueClass == String.class) {
                return value.toString();
            }
            if (value.getClass() == String.class) {
                try {
                    Class[] argTypes = new Class[]{String.class};
                    Constructor<?> constructor = value.getClass().getConstructor(argTypes);
                    return constructor.newInstance((String)value);
                }
                catch (Throwable t) {
                    return value;
                }
            }
            return value;
        }
    }

    public static class VTableCellRenderer
    extends DefaultTableCellRenderer {
        private DateFormat dateFormatter = null;
        private NumberFormat numFormatter = null;
        private Color readOnlyBack = null;

        public VTableCellRenderer(Color readOnly) {
            this.setReadOnlyBackgroundColor(readOnly);
        }

        public VTableCellRenderer() {
            this(CELL_READONLY_COLOR);
        }

        public void setReadOnlyBackgroundColor(Color color) {
            this.readOnlyBack = color;
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                this.setText("");
            } else if (value instanceof Double || value instanceof Float) {
                if (this.numFormatter == null) {
                    this.numFormatter = NumberFormat.getInstance();
                }
                this.setText(this.numFormatter.format(value));
            } else if (value instanceof Date) {
                if (this.dateFormatter == null) {
                    this.dateFormatter = DateFormat.getInstance();
                }
                this.setText(this.dateFormatter.format(value));
            } else {
                super.setValue(value);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int row, int col) {
            Color bg;
            super.getTableCellRendererComponent(tbl, val, isSel, focus, row, col);
            Color color = bg = tbl.isCellEditable(row, col) || this.readOnlyBack == null ? tbl.getBackground() : this.readOnlyBack;
            if (isSel) {
                bg = ColorTools.mix((Color)bg, (Color)tbl.getSelectionBackground(), (float)0.7f);
            }
            this.setBackground(bg);
            this.setOpaque(true);
            return this;
        }
    }

    public static class VTableRowAdapter
    implements VTableRow {
        private Vector<Object> data = new Vector();

        @Override
        public Object getRowObject() {
            return this.data;
        }

        @Override
        public Object getColumnValue(int col) {
            return col >= 0 && col < this.data.size() ? this.data.get(col) : "";
        }

        @Override
        public void setColumnValue(int col, Object value) {
            while (this.data.size() <= col) {
                this.data.add("");
            }
            this.data.set(col, value);
        }

        @Override
        public boolean isColumnEditable(int col) {
            return true;
        }

        public boolean equals(Object other) {
            if (!(other instanceof VTableRow)) {
                return false;
            }
            return this.getRowObject().equals(((VTableRow)other).getRowObject());
        }
    }

    public static interface VTableRow {
        public Object getRowObject();

        public Object getColumnValue(int var1);

        public void setColumnValue(int var1, Object var2);

        public boolean isColumnEditable(int var1);
    }

    public static class VColumnComparator
    implements Comparator<Object> {
        private int column = 0;
        private boolean ascending = true;

        public VColumnComparator(int colNdx) {
            this(colNdx, true);
        }

        public VColumnComparator(int colNdx, boolean ascending) {
            this.column = colNdx;
            this.ascending = ascending;
        }

        public int getSortColumn() {
            return this.column;
        }

        public boolean getSortAscending() {
            return this.ascending;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object c2;
            VTableRow r1 = o1 instanceof VTableRow ? (VTableRow)o1 : null;
            VTableRow r2 = o2 instanceof VTableRow ? (VTableRow)o2 : null;
            Object c1 = r1 != null ? r1.getColumnValue(this.column) : null;
            Object object = c2 = r2 != null ? r2.getColumnValue(this.column) : null;
            if (c1 instanceof Number && c2 instanceof Number) {
                Number n1 = (Number)c1;
                Number n2 = (Number)c2;
                if (n1 instanceof Long || n1 instanceof Integer || n1 instanceof Byte) {
                    long d = n1.longValue() - n2.longValue();
                    int s = d > 0L ? 1 : (d < 0L ? -1 : 0);
                    return this.ascending ? s : -s;
                }
                if (n1 instanceof Double || n1 instanceof Float) {
                    double d = n1.doubleValue() - n2.doubleValue();
                    int s = d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
                    return this.ascending ? s : -s;
                }
                int s = n1.toString().compareTo(n2.toString());
                return this.ascending ? s : -s;
            }
            if (c1 instanceof Number && !(c2 instanceof Number)) {
                return this.ascending ? -1 : 1;
            }
            if (!(c1 instanceof Number) && c2 instanceof Number) {
                return this.ascending ? 1 : -1;
            }
            String s1 = c1 != null ? c1.toString() : "";
            String s2 = c2 != null ? c2.toString() : "";
            int s = s1.compareTo(s2);
            return this.ascending ? s : -s;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof VColumnComparator) {
                return this.column == ((VColumnComparator)obj).column && this.ascending == ((VColumnComparator)obj).ascending;
            }
            return false;
        }
    }

    protected static class VTableModel
    extends AbstractTableModel {
        private Object[] columnNames = null;
        private Map<String, Object> columnAttr = null;
        private boolean[] editableColumns = null;
        private List<?> tableData = null;
        private VColumnComparator sortComparator = null;

        public VTableModel() {
        }

        public VTableModel(String[] colNames) {
            this();
            this.setColumnNames(colNames);
        }

        public Object[] getColumnNames() {
            if (this.columnNames == null) {
                this.setColumnNames(new String[]{"Default"});
            }
            return this.columnNames;
        }

        public void setColumnNames(String[] colNames) {
            this.columnNames = colNames;
        }

        @Override
        public String getColumnName(int col) {
            Object[] colObj = this.getColumnNames();
            if (col >= 0 && col < colObj.length) {
                return colObj[col].toString();
            }
            return "";
        }

        public void setColumnAttribute(int col, String key, Object val) {
            if (key != null && col >= 0 && col < this.getColumnCount()) {
                String k = col + VTable.COLUMN_WIDTH_SEPARATOR + key;
                if (val != null) {
                    if (this.columnAttr == null) {
                        this.columnAttr = new HashMap<String, Object>();
                    }
                    this.columnAttr.put(k, val);
                } else if (this.columnAttr != null) {
                    this.columnAttr.remove(k);
                }
            }
        }

        public Object getColumnAttribute(int col, String key, Object dft) {
            if (this.columnAttr != null && key != null && col >= 0 && col < this.getColumnCount()) {
                String k = col + VTable.COLUMN_WIDTH_SEPARATOR + key;
                return this.columnAttr.containsKey(k) ? this.columnAttr.get(k) : dft;
            }
            return dft;
        }

        public boolean getColumnBoolean(int col, String key, boolean dft) {
            Object val = this.getColumnAttribute(col, key, null);
            return StringTools.parseBoolean((Object)val, (boolean)dft);
        }

        public void setColumnBoolean(int col, String key, boolean val) {
            this.setColumnAttribute(col, key, String.valueOf(val));
        }

        public long getColumnLong(int col, String key, long dft) {
            return StringTools.parseLong((Object)this.getColumnAttribute(col, key, null), (long)dft);
        }

        public void setColumnLong(int col, String key, long val) {
            this.setColumnAttribute(col, key, new Long(val));
        }

        public boolean isValidRow(int row) {
            return row >= 0 && row < this.getRowCount();
        }

        @Override
        public int getRowCount() {
            return this.getTableData().size();
        }

        @Override
        public int getColumnCount() {
            return this.getColumnNames().length;
        }

        public <T extends VTableRow> List<T> getTableData() {
            if (this.tableData == null) {
                this.tableData = new Vector();
            }
            return this.tableData;
        }

        public <T extends VTableRow> void setTableData(List<T> data) {
            this.tableData = data;
            this.sortByColumn();
            this.fireTableDataChanged();
        }

        public int getSortedColumn() {
            if (this.sortComparator != null) {
                return this.sortComparator.getSortColumn();
            }
            return -1;
        }

        public boolean isSorted() {
            return this.getSortedColumn() >= 0;
        }

        public boolean isSortedAscending() {
            if (this.sortComparator != null) {
                return this.sortComparator.getSortAscending();
            }
            return true;
        }

        public void sortByColumn(VColumnComparator vcc) {
            if (vcc != null) {
                Collections.sort(this.tableData, vcc);
                this.sortComparator = vcc;
            } else {
                this.sortComparator = null;
            }
        }

        public void sortByColumn() {
            if (this.sortComparator != null && this.tableData != null) {
                Collections.sort(this.tableData, this.sortComparator);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            VTableRow rowVal = this.getRow(row);
            return rowVal != null ? rowVal.getColumnValue(col) : "";
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            VTableRow rowVal = this.getRow(row);
            if (rowVal != null) {
                rowVal.setColumnValue(col, val != null ? val : "");
                this.fireTableCellUpdated(row, col);
            }
        }

        public VTableRow getRow(int row) {
            VTableRow obj;
            VTableRow vTableRow = obj = this.isValidRow(row) ? (VTableRow)this.getTableData().get(row) : null;
            if (obj == null) {
                Print.logError((String)("Invalid row index: " + row), (Object[])new Object[0]);
                return null;
            }
            if (obj instanceof VTableRow) {
                return obj;
            }
            Print.logError((String)("Not a VTableRow: " + StringTools.className((Object)obj)), (Object[])new Object[0]);
            return null;
        }

        public int getRow(VTableRow row) {
            if (row != null) {
                return this.getTableData().indexOf(row);
            }
            return -1;
        }

        public void addRow(VTableRow rowVal) {
            if (rowVal != null) {
                int row = this.getRowCount();
                this.getTableData().add(rowVal);
                this.fireTableRowsInserted(row, row);
            }
        }

        public void insertRow(int row, VTableRow rowVal) {
            if (row >= 0 && rowVal != null) {
                this.getTableData().add(row, rowVal);
                this.fireTableRowsInserted(row, row);
            }
        }

        public void removeRow(int row) {
            if (row >= 0) {
                this.getTableData().remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            boolean[] ec = this._getEditableColumns();
            return ec[col] && this.getRow(row).isColumnEditable(col);
        }

        public void setColumnEditable(int col, boolean isEditable) {
            boolean[] ec = this._getEditableColumns();
            if (col >= 0 && col < ec.length) {
                ec[col] = isEditable;
            } else {
                for (int i = 0; i < ec.length; ++i) {
                    ec[i] = isEditable;
                }
            }
        }

        public void setColumnEditable(int[] col, boolean isEditable) {
            for (int i = 0; i < col.length; ++i) {
                this.setColumnEditable(col[i], isEditable);
            }
        }

        protected boolean[] _getEditableColumns() {
            if (this.editableColumns == null) {
                this.editableColumns = new boolean[16];
                for (int i = 0; i < this.editableColumns.length; ++i) {
                    this.editableColumns[i] = true;
                }
            }
            return this.editableColumns;
        }
    }

    protected class VTableColumn
    extends TableColumn {
        private boolean isHidden;

        public VTableColumn(int modelIndex) {
            super(modelIndex);
            this.isHidden = false;
        }

        public void setHidden(boolean hidden) {
            this.isHidden = hidden;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        @Override
        public void setWidth(int w) {
            if (w != this.getWidth()) {
                super.setWidth(w);
                if (VTable.this.headerMouseDown) {
                    VTable.this.columnWasResized = true;
                }
            }
        }

        @Override
        public int getWidth() {
            return this.isHidden() ? 0 : super.getWidth();
        }

        @Override
        public int getMaxWidth() {
            return this.isHidden() ? 0 : super.getMaxWidth();
        }

        @Override
        public int getMinWidth() {
            return this.isHidden() ? 0 : super.getMinWidth();
        }

        @Override
        public int getPreferredWidth() {
            return this.isHidden() ? 0 : super.getPreferredWidth();
        }

        @Override
        public boolean getResizable() {
            return this.isHidden() ? false : super.getResizable();
        }
    }

    protected class VTableColumnModel
    extends DefaultTableColumnModel {
        @Override
        public void addColumn(TableColumn aColumn) {
            super.addColumn(aColumn);
        }

        @Override
        public void removeColumn(TableColumn aColumn) {
            super.removeColumn(aColumn);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            super.moveColumn(columnIndex, newIndex);
        }

        public void setColumnHidden(int columnIndex, boolean hidden) {
            TableColumn tc = this.getColumn(columnIndex);
            if (tc instanceof VTableColumn) {
                ((VTableColumn)tc).setHidden(hidden);
            }
        }

        public boolean isColumnHidden(int columnIndex) {
            TableColumn tc = this.getColumn(columnIndex);
            if (tc instanceof VTableColumn) {
                return ((VTableColumn)tc).isHidden();
            }
            return false;
        }

        @Override
        public int getColumnCount() {
            return super.getColumnCount();
        }

        @Override
        public TableColumn getColumn(int columnIndex) {
            return super.getColumn(columnIndex);
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            return super.getColumns();
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tcml) {
            super.addColumnModelListener(tcml);
        }
    }

    protected class VJTableHeader
    extends JTableHeader {
        public VJTableHeader() {
        }

        public VJTableHeader(TableColumnModel cm) {
            super(cm);
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            int modelColNdx;
            int viewColNdx = VTable.this.tableView.getColumnModel().getColumnIndexAtX(me.getX());
            int n = modelColNdx = viewColNdx >= 0 ? VTable.this.tableView.convertColumnIndexToModel(viewColNdx) : -1;
            if (modelColNdx >= 0) {
                return VTable.this.tableView.getColumnName(modelColNdx);
            }
            return null;
        }
    }

    protected class VTableView
    extends JTable {
        private Dimension minimumSize;

        public VTableView() {
            this.minimumSize = null;
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
        }

        public VTableView(TableModel tm) {
            super(tm);
            this.minimumSize = null;
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
        }

        public VTableView(TableModel tm, TableColumnModel cm) {
            super(tm, cm);
            this.minimumSize = null;
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            TableCellRenderer tcr = super.getCellRenderer(row, col);
            if (!(tcr instanceof VTableCellRenderer)) {
                Print.logError((String)("Not a VTableCellRenderer: " + StringTools.className((Object)tcr)), (Object[])new Object[0]);
            }
            return tcr;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor tce = super.getCellEditor(row, col);
            if (!(tce instanceof VTableCellEditor)) {
                Print.logError((String)("Not a VTableCellEditor: " + StringTools.className((Object)tce)), (Object[])new Object[0]);
            }
            return tce;
        }

        @Override
        public void setModel(TableModel model) {
            super.setModel(model);
        }

        public VTable getVTable() {
            return VTable.this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return d;
        }

        @Override
        public boolean isMinimumSizeSet() {
            return this.minimumSize != null || super.isMinimumSizeSet();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension minSize = super.getMinimumSize();
            if (this.minimumSize != null) {
                Dimension ms = new Dimension(this.minimumSize);
                if (ms.width < 0) {
                    ms.width = minSize.width;
                }
                if (ms.height < 0) {
                    ms.height = minSize.height;
                }
                minSize = ms;
            }
            return minSize;
        }

        @Override
        public void setMinimumSize(Dimension ms) {
            this.minimumSize = ms;
        }

        public void setMinimumWidth(int w) {
            if (this.minimumSize == null) {
                this.minimumSize = new Dimension(-1, -1);
            }
            this.minimumSize.width = w;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.isMinimumSizeSet()) {
                Dimension vs = VTable.this.scrollView.getViewport().getSize();
                Dimension ms = this.getMinimumSize();
                if (vs.width <= ms.width) {
                    return false;
                }
            }
            return super.getScrollableTracksViewportWidth();
        }

        @Override
        public TableColumnModel getColumnModel() {
            return super.getColumnModel();
        }

        @Override
        protected TableColumnModel createDefaultColumnModel() {
            return new VTableColumnModel();
        }

        @Override
        public void createDefaultColumnsFromModel() {
            TableModel tm = this.getModel();
            if (tm != null) {
                TableColumnModel cm = this.getColumnModel();
                while (cm.getColumnCount() > 0) {
                    cm.removeColumn(cm.getColumn(0));
                }
                for (int i = 0; i < tm.getColumnCount(); ++i) {
                    VTableColumn newColumn = new VTableColumn(i);
                    this.addColumn(newColumn);
                }
            }
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new VJTableHeader(this.getColumnModel());
        }

        @Override
        public JTableHeader getTableHeader() {
            return super.getTableHeader();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return super.getSelectionModel();
        }

        @Override
        public int getSelectedRow() {
            return super.getSelectedRow();
        }

        @Override
        public int[] getSelectedRows() {
            return super.getSelectedRows();
        }

        public void setSelectedRows(int[] rows) {
            if (rows == null || rows.length == 0) {
                this.clearSelection();
            } else {
                this.clearSelection();
                ListSelectionModel lsm = this.getSelectionModel();
                for (int i = 0; i < rows.length; ++i) {
                    lsm.addSelectionInterval(rows[i], rows[i]);
                }
            }
        }

        @Override
        public void setRowSelectionInterval(int rowStr, int rowEnd) {
            super.setRowSelectionInterval(rowStr, rowEnd);
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            super.setSelectionMode(selectionMode);
        }

        @Override
        public int getSelectedColumn() {
            return super.getSelectedColumn();
        }

        @Override
        public void clearSelection() {
            super.clearSelection();
        }

        @Override
        public void setToolTipText(String text) {
            super.setToolTipText(text);
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            VTableRow row = VTable.this.getRowAtPoint(me);
            if (row != null) {
                Object obj;
                int modelColNdx;
                int viewColNdx = this.getColumnModel().getColumnIndexAtX(me.getX());
                int n = modelColNdx = viewColNdx >= 0 ? this.convertColumnIndexToModel(viewColNdx) : -1;
                if (modelColNdx >= 0 && (obj = row.getColumnValue(modelColNdx)) != null) {
                    return obj.toString();
                }
            }
            return null;
        }
    }

    private static class EnablementWrapper {
        private Object item = null;
        private String cmd = null;

        public EnablementWrapper(AbstractButton ab, String ac) {
            this.item = ab;
            this.cmd = ac;
        }

        public EnablementWrapper(JMenuBar ab, String ac) {
            this.item = ab;
            this.cmd = ac;
        }

        public void setEnabled(boolean enable) {
            if (this.item instanceof JMenuBar) {
                MenuElement[] me = ((JMenuBar)this.item).getSubElements();
                for (int i = 0; i < me.length; ++i) {
                    if (!(me[i] instanceof AbstractButton)) continue;
                    VButton.setActionEnabled((AbstractButton)((Object)me[i]), this.cmd, enable);
                }
            } else if (this.item instanceof AbstractButton) {
                VButton.setActionEnabled((AbstractButton)this.item, this.cmd, enable);
            } else {
                Print.logStackTrace((String)("Unrecognized type: " + StringTools.className((Object)this.item)));
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof EnablementWrapper) {
                EnablementWrapper ew = (EnablementWrapper)obj;
                return this.item.equals(ew.item) && this.cmd.equals(ew.cmd);
            }
            return false;
        }
    }

    public static class VHeaderRenderer
    extends DefaultTableCellRenderer {
        private JTableHeader tableHeader = null;

        public VHeaderRenderer(JTableHeader tableHeader) {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(10);
            this.setForeground(tableHeader.getForeground());
            this.setBackground(tableHeader.getBackground());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.tableHeader = tableHeader;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean sel, boolean focus, int rowNdx, int colNdx) {
            this.setText(value != null ? value.toString() : "");
            this.setFont(this.tableHeader.getFont());
            return this;
        }
    }

    public static interface VColumnResizedListener {
        public void tableColumnsResized(VTable var1);
    }
}

