/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.util.DateTime;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VSpinner
extends VBox {
    public static final Color READONLY_BACKGROUND_COLOR = new Color(220, 220, 220);
    private VJSpinner spinner = this.createSpinner();
    private JButton nextButton = null;
    private Runnable nextRunnable = null;
    private JButton prevButton = null;
    private Runnable prevRunnable = null;
    private Object lastValue = null;
    private JPanel spinnerFiller = null;
    private HashMap<String, Object> propertyMap = null;

    public VSpinner(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.spinner.addChangeListener(new VSpinnerChangeListener());
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)this.spinner, this.getDefaultGBC());
        if (this.nextButton != null) {
            this.nextRunnable = new Runnable(){

                @Override
                public void run() {
                    VSpinner.this.nextButtonWasClicked();
                }
            };
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MethodAction.invokeLater((Runnable)VSpinner.this.nextRunnable);
                }
            });
        }
        if (this.prevButton != null) {
            this.prevRunnable = new Runnable(){

                @Override
                public void run() {
                    VSpinner.this.previousButtonWasClicked();
                }
            };
            this.prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MethodAction.invokeLater((Runnable)VSpinner.this.prevRunnable);
                }
            });
        }
    }

    public VSpinner(String[] items) {
        this(null, null, false);
        this.setModel(items);
    }

    public VSpinner(Map<Object, Object> items) {
        this(null, null, false);
        this.setModel(items);
    }

    public VSpinner(DateTime dt, TimeZone tz) {
        this(null, null, false);
        this.setModel(dt, tz);
    }

    public VSpinner(int val, int min, int max) {
        this(val, min, max, 1);
    }

    public VSpinner(int val, int min, int max, int step) {
        this(null, null, false);
        this.setModel(val, min, max, step);
        JComponent ed = this.getSpinner().getEditor();
        Dimension d = ed.getPreferredSize();
        ++d.height;
        ed.setPreferredSize(d);
    }

    public VSpinner(double val, double min, double max, double step) {
        this(null, null, false);
        this.setModel(val, min, max, step);
        JComponent ed = this.getSpinner().getEditor();
        Dimension d = ed.getPreferredSize();
        ++d.height;
        ed.setPreferredSize(d);
    }

    protected VJSpinner createSpinner() {
        return new VJSpinner();
    }

    public VJSpinner getSpinner() {
        return this.spinner;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public JButton getPreviousButton() {
        return this.prevButton;
    }

    protected void nextButtonWasClicked() {
    }

    protected void previousButtonWasClicked() {
    }

    protected static List<Object> _cleanItemList(List<Object> items) {
        Vector<Object> v = new Vector<Object>();
        if (items != null) {
            for (Object obj : items) {
                if (obj == null) continue;
                v.add(obj);
            }
        }
        return v;
    }

    protected static List<Object> _cleanItemList(Object[] items) {
        Vector<Object> v = new Vector<Object>();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                v.add(items[i]);
            }
        }
        return v;
    }

    protected static List<Object> _cleanItemList(Map<Object, Object> items) {
        Vector<Object> v = new Vector<Object>();
        if (items != null) {
            for (Object obj : items.keySet()) {
                if (obj == null) continue;
                v.add(obj);
            }
        }
        return v;
    }

    public void setModel(int val, int min, int max) {
        this.setModel(val, min, max, 1);
    }

    public void setModel(int val, int min, int max, int step) {
        this.getSpinner().setModel(new SpinnerNumberModel(val, min, max, step));
    }

    public void setModel(double val, double min, double max, double step) {
        this.getSpinner().setModel(new SpinnerNumberModel(val, min, max, step));
    }

    public void setModel(Date dt, TimeZone tz) {
        if (dt != null) {
            Date min = DateTime.getMinDate().getDate();
            Date max = DateTime.getMaxDate().getDate();
            if (dt.compareTo(min) < 0) {
                dt = min;
            }
            if (dt.compareTo(max) > 0) {
                dt = max;
            }
            try {
                this.getSpinner().setModel(new VSpinnerDateModel(dt, (Comparable)min, (Comparable)max, 5));
            }
            catch (Throwable t) {
                Print.logException((String)"<JSpinner>.setModel", (Throwable)t);
                this.getSpinner().setModel(new VSpinnerDateModel());
            }
        } else {
            this.getSpinner().setModel(new VSpinnerDateModel());
        }
        this.propertyMap = null;
    }

    public void setModel(DateTime dt, TimeZone tz) {
        this.setModel(dt != null ? dt.getDate() : null, tz);
    }

    public void setModel(Object[] items) {
        Object selItem = this.getSelectedItem();
        this.getSpinner().setModel(new VSpinnerListModel(VSpinner._cleanItemList(items)));
        this.propertyMap = null;
        if (this.containsItem(selItem)) {
            this.setSelectedItem(selItem);
        }
    }

    public void setModel(List<Object> items) {
        this.setModel(VSpinner._cleanItemList(items));
    }

    public void setModel(Map<Object, Object> map) {
        Object selItem = this.getSelectedItem();
        this.getSpinner().setModel(new VSpinnerListModel(VSpinner._cleanItemList(map)));
        this.propertyMap = null;
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            this.setItemProperty(key.toString(), val);
        }
        if (this.containsItem(selItem)) {
            this.setSelectedItem(selItem);
        }
    }

    public SpinnerModel getModel() {
        return this.getSpinner().getModel();
    }

    public boolean isNumberModel() {
        SpinnerModel model = this.getModel();
        return model instanceof SpinnerNumberModel;
    }

    public Class getNumberModelClass() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            Number n = ((SpinnerNumberModel)model).getStepSize();
            return n != null ? n.getClass() : null;
        }
        return null;
    }

    public Comparable getMinimum() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getMinimum();
        }
        return null;
    }

    public Comparable getMaximum() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getMaximum();
        }
        return null;
    }

    public Number getStepSize() {
        SpinnerModel model = this.getModel();
        if (model instanceof SpinnerNumberModel) {
            return ((SpinnerNumberModel)model).getStepSize();
        }
        return null;
    }

    public void addItem(Object[] item) {
        if (item != null) {
            for (int i = 0; i < item.length; ++i) {
                this.addItem(item[i]);
            }
        }
    }

    public void addItem(Object item) {
        this.addItem(item.toString(), item instanceof String ? null : item);
    }

    public void addItem(String item, Object property) {
        SpinnerModel model = this.getModel();
        if (model instanceof VSpinnerListModel) {
            ((VSpinnerListModel)model).addItem(item);
        } else {
            Print.logWarn((String)("'addItem' not supported for model " + StringTools.className((Object)model)), (Object[])new Object[0]);
        }
        this.setItemProperty(item, property);
    }

    public void addItem(String item, int property) {
        this.addItem(item, new Integer(property));
    }

    public List<Object> getItemList() {
        SpinnerModel model = this.getModel();
        if (model instanceof VSpinnerListModel) {
            return ((VSpinnerListModel)model).getItemList();
        }
        Print.logWarn((String)("'getItemList' not supported for model " + StringTools.className((Object)model)), (Object[])new Object[0]);
        return null;
    }

    public void setItemProperty(String item, Object property) {
        if (property != null || this.propertyMap != null) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap();
            }
            if (property != null) {
                this.propertyMap.put(item, property);
            } else {
                this.propertyMap.remove(item);
            }
        }
    }

    public Object getItemProperty(Object item) {
        if (this.propertyMap != null) {
            Object prop = this.propertyMap.get(item);
            return prop != null ? prop : item;
        }
        return item;
    }

    public String getPropertyText(Object prop) {
        Object item = this.getPropertyItem(prop);
        return item != null ? item.toString() : null;
    }

    public Object getPropertyItem(Object prop) {
        if (prop == null) {
            return null;
        }
        if (this.propertyMap != null) {
            for (String key : this.propertyMap.keySet()) {
                Object val = this.propertyMap.get(key);
                if (prop != val && !prop.equals(val)) continue;
                return key;
            }
            return prop;
        }
        return prop;
    }

    public boolean containsItem(Object item) {
        if (item != null) {
            SpinnerModel model = this.getModel();
            if (model instanceof SpinnerListModel) {
                SpinnerListModel slm = (SpinnerListModel)model;
                List<?> slmList = slm.getList();
                return slmList.indexOf(item) >= 0;
            }
            if (model instanceof SpinnerNumberModel) {
                Number max;
                SpinnerNumberModel snm = (SpinnerNumberModel)model;
                Class<?> nc = snm.getStepSize() != null ? snm.getStepSize().getClass() : null;
                Number val = nc != null ? (Number)StringTools.parseNumber((Object)item, nc, null) : (Number)null;
                Number min = snm.getMinimum() instanceof Number ? (Number)((Number)((Object)snm.getMinimum())) : (Number)null;
                Number number = max = snm.getMaximum() instanceof Number ? (Number)((Number)((Object)snm.getMaximum())) : (Number)null;
                if (val instanceof Comparable && min != null && max != null) {
                    Comparable vc = (Comparable)((Object)val);
                    return vc.compareTo(min) >= 0 && vc.compareTo(max) <= 0;
                }
            }
        }
        return false;
    }

    public void setSelectedText(String item) {
        this.setSelectedItem(item);
    }

    public void setSelectedItem(Object item) {
        Object selItem = this.getSelectedItem();
        if (item != null) {
            if (!item.equals(selItem)) {
                SpinnerModel model = this.getModel();
                if (model instanceof SpinnerListModel) {
                    this.getSpinner().setValue(item, true);
                } else if (model instanceof SpinnerDateModel) {
                    if (item instanceof DateTime) {
                        this.getSpinner().setValue(((DateTime)item).getDate(), true);
                    } else if (item instanceof Date) {
                        this.getSpinner().setValue((Date)item, true);
                    } else {
                        Print.logError((String)("Unrecognized type: " + StringTools.className((Object)item)), (Object[])new Object[0]);
                    }
                } else if (model instanceof SpinnerNumberModel) {
                    if (item instanceof Number) {
                        this.getSpinner().setValue((Number)item, true);
                    } else {
                        Print.logError((String)("Unrecognized type: " + StringTools.className((Object)item)), (Object[])new Object[0]);
                    }
                } else {
                    Print.logError((String)("Unrecognized model: " + StringTools.className((Object)model)), (Object[])new Object[0]);
                }
            }
        } else if (selItem != null) {
            this.getSpinner().setValue("", true);
        }
    }

    public void setSelectedProperty(Object prop) {
        Object selProp = this.getSelectedProperty();
        if (prop != null) {
            if (!prop.equals(selProp)) {
                this.setSelectedItem(this.getPropertyItem(prop));
            }
        } else if (selProp != null) {
            this.setSelectedItem(null);
        }
    }

    public void setSelectedProperty(int prop) {
        this.setSelectedProperty(new Integer(prop));
    }

    public void setSelectedProperty(double prop) {
        this.setSelectedProperty(new Double(prop));
    }

    @Override
    public void setValue(Object prop) {
        this.setSelectedProperty(prop);
    }

    public void setValue(int prop) {
        this.setSelectedProperty(new Integer(prop));
    }

    public void setValue(double prop) {
        this.setSelectedProperty(new Double(prop));
    }

    public Object getSelectedItem() {
        Object val = this.getSpinner().getValue();
        return val;
    }

    public String getSelectedText() {
        Object sel = this.getSelectedItem();
        return sel != null ? sel.toString() : null;
    }

    public Object getSelectedProperty() {
        return this.getItemProperty(this.getSelectedItem());
    }

    @Override
    public Object getValue() {
        Object prop = this.getSelectedProperty();
        return prop;
    }

    public Number getNumberValue(Number dft) {
        Object prop = this.getSelectedProperty();
        return StringTools.parseNumber((Object)prop, (Class)this.getNumberModelClass(), (Number)dft);
    }

    public int getIntValue(int dft) {
        Object prop = this.getSelectedProperty();
        return StringTools.parseInt((Object)prop, (int)dft);
    }

    public double getDoubleValue(double dft) {
        Object prop = this.getSelectedProperty();
        return StringTools.parseDouble((Object)prop, (double)dft);
    }

    public DateTime getDateTimeValue(DateTime dft) {
        Object sel = this.getSelectedItem();
        if (sel instanceof DateTime) {
            return (DateTime)sel;
        }
        if (sel instanceof Date) {
            return new DateTime((Date)sel);
        }
        return dft;
    }

    public void setTimeZone(TimeZone tz) {
        if (tz != null) {
            this.getSpinner().setTimeZone(tz);
        } else {
            this.getSpinner().setTimeZone(DateTime.getDefaultTimeZone());
        }
    }

    @Override
    protected void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        this.getSpinner().setEnabled(!R && this.isEnabled());
        this.resetColors();
    }

    @Override
    protected void enabledStateChanged(boolean enabled) {
        if (this.getSpinner() != null) {
            boolean E = enabled && this._isEnabled();
            this.getSpinner().setEnabled(E && !this.isReadOnly());
            this.resetColors();
        }
    }

    private void resetColors() {
        if (this.getSpinner() != null) {
            Color fg;
            boolean en = this.isEnabled();
            boolean ro = this.isReadOnly();
            Color color = fg = en ? Color.black : Color.darkGray;
            Color bg = en ? (ro ? READONLY_BACKGROUND_COLOR : Color.white) : Color.gray;
            this.getSpinner().setForeground(fg);
            this.getSpinner().setBackground(bg);
        }
    }

    public void addButton(VButton btn) {
        this.setGBCX(0.0, -1, 0);
        btn.setPreferredHeight(this.getSpinner().getPreferredSize().height);
        this.add((Component)btn, this.getDefaultGBC());
    }

    @Override
    public void setMaximumSize(Dimension size) {
        super.setMaximumSize(size);
        if (this.spinnerFiller == null) {
            this.spinnerFiller = new JPanel();
            this.spinnerFiller.setOpaque(false);
            this.setGBCX(0.5, -1, 1);
            this.setGBCY(0.5, 0, 1);
            this.add((Component)this.spinnerFiller, this.getDefaultGBC());
            GridBagLayout gbl = this.getContainerLayout();
            GridBagConstraints gbc = gbl.getConstraints(this.getSpinner());
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbl.setConstraints(this.getSpinner(), gbc);
        }
    }

    public static class VSpinnerListModel
    extends SpinnerListModel {
        private List<Object> itemList = null;

        public VSpinnerListModel(List<Object> values) {
            super(values);
            this.itemList = values;
        }

        public List<Object> getItemList() {
            return this.itemList;
        }

        public void addItem(Object item) {
            if (this.itemList != null) {
                this.itemList.add(item);
            }
        }
    }

    public static class VSpinnerDateModel
    extends SpinnerDateModel {
        public VSpinnerDateModel() {
        }

        public VSpinnerDateModel(Date value, Comparable start, Comparable end, int calendarField) {
            super(value, start, end, calendarField);
        }

        @Override
        public void setValue(Object dt) {
            try {
                super.setValue(dt);
            }
            catch (Throwable t) {
                Print.logException((String)"setValue", (Throwable)t);
            }
        }
    }

    protected class VJSpinner
    extends JSpinner {
        private ChangeEvent changeEvent = new ChangeEvent(this);
        private int doFireChanged = 0;

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            super.addImpl(comp, constraints, index);
            if (constraints instanceof String) {
                String s = (String)constraints;
                if (comp instanceof JButton && s.equalsIgnoreCase("Next")) {
                    VSpinner.this.nextButton = (JButton)comp;
                } else if (comp instanceof JButton && s.equalsIgnoreCase("Previous")) {
                    VSpinner.this.prevButton = (JButton)comp;
                }
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = new Dimension(super.getPreferredSize());
            d.width += 9;
            return d;
        }

        @Override
        protected void fireStateChanged() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                ChangeListener cl = (ChangeListener)listeners[i + 1];
                if (this.doFireChanged != 0 && cl instanceof VSpinnerChangeListener) continue;
                cl.stateChanged(this.changeEvent);
            }
        }

        @Override
        public void setModel(SpinnerModel model) {
            super.setModel(model);
        }

        @Override
        public SpinnerModel getModel() {
            return super.getModel();
        }

        @Override
        protected JComponent createEditor(SpinnerModel model) {
            if (model instanceof SpinnerDateModel) {
                JSpinner.DateEditor de = new JSpinner.DateEditor((JSpinner)this, "yyyy/MM/dd HH:mm");
                Font font = VBox.FONT_MONOSPACED_PLAIN;
                de.setFont(font);
                de.getTextField().setFont(font);
                super.setFont(font);
                return de;
            }
            return super.createEditor(model);
        }

        @Override
        public Object getNextValue() {
            if (this.getModel() instanceof SpinnerNumberModel) {
                SpinnerNumberModel snm = (SpinnerNumberModel)this.getModel();
                Number val = (Number)snm.getNextValue();
                Number min = snm.getMinimum() instanceof Number ? (Number)((Number)((Object)snm.getMinimum())) : (Number)null;
                Number max = snm.getMaximum() instanceof Number ? (Number)((Number)((Object)snm.getMaximum())) : (Number)null;
                Number step = snm.getStepSize();
                if (val == null) {
                    return max;
                }
                if (step != null && min != null) {
                    double v = val.doubleValue();
                    double m = min.doubleValue();
                    double s = step.doubleValue();
                    double n = m + Math.floor((v - m) / s) * s;
                    return StringTools.parseNumber((Object)String.valueOf(n), step.getClass(), (Number)val);
                }
                return val;
            }
            return super.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            if (this.getModel() instanceof SpinnerNumberModel) {
                SpinnerNumberModel snm = (SpinnerNumberModel)this.getModel();
                Number val = (Number)snm.getPreviousValue();
                Number min = snm.getMinimum() instanceof Number ? (Number)((Number)((Object)snm.getMinimum())) : (Number)null;
                Number step = snm.getStepSize();
                if (val == null) {
                    return min;
                }
                if (step != null && min != null) {
                    double v = val.doubleValue();
                    double m = min.doubleValue();
                    double s = step.doubleValue();
                    double n = m + Math.ceil((v - m) / s) * s;
                    return StringTools.parseNumber((Object)String.valueOf(n), step.getClass(), (Number)val);
                }
                return val;
            }
            return super.getPreviousValue();
        }

        public void setTimeZone(TimeZone tz) {
            JComponent editor = super.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                ((JSpinner.DateEditor)editor).getFormat().setTimeZone(tz);
            }
        }

        @Override
        public void setValue(Object item) {
            super.setValue(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object item, boolean disableFireAction) {
            try {
                if (disableFireAction) {
                    this.suspendFireChanged(true);
                }
                this.setValue(item);
            }
            finally {
                if (disableFireAction) {
                    this.suspendFireChanged(false);
                }
            }
        }

        public void setSelectedIndex(int ndx) {
            SpinnerModel model = super.getModel();
            if (model instanceof SpinnerListModel) {
                SpinnerListModel slm = (SpinnerListModel)model;
                List<?> list = slm.getList();
                if (ndx >= 0 && ndx < list.size()) {
                    slm.setValue(list.get(ndx));
                }
            } else if (model instanceof SpinnerDateModel || model instanceof SpinnerNumberModel) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedIndex(int ndx, boolean disableFireAction) {
            try {
                if (disableFireAction) {
                    this.suspendFireChanged(true);
                }
                this.setSelectedIndex(ndx);
            }
            finally {
                if (disableFireAction) {
                    this.suspendFireChanged(false);
                }
            }
        }

        public void setSelectedItem(Object item) {
            SpinnerModel model = super.getModel();
            if (model instanceof SpinnerListModel) {
                SpinnerListModel slm = (SpinnerListModel)model;
                slm.setValue(item);
            } else if (model instanceof SpinnerDateModel) {
                SpinnerDateModel sdm = (SpinnerDateModel)model;
                if (item instanceof DateTime) {
                    sdm.setValue(((DateTime)item).getDate());
                } else if (item instanceof Date) {
                    sdm.setValue((Date)item);
                } else {
                    Print.logError((String)("Unrecognized item type: " + StringTools.className((Object)item)), (Object[])new Object[0]);
                }
            } else if (model instanceof SpinnerNumberModel) {
                SpinnerNumberModel snm = (SpinnerNumberModel)model;
                if (item instanceof Number) {
                    Class<?> c = snm.getStepSize().getClass();
                    Number num = StringTools.parseNumber((Object)item, c, null);
                    if (num != null) {
                        snm.setValue(num);
                    } else {
                        Print.logError((String)("Unable to convert item '" + item + "' to class '" + StringTools.className(c) + "'"), (Object[])new Object[0]);
                    }
                } else {
                    Print.logError((String)("Unrecognized item type: " + StringTools.className((Object)item)), (Object[])new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedItem(Object obj, boolean disableFireAction) {
            try {
                if (disableFireAction) {
                    this.suspendFireChanged(true);
                }
                this.setSelectedItem(obj);
            }
            finally {
                if (disableFireAction) {
                    this.suspendFireChanged(false);
                }
            }
        }

        public void suspendFireChanged(boolean suspendFireChanged) {
            if (suspendFireChanged) {
                ++this.doFireChanged;
            } else {
                --this.doFireChanged;
                if (this.doFireChanged < 0) {
                    this.doFireChanged = 0;
                }
            }
        }

        public JFormattedTextField getTextField() {
            return ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            this.getEditor().setFont(font);
            this.getTextField().setFont(font);
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.getTextField().setForeground(c);
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.getTextField().setBackground(c);
        }
    }

    private class VSpinnerChangeListener
    implements ChangeListener {
        private VSpinnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            VSpinner.this.fireAction(null, false);
            VSpinner.this.lastValue = VSpinner.this.getValue();
        }
    }
}

