/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButtonGroup;
import org.opengts.opt.ui.VRadioButton;

public class VRadioButtonBox
extends VBox {
    private int row = 0;
    private VButtonGroup group = new VButtonGroup();
    private ActionListener action = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            VRadioButtonBox.this.enableSelected();
            VRadioButtonBox.this.fireAction();
        }
    };

    public VRadioButtonBox(String title, String label, boolean bordered) {
        super(title, label, bordered);
    }

    public VRadioButton addRow(String title, VBox vb) {
        VRadioButton rb = new VRadioButton(title);
        rb.setPreferredHeight(18);
        this.setGBCX(0.5, 0, 1, 0, 0);
        this.setGBCY(0.0, this.row++, 1, 0, 0);
        this.add((Component)rb, this.getDefaultGBC());
        this.group.add(rb);
        rb.addActionListener(this.action);
        if (vb != null) {
            this.setGBCX(0.5, 0, 1, 23, 0);
            this.setGBCY(0.0, this.row++, 1, 0, 4);
            this.add((Component)vb, this.getDefaultGBC());
            vb.setEnabled(false);
            rb.setComponent(vb);
        }
        if (this.group.getButtonCount() == 1) {
            this.setSelectedRow(0);
            this.enableSelected();
        }
        return rb;
    }

    public void setSelectedRow(int index) {
        this.group.setSelectedIndex(index);
    }

    public int getSelectedRow() {
        return this.group.getSelectedIndex();
    }

    protected void enableSelected() {
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            VRadioButton rb;
            VBox vb;
            AbstractButton rbObj = e.nextElement();
            if (!(rbObj instanceof VRadioButton) || (vb = (rb = (VRadioButton)rbObj).getComponent()) == null) continue;
            vb.setEnabled(rb.isSelected());
        }
    }

    public void setRowValue(int ndx, Object val) {
        VBox box;
        Object rbObj = this.group.getObject(ndx);
        if (rbObj instanceof VRadioButton && (box = ((VRadioButton)rbObj).getComponent()) != null) {
            box.setValue(val);
        }
    }

    public Object getRowValue(int ndx) {
        Object rbObj = this.group.getObject(ndx);
        if (rbObj instanceof VRadioButton) {
            VBox box = ((VRadioButton)rbObj).getComponent();
            return box != null ? box.getValue() : null;
        }
        return null;
    }

    @Override
    public void setValue(Object val) {
        this.setRowValue(this.getSelectedRow(), val);
    }

    @Override
    public Object getValue() {
        return this.getRowValue(this.getSelectedRow());
    }
}

