/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.opt.ui.VBox;
import org.opengts.util.StringTools;

public class VRadioButton
extends JRadioButton
implements ActionListener {
    private Dimension preferredSize = null;
    private VBox component = null;

    public VRadioButton() {
        this(null, null, null, null);
    }

    public VRadioButton(String text) {
        this(text, null, null, null);
    }

    public VRadioButton(ActionTarget at) {
        this(at.getTitle(), at.getListener(), at.getCommand());
    }

    public VRadioButton(String text, ActionListener al) {
        this(text, null, al, text);
    }

    public VRadioButton(String text, ActionListener al, String actionCmd) {
        this(text, null, al, actionCmd);
    }

    public VRadioButton(Icon icon, ActionListener al, String actionCmd) {
        this(null, icon, al, actionCmd);
    }

    public VRadioButton(String text, Icon icon, ActionListener al) {
        this(text, icon, al, text);
    }

    public VRadioButton(String text, Icon icon, ActionListener al, String actionCmd) {
        super(text);
        this.setActionCommand(actionCmd != null ? actionCmd : text);
        if (icon != null) {
            this.setIcon(icon);
        }
        if (al != null) {
            this.addActionListener(al);
        }
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            super.setText("");
        } else if (text.indexOf("\n") >= 0) {
            String htmlText = "<html><center>" + StringTools.htmlFilterText((Object)text) + "</center></html>";
            super.setText(htmlText);
        } else {
            super.setText(text);
        }
    }

    public JToggleButton getToggleButton() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.doClick();
    }

    @Override
    public boolean isSelected() {
        return super.isSelected();
    }

    public void setReadOnly(boolean flag) {
        this.setEnabled(!flag);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.preferredSize == null) {
            return ps;
        }
        Dimension d = new Dimension(this.preferredSize);
        if (d.width < 0) {
            d.width = ps.width;
        }
        if (d.height < 0) {
            d.height = ps.height;
        }
        return d;
    }

    @Override
    public void setPreferredSize(Dimension ps) {
        this.preferredSize = ps;
    }

    public void setPreferredWidth(int w) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.width = w;
    }

    public void setPreferredHeight(int h) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.height = h;
    }

    public void setComponent(VBox component) {
        this.component = component;
    }

    public VBox getComponent() {
        return this.component;
    }
}

