/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VMenuItem;
import org.opengts.opt.ui.VSeparator;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VPopupMenu
extends JPopupMenu {
    public VPopupMenu() {
    }

    public VPopupMenu(String title) {
        super(title);
    }

    public VPopupMenu(JComponent[] comp) {
        this();
        this.add(comp);
    }

    public VPopupMenu(String title, JComponent[] comp) {
        this(title);
        this.add(comp);
    }

    @Override
    public JMenuItem add(JMenuItem item) {
        return item != null ? super.add(item) : null;
    }

    public void add(JComponent[] item) {
        if (item != null) {
            for (int i = 0; i < item.length; ++i) {
                JComponent jmi = item[i];
                if (jmi == null) continue;
                if (jmi instanceof JMenuItem) {
                    this.add((JMenuItem)jmi);
                    continue;
                }
                if (jmi instanceof JSeparator) {
                    this.add((JSeparator)jmi);
                    continue;
                }
                Print.logError((String)("Unsupported menu item type: " + StringTools.className((Object)jmi)), (Object[])new Object[0]);
            }
        }
    }

    public VMenuItem add(String title, ActionListener al) {
        return (VMenuItem)this.add(new VMenuItem(title, al));
    }

    public VMenuItem add(String title, ActionListener al, String cmd) {
        return (VMenuItem)this.add(new VMenuItem(title, al, cmd));
    }

    public JSeparator add(JSeparator sep) {
        return sep != null ? (JSeparator)super.add(sep) : null;
    }

    @Override
    public void addSeparator() {
        this.add(new VSeparator());
    }

    public void setActionEnabled(String ac, boolean enable) {
        VPopupMenu.setActionEnabled(this, ac, enable);
    }

    public static void setActionEnabled(JPopupMenu popup, String ac, boolean enable) {
        int cnt = popup.getComponentCount();
        for (int i = 0; i < cnt; ++i) {
            Component m = popup.getComponent(i);
            if (!(m instanceof AbstractButton)) continue;
            VButton.setActionEnabled((AbstractButton)m, ac, enable);
        }
    }
}

