/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.opt.ui.WinTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class VOptionPane {
    public static final int QUESTION_MESSAGE = 3;
    public static final int INFO_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int ERROR_MESSAGE = 0;
    public static final int WARNING_MESSAGE = 2;
    public static final int NO_OPTION = 1;
    public static final int YES_OPTION = 0;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    private static Map<Color, Border> sharedColorBorders = new HashMap<Color, Border>();

    protected static void _displayErrorIfNotDispatchThread() {
        if (RTConfig.isDebugMode() && !EventQueue.isDispatchThread()) {
            Print.logStackTrace((String)"VOptionPane invoked from a non-dispatch thread");
        }
    }

    public static void showNotImplemented(String m) {
        StringBuffer sb = new StringBuffer();
        if (m != null && !m.equals("")) {
            sb.append(m).append("\n");
        }
        sb.append("This feature is not yet available.\n");
        sb.append("Please check back soon.");
        VOptionPane.showWarningDialog(null, sb.toString(), "Under Construction");
    }

    public static void showNotImplemented() {
        VOptionPane.showNotImplemented(null);
    }

    private static void showTimedMessageDialog(Component parent, String msg, String title, long displayTimeMS, int type) {
        VOptionPane._displayErrorIfNotDispatchThread();
        VLabel m = new VLabel(msg);
        TimedDialogDisposal timer = new TimedDialogDisposal(m, displayTimeMS);
        timer.start();
        VOptionPane._showMessageDialog(parent, m, title, type);
        timer.stop();
    }

    private static Border createPopupBorder(Color color) {
        Border border;
        if (color == null) {
            color = Color.blue.darker().darker();
        }
        if ((border = sharedColorBorders.get(color)) == null) {
            Color hilight = color.brighter();
            Color shadow = color.darker().darker();
            border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createCompoundBorder(new BevelBorder(0, hilight, shadow), BorderFactory.createCompoundBorder(new LineBorder(color, 3), new BevelBorder(1, hilight, shadow))));
            sharedColorBorders.put(color, border);
        }
        return border;
    }

    private static Popup createMessagePopup(Component parent, String msg, String title, int type, Color borderColor) {
        VBox borderBox = new VBox(null, null, false);
        borderBox.setBorder(VOptionPane.createPopupBorder(borderColor));
        VBox box = new VBox(" " + title + " ", null, true);
        borderBox.setGBCX(0.5, 0, 1, 0, 0);
        borderBox.setGBCY(0.5, 0, 1, 0, 0);
        borderBox.add((Component)box, borderBox.getDefaultGBC());
        JOptionPane dp = new JOptionPane(msg, type, -1, null, new Object[0]);
        box.setGBCX(0.5, 0, 1, 0, 10);
        box.setGBCY(0.5, 0, 1, 0, 0);
        box.add((Component)dp, box.getDefaultGBC());
        Point offset = new Point(0, -10);
        Dimension boxSize = borderBox.getPreferredSize();
        Point parLoc = parent != null ? parent.getLocationOnScreen() : new Point(0, 0);
        Dimension parSize = parent != null ? parent.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        int x = parLoc.x + offset.x + (parSize.width - boxSize.width) / 2;
        int y = parLoc.y + offset.y + (parSize.height - boxSize.height) / 2;
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        Popup popup = popupFactory.getPopup(parent, borderBox, x, y);
        return popup;
    }

    public static void showTimedMessagePopup(Component parent, String msg, String title, long displayTimeMS, int type, Color borderColor) {
        VOptionPane._displayErrorIfNotDispatchThread();
        Popup popup = VOptionPane.createMessagePopup(parent, msg, title, type, borderColor);
        TimedDialogDisposal dd = new TimedDialogDisposal(popup, displayTimeMS);
        dd.start();
        popup.show();
    }

    public static void showInfoDialog(Component parent, Object msg, String title) {
        VOptionPane._showMessageDialog(parent, msg, title, 1);
    }

    public static void showInfoDialog(Component parent, Object msg) {
        VOptionPane.showInfoDialog(parent, msg, "Information Dialog");
    }

    public static void showInfoDialog(Component parent, String msg, String title, long displayTimeMS) {
        VOptionPane.showTimedMessageDialog(parent, msg, title, displayTimeMS, 1);
    }

    public static void showInfoPopup(Component parent, String msg, String title, long displayTimeMS) {
        Color borderColor = Color.blue.darker().darker();
        VOptionPane.showTimedMessagePopup(parent, msg, title, displayTimeMS, 1, borderColor);
    }

    public static void showErrorDialog(Component parent, Object msg, String title) {
        VOptionPane._showMessageDialog(parent, msg, title, 0);
    }

    public static void showErrorDialog(Component parent, Object msg) {
        VOptionPane.showErrorDialog(parent, msg, "Error Dialog");
    }

    public static void showErrorDialog(Component parent, String msg, String title, long displayTimeMS) {
        VOptionPane.showTimedMessageDialog(parent, msg, title, displayTimeMS, 0);
    }

    public static void showErrorPopup(Component parent, String msg, String title, long displayTimeMS) {
        Color borderColor = Color.red.darker().darker();
        VOptionPane.showTimedMessagePopup(parent, msg, title, displayTimeMS, 0, borderColor);
    }

    public static void showWarningDialog(Component parent, Object msg, String title) {
        VOptionPane._showMessageDialog(parent, msg, title, 2);
    }

    public static void showWarningDialog(Component parent, Object msg) {
        VOptionPane.showWarningDialog(parent, msg, "Warning Dialog");
    }

    public static void showWarningDialog(Component parent, String msg, String title, long displayTimeMS) {
        VOptionPane.showTimedMessageDialog(parent, msg, title, displayTimeMS, 2);
    }

    public static void showWarningPopup(Component parent, String msg, String title, long displayTimeMS) {
        Color borderColor = Color.yellow.darker().darker();
        VOptionPane.showTimedMessagePopup(parent, msg, title, displayTimeMS, 2, borderColor);
    }

    public static boolean showYesNoDialog(Component parent, Object msg, String title) {
        int rtn = VOptionPane._showConfirmDialog(parent, msg, title, 0);
        return rtn == 0;
    }

    public static boolean showYesNoDialog(Component parent, Object msg) {
        return VOptionPane.showYesNoDialog(parent, msg, "Confirmation Dialog");
    }

    public static boolean showOkCancelDialog(Component parent, Object msg, String title) {
        int rtn = VOptionPane._showConfirmDialog(parent, msg, title, 2);
        return rtn == 0;
    }

    public static boolean showOkCancelDialog(Component parent, Object msg) {
        return VOptionPane.showOkCancelDialog(parent, msg, "Confirmation Dialog");
    }

    public static int showYesNoCancelDialog(Component parent, Object msg, String title) {
        return VOptionPane._showConfirmDialog(parent, msg, title, 1);
    }

    public static int showYesNoCancelDialog(Component parent, Object msg) {
        return VOptionPane.showYesNoCancelDialog(parent, msg, "Confirmation Dialog");
    }

    public static String showTextInputDialog(Component parent, Object msg, String title) {
        VOptionPane._displayErrorIfNotDispatchThread();
        String s = JOptionPane.showInputDialog(VOptionPane.getParent(parent), msg, title, 3);
        return s != null ? s.trim() : null;
    }

    public static String showTextInputDialog(Component parent, Object msg) {
        return VOptionPane.showTextInputDialog(parent, msg, "Text Input");
    }

    public static String showTextInputDialog(Component parent, Object msg, String title, String dftText) {
        Object[] m;
        boolean rtn;
        VTextField textInput = new VTextField(null, null, false, false);
        if (dftText != null) {
            textInput.setText(dftText);
        }
        if (rtn = VOptionPane.showOkCancelDialog(parent, m = new Object[]{msg, textInput}, title)) {
            return textInput.getText();
        }
        return null;
    }

    public static String showPasswordConfirmInputDialog(Component parent, Object msg, String title) {
        boolean rtn;
        String retryMsg = "<html><i>(&nbsp;password not confirmed, please try again&nbsp;)&nbsp;</i></html>  ";
        String confirmMsg = "Confirm password:";
        VTextField password_1 = new VTextField(null, null, false, true);
        VTextField password_2 = new VTextField(null, null, false, true);
        Object[] m = new Object[]{msg, password_1, confirmMsg, password_2};
        while (rtn = VOptionPane.showOkCancelDialog(parent, m, title)) {
            String pass_2;
            String pass_1 = password_1.getText();
            if (pass_1.equals(pass_2 = password_2.getText())) {
                return pass_1;
            }
            password_1.setText("");
            password_2.setText("");
            m = new Object[]{retryMsg, msg, password_1, confirmMsg, password_2};
        }
        return null;
    }

    public static String showPasswordInputDialog(Component parent, Object msg, String title) {
        VTextField password = new VTextField(null, null, false, true);
        Object[] m = new Object[]{msg, password};
        boolean rtn = VOptionPane.showOkCancelDialog(parent, m, title);
        if (rtn) {
            return password.getText();
        }
        return null;
    }

    public static String showPasswordInputDialog(Component parent, Object msg) {
        return VOptionPane.showPasswordInputDialog(parent, msg, "Enter Password");
    }

    public static String showTextAreaInputDialog(Component parent, Object msg, String title) {
        VTextArea textArea = new VTextArea(6, 45);
        Object[] m = new Object[]{msg, textArea};
        boolean rtn = VOptionPane.showOkCancelDialog(parent, m, title);
        return rtn ? textArea.getText() : null;
    }

    public static String showTextAreaInputDialog(Component parent, Object msg) {
        return VOptionPane.showTextAreaInputDialog(parent, msg, "Text Input");
    }

    public static void showTextAreaInfoDialog(Component parent, String msg, String title) {
        VOptionPane.showTextAreaInfoDialog(parent, 16, 50, msg, "Text Output");
    }

    public static void showTextAreaInfoDialog(Component parent, int rows, int cols, String msg, String title) {
        VTextArea textArea = new VTextArea(rows, cols);
        textArea.setReadOnly(true);
        textArea.setText(msg != null ? msg : "");
        Object[] m = new Object[]{textArea};
        VOptionPane._showMessageDialog(parent, m, title, 1);
    }

    public static void showTextAreaInfoDialog(Component parent, String msg) {
        VOptionPane.showTextAreaInfoDialog(parent, msg, "Text Output");
    }

    public static Object showComboInputDialog(Component parent, Object msg, Map map, String title) {
        VComboBox comboBox = new VComboBox(null, null, false);
        comboBox.setModel(map);
        Object[] m = new Object[]{msg, comboBox};
        boolean rtn = VOptionPane.showOkCancelDialog(parent, m, title);
        return rtn ? comboBox.getValue() : null;
    }

    public static Object showComboInputDialog(Component parent, Object msg, Object[] list, String title) {
        VComboBox comboBox = new VComboBox(null, null, false);
        comboBox.setModel(list);
        Object[] m = new Object[]{msg, comboBox};
        boolean rtn = VOptionPane.showOkCancelDialog(parent, m, title);
        return rtn ? comboBox.getValue() : null;
    }

    public static Object showComboInputDialog(Component parent, Object msg, Object[] list) {
        return VOptionPane.showComboInputDialog(parent, msg, list, "Selection Input");
    }

    public static VDialog showProgressDialog(Component parent, Object msg, String title) {
        return VOptionPane.showProgressDialog(parent, msg, title, true);
    }

    public static VDialog showProgressDialog(Component parent, Object msg, String title, boolean show) {
        VOptionPane._displayErrorIfNotDispatchThread();
        VDialog dialog = new VDialog(WinTools.getParentFrame(VOptionPane.getParent(parent)), title, false);
        VBox container = dialog.getContentBox();
        JOptionPane dp = new JOptionPane(msg, 1, -1, null, new Object[0]);
        container.setGBCX(0.5, 0, 1, 0, 10);
        container.setGBCY(0.5, 0, 1, 0, 0);
        container.add((Component)dp, container.getDefaultGBC());
        Point offset = new Point(0, -10);
        Dimension boxSize = new Dimension(dp.getPreferredSize());
        boxSize.width += 30;
        boxSize.height += 40;
        Point parLoc = parent != null ? parent.getLocationOnScreen() : new Point(0, 0);
        Dimension parSize = parent != null ? parent.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        int x = parLoc.x + offset.x + (parSize.width - boxSize.width) / 2;
        int y = parLoc.y + offset.y + (parSize.height - boxSize.height) / 2;
        dialog.setBounds(x, y, boxSize.width, boxSize.height);
        if (show) {
            dialog.show();
        }
        return dialog;
    }

    private static Component getParent(Component p) {
        for (Component c = p; c != null; c = c.getParent()) {
            if (!(c instanceof JScrollPane)) continue;
            return c;
        }
        return p;
    }

    public static void _showMessageDialog(final Component parent, final Object m, final String title, final int msgType) throws HeadlessException {
        boolean isDispatchThread = EventQueue.isDispatchThread();
        if (isDispatchThread) {
            JOptionPane.showMessageDialog(VOptionPane.getParent(parent), m, title, msgType);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(VOptionPane.getParent(parent), m, title, msgType);
                    }
                });
            }
            catch (InterruptedException ie) {
                Print.logWarn((String)"Thread interrupted ...", (Object[])new Object[0]);
            }
            catch (InvocationTargetException ite) {
                Print.logWarn((String)"EventQueue.invokeAndWait failed! ...", (Object[])new Object[0]);
            }
        }
    }

    public static int _showConfirmDialog(final Component parent, final Object m, final String title, final int msgType) throws HeadlessException {
        boolean isDispatchThread = EventQueue.isDispatchThread();
        if (isDispatchThread) {
            return JOptionPane.showConfirmDialog(VOptionPane.getParent(parent), m, title, msgType);
        }
        final int[] opt = new int[]{0};
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    opt[0] = JOptionPane.showConfirmDialog(VOptionPane.getParent(parent), m, title, msgType);
                }
            });
        }
        catch (InvocationTargetException ite) {
            Print.logWarn((String)"EventQueue.invokeAndWait failed! ...", (Object[])new Object[0]);
        }
        catch (InterruptedException ie) {
            Print.logWarn((String)"Thread interrupted ...", (Object[])new Object[0]);
        }
        return opt[0];
    }

    private static class TimedDialogDisposal
    implements ActionListener {
        private Component comp = null;
        private Popup popup = null;
        private Timer timer = null;
        private int timeout = 0;

        public TimedDialogDisposal(Component c, long timeoutMS) {
            this.comp = c;
            this.timeout = (int)timeoutMS;
        }

        public TimedDialogDisposal(Popup p, long timeoutMS) {
            this.popup = p;
            this.timeout = (int)timeoutMS;
        }

        public void start() {
            if (this.timer == null) {
                this.timer = new Timer(this.timeout, this);
                this.timer.setRepeats(false);
                this.timer.start();
            } else {
                this.timer.restart();
            }
        }

        public void stop() {
            if (this.timer != null) {
                this.timer.stop();
                this.actionPerformed(null);
                this.timer = null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Dialog dialog;
            this.timer = null;
            if (this.comp != null && this.comp.isVisible() && (dialog = WinTools.getParentDialog(this.comp)) != null && dialog.isVisible()) {
                dialog.dispose();
            }
            if (this.popup != null) {
                this.popup.hide();
                this.popup = null;
            }
        }
    }
}

