/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VMenuLayout
implements LayoutManager {
    private int maxRows = 10;
    private int hgap = 0;
    private int vgap = 0;

    public VMenuLayout(int maxRows) {
        this(maxRows, 2, 0);
    }

    public VMenuLayout(int maxRows, int hgap, int vgap) {
        this.setRows(maxRows);
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    public int getRows() {
        return this.maxRows;
    }

    public void setRows(int rows) {
        this.maxRows = rows;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            Insets insets = target.getInsets();
            int nMembers = target.getComponentCount();
            int vMembers = 0;
            for (int i = 0; i < nMembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                ++vMembers;
                Dimension md = m.getPreferredSize();
                if (md.height > d.height) {
                    d.height = md.height;
                }
                if (md.width <= d.width) continue;
                d.width = md.width;
            }
            int rows = vMembers < this.maxRows ? vMembers : this.maxRows;
            int cols = (vMembers - 1) / rows + 1;
            int width = d.width * cols + this.hgap * (cols - 1) + (insets.left + insets.right);
            int height = d.height * rows + this.vgap * (rows - 1) + (insets.top + insets.bottom);
            return new Dimension(width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            Insets insets = target.getInsets();
            int nMembers = target.getComponentCount();
            int vMembers = 0;
            for (int i = 0; i < nMembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                ++vMembers;
                Dimension md = m.getMinimumSize();
                if (md.height > d.height) {
                    d.height = md.height;
                }
                if (md.width <= d.width) continue;
                d.width = md.width;
            }
            int rows = vMembers < this.maxRows ? vMembers : this.maxRows;
            int cols = (vMembers - 1) / rows + 1;
            int width = d.width * cols + this.hgap * (cols - 1) + (insets.left + insets.right);
            int height = d.height * rows + this.vgap * (rows - 1) + (insets.top + insets.bottom);
            return new Dimension(width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int nMembers = target.getComponentCount();
            int vMembers = 0;
            for (int i = 0; i < nMembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                ++vMembers;
            }
            Insets insets = target.getInsets();
            int cols = (vMembers - 1) / this.maxRows + 1;
            int rows = vMembers < this.maxRows ? vMembers : this.maxRows;
            int maxCellWidth = (target.getWidth() - (insets.left + insets.right + this.hgap * (cols - 1))) / cols;
            int maxCellHeight = (target.getHeight() - (insets.top + insets.bottom + this.vgap * (rows - 1))) / rows;
            int x = insets.left;
            int y = insets.top;
            int displayCount = 0;
            int currentRow = 0;
            for (int i = 0; i < nMembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (currentRow >= this.maxRows) {
                    x += maxCellWidth + this.hgap;
                    y = insets.top;
                    currentRow = 0;
                }
                Dimension d = new Dimension(m.getPreferredSize());
                Dimension sd = new Dimension(Math.min(maxCellWidth, d.width), Math.min(maxCellHeight, d.height));
                m.setSize(sd.width, sd.height);
                m.setLocation(x, y);
                y += sd.height + this.vgap;
                ++displayCount;
                ++currentRow;
            }
        }
    }
}

