/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VList;
import org.opengts.opt.ui.VListItem;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VSplitPane;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VListViewer
extends VBox {
    public static final Color COLOR_NORMAL_BACKGROUND = new Color(246, 246, 255);
    public static final Color COLOR_SELECT_BACKGROUND = new Color(235, 235, 255);
    private VList listView = null;
    private VBox customContainer = null;
    private VSplitPane splitView = null;
    private VButton prevButton = null;
    private VButton nextButton = null;
    private VList.CustomKeyBindingHandler keyBindingHandler = null;

    public VListViewer(String listTitle) {
        this(null, listTitle, -1, false);
    }

    public VListViewer(String boxTitle, String listTitle, boolean bordered) {
        this(boxTitle, listTitle, -1, bordered);
    }

    public VListViewer(String boxTitle, String listTitle, int preferredListWidth, boolean bordered) {
        super(boxTitle, null, bordered);
        this.listView = this.createVList(listTitle);
        this.listView.addSelectionListener(new VList.VListSelectionListener(){

            @Override
            public void selectionChanged(VList list) {
                VListItem item = list.getSelectedItem();
                if (item != null) {
                    Component c = item.getCustomView();
                    VListViewer.this.setCustomView(c);
                } else {
                    VListViewer.this.setCustomView(null);
                }
                VListViewer.this.updateButtonEnabledState();
            }
        });
        this.setPreferredListWidth(preferredListWidth);
        this.customContainer = new VBox(null, null, false);
        this.customContainer.setGBCX(0.5, 0, 1);
        this.customContainer.setGBCY(0.5, 0, 1);
        Component dftView = this.createDefaultView();
        if (dftView != null) {
            this.customContainer.add(dftView, this.customContainer.getDefaultGBC());
        }
        this.splitView = new VSplitPane(1, this.listView, this.customContainer);
        this.splitView.setContinuousLayout(true);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        this.add((Component)this.splitView, this.getDefaultGBC());
        boolean ADD_PREV_NEXT_BUTTONS = true;
        if (ADD_PREV_NEXT_BUTTONS) {
            JPanel statusBox = this.getStatusArea();
            GridBagConstraints btnBoxGBC = VBox.NewGBC();
            VBox.SetGBCX(btnBoxGBC, 0.5, 0, 1, 0, 0);
            VBox.SetGBCY(btnBoxGBC, 0.0, 1, 1, 0, 5);
            JPanel buttonBox = new JPanel(new GridBagLayout());
            buttonBox.setOpaque(false);
            statusBox.add((Component)buttonBox, btnBoxGBC);
            this.prevButton = new VButton("< Back");
            this.prevButton.resetKeyboardActions();
            this.prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    VListViewer.this.selectPrevious(false);
                }
            });
            GridBagConstraints prevGBC = VBox.NewGBC();
            VBox.SetGBCX(prevGBC, 0.0, 0, 1, 15, 0);
            VBox.SetGBCY(prevGBC, 0.0, 0, 1, 0, 0);
            prevGBC.anchor = 17;
            buttonBox.add((Component)this.prevButton, prevGBC);
            this.nextButton = new VButton("Next >");
            this.nextButton.resetKeyboardActions();
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    VListViewer.this.selectNext(false);
                }
            });
            GridBagConstraints nextGBC = VBox.NewGBC();
            VBox.SetGBCX(nextGBC, 0.0, 1, 1, 5, 0);
            VBox.SetGBCY(nextGBC, 0.0, 0, 1, 0, 0);
            nextGBC.anchor = 17;
            buttonBox.add((Component)this.nextButton, nextGBC);
            boolean gridX = false;
            GridBagConstraints fillGBC = VBox.NewGBC();
            VBox.SetGBCX(fillGBC, 0.5, 9, 1, 0, 0);
            VBox.SetGBCY(fillGBC, 0.0, 0, 1);
            fillGBC.fill = 2;
            JPanel buttonBoxFiller = new JPanel();
            buttonBoxFiller.setOpaque(false);
            buttonBox.add((Component)buttonBoxFiller, fillGBC);
        }
        this.keyBindingHandler = this.getCustomKeyBindingHandler();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return this.getCustomKeyBindingHandler().processKeyBinding(ks, e, condition, pressed);
    }

    protected void updateButtonEnabledState() {
        int selNdx = this.listView.getSelectedIndex();
        VListItem selItem = this.listView.getSelectedItem();
        if (selNdx <= 0) {
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setEnabled(selItem == null || selItem.allowSelectPrevious());
        }
        if (selNdx < 0 || selNdx >= this.listView.getListSize() - 1) {
            this.nextButton.setEnabled(false);
        } else {
            this.nextButton.setEnabled(selItem == null || selItem.allowSelectNext());
        }
    }

    public VList getVList() {
        return this.listView;
    }

    public void addSelectionListener(VList.VListSelectionListener lsl) {
        this.listView.addSelectionListener(lsl);
    }

    public void removeSelectionListener(VList.VListSelectionListener lsl) {
        this.listView.removeSelectionListener(lsl);
    }

    public void setListTitle(String title) {
        this.getVList().setTitle(title);
    }

    protected Component createDefaultView() {
        return null;
    }

    public VList createVList(String listTitle) {
        return new CustomList(listTitle);
    }

    public void setPreferredListWidth(int width) {
        if (width > 0) {
            this.listView.setPreferredWidth(width);
        }
    }

    public void setListItems(List<VListItem> items) {
        if (!ListTools.isEmpty(items)) {
            Vector<Object> objList = new Vector<Object>();
            for (VListItem vli : items) {
                objList.add(vli.getListObject());
            }
            this.listView.setListData(objList);
        } else {
            this.listView.setListData((List)null);
        }
    }

    public void setListItems(VListItem[] items) {
        if (!ListTools.isEmpty((Object[])items)) {
            Vector<Object> objList = new Vector<Object>();
            for (VListItem vli : items) {
                objList.add(vli.getListObject());
            }
            this.listView.setListData(objList);
        } else {
            this.listView.setListData((List)null);
        }
    }

    public VListItem getSelectedItem() {
        return this.listView.getSelectedItem();
    }

    public void setSelectedItem(String key) {
        VListItem selItem = this.getSelectedItem();
        if (selItem != null && !selItem.getKey().equals(key) && !selItem.validateCustomView()) {
            return;
        }
        if (StringTools.isBlank((String)key)) {
            this.clearSelection();
        } else {
            List<Object> list = this.listView.getListData();
            for (int i = 0; i < list.size(); ++i) {
                Object item = list.get(i);
                if (!(item instanceof VListItem) || !key.equals(((VListItem)item).getKey())) continue;
                this.listView.setSelectedIndex(i);
                return;
            }
            this.clearSelection();
        }
    }

    public void clearSelection() {
        this.listView.clearSelection();
    }

    public void selectNext(boolean wrap) {
        int size = this.listView.getListSize();
        if (size > 0) {
            Object newVal;
            Object selVal;
            int selNdx = this.listView.getSelectedIndex();
            if (selNdx < 0) {
                selNdx = 0;
            }
            if ((selVal = this.listView.getValueAt(selNdx)) instanceof ItemValidator && !((ItemValidator)selVal).isListItemValid(true)) {
                return;
            }
            if (selVal instanceof VListItem && !((VListItem)selVal).allowSelectNext()) {
                return;
            }
            int newNdx = selNdx;
            do {
                if (wrap) {
                    newNdx = (newNdx + 1) % size;
                    continue;
                }
                if (newNdx + 1 < size) {
                    ++newNdx;
                    continue;
                }
                if (newNdx != selNdx) continue;
                return;
            } while ((newVal = this.listView.getValueAt(newNdx)) instanceof JSeparator || newVal instanceof VListItem && ((VListItem)newVal).isSeparator());
            this.listView.setSelectedIndex(newNdx);
        }
    }

    public void selectPrevious(boolean wrap) {
        int size = this.listView.getListSize();
        if (size > 0) {
            Object newVal;
            Object selVal;
            int selNdx = this.listView.getSelectedIndex();
            if (selNdx < 0) {
                selNdx = 0;
            }
            if ((selVal = this.listView.getValueAt(selNdx)) instanceof VListItem && !((VListItem)selVal).allowSelectPrevious()) {
                return;
            }
            int newNdx = selNdx;
            do {
                if (wrap) {
                    newNdx = (newNdx + size - 1) % size;
                    continue;
                }
                if (newNdx > 0) {
                    --newNdx;
                    continue;
                }
                if (newNdx != selNdx) continue;
                return;
            } while ((newVal = this.listView.getValueAt(newNdx)) instanceof JSeparator || newVal instanceof VListItem && ((VListItem)newVal).isSeparator());
            this.listView.setSelectedIndex(newNdx);
        }
    }

    public VList.CustomKeyBindingHandler getCustomKeyBindingHandler() {
        if (this.keyBindingHandler == null) {
            this.keyBindingHandler = new VList.CustomKeyBindingHandler(){

                @Override
                public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    if (condition == 0 && pressed) {
                        int kc = e.getKeyCode();
                        boolean wrap = false;
                        switch (kc) {
                            case 37: 
                            case 38: {
                                VListViewer.this.selectPrevious(wrap);
                                return true;
                            }
                            case 39: 
                            case 40: {
                                VListViewer.this.selectNext(wrap);
                                return true;
                            }
                        }
                    }
                    return false;
                }
            };
        }
        return this.keyBindingHandler;
    }

    public VBox getCustomContainer() {
        return this.customContainer;
    }

    protected void setCustomView(Component comp) {
        JPanel container = this.customContainer.getContainerArea();
        container.removeAll();
        this.customContainer.invalidate();
        this.customContainer.validate();
        if (comp != null) {
            GridBagConstraints gbc = this.customContainer.getDefaultGBC();
            this.customContainer.add(comp, gbc);
            if (comp instanceof VBox) {
                ((VBox)comp).refresh();
            }
        }
        this.customContainer.invalidate();
        this.customContainer.validate();
        this.customContainer.repaint();
    }

    public VContextMenu setContextMenu(JPopupMenu popup) {
        return this.listView.setContextMenu(popup);
    }

    public VContextMenu setContextMenu(VPopupMenuProvider popupProv) {
        return this.listView.setContextMenu(popupProv);
    }

    public VContextMenu getContextMenu() {
        return this.listView.getContextMenu();
    }

    public static interface ItemValidator {
        public boolean isListItemValid(boolean var1);
    }

    public static class CustomListCellRenderer
    extends VList.VListCellRenderer {
        private Font fontPlain = null;
        private Font fontBold = null;
        private Border border = new EmptyBorder(1, 1, 1, 1);
        private Color selectBackground = null;
        private Color normalForeground = null;
        private Color disablForeground = null;

        public CustomListCellRenderer() {
            this.fontPlain = VBox.FONT_DIALOG_PLAIN(12);
            this.fontBold = VBox.FONT_DIALOG_BOLD(12);
            this.selectBackground = COLOR_SELECT_BACKGROUND;
            this.normalForeground = new Color(0, 0, 0);
            this.disablForeground = new Color(0, 0, 180);
        }

        @Override
        protected Component adjustsRendererComponent(JList list, Object val, int index, boolean isSel, boolean focus) {
            this.setBorder(this.border);
            if (isSel) {
                this.setBackground(this.selectBackground);
                this.setFont(this.fontBold);
            } else {
                this.setBackground(COLOR_NORMAL_BACKGROUND);
                this.setFont(this.fontPlain);
            }
            if (val instanceof VListItem) {
                this.setForeground(((VListItem)val).isEnabled() ? this.normalForeground : this.disablForeground);
            }
            this.setOpaque(true);
            this.setEnabled(list.isEnabled());
            this.setPreferredHeight(list.getFixedCellHeight());
            return this;
        }
    }

    public class CustomList
    extends VList {
        public CustomList(String title) {
            super(title, null, false);
            this.setBackground(COLOR_NORMAL_BACKGROUND);
            Print.logInfo((String)"Resetting all keyboard actions ...", (Object[])new Object[0]);
            this.resetKeyboardActions();
            this.setKeyBindingHandler(VListViewer.this.getCustomKeyBindingHandler());
            this.setFocusable(true);
        }

        @Override
        protected ListCellRenderer createListCellRenderer() {
            return new CustomListCellRenderer();
        }
    }
}

