/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VLabelValue
extends VBox {
    private static final String ROW_KEY = "VLabelValue.row";
    private static final String PROP_KEY = "VLabelValue.key";
    private Vector<VLabelValueRow> row = new Vector();
    private int nextRow = 0;
    private ActionListener changeListener = null;
    private boolean doubleRowDisplay = false;

    public VLabelValue(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.setInsets(0, 5, 0, 5);
        this.changeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object src = ae.getSource();
                if (src instanceof VBox) {
                    VLabelValueRow row = (VLabelValueRow)((VBox)src).getAttribute(VLabelValue.ROW_KEY, null);
                    if (row == null) {
                        Print.logWarn((String)("ROW is null: " + src), (Object[])new Object[0]);
                    } else if (!row.isReadOnly()) {
                        row.setChanged();
                        VLabelValue.this._changed(row);
                    }
                } else {
                    Print.logError((String)("Not a VBox! " + StringTools.className((Object)src)), (Object[])new Object[0]);
                }
            }
        };
    }

    public void setDoubleRowDisplay(boolean doubleRows) {
        this.doubleRowDisplay = doubleRows;
    }

    public VLabelValueRow addRow(String title, VBox comp) {
        return this.addRow(title, null, null, comp, null, null);
    }

    public VLabelValueRow addRow(String title, String desc, VBox comp) {
        return this.addRow(title, desc, null, comp, null, null);
    }

    public VLabelValueRow addRow(String title, VBox comp, Object rowData) {
        return this.addRow(this.createVLabelValueRow(title, null, null, comp, rowData, null));
    }

    public VLabelValueRow addRow(String title, VBox comp, String propKey) {
        return this.addRow(this.createVLabelValueRow(title, null, null, comp, null, propKey));
    }

    public VLabelValueRow addRow(String title, String desc, VBox comp, String propKey) {
        return this.addRow(this.createVLabelValueRow(title, desc, null, comp, null, propKey));
    }

    public VLabelValueRow addRow(String title, VBox comp, Object rowData, String propKey) {
        return this.addRow(this.createVLabelValueRow(title, null, null, comp, rowData, propKey));
    }

    public VLabelValueRow addRow(String title, String desc, VBox comp, Object rowData, String propKey) {
        return this.addRow(this.createVLabelValueRow(title, desc, null, comp, rowData, propKey));
    }

    public VLabelValueRow addRow(String title, String desc, String help, VBox comp, Object rowData, String propKey) {
        return this.addRow(this.createVLabelValueRow(title, desc, help, comp, rowData, propKey));
    }

    public VLabelValueRow addRow(VLabelValueRow row) {
        if (this.doubleRowDisplay) {
            VBox comp;
            String rowTitle = row.getTitle();
            String rowHelp = row.getHelp();
            int topMargin = StringTools.isBlank((String)rowTitle) ? 2 : 5;
            int botMargin = StringTools.isBlank((String)rowHelp) ? 2 : 5;
            int rowMargin = topMargin + botMargin;
            GridBagConstraints labelBoxGBC = VLabelValue.NewGBC();
            VBox labelValueBox = new VBox(null, null, false);
            VLabelValue.SetGBCX(labelBoxGBC, 0.5, 0, 2, 0, 0);
            VLabelValue.SetGBCY(labelBoxGBC, 0.0, this.nextRow, 1, 0, 0);
            labelBoxGBC.insets.top = this.nextRow > 0 ? rowMargin : rowMargin - 1;
            labelBoxGBC.insets.left = 0;
            labelBoxGBC.anchor = 18;
            this.add((Component)labelValueBox, labelBoxGBC);
            GridBagConstraints labelGBC = VLabelValue.NewGBC();
            VLabel label = new VLabel(rowTitle);
            VLabelValue.SetGBCX(labelGBC, 0.0, 0, 1, 0, 0);
            VLabelValue.SetGBCY(labelGBC, 0.0, 0, 1, 0, 0);
            labelGBC.anchor = 17;
            labelValueBox.add((Component)label, labelGBC);
            row.setLabel(label);
            GridBagConstraints fillerGBC = VLabelValue.NewGBC();
            VLabelValue.SetGBCX(fillerGBC, 0.5, 1, 1);
            VLabelValue.SetGBCY(fillerGBC, 0.0, 0, 1);
            labelValueBox.add((Component)new VFiller(), fillerGBC);
            if (this.isReadOnly() && !row.isReadOnly()) {
                row.setReadOnly(true);
            }
            if ((comp = row.getComponent()) != null) {
                VBox editor = null;
                String desc = row.getDescription();
                if (!StringTools.isBlank((String)desc)) {
                    VBox box = new VBox(null, null, false);
                    box.setGBCX(0.0, 0, 1);
                    box.setGBCY(0.0, 0, 1);
                    box.add((Component)comp, box.getDefaultGBC());
                    VLabel descLabel = new VLabel(desc);
                    descLabel.setPlainFont();
                    box.setGBCX(0.5, 1, 1, 5, 0);
                    box.setGBCY(0.0, 0, 1);
                    box.add((Component)descLabel, box.getDefaultGBC());
                    editor = box;
                } else {
                    editor = comp;
                }
                GridBagConstraints editGBC = VLabelValue.NewGBC();
                VLabelValue.SetGBCX(editGBC, 0.0, 0, 3, 20, 0);
                VLabelValue.SetGBCY(editGBC, 0.0, 1, 1, 0, 0);
                editGBC.anchor = 17;
                labelValueBox.add((Component)editor, editGBC);
                comp.setAttribute(ROW_KEY, row);
                comp.addActionListener(this.changeListener);
            }
            if (!StringTools.isBlank((String)rowHelp)) {
                VLabel helpLabel = new VLabel(rowHelp);
                Font helpFont = helpLabel.getFont();
                helpLabel.setFont(helpFont.deriveFont(helpFont.getSize2D() - 2.0f));
                GridBagConstraints helpGBC = VLabelValue.NewGBC();
                VLabelValue.SetGBCX(helpGBC, 0.0, 0, 3, 20, 0);
                VLabelValue.SetGBCY(helpGBC, 0.0, 2, 1, 0, 0);
                helpGBC.anchor = 17;
                labelValueBox.add((Component)helpLabel, helpGBC);
            }
        } else {
            VBox comp;
            int rowMargin = 3;
            GridBagConstraints labelGBC = VLabelValue.NewGBC();
            String rowTitle = row.getTitle();
            VLabel label = new VLabel(rowTitle);
            VLabelValue.SetGBCX(labelGBC, 0.0, 0, 1, 0, 0);
            VLabelValue.SetGBCY(labelGBC, 0.0, this.nextRow, 1, 0, 0);
            labelGBC.insets.top = this.nextRow > 0 ? rowMargin : rowMargin - 1;
            labelGBC.insets.left = 0;
            labelGBC.anchor = 12;
            this.add((Component)label, labelGBC);
            row.setLabel(label);
            if (this.isReadOnly() && !row.isReadOnly()) {
                row.setReadOnly(true);
            }
            if ((comp = row.getComponent()) != null) {
                VBox editor = null;
                String desc = row.getDescription();
                if (!StringTools.isBlank((String)desc)) {
                    VBox box = new VBox(null, null, false);
                    box.setGBCX(0.0, 0, 1);
                    box.setGBCY(0.0, 0, 1);
                    box.add((Component)comp, box.getDefaultGBC());
                    VLabel descLabel = new VLabel(desc);
                    descLabel.setPlainFont();
                    box.setGBCX(0.5, 1, 1, 5, 0);
                    box.setGBCY(0.0, 0, 1);
                    box.add((Component)descLabel, box.getDefaultGBC());
                    editor = box;
                } else {
                    editor = comp;
                }
                GridBagConstraints editGBC = VLabelValue.NewGBC();
                VLabelValue.SetGBCX(editGBC, 0.5, 1, 1, 0, 0);
                VLabelValue.SetGBCY(editGBC, 0.0, this.nextRow, 1, 0, 0);
                editGBC.insets.top = this.nextRow > 0 ? rowMargin : rowMargin - 1;
                editGBC.insets.left = 7;
                editGBC.anchor = 17;
                this.add((Component)editor, editGBC);
                comp.setAttribute(ROW_KEY, row);
                comp.addActionListener(this.changeListener);
            }
        }
        this.row.add(row);
        ++this.nextRow;
        return row;
    }

    public VLabel addLabel(String title, String labelText) {
        int rowMargin = this.doubleRowDisplay ? 12 : 3;
        GridBagConstraints labelGBC = VLabelValue.NewGBC();
        VLabel label = new VLabel(title);
        VLabelValue.SetGBCX(labelGBC, 0.0, 0, 1, 0, 0);
        VLabelValue.SetGBCY(labelGBC, 0.0, this.nextRow, 1, 0, 0);
        labelGBC.insets.top = this.nextRow > 0 ? rowMargin : rowMargin - 1;
        labelGBC.insets.left = 0;
        labelGBC.anchor = 12;
        this.add((Component)label, labelGBC);
        VLabel labelComp = null;
        if (labelText != null) {
            labelComp = new VLabel(labelText);
            GridBagConstraints editGBC = VLabelValue.NewGBC();
            VLabelValue.SetGBCX(editGBC, 0.5, 1, 1, 0, 0);
            VLabelValue.SetGBCY(editGBC, 0.0, this.nextRow, 1, 0, 0);
            editGBC.insets.top = this.nextRow > 0 ? rowMargin : rowMargin - 1;
            editGBC.insets.left = 7;
            editGBC.anchor = 17;
            this.add((Component)labelComp, editGBC);
        }
        ++this.nextRow;
        return labelComp;
    }

    public VSeparator addSeparator() {
        VSeparator sep = new VSeparator();
        this.setGBCX(0.5, 0, 2);
        this.setGBCY(0.0, this.nextRow, 1);
        this.getDefaultGBC().insets.top = this.nextRow > 0 ? (this.doubleRowDisplay ? 10 : 3) : 0;
        this.getDefaultGBC().insets.left = 0;
        this.getDefaultGBC().anchor = 10;
        this.add((Component)sep, this.getDefaultGBC());
        ++this.nextRow;
        return sep;
    }

    public JPanel addSpacer() {
        VFiller spacer = new VFiller();
        this.setGBCX(0.0, 0, 1);
        this.setGBCY(0.5, this.nextRow, 1);
        this.getDefaultGBC().insets.top = 0;
        this.getDefaultGBC().insets.left = 0;
        this.getDefaultGBC().anchor = 10;
        this.add((Component)spacer, this.getDefaultGBC());
        ++this.nextRow;
        return spacer;
    }

    private void _changed(VLabelValueRow row) {
        this.changed(row);
    }

    protected void changed(VLabelValueRow row) {
    }

    public boolean hasRowChanged(String key) {
        return this.hasRowChanged(this.getRowKeyIndex(key));
    }

    public boolean hasRowChanged(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        return row != null ? row.hasChanged() : false;
    }

    public boolean hasChanged() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.hasRowChanged(i)) continue;
            return true;
        }
        return false;
    }

    public void clearRowChanged(String key) {
        this.clearRowChanged(this.getRowKeyIndex(key));
    }

    public void clearRowChanged(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        if (row != null) {
            row.clearChanged();
        }
    }

    public void clearChanged() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.clearRowChanged(i);
        }
    }

    public int getRowCount() {
        return this.row != null ? this.row.size() : 0;
    }

    public VLabelValueRow getRow(String key) {
        return this.getRow(this.getRowKeyIndex(key));
    }

    public VLabelValueRow getRow(int ndx) {
        if (ndx >= 0 && ndx < this.row.size()) {
            return this.row.get(ndx);
        }
        return null;
    }

    public Map<String, VLabelValueRow> getRowMap() {
        HashMap<String, VLabelValueRow> map = new HashMap<String, VLabelValueRow>();
        for (VLabelValueRow r : this.row) {
            String k = r.getKey();
            if (k == null) {
                Object d = r.getData();
                if (d == null) continue;
                k = d.toString();
            }
            map.put(k, r);
        }
        return map;
    }

    public Map<String, VBox> getRowComponentMap() {
        HashMap<String, VBox> map = new HashMap<String, VBox>();
        for (VLabelValueRow r : this.row) {
            VBox c = r.getComponent();
            if (c == null) continue;
            String k = r.getKey();
            if (k == null) {
                Object d = r.getData();
                if (d == null) continue;
                k = d.toString();
            }
            map.put(k, c);
        }
        return map;
    }

    public Map<String, Object> getRowValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (VLabelValueRow r : this.row) {
            VBox c = r.getComponent();
            if (c == null) continue;
            String k = r.getKey();
            if (k == null) {
                Object d = r.getData();
                if (d == null) continue;
                k = d.toString();
            }
            map.put(k, c.getValue());
        }
        return map;
    }

    public void setRowEnabled(String key, boolean state) {
        this.setRowEnabled(this.getRowKeyIndex(key), state);
    }

    public void setRowEnabled(int row, boolean state) {
        VBox rowComp = this.getRowComponent(row);
        rowComp.setEnabled(state);
    }

    public boolean isRowEnabled(int row) {
        VBox rowComp = this.getRowComponent(row);
        return rowComp.isEnabled();
    }

    public void setRowReadOnly(String key, boolean state) {
        this.setRowReadOnly(this.getRowKeyIndex(key), state);
    }

    public void setRowReadOnly(int row, boolean state) {
        VBox rowComp = this.getRowComponent(row);
        rowComp.setReadOnly(state);
    }

    public boolean isRowReadOnly(String key) {
        return this.isRowReadOnly(this.getRowKeyIndex(key));
    }

    public boolean isRowReadOnly(int row) {
        VBox rowComp = this.getRowComponent(row);
        return rowComp.isReadOnly();
    }

    public VBox getRowComponent(String key) {
        return this.getRowComponent(this.getRowKeyIndex(key));
    }

    public VBox getRowComponent(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        return row != null ? row.getComponent() : null;
    }

    public Object getRowData(String key) {
        return this.getRowData(this.getRowKeyIndex(key));
    }

    public Object getRowData(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        return row != null ? row.getData() : null;
    }

    public void setRowData(int ndx, Object obj) {
        VLabelValueRow row = this.getRow(ndx);
        if (row != null) {
            row.setData(obj);
        }
    }

    public Object getRowValue(String key) {
        return this.getRowValue(this.getRowKeyIndex(key));
    }

    public int getRowValue(String key, int dft) {
        return StringTools.parseInt((Object)this.getRowValue(key), (int)dft);
    }

    public long getRowValue(String key, long dft) {
        return StringTools.parseLong((Object)this.getRowValue(key), (long)dft);
    }

    public double getRowValue(String key, double dft) {
        return StringTools.parseDouble((Object)this.getRowValue(key), (double)dft);
    }

    public void setRowValue(String key, Object val) {
        this.setRowValue(this.getRowKeyIndex(key), val);
    }

    public void setRowValue(String key, String val) {
        this.setRowValue(this.getRowKeyIndex(key), (Object)val);
    }

    public void setRowValue(String key, int val) {
        this.setRowValue(this.getRowKeyIndex(key), (Object)val);
    }

    public void setRowValue(String key, long val) {
        this.setRowValue(this.getRowKeyIndex(key), (Object)val);
    }

    public void setRowValue(String key, double val) {
        this.setRowValue(this.getRowKeyIndex(key), (Object)val);
    }

    public Object getRowValue(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        return row != null ? row.getValue() : null;
    }

    public int getRowValue(int ndx, int dft) {
        return StringTools.parseInt((Object)this.getRowValue(ndx), (int)dft);
    }

    public long getRowValue(int ndx, long dft) {
        return StringTools.parseLong((Object)this.getRowValue(ndx), (long)dft);
    }

    public double getRowValue(int ndx, double dft) {
        return StringTools.parseDouble((Object)this.getRowValue(ndx), (double)dft);
    }

    public void setRowValue(int ndx, Object val) {
        VLabelValueRow row = this.getRow(ndx);
        if (row != null) {
            row.setValue(val);
        }
    }

    public void setRowValue(int ndx, String val) {
        this.setRowValue(ndx, (Object)val);
    }

    public void setRowValue(int ndx, int val) {
        this.setRowValue(ndx, (Object)new Integer(val));
    }

    public void setRowValue(int ndx, long val) {
        this.setRowValue(ndx, (Object)new Long(val));
    }

    public void setRowValue(int ndx, double val) {
        this.setRowValue(ndx, (Object)new Double(val));
    }

    public void clearRowValue(String key) {
        this.clearRowValue(this.getRowKeyIndex(key));
    }

    public void clearRowValue(int ndx) {
        VLabelValueRow row = this.getRow(ndx);
        if (row != null) {
            row.setValue("");
        }
    }

    public void clearAllValues() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.clearRowValue(i);
        }
    }

    public int getRowDataIndex(Object rowData) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VLabelValueRow row = this.getRow(i);
            Object data = row.getData();
            if (data == rowData) {
                return i;
            }
            if (data == null || !data.equals(rowData)) continue;
            return i;
        }
        return -1;
    }

    public int getRowKeyIndex(String rowKey) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VLabelValueRow row = this.getRow(i);
            String key = row.getKey();
            if (key == null) {
                Object d = row.getData();
                if (d == null) continue;
                key = d.toString();
            }
            if (!key.equals(rowKey)) continue;
            return i;
        }
        return -1;
    }

    protected VLabelValueRow createVLabelValueRow(String title, String desc, String help, VBox comp, Object data, String key) {
        VLabelValueRow vrow = new VLabelValueRow(title, desc, help, comp, data, key);
        return vrow;
    }

    public static class VLabelValueRow {
        private String title = null;
        private String desc = null;
        private String help = null;
        private VBox comp = null;
        private JLabel label = null;
        private String prop = null;
        private Object data = null;
        private String key = null;
        private Object value = null;
        private boolean changed = false;

        public VLabelValueRow(String title, VBox comp, Object data) {
            this(title, null, null, comp, data, null);
        }

        public VLabelValueRow(String title, VBox comp, Object data, String key) {
            this(title, null, null, comp, data, key);
        }

        public VLabelValueRow(String title, String desc, VBox comp, Object data) {
            this(title, desc, null, comp, data, null);
        }

        public VLabelValueRow(String title, String desc, VBox comp, Object data, String key) {
            this(title, desc, null, comp, data, null);
        }

        public VLabelValueRow(String title, String desc, String help, VBox comp, Object data) {
            this(title, desc, help, comp, data, null);
        }

        public VLabelValueRow(String title, String desc, String help, VBox comp, Object data, String key) {
            this.title = title;
            this.desc = desc;
            this.help = help;
            this.comp = comp;
            this.data = data;
            this.key = key;
            this.value = null;
            this.changed = false;
            if (this.comp != null) {
                this.comp.setAttribute(VLabelValue.PROP_KEY, this.key);
            }
        }

        public void setTitle(String title) {
            this.title = title;
            this.label.setText(title);
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getHelp() {
            return this.help;
        }

        public void setToolTipText(String tooltip) {
            if (this.comp != null) {
                this.comp.setToolTipText(tooltip);
            }
            if (this.label != null) {
                this.label.setToolTipText(tooltip);
            }
        }

        public void setLabel(JLabel label) {
            this.label = label;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public VBox getComponent() {
            return this.comp;
        }

        public Object getValue() {
            if (this.comp != null) {
                return this.comp.getValue();
            }
            return null;
        }

        public void setValue(Object obj) {
            if (this.comp != null) {
                this.comp.setValue(obj);
                this.clearChanged();
            }
        }

        public void setChanged() {
            if (!this.changed) {
                Object v = this.getValue();
                if (this.value == null) {
                    if (v != null) {
                        this.changed = true;
                    }
                } else if (v == null) {
                    this.changed = true;
                } else if (!this.value.equals(v)) {
                    this.changed = true;
                }
            }
        }

        public boolean hasChanged() {
            return this.changed;
        }

        public void clearChanged() {
            this.value = this.getValue();
            this.changed = false;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object obj) {
            this.data = obj;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setReadOnly(boolean state) {
            if (this.comp != null) {
                this.comp.setReadOnly(state);
            }
        }

        public boolean isReadOnly() {
            return this.comp != null ? this.comp.isReadOnly() : true;
        }

        public void setVisible(boolean visible) {
            JLabel lbl = this.getLabel();
            VBox box = this.getComponent();
            if (lbl != null) {
                lbl.setVisible(visible);
            }
            if (box != null) {
                box.setVisible(visible);
            }
        }

        public String toString() {
            return this.title;
        }
    }
}

