/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VMenuBar;
import org.opengts.opt.ui.VSeparator;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VFrame
extends JFrame {
    private JPanel buttonBox = null;
    private JPanel buttonBoxFiller = null;
    private boolean buttonBoxDivider = true;
    private int buttonAnchor = 13;
    private boolean exitOnHide = false;
    private boolean isModal = false;
    private boolean modalBlock = false;
    private Map<String, Object> attributeMap = null;
    private static boolean SET_INVISIBLE_WHILE_RESIZING = true;
    private int isSettingBounds = 0;
    private WindowListener winListener = null;
    private ActionTarget winClosingAction = null;
    private int winInvokeLevel = 0;

    public VFrame(String title) {
        this(null, title, false);
    }

    public VFrame(Object owner, String title, boolean isModal) {
        super(title);
        this.setModal(isModal);
        this.initVFrame();
    }

    protected void initVFrame() {
        VBox content = new VBox(null, null, false);
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.0, -1, 1);
        content.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(content);
        this.initComponentListener();
        this.initWindowListener();
    }

    protected void initComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowMoved();
                }
            }

            @Override
            public void componentResized(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowResized();
                }
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
                Component c = ce.getComponent();
                if (c instanceof VFrame) {
                    ((VFrame)c).windowHidden();
                }
            }
        });
    }

    protected void windowMoved() {
    }

    protected void windowResized() {
    }

    protected void windowHidden() {
    }

    protected void initWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowOpened();
                }
            }

            @Override
            public void windowIconified(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowIconified();
                }
            }

            @Override
            public void windowDeiconified(WindowEvent we) {
                Window w = we.getWindow();
                if (w instanceof VFrame) {
                    ((VFrame)w).windowDeiconified();
                }
            }
        });
    }

    protected void windowOpened() {
    }

    protected void windowIconified() {
    }

    protected void windowDeiconified() {
    }

    public VBox getContentBox() {
        return (VBox)this.getContentPane();
    }

    public void addMenu(JMenu menu) {
        this.getVMenuBar().mergeAdd(menu);
    }

    public void addMenuSpace() {
        this.getVMenuBar().addFiller();
    }

    public VMenuBar getVMenuBar() {
        return (VMenuBar)this.getJMenuBar();
    }

    @Override
    public JMenuBar getJMenuBar() {
        VMenuBar menuBar = (VMenuBar)super.getJMenuBar();
        if (menuBar == null) {
            menuBar = new VMenuBar();
            this.setJMenuBar(menuBar);
        }
        return menuBar;
    }

    protected Container _getButtonBox() {
        if (this.buttonBox == null) {
            JPanel statusBox = this.getContentBox().getStatusArea();
            if (this.getDrawButtonDivider()) {
                GridBagConstraints sepGBC = VBox.NewGBC();
                VBox.SetGBCX(sepGBC, 0.5, 0, 1, 0, 0);
                VBox.SetGBCY(sepGBC, 0.0, 0, 1, 0, 0);
                statusBox.add((Component)new VSeparator(), sepGBC);
            }
            GridBagConstraints btnGBC = VBox.NewGBC();
            VBox.SetGBCX(btnGBC, 0.5, 0, 1, 0, 0);
            VBox.SetGBCY(btnGBC, 0.0, 1, 1, 0, 0);
            this.buttonBox = new JPanel(new GridBagLayout());
            this.buttonBox.setOpaque(false);
            statusBox.add((Component)this.buttonBox, btnGBC);
            this._addButtonFiller();
        }
        return this.buttonBox;
    }

    protected void _addButtonFiller() {
        if (this.buttonBoxFiller == null && this.buttonAnchor != 10) {
            int gridX = this.buttonAnchor == 17 ? 0 : -1;
            GridBagConstraints fillGBC = VBox.NewGBC();
            VBox.SetGBCX(fillGBC, 0.5, gridX, 1, 0, 0);
            VBox.SetGBCY(fillGBC, 0.0, 0, 1);
            fillGBC.fill = 2;
            this.buttonBoxFiller = new JPanel();
            this.buttonBoxFiller.setOpaque(false);
            this.buttonBox.add((Component)this.buttonBoxFiller, fillGBC);
        }
    }

    public void setDrawButtonDivider(boolean state) {
        this.buttonBoxDivider = state;
    }

    public boolean getDrawButtonDivider() {
        return this.buttonBoxDivider;
    }

    public void setButtonAnchor(int anchor) {
        this.buttonAnchor = anchor;
    }

    public void setButtonAnchorWest() {
        this.setButtonAnchor(17);
    }

    public void setButtonAnchorEast() {
        this.setButtonAnchor(13);
    }

    public void setButtonAnchorCenter() {
        this.setButtonAnchor(10);
    }

    public int getButtonAnchor() {
        return this.buttonAnchor;
    }

    public VButton addButton(VButton btn) {
        return this.addButton(btn, false);
    }

    public VButton addButton(VButton btn, boolean makeDefault) {
        GridBagConstraints gbc = VBox.NewGBC();
        VBox.SetGBCX(gbc, 0.0, -1, 1, 5, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        this._getButtonBox().add((Component)btn, gbc);
        if (makeDefault) {
            this.setDefaultButton(btn);
        }
        return btn;
    }

    public JButton addButton(JButton btn) {
        return this.addButton(btn, false);
    }

    public JButton addButton(JButton btn, boolean makeDefault) {
        GridBagConstraints gbc = VBox.NewGBC();
        VBox.SetGBCX(gbc, 0.0, -1, 1, 5, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        this._getButtonBox().add((Component)btn, gbc);
        if (makeDefault) {
            this.setDefaultButton(btn);
        }
        return btn;
    }

    public void addButtonSeparator() {
        this.addButtonSeparator(-1);
    }

    public void addButtonSeparator(int fixedWidth) {
        if (fixedWidth < 0 && this.buttonBoxFiller != null) {
            this._getButtonBox().remove(this.buttonBoxFiller);
            this.buttonBoxFiller = null;
        }
        ButtonSeparator sep = new ButtonSeparator(fixedWidth);
        GridBagConstraints gbc = VBox.NewGBC();
        double weightx = fixedWidth < 0 ? 0.5 : 0.0;
        VBox.SetGBCX(gbc, weightx, -1, 1, 0, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        gbc.fill = 2;
        this._getButtonBox().add((Component)sep, gbc);
    }

    public void setDefaultButton(VButton btn) {
        this.getRootPane().setDefaultButton(btn.getJButton());
    }

    public void setDefaultButton(JButton btn) {
        this.getRootPane().setDefaultButton(btn);
    }

    public JButton getDefaultButton() {
        return this.getRootPane().getDefaultButton();
    }

    public void setModal(boolean modal) {
        this.isModal = modal;
    }

    public boolean isModal() {
        return this.isModal;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Container container = this.getContentPane();
        if (container instanceof JPanel) {
            ((JPanel)container).setBackground(color);
            ((JPanel)container).setOpaque(true);
        }
    }

    public void centerOnScreen(Dimension winSize, Dimension offset) {
        if (winSize == null || winSize.width <= 0 || winSize.height <= 0) {
            int w = winSize != null ? winSize.width : -1;
            int h = winSize != null ? winSize.height : -1;
            this.pack();
            winSize = new Dimension(this.getPreferredSize());
            if (w > 0) {
                winSize.width = w;
            }
            if (h > 0) {
                winSize.height = h;
            }
        }
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (scr.width - winSize.width) / 2;
        int y = (scr.height - winSize.height) / 2;
        if (offset != null) {
            x += offset.width;
            y += offset.height;
        }
        this.setBounds(x, y, winSize.width, winSize.height);
    }

    public void centerOnScreen(Dimension winSize) {
        this.centerOnScreen(winSize, null);
    }

    public void centerOnScreen(int width, int height, int ofsWidth, int ofsHeight) {
        this.centerOnScreen(new Dimension(width, height), new Dimension(ofsWidth, ofsHeight));
    }

    public void centerOnScreen(int width, int height) {
        this.centerOnScreen(new Dimension(width, height), null);
    }

    public void centerOnScreen() {
        this.centerOnScreen(this.getSize(), null);
    }

    public boolean isSettingBounds() {
        return this.isSettingBounds > 0;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle r = this.getBounds();
        if (x != r.x || y != r.y || w != r.width || h != r.height) {
            ++this.isSettingBounds;
            boolean wasVisible = false;
            if (SET_INVISIBLE_WHILE_RESIZING && this.isVisible()) {
                Print.logDebug((String)"Setting window invisible before moving ...", (Object[])new Object[0]);
                wasVisible = true;
                this.setVisible(false);
            }
            super.setBounds(x, y, w, h);
            if (SET_INVISIBLE_WHILE_RESIZING && wasVisible) {
                this.setVisible(true);
            }
            --this.isSettingBounds;
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (!this.isSettingBounds()) {
            Print.logStackTrace((String)("Reshaping: " + x + "/" + y));
        }
        super.reshape(x, y, width, height);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void show() {
        if (this.isModal()) {
            this.showModal();
        } else {
            super.show();
        }
    }

    public void showModal() {
        super.show();
        this.modalBlock = true;
        while (this.modalBlock && this.processModalEvents()) {
        }
    }

    @Override
    public void hide() {
        this.modalBlock = false;
        super.hide();
        if (this.exitOnHide) {
            System.exit(0);
        }
    }

    @Override
    public void toFront() {
        if (OSTools.isBrokenToFront()) {
            this.setIconified(true);
        }
        this.setIconified(false);
        super.toFront();
    }

    private boolean processModalEvents() {
        try {
            AWTEvent event;
            boolean eventOK;
            EventQueue theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            do {
                event = theQueue.getNextEvent();
                eventOK = true;
                int eventID = event.getID();
                if ((eventID < 500 || eventID > 507) && (eventID < 1001 || eventID > 1001)) continue;
                Object src = event.getSource();
                if (src instanceof Component) {
                    Component c;
                    for (c = (Component)src; c != this && c != null; c = c.getParent()) {
                    }
                    if (c == this) continue;
                    eventOK = false;
                    this._consumeEvent(theQueue, event);
                    continue;
                }
                Print.logDebug((String)("Source: " + src), (Object[])new Object[0]);
            } while (!eventOK);
            this._dispatchEvent(theQueue, event);
            return true;
        }
        catch (InterruptedException ie) {
            return false;
        }
        catch (Throwable t) {
            Print.logException((String)"Processing Modal events", (Throwable)t);
            return true;
        }
    }

    private void _consumeEvent(EventQueue theQueue, AWTEvent event) {
        Print.logDebug((String)("Consume event: " + event), (Object[])new Object[0]);
    }

    private void _dispatchEvent(EventQueue theQueue, AWTEvent event) {
        Object src = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (src instanceof Component) {
            ((Component)src).dispatchEvent(event);
        } else if (src instanceof MenuComponent) {
            ((MenuComponent)src).dispatchEvent(event);
        } else {
            System.err.println("unable to dispatch event: " + event);
        }
    }

    public void setDoNothingOnClose() {
        this.setDefaultCloseOperation(0);
        this.exitOnHide = false;
    }

    public void setExitOnClose() {
        this.setDefaultCloseOperation(3);
        this.exitOnHide = true;
    }

    public void setActionOnClose(ActionListener al, String cmd) {
        this.setActionOnClose(new ActionTarget(al, cmd));
    }

    public void setActionOnClose(ActionTarget actTarg) {
        this.setDoNothingOnClose();
        this.winClosingAction = actTarg;
        if (this.winClosingAction != null && this.winListener == null) {
            this.winListener = new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent ae) {
                    if (VFrame.this.winClosingAction != null && VFrame.this.winInvokeLevel == 0) {
                        try {
                            VFrame.this.winInvokeLevel++;
                            VFrame.this.winClosingAction.invoke(VFrame.this);
                        }
                        finally {
                            VFrame.this.winInvokeLevel--;
                        }
                    }
                }
            };
            this.addWindowListener(this.winListener);
        }
    }

    public void setNormal() {
        this.setExtendedState(0);
    }

    public boolean isMaximized() {
        int extState = this.getExtendedState();
        return (extState & 6) != 0;
    }

    public boolean isIconified() {
        int extState = this.getExtendedState();
        return (extState & 1) != 0;
    }

    public void setIconified(boolean iconified) {
        this.setExtendedState(iconified ? 1 : 0);
    }

    @Override
    protected void processWindowEvent(WindowEvent we) {
        super.processWindowEvent(we);
    }

    private Map<String, Object> getAttrMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    public void setAttribute(String key, Object val) {
        if (key != null) {
            if (val != null) {
                this.getAttrMap().put(key, val);
            } else {
                this.getAttrMap().remove(key);
            }
        }
    }

    public Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public Object getAttribute(String key, Object dftValue) {
        if (key != null) {
            Object obj = this.getAttrMap().get(key);
            return obj != null ? obj : dftValue;
        }
        return dftValue;
    }

    public static void showTestComponent(Component c) {
        VFrame.showTestComponent(c, null);
    }

    public static void showTestComponent(Component c, JMenu m) {
        VFrame.showTestComponent(c, m, 400, 400);
    }

    public static void showTestComponent(Component c, int width, int height) {
        VFrame.showTestComponent(c, null, width, height);
    }

    public static void showTestComponent(Component c, JMenu m, int width, int height) {
        VFrame frame = new VFrame("Test Component");
        if (m != null) {
            frame.addMenu(m);
        }
        frame.centerOnScreen(width, height);
        frame.setExitOnClose();
        VBox container = frame.getContentBox();
        container.setGBCY(0.5, 0, 1);
        container.add(c, container.getDefaultGBC());
        frame.setVisible(true);
    }

    public static String setLookAndFeel(String laf) {
        try {
            if (StringTools.isBlank((String)laf)) {
                laf = OSTools.isMacOS() ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (laf.equalsIgnoreCase("system")) {
                laf = UIManager.getSystemLookAndFeelClassName();
            } else if (laf.equalsIgnoreCase("common") || laf.equalsIgnoreCase("cross")) {
                laf = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (laf.equalsIgnoreCase("metal")) {
                laf = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else if (laf.equalsIgnoreCase("mac")) {
                laf = "apple.laf.AquaLookAndFeel";
            }
            UIManager.setLookAndFeel(laf);
            return laf;
        }
        catch (Throwable th) {
            Print.logException((String)"Error setting Look&Feel ...", (Throwable)th);
            return null;
        }
    }

    public static void main(String[] argv) {
        SET_INVISIBLE_WHILE_RESIZING = false;
        VFrame frame = new VFrame("Test");
        frame.centerOnScreen(400, 400);
        frame.setExitOnClose();
        frame.setVisible(true);
        Point p = frame.getLocation();
        for (int i = 0; i < 10; ++i) {
            p = new Point(p.x + 10, p.y + 10);
            frame.setLocation(p);
        }
    }

    private class ButtonSeparator
    extends JPanel {
        private int fixedWidth = -1;

        public ButtonSeparator(int width) {
            this.fixedWidth = width;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension ps = super.getPreferredSize();
            if (this.fixedWidth < 0) {
                return ps;
            }
            return new Dimension(this.fixedWidth, ps.height);
        }
    }
}

