/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;

public class VFileFilter
extends FileFilter {
    private String shortDescription = null;
    private String longDescription = null;
    private OrderedSet<String> extnSet = null;
    private boolean showExtensions = true;

    public VFileFilter(String desc, String[] extn) {
        this.extnSet = (OrderedSet)ListTools.toSet((Object[])extn, (Set)new OrderedSet());
        this.setDescription(desc);
    }

    public void setDescription(String desc) {
        this.shortDescription = desc;
        this.longDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.longDescription == null) {
            StringBuffer sb = new StringBuffer();
            if (this.shortDescription != null && !this.shortDescription.equals("")) {
                sb.append(this.shortDescription);
            }
            if (this.getShowExtensions() && !this.extnSet.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("(");
                Iterator i = this.extnSet.iterator();
                while (i.hasNext()) {
                    sb.append(".").append((String)i.next());
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
            this.longDescription = sb.toString();
        }
        return this.longDescription;
    }

    public void setShowExtensions(boolean showExtn) {
        this.showExtensions = showExtn;
    }

    public boolean getShowExtensions() {
        return this.showExtensions;
    }

    public void addExtension(String extn) {
        if (extn != null) {
            if (extn.startsWith(".")) {
                extn = extn.substring(1);
            }
            if (!this.extnSet.contains((Object)extn) && !extn.equals("")) {
                this.extnSet.add((Object)extn);
                this.longDescription = null;
            }
        }
    }

    public void addExtensions(String[] extn) {
        if (extn != null) {
            for (int i = 0; i < extn.length; ++i) {
                this.addExtension(extn[i]);
            }
        }
    }

    public void removeExtension(String extn) {
        if (extn != null) {
            if (extn.startsWith(".")) {
                extn = extn.substring(1);
            }
            if (this.extnSet.contains((Object)extn)) {
                this.extnSet.remove((Object)extn);
                this.longDescription = null;
            }
        }
    }

    public void removeExtensions(String[] extn) {
        if (extn != null) {
            for (int i = 0; i < extn.length; ++i) {
                this.removeExtension(extn[i]);
            }
        }
    }

    public boolean containsExtension(String extn) {
        if (extn != null) {
            if (extn.startsWith(".")) {
                extn = extn.substring(1);
            }
            return this.extnSet.contains((Object)extn);
        }
        return false;
    }

    public int getExtensionCount() {
        return this.extnSet.size();
    }

    public String getExtension(int ndx) {
        if (ndx >= 0 && ndx < this.extnSet.size()) {
            return (String)this.extnSet.get(ndx);
        }
        return null;
    }

    @Override
    public boolean accept(File f) {
        try {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                String extn = FileTools.getExtension((String)f.getName()).toLowerCase();
                return this.extnSet.contains((Object)extn);
            }
            return false;
        }
        catch (Throwable th) {
            Print.logWarn((String)("Trapped Exception ... ignoring ... [" + th + "]"), (Object[])new Object[0]);
            return false;
        }
    }
}

