/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VMenuBar;
import org.opengts.opt.ui.VSeparator;
import org.opengts.util.OSTools;
import org.opengts.util.Print;

public class VDialog
extends JDialog {
    private JPanel buttonBox = null;
    private JPanel buttonBoxFiller = null;
    private boolean buttonBoxDivider = true;
    private int buttonAnchor = 13;
    private boolean exitOnHide = false;
    private Map<String, Object> attributeMap = null;
    private int isSettingBounds = 0;
    private WindowListener winListener = null;
    private ActionTarget winClosingAction = null;
    private int winInvokeLevel = 0;

    public VDialog(String title) {
        super((Frame)null, title, false);
        this.initVDialog();
    }

    public VDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initVDialog();
    }

    public VDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initVDialog();
    }

    protected void initVDialog() {
        VBox content = new VBox(null, null, false);
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.0, -1, 1);
        content.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(content);
    }

    public VBox getContentBox() {
        return (VBox)this.getContentPane();
    }

    public void addMenu(JMenu menu) {
        this.getVMenuBar().mergeAdd(menu);
    }

    public VMenuBar getVMenuBar() {
        JMenuBar jmb = this.getJMenuBar();
        if (jmb instanceof VMenuBar) {
            return (VMenuBar)jmb;
        }
        Print.logError((String)"MenuBar is not an instance of VMenuBar!", (Object[])new Object[0]);
        return null;
    }

    @Override
    public JMenuBar getJMenuBar() {
        JMenuBar menuBar = super.getJMenuBar();
        if (menuBar == null) {
            menuBar = new VMenuBar();
            this.setJMenuBar(menuBar);
        }
        return menuBar;
    }

    protected Container _getButtonBox() {
        if (this.buttonBox == null) {
            JPanel statusBox = this.getContentBox().getStatusArea();
            if (this.getDrawButtonDivider()) {
                GridBagConstraints sepGBC = VBox.NewGBC();
                VBox.SetGBCX(sepGBC, 0.5, 0, 1, 0, 0);
                VBox.SetGBCY(sepGBC, 0.0, 0, 1, 0, 0);
                statusBox.add((Component)new VSeparator(), sepGBC);
            }
            GridBagConstraints btnGBC = VBox.NewGBC();
            VBox.SetGBCX(btnGBC, 0.5, 0, 1, 0, 0);
            VBox.SetGBCY(btnGBC, 0.0, 1, 1, 0, 0);
            this.buttonBox = new JPanel(new GridBagLayout());
            this.buttonBox.setOpaque(false);
            statusBox.add((Component)this.buttonBox, btnGBC);
            this._addButtonFiller();
        }
        return this.buttonBox;
    }

    protected void _addButtonFiller() {
        if (this.buttonBoxFiller == null && this.buttonAnchor != 10) {
            int gridX = this.buttonAnchor == 17 ? 0 : -1;
            GridBagConstraints fillGBC = VBox.NewGBC();
            VBox.SetGBCX(fillGBC, 0.5, gridX, 1, 0, 0);
            VBox.SetGBCY(fillGBC, 0.0, 0, 1);
            fillGBC.fill = 2;
            this.buttonBoxFiller = new JPanel();
            this.buttonBoxFiller.setOpaque(false);
            this.buttonBox.add((Component)this.buttonBoxFiller, fillGBC);
        }
    }

    public void setDrawButtonDivider(boolean state) {
        this.buttonBoxDivider = state;
    }

    public boolean getDrawButtonDivider() {
        return this.buttonBoxDivider;
    }

    public void setButtonAnchor(int anchor) {
        this.buttonAnchor = anchor;
    }

    public void setButtonAnchorWest() {
        this.setButtonAnchor(17);
    }

    public void setButtonAnchorEast() {
        this.setButtonAnchor(13);
    }

    public void setButtonAnchorCenter() {
        this.setButtonAnchor(10);
    }

    public int getButtonAnchor() {
        return this.buttonAnchor;
    }

    public VButton addButton(VButton btn) {
        return this.addButton(btn, false);
    }

    protected VButton addButton(VButton btn, boolean makeDefault) {
        GridBagConstraints gbc = VBox.NewGBC();
        VBox.SetGBCX(gbc, 0.0, -1, 1, 5, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        this._getButtonBox().add((Component)btn, gbc);
        if (makeDefault) {
            this.setDefaultButton(btn);
        }
        return btn;
    }

    public JButton addButton(JButton btn) {
        return this.addButton(btn, false);
    }

    protected JButton addButton(JButton btn, boolean makeDefault) {
        GridBagConstraints gbc = VBox.NewGBC();
        VBox.SetGBCX(gbc, 0.0, -1, 1, 5, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        this._getButtonBox().add((Component)btn, gbc);
        if (makeDefault) {
            this.setDefaultButton(btn);
        }
        return btn;
    }

    public void addButtonSeparator() {
        this.addButtonSeparator(-1);
    }

    public void addButtonSeparator(int fixedWidth) {
        if (fixedWidth < 0 && this.buttonBoxFiller != null) {
            this._getButtonBox().remove(this.buttonBoxFiller);
            this.buttonBoxFiller = null;
        }
        ButtonSeparator sep = new ButtonSeparator(fixedWidth);
        GridBagConstraints gbc = VBox.NewGBC();
        double weightx = fixedWidth < 0 ? 0.5 : 0.0;
        VBox.SetGBCX(gbc, weightx, -1, 1, 0, 0);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        gbc.anchor = this.getButtonAnchor();
        gbc.fill = 2;
        this._getButtonBox().add((Component)sep, gbc);
    }

    public void setDefaultButton(VButton btn) {
        this.getRootPane().setDefaultButton(btn.getJButton());
    }

    public void setDefaultButton(JButton btn) {
        this.getRootPane().setDefaultButton(btn);
    }

    public JButton getDefaultButton() {
        return this.getRootPane().getDefaultButton();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        Container container = this.getContentPane();
        if (container instanceof JPanel) {
            ((JPanel)container).setBackground(color);
            ((JPanel)container).setOpaque(true);
        }
    }

    public void centerOnScreen(Dimension winSize) {
        if (winSize == null || winSize.width <= 0 || winSize.height <= 0) {
            int w = winSize != null ? winSize.width : -1;
            int h = winSize != null ? winSize.height : -1;
            this.pack();
            winSize = new Dimension(this.getPreferredSize());
            if (w > 0) {
                winSize.width = w;
            }
            if (h > 0) {
                winSize.height = h;
            }
        }
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (scr.width - winSize.width) / 2;
        int y = (scr.height - winSize.height) / 2;
        this.setBounds(x, y, winSize.width, winSize.height);
    }

    public void centerOnScreen(int width, int height) {
        this.centerOnScreen(new Dimension(width, height));
    }

    public void centerOnScreen() {
        this.centerOnScreen(this.getSize());
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
    }

    public boolean isSettingBounds() {
        return this.isSettingBounds > 0;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle r = this.getBounds();
        if (x != r.x || y != r.y || w != r.width || h != r.height) {
            boolean wasVisible = false;
            if (this.isVisible()) {
                wasVisible = true;
                ++this.isSettingBounds;
                this.setVisible(false);
            }
            super.setBounds(x, y, w, h);
            if (wasVisible) {
                this.setVisible(true);
                --this.isSettingBounds;
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void hide() {
        super.hide();
        if (this.exitOnHide) {
            System.exit(0);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.exitOnHide) {
            System.exit(0);
        }
    }

    @Override
    public void toFront() {
        if (OSTools.isBrokenToFront()) {
            this.setVisible(false);
        }
        this.setVisible(true);
        super.toFront();
    }

    public void setDoNothingOnClose() {
        this.setDefaultCloseOperation(0);
        this.exitOnHide = false;
    }

    public void setExitOnClose() {
        this.exitOnHide = true;
    }

    public void setActionOnClose(ActionListener al, String cmd) {
        this.setActionOnClose(new ActionTarget(al, cmd));
    }

    public void setActionOnClose(ActionTarget actTarg) {
        this.setDoNothingOnClose();
        this.winClosingAction = actTarg;
        if (this.winClosingAction != null && this.winListener == null) {
            this.winListener = new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosing(WindowEvent ae) {
                    if (VDialog.this.winClosingAction != null && VDialog.this.winInvokeLevel == 0) {
                        try {
                            VDialog.this.winInvokeLevel++;
                            VDialog.this.winClosingAction.invoke(VDialog.this);
                        }
                        finally {
                            VDialog.this.winInvokeLevel--;
                        }
                    }
                }
            };
            this.addWindowListener(this.winListener);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent we) {
        super.processWindowEvent(we);
    }

    private Map<String, Object> getAttrMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    public void setAttribute(String key, Object val) {
        if (key != null) {
            if (val != null) {
                this.getAttrMap().put(key, val);
            } else {
                this.getAttrMap().remove(key);
            }
        }
    }

    public Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public Object getAttribute(String key, Object dftValue) {
        if (key != null) {
            Object obj = this.getAttrMap().get(key);
            return obj != null ? obj : dftValue;
        }
        return dftValue;
    }

    public static void showTestComponent(Component c) {
        VDialog.showTestComponent(c, null);
    }

    public static void showTestComponent(Component c, JMenu m) {
        VDialog.showTestComponent(c, m, 400, 400);
    }

    public static void showTestComponent(Component c, int width, int height) {
        VDialog.showTestComponent(c, null, width, height);
    }

    public static void showTestComponent(Component c, JMenu m, int width, int height) {
        VDialog dialog = new VDialog((Frame)null, "Test Component", true);
        if (m != null) {
            dialog.addMenu(m);
        }
        dialog.centerOnScreen(width, height);
        dialog.setExitOnClose();
        VBox container = dialog.getContentBox();
        container.setGBCY(0.5, 0, 1);
        container.add(c, container.getDefaultGBC());
        dialog.setVisible(true);
    }

    private class ButtonSeparator
    extends JPanel {
        private int fixedWidth = -1;

        public ButtonSeparator(int width) {
            this.fixedWidth = width;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension ps = super.getPreferredSize();
            if (this.fixedWidth < 0) {
                return ps;
            }
            return new Dimension(this.fixedWidth, ps.height);
        }
    }
}

