/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VPopupMenu;
import org.opengts.opt.ui.VPopupMenuProvider;

public class VContextMenu
extends MouseAdapter {
    public static final String POPUP_LISTENER = "VContextMenu.PopupListener";
    private JComponent component = null;
    private JPopupMenu popupMenu = null;
    private VPopupMenuProvider popupProvider = null;
    private PopupValidator validator = null;

    public static VContextMenu setContextMenu(JComponent comp, JPopupMenu popup) {
        VContextMenu cm = new VContextMenu(comp, popup);
        comp.putClientProperty(POPUP_LISTENER, cm);
        return cm;
    }

    public static VContextMenu setContextMenu(JComponent comp, VPopupMenuProvider popupProv) {
        VContextMenu cm = new VContextMenu(comp, popupProv);
        comp.putClientProperty(POPUP_LISTENER, cm);
        return cm;
    }

    public static VContextMenu getContextMenu(JComponent comp) {
        Object obj = comp.getClientProperty(POPUP_LISTENER);
        return obj instanceof VContextMenu ? (VContextMenu)obj : null;
    }

    public static JPopupMenu getPopupMenu(JComponent comp) {
        VContextMenu cm = VContextMenu.getContextMenu(comp);
        return cm != null ? cm.getPopupMenu() : null;
    }

    public VContextMenu(JComponent comp, JPopupMenu popup) {
        this.component = comp;
        this.popupMenu = popup;
        this.component.addMouseListener(this);
    }

    public VContextMenu(JComponent comp, VPopupMenuProvider popupProv) {
        this.component = comp;
        this.popupProvider = popupProv;
        this.component.addMouseListener(this);
    }

    public void setPopupValidator(PopupValidator validator) {
        this.validator = validator;
    }

    public PopupValidator getPopupValidator() {
        return this.validator;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu != null) {
            return this.popupMenu;
        }
        if (this.popupProvider != null) {
            return this.popupProvider.getPopupMenu();
        }
        return null;
    }

    private void showPopup(MouseEvent me) {
        if (me.isPopupTrigger() && (this.validator == null || this.validator.validatePopupMenu(this, me))) {
            Component c = me.getComponent();
            if (c instanceof VBox) {
                ((VBox)c).selectItemAt(me.getPoint());
            } else if (c instanceof JList) {
                JList jlist = (JList)c;
                int ndx = jlist.locationToIndex(me.getPoint());
                jlist.setSelectedIndex(ndx);
            } else if (c instanceof JTree) {
                Object node;
                JTree jtree = (JTree)c;
                TreePath selPath = jtree.getPathForLocation(me.getX(), me.getY());
                Object object = node = selPath != null ? selPath.getLastPathComponent() : null;
                if (node instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
                    jtree.setSelectionPath(new TreePath(dmtn.getPath()));
                }
            } else if (c instanceof JTable) {
                JTable jtable = (JTable)c;
                int ndx = jtable.rowAtPoint(me.getPoint());
                if (!jtable.isRowSelected(ndx)) {
                    jtable.setRowSelectionInterval(ndx, ndx);
                }
            } else if (c instanceof JTabbedPane) {
                JTabbedPane jtabbedpane = (JTabbedPane)c;
                int ndx = jtabbedpane.indexAtLocation(me.getX(), me.getY());
                if (ndx < 0) {
                    return;
                }
                jtabbedpane.setSelectedIndex(ndx);
            }
            JPopupMenu popup = this.getPopupMenu();
            if (popup != null) {
                popup.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.showPopup(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.showPopup(me);
    }

    public void setActionEnabled(String ac, boolean enable) {
        VPopupMenu.setActionEnabled(this.getPopupMenu(), ac, enable);
    }

    public static interface PopupValidator {
        public boolean validatePopupMenu(VContextMenu var1, MouseEvent var2);
    }
}

