/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.lantrix;

import java.net.BindException;
import java.net.DatagramSocket;
import java.util.List;
import java.util.Vector;
import org.opengts.db.DCServerConfig;
import org.opengts.servers.lantrix.Constants;
import org.opengts.servers.lantrix.Main;
import org.opengts.servers.lantrix.TrackClientPacketHandler;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;

public class TrackServer {
    private static TrackServer trackServerInstance = null;
    private static long tcpTimeout_idle = 20000L;
    private static long tcpTimeout_packet = 4000L;
    private static long tcpTimeout_session = 60000L;
    private static long udpTimeout_idle = 5000L;
    private static long udpTimeout_packet = 4000L;
    private static long udpTimeout_session = 60000L;
    private List<ServerSocketThread> tcpThread = new Vector<ServerSocketThread>();
    private List<ServerSocketThread> udpThread = new Vector<ServerSocketThread>();
    private ServerSocketThread cmdThread = null;
    private DatagramSocket udpSocket = null;

    public static void configInit() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            TrackServer.setTcpIdleTimeout(dcs.getTcpIdleTimeoutMS(20000L));
            TrackServer.setTcpPacketTimeout(dcs.getTcpPacketTimeoutMS(4000L));
            TrackServer.setTcpSessionTimeout(dcs.getTcpSessionTimeoutMS(60000L));
            TrackServer.setUdpIdleTimeout(dcs.getUdpIdleTimeoutMS(5000L));
            TrackServer.setUdpPacketTimeout(dcs.getUdpPacketTimeoutMS(4000L));
            TrackServer.setUdpSessionTimeout(dcs.getUdpSessionTimeoutMS(60000L));
        }
    }

    public static TrackServer startTrackServer(int[] tcpPorts, int[] udpPorts, int commandPort) throws Throwable {
        if (trackServerInstance == null) {
            trackServerInstance = new TrackServer(tcpPorts, udpPorts, commandPort);
        }
        return trackServerInstance;
    }

    public static TrackServer getTrackServer() {
        return trackServerInstance;
    }

    public static void setTcpIdleTimeout(long timeout) {
        tcpTimeout_idle = timeout;
    }

    public static long getTcpIdleTimeout() {
        return tcpTimeout_idle;
    }

    public static void setTcpPacketTimeout(long timeout) {
        tcpTimeout_packet = timeout;
    }

    public static long getTcpPacketTimeout() {
        return tcpTimeout_packet;
    }

    public static void setTcpSessionTimeout(long timeout) {
        tcpTimeout_session = timeout;
    }

    public static long getTcpSessionTimeout() {
        return tcpTimeout_session;
    }

    public static void setUdpIdleTimeout(long timeout) {
        udpTimeout_idle = timeout;
    }

    public static long getUdpIdleTimeout() {
        return udpTimeout_idle;
    }

    public static void setUdpPacketTimeout(long timeout) {
        udpTimeout_packet = timeout;
    }

    public static long getUdpPacketTimeout() {
        return udpTimeout_packet;
    }

    public static void setUdpSessionTimeout(long timeout) {
        udpTimeout_session = timeout;
    }

    public static long getUdpSessionTimeout() {
        return udpTimeout_session;
    }

    private TrackServer(int[] tcpPorts, int[] udpPorts, int commandPort) throws Throwable {
        int port;
        int i;
        int listeners = 0;
        if (!ListTools.isEmpty(tcpPorts)) {
            for (i = 0; i < tcpPorts.length; ++i) {
                port = tcpPorts[i];
                if (ServerSocketThread.isValidPort(port)) {
                    try {
                        this._startTCP(port);
                        ++listeners;
                    }
                    catch (BindException be) {
                        Print.logError("TCP: Error binding to port: %d", port);
                    }
                    continue;
                }
                throw new Exception("TCP: Invalid port number: " + port);
            }
        }
        if (!ListTools.isEmpty(udpPorts)) {
            for (i = 0; i < udpPorts.length; ++i) {
                port = udpPorts[i];
                if (ServerSocketThread.isValidPort(port)) {
                    try {
                        ServerSocketThread sst = this._startUDP(port);
                        if (this.udpSocket == null) {
                            this.udpSocket = sst.getDatagramSocket();
                        }
                        ++listeners;
                    }
                    catch (BindException be) {
                        Print.logError("UDP: Error binding to port: %d", port);
                    }
                    continue;
                }
                throw new Exception("UDP: Invalid port number: " + port);
            }
        }
        if (listeners <= 0) {
            Print.logWarn("No active device communication listeners!", new Object[0]);
        }
    }

    private void _startTCP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(port);
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(false);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        sst.setIgnoreChar(Constants.ASCII_IGNORE_CHARS);
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(tcpTimeout_idle);
        sst.setPacketTimeout(tcpTimeout_packet);
        sst.setSessionTimeout(tcpTimeout_session);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        sst.setLingerTimeoutSec(2);
        Print.logInfo("Starting TCP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ...", new Object[0]);
        sst.start();
        this.tcpThread.add(sst);
    }

    private ServerSocketThread _startUDP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(ServerSocketThread.createDatagramSocket(port));
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(false);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        sst.setIgnoreChar(Constants.ASCII_IGNORE_CHARS);
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(udpTimeout_idle);
        sst.setPacketTimeout(udpTimeout_packet);
        sst.setSessionTimeout(udpTimeout_session);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        Print.logInfo("Starting UDP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ...", new Object[0]);
        sst.start();
        this.udpThread.add(sst);
        return sst;
    }

    public DatagramSocket getUdpDatagramSocket() {
        return this.udpSocket;
    }
}

