/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.lantrix;

import java.net.InetAddress;
import java.util.List;
import java.util.TimeZone;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.lantrix.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static boolean DEBUG_MODE = false;
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = false;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean PACKET_LEN_END_OF_STREAM = false;
    private static final TimeZone gmtTimezone = DateTime.getGMTTimeZone();
    private String ipAddress = null;
    private int clientPort = 0;
    private int eventTotalCount = 0;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (PACKET_LEN_END_OF_STREAM) {
            return -2;
        }
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (ListTools.isEmpty(pktBytes)) {
            Print.logWarn("Ignoring empty/null packet", new Object[0]);
        } else if (pktBytes.length < 2) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
        } else {
            String s = StringTools.toStringValue(pktBytes).trim();
            Print.logInfo("Recv: " + s, new Object[0]);
            Print.logInfo("Hex: 0x" + StringTools.toHexString(pktBytes), new Object[0]);
            return this.parseInsertRecord_lantrix(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseInsertRecord_lantrix(String s) {
        List<Device.GeozoneTransition> zone;
        double KPH;
        if (StringTools.isBlank(s)) {
            Print.logError("String is null/blank", new Object[0]);
            return null;
        }
        if (s.length() < 5) {
            Print.logError("String is invalid length", new Object[0]);
            return null;
        }
        if (!s.startsWith(">")) {
            Print.logError("String does not start with '>'", new Object[0]);
            return null;
        }
        int se = s.endsWith("<") ? s.length() - 1 : s.length();
        String[] T = StringTools.split(s = s.substring(1, se), ';');
        if (T[0].length() < 33) {
            Print.logError("Invalid 'RPG' data length", new Object[0]);
            return null;
        }
        String mobileID = null;
        for (int i = 1; i < T.length; ++i) {
            if (!T[i].startsWith("ID=")) continue;
            mobileID = T[i].substring(3);
            break;
        }
        String Sentence_number = null;
        for (int j = 1; j < T.length; ++j) {
            if (!T[j].startsWith("#")) continue;
            Sentence_number = T[j].substring(1);
            break;
        }
        String tracker_ID = mobileID;
        String frame_data_checksum = null;
        frame_data_checksum = ">ACK;ID=" + tracker_ID + ";#" + Sentence_number + ";*";
        String chksum = TrackClientPacketHandler.getCheckSum(frame_data_checksum);
        String frame_data_ACK = null;
        frame_data_ACK = frame_data_checksum + chksum + "<\r\n";
        long dmy = StringTools.parseLong(T[0].substring(3, 9), 0L);
        long hms = StringTools.parseLong(T[0].substring(9, 15), 0L);
        long fixtime = this._getUTCSeconds(dmy, hms);
        double latitude = (double)StringTools.parseLong(T[0].substring(15, 23), 0L) / 100000.0;
        double longitude = (double)StringTools.parseLong(T[0].substring(23, 32), 0L) / 100000.0;
        double speedKPH = KPH = StringTools.parseDouble(T[0].substring(32, 35), 0.0);
        double headingDeg = StringTools.parseDouble(T[0].substring(35, 38), 0.0);
        int age_data = Integer.parseInt(T[0].substring(39, 41), 16);
        String decimal = Integer.toString(age_data);
        long inout = Long.parseLong(T[0].substring(41, 43), 16);
        String binary_io = Long.toBinaryString(inout);
        String srcStr = T[0].substring(38, 39);
        String ageStr = decimal;
        double altitudeM = 0.0;
        double odomKM = 0.0;
        long gpioInput = 0L;
        int statusCode = 61472;
        gpioInput = inout;
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date.", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        boolean validGPS = true;
        if (!GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid lat/lon: " + latitude + "/" + longitude, new Object[0]);
            validGPS = false;
            latitude = 0.0;
            longitude = 0.0;
            speedKPH = 0.0;
            headingDeg = 0.0;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        Print.logInfo("MobileID  : " + mobileID, new Object[0]);
        Print.logInfo("Sentence  : " + Sentence_number, new Object[0]);
        Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GeoPoint  : " + geoPoint, new Object[0]);
        Print.logInfo("Speed km/h: " + speedKPH + " [" + headingDeg + "]", new Object[0]);
        if (StringTools.isBlank(mobileID)) {
            Print.logError("Missing MobileID", new Object[0]);
            return null;
        }
        String accountID = "";
        String deviceID = "";
        String uniqueID = "";
        Device device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), mobileID);
        if (device == null) {
            return null;
        }
        accountID = device.getAccountID();
        deviceID = device.getDeviceID();
        uniqueID = device.getUniqueID();
        Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        DataTransport dataXPort = device.getDataTransport();
        if (this.ipAddress != null && !dataXPort.isValidIPAddress(this.ipAddress)) {
            DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.ipAddress + " [expecting " + validIPAddr + "]", new Object[0]);
            return null;
        }
        dataXPort.setIpAddressCurrent(this.ipAddress);
        dataXPort.setRemotePortCurrent(this.clientPort);
        dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!dataXPort.getDeviceCode().equalsIgnoreCase("lantrix")) {
            dataXPort.setDeviceCode("lantrix");
        }
        if (!validGPS && statusCode == 61472) {
            Print.logWarn("Ignoring event with invalid latitude/longitude", new Object[0]);
            return null;
        }
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM);
        Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
        if (SIMEVENT_GEOZONES && validGPS && (zone = device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                this.insertEventRecord(device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
                Print.logInfo("Geozone    : " + z, new Object[0]);
                if (z.getStatusCode() != statusCode) continue;
                Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(statusCode), new Object[0]);
                statusCode = -1;
            }
        }
        if (statusCode != 0) {
            if (statusCode != 61472 || !validGPS) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
            } else if (!device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                if (statusCode == 61472 && speedKPH > 0.0) {
                    statusCode = 61714;
                }
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
            }
        }
        try {
            device.updateChangedEventFields();
        }
        catch (DBException dbe) {
            Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
        }
        Print.logInfo("ACK: " + frame_data_ACK, new Object[0]);
        return frame_data_ACK.getBytes();
    }

    private long _getUTCSeconds(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    private static String getCheckSum(String msg) {
        int y = 0;
        String chk = null;
        for (int x = 0; x < msg.length() - 1 && msg.charAt(x) != '*'; ++x) {
            y = (byte)(y ^ msg.charAt(x) & 0x7F);
        }
        chk = Integer.toHexString(y).toUpperCase();
        if (chk.length() == 1) {
            chk = "0" + chk;
        }
        return chk;
    }

    private EventData createEventRecord(Device device, long fixtime, int statusCode, GeoPoint geoPoint, long gpioInput, double speedKPH, double heading, double altitude, double odomKM) {
        String accountID = device != null ? device.getAccountID() : "";
        String deviceID = device != null ? device.getDeviceID() : "";
        EventData.Key evKey = new EventData.Key(accountID, deviceID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeoPoint(geoPoint);
        evdb.setInputMask(gpioInput);
        evdb.setHeading(heading);
        evdb.setSpeedKPH(speedKPH);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        return evdb;
    }

    private void insertEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpioInput, double speedKPH, double heading, double altitude, double odomKM) {
        EventData evdb = this.createEventRecord(device, fixtime, statusCode, geoPoint, gpioInput, speedKPH, heading, altitude, odomKM);
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (device != null) {
            device.insertEventData(evdb);
        }
        ++this.eventTotalCount;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            PACKET_LEN_END_OF_STREAM = dcsc.getBooleanProperty("lantrix.packetLenEndOfStream", PACKET_LEN_END_OF_STREAM);
        }
    }
}

