/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.dct;

import java.net.BindException;
import java.net.DatagramSocket;
import org.opengts.db.DCServerConfig;
import org.opengts.servers.dct.Constants;
import org.opengts.servers.dct.Main;
import org.opengts.servers.dct.TrackClientPacketHandler;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;

public class TrackServer {
    private static TrackServer trackServerInstance = null;
    private static long tcpTimeout_idle = 10000L;
    private static long tcpTimeout_packet = 4000L;
    private static long tcpTimeout_session = 300000L;
    private static long udpTimeout_idle = 5000L;
    private static long udpTimeout_packet = 4000L;
    private static long udpTimeout_session = 60000L;
    private OrderedMap<Integer, ServerSocketThread> tcpThread = null;
    private OrderedMap<Integer, ServerSocketThread> udpThread = null;
    private OrderedMap<Integer, DatagramSocket> udpSocket = null;
    private ServerSocketThread cmdThread = null;

    public static void configInit() {
        DCServerConfig dcs = Main.getServerConfig(null);
        if (dcs != null) {
            TrackServer.setTcpIdleTimeout(dcs.getTcpIdleTimeoutMS(10000L));
            TrackServer.setTcpPacketTimeout(dcs.getTcpPacketTimeoutMS(4000L));
            TrackServer.setTcpSessionTimeout(dcs.getTcpSessionTimeoutMS(300000L));
            TrackServer.setUdpIdleTimeout(dcs.getUdpIdleTimeoutMS(5000L));
            TrackServer.setUdpPacketTimeout(dcs.getUdpPacketTimeoutMS(4000L));
            TrackServer.setUdpSessionTimeout(dcs.getUdpSessionTimeoutMS(60000L));
        } else {
            Print.logWarn("DCServer not found: " + Main.getServerName(), new Object[0]);
        }
    }

    public static TrackServer startTrackServer(int[] tcpPorts, int[] udpPorts, int commandPort) throws Throwable {
        if (trackServerInstance == null) {
            trackServerInstance = new TrackServer(tcpPorts, udpPorts, commandPort);
        }
        return trackServerInstance;
    }

    public static TrackServer getInstance() {
        return trackServerInstance;
    }

    public static void setTcpIdleTimeout(long timeout) {
        tcpTimeout_idle = timeout;
    }

    public static long getTcpIdleTimeout() {
        return tcpTimeout_idle;
    }

    public static void setTcpPacketTimeout(long timeout) {
        tcpTimeout_packet = timeout;
    }

    public static long getTcpPacketTimeout() {
        return tcpTimeout_packet;
    }

    public static void setTcpSessionTimeout(long timeout) {
        tcpTimeout_session = timeout;
    }

    public static long getTcpSessionTimeout() {
        return tcpTimeout_session;
    }

    public static void setUdpIdleTimeout(long timeout) {
        udpTimeout_idle = timeout;
    }

    public static long getUdpIdleTimeout() {
        return udpTimeout_idle;
    }

    public static void setUdpPacketTimeout(long timeout) {
        udpTimeout_packet = timeout;
    }

    public static long getUdpPacketTimeout() {
        return udpTimeout_packet;
    }

    public static void setUdpSessionTimeout(long timeout) {
        udpTimeout_session = timeout;
    }

    public static long getUdpSessionTimeout() {
        return udpTimeout_session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TrackServer(int[] tcpPorts, int[] udpPorts, int commandPort) throws Throwable {
        ServerSocketThread sst;
        int port;
        int i;
        int listeners = 0;
        if (!ListTools.isEmpty(tcpPorts)) {
            this.tcpThread = new OrderedMap();
            for (i = 0; i < tcpPorts.length; ++i) {
                port = tcpPorts[i];
                if (!ServerSocketThread.isValidPort(port)) throw new Exception("TCP: Invalid port number: " + port);
                try {
                    sst = this._startTCP(port);
                    this.tcpThread.put(new Integer(port), sst);
                    ++listeners;
                }
                catch (BindException be) {
                    Print.logError("TCP: Error binding to port: %d", port);
                }
            }
        }
        if (!ListTools.isEmpty(udpPorts)) {
            this.udpThread = new OrderedMap();
            this.udpSocket = new OrderedMap();
            for (i = 0; i < udpPorts.length; ++i) {
                port = udpPorts[i];
                if (!ServerSocketThread.isValidPort(port)) throw new Exception("UDP: Invalid port number: " + port);
                try {
                    sst = this._startUDP(port);
                    this.udpThread.put(new Integer(port), sst);
                    this.udpSocket.put(new Integer(port), sst.getDatagramSocket());
                    ++listeners;
                }
                catch (BindException be) {
                    Print.logError("UDP: Error binding to port: %d", port);
                }
            }
        }
        if (listeners <= 0) {
            Print.logWarn("No active device communication listeners!", new Object[0]);
        }
        if (commandPort > 0) {
            if (!ServerSocketThread.isValidPort(commandPort)) throw new Exception("Command: Invalid port number: " + commandPort);
            try {
                this._startCommand(commandPort);
                return;
            }
            catch (BindException be) {
                Print.logError("Command: Error binding to port: %d", commandPort);
            }
            return;
        } else {
            Print.logWarn("Ignoring CommandPort listener", new Object[0]);
        }
    }

    private ServerSocketThread _startTCP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(port);
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(true);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(TrackServer.getTcpIdleTimeout());
        sst.setPacketTimeout(TrackServer.getTcpPacketTimeout());
        sst.setSessionTimeout(TrackServer.getTcpSessionTimeout());
        sst.setLingerTimeoutSec(5);
        sst.setTerminateOnTimeout(false);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        DCServerConfig.startServerSocketThread(sst, "Event");
        return sst;
    }

    public ServerSocketThread getServerSocketThread_tcp(int port) {
        if (ListTools.isEmpty(this.tcpThread)) {
            return null;
        }
        if (port <= 0) {
            return this.tcpThread.getFirstValue();
        }
        ServerSocketThread sst = this.tcpThread.get(new Integer(port));
        if (sst != null) {
            return sst;
        }
        Print.logWarn("TCP 'Listen' port[" + port + "] not found, returning first ServerSocketThread", new Object[0]);
        return this.tcpThread.getFirstValue();
    }

    private ServerSocketThread _startUDP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(ServerSocketThread.createDatagramSocket(port));
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(true);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(TrackServer.getUdpIdleTimeout());
        sst.setPacketTimeout(TrackServer.getUdpPacketTimeout());
        sst.setSessionTimeout(TrackServer.getUdpSessionTimeout());
        sst.setTerminateOnTimeout(false);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        DCServerConfig.startServerSocketThread(sst, "Event");
        return sst;
    }

    public DatagramSocket getUdpDatagramSocket(int port) {
        if (ListTools.isEmpty(this.udpSocket)) {
            return null;
        }
        if (port <= 0) {
            return this.udpSocket.getFirstValue();
        }
        DatagramSocket ds = this.udpSocket.get(new Integer(port));
        if (ds != null) {
            return ds;
        }
        Print.logWarn("'Listen' port[" + port + "] not found, returning first DatagramSocket", new Object[0]);
        return this.udpSocket.getFirstValue();
    }

    private void _startCommand(int port) throws Throwable {
        ServerSocketThread sst = null;
        Class<?> cmdPktClass = null;
        try {
            cmdPktClass = Class.forName("org.opengts.servers.template.TemplateCommandHandler");
        }
        catch (Throwable th) {
            return;
        }
        try {
            sst = new ServerSocketThread(port);
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(true);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(new int[]{13, 10});
        sst.setIgnoreChar(null);
        sst.setMaximumPacketLength(1200);
        sst.setMinimumPacketLength(1);
        sst.setIdleTimeout(1000L);
        sst.setPacketTimeout(1000L);
        sst.setSessionTimeout(10000L);
        sst.setLingerTimeoutSec(5);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(cmdPktClass);
        Print.logInfo("Starting Command listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ...", new Object[0]);
        sst.start();
        this.cmdThread = sst;
    }
}

