/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.dct;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.servers.GPSEvent;
import org.opengts.servers.dct.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static int DATA_FORMAT_OPTION = 1;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 0L;
    private static boolean DFT_INSERT_EVENT;
    private static boolean INSERT_EVENT;
    public static double MINIMUM_SPEED_KPH;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    public static final double KNOTS_PER_KILOMETER = 0.5399568034557235;
    private String tipoData = "";
    private static final int[] InputStatusCodes_ON;
    private static final int[] InputStatusCodes_OFF;
    private String sessionID = null;
    private GPSEvent gpsEvent = null;
    private Device gpsDevice = null;
    private String lastModemID = null;
    private boolean terminate = false;
    private String ipAddress = null;
    private int clientPort = 0;
    public static final boolean USE_STANDARD_TCP_SESSION_ID = true;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.tipoData = this.isDuplex() ? "TCP" : "UDP";
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public String getSessionID() {
        if (!StringTools.isBlank(this.sessionID)) {
            return this.sessionID;
        }
        if (this.gpsDevice != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        }
        if (this.gpsEvent != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsEvent.getDevice());
        }
        return null;
    }

    public static String GetTcpSessionID(Device dev) {
        return DCServerFactory.getTcpSessionID(dev);
    }

    public static String CreateTcpSessionID(Device dev) {
        return DCServerFactory.createTcpSessionID(dev);
    }

    private GPSEvent createGPSEvent(String modemID) {
        DCServerConfig dcserver = Main.getServerConfig(null);
        if (this.gpsDevice != null) {
            if (!(modemID.equals("*") || this.lastModemID != null && this.lastModemID.equals(modemID))) {
                Print.logError("New MobileID does not match previously loaded Device", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, this.gpsDevice);
        } else {
            if (StringTools.isBlank(modemID) || modemID.equals("*")) {
                Print.logWarn("ModemID not specified!", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, modemID);
            this.gpsDevice = this.gpsEvent.getDevice();
        }
        if (this.gpsDevice == null) {
            return null;
        }
        this.sessionID = TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        return this.gpsEvent;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    private void setTerminate() {
        this.terminate = true;
    }

    @Override
    public boolean getTerminateSession() {
        return this.terminate;
    }

    @Override
    public byte[] getInitialPacket() throws Exception {
        return null;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes != null && pktBytes.length > 0) {
            String s = StringTools.toStringValue(pktBytes).trim();
            System.out.println("");
            byte[] rtn = null;
            if (s.startsWith(">REV")) {
                System.out.println(this.tipoData + " : " + s);
                rtn = this.insertREV_data(s);
            } else if (s.startsWith(">RPV")) {
                rtn = this.parseNull(s);
            } else {
                return null;
            }
            return rtn;
        }
        Print.logInfo("...", new Object[0]);
        return null;
    }

    private byte[] parseNull(String s) {
        if (StringTools.isBlank(s)) {
            Print.logError("String is null/blank", new Object[0]);
            return null;
        }
        if (s.length() < 5) {
            Print.logError("String is invalid length", new Object[0]);
            return null;
        }
        if (!s.startsWith(">")) {
            Print.logError("String does not start with '>'", new Object[0]);
            return null;
        }
        int se = s.endsWith("<") ? s.length() - 1 : s.length();
        String[] T = StringTools.split(s = s.substring(1, se), ';');
        if (!T[0].startsWith("REV")) {
            Print.logWarn("Only 'REV' record types please!", new Object[0]);
            this.setTerminateSession();
            return null;
        }
        if (T[0].length() < 40) {
            Print.logError("Invalid 'REV' data length", new Object[0]);
            return null;
        }
        return null;
    }

    private byte[] insertREV_data(String s) {
        if (StringTools.isBlank(s)) {
            Print.logError("String is null/blank", new Object[0]);
            return null;
        }
        if (s.length() < 5) {
            Print.logError("String is invalid length", new Object[0]);
            return null;
        }
        if (!s.startsWith(">")) {
            Print.logError("String does not start with '>'", new Object[0]);
            return null;
        }
        int se = s.endsWith("<") ? s.length() - 1 : s.length();
        String[] T = StringTools.split(s = s.substring(1, se), ';');
        if (!T[0].startsWith("REV")) {
            Print.logWarn("Solo registros REV por favor!", new Object[0]);
            return null;
        }
        if (T[0].length() < 40) {
            Print.logError("Invalid 'REV' data length", new Object[0]);
            return null;
        }
        String modemID = null;
        for (int i = 1; i < T.length; ++i) {
            if (!T[i].startsWith("ID=")) continue;
            modemID = T[i].substring(3);
            modemID = modemID.toLowerCase();
            break;
        }
        int eventID = StringTools.parseInt(T[0].substring(3, 5), 0);
        int numSem = StringTools.parseInt(T[0].substring(5, 9), 0);
        int numDia = StringTools.parseInt(T[0].substring(9, 10), 0);
        int statusCode = 61472;
        int gpsTOD = StringTools.parseInt(T[0].substring(10, 15), 0);
        double latitude = (double)StringTools.parseLong(T[0].substring(15, 23), 0L) / 100000.0;
        double longitude = (double)StringTools.parseLong(T[0].substring(23, 32), 0L) / 100000.0;
        double speedKPH = StringTools.parseDouble(T[0].substring(32, 35), 0.0) * 1.609344;
        double heading = StringTools.parseDouble(T[0].substring(35, 38), 0.0);
        String srcStr = T[0].substring(38, 39);
        String ageStr = T[0].substring(39, 40);
        double altitudeM = 0.0;
        long gpioInput = 0L;
        long prueba0 = new DateTime(DateTime.getGMTTimeZone()).getDayStart();
        long prueba = new DateTime(DateTime.getGMTTimeZone()).getTimeSec();
        long fixtime = new DateTime(DateTime.getGMTTimeZone()).getTimeSec();
        if (fixtime - DateTime.MinuteSeconds(15L) > DateTime.getCurrentTimeSec()) {
            fixtime -= DateTime.DaySeconds(1L);
        }
        boolean validGPS = true;
        if (!GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid lat/lon: " + latitude + "/" + longitude, new Object[0]);
            validGPS = false;
            latitude = 0.0;
            longitude = 0.0;
            speedKPH = 0.0;
            heading = 0.0;
        }
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            heading = 0.0;
        } else if (heading < 0.0) {
            heading = 0.0;
        }
        if (StringTools.isBlank(modemID)) {
            Print.logError("Missing MobileID", new Object[0]);
            return null;
        }
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + deviceID + "/" + uniqueID + "]");
        System.out.println("Evento: " + fixtime + " [" + new DateTime(fixtime) + "]");
        if (!validGPS && statusCode == 61472) {
            Print.logWarn("Ignoring event with invalid latitude/longitude", new Object[0]);
            return null;
        }
        System.out.println("EventID: " + eventID);
        statusCode = eventID == 1 ? (speedKPH == 0.0 ? 61715 : (speedKPH >= 6.0 ? 61713 : (speedKPH >= 20.0 ? 61714 : (speedKPH >= 90.0 ? 61722 : 61727)))) : (eventID == 2 ? 62465 : (eventID == 3 ? 62467 : (eventID == 4 ? 63553 : (eventID == 5 ? 62498 : (eventID == 6 ? 62499 : (eventID == 8 ? 64787 : (eventID == 9 ? 64789 : (eventID == 10 ? 61722 : (eventID == 11 ? 61718 : (eventID == 13 ? 64803 : (eventID == 14 ? 64804 : (eventID == 15 ? 64784 : (eventID == 17 ? 61731 : (eventID == 18 ? 63809 : (eventID == 46 ? 64784 : (eventID == 53 ? 64805 : (eventID == 56 ? 61722 : 61472)))))))))))))))));
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.lastModemID = modemID;
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setBatteryLevel(100.0);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return modemID.getBytes();
        }
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        return null;
    }

    private boolean parseInsertRecord_Common(GPSEvent gpsEv) {
        List<Device.GeozoneTransition> zone;
        double odomKM;
        long fixtime = gpsEv.getTimestamp();
        int statusCode = gpsEv.getStatusCode();
        Device dev = gpsEv.getDevice();
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date/time", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
            gpsEv.setTimestamp(fixtime);
        }
        if (!gpsEv.isValidGeoPoint()) {
            Print.logWarn("Invalid lat/lon: " + gpsEv.getLatitude() + "/" + gpsEv.getLongitude(), new Object[0]);
            gpsEv.setLatitude(0.0);
            gpsEv.setLongitude(0.0);
        }
        GeoPoint geoPoint = gpsEv.getGeoPoint();
        if (gpsEv.getSpeedKPH() < MINIMUM_SPEED_KPH) {
            gpsEv.setSpeedKPH(0.0);
            gpsEv.setHeading(0.0);
        }
        odomKM = (odomKM = 0.0) <= 0.0 ? (ESTIMATE_ODOMETER && geoPoint.isValid() ? this.gpsDevice.getNextOdometerKM(geoPoint) : this.gpsDevice.getLastOdometerKM()) : dev.adjustOdometerKM(odomKM);
        Print.logInfo("Odometer KM: " + odomKM, new Object[0]);
        gpsEv.setOdometerKM(odomKM);
        if (SIMEVENT_GEOZONES && geoPoint.isValid() && (zone = dev.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                gpsEv.insertEventData(z.getTimestamp(), z.getStatusCode(), z.getGeozone());
                Print.logInfo("Geozone    : " + z, new Object[0]);
            }
        }
        if (gpsEv.hasInputMask() && gpsEv.getInputMask() >= 0L) {
            long chgMask;
            long gpioInput = gpsEv.getInputMask();
            if (SIMEVENT_DIGITAL_INPUTS > 0L && (chgMask = (dev.getLastInputState() ^ gpioInput) & SIMEVENT_DIGITAL_INPUTS) != 0L) {
                for (int b = 0; b <= 15; ++b) {
                    long m = 1L << b;
                    if ((chgMask & m) == 0L) continue;
                    int inpCode = (gpioInput & m) != 0L ? InputStatusCodes_ON[b] : InputStatusCodes_OFF[b];
                    long inpTime = fixtime;
                    gpsEv.insertEventData(inpTime, inpCode);
                    Print.logInfo("GPIO : " + StatusCodes.GetDescription(inpCode, null), new Object[0]);
                }
            }
            dev.setLastInputState(gpioInput & 0xFFFFL);
        }
        gpsEv.insertEventData(fixtime, statusCode);
        gpsEv.updateDevice();
        return true;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig(null);
        if (dcsc == null) {
            Print.logWarn("DCServer not found: " + Main.getServerName(), new Object[0]);
            return;
        }
        DATA_FORMAT_OPTION = dcsc.getIntProperty(Main.ARG_FORMAT, DATA_FORMAT_OPTION);
        MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
        ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
        SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
        SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFFFL;
    }

    private static int _usage() {
        String cn = StringTools.className(TrackClientPacketHandler.class);
        Print.sysPrintln("Test/Load Device Communication Server", new Object[0]);
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  $JAVA_HOME/bin/java -classpath <classpath> %s {options}", cn);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -insert=[true|false]    Insert parsed records into EventData", new Object[0]);
        Print.sysPrintln("  -format=[1|2]           Data format", new Object[0]);
        Print.sysPrintln("  -debug                  Parse internal sample/debug data (if any)", new Object[0]);
        Print.sysPrintln("  -parseFile=<file>       Parse data from specified file", new Object[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int _main(boolean fromMain) {
        INSERT_EVENT = RTConfig.getBoolean(Main.ARG_INSERT, DFT_INSERT_EVENT);
        if (!INSERT_EVENT) {
            Print.sysPrintln("Warning: Data will NOT be inserted into the database", new Object[0]);
        }
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
        if (RTConfig.getBoolean(Main.ARG_DEBUG, false)) {
            String[] data = null;
            switch (DATA_FORMAT_OPTION) {
                case 1: {
                    data = new String[]{"123456789012345,2006/09/05,07:47:26,35.3640,-142.2958,27.0,224.8"};
                    break;
                }
                case 2: {
                    data = new String[]{"account/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E", "/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E"};
                    break;
                }
                case 3: {
                    data = new String[]{"2,123,1234567890,0,20101223,110819,1,2.1,39.1234,-142.1234,33,227,1800"};
                    break;
                }
                case 9: {
                    data = new String[]{"mid=123456789012345 lat=39.12345 lon=-142.12345 kph=123.0"};
                    break;
                }
                default: {
                    Print.sysPrintln("Unrecognized Data Format: %d", DATA_FORMAT_OPTION);
                    return TrackClientPacketHandler._usage();
                }
            }
            for (int i = 0; i < data.length; ++i) {
                tcph.getHandlePacket(data[i].getBytes());
            }
            return 0;
        }
        if (RTConfig.hasProperty(Main.ARG_PARSEFILE)) {
            File parseFile = RTConfig.getFile(Main.ARG_PARSEFILE, null);
            if (parseFile == null || !parseFile.isFile()) {
                Print.sysPrintln("Data source file not specified, or does not exist.", new Object[0]);
                return TrackClientPacketHandler._usage();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(parseFile);
            }
            catch (IOException ioe) {
                Print.logException("Error openning input file: " + parseFile, ioe);
                return 2;
            }
            try {
                while (true) {
                    String data;
                    if (StringTools.isBlank(data = FileTools.readLine(fis))) {
                        continue;
                    }
                    tcph.getHandlePacket(data.getBytes());
                }
            }
            catch (EOFException eof) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("***** End-Of-File *****", new Object[0]);
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            catch (IOException ioe) {
                try {
                    Print.logException("Error reaading input file: " + parseFile, ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            return 0;
        }
        return TrackClientPacketHandler._usage();
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        System.exit(TrackClientPacketHandler._main(false));
    }

    static {
        INSERT_EVENT = DFT_INSERT_EVENT = true;
        MINIMUM_SPEED_KPH = 0.0;
        InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
        InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
    }
}

