/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.custom.gts.rule;

import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.EventRuleFactory;
import org.opengts.rule.RuleListener;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.tables.Rule;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class ENREFunctions {
    private static ThreadPool ENREThreadPool = new ThreadPool("ENREFunctions", 5);
    public static final String ENRERuleListener_Name = "ENRERuleListener";

    public ENREFunctions() {
        RuleFactory ruleFact = Device.getRuleFactory();
        if (!(ruleFact instanceof EventRuleFactory)) {
            return;
        }
        EventRuleFactory erf = (EventRuleFactory)ruleFact;
        Print.logInfo((String)("Installing custom rule functions: " + StringTools.className((Object)this)), (Object[])new Object[0]);
        erf.addFunction(new EventFunctionHandler(new String[]{"$SUM"}){

            public String getUsage() {
                return "Double $SUM(Double A, Double B [, Double C [, Double D]])";
            }

            public String getDescription() {
                return "Sum arguments and return value.";
            }

            public Class getReturnType() {
                return Double.class;
            }

            public Object getDefaultValue() {
                return new Double(0.0);
            }

            public EventFunctionHandler.ArgCk getArgCheck() {
                return new EventFunctionHandler.ArgCk((EventFunctionHandler)this, 0, 1, 2, 3, 4, new Class[]{Double.class, Double.class, Double.class, Double.class});
            }

            public Object invokeFunction(FunctionMap fm, Object[] args) {
                if (!this.checkArgs(args)) {
                    return null;
                }
                double accum = 0.0;
                for (int i = 0; i < args.length; ++i) {
                    accum += 1.DoubleValue((Object)args[i]);
                }
                return new Double(accum);
            }
        });
        erf.addIdentifier(new EventIdentifierHandler(new String[]{"random"}){

            public String getDescription() {
                return "Random number between 0.0 and 1.0";
            }

            public Object getValue(IdentifierMap idm) {
                return new Double(Math.random());
            }
        });
        if (!EventRuleAction.hasRuleListener((String)ENRERuleListener_Name)) {
            Print.logInfo((String)"Adding ENRERuleListener ...", (Object[])new Object[0]);
            EventRuleAction.addRuleListener((RuleListener)new ENRERuleListener());
        } else {
            Print.logInfo((String)"ENRERuleListener already added ...", (Object[])new Object[0]);
        }
    }

    public static class ENRERuleListener
    implements RuleListener {
        public ENRERuleListener() {
            Print.logInfo((String)("RuleListener installed: " + StringTools.className((Object)this)), (Object[])new Object[0]);
        }

        public String getName() {
            return ENREFunctions.ENRERuleListener_Name;
        }

        public String toString() {
            return this.getName();
        }

        public void handleRuleNotification(Account account, Device device, EventData event, boolean isCronMode, String selector, Rule rule) {
            String accountID = account != null ? account.getAccountID() : "";
            String deviceID = device != null ? device.getDeviceID() : "";
            String ruleID = rule != null ? rule.getRuleID() : "";
            String cannedAct = rule != null ? rule.getCannedActions() : "";
            Print.logInfo((String)("Rule Action for Account/Device: " + accountID + "/" + deviceID), (Object[])new Object[0]);
            if (StringTools.isBlank((String)cannedAct)) {
                String[] caList;
                for (String craItem : caList = StringTools.split((String)cannedAct, (char)',')) {
                    Object[] cra = StringTools.split((String)craItem, (char)':');
                    if (ListTools.size((Object[])cra) <= 0) continue;
                    Object craKey = cra[0];
                    String craArg = cra.length > 1 ? cra[1] : "";
                }
            }
        }
    }
}

