/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.custom.gts;

import java.util.List;
import org.opengts.db.DBConfig;
import org.opengts.db.EventUtil;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class StartupInit
extends org.opengts.StartupInit
implements DBConfig.DBInitialization,
DBFactory.CustomFactoryHandler {
    private static String PROP_ENREInitialize_class = "ENREInitialize.class";
    protected static boolean LIMIT_DISPLAYED_STATUS_CODES = false;
    protected static boolean SET_STATUS_CODE_DESCRIPTIONS = false;
    protected static boolean ADD_RECORD_LISTENERS = false;
    protected static boolean ADD_ADDITIONAL_EVENTDATA_FIELDS = false;
    protected static boolean ADD_ADDITIONAL_TABLES = false;

    public void preInitialization() {
        Print.logDebug((String)"'StartupInit' Initialization for GTS Enterprise ...", (Object[])new Object[0]);
        super.preInitialization();
    }

    public void addTableFactories() {
        super.addTableFactories();
        if (ADD_ADDITIONAL_TABLES) {
            // empty if block
        }
        if (DBConfig.hasRulePackage()) {
            String dft_enreInitClassName = "org.opengts.custom.gts.rule.ENREFunctions";
            String enreInitClassName = RTConfig.getString((String)PROP_ENREInitialize_class, (String)dft_enreInitClassName);
            try {
                Class<?> enreInitClass = Class.forName(enreInitClassName);
                try {
                    enreInitClass.newInstance();
                    Print.logDebug((String)"Loaded custom Rule functions/identifiers", (Object[])new Object[0]);
                }
                catch (Throwable th) {
                    Print.logError((String)("Error loading custom Rule functions/identifiers: " + th), (Object[])new Object[0]);
                }
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    protected EventUtil.OptionalEventFields createOptionalEventFieldsHandler() {
        return super.createOptionalEventFieldsHandler();
    }

    public void postInitialization() {
        if (!LIMIT_DISPLAYED_STATUS_CODES) {
            StatusCodes.initStatusCodes(null);
        }
        if (SET_STATUS_CODE_DESCRIPTIONS) {
            // empty if block
        }
        if (ADD_RECORD_LISTENERS) {
            // empty if block
        }
        this.initPasswordHandler();
    }

    public <T extends DBRecord<T>> DBFactory<T> createDBFactory(String tableName, DBField[] field, DBFactory.KeyType keyType, Class<T> rcdClass, Class<? extends DBRecordKey<T>> keyClass, boolean editable, boolean viewable) {
        return super.createDBFactory(tableName, field, keyType, rcdClass, keyClass, editable, viewable);
    }

    public List<DBField> selectFields(DBFactory factory, List<DBField> fields) {
        String tblName = factory.getUntranslatedTableName();
        if (tblName.equalsIgnoreCase(Account.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.Account.AddressFieldInfo", false, Account.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.MapLegendFieldInfo", true, Account.MapLegendFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.AccountManagerInfo", true, Account.AccountManagerInfo);
            this.addDBFields(tblName, fields, "startupInit.Account.DataPushInfo", true, Account.DataPushInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(User.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.User.AddressFieldInfo", false, User.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.User.ExtraFieldInfo", false, User.ExtraFieldInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(Device.TABLE_NAME())) {
            boolean ruPkg = DBConfig.hasRulePackage();
            boolean bcPkg = Account.SupportsBorderCrossing();
            this.addDBFields(tblName, fields, "startupInit.Device.NotificationFieldInfo", true, Device.NotificationFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.GeoCorridorFieldInfo", ruPkg, Device.GeoCorridorFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.FixedLocationFieldInfo", false, Device.FixedLocationFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.LinkFieldInfo", false, Device.LinkFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.BorderCrossingFieldInfo", bcPkg, Device.BorderCrossingFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.MaintOdometerFieldInfo", ruPkg, Device.MaintOdometerFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.WorkOrderInfo", false, Device.WorkOrderInfo);
            this.addDBFields(tblName, fields, "startupInit.Device.DataPushInfo", true, Device.DataPushInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(DeviceGroup.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.DeviceGroup.WorkOrderInfo", false, DeviceGroup.WorkOrderInfo);
            return fields;
        }
        if (tblName.equalsIgnoreCase(EventData.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.EventData.AutoIncrementIndex", false, EventData.AutoIncrementIndex);
            this.addDBFields(tblName, fields, "startupInit.EventData.CreationTimeMillisecond", false, EventData.CreationTimeMillisecond);
            this.addDBFields(tblName, fields, "startupInit.EventData.AddressFieldInfo", true, EventData.AddressFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.GPSFieldInfo", true, EventData.GPSFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.CustomFieldInfo", false, EventData.CustomFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.GarminFieldInfo", false, EventData.GarminFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.CANBUSFieldInfo", false, EventData.CANBUSFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.AtmosphereFieldInfo", false, EventData.AtmosphereFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.ThermoFieldInfo", false, EventData.ThermoFieldInfo, 4);
            this.addDBFields(tblName, fields, "startupInit.EventData.AnalogFieldInfo", false, EventData.AnalogFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.EventData.EndOfDaySummary", false, EventData.EndOfDaySummary);
            this.addDBFields(tblName, fields, "startupInit.EventData.ServingCellTowerData", false, EventData.ServingCellTowerData);
            this.addDBFields(tblName, fields, "startupInit.EventData.NeighborCellTowerData", false, EventData.NeighborCellTowerData);
            this.addDBFields(tblName, fields, "startupInit.EventData.WorkZoneGridData", false, EventData.WorkZoneGridData);
            if (ADD_ADDITIONAL_EVENTDATA_FIELDS) {
                Print.logInfo((String)"Adding custom fields to EventData ...", (Object[])new Object[0]);
                this.addDBFields(tblName, fields, null, true, new DBField[]{new DBField("customDoubleValue", Double.TYPE, "DOUBLE", "Double value", "edit=2"), new DBField("customBoolValue", Boolean.TYPE, "BOOLEAN", "Boolean value", "edit=2"), new DBField("custom32BitValue", Long.TYPE, "UINT32", "32Bit Value", "edit=2"), new DBField("customStringValue", String.class, DBField.TYPE_STRING((int)32), "String Value", "edit=2")});
            }
            return fields;
        }
        if (tblName.equalsIgnoreCase(Geozone.TABLE_NAME())) {
            this.addDBFields(tblName, fields, "startupInit.Geozone.PriorityFieldInfo", true, Geozone.PriorityFieldInfo);
            this.addDBFields(tblName, fields, "startupInit.Geozone.CorridorFieldInfo", true, Geozone.CorridorFieldInfo);
            return fields;
        }
        return super.selectFields(factory, fields);
    }
}

