/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.hplow;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.TimeZone;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.servers.GPSEvent;
import org.opengts.servers.hplow.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.Nmea0183;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static int DATA_FORMAT_OPTION = 2;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 0L;
    private static boolean DFT_INSERT_EVENT;
    private static boolean INSERT_EVENT;
    public static double MINIMUM_SPEED_KPH;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    public static final double KNOTS_PER_KILOMETER = 0.5399568034557235;
    private static boolean IGNORE_NMEA_CHECKSUM;
    private static final TimeZone gmtTimezone;
    private static final int[] InputStatusCodes_ON;
    private static final int[] InputStatusCodes_OFF;
    private String sessionID = null;
    private GPSEvent gpsEvent = null;
    private Device gpsDevice = null;
    private String lastModemID = null;
    private boolean terminate = false;
    private String ipAddress = null;
    private int clientPort = 0;
    public static final boolean USE_STANDARD_TCP_SESSION_ID = true;
    private static String[] RTP_ACCOUNT;
    private static String[] RTP_DEVICE;
    private static String[] RTP_MODEMID;
    private static String[] RTP_TIMESTAMP;
    private static String[] RTP_STATUSCODE;
    private static String[] RTP_GEOPOINT;
    private static String[] RTP_GPSAGE;
    private static String[] RTP_SATCOUNT;
    private static String[] RTP_SPEED;
    private static String[] RTP_HEADING;
    private static String[] RTP_ALTITUDE;
    private static String[] RTP_ODOMETER;
    private static String[] RTP_INPUTMASK;
    private static String[] RTP_SERVERID;
    private static String[] RTP_ACK;
    private static String[] RTP_NAK;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public String getSessionID() {
        if (!StringTools.isBlank(this.sessionID)) {
            return this.sessionID;
        }
        if (this.gpsDevice != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        }
        if (this.gpsEvent != null) {
            return TrackClientPacketHandler.CreateTcpSessionID(this.gpsEvent.getDevice());
        }
        return null;
    }

    public static String GetTcpSessionID(Device dev) {
        return DCServerFactory.getTcpSessionID(dev);
    }

    public static String CreateTcpSessionID(Device dev) {
        return DCServerFactory.createTcpSessionID(dev);
    }

    private GPSEvent createGPSEvent(String accountID, String deviceID) {
        DCServerConfig dcserver = Main.getServerConfig(null);
        if (this.gpsDevice != null) {
            if (!this.gpsDevice.getAccountID().equals(accountID) || !this.gpsDevice.getDeviceID().equals(deviceID)) {
                Print.logError("New AccountID/DeviceID does not match previously loaded Device", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, this.gpsDevice);
        } else {
            if (StringTools.isBlank(deviceID)) {
                Print.logWarn("DeviceID not specified!", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, accountID, deviceID);
            this.gpsDevice = this.gpsEvent.getDevice();
        }
        if (this.gpsDevice == null) {
            return null;
        }
        this.sessionID = TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        return this.gpsEvent;
    }

    private GPSEvent createGPSEvent(String modemID) {
        DCServerConfig dcserver = Main.getServerConfig(null);
        if (this.gpsDevice != null) {
            if (!(modemID.equals("*") || this.lastModemID != null && this.lastModemID.equals(modemID))) {
                Print.logError("New MobileID does not match previously loaded Device", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, this.gpsDevice);
        } else {
            if (StringTools.isBlank(modemID) || modemID.equals("*")) {
                Print.logWarn("ModemID not specified!", new Object[0]);
                return null;
            }
            this.gpsEvent = new GPSEvent(dcserver, this.ipAddress, this.clientPort, modemID);
            this.gpsDevice = this.gpsEvent.getDevice();
        }
        if (this.gpsDevice == null) {
            return null;
        }
        this.sessionID = TrackClientPacketHandler.CreateTcpSessionID(this.gpsDevice);
        return this.gpsEvent;
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    private void setTerminate() {
        this.terminate = true;
    }

    @Override
    public boolean getTerminateSession() {
        return this.terminate;
    }

    @Override
    public byte[] getInitialPacket() throws Exception {
        return null;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes != null && pktBytes.length > 0) {
            String s = StringTools.toStringValue(pktBytes).trim();
            System.out.println("");
            System.out.println("Trama: " + s);
            byte[] rtn = null;
            switch (DATA_FORMAT_OPTION) {
                case 1: {
                    rtn = this.parseInsertRecord_ASCII_01(s);
                    break;
                }
                case 2: {
                    rtn = this.parseInsertRecord_ASCII_02(s);
                    break;
                }
                case 3: {
                    rtn = this.parseInsertRecord_ASCII_03(s);
                    break;
                }
                case 9: {
                    rtn = this.parseInsertRecord_RTProps(s);
                    break;
                }
                case 11: {
                    rtn = this.parseInsertRecord_Device_1(s);
                    break;
                }
                default: {
                    Print.logError("Unspecified data format", new Object[0]);
                }
            }
            return rtn;
        }
        Print.logInfo("Empty packet received ...", new Object[0]);
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        return null;
    }

    private boolean parseInsertRecord_Common(GPSEvent gpsEv) {
        List<Device.GeozoneTransition> zone;
        double odomKM;
        long fixtime = gpsEv.getTimestamp();
        int statusCode = gpsEv.getStatusCode();
        Device dev = gpsEv.getDevice();
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date/time", new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
            gpsEv.setTimestamp(fixtime);
        }
        if (!gpsEv.isValidGeoPoint()) {
            Print.logWarn("Invalid lat/lon: " + gpsEv.getLatitude() + "/" + gpsEv.getLongitude(), new Object[0]);
            gpsEv.setLatitude(0.0);
            gpsEv.setLongitude(0.0);
        }
        GeoPoint geoPoint = gpsEv.getGeoPoint();
        if (gpsEv.getSpeedKPH() < MINIMUM_SPEED_KPH) {
            gpsEv.setSpeedKPH(0.0);
            gpsEv.setHeading(0.0);
        }
        odomKM = (odomKM = 0.0) <= 0.0 ? (ESTIMATE_ODOMETER && geoPoint.isValid() ? this.gpsDevice.getNextOdometerKM(geoPoint) : this.gpsDevice.getLastOdometerKM()) : dev.adjustOdometerKM(odomKM);
        Print.logInfo("Odometer KM: " + odomKM, new Object[0]);
        gpsEv.setOdometerKM(odomKM);
        if (SIMEVENT_GEOZONES && geoPoint.isValid() && (zone = dev.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                gpsEv.insertEventData(z.getTimestamp(), z.getStatusCode(), z.getGeozone());
                Print.logInfo("Geozone    : " + z, new Object[0]);
            }
        }
        if (gpsEv.hasInputMask() && gpsEv.getInputMask() >= 0L) {
            long chgMask;
            long gpioInput = gpsEv.getInputMask();
            if (SIMEVENT_DIGITAL_INPUTS > 0L && (chgMask = (dev.getLastInputState() ^ gpioInput) & SIMEVENT_DIGITAL_INPUTS) != 0L) {
                for (int b = 0; b <= 15; ++b) {
                    long m = 1L << b;
                    if ((chgMask & m) == 0L) continue;
                    int inpCode = (gpioInput & m) != 0L ? InputStatusCodes_ON[b] : InputStatusCodes_OFF[b];
                    long inpTime = fixtime;
                    gpsEv.insertEventData(inpTime, inpCode);
                    Print.logInfo("GPIO : " + StatusCodes.GetDescription(inpCode, null), new Object[0]);
                }
            }
            dev.setLastInputState(gpioInput & 0xFFFFL);
        }
        gpsEv.insertEventData(fixtime, statusCode);
        gpsEv.updateDevice();
        return true;
    }

    private byte[] parseInsertRecord_ASCII_01(String s) {
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null || fld.length < 5) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return null;
        }
        String modemID = fld[0].toLowerCase();
        long fixtime = this._parseDate(fld[1], fld[2]);
        int statusCode = 61472;
        double latitude = StringTools.parseDouble(fld[3], 0.0);
        double longitude = StringTools.parseDouble(fld[4], 0.0);
        double speedKPH = fld.length > 5 ? StringTools.parseDouble(fld[5], 0.0) : 0.0;
        double heading = fld.length > 6 ? StringTools.parseDouble(fld[6], 0.0) : 0.0;
        double altitudeM = fld.length > 7 ? StringTools.parseDouble(fld[7], 0.0) : 0.0;
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private long _parseDate(String yyyymmdd, String hhmmss) {
        String[] d = StringTools.parseStringArray(yyyymmdd, "/");
        String[] t = StringTools.parseStringArray(hhmmss, ":");
        if (d.length != 3 && t.length != 3) {
            return 0L;
        }
        int YY = StringTools.parseInt(d[0], 0);
        int MM = StringTools.parseInt(d[1], 0);
        int DD = StringTools.parseInt(d[2], 0);
        int hh = StringTools.parseInt(t[0], 0);
        int mm = StringTools.parseInt(t[1], 0);
        int ss = StringTools.parseInt(t[2], 0);
        if (YY < 100) {
            YY += 2000;
        }
        DateTime dt = new DateTime(gmtTimezone, YY, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private long _parseDate(long yyyymmdd, long hhmmss) {
        if (yyyymmdd <= 0L || hhmmss < 0L) {
            return 0L;
        }
        int YY = (int)(yyyymmdd / 10000L);
        int MM = (int)(yyyymmdd / 100L % 100L);
        int DD = (int)(yyyymmdd / 1L % 100L);
        int hh = (int)(hhmmss / 10000L);
        int mm = (int)(hhmmss / 100L % 100L);
        int ss = (int)(hhmmss / 1L % 100L);
        if (YY < 100) {
            YY += 2000;
        }
        DateTime dt = new DateTime(gmtTimezone, YY, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private long _parseDate(long yyyymmddhhmmss) {
        if (yyyymmddhhmmss <= 0L) {
            return 0L;
        }
        int YY = (int)(yyyymmddhhmmss / 10000000000L);
        int MM = (int)(yyyymmddhhmmss / 100000000L % 100L);
        int DD = (int)(yyyymmddhhmmss / 1000000L % 100L);
        int hh = (int)(yyyymmddhhmmss / 10000L % 100L);
        int mm = (int)(yyyymmddhhmmss / 100L % 100L);
        int ss = (int)(yyyymmddhhmmss / 1L % 100L);
        if (YY < 100) {
            YY += 2000;
        }
        DateTime dt = new DateTime(gmtTimezone, YY, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private byte[] parseInsertRecord_ASCII_02(String s) {
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s, '<');
        if (fld == null || fld.length < 2) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return null;
        }
        String deviceID = fld[0].toLowerCase().substring(1, fld[0].length());
        Nmea0183 gprmc = new Nmea0183(fld[1], IGNORE_NMEA_CHECKSUM);
        long fixtime = gprmc.getFixtime();
        int statusCode = 61472;
        double latitude = gprmc.getLatitude();
        double longitude = gprmc.getLongitude();
        double speedKPH = gprmc.getSpeedKPH();
        double heading = gprmc.getHeading();
        double altitudeM = 0.0;
        this.gpsEvent = this.createGPSEvent(deviceID);
        if (this.gpsEvent == null) {
            return null;
        }
        Device device = this.gpsEvent.getDevice();
        if (device == null) {
            return null;
        }
        String accountID = device.getAccountID();
        String devceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        System.out.println("Registro ---> [" + accountID + "/" + devceID + "/" + uniqueID + "]");
        System.out.println("Evento: " + fixtime + " [" + new DateTime(fixtime) + "]");
        double maxSpeed = device.getSpeedLimitKPH();
        if (speedKPH > MINIMUM_SPEED_KPH && speedKPH < maxSpeed) {
            statusCode = device.getLastValidSpeed() <= MINIMUM_SPEED_KPH ? 61713 : 61714;
        } else if (speedKPH >= maxSpeed) {
            statusCode = 61722;
        } else if (speedKPH <= MINIMUM_SPEED_KPH) {
            statusCode = 61715;
        }
        speedKPH = this.gpsEvent.ajustaVelocidad(device.getDescription(), speedKPH);
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private byte[] parseInsertRecord_ASCII_03(String s) {
        String[] fld;
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        String kv = null;
        int kvPos = s.indexOf(59);
        if (kvPos >= 0) {
            kv = s.substring(kvPos + 1);
            s = s.substring(0, kvPos);
        }
        if ((fld = StringTools.parseStringArray(s, ',')) == null || fld.length < 10) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return null;
        }
        int statusCode = 61472;
        int sequence = StringTools.parseInt(fld[0], 0);
        int eventCode = StringTools.parseInt(fld[1], 0);
        String modemID = fld[2].toLowerCase();
        int format = StringTools.parseInt(fld[3], 0);
        long yyyymmdd = StringTools.parseLong(fld[4], 0L);
        long hhmmss = StringTools.parseLong(fld[5], 0L);
        long fixtime = this._parseDate(yyyymmdd, hhmmss);
        boolean validGPS = fld[6].equals("1");
        double latitude = validGPS ? StringTools.parseDouble(fld[8], 0.0) : 0.0;
        double longitude = validGPS ? StringTools.parseDouble(fld[9], 0.0) : 0.0;
        double heading = validGPS && fld.length > 10 ? StringTools.parseDouble(fld[10], 0.0) : 0.0;
        double speedKPH = validGPS && fld.length > 11 ? StringTools.parseDouble(fld[11], 0.0) : 0.0;
        double altitudeM = validGPS && fld.length > 12 ? StringTools.parseDouble(fld[12], 0.0) : 0.0;
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    private byte[] parseInsertRecord_RTProps(String s) {
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (StringTools.isBlank(s)) {
            Print.logError("Packet string is blank/null", new Object[0]);
            return null;
        }
        RTProperties rtp = new RTProperties(s);
        String accountID = rtp.getString(RTP_ACCOUNT, null);
        String deviceID = rtp.getString(RTP_DEVICE, null);
        String mobileID = rtp.getString(RTP_MODEMID, null);
        long fixtime = rtp.getLong(RTP_TIMESTAMP, 0L);
        int statusCode = rtp.getInt(RTP_STATUSCODE, 61472);
        String gpsStr = rtp.getString(RTP_GEOPOINT, null);
        long gpsAge = rtp.getLong(RTP_GPSAGE, 0L);
        int satCount = rtp.getInt(RTP_SATCOUNT, 0);
        double speedKPH = rtp.getDouble(RTP_SPEED, 0.0);
        double heading = rtp.getDouble(RTP_HEADING, 0.0);
        double altitudeM = rtp.getDouble(RTP_ALTITUDE, 0.0);
        double odomKM = rtp.getDouble(RTP_ODOMETER, 0.0);
        long gpioInput = rtp.getLong(RTP_INPUTMASK, -1L);
        String dcsid = rtp.getString(RTP_SERVERID, null);
        String ack = rtp.getString(RTP_ACK, null);
        String nak = rtp.getString(RTP_NAK, null);
        GeoPoint geoPoint = new GeoPoint(gpsStr);
        if (StringTools.isBlank(mobileID)) {
            Print.logError("UniqueID/ModemID not specified!", new Object[0]);
            return nak != null ? (nak + "\n").getBytes() : null;
        }
        String dcsName = !StringTools.isBlank(dcsid) ? dcsid : Main.getServerName();
        DCServerConfig dcserver = DCServerFactory.getServerConfig(dcsName);
        if (dcserver == null) {
            Print.logWarn("DCServer name not registered: " + dcsName, new Object[0]);
        }
        boolean hasAcctDevID = false;
        if (!StringTools.isBlank(accountID)) {
            if (StringTools.isBlank(deviceID)) {
                Print.logError("'deviceID' required if 'accountID' specified", new Object[0]);
                return nak != null ? (nak + "\n").getBytes() : null;
            }
            if (!StringTools.isBlank(mobileID)) {
                Print.logError("'mobileID' not allowed if 'accountID' specified", new Object[0]);
                return nak != null ? (nak + "\n").getBytes() : null;
            }
            hasAcctDevID = true;
        } else {
            if (!StringTools.isBlank(deviceID)) {
                Print.logError("'accountID' required if 'deviceID' specified", new Object[0]);
                return nak != null ? (nak + "\n").getBytes() : null;
            }
            if (StringTools.isBlank(mobileID)) {
                Print.logError("'mobileID' not specified", new Object[0]);
                return nak != null ? (nak + "\n").getBytes() : null;
            }
        }
        GPSEvent gPSEvent = this.gpsEvent = hasAcctDevID ? this.createGPSEvent(accountID, deviceID) : this.createGPSEvent(mobileID);
        if (this.gpsEvent == null) {
            return nak != null ? (nak + "\n").getBytes() : null;
        }
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setGeoPoint(geoPoint);
        this.gpsEvent.setGpsAge(gpsAge);
        this.gpsEvent.setSatelliteCount(satCount);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setAltitude(altitudeM);
        this.gpsEvent.setOdometerKM(odomKM);
        if (gpioInput >= 0L) {
            this.gpsEvent.setInputMask(gpioInput);
        }
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return ack != null ? (ack + "\n").getBytes() : null;
        }
        return nak != null ? (nak + "\n").getBytes() : null;
    }

    private byte[] parseInsertRecord_Device_1(String s) {
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (StringTools.isBlank(s)) {
            Print.logError("Packet string is blank/null", new Object[0]);
            return null;
        }
        if (!s.startsWith("$")) {
            Print.logError("Packet string does not start with '$'", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s.substring(1), ',');
        if (fld == null || fld.length < 11) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return null;
        }
        String eventCode = fld[0];
        String modemID = fld[1].toLowerCase();
        long fixtime = Nmea0183.parseFixtime(fld[10], fld[2], true);
        boolean validGPS = fld[3].equalsIgnoreCase("A");
        double latitude = validGPS ? Nmea0183.ParseLatitude(fld[4], fld[5], 90.0) : 0.0;
        double longitude = validGPS ? Nmea0183.ParseLongitude(fld[6], fld[7], 180.0) : 0.0;
        double speedKnot = validGPS ? StringTools.parseDouble(fld[8], 0.0) : 0.0;
        double speedKPH = validGPS ? speedKnot * 1.852 : 0.0;
        double heading = validGPS ? StringTools.parseDouble(fld[9], 0.0) : 0.0;
        double altitudeM = 0.0;
        int statusCode = 61472;
        if (eventCode.equalsIgnoreCase("POS")) {
            statusCode = 61472;
        } else if (eventCode.equalsIgnoreCase("IN1")) {
            statusCode = 61489;
        } else if (eventCode.equalsIgnoreCase("IN2")) {
            statusCode = 61490;
        } else if (eventCode.equalsIgnoreCase("IN3")) {
            statusCode = 61491;
        } else if (eventCode.equalsIgnoreCase("LPA")) {
            statusCode = 64784;
        } else if (eventCode.equalsIgnoreCase("CPA")) {
            statusCode = 64787;
        } else if (eventCode.equalsIgnoreCase("SPD")) {
            statusCode = 61722;
        } else if (eventCode.equalsIgnoreCase("GOF")) {
            statusCode = 62032;
        }
        this.gpsEvent = this.createGPSEvent(modemID);
        if (this.gpsEvent == null) {
            return null;
        }
        this.gpsEvent.setTimestamp(fixtime);
        this.gpsEvent.setStatusCode(statusCode);
        this.gpsEvent.setLatitude(latitude);
        this.gpsEvent.setLongitude(longitude);
        this.gpsEvent.setSpeedKPH(speedKPH);
        this.gpsEvent.setHeading(heading);
        this.gpsEvent.setAltitude(altitudeM);
        if (this.parseInsertRecord_Common(this.gpsEvent)) {
            return null;
        }
        return null;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig(null);
        if (dcsc == null) {
            Print.logWarn("DCServer not found: " + Main.getServerName(), new Object[0]);
            return;
        }
        DATA_FORMAT_OPTION = dcsc.getIntProperty(Main.ARG_FORMAT, DATA_FORMAT_OPTION);
        MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
        ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
        SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
        SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFFFL;
    }

    private static int _usage() {
        String cn = StringTools.className(TrackClientPacketHandler.class);
        Print.sysPrintln("Test/Load Device Communication Server", new Object[0]);
        Print.sysPrintln("Usage:", new Object[0]);
        Print.sysPrintln("  $JAVA_HOME/bin/java -classpath <classpath> %s {options}", cn);
        Print.sysPrintln("Options:", new Object[0]);
        Print.sysPrintln("  -insert=[true|false]    Insert parsed records into EventData", new Object[0]);
        Print.sysPrintln("  -format=[1|2]           Data format", new Object[0]);
        Print.sysPrintln("  -debug                  Parse internal sample/debug data (if any)", new Object[0]);
        Print.sysPrintln("  -parseFile=<file>       Parse data from specified file", new Object[0]);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int _main(boolean fromMain) {
        INSERT_EVENT = RTConfig.getBoolean(Main.ARG_INSERT, DFT_INSERT_EVENT);
        if (!INSERT_EVENT) {
            Print.sysPrintln("Warning: Data will NOT be inserted into the database", new Object[0]);
        }
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
        if (RTConfig.getBoolean(Main.ARG_DEBUG, false)) {
            String[] data = null;
            switch (DATA_FORMAT_OPTION) {
                case 1: {
                    data = new String[]{"123456789012345,2006/09/05,07:47:26,35.3640,-142.2958,27.0,224.8"};
                    break;
                }
                case 2: {
                    data = new String[]{"account/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E", "/device/$GPRMC,025423.494,A,3709.0642,N,14207.8315,W,12.09,108.52,200505,,*2E"};
                    break;
                }
                case 3: {
                    data = new String[]{"2,123,1234567890,0,20101223,110819,1,2.1,39.1234,-142.1234,33,227,1800"};
                    break;
                }
                case 9: {
                    data = new String[]{"mid=123456789012345 lat=39.12345 lon=-142.12345 kph=123.0"};
                    break;
                }
                default: {
                    Print.sysPrintln("Unrecognized Data Format: %d", DATA_FORMAT_OPTION);
                    return TrackClientPacketHandler._usage();
                }
            }
            for (int i = 0; i < data.length; ++i) {
                tcph.getHandlePacket(data[i].getBytes());
            }
            return 0;
        }
        if (RTConfig.hasProperty(Main.ARG_PARSEFILE)) {
            File parseFile = RTConfig.getFile(Main.ARG_PARSEFILE, null);
            if (parseFile == null || !parseFile.isFile()) {
                Print.sysPrintln("Data source file not specified, or does not exist.", new Object[0]);
                return TrackClientPacketHandler._usage();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(parseFile);
            }
            catch (IOException ioe) {
                Print.logException("Error openning input file: " + parseFile, ioe);
                return 2;
            }
            try {
                while (true) {
                    String data;
                    if (StringTools.isBlank(data = FileTools.readLine(fis))) {
                        continue;
                    }
                    tcph.getHandlePacket(data.getBytes());
                }
            }
            catch (EOFException eof) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("***** End-Of-File *****", new Object[0]);
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            catch (IOException ioe) {
                try {
                    Print.logException("Error reaading input file: " + parseFile, ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            return 0;
        }
        return TrackClientPacketHandler._usage();
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        System.exit(TrackClientPacketHandler._main(false));
    }

    static {
        INSERT_EVENT = DFT_INSERT_EVENT = true;
        MINIMUM_SPEED_KPH = 0.0;
        IGNORE_NMEA_CHECKSUM = true;
        gmtTimezone = DateTime.getGMTTimeZone();
        InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
        InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
        RTP_ACCOUNT = new String[]{"acct", "accountid"};
        RTP_DEVICE = new String[]{"dev", "deviceid"};
        RTP_MODEMID = new String[]{"mid", "modemid", "uniqueid", "imei"};
        RTP_TIMESTAMP = new String[]{"ts", "timestamp", "time"};
        RTP_STATUSCODE = new String[]{"code", "statusCode"};
        RTP_GEOPOINT = new String[]{"gps", "geopoint"};
        RTP_GPSAGE = new String[]{"age", "gpsAge"};
        RTP_SATCOUNT = new String[]{"sats", "satCount"};
        RTP_SPEED = new String[]{"kph", "speed", "speedKph"};
        RTP_HEADING = new String[]{"dir", "heading"};
        RTP_ALTITUDE = new String[]{"alt", "altm", "altitude"};
        RTP_ODOMETER = new String[]{"odom", "odometer"};
        RTP_INPUTMASK = new String[]{"gpio", "inputMask"};
        RTP_SERVERID = new String[]{"dcs", "serverid"};
        RTP_ACK = new String[]{"ack"};
        RTP_NAK = new String[]{"nak"};
    }
}

