/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.servers.sanav;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.opengts.cellid.CellTower;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.extra.servers.sanav.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Nmea0183;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static boolean SAVE_SESSION_STATISTICS = true;
    public static boolean USE_LAST_VALID_GPS = false;
    public static boolean IGNORE_INVALID_GPS_EV = true;
    public static boolean TCP_PACKET_LENGTH_EOS = true;
    public static boolean DEBUG_MODE = false;
    public static String GS818_ACK = "ACK";
    private static double MAX_BATTERY_VOLTS = 4.1;
    private static double MIN_BATTERY_VOLTS = 3.65;
    private static double RANGE_BATTERY_VOLTS = MAX_BATTERY_VOLTS - MIN_BATTERY_VOLTS;
    private Device device = null;
    private DataTransport dataXPort = null;

    private static double CalcBatteryPercent(double voltage) {
        double percent = (voltage - MIN_BATTERY_VOLTS) / RANGE_BATTERY_VOLTS;
        if (percent < 0.0) {
            return 0.0;
        }
        if (percent > 1.0) {
            return 1.0;
        }
        return percent;
    }

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.clearSavedEventCount();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
        if (SAVE_SESSION_STATISTICS && !DEBUG_MODE && this.device != null) {
            this.device.insertSessionStatistic(this.getSessionStartTime(), this.getIPAddress(), this.isDuplex(), readCount, writeCount, this.getSavedEventCount());
        }
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (this.isDuplex() && TCP_PACKET_LENGTH_EOS) {
            return -2;
        }
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes == null) {
            Print.logError("Packet is null", new Object[0]);
            return null;
        }
        if (pktBytes.length < 12) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
            return null;
        }
        String s = StringTools.toStringValue(pktBytes).trim();
        Print.logInfo("Recv: " + s, new Object[0]);
        return this.parseInsertRecord(s);
    }

    private int parseStatusCode(String evCode) {
        int ndx;
        int sc;
        String code = StringTools.trim(evCode).toUpperCase();
        if (code.startsWith("B")) {
            code = code.startsWith("B-") ? code.substring(2) : code.substring(1);
        }
        int codeLen = code.length();
        int statusCode = 61472;
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && (sc = dcs.translateStatusCode(code, -9999)) >= 0) {
            return sc;
        }
        statusCode = codeLen == 0 ? 61472 : (code.startsWith("0X") ? StringTools.parseInt(code, 61472) : (code.equals("AUTO") || code.equals("LAUTO") ? 61472 : (code.equals("SOS") ? 61488 : (code.equals("MOVE") ? 61724 : (code.equals("POLL") ? 61504 : (code.equals("GIN") ? 61968 : (code.equals("GOUT") ? 62000 : (code.startsWith("GF") ? (code.endsWith("IN") ? 61968 : (code.endsWith("OUT") ? 62000 : 62032)) : (code.equals("PARK") ? 62144 : (code.equals("UNPARK") || code.equals("UNPA") ? 62150 : (code.equals("START") ? 61472 : (code.equals("ACCON") ? 62465 : (code.equals("ACCOFF") ? 62467 : (code.equals("LP") ? 64784 : (code.equals("DC") ? 64787 : (code.equals("CH") ? 64789 : (code.equals("OPEN") ? StatusCodes.InputStatusCodes_ON[0] : (code.equals("CLOSE") ? StatusCodes.InputStatusCodes_OFF[0] : (code.startsWith("ALARM") && codeLen >= 6 ? ((ndx = code.charAt(5) - 48) >= 0 && ndx <= 9 && ndx < StatusCodes.InputStatusCodes_ON.length ? StatusCodes.InputStatusCodes_ON[ndx] : 62466) : (code.equals("STATIONARY") ? 61716 : (code.equals("VIBRATION") ? 63633 : (code.equals("OVERSPEED") ? 61722 : 61472))))))))))))))))))))));
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] parseInsertRecord(String s) {
        List<Device.GeozoneTransition> zone;
        double lastLon;
        double lastLat;
        int x;
        if (StringTools.isBlank(s)) {
            Print.logError("String is null/blank", new Object[0]);
            return null;
        }
        this.clearSavedEventCount();
        String imeiField = "";
        String fmiField = "";
        String dataField = "";
        String xtraField = "";
        String c = "&";
        int p = s.indexOf(c);
        if (p < 0) {
            c = ";";
            p = s.indexOf(c);
        }
        if (p < 0) {
            Print.logError("No data", new Object[0]);
            return null;
        }
        imeiField = s.substring(0, p);
        dataField = s.substring(p + 1);
        int e = imeiField.indexOf(",");
        if (e >= 0) {
            fmiField = imeiField.substring(e + 1);
            imeiField = imeiField.substring(0, e);
        }
        if ((x = dataField.indexOf(";")) >= 0) {
            xtraField = dataField.substring(x + 1);
            dataField = dataField.substring(0, x);
            xtraField = xtraField.replace(':', '=');
            xtraField = xtraField.replace(',', ' ');
        }
        String imei = "";
        if (imeiField.startsWith("imei=")) {
            imei = imeiField.substring(5).trim();
        } else if (imeiField.startsWith("id=")) {
            imei = imeiField.substring(3).trim();
        }
        if (StringTools.isBlank(imei)) {
            Print.logError("Missing IMEI/MobileID", new Object[0]);
            return null;
        }
        byte[] ackPkt = null;
        int ackPos = dataField.indexOf(GS818_ACK);
        if (ackPos >= 0) {
            int ackS = ackPos + GS818_ACK.length();
            int ackE = ackS + 4;
            if (ackE > dataField.length()) {
                ackE = dataField.length();
            }
            String serialNum = dataField.substring(ackS, ackE);
            String ackStr = "@PCack," + imei + "," + serialNum + "\r\n";
            Print.logInfo("ACK Packet: " + ackStr.trim(), new Object[0]);
            ackPkt = ackStr.getBytes();
        }
        this.device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), imei);
        if (this.device == null) {
            return ackPkt;
        }
        String accountID = this.device.getAccountID();
        String deviceID = this.device.getDeviceID();
        Print.logInfo("UniqueID  : " + this.device.getUniqueID(), new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        this.dataXPort = this.device.getDataTransport();
        if (this.hasIPAddress() && !this.dataXPort.isValidIPAddress(this.getIPAddress())) {
            DTIPAddrList validIPAddr = this.dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.getIPAddress() + " [expecting " + validIPAddr + "]", new Object[0]);
            return ackPkt;
        }
        this.dataXPort.setIpAddressCurrent(this.getIPAddress());
        this.dataXPort.setRemotePortCurrent(this.getRemotePort());
        this.dataXPort.setListenPortCurrent(this.getLocalPort());
        this.dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!this.dataXPort.getDeviceCode().equalsIgnoreCase("sanav")) {
            this.dataXPort.setDeviceCode("sanav");
        }
        long fixtime = 0L;
        boolean validGPS = false;
        double latitude = 0.0;
        double longitude = 0.0;
        GeoPoint geoPoint = GeoPoint.INVALID_GEOPOINT;
        long gpsAge = 0L;
        double speedKPH = 0.0;
        double headingDeg = 0.0;
        double altitudeM = 0.0;
        double odomKM = 0.0;
        int statusCode = 61472;
        double batteryV = 0.0;
        long gpioInput = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        int RSSI = 0;
        double analog1 = 0.0;
        double analog2 = 0.0;
        double boardTempC = 0.0;
        CellTower[] cellTower = null;
        if (!fmiField.equalsIgnoreCase("OK") && !fmiField.equalsIgnoreCase("FAIL") && fmiField.startsWith("FMI=")) {
            byte DLE = 16;
            byte[] fmiB = StringTools.parseHex(fmiField.substring(4), null);
            if (ListTools.size(fmiB) >= 6) {
                byte[] fmiBU = new byte[fmiB.length];
                int fmiBULen = 0;
                fmiBU[fmiBULen++] = fmiB[0];
                for (int i = 1; i < fmiB.length - 2; ++i) {
                    fmiBU[fmiBULen++] = fmiB[i];
                    if (fmiB[i] != DLE) continue;
                    if (fmiB[i + 1] == DLE) {
                        ++i;
                        continue;
                    }
                    Print.logWarn("Expected DLE, found 0x" + StringTools.toHexString(fmiB[i + 1]), new Object[0]);
                }
                fmiBU[fmiBULen++] = fmiB[fmiB.length - 2];
                fmiBU[fmiBULen++] = fmiB[fmiB.length - 1];
                Print.logInfo("FMI Packet: 0x" + StringTools.toHexString(fmiBU), new Object[0]);
                Payload fmi = new Payload(fmiBU, 0, fmiBULen);
                byte DLE_1 = (byte)fmi.readUInt(1, 0, "FMI:DLE-1");
                int pktID = fmi.readUInt(1, 0, "FMI:PacketID");
                int pktLen = fmi.readUInt(1, 0, "FMI:PackeLen");
                byte[] pktData = fmi.readBytes(pktLen, "FMI:Data");
                int chksum = fmi.readUInt(1, 0, "FMI:ChkSum");
                byte DLE_2 = (byte)fmi.readUInt(1, 0, "FMI:DLE-2");
                byte EOT = (byte)fmi.readUInt(1, 0, "FMI:EOT");
                if (fmi.getAvailableReadLength() > 0) {
                    Print.logWarn("Unexpected bytes remaining in FMI payload: " + fmi.getAvailableReadLength(), new Object[0]);
                } else if (DLE_1 != DLE || DLE_2 != DLE || EOT != 3) {
                    Print.logWarn("Unexpected FMI packet framing", new Object[0]);
                }
            } else {
                Print.logWarn("Unexpected FMI packet length: 0x" + StringTools.toHexString(fmiB), new Object[0]);
            }
        }
        if (dataField.startsWith("rmc=")) {
            Nmea0183 gprmc = null;
            String gprmcStr = dataField.substring(4);
            if (gprmcStr.startsWith("$GPRMC")) {
                gprmc = new Nmea0183(gprmcStr, true);
            } else if (gprmcStr.startsWith("GPRMC")) {
                gprmc = new Nmea0183("$" + gprmcStr, true);
            } else {
                Print.logError("Missing '$GPRMC'", new Object[0]);
                return ackPkt;
            }
            fixtime = gprmc.getFixtime();
            validGPS = gprmc.isValidGPS();
            latitude = validGPS ? gprmc.getLatitude() : 0.0;
            longitude = validGPS ? gprmc.getLongitude() : 0.0;
            geoPoint = new GeoPoint(latitude, longitude);
            speedKPH = validGPS ? gprmc.getSpeedKPH() : 0.0;
            headingDeg = validGPS ? gprmc.getHeading() : 0.0;
            String[] extraData = gprmc.getExtraData();
            if (!ListTools.isEmpty(extraData)) {
                Print.logInfo("Extra data: " + StringTools.join(extraData, ','), new Object[0]);
                if (extraData[0].length() > 0 && Character.isDigit(extraData[0].charAt(0))) {
                    batteryV = StringTools.parseDouble(extraData[0], 0.0) / 1000.0;
                    statusCode = extraData.length > 1 ? this.parseStatusCode(extraData[1]) : 61472;
                } else {
                    int ep = extraData[0].indexOf(45);
                    String stat = ep >= 0 ? extraData[0].substring(0, ep) : extraData[0];
                    String batt = ep >= 0 ? extraData[0].substring(ep + 1) : null;
                    statusCode = this.parseStatusCode(stat);
                    batteryV = StringTools.parseDouble(batt, 0.0) / 1000.0;
                    gpioInput = extraData.length > 1 ? StringTools.parseHexLong(extraData[1], 0L) : 0L;
                    HDOP = extraData.length > 2 ? StringTools.parseDouble(extraData[2], 0.0) : 0.0;
                    int n = numSats = extraData.length > 3 ? StringTools.parseInt(extraData[3], 0) : 0;
                    if (extraData.length > 39) {
                        Vector<CellTower> ctList = new Vector<CellTower>();
                        int c2 = 4;
                        int x2 = 0;
                        while (c2 <= 34) {
                            int MCC = extraData.length > c2 + 0 ? StringTools.parseInt(extraData[c2 + 0], 0) : 0;
                            int MNC = extraData.length > c2 + 1 ? StringTools.parseInt(extraData[c2 + 1], 0) : 0;
                            int LAC = extraData.length > c2 + 2 ? StringTools.parseHexInt(extraData[c2 + 2], 0) : 0;
                            int CID = extraData.length > c2 + 3 ? StringTools.parseHexInt(extraData[c2 + 3], 0) : 0;
                            int RxL = extraData.length > c2 + 4 ? StringTools.parseInt(extraData[c2 + 4], 0) : 0;
                            ctList.add(new CellTower(MCC, MNC, -1, CID, LAC, -1, RxL));
                            c2 += 5;
                            ++x2;
                        }
                        if (ctList.size() > 0) {
                            int tav = extraData.length > 39 ? StringTools.parseInt(extraData[39], 0) : 0;
                            cellTower = ctList.toArray(new CellTower[ctList.size()]);
                            cellTower[0].setTimingAdvance(tav);
                        }
                    }
                    RSSI = extraData.length > 40 ? StringTools.parseInt(extraData[40], 0) : 0;
                    analog1 = extraData.length > 41 ? StringTools.parseDouble(extraData[41], 0.0) : 0.0;
                    analog2 = extraData.length > 42 ? StringTools.parseDouble(extraData[42], 0.0) : 0.0;
                    boardTempC = extraData.length > 43 ? StringTools.parseDouble(extraData[43], 0.0) : 0.0;
                    altitudeM = extraData.length > 44 ? StringTools.parseDouble(extraData[44], 0.0) : 0.0;
                }
            }
        } else if (dataField.startsWith("data=")) {
            String datas = dataField.substring(5);
            String[] fld = StringTools.split(datas, ',');
            fixtime = fld.length > 0 ? StringTools.parseLong(fld[0], 0L) : 0L;
            statusCode = fld.length > 1 ? this.parseStatusCode(fld[1]) : 61472;
            latitude = fld.length > 2 ? StringTools.parseDouble(fld[2], 0.0) : 0.0;
            longitude = fld.length > 3 ? StringTools.parseDouble(fld[3], 0.0) : 0.0;
            validGPS = GeoPoint.isValid(latitude, longitude);
            geoPoint = validGPS ? new GeoPoint(latitude, longitude) : GeoPoint.INVALID_GEOPOINT;
            speedKPH = fld.length > 4 && validGPS ? StringTools.parseDouble(fld[4], 0.0) : 0.0;
            headingDeg = fld.length > 5 && validGPS ? StringTools.parseDouble(fld[5], 0.0) : 0.0;
            altitudeM = fld.length > 6 && validGPS ? StringTools.parseDouble(fld[6], 0.0) : 0.0;
            gpsAge = fld.length > 7 && validGPS ? StringTools.parseLong(fld[7], 0L) : 0L;
            HDOP = fld.length > 8 && validGPS ? StringTools.parseDouble(fld[8], 0.0) : 0.0;
            numSats = fld.length > 9 && validGPS ? StringTools.parseInt(fld[9], 0) : 0;
        } else {
            Print.logError("Missing 'rmc='", new Object[0]);
            return ackPkt;
        }
        HashMap<String, Object> xtraFields = null;
        if (!StringTools.isBlank(xtraField)) {
            Map<Object, Object> xtraProp = new RTProperties(xtraField).getProperties();
            DBFactory<EventData> edFact = EventData.getFactory();
            xtraFields = new HashMap<String, Object>();
            for (Object key : xtraProp.keySet()) {
                String keyStr = key.toString();
                String valStr = StringTools.trim(xtraProp.get(key));
                DBField dbFld = edFact.getField(keyStr);
                if (dbFld != null && !dbFld.isPrimaryKey()) {
                    Object valObj = dbFld.parseStringValue(valStr);
                    if (valObj != null) {
                        xtraFields.put(keyStr, valObj);
                        continue;
                    }
                    Print.logWarn("EventData invalid column value: " + key + " ==> " + valStr, new Object[0]);
                    continue;
                }
                Print.logWarn("EventData column not supported: " + key, new Object[0]);
            }
        }
        double batteryLvl = TrackClientPacketHandler.CalcBatteryPercent(batteryV);
        if (!validGPS && USE_LAST_VALID_GPS && GeoPoint.isValid(lastLat = this.device.getLastValidLatitude(), lastLon = this.device.getLastValidLongitude())) {
            validGPS = true;
            latitude = lastLat;
            longitude = lastLon;
            geoPoint = new GeoPoint(latitude, longitude);
            gpsAge = fixtime - this.device.getLastGPSTimestamp();
            headingDeg = this.device.getLastValidHeading();
        }
        if (statusCode == 0) {
            statusCode = speedKPH > 0.0 ? 61714 : 61472;
        } else if (XLATE_LOCATON_INMOTION && statusCode == 61472 && speedKPH > 0.0) {
            statusCode = 61714;
        }
        Print.logInfo("Timestamp : " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GPS       : " + geoPoint + " [" + numSats + "] age=" + gpsAge, new Object[0]);
        Print.logInfo("Speed     : " + StringTools.format(speedKPH, "#0.0") + " kph " + headingDeg, new Object[0]);
        Print.logInfo("Altitude  : " + StringTools.format(altitudeM, "#0.0") + " meters", new Object[0]);
        Print.logInfo("Battery%  : " + batteryLvl * 100.0 + " %  [" + batteryV + " volts]", new Object[0]);
        Print.logInfo("gpioInput : 0x" + StringTools.toHexString(gpioInput, 16), new Object[0]);
        Print.logInfo("HDOP      : " + HDOP, new Object[0]);
        Print.logInfo("RSSI      : " + RSSI, new Object[0]);
        if (!ListTools.isEmpty(xtraFields)) {
            for (Object key : xtraFields.keySet()) {
                Print.logInfo((String)key + " : " + xtraFields.get(key), new Object[0]);
            }
        }
        if (!ListTools.isEmpty(cellTower)) {
            for (int ct = 0; ct < cellTower.length; ++ct) {
                Print.logInfo("CellTower" + ct + ": " + cellTower[ct], new Object[0]);
            }
        }
        if (!validGPS && IGNORE_INVALID_GPS_EV) {
            if (statusCode == 61472) {
                Print.logWarn("Ignoring LOCATION event with invalid latitude/longitude", new Object[0]);
                return ackPkt;
            }
            if (statusCode == 63633 || statusCode == 63634) {
                Print.logWarn("Ignoring VIBRATION event with invalid latitude/longitude", new Object[0]);
                return ackPkt;
            }
        }
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        this.dataXPort.setIpAddressCurrent(this.getIPAddress());
        this.dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!this.dataXPort.getDeviceCode().equalsIgnoreCase("sanav")) {
            this.dataXPort.setDeviceCode("sanav");
        }
        if (this.device != null) {
            odomKM = this.device.calculateOdometerKM(odomKM, fixtime, validGPS, geoPoint, ESTIMATE_ODOMETER, true);
        }
        if (SIMEVENT_GEOZONES && validGPS && this.device != null && (zone = this.device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                this.insertEventRecord(this.device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, gpsAge, HDOP, numSats, RSSI, gpioInput, batteryLvl, speedKPH, headingDeg, altitudeM, odomKM, analog1, analog2, boardTempC, cellTower, xtraFields);
                Print.logInfo("Geozone    : " + z, new Object[0]);
                if (z.getStatusCode() != statusCode) continue;
                Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(statusCode), new Object[0]);
                statusCode = -1;
            }
        }
        if (!(statusCode < 0 || statusCode == -1 || statusCode == 61472 && this.hasSavedEvents())) {
            if (statusCode != 61472) {
                this.insertEventRecord(this.device, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, RSSI, gpioInput, batteryLvl, speedKPH, headingDeg, altitudeM, odomKM, analog1, analog2, boardTempC, cellTower, xtraFields);
            } else if (validGPS && this.device != null && !this.device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                this.insertEventRecord(this.device, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, RSSI, gpioInput, batteryLvl, speedKPH, headingDeg, altitudeM, odomKM, analog1, analog2, boardTempC, cellTower, xtraFields);
            }
        }
        if (!DEBUG_MODE && this.device != null) {
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dbe) {
                Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
            }
        }
        return ackPkt;
    }

    private EventData createEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, int RSSI, long gpioInput, double batteryLevel, double speedKPH, double heading, double altitude, double odomKM, double analog1, double analog2, double tempC, CellTower[] cellTower, Map<String, Object> xtraFields) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSignalStrength(RSSI);
        evdb.setInputMask(gpioInput);
        evdb.setBatteryLevel(batteryLevel);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        evdb.setAnalog0(analog1);
        evdb.setAnalog1(analog2);
        evdb.setThermoAverage0(tempC);
        if (!ListTools.isEmpty(cellTower)) {
            evdb.setServingCellTower(cellTower[0]);
            for (int c = 1; c < cellTower.length; ++c) {
                evdb.setNeighborCellTower(c - 1, cellTower[c]);
            }
        }
        if (xtraFields != null) {
            for (String fld : xtraFields.keySet()) {
                Object val = xtraFields.get(fld);
                Print.logInfo("Saving field " + fld + " ==> " + val, new Object[0]);
                evdb.setFieldValue(fld, val);
                Print.logInfo("Entity ID 1): " + evdb.getEntityID(), new Object[0]);
            }
        }
        return evdb;
    }

    private void insertEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, int RSSI, long gpioInput, double batteryLevel, double speedKPH, double heading, double altitude, double odomKM, double analog1, double analog2, double tempC, CellTower[] cellTower, Map<String, Object> xtraFields) {
        EventData evdb = this.createEventRecord(device, fixtime, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, RSSI, gpioInput, batteryLevel, speedKPH, heading, altitude, odomKM, analog1, analog2, tempC, cellTower, xtraFields);
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        device.insertEventData(evdb);
        this.incrementSavedEventCount();
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            SAVE_SESSION_STATISTICS = dcsc.getSaveSessionStatistics(SAVE_SESSION_STATISTICS);
            USE_LAST_VALID_GPS = dcsc.getUseLastValidGPSLocation(USE_LAST_VALID_GPS);
            IGNORE_INVALID_GPS_EV = dcsc.getIgnoreEventsWithInvalidGPS(IGNORE_INVALID_GPS_EV);
            TCP_PACKET_LENGTH_EOS = dcsc.getBooleanProperty("sanav.tcpPacketLengthEndOfStream", TCP_PACKET_LENGTH_EOS);
        }
    }
}

