/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.servers.sanav;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBAdmin;
import org.opengts.extra.servers.sanav.TrackClientPacketHandler;
import org.opengts.extra.servers.sanav.TrackServer;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_TCP_PORT = new String[]{"tcp", "p", "port"};
    public static final String[] ARG_UDP_PORT = new String[]{"udp", "p", "port"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "sanav";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName());
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int getCommandDispatcherPort() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getCommandDispatcherPort();
        }
        return RTConfig.getInt(ARG_CMD_PORT, 0);
    }

    public static String getUniqueIDPrefixList() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            return DCServerFactory.getUniquePrefixString(dcsc.getUniquePrefix());
        }
        return "";
    }

    private static void usage(String msg) {
        String tcp = StringTools.join(Main.getTcpPorts(), ",");
        String udp = StringTools.join(Main.getUdpPorts(), ",");
        if (msg != null) {
            Print.logInfo(msg, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + StringTools.className(Main.class) + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]           Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", new Object[0]);
        Print.logInfo("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + tcp + "]", new Object[0]);
        Print.logInfo("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + udp + "]", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        String SEP = "--------------------------------------------------------------------------";
        Print.logInfo(SEP, new Object[0]);
        Print.logInfo("Sanav TCP/UDP", new Object[0]);
        Print.logInfo("Version: 0.2.16", new Object[0]);
        Print.logInfo("Copyright 2007-2013, GeoTelematic Solutions, Inc.", new Object[0]);
        Print.logInfo(SEP, new Object[0]);
        Print.logInfo("Minimum speed      : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH + " km/h", new Object[0]);
        Print.logInfo("Estimating Odometer: " + TrackClientPacketHandler.ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("Simulating Geozone : " + TrackClientPacketHandler.SIMEVENT_GEOZONES, new Object[0]);
        Print.logInfo("Memory Usage [Mb]  : " + OSTools.getMemoryUsageStringMb(), new Object[0]);
        Print.logInfo(SEP, new Object[0]);
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                int[] tcpPorts = Main.getTcpPorts();
                int[] udpPorts = Main.getUdpPorts();
                int commandPort = Main.getCommandDispatcherPort();
                TrackServer.startTrackServer(tcpPorts, udpPorts, commandPort);
            }
            catch (Throwable t) {
                Print.logError("Error: " + t, new Object[0]);
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
    }
}

