/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.servers.sanav;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.extra.servers.sanav.Main;
import org.opengts.extra.servers.sanav.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class CommandHandler
extends CommandPacketHandler {
    @Override
    public String getServerName() {
        return "sanav";
    }

    public int getClientCommandPort_udp(int dftPort) {
        DCServerConfig dcsc = Main.getServerConfig();
        int port = dcsc.getClientCommandPort_udp(0);
        return port > 0 ? port : dftPort;
    }

    private byte[] createPacket(Device device, String cmdName, DCServerConfig.CommandProtocol cmdProto, String cmdStr) {
        return null;
    }

    @Override
    public DCServerFactory.ResultCode handleCommand(Device device, String cmdType, String cmdName, String[] cmdArgs) {
        Print.logInfo("Received Command: type=%s name=%s arg=%s", cmdType, cmdName, StringTools.join(cmdArgs, ','));
        if (device == null) {
            return DCServerFactory.ResultCode.INVALID_DEVICE;
        }
        if (cmdType.equalsIgnoreCase("ping")) {
            cmdType = "config";
            cmdName = "LocateNow";
        }
        if (!cmdType.equalsIgnoreCase("config")) {
            return DCServerFactory.ResultCode.INVALID_TYPE;
        }
        DCServerConfig dcsc = Main.getServerConfig();
        DCServerConfig.Command command = dcsc.getCommand(cmdName);
        if (command == null) {
            Print.logWarn("Command not found: " + cmdName, new Object[0]);
            return DCServerFactory.ResultCode.INVALID_COMMAND;
        }
        String cmdStr = command.getCommandString(device, cmdArgs);
        Print.logInfo("CmdStr: " + cmdStr, new Object[0]);
        DCServerConfig.CommandProtocol cmdProto = command.getCommandProtocol(DCServerConfig.CommandProtocol.UDP);
        if (cmdProto == null) {
            return DCServerFactory.ResultCode.INVALID_PROTO;
        }
        if (!cmdProto.equals(DCServerConfig.CommandProtocol.UDP)) {
            return DCServerFactory.ResultCode.INVALID_PROTO;
        }
        Print.logDebug("Command [device=%s, cmd=%s]", device.getDeviceID(), cmdName);
        byte[] packet = this.createPacket(device, cmdName, cmdProto, cmdStr);
        if (ListTools.isEmpty(packet)) {
            return DCServerFactory.ResultCode.INVALID_PACKET;
        }
        DCServerFactory.ResultCode cmdResp = DCServerFactory.ResultCode.INVALID_PROTO;
        switch (cmdProto) {
            case UDP: {
                cmdResp = this.sendCommandPacket_udp(device, cmdType, packet);
                break;
            }
            case SMS: {
                cmdResp = this.sendCommandPacket_sms(device, cmdType, packet);
                break;
            }
            case TCP: {
                cmdResp = DCServerFactory.ResultCode.INVALID_PROTO;
            }
        }
        command.setDeviceCommandAttributes(cmdResp, device, cmdStr, true);
        return cmdResp;
    }

    private DCServerFactory.ResultCode sendCommandPacket_sms(Device device, String cmdType, byte[] pktData) {
        if (ListTools.isEmpty(pktData)) {
            Print.logError("Command packet is null/empty (%s)", cmdType);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        String pktStr = StringTools.toStringValue(pktData);
        String smsEmail = device.getSmsEmail();
        if (StringTools.isBlank(smsEmail)) {
            Print.logError("Device SMS Email address is blank: " + device.getDeviceID(), new Object[0]);
            return DCServerFactory.ResultCode.NOT_SUPPORTED;
        }
        return DCServerFactory.ResultCode.INVALID_PROTO;
    }

    private DCServerFactory.ResultCode sendCommandPacket_udp(Device device, String cmdType, byte[] pktData) {
        if (ListTools.isEmpty(pktData)) {
            Print.logError("Command packet is null/empty (%s)", cmdType);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        int frPort = device.getListenPortCurrent();
        String toHost = StringTools.trim(device.getIpAddressCurrent());
        int toPort = this.getClientCommandPort_udp(device.getRemotePortCurrent());
        long age = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        if (StringTools.isBlank(toHost) || toHost.equals("0.0.0.0") || toPort <= 0) {
            Print.logError("Device host:port not known> %s:%d", toHost, toPort);
            return DCServerFactory.ResultCode.UNKNOWN_HOST;
        }
        Print.logInfo("Send '%s:%d' (age %dsec) [%s] 0x%s", toHost, toPort, age, cmdType, StringTools.toHexString(pktData));
        try {
            this.sendDatagramMessage(frPort, toHost, toPort, pktData);
            return DCServerFactory.ResultCode.SUCCESS;
        }
        catch (Throwable th) {
            Print.logException("UDP transmit failure", th);
            return DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
    }

    private void sendDatagramMessage(int frPort, String toHost, int toPort, byte[] pkt) throws IOException {
        boolean closeSocket = false;
        DatagramSocket dgSocket = TrackServer.getTrackServer().getUdpDatagramSocket(frPort);
        if (dgSocket == null) {
            Print.logWarn("Creating temporary DatagramSocket for transmission", new Object[0]);
            dgSocket = ServerSocketThread.createDatagramSocket(0);
            closeSocket = true;
        }
        DatagramPacket respPkt = new DatagramPacket(pkt, pkt.length, InetAddress.getByName(toHost), toPort);
        Print.logInfo("Sending Datagram(from %d) to %s:%d> 0x%s", dgSocket.getLocalPort(), toHost, toPort, StringTools.toHexString(pkt));
        dgSocket.send(respPkt);
        if (closeSocket) {
            dgSocket.close();
        }
    }

    public static void main(String[] args) {
        RTConfig.setCommandLineArgs(args);
        CommandHandler ech = new CommandHandler();
    }
}

