/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.opengts.util.FileTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class MergeLocalStrings {
    private static final String LOCALSTRINGS_EN_PROPERTIES = "LocalStrings_en.properties";
    private File locale_en_props = null;
    private String[] enFileStrArry = null;
    private MergeItem[] mergeItems = null;
    private static FileFilter localStringsFilter = null;
    private static final String[] ARG_SCAN = new String[]{"scan"};
    private static final String[] ARG_MERGE = new String[]{"merge"};

    public MergeLocalStrings(File enFile, File[] xxFile) throws IOException {
        this.locale_en_props = enFile;
        if (this.locale_en_props == null || !this.locale_en_props.isFile()) {
            throw new FileNotFoundException("LocalStrings_en.properties not found: " + this.locale_en_props);
        }
        String enFilePath = this.locale_en_props.getParent();
        String enFileName = this.locale_en_props.getName();
        if (enFilePath == null || !enFileName.equals(LOCALSTRINGS_EN_PROPERTIES)) {
            throw new IOException("Invalid 'LocalStrings_en.properties' filename: " + this.locale_en_props);
        }
        if (xxFile == null || xxFile.length == 0) {
            throw new FileNotFoundException("'LocalStrings_XX.properties' files not specified");
        }
        byte[] enFileData = FileTools.readFile(this.locale_en_props);
        if (enFileData == null) {
            throw new IOException("Invalid 'LocalStrings_en.properties' file: " + this.locale_en_props);
        }
        this.enFileStrArry = StringTools.split(StringTools.toStringValue(enFileData), '\n');
        this.mergeItems = new MergeItem[xxFile.length];
        for (int i = 0; i < xxFile.length; ++i) {
            if (xxFile[i] == null) {
                throw new FileNotFoundException("Invalid 'LocalStrings_XX.properties' file: " + xxFile[i]);
            }
            String xxFilePath = xxFile[i].getParent();
            String xxFileName = xxFile[i].getName();
            if (xxFilePath == null || !xxFileName.startsWith("LocalStrings_") || !xxFileName.endsWith(".properties")) {
                throw new IOException("Invalid 'LocalStrings_XX.properties' filename: " + xxFile[i]);
            }
            File xxFile_old = new File(xxFile[i].toString() + ".old");
            if (xxFile_old.exists()) {
                throw new IOException("Old 'LocalStrings_XX.properties' already exists: " + xxFile_old);
            }
            if (!enFilePath.equals(xxFilePath)) {
                throw new IOException("Invalid 'LocalStrings_XX.properties' filename: " + xxFile[i]);
            }
            this.mergeItems[i] = new MergeItem(xxFile[i], enFileName, this.enFileStrArry);
        }
    }

    public boolean hasChanged() {
        if (this.mergeItems != null) {
            for (int i = 0; i < this.mergeItems.length; ++i) {
                if (!this.mergeItems[i].hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean save() throws IOException {
        if (this.mergeItems == null) {
            throw new IOException("Nothing to save");
        }
        if (!this.hasChanged()) {
            return false;
        }
        for (int i = 0; i < this.mergeItems.length; ++i) {
            this.mergeItems[i].save();
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("English: ");
        sb.append(this.locale_en_props);
        if (this.mergeItems != null) {
            for (int i = 0; i < this.mergeItems.length; ++i) {
                sb.append("\n");
                MergeItem mi = this.mergeItems[i];
                sb.append("  --> ");
                sb.append(mi.getFile());
                if (!mi.hasChanged()) continue;
                sb.append(" [changed]");
            }
        }
        return sb.toString();
    }

    protected static FileFilter getLocalStringsFilter() {
        if (localStringsFilter == null) {
            localStringsFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.isFile()) {
                        String name = file.getName();
                        return name.startsWith("LocalStrings_") && name.endsWith(".properties");
                    }
                    return false;
                }
            };
        }
        return localStringsFilter;
    }

    protected static boolean _findMergeItems(File subDir, List<MergeLocalStrings> mergeList) throws IOException {
        boolean ok = true;
        if (!subDir.isDirectory()) {
            return ok;
        }
        FileFilter filter = MergeLocalStrings.getLocalStringsFilter();
        File[] filesInSubdir = subDir.listFiles(filter);
        if (filesInSubdir == null || filesInSubdir.length <= 0) {
            return ok;
        }
        boolean foundProps = false;
        File enFile = null;
        Vector<File> files = new Vector<File>();
        Vector<File> dirs = new Vector<File>();
        for (int i = 0; i < filesInSubdir.length; ++i) {
            File f = filesInSubdir[i];
            if (f.isFile()) {
                foundProps = true;
                if (f.getName().equals(LOCALSTRINGS_EN_PROPERTIES)) {
                    enFile = f;
                    continue;
                }
                files.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            dirs.add(f);
        }
        if (foundProps) {
            if (enFile != null) {
                File[] xxFile = files.toArray(new File[files.size()]);
                mergeList.add(new MergeLocalStrings(enFile, xxFile));
            } else {
                ok = false;
                Print.sysPrintln("*** MISSING: LocalStrings_en.properties", new Object[0]);
                for (File xxFile : files) {
                    Print.sysPrintln("   ==> " + xxFile + "  [skipped]", new Object[0]);
                }
            }
        }
        Iterator d = dirs.iterator();
        while (d.hasNext()) {
            if (MergeLocalStrings._findMergeItems((File)d.next(), mergeList)) continue;
            ok = false;
        }
        return ok;
    }

    protected static List findMergeItems(File subDir) throws IOException {
        Vector<MergeLocalStrings> mergeItems = new Vector<MergeLocalStrings>();
        if (MergeLocalStrings._findMergeItems(subDir, mergeItems)) {
            return mergeItems;
        }
        return null;
    }

    public static void main(String[] argv) {
        List list;
        File scanDir;
        RTConfig.setCommandLineArgs(argv);
        if (RTConfig.hasProperty(ARG_SCAN)) {
            try {
                scanDir = RTConfig.getFile(ARG_SCAN, new File("."));
                list = MergeLocalStrings.findMergeItems(scanDir);
                if (list != null) {
                    Print.sysPrintln("", new Object[0]);
                    for (MergeLocalStrings mls : list) {
                        Print.sysPrintln(mls.toString(), new Object[0]);
                        Print.sysPrintln("", new Object[0]);
                    }
                }
            }
            catch (IOException ioe) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("Scan error: " + ioe.getMessage(), new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty(ARG_MERGE)) {
            try {
                scanDir = RTConfig.getFile(ARG_MERGE, new File("."));
                list = MergeLocalStrings.findMergeItems(scanDir);
                if (list != null) {
                    for (MergeLocalStrings mls : list) {
                        Print.sysPrintln(mls.toString(), new Object[0]);
                        mls.save();
                        Print.sysPrintln("", new Object[0]);
                    }
                }
            }
            catch (IOException ioe) {
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("Merge error: " + ioe.getMessage(), new Object[0]);
            }
            System.exit(0);
        }
        Print.sysPrintln("Missing options:", new Object[0]);
        Print.sysPrintln("  -scan=<sourceDir>      Display list of LocalStrings_XX.properties files", new Object[0]);
        Print.sysPrintln("  -merge=<sourceDir>     Merged/save LocalStrings_XX.properties files", new Object[0]);
        Print.sysPrintln("Notes:", new Object[0]);
        Print.sysPrintln("  1) Scan/Merge process will terminate if any errors are encountered", new Object[0]);
    }

    protected class MergeItem {
        private File xxFile = null;
        private String xxFileString_old = null;
        private String xxFileString_new = null;

        public MergeItem(File xx, String enFileName, String[] mergeProps) throws IOException {
            this.xxFile = xx;
            byte[] xxFileData_old = FileTools.readFile(this.xxFile);
            this.xxFileString_old = xxFileData_old != null ? StringTools.toStringValue(xxFileData_old) : null;
            Properties xxProps = new Properties();
            if (this.xxFile.exists()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(this.xxFile);
                    xxProps.load(fis);
                }
                catch (IOException ioe) {
                    Print.logError("Locale read error: " + ioe, new Object[0]);
                    throw ioe;
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable th) {}
                }
            }
            String[] xxFileStrArry = new String[mergeProps.length];
            for (int i = 0; i < xxFileStrArry.length; ++i) {
                xxFileStrArry[i] = mergeProps[i];
                int p = xxFileStrArry[i].indexOf(enFileName);
                if (p < 0) continue;
                String e = xxFileStrArry[i];
                xxFileStrArry[i] = e.substring(0, p) + this.xxFile.getName() + e.substring(p + enFileName.length());
            }
            Enumeration<?> e = xxProps.propertyNames();
            while (e.hasMoreElements()) {
                String propKey = (String)e.nextElement();
                String propVal = StringTools.replace(xxProps.getProperty(propKey), "\n", "\\n");
                if (propVal == null) continue;
                String enk = "#" + propKey + "=";
                for (int i = 0; i < xxFileStrArry.length; ++i) {
                    if (!xxFileStrArry[i].startsWith(enk)) continue;
                    xxFileStrArry[i] = propKey + "=" + propVal;
                }
            }
            this.xxFileString_new = StringTools.join(xxFileStrArry, '\n') + "\n";
        }

        public File getFile() {
            return this.xxFile;
        }

        public boolean hasChanged() {
            if (this.xxFileString_new == null) {
                return false;
            }
            return this.xxFileString_old == null || !this.xxFileString_old.equals(this.xxFileString_new);
        }

        public boolean save() throws IOException {
            if (this.xxFileString_new == null) {
                throw new IOException("No new 'LocalStrings_XX.properties' data to save");
            }
            if (!this.hasChanged()) {
                return false;
            }
            File xxFile_old = new File(this.xxFile.toString() + ".old");
            if (xxFile_old.exists()) {
                throw new IOException("Old 'LocalStrings_XX.properties' already exists: " + xxFile_old);
            }
            if (!this.xxFile.renameTo(xxFile_old)) {
                throw new IOException("Unable to rename 'LocalStrings_XX.properties' file: " + this.xxFile);
            }
            if (!xxFile_old.exists()) {
                throw new IOException("Renamed, but 'LocalStrings_XX.properties.old' does not exist: " + xxFile_old);
            }
            if (this.xxFile.exists()) {
                throw new IOException("Renamed, but 'LocalStrings_XX.properties' still exist: " + this.xxFile);
            }
            byte[] xxFileData_new = this.xxFileString_new.getBytes();
            FileTools.writeFile(xxFileData_new, this.xxFile);
            Print.logInfo("Saved: " + this.xxFile, new Object[0]);
            return true;
        }

        public String toString() {
            return this.xxFileString_new != null ? this.xxFileString_new : "";
        }
    }
}

