/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.tools;

import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Mac;
import org.opengts.cellid.MobileLocationProvider;
import org.opengts.cellid.MobileLocationProviderAdapter;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.GeneralPasswordHandler;
import org.opengts.db.PasswordHandler;
import org.opengts.db.PingDispatcher;
import org.opengts.db.RuleFactory;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.GeocodeProviderAdapter;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.IPTools;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.war.report.ReportConstraints;
import org.opengts.war.report.ReportFactory;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapProviderAdapter;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.PrivateLabelLoader;
import org.opengts.war.tools.PushpinIcon;

public class CheckInstall {
    private static final String ARG_privateLabelDetail = "privateLabelDetail";
    private static final String PFX = "    ";
    private static final String TRACK_CLASS_DIR = "./build/track/WEB-INF/classes";
    private static final int MAX_WIDTH = 100;
    private static final int WRAP_WIDTH = 85;
    private static boolean SHOW_REPORT_LIMITS = false;
    private static final long RECOMMENDED_MEMORY_MB = 4096L;
    private static final double THRESHOLD_DISK_UTIL = 0.9;
    private static final String[] PROP_skipDefaultEMailChecks = new String[]{"checkInstall.skipDefaultEMailChecks", "skipDefaultEMailChecks", "skipEMailChecks"};
    private static final String[] PROP_skipDefaultMapChecks = new String[]{"checkInstall.skipDefaultMapChecks", "skipDefaultMapChecks", "skipMapChecks"};
    private static final String[] PROP_skipDBRecordCount = new String[]{"checkInstall.skipDBRecordCount", "skipDBRecordCount", "noRecordCount"};
    private static final String ENVIRON_GTS_LINKS = "GTS_LINKS";
    private static final String ENVIRON_GTS_HOME = "GTS_HOME";
    private static final String ENVIRON_GTS_CONF = "GTS_CONF";
    private static final String ENVIRON_GTS_CHARSET = "GTS_CHARSET";
    private static final String ENVIRON_JAVA_HOME = "JAVA_HOME";
    private static final String ENVIRON_ANT_HOME = "ANT_HOME";
    private static final String ENVIRON_CATALINA_HOME = "CATALINA_HOME";
    private static final String ENVIRON_MYSQL_HOME = "MYSQL_HOME";
    private static final String ENVIRON_CLASSPATH = "CLASSPATH";
    private static final String ENVIRON_PATH = "PATH";
    private static final String REASON_DIR_NOT_EXIST = "Java '<File>.isDirectory()' returned false";
    private static final String REASON_FILE_NOT_EXIST = "Java '<File>.isFile()' returned false";
    private static final String REASON_SYSTEM_ERROR = "Possible internal system error";
    private static final String FIX_JAVA_VERSION = "Please install Sun Microsystems Java version 1.6 (ie. 'Java 6')";
    private static final String FIX_VALID_DIRECTORY = "Please specify a valid directory path";
    private static final String FIX_VALID_FILE = "Please specify a valid file path";
    private static final String FIX_PREVIOUS_ERRORS = "Fix previous errors, then re-run this installation check.";
    private static List<String[]> _errors = new Vector<String[]>();
    private static int warnCount = 0;
    private static List<String> warnList = new Vector<String>();
    private static OutputHandler outputHandler = null;
    private static final String LS_FILE_PFX = "  ";
    private static final String LS_ERROR_PFX = "    ==> ERROR: ";
    private static final String[] ARG_LOCAL_STRINGS = new String[]{"localStrings", "ls"};
    private static final String[] ARG_SEND_TEST_EMAIL = new String[]{"sendTestEmailTo", "sendMail", "sendEmail"};
    private static final String[] ARG_SMTP_PROPERTIES = new String[]{"smtpProperties", "smtp"};
    private static final String[] ARG_SEND_TEST_SMS = new String[]{"sendTestSmsTo", "sendSMS"};
    private static final String[] ARG_SHOW_REPORT_LIMIT = new String[]{"showReportLimit", "showReportLimits"};

    private static List<String[]> getErrors() {
        return _errors;
    }

    private static void clearErrors() {
        CheckInstall.getErrors().clear();
    }

    private static void addError(String error, String reason, String fix, boolean fatal) {
        if (fatal) {
            CheckInstall.getErrors().add(new String[]{error, reason, fix});
        } else {
            CheckInstall.getErrors().add(new String[]{error, reason, fix, "false"});
        }
    }

    private static void addError(String error, String reason, String fix) {
        CheckInstall.addError(error, reason, fix, true);
    }

    private static int warnCount() {
        return warnCount;
    }

    private static List<String> getWarnings() {
        return warnList;
    }

    private static int countWarning(String msg) {
        int wc = ++warnCount;
        warnList.add(wc + ") " + msg);
        return wc;
    }

    public static void setOutputHandler(final OutputHandler output) {
        if (output == null) {
            outputHandler = null;
            BasicPrivateLabelLoader.setOutputHandler(null);
        } else {
            outputHandler = output;
            BasicPrivateLabelLoader.setOutputHandler(new BasicPrivateLabelLoader.OutputHandler(){

                @Override
                public void privateLabelOutput(String s) {
                    output.checkInstallOutput(s);
                }
            });
        }
    }

    private static void println(String s) {
        if (outputHandler != null) {
            outputHandler.checkInstallOutput(s);
        } else {
            Print.sysPrintln(s, new Object[0]);
        }
    }

    private static void wrapPrintln(String s, char sep) {
        int pfxNdx = 0;
        while (Character.isWhitespace(s.charAt(pfxNdx))) {
            ++pfxNdx;
        }
        String prefix = s.substring(0, pfxNdx) + LS_FILE_PFX;
        while (s.length() > 85) {
            int ch;
            for (ch = 85; ch > 0 && s.charAt(ch) != sep; --ch) {
            }
            if (ch <= 0) break;
            CheckInstall.println(s.substring(0, ch + 1));
            s = prefix + s.substring(ch + 1).trim();
        }
        if (s.length() > 0) {
            CheckInstall.println(s);
        }
    }

    private static void printVariable(String name, Object val, Object note) {
        int tab = 22;
        CheckInstall.printVariable(name, val, note, tab);
    }

    private static void printVariable(String name, Object val, Object note, int tab) {
        String n;
        int len = 2 + tab + 5;
        String nameFmt = LS_FILE_PFX + StringTools.leftAlign(name, tab) + " ==> ";
        String v = val != null ? val.toString() : "";
        String string = n = note != null ? note.toString() : "";
        if (StringTools.isBlank(n)) {
            CheckInstall.println(nameFmt + v);
        } else if (StringTools.isBlank(v)) {
            CheckInstall.println(nameFmt + n);
        } else if (nameFmt.length() + v.length() + LS_FILE_PFX.length() + n.length() < 100) {
            CheckInstall.println(nameFmt + v + LS_FILE_PFX + n);
        } else {
            CheckInstall.println(nameFmt + v);
            CheckInstall.println(StringTools.replicateString(" ", len) + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File getEnvironmentFile(String name, boolean isDirectory, boolean errorIfMissing) {
        String val = null;
        try {
            val = System.getenv(name);
            if (StringTools.isBlank(val)) {
                if (errorIfMissing) {
                    CheckInstall.printVariable(name, "", "(ERROR: not defined)");
                    CheckInstall.addError("Environment variable '" + name + "' is not defined.", null, "Please define the specified environment variable");
                    return null;
                }
                CheckInstall.printVariable(name, "", "(NOTE: not defined)");
                return null;
            }
            if (val.indexOf("\"") >= 0 || val.indexOf("'") >= 0) {
                CheckInstall.printVariable(name, val, "(ERROR: contains quotes)");
                CheckInstall.addError("Directory specification '" + name + "' contains quote characters.", null, "Remove quotes from directory specification");
                return null;
            }
        }
        catch (Error err) {
            CheckInstall.printVariable(name, "", "(ERROR: error retrieving environment variable)");
            CheckInstall.addError("Error retrieving environment variable '" + name + "'.", "Possible invalid version of Java installed", FIX_JAVA_VERSION);
            return null;
        }
        File dir = new File(val);
        if (isDirectory) {
            if (!dir.isDirectory()) {
                if (FileTools.isCygwinSymlink(dir)) {
                    File cygLink = FileTools.getCygwinSymlinkFile(dir, true);
                    if (!FileTools.isDirectory(cygLink)) {
                        CheckInstall.printVariable(name, val, "(ERROR: Cygwin link - " + cygLink + ")");
                        CheckInstall.addError("Environment variable '" + name + "' specifies a Cygwin symbolic link.", "Directory appears to be a Cygwin symbolic link", "Please change environment value to a DOS absolute/canonical path");
                        return null;
                    }
                    dir = cygLink;
                } else {
                    if (!FileTools.isWindowsShortcut(dir)) {
                        CheckInstall.printVariable(name, val, "(ERROR: invalid directory)");
                        CheckInstall.addError("Environment variable '" + name + "' specifies an invalid directory.", REASON_DIR_NOT_EXIST, FIX_VALID_DIRECTORY);
                        return null;
                    }
                    File winLink = FileTools.getWindowsShortcutFile(dir, true);
                    if (!FileTools.isDirectory(winLink)) {
                        CheckInstall.printVariable(name, val, "(ERROR: Windows shortcut - " + winLink + ")");
                        CheckInstall.addError("Environment variable '" + name + "' specifies a Windows shortcut.", "Directory appears to be a Windows shortcut", "Please change environment value to a DOS absolute/canonical path");
                        return null;
                    }
                    dir = winLink;
                }
            }
        } else if (!dir.isFile()) {
            CheckInstall.printVariable(name, val, "(ERROR: invalid file)");
            CheckInstall.addError("Environment variable '" + name + "' specifies an invalid file.", REASON_FILE_NOT_EXIST, FIX_VALID_FILE);
            return null;
        }
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            CheckInstall.printVariable(name, val, "(ERROR: canonical error)");
            CheckInstall.addError("Error retrieving canonical directory for environment variable '" + name + "'.", REASON_SYSTEM_ERROR, null);
            return null;
        }
    }

    private static void printSystemProperties() {
        Properties props = System.getProperties();
        Enumeration<?> n = props.propertyNames();
        while (n.hasMoreElements()) {
            String key = (String)n.nextElement();
            String val = props.getProperty(key);
            CheckInstall.println(key + " ==> " + val);
        }
    }

    private static boolean isGtsClass(String className) {
        if (className.startsWith("org.opengts.rule.")) {
            return true;
        }
        if (className.startsWith("org.opengts.opt.")) {
            return true;
        }
        return className.startsWith("org.opengts.priv.");
    }

    private static String ClassName(Object clazz) {
        return CheckInstall.ClassName(StringTools.className(clazz));
    }

    private static String ClassName(String className) {
        if (CheckInstall.isGtsClass(className)) {
            return "GTS:" + className;
        }
        return className;
    }

    private static File getLikelyWindowsJDK(File path) {
        if (!OSTools.isWindows()) {
            return null;
        }
        File dir = null;
        if (path != null) {
            dir = path;
        } else if (FileTools.isDirectory("C:/Program Files/Java")) {
            dir = new File("C:/Program Files/Java");
        } else if (FileTools.isDirectory("C:/Program Files (x86)/Java")) {
            dir = new File("C:/Program Files (x86)/Java");
        } else {
            return null;
        }
        String[] fileList = ListTools.sort(dir.list());
        if (!ListTools.isEmpty(fileList)) {
            File jdkDirPath = null;
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].startsWith("jdk")) continue;
                jdkDirPath = new File(dir, fileList[i]);
            }
            return jdkDirPath;
        }
        return null;
    }

    private static void validateLocalStrings(File dir) {
        Print.sysPrintln("Verifying 'LocalStrings_XX.properties' files ...", new Object[0]);
        if (dir == null) {
            Print.sysPrintln("    ==> ERROR: Specified file/directory does not exist: null", new Object[0]);
        } else if (dir.isFile()) {
            int count = CheckInstall._validateLocalStrings(new File[]{dir}, null);
            if (count <= 0) {
                Print.sysPrintln("    ==> ERROR: Not a 'LocalStrings_XX.properties' file", new Object[0]);
            }
        } else if (dir.isDirectory()) {
            Print.sysPrintln("Directory: " + dir, new Object[0]);
            int count = CheckInstall._validateLocalStrings(new File[]{dir}, null);
            if (count <= 0) {
                Print.sysPrintln("    ==> ERROR: No LocalStrings files found", new Object[0]);
            }
        } else {
            Print.sysPrintln("    ==> ERROR: File/Directory does not exist: " + dir, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int _validateLocalStrings(File[] files, List<File> badPropFiles) {
        int i;
        int count = 0;
        boolean verbose = badPropFiles == null;
        for (i = 0; i < files.length; ++i) {
            String n;
            if (files[i] == null || !files[i].isFile() || !(n = files[i].getName()).startsWith("LocalStrings_") || !n.endsWith(".properties")) continue;
            ++count;
            if (verbose) {
                Print.sysPrintln(LS_FILE_PFX + files[i] + " ...", new Object[0]);
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(files[i]);
                Properties props = new Properties();
                props.load(fis);
            }
            catch (Throwable th) {
                if (badPropFiles != null) {
                    badPropFiles.add(files[i]);
                } else if (verbose) {
                    Print.sysPrintln(LS_ERROR_PFX + th.getMessage(), new Object[0]);
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
            try {
                byte[] data = FileTools.readFile(files[i]);
                if (data == null) continue;
                int line = 1;
                StringBuffer lineBuff = new StringBuffer();
                boolean badChar = false;
                for (int b = 0; b < data.length; ++b) {
                    int ch = data[b] & 0xFF;
                    if (ch == 10) {
                        if (badChar) {
                            Print.sysPrintln("    ==> ERROR: Invalid characters at line #" + line, new Object[0]);
                        }
                        badChar = false;
                        lineBuff.setLength(0);
                        ++line;
                        continue;
                    }
                    if (ch == 13) continue;
                    if (ch == 9) {
                        lineBuff.append((char)ch);
                        continue;
                    }
                    if (ch >= 32 && ch <= 126) {
                        lineBuff.append((char)ch);
                        continue;
                    }
                    badChar = true;
                }
                continue;
            }
            catch (Throwable th) {
                if (badPropFiles != null) {
                    badPropFiles.add(files[i]);
                    continue;
                }
                if (!verbose) continue;
                Print.sysPrintln(LS_ERROR_PFX + th.getMessage(), new Object[0]);
                continue;
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].isDirectory()) continue;
            File[] subFiles = ListTools.sort(files[i].listFiles(), null);
            count += CheckInstall._validateLocalStrings(subFiles, badPropFiles);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String gtsHomeStr;
        String waStartupInitClass;
        int WC;
        String memStr;
        String usage;
        String freMb;
        String useMb;
        String totMb;
        double _usage;
        double _free;
        double _used;
        double _tot;
        int digLen;
        String fmt;
        String saKeyKey;
        RTConfig.setWebApp(true);
        BasicPrivateLabelLoader.setTrackServlet_debugOnly();
        DBConfig.cmdLineInit(argv, true);
        Print.setLogLevel(3, false, false);
        boolean isEnterprise = DBConfig.hasExtraPackage();
        boolean isWindows = OSTools.isWindows();
        StringBuffer recommendations = new StringBuffer();
        File configDir = RTConfig.getLoadedConfigDir();
        if (RTConfig.hasProperty(ARG_LOCAL_STRINGS)) {
            File dir = RTConfig.getFile(ARG_LOCAL_STRINGS, null);
            CheckInstall.validateLocalStrings(dir);
            System.exit(0);
        }
        SHOW_REPORT_LIMITS = RTConfig.getBoolean(ARG_SHOW_REPORT_LIMIT, SHOW_REPORT_LIMITS);
        String sendTestEmailTo = RTConfig.getString(ARG_SEND_TEST_EMAIL, null);
        String smtpPropBPL = RTConfig.getString(ARG_SMTP_PROPERTIES, null);
        String sendTestSMSTo = RTConfig.getString(ARG_SEND_TEST_SMS, null);
        File env_GTS_LINKS = null;
        File env_GTS_HOME = null;
        File env_GTS_CONF = null;
        File env_JAVA_HOME = null;
        File env_ANT_HOME = null;
        File env_CATALINA_HOME = null;
        CheckInstall.clearErrors();
        CheckInstall.println("");
        int sepWidth = 85;
        String eqSep = StringTools.replicateString("=", sepWidth);
        if (RTConfig.hasProperty("props")) {
            CheckInstall.printSystemProperties();
            System.exit(0);
        }
        CheckInstall.println(eqSep);
        if (RTConfig.hasProperty("ServiceAccount.ID")) {
            String srvID = DBConfig.getServiceAccountID("?");
            String srvName = DBConfig.getServiceAccountName("?");
            CheckInstall.println("Service Account: [" + srvID + "] " + srvName);
            CheckInstall.println(eqSep);
        }
        CheckInstall.println("");
        CheckInstall.println(isEnterprise ? "GTS Enterprise:" : "OpenGTS:");
        CheckInstall.printVariable("(Version)", DBConfig.getVersion(), isEnterprise ? "(enterprise)" : "");
        CheckInstall.printVariable("(Compiled Time)", new DateTime(1415031708L).toString(), "");
        CheckInstall.printVariable("(Current Time)", new DateTime().toString(), "");
        String userName = System.getProperty("user.name", "?");
        if (userName.equalsIgnoreCase("root")) {
            CheckInstall.printVariable("(Current User)", userName, "(ERROR: should not be 'root')");
            CheckInstall.addError("This application is being run as superuser 'root'.", "This application should be run under a user other than 'root'.", "Change to a different user when running GTS/OpenGTS.");
        } else {
            CheckInstall.printVariable("(Current User)", userName, "");
        }
        String saIDKey = "ServiceAccount.ID";
        CheckInstall.printVariable(saIDKey, RTConfig.getString(saIDKey, "?"), "");
        String saNameKey = "ServiceAccount.Name";
        CheckInstall.printVariable(saNameKey, RTConfig.getString(saNameKey, "?"), "");
        String saTypeKey = "ServiceAccount.Attr";
        if (RTConfig.hasProperty(saTypeKey)) {
            CheckInstall.printVariable(saTypeKey, RTConfig.getString(saTypeKey, "?"), "");
        }
        if (RTConfig.hasProperty(saKeyKey = "ServiceAccount.Key")) {
            CheckInstall.printVariable(saKeyKey, RTConfig.getString(saKeyKey, "?"), "");
        }
        CheckInstall.println("");
        CheckInstall.println("System Information:");
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            InetAddress hostIP = InetAddress.getByName(hostName);
            String hostIPStr = hostIP != null ? hostIP.toString() : "";
            int h = hostIPStr.indexOf("/");
            if (h >= 0) {
                hostIPStr = hostIPStr.substring(h + 1).trim();
            }
            CheckInstall.printVariable("(Hostname)", hostName, "[" + hostIPStr + "]");
        }
        catch (UnknownHostException uhe) {
            String hostName = uhe.getMessage().trim();
            int h = hostName.lastIndexOf(":");
            if (h >= 0) {
                hostName = hostName.substring(h + 1).trim();
            }
            CheckInstall.printVariable("(Hostname)", "(" + hostName + ")", "(ERROR: unable to resolve local host name)");
            CheckInstall.addError("Unable to resolve local host name '" + hostName + "'.", "Specified host name may be missing from the '/etc/hosts' file.", "Add '" + hostName + "' to localhost entries in '/etc/hosts' file.");
        }
        String osArchKey = "os.arch";
        CheckInstall.printVariable(osArchKey, System.getProperty(osArchKey, "?"), "");
        String osNameKey = "os.name";
        CheckInstall.printVariable(osNameKey, System.getProperty(osNameKey, "?"), "");
        String osVersKey = "os.version";
        CheckInstall.printVariable(osVersKey, System.getProperty(osVersKey, "?"), "");
        File issueFile = new File("/etc/issue");
        if (issueFile.isFile()) {
            String issue = StringTools.toStringValue(FileTools.readFile(issueFile));
            String[] I = StringTools.parseStringArray(issue, "\r\n");
            CheckInstall.printVariable(issueFile.toString(), I[0], "");
        }
        OSTools.MemoryUsage sysMem = OSTools.getSystemMemoryUsage(null);
        OSTools.DiskUsage sysDisk = OSTools.getSystemDiskUsage(configDir, null);
        if (sysMem != null) {
            fmt = "0";
            digLen = sysMem.getTotalFieldLength(0x100000L, sysDisk) + fmt.length() - 1;
            Print.sysPrintln("MemoryUsage digLen: " + digLen, new Object[0]);
            _tot = sysMem.getTotal_Mb();
            _used = sysMem.getUsed_Mb();
            _free = sysMem.getFree_Mb();
            _usage = sysMem.getUsage();
            totMb = StringTools.format(_tot, fmt);
            useMb = StringTools.format(_used, fmt);
            freMb = StringTools.format(_free, fmt);
            usage = String.valueOf(Math.round(_usage * 100.0)) + "%";
            totMb = StringTools.rightAlign(totMb, digLen);
            useMb = StringTools.rightAlign(useMb, digLen);
            freMb = StringTools.rightAlign(freMb, digLen);
            memStr = "Total:" + totMb + "  Used:" + useMb + " [" + usage + "]" + "  Free:" + freMb;
            if (_tot < 4095.0) {
                WC = CheckInstall.countWarning("Memory below recommended value");
                CheckInstall.printVariable("(Memory Usage Mb)", memStr, "(WARNING[" + WC + "]: below recommended value)");
                recommendations.append("- Highly recommend increasing memory to at least 4096 Mb for a production environment.\n");
            } else {
                CheckInstall.printVariable("(Memory Usage Mb)", memStr, "");
            }
        } else {
            CheckInstall.printVariable("(Memory Usage)", "(not available)", "");
        }
        if (sysDisk != null) {
            fmt = "0";
            digLen = sysDisk.getTotalFieldLength(0x100000L) + fmt.length() - 1;
            _tot = sysDisk.getTotal_Mb();
            _used = sysDisk.getUsed_Mb();
            _free = sysDisk.getFree_Mb();
            _usage = sysDisk.getUsage();
            totMb = StringTools.format(_tot, fmt);
            useMb = StringTools.format(_used, fmt);
            freMb = StringTools.format(_free, fmt);
            usage = String.valueOf(Math.round(_usage * 100.0)) + "%";
            totMb = StringTools.rightAlign(totMb, digLen);
            useMb = StringTools.rightAlign(useMb, digLen);
            freMb = StringTools.rightAlign(freMb, digLen);
            memStr = "Total:" + totMb + "  Used:" + useMb + " [" + usage + "]" + "  Free:" + freMb;
            if (_usage > 0.9) {
                WC = CheckInstall.countWarning("Disk utilization above recommended threshold");
                CheckInstall.printVariable("(Disk Usage Mb)", memStr, "(WARNING[" + WC + "]: utilization above recommended threshold)");
                recommendations.append("- Highly recommend increasing available disk space.\n");
            } else {
                CheckInstall.printVariable("(Disk Usage Mb)", memStr, "");
            }
        } else {
            CheckInstall.printVariable("(Disk Usage)", "(not available)", "");
        }
        boolean isJava6plus = false;
        File javaInstallDir = null;
        File mostLikelyWinJDK = null;
        CheckInstall.println("");
        CheckInstall.println("Java Version (the JRE running this program):");
        String javaVendKey = "java.vendor";
        String javaVendVal = System.getProperty(javaVendKey);
        if (javaVendVal == null || javaVendVal.indexOf("Sun Microsystems") < 0 && javaVendVal.indexOf("Oracle") < 0 && javaVendVal.indexOf("Apple") < 0) {
            CheckInstall.printVariable("(Vendor)", javaVendVal, "(ERROR: not a Sun Microsystems version!)");
            CheckInstall.addError("This is not a 'Sun Microsystems, Inc' version of Java.", "Sun Microsystems Java not installed, or not referenced in executable path", FIX_JAVA_VERSION);
        } else {
            CheckInstall.printVariable("(Vendor)", javaVendVal, "");
        }
        String javaSpecKey = "java.specification.version";
        String javaSpecVal = StringTools.trim(System.getProperty(javaSpecKey));
        if (javaSpecVal.startsWith("1.5")) {
            CheckInstall.printVariable("(Version)", javaSpecVal, "(ERROR: requires 1.6+ to run properly)");
            CheckInstall.addError("This Java version may no longer be supported (" + javaSpecVal + ").", "Supported version of Java is not installed, or is not referenced in executable path", FIX_JAVA_VERSION);
        } else if (javaSpecVal.startsWith("1.6")) {
            CheckInstall.printVariable("(Version)", javaSpecVal, "");
            isJava6plus = true;
        } else if (javaSpecVal.startsWith("1.7")) {
            CheckInstall.printVariable("(Version)", javaSpecVal, "");
            isJava6plus = true;
        } else if (javaSpecVal.startsWith("1.8")) {
            int WC2 = CheckInstall.countWarning("Not fully tested with Java 1.8");
            CheckInstall.printVariable("(Version)", javaSpecVal, "(WARNING[" + WC2 + "]: not yet fully tested with 1.8)");
            isJava6plus = true;
        } else {
            CheckInstall.printVariable("(Version)", javaSpecVal, "(ERROR: invalid version)");
            CheckInstall.addError("This Java version is not supported (" + javaSpecVal + ").", "Supported version of Java is not installed, or is not referenced in executable path", FIX_JAVA_VERSION);
        }
        String javaHomeKey = "java.home";
        String javaHomeVal = System.getProperty(javaHomeKey, "");
        try {
            File javaHomeDir;
            File file = javaHomeDir = !javaHomeVal.equals("") ? new File(javaHomeVal).getCanonicalFile() : null;
            if (javaHomeDir != null) {
                boolean isJavaPathJRE;
                javaInstallDir = javaHomeDir.getName().equals("jre") ? javaHomeDir.getParentFile() : javaHomeDir;
                String javaInstallDirStr = javaInstallDir.toString();
                boolean bl = isJavaPathJRE = StringTools.indexOfIgnoreCase(javaInstallDirStr, "jre") >= 0;
                if (isJavaPathJRE) {
                    CheckInstall.printVariable("(Install dir)", javaInstallDir, "(ERROR: 'PATH' points to the JRE, rather than the JDK)");
                    if (isWindows && (mostLikelyWinJDK = CheckInstall.getLikelyWindowsJDK(javaInstallDir.getParentFile())) != null) {
                        String JavaHome = System.getenv(ENVIRON_JAVA_HOME);
                        if (JavaHome != null && JavaHome.equals(mostLikelyWinJDK.toString())) {
                            CheckInstall.println("    ('PATH' should be prefixed with '%JAVA_HOME%\\bin')");
                        } else {
                            CheckInstall.println("    ('PATH' should likely be prefixed with '" + mostLikelyWinJDK + "\\bin')");
                        }
                    }
                    CheckInstall.addError("The 'PATH' environment variable points to the JRE, rather than the JDK.", "The 'PATH' environment variable points to the JRE (Java Runtime Environment), rather than the JDK (Java Developer Kit).  The JDK already contains the JRE, so a separate JRE insallation  is not necessary.", "Set the 'PATH' environment variable to point to the JDK installation bin directory.");
                } else {
                    CheckInstall.printVariable("(Install dir)", javaInstallDir.toString(), "");
                }
            } else {
                javaInstallDir = null;
            }
        }
        catch (IOException ioe) {
            javaInstallDir = null;
        }
        if (javaInstallDir == null) {
            CheckInstall.printVariable(javaHomeKey, javaHomeVal, "(ERROR: unable to determine Java installation dir)");
            CheckInstall.addError("Unable to resolve the Java installation directory from '" + javaHomeVal + "'.", "Error encountered while attempting to determine the Java installation directory", null);
        }
        String javaHeadKey = "java.awt.headless";
        String javaHeadVal = System.getProperty(javaHeadKey, "false");
        CheckInstall.printVariable(javaHeadKey, javaHeadVal, "");
        try {
            Font font = new Font(PushpinIcon.DEFAULT_TEXT_FONT, 0, 10);
            CheckInstall.printVariable("(Has Fonts)", "true", "");
        }
        catch (Throwable th) {
            int WC3 = CheckInstall.countWarning("Unable to load Fonts");
            CheckInstall.printVariable("(Has Fonts)", "false", "(WARNING[" + WC3 + "]: unable to load fonts)");
        }
        StringBuffer hashSB = new StringBuffer();
        try {
            MessageDigest.getInstance("MD5");
            hashSB.append("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            hashSB.append("[MD5]");
        }
        hashSB.append(", ");
        try {
            MessageDigest.getInstance("SHA-1");
            hashSB.append("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            hashSB.append("[SHA-1]");
        }
        hashSB.append(", ");
        try {
            Mac.getInstance("HmacSHA256");
            hashSB.append("SHA-2");
        }
        catch (NoSuchAlgorithmException nsae) {
            hashSB.append("[SHA-2]");
        }
        CheckInstall.printVariable("(Hash Algorithms)", hashSB.toString(), "");
        CheckInstall.println("");
        CheckInstall.println("Environment variable paths (canonical):");
        env_GTS_HOME = CheckInstall.getEnvironmentFile(ENVIRON_GTS_HOME, true, true);
        if (env_GTS_HOME != null) {
            String userDirPath = System.getProperty("user.dir", "");
            try {
                File userDir;
                File file = userDir = !userDirPath.equals("") ? new File(userDirPath).getCanonicalFile() : null;
                if (!env_GTS_HOME.equals(userDir)) {
                    CheckInstall.printVariable(ENVIRON_GTS_HOME, env_GTS_HOME, "(ERROR: does not match the current directory)");
                    CheckInstall.addError("'GTS_HOME' does not match the current directory '" + userDir + "'.", "This installation check must be executed from directory '" + env_GTS_HOME + "'", "Change the environment variable 'GTS_HOME', or cd to '" + env_GTS_HOME + "'.");
                } else {
                    CheckInstall.printVariable(ENVIRON_GTS_HOME, env_GTS_HOME, "");
                }
            }
            catch (IOException ioe) {
                CheckInstall.printVariable(ENVIRON_GTS_HOME, env_GTS_HOME, "(ERROR: unable to determine current directory)");
                CheckInstall.addError("Unable to resolve the current directory from '" + userDirPath + "'.", "Error encountered while attempting to determine current directory", null);
            }
        }
        if ((env_GTS_LINKS = CheckInstall.getEnvironmentFile(ENVIRON_GTS_LINKS, true, false)) == null) {
            if (!OSTools.isWindows()) {
                env_GTS_LINKS = new File("/usr/local");
            } else if (env_GTS_HOME != null) {
                // empty if block
            }
        }
        if ((env_GTS_CONF = CheckInstall.getEnvironmentFile(ENVIRON_GTS_CONF, false, false)) != null) {
            CheckInstall.printVariable(ENVIRON_GTS_CONF, env_GTS_CONF, "");
        }
        if ((env_JAVA_HOME = CheckInstall.getEnvironmentFile(ENVIRON_JAVA_HOME, true, true)) != null) {
            boolean isJavaEnvJRE;
            String env_JAVA_HOME_name = env_JAVA_HOME.getName();
            boolean bl = isJavaEnvJRE = StringTools.indexOfIgnoreCase(env_JAVA_HOME_name, "jre") >= 0;
            if (isJavaEnvJRE) {
                CheckInstall.printVariable(ENVIRON_JAVA_HOME, env_JAVA_HOME, "(ERROR: points to the JRE, rather than the JDK)");
                if (isWindows) {
                    File likelyJDK;
                    File file = likelyJDK = mostLikelyWinJDK != null ? mostLikelyWinJDK : CheckInstall.getLikelyWindowsJDK(null);
                    if (likelyJDK != null) {
                        CheckInstall.println("    ('JAVA_HOME' should likely be set to '" + likelyJDK + "')");
                    }
                }
                CheckInstall.addError("'JAVA_HOME' points to the JRE, rather than the JDK.", "The 'JAVA_HOME' environment variable points to the JRE (Java Runtime Environment), rather than the JDK (Java Developer Kit).  The JDK already contains the JRE, so a separate JRE insallation  is not necessary.", "Set JAVA_HOME to point to the JDK installation directory.");
            } else if (javaInstallDir == null) {
                int WC4 = CheckInstall.countWarning("Cannot compare JAVA_HOME to Java Install directory");
                CheckInstall.printVariable(ENVIRON_JAVA_HOME, env_JAVA_HOME, "(WARNING[" + WC4 + "]: could not compare to Java install dir)");
            } else if (!javaInstallDir.equals(env_JAVA_HOME)) {
                CheckInstall.printVariable(ENVIRON_JAVA_HOME, env_JAVA_HOME, "(ERROR: does not match Java install dir)");
                CheckInstall.addError("'JAVA_HOME' does not match the Java installation 'PATH' directory '" + javaInstallDir + "'.", "The version of Java referenced in the executable 'PATH' environment variable does not match 'JAVA_HOME'.", "Make sure both the 'JAVA_HOME' and 'PATH' environment variables point to the same installed JDK.");
            } else {
                CheckInstall.printVariable(ENVIRON_JAVA_HOME, env_JAVA_HOME, "");
            }
        } else if (isWindows) {
            File likelyJDK;
            File file = likelyJDK = mostLikelyWinJDK != null ? mostLikelyWinJDK : CheckInstall.getLikelyWindowsJDK(null);
            if (likelyJDK != null) {
                CheckInstall.println("    ('JAVA_HOME' should likely be set to '" + likelyJDK + "')");
            }
        }
        env_ANT_HOME = CheckInstall.getEnvironmentFile(ENVIRON_ANT_HOME, true, false);
        if (env_ANT_HOME != null) {
            CheckInstall.printVariable(ENVIRON_ANT_HOME, env_ANT_HOME, "");
        }
        if ((env_CATALINA_HOME = CheckInstall.getEnvironmentFile(ENVIRON_CATALINA_HOME, true, true)) != null) {
            if (!env_CATALINA_HOME.isDirectory()) {
                int WC5 = CheckInstall.countWarning("'CATALINA_HOME' does not specify a directory");
                CheckInstall.printVariable(ENVIRON_CATALINA_HOME, env_CATALINA_HOME, "(WARNING[" + WC5 + "]: does not exist)");
                env_CATALINA_HOME = null;
            } else {
                File servletApiJarFile2;
                boolean foundServletApiJar2;
                File servletApiJarFile1;
                boolean foundServletApiJar1;
                CheckInstall.printVariable(ENVIRON_CATALINA_HOME, env_CATALINA_HOME, "");
                if (!isWindows && isJava6plus) {
                    String ext = isWindows ? ".bat" : ".sh";
                    String[] sh = new String[]{"startup", "shutdown", "catalina"};
                    File tomcatBin = new File(env_CATALINA_HOME, "bin");
                    int notExecutableCount = 0;
                    try {
                        for (int i = 0; i < sh.length; ++i) {
                            File shFile = new File(tomcatBin, sh[i] + ext);
                            MethodAction canExecMeth = new MethodAction((Object)shFile, "canExecute");
                            boolean canExec = (Boolean)canExecMeth.invoke();
                            if (canExec) continue;
                            ++notExecutableCount;
                            break;
                        }
                    }
                    catch (Throwable th) {
                        int WC6 = CheckInstall.countWarning("Unable to check for exectuable Tomcat scripts");
                        CheckInstall.println("    WARNING[" + WC6 + "]: Unable to check for executable Tomcat scripts: " + th);
                    }
                    if (notExecutableCount > 0) {
                        CheckInstall.println("    ERROR: Tomcat '$CATALINA_HOME/bin' directory contains non-executable '" + ext + "' files!");
                        CheckInstall.addError("Tomcat contains non-executable '" + ext + "' files", "Some Tomcat '" + ext + "' commands do not have the 'execute' permission bit set.", "Run 'chmod a+x $CATALINA_HOME" + File.separator + "*" + ext + "' to set the execute bit");
                    }
                }
                if (!isWindows && isJava6plus) {
                    final AccumulatorLong accumCantRead = new AccumulatorLong(0L);
                    long maxListedFiles = 4L;
                    try {
                        FileTools.traverseAllFiles(env_CATALINA_HOME, new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                if (!FileTools.canRead(f)) {
                                    accumCantRead.increment();
                                    if (accumCantRead.get() < 4L) {
                                        CheckInstall.println("    ERROR: Cannot read - " + f);
                                    } else if (accumCantRead.get() == 4L) {
                                        CheckInstall.println("    ERROR: ... (additional non-readable files omitted) ...");
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    catch (Throwable th) {
                        Print.logException("Readable files error", th);
                        int WC7 = CheckInstall.countWarning("Unable to check for (non-)readable Tomcat files");
                        CheckInstall.println("    WARNING[" + WC7 + "]: Unable to check for (non-)readable Tomcat files: " + th);
                    }
                    if (accumCantRead.get() > 0L) {
                        CheckInstall.println("    ERROR: Tomcat '$CATALINA_HOME/' directory contains non-readable files!");
                        CheckInstall.addError("Tomcat contains non-readable files", "Some Tomcat files do not have the 'read' permission bit set or are owned by a different user.", "Run 'chmod' to set the read bit, or 'chown' to change to the proper user.");
                    }
                }
                if (!(foundServletApiJar1 = (servletApiJarFile1 = new File(new File(new File(env_CATALINA_HOME, "common"), "lib"), "servlet-api.jar")).isFile()) && !(foundServletApiJar2 = (servletApiJarFile2 = new File(new File(env_CATALINA_HOME, "lib"), "servlet-api.jar")).isFile())) {
                    String saj = (isWindows ? "%CATALINA_HOME%\\common\\lib\\" : "$CATALINA_HOME/common/lib/") + servletApiJarFile1.getName();
                    CheckInstall.println("    ERROR: Tomcat '" + saj + "' file not found!");
                    CheckInstall.addError("Tomcat '" + saj + "' file not found", "CATALINA_HOME is likely pointing to an invalid Tomcat installation", "Check directory referenced by CATALINA_HOME");
                }
            }
        }
        CheckInstall.println("");
        CheckInstall.println("Extended library Jar files: 'java.ext.dirs'");
        String[] javaExtDirs = StringTools.split(System.getProperty("java.ext.dirs", ""), File.pathSeparatorChar);
        if (javaExtDirs == null || javaExtDirs.length == 0) {
            CheckInstall.println("    ERROR: System property 'java.ext.dirs' is null/empty!");
            CheckInstall.addError("Extended library jar directory property 'java.ext.dirs' is null/empty.", "'java.ext.dirs' is not defined", null);
        } else {
            String[] reqJars = new String[]{"*mail.jar", "mysql-connector-java-*"};
            for (int xd = 0; xd < javaExtDirs.length; ++xd) {
                String[] fileList;
                File prpExtLibHome;
                block420: {
                    prpExtLibHome = null;
                    fileList = null;
                    try {
                        prpExtLibHome = new File(javaExtDirs[xd]).getCanonicalFile();
                        fileList = prpExtLibHome.list();
                        if (fileList != null) break block420;
                        fileList = new String[]{};
                    }
                    catch (IOException ioe) {
                        CheckInstall.println("    ERROR: Unable to resolve extended library jar directory: " + javaExtDirs[xd]);
                        CheckInstall.println("     [" + ioe.getMessage() + "]");
                        CheckInstall.addError("Unable to resolve Java extended library directory.", "Error resolving the System property 'java.ext.dirs' directory: " + javaExtDirs[xd], null);
                        break;
                    }
                }
                CheckInstall.printVariable("(Ext dir)", prpExtLibHome, "");
                for (int j = 0; j < reqJars.length; ++j) {
                    if (reqJars[j] == null) continue;
                    String foundJarName = null;
                    for (int i = 0; i < fileList.length; ++i) {
                        String pattern;
                        if (!StringTools.endsWithIgnoreCase(fileList[i], ".jar")) continue;
                        if (reqJars[j].endsWith("*")) {
                            pattern = reqJars[j].substring(0, reqJars[j].length() - 1);
                            if (!StringTools.startsWithIgnoreCase(fileList[i], pattern)) continue;
                            foundJarName = fileList[i];
                            break;
                        }
                        if (reqJars[j].startsWith("*")) {
                            pattern = reqJars[j].substring(1);
                            if (!StringTools.endsWithIgnoreCase(fileList[i], pattern)) continue;
                            foundJarName = fileList[i];
                            break;
                        }
                        if (!fileList[i].equalsIgnoreCase(reqJars[j])) continue;
                        foundJarName = fileList[i];
                        break;
                    }
                    if (foundJarName == null) continue;
                    File foundJar = new File(prpExtLibHome, foundJarName);
                    if (foundJar.canRead()) {
                        CheckInstall.printVariable(reqJars[j], "Found '" + foundJarName + "'", "");
                    } else {
                        CheckInstall.printVariable(reqJars[j], "Found '" + foundJarName + "'", "(ERROR: not readable!)");
                        CheckInstall.addError("Jar file '" + reqJars[j] + "' is not readable by this application.", "The jar file permissions may restrict the ability to read this file.", "Make sure this jar file permissions is set to world-readable.");
                    }
                    reqJars[j] = null;
                }
            }
            for (int j = 0; j < reqJars.length; ++j) {
                if (reqJars[j] == null) continue;
                CheckInstall.printVariable(reqJars[j], "", "(ERROR: not found!)");
                CheckInstall.addError("Jar file '" + reqJars[j] + "' was not found.", "The jar file is not installed in the extended library directory", "Please install the jar file in the extended library directory");
            }
        }
        CheckInstall.println("");
        CheckInstall.println("Runtime Configuration:");
        File defaultConfigFile = null;
        try {
            defaultConfigFile = FileTools.toFile(RTConfig.getLoadedConfigURL());
        }
        catch (Throwable th) {
            int WC8 = CheckInstall.countWarning("Error converting URL to File: " + RTConfig.getLoadedConfigURL());
            CheckInstall.println("    WARNING[" + WC8 + "]: Unable to convert URL to File: " + RTConfig.getLoadedConfigURL());
        }
        if (defaultConfigFile == null) {
            CheckInstall.printVariable("(Default cfg dir)", configDir != null ? configDir.toString() : "(ERROR: not found!)", "");
            CheckInstall.printVariable("(Default cfg file)", "", "(ERROR: not found!)");
            CheckInstall.addError("Runtime configuration file not found.", "Possible missing configuration file, or not found in CLASSPATH.", "Please include configuration file directory in CLASSPATH.");
        } else if (configDir == null) {
            CheckInstall.printVariable("(Default cfg dir)", "", "(ERROR: not found!)");
            CheckInstall.printVariable("(Default cfg file)", defaultConfigFile, "");
            CheckInstall.addError("Runtime configuration directory not found.", "Possible CLASSPATH and/or GTS_HOME configuration issue.", "Please repair CLASSPATH and/or GTS_HOME configuration.");
        } else {
            CheckInstall.printVariable("(Default cfg dir)", configDir, "");
            CheckInstall.printVariable("(Default cfg file)", defaultConfigFile, "");
        }
        File defaultFile = defaultConfigFile;
        RTProperties defaultProps = defaultFile != null ? new RTProperties(defaultFile) : null;
        File webappFile = configDir != null ? new File(configDir, "webapp.conf") : null;
        RTProperties webappProps = null;
        if (webappFile == null || !webappFile.isFile()) {
            CheckInstall.printVariable("(WebApp cfg URL)", "", "(ERROR: not found!)");
            CheckInstall.addError("WebApp configuration file not found.", "Possible missing configuration file, or not found in CLASSPATH.", "Please include configuration file directory in CLASSPATH.");
        } else {
            try {
                webappProps = new RTProperties();
                webappProps.setKeyReplacementMode(1);
                webappProps.setConfigLogMessagesEnabled(false);
                webappProps.setProperties(webappFile, true);
                CheckInstall.printVariable("(WebApp cfg file)", webappFile, "");
            }
            catch (IOException ioe) {
                webappProps = null;
                Print.logError("Unable to load config file: " + webappFile + " [" + ioe + "]", new Object[0]);
                CheckInstall.printVariable("(WebApp cfg file)", webappFile, "(ERROR: unable to load!)");
                CheckInstall.addError("Unable to load WebApp configuration file.", "Possible invalid/unreadable configuration file.", "Please check that configuration exists and is readable.");
            }
        }
        File logDir = RTConfig.getFile("log.dir", null);
        if (logDir == null || StringTools.isBlank(logDir.toString())) {
            CheckInstall.printVariable("log.dir", "", "(ERROR: not specified!)");
            CheckInstall.addError("The 'log.dir' appears to be missing from the runtime configuration.", "Missing 'log.dir' specification in 'default.conf' (or included files).", "Please include 'log.dir' specification in 'default.conf' (or included files).");
        } else if (!logDir.isDirectory()) {
            CheckInstall.printVariable("log.dir", logDir, "(ERROR: does not exist!)");
            CheckInstall.addError("The specified 'log.dir' directory does not exist.", "The specified 'log.dir' directory does not exist.", "Please make sure 'log.dir' specifies an existing directory.");
        } else {
            CheckInstall.printVariable("log.dir", logDir, "");
            final AccumulatorLong accumCantReadWrite = new AccumulatorLong(0L);
            long maxListedFiles = 4L;
            try {
                FileTools.traverseAllFiles(logDir, new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (!FileTools.canRead(f) || !FileTools.canWrite(f)) {
                            accumCantReadWrite.increment();
                            if (accumCantReadWrite.get() < 4L) {
                                CheckInstall.println("    ERROR: Cannot read/write - " + f);
                            } else if (accumCantReadWrite.get() == 4L) {
                                CheckInstall.println("    ERROR: ... (additional non-read/writable files omitted) ...");
                            }
                        }
                        return true;
                    }
                });
            }
            catch (Throwable th) {
                Print.logException("Read/Writable files error", th);
                int WC9 = CheckInstall.countWarning("Unable to check for (non-)read/writable Log files");
                CheckInstall.println("    WARNING[" + WC9 + "]: Unable to check for (non-)read/writable Log files: " + th);
            }
            if (accumCantReadWrite.get() > 0L) {
                CheckInstall.println("    ERROR: Log directory contains non-read/writable files!");
                CheckInstall.addError("Log directory contains non-read/writable files", "Some Log files do not have the 'read/write' permission bits set or are owned by a different user.", "Run 'chmod' to set the read/write bits, or 'chown' to change to the proper user.");
            }
        }
        String dbProv = "";
        dbProv = RTConfig.getString("db.sql.provider", "");
        if (StringTools.isBlank(dbProv)) {
            CheckInstall.printVariable("db.sql.provider", "", "(ERROR: not specified!)");
            CheckInstall.addError("The DB provider has not been specified.", "Missing 'db.sql.provider' specification in 'default.conf' (or included files).", "Please include 'db.sql.provider' specification in 'default.conf' (or included files).");
        } else if (webappProps != null && !dbProv.equals(webappProps.getString("db.sql.provider", ""))) {
            CheckInstall.printVariable("db.sql.provider", dbProv, "(ERROR: does not match 'webapp.conf'!)");
            CheckInstall.addError("The DB provider in 'default.conf' does not match specification in 'webapp.conf'.", "Invalid 'db.sql.provider' specification in 'webapp.conf'.", "Please include proper 'db.sql.provider' specification in 'webapp.conf'.");
        } else {
            CheckInstall.printVariable("db.sql.provider", dbProv, "");
        }
        String dftHost = defaultProps != null ? defaultProps.getString("db.sql.host", "") : "";
        String dbHost = RTConfig.getString("db.sql.host", "");
        if (StringTools.isBlank(dftHost)) {
            CheckInstall.printVariable("db.sql.host", "", "(ERROR: not specified!)");
            CheckInstall.addError("The DB host has not been specified.", "Missing 'db.sql.host' specification in 'default.conf'.", "Please include 'db.sql.host' specification in 'default.conf'.");
        } else if (!dftHost.equals(dbHost)) {
            int WC10 = CheckInstall.countWarning("DB host does not match host in 'default.conf'");
            CheckInstall.printVariable("db.sql.host", dftHost, "(WARNING[" + WC10 + "]: does not match default host [" + dbHost + "])");
        } else if (webappProps != null && !dftHost.equals(webappProps.getString("db.sql.host", ""))) {
            int WC11 = CheckInstall.countWarning("DB host does not match host in 'webapp.conf'");
            CheckInstall.printVariable("db.sql.host", dftHost, "(WARNING[" + WC11 + "]: does not match 'webapp.conf')");
        } else if (!IPTools.isLocalhost(dftHost)) {
            String dftHostIP = IPTools.getIPAddress(dftHost);
            int WC12 = CheckInstall.countWarning("DB host [" + dftHostIP + "] does not match 'localhost'");
            CheckInstall.printVariable("db.sql.host", dftHost, "(WARNING[" + WC12 + "]: is not 'localhost')");
        } else {
            CheckInstall.printVariable("db.sql.host", dftHost, "");
        }
        String dbName = RTConfig.getString("db.sql.dbname", "");
        if (StringTools.isBlank(dbName)) {
            CheckInstall.printVariable("db.sql.dbname", "", "(ERROR: not specified!)");
            CheckInstall.addError("The DB name has not been specified.", "Missing 'db.sql.dbname' specification in 'default.conf'.", "Please include 'db.sql.dbname' specification in 'default.conf'.");
        } else if (webappProps != null && !dbName.equals(webappProps.getString("db.sql.dbname", ""))) {
            String waName = webappProps.getString("db.sql.dbname", "");
            CheckInstall.printVariable("db.sql.dbname", dbName, "(ERROR: does not match 'webapp.conf'!)");
            CheckInstall.addError("The DB name in 'default.conf' does not match specification in 'webapp.conf'.", "Invalid 'db.sql.dbname' specification in 'webapp.conf' [" + waName + "].", "Please include proper 'db.sql.dbname' specification in 'webapp.conf'.");
        } else {
            CheckInstall.printVariable("db.sql.dbname", dbName, "");
        }
        String dbUser = RTConfig.getString("db.sql.user", "");
        if (StringTools.isBlank(dbUser)) {
            CheckInstall.printVariable("db.sql.user", "", "(ERROR: not specified!)");
            CheckInstall.addError("The DB user has not been specified.", "Missing 'db.sql.user' specification in 'default.conf' (or included files).", "Please include 'db.sql.user' specification in 'default.conf' (or included files).");
        } else if (webappProps != null && !dbUser.equals(webappProps.getString("db.sql.user", ""))) {
            String waUser = webappProps.getString("db.sql.user", "");
            CheckInstall.printVariable("db.sql.user", dbUser, "(ERROR: does not match 'webapp.conf'!)");
            CheckInstall.addError("The DB user in 'default.conf' does not match specification in 'webapp.conf'.", "Invalid 'db.sql.user' specification in 'webapp.conf'.", "Please include proper 'db.sql.user' specification in 'webapp.conf' [" + waUser + "].");
        } else if (dbUser.equals("root")) {
            int WC13 = CheckInstall.countWarning("DB user should not be 'root'");
            CheckInstall.printVariable("db.sql.user", dbUser, "(WARNING[" + WC13 + "]: should not be 'root')");
        } else {
            CheckInstall.printVariable("db.sql.user", dbUser, "");
        }
        boolean dbUTF8 = RTConfig.getBoolean("db.sql.utf8", false);
        CheckInstall.printVariable("db.sql.utf8", String.valueOf(dbUTF8), "");
        CheckInstall.printVariable("db.sql.url", RTConfig.getString("db.sql.url", ""), "");
        CheckInstall.printVariable("db.sql.url.db", RTConfig.getString("db.sql.url.db", ""), "");
        boolean dbcp = RTConfig.getBoolean("db.dbConnectionPool");
        CheckInstall.printVariable("db.dbConnectionPool", String.valueOf(dbcp), "");
        if (StringTools.containsIgnoreCase(dbProv, "mysql")) {
            int recommendedMaxConn = 300;
            String maxConnTitle = "(MySQL MaxConnections)";
            File myCnfFile = new File("/etc/my.cnf");
            if (!myCnfFile.isFile()) {
                myCnfFile = new File("/etc/mysql/my.cnf");
            }
            if (myCnfFile.isFile()) {
                List<String> maxConn = FileTools.findPatternInFile(myCnfFile, "max_connections", true);
                if (ListTools.size(maxConn) <= 0) {
                    maxConn = FileTools.findPatternInFile(myCnfFile, "max-connections", true);
                }
                if (ListTools.size(maxConn) > 0) {
                    for (String maxConnLine : maxConn) {
                        if ((maxConnLine = StringTools.trim(maxConnLine)).startsWith("#")) continue;
                        int eqSepPos = maxConnLine.lastIndexOf("=");
                        if (eqSepPos < 0) {
                            CheckInstall.printVariable(maxConnTitle, "unknown", "(unable to find specified max conn)");
                            continue;
                        }
                        String maxStr = maxConnLine.substring(eqSepPos + 1).trim();
                        int maxInt = StringTools.parseInt(maxStr, -1);
                        if (maxInt < 0) {
                            CheckInstall.printVariable(maxConnTitle, "unknown", "(unable to parse specified max conn)");
                            continue;
                        }
                        if (maxInt < recommendedMaxConn) {
                            CheckInstall.printVariable(maxConnTitle, maxStr, "(Recommend at least " + recommendedMaxConn + ")");
                            recommendations.append("- Recommend setting MySQL 'max_connections' to at least " + recommendedMaxConn + ":\n");
                            recommendations.append("     see \"http://www.opengts.org/FAQ.html#faq_mysqlConn\"\n");
                            continue;
                        }
                        CheckInstall.printVariable(maxConnTitle, maxStr, "");
                    }
                } else {
                    CheckInstall.printVariable(maxConnTitle, "default", "(Recommend setting to at least " + recommendedMaxConn + ")");
                    recommendations.append("- Recommend setting MySQL 'max_connections' to at least " + recommendedMaxConn + ".\n");
                    recommendations.append("     see \"http://www.opengts.org/FAQ.html#faq_mysqlConn\"\n");
                }
            } else {
                CheckInstall.printVariable(maxConnTitle, "unknown", "('" + myCnfFile + "' not found)");
            }
        }
        String startupInitClass = RTConfig.getString("StartupInit.class", "");
        String string = waStartupInitClass = webappProps != null ? webappProps.getString("StartupInit.class", "") : "";
        if (StringTools.isBlank(startupInitClass) && StringTools.isBlank(waStartupInitClass)) {
            CheckInstall.printVariable("StartupInit.class", "(default)", "");
        } else {
            String initClass = !StringTools.isBlank(startupInitClass) ? startupInitClass : waStartupInitClass;
            CheckInstall.printVariable("StartupInit.class", CheckInstall.ClassName(initClass), "");
            Object startupInit = null;
            if (!startupInitClass.equals(waStartupInitClass)) {
                CheckInstall.println("    ERROR: 'webapp.conf' does not match 'default.conf'!");
                CheckInstall.addError("webapp.conf 'StartupInit.class' does not match default.conf", null, "Change 'webapp.conf' to match 'default.conf'.");
            }
            try {
                Class<?> cfgClass = Class.forName(initClass);
                startupInit = cfgClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                CheckInstall.println("    ERROR: Class not found!");
                CheckInstall.addError("Unable to load class '" + initClass + ".", "Class '" + initClass + "' was not found.", "Fix class definition.");
            }
            catch (Throwable th) {
                CheckInstall.println("    ERROR: Unable to load instance!");
                CheckInstall.addError("Unable to load class '" + initClass + ".", "Due to error '" + th.toString() + "'", "Fix class definition.");
            }
        }
        RuleFactory ruleFact = Device.getRuleFactory();
        if (ruleFact != null) {
            long compileTime = 0L;
            try {
                MethodAction ma = new MethodAction((Object)ruleFact, "getCompileTime");
                Long ct = (Long)ma.invoke();
                compileTime = ct != null ? ct : 0L;
            }
            catch (Throwable th) {
                compileTime = 0L;
            }
            StringBuffer v = new StringBuffer();
            v.append("[").append(ruleFact.getName()).append(" ").append(ruleFact.getVersion());
            if (compileTime > 0L) {
                v.append(" ").append(new DateTime(compileTime).gmtFormat("yyyy/MM/dd HH:mm:ss"));
            }
            v.append("] ").append(CheckInstall.ClassName(ruleFact));
            CheckInstall.printVariable("(RuleFactory)", v.toString(), "");
            try {
                MethodAction ma = new MethodAction((Object)ruleFact, "checkRuntime");
                Boolean rt = (Boolean)ma.invoke();
                if (rt != null && !rt.booleanValue()) {
                    recommendations.append("- Recommend checking RuleFactory runtime support components.\n");
                }
            }
            catch (Throwable th) {}
        } else {
            CheckInstall.printVariable("(RuleFactory)", "(not installed)", "");
        }
        PingDispatcher pingDisp = Device.getPingDispatcher();
        if (pingDisp != null) {
            CheckInstall.printVariable("(PingDispatcher)", CheckInstall.ClassName(pingDisp), "");
        }
        int smsIsFunctional = -1;
        if (defaultProps != null) {
            String none = "<none>";
            String smsType = defaultProps.getString("SmsGatewayHandler.defaultName", none);
            StringBuffer sms = new StringBuffer();
            if (smsType.equals(none)) {
                smsIsFunctional = -1;
            } else if (smsType.equals("emailBody")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.emailBody.smsEmailAddress", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("emailSubject")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.emailSubject.smsEmailAddress", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("httpURL")) {
                String s = defaultProps.getString("SmsGatewayHandler.httpURL.url", "");
                if (s.length() > 45) {
                    s = s.substring(0, 46) + " ...";
                }
                sms.append(s);
                smsIsFunctional = 1;
            } else if (smsType.equals("clickatell")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.clickatell.smsEmailAddress", ""));
                sms.append(", User=");
                sms.append(defaultProps.getString("SmsGatewayHandler.clickatell.user", ""));
                sms.append(", Pass=");
                sms.append("xxxxxx");
                sms.append(", API=");
                sms.append(defaultProps.getString("SmsGatewayHandler.clickatell.api_id", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("mail2txt")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txt.smsEmailAddress", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("mail2txt160")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txt160.smsEmailAddress", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("mail2txtid")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txtid.smsEmailAddress", ""));
                sms.append(", From=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txtid.from", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("mail2txt160id")) {
                sms.append("EMail=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txt160id.smsEmailAddress", ""));
                sms.append(", From=");
                sms.append(defaultProps.getString("SmsGatewayHandler.mail2txt160id.from", ""));
                smsIsFunctional = 1;
            } else if (smsType.equals("ozekisms")) {
                sms.append("HostPort=");
                sms.append(defaultProps.getString("SmsGatewayHandler.ozekisms.hostPort", ""));
                sms.append(", Orig=");
                sms.append(defaultProps.getString("SmsGatewayHandler.ozekisms.originator", ""));
                sms.append(", User=");
                sms.append(defaultProps.getString("SmsGatewayHandler.ozekisms.user", ""));
                sms.append(", Pass=");
                sms.append("xxxxxx");
                smsIsFunctional = 1;
            } else {
                sms.append("<unrecognized>");
                smsIsFunctional = 0;
            }
            CheckInstall.printVariable("(SMS Gateway)", smsType, "[" + sms + "]");
            if (!StringTools.isBlank(sendTestSMSTo) && smsIsFunctional == 1) {
                String smsAccount = Account.getSystemAdminAccountID();
                CheckInstall.println("    Sending test SMS message to '" + sendTestSMSTo + "' (via \"" + smsAccount + "\") ...");
                try {
                    Account sysadmin = Account.getAccount(smsAccount);
                    SMSOutboundGateway gw = SMSOutboundGateway.GetSMSGateway(smsType);
                    if (sysadmin == null) {
                        CheckInstall.println("    ERROR: Unable to send SMS (no '" + smsAccount + "' account)");
                        CheckInstall.addError("Unable to send a test SMS message.", "No '" + smsAccount + "' account found.", "Please fix displayed errors and re-run CheckInstall.");
                    } else if (gw == null) {
                        CheckInstall.println("    ERROR: Unable to send SMS (SMSOutboundGateway not found)");
                        CheckInstall.addError("Unable to send a test SMS message.", "Invalid SMSOutboundGateway specified.", "Please fix displayed errors and re-run CheckInstall.");
                    } else {
                        String smsText = "CheckInstall test message [" + DBConfig.getVersion() + "]";
                        SendMail.SetThreadModel("current");
                        DCServerFactory.ResultCode rtn = gw.sendSMSMessage(sysadmin, smsText, sendTestSMSTo);
                        if (!DCServerFactory.ResultCode.SUCCESS.equals(rtn)) {
                            CheckInstall.println("    ERROR: Unable to send SMS (SMSOutboundGateway returned error)");
                            CheckInstall.addError("Unable to send a test SMS message.", "SMSOutboundGateway return error: " + rtn, "Please fix displayed errors and re-run CheckInstall.");
                        } else {
                            CheckInstall.println("    ... Test SMS message successfully sent.");
                        }
                    }
                }
                catch (Throwable th) {
                    CheckInstall.println("    ERROR: Unable to send SMS (Exception occurred)");
                    CheckInstall.addError("Unable to send a test SMS message.", "Exception - " + th, "Please fix displayed errors and re-run CheckInstall.");
                }
            }
        }
        int emailIsFunctional = -1;
        boolean hasSMTPHost = true;
        SendMail.SmtpProperties smtpProps = null;
        BasicPrivateLabel bpl = null;
        if (!StringTools.isBlank(smtpPropBPL)) {
            bpl = BasicPrivateLabelLoader.getPrivateLabel(smtpPropBPL);
            if (bpl == null) {
                CheckInstall.println("    WARN: Invalid PrivateLabel name specified: " + smtpPropBPL);
            } else {
                smtpProps = bpl.getSmtpProperties();
            }
        }
        if (smtpProps == null) {
            smtpProps = new SendMail.SmtpProperties();
            smtpPropBPL = "<default>";
        }
        String none = "<none>";
        String smtpHost = StringTools.blankDefault(smtpProps.getHost(), none);
        int smtpPort = smtpProps.getPort();
        String smtpUser = StringTools.blankDefault(smtpProps.getUser(), none);
        String smtpEmail = smtpProps.getUserEmail();
        String smtpSSL = smtpProps.getEnableSSL();
        String smtpTLS = smtpProps.getEnableTLS();
        hasSMTPHost = !StringTools.isBlank(smtpHost) && !smtpHost.equals(none);
        String SMTPDesc = "(SMTP:" + smtpPropBPL + ")";
        CheckInstall.printVariable(SMTPDesc, smtpHost + ":" + smtpPort, "[user=" + smtpUser + ", ssl=" + smtpSSL + ", tls=" + smtpTLS + "]");
        if (!hasSMTPHost) {
            CheckInstall.printVariable("(SMTP Connection)", "", "SMTP service disabled (no host specified)");
        } else {
            boolean SMTP_port_ok = false;
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(smtpHost, smtpPort), 3000);
                CheckInstall.printVariable("(SMTP Connection)", "Successful connection (does not guarantee service)", "");
                SMTP_port_ok = true;
            }
            catch (SocketTimeoutException ste) {
                CheckInstall.printVariable("(SMTP Connection)", "Failed", "(ERROR: connection timeout)");
                CheckInstall.addError("Unable to connect to the SMTP host:port '" + smtpHost + ":" + smtpPort + "'.", "Possible slow connection, or possible invalid SMTP host:port specification.", "Please check proper SMTP specification, and re-run CheckInstall.", false);
            }
            catch (ConnectException ce) {
                CheckInstall.printVariable("(SMTP Connection)", "Failed", "(ERROR: connection refused)");
                CheckInstall.addError("Unable to connect to the SMTP host:port '" + smtpHost + ":" + smtpPort + "'.", "Invalid SMTP host:port specified.", "Please set valid SMTP host:port specification.", false);
            }
            catch (UnknownHostException uhe) {
                CheckInstall.printVariable("(SMTP Connection)", "Failed", "(ERROR: unknown host)");
                CheckInstall.addError("Unable to connect to the SMTP host '" + smtpHost + "'.", "Invalid SMTP host specified in 'default.conf' (or included files).", "Please set valid SMTP host specification.", false);
            }
            catch (Throwable th) {
                Print.logException("SMTP server connect error", th);
                CheckInstall.printVariable("(SMTP Connection)", "Failed", "(ERROR: unexpected error)");
                CheckInstall.addError("Unable to connect to the SMTP host:port '" + smtpHost + ":" + smtpPort + "'.", "Unexpected error received [" + th + "]", "Please fix and re-run this CheckInstall.", false);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable th) {}
                socket = null;
            }
            String SMTP_session = "javax.mail.Session";
            boolean found_JavaMail = false;
            try {
                Class.forName(SMTP_session);
                found_JavaMail = true;
            }
            catch (Throwable th) {
                CheckInstall.println("    ERROR: JavaMail not installed, unable to locate '" + SMTP_session + "'");
                CheckInstall.addError("Unable to locate JavaMail support (class '" + SMTP_session + "').", "'mail.jar' may not be installed in a Java extended library directory.", "Please install JavaMail, and re-run CheckInstall.");
                found_JavaMail = false;
            }
            boolean SendMail_functional = false;
            if (found_JavaMail) {
                try {
                    Class.forName("org.opengts.util.SendMailArgs");
                    SendMail_functional = true;
                }
                catch (Throwable th) {
                    CheckInstall.println("    ERROR: JavaMail may not have been installed at compile time!");
                    CheckInstall.addError("JavaMail was not installed at the time this code was compiled.", "'mail.jar' was not installed in a Java extended library directory.", "Please install JavaMail, recompile, and re-run CheckInstall.");
                }
            }
            int n = !SendMail_functional ? -1 : (emailIsFunctional = !SMTP_port_ok ? 0 : 1);
            if (!StringTools.isBlank(sendTestEmailTo) && SMTP_port_ok && SendMail_functional) {
                String toAddr = sendTestEmailTo;
                String fromAddr = smtpProps.getUserEmail();
                if (StringTools.isBlank(fromAddr)) {
                    CheckInstall.println("    ERROR: Unable to send email ('smtp.user.emailAddress' not defined)");
                    CheckInstall.addError("Unable to send a test email.", "Property 'smtp.user.emailAddress' has not been defined in the runtime config file.", "Please initialize this property to a valid 'from' email address, and re-run CheckInstall.");
                } else if (StringTools.isBlank(toAddr) || toAddr.endsWith("example.com")) {
                    CheckInstall.println("    ERROR: Unable to send email (Invalid 'To' address)");
                    CheckInstall.addError("Unable to send a test email.", "Invalid 'To' address specified.", "Please specify a valid 'To' address, and re-run CheckInstall.");
                } else {
                    String subj = "CheckInstall test email [" + DBConfig.getVersion() + "]";
                    String body = "CheckInstall test email sent successfully.\n";
                    CheckInstall.println("    Sending test email to '" + toAddr + "' ...");
                    SendMail.SetThreadModel("current");
                    if (SendMail.send(fromAddr, toAddr, subj, body, null, smtpProps)) {
                        CheckInstall.println("    ... Test email successfully sent:");
                        CheckInstall.println("        From   : " + fromAddr);
                        CheckInstall.println("        To     : " + toAddr);
                        CheckInstall.println("        Subject: " + subj);
                        CheckInstall.println("        Body   : " + body);
                    } else {
                        CheckInstall.println("    ERROR: Unable to send email ('SendMail' failed)");
                        CheckInstall.addError("Unable to send a test email.", "'SendMail' failed (see previous errors).", "Please fix displayed errors and re-run CheckInstall.");
                    }
                }
            }
        }
        CheckInstall.println("");
        CheckInstall.println("Character Encodings:");
        CheckInstall.printVariable("(Default Encoding)", StringTools.getCharacterEncoding(), "");
        String propEncoding = "file.encoding";
        String fileEncoding = System.getProperty(propEncoding, null);
        if (fileEncoding != null) {
            CheckInstall.printVariable(propEncoding, fileEncoding, "");
        } else {
            CheckInstall.printVariable(propEncoding, "(not specified?)", "");
        }
        String envGtsCharset = System.getenv(ENVIRON_GTS_CHARSET);
        if (envGtsCharset != null) {
            try {
                byte[] b = "hello".getBytes(envGtsCharset);
                CheckInstall.printVariable(ENVIRON_GTS_CHARSET, envGtsCharset, "");
            }
            catch (UnsupportedEncodingException uce) {
                CheckInstall.printVariable(ENVIRON_GTS_CHARSET, envGtsCharset, "(ERROR: invalid character encoding)");
                CheckInstall.addError("'GTS_CHARSET' specifies an invalid character encoding.", "Character encoding specified by 'GTS_CHARSET' is invalid", FIX_PREVIOUS_ERRORS);
            }
        }
        String dbCharset = null;
        try {
            dbCharset = DBProvider.getDefaultCharacterSet();
        }
        catch (Throwable th) {
            // empty catch block
        }
        String dbcs = !StringTools.isBlank(dbCharset) ? dbCharset : "?";
        CheckInstall.printVariable("DBProvider:" + DBProvider.getProviderName(), dbcs, "");
        CheckInstall.println("");
        CheckInstall.println("Tables [" + DBProvider.getDBUri(true) + "]");
        boolean skipTableChecks = false;
        if (defaultConfigFile != null) {
            String driver = DBProvider.loadJDBCDriver();
            if (driver == null) {
                CheckInstall.println("    ERROR: JDBC driver not found or cannot be loaded!");
                CheckInstall.addError("JDBC driver not found, or cannot be loaded.", "The database JDBC driver has not been installed, or cannot be loaded.", "Please install the appropriate JDBC driver with world-readable permissions.");
                skipTableChecks = true;
            } else {
                OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
                Iterator<String> i = factMap.keyIterator();
                while (i.hasNext()) {
                    String tn = i.next();
                    DBFactory<? extends DBRecord> f = factMap.get(tn);
                    try {
                        if (!f.tableExists()) {
                            CheckInstall.printVariable(f.getUntranslatedTableName(), "", "(ERROR: table does not exist!)");
                            CheckInstall.addError("Table '" + f.getUntranslatedTableName() + "' does not exist.", "Database may not have been initialized.", "Please initialize the database.");
                            continue;
                        }
                        if (!f.validateColumns(0)) {
                            CheckInstall.printVariable(f.getUntranslatedTableName(), "", "(ERROR: column validation failed!)");
                            CheckInstall.addError("Table '" + f.getUntranslatedTableName() + "' failed column validation.", "Table may be missing columns, or have columns which have changed types.", "Run 'bin/dbAdmin.pl -tables' (or 'bin/dbconfig.bat -tables') for details.");
                            continue;
                        }
                        String dbEng = f.getIndexType();
                        StringBuffer sb = new StringBuffer();
                        sb.append("[").append(dbEng).append("] ");
                        if (RTConfig.getBoolean(PROP_skipDBRecordCount, false)) {
                            sb.append("Exists");
                        } else {
                            boolean actual = false;
                            long rcdCnt = f.getRecordCount("", actual);
                            String rcdCntS = String.valueOf(rcdCnt);
                            if (!actual && rcdCnt > 0L && dbEng.equalsIgnoreCase("InnoDB")) {
                                rcdCntS = "~" + rcdCntS;
                            }
                            sb.append(rcdCntS);
                        }
                        CheckInstall.printVariable(f.getUntranslatedTableName(), sb.toString(), "");
                    }
                    catch (DBException dbe) {
                        if (dbe.isSQLException()) {
                            SQLException sqle = (SQLException)dbe.getCause();
                            String sqlMsg = sqle.getMessage().toLowerCase();
                            if (sqlMsg.indexOf("access denied") >= 0) {
                                CheckInstall.printVariable(tn, "", "(ERROR: SQL database access denied!)");
                                CheckInstall.addError("Database access denied.", "Possible invalid user/password, or database name, specified in runtime config file", "Please specify a valid database name/user/password in the runtime config file");
                            } else if (sqlMsg.indexOf("communications link failure") >= 0) {
                                CheckInstall.printVariable(tn, "", "(ERROR: SQL database connection failure!)");
                                CheckInstall.addError("Database connection failure.", "Database may not be running on expected port", "Please start database service on expected port");
                            } else if (sqlMsg.indexOf("no suitable driver") >= 0) {
                                CheckInstall.printVariable(tn, "", "(ERROR: Invalid JDBC driver!)");
                                CheckInstall.addError("JDBC driver not found, or invalid.", "The JDBC driver is not installed, or is invalid for the specified database provider", "Please install the appropriate JDBC driver for the specified database provider");
                            } else {
                                CheckInstall.printVariable(tn, "", "(ERROR: SQL exception!)");
                                CheckInstall.addError("SQL database exception while checking table '" + f.getUntranslatedTableName() + "' existance.", "Refer to above stacktrace for a detailed description", null);
                                dbe.printException();
                            }
                        } else {
                            CheckInstall.printVariable(tn, "", "(ERROR: database exception!)");
                            CheckInstall.addError("Database exception while checking table '" + f.getUntranslatedTableName() + "' existance.", "Refer to above stacktrace for a detailed description", null);
                            dbe.printException();
                        }
                        skipTableChecks = true;
                        break;
                    }
                }
            }
        } else {
            skipTableChecks = true;
        }
        if (skipTableChecks) {
            CheckInstall.println("    ERROR: Skipping table checks due to previous errors");
            CheckInstall.addError("Database table checks not performed.", "Table checks ignored due to previous errors", FIX_PREVIOUS_ERRORS);
        }
        CheckInstall.println("");
        CheckInstall.println("reports.xml:");
        File reportsXMLFile = ReportFactory._getReportXMLFile();
        if (reportsXMLFile == null || !reportsXMLFile.isFile()) {
            CheckInstall.printVariable("(XML file)", "", "(ERROR: XML file not found)");
            CheckInstall.addError("'reports.xml' file not found.", "Unable to locate 'reports.xml' file.", "Make sure that the 'reports.xml' file is available, then re-run this installation check");
        } else if (ReportFactory.hasParsingWarnings()) {
            CheckInstall.printVariable("(XML file)", reportsXMLFile.toString(), "(ERROR: Has parsing errors)");
            CheckInstall.addError("'reports.xml' has parsing errors.", "The 'reports.xml' lokely has invalid XML syntax or other parsing errors.", "Fix errors in 'reports.xml', then re-run this installation check");
        } else {
            CheckInstall.printVariable("(XML file)", reportsXMLFile.toString(), "");
        }
        Collection rptFactList = ReportFactory.getReportFactories();
        CheckInstall.printVariable("Total report count", String.valueOf(ListTools.size(rptFactList)), "");
        if (ListTools.isEmpty(rptFactList)) {
            if (BasicPrivateLabelLoader.isTrackServlet()) {
                int WC14 = CheckInstall.countWarning("'reports.xml' does not define any reports");
                CheckInstall.println("    WARNING[" + WC14 + "]: 'reports.xml' does not define any reports.");
            } else {
                int WC15 = CheckInstall.countWarning("'reports.xml' might not define any reports");
                CheckInstall.println("    WARNING[" + WC15 + "]: 'reports.xml' might not define any reports.");
            }
        } else {
            List<ReportFactory> rfList = ListTools.toList(rptFactList, new Vector());
            ListTools.sort(rfList, new Comparator<ReportFactory>(){

                @Override
                public int compare(ReportFactory rf1, ReportFactory rf2) {
                    String rt2;
                    if (rf1 == rf2) {
                        return 0;
                    }
                    if (rf1 == null) {
                        return 1;
                    }
                    if (rf2 == null) {
                        return -1;
                    }
                    String rt1 = rf1.getReportType();
                    if (rt1.equalsIgnoreCase(rt2 = rf1.getReportType())) {
                        return rf1.getReportName().compareTo(rf1.getReportName());
                    }
                    return rt1.compareTo(rt2);
                }
            });
            String lastReportType = null;
            for (ReportFactory rf : rfList) {
                String rptType = rf.getReportType();
                String rptName = rf.getReportName();
                String rptTitle = rf.getReportTitle(null, "");
                String rptLimit = "";
                if (SHOW_REPORT_LIMITS && rf.hasReportConstraints()) {
                    ReportConstraints rc = rf.getReportConstraints();
                    long selLim = rc.getSelectionLimit();
                    long rptLim = rc.getReportLimit();
                    rptLimit = "(limits=" + selLim + "/" + rptLim + ")";
                }
                if (lastReportType == null || !lastReportType.equalsIgnoreCase(rptType)) {
                    String rtDesc = ReportFactory.getReportTypeDescription(null, (String)rptType);
                    CheckInstall.printVariable("(" + rptType + ")", "--- " + rtDesc, "");
                    lastReportType = rptType;
                }
                CheckInstall.printVariable(" " + rptName, rptTitle, rptLimit, 26);
            }
        }
        CheckInstall.println("");
        CheckInstall.println("private.xml:");
        File privLblXMLFile = BasicPrivateLabelLoader.getPrivateXMLFile();
        if (privLblXMLFile == null || !privLblXMLFile.isFile()) {
            CheckInstall.printVariable("(XML file)", "", "(ERROR: XML file not found)");
            CheckInstall.addError("'private.xml' file not found.", "Unable to locate 'private.xml' file.", "Make sure that the 'private.xml' file is available, then re-run this installation check");
        } else {
            String trackXMLName;
            File trackXMLFile;
            CheckInstall.printVariable("(XML file)", privLblXMLFile.toString(), "");
            if (env_CATALINA_HOME != null && (trackXMLFile = new File(env_CATALINA_HOME, trackXMLName = "/webapps/track/WEB-INF/private.xml".replace('/', File.separatorChar))).isFile()) {
                int diff;
                byte[] T = FileTools.readFile(trackXMLFile);
                byte[] G = FileTools.readFile(privLblXMLFile);
                if (T != null && G != null && (diff = StringTools.compare(T, G, G.length)) != 0) {
                    String CH = isWindows ? "%CATALINA_HOME%" : "$CATALINA_HOME";
                    int WC16 = CheckInstall.countWarning("'private.xml' file does not match deployed version");
                    CheckInstall.println("    WARNING[" + WC16 + "]: does not match " + CH + trackXMLName);
                }
            }
        }
        Class loaderClass = BasicPrivateLabelLoader.getInstanceClass();
        CheckInstall.printVariable("(Class)", CheckInstall.ClassName(loaderClass), "");
        boolean isPrivateLabelLoader = false;
        try {
            isPrivateLabelLoader = PrivateLabelLoader.class.isAssignableFrom(loaderClass);
        }
        catch (Throwable th) {
            isPrivateLabelLoader = false;
        }
        if (!isPrivateLabelLoader) {
            if (env_CATALINA_HOME == null) {
                CheckInstall.println("    ERROR: CATALINA_HOME not defined, unable to perform Servlet level validation.");
                CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "CATALINA_HOME has not been defined", "Define CATALINA_HOME");
            } else {
                try {
                    Class.forName("org.opengts.war.track.Track");
                    try {
                        Class.forName("org.opengts.war.tools.PrivateLabelLoader");
                        CheckInstall.println("    ERROR: Unexpected 'PrivateLabelLoader' error, unable to perform Servlet level validation.");
                        CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "Some unexpected error has occurred while loading 'PrivateLabelLoader'", null);
                    }
                    catch (Throwable th) {
                        CheckInstall.println("    ERROR: Unable to load 'PrivateLabelLoader.class', unable to perform Servlet level validation.");
                        CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "Error loading 'PrivateLabelLoader': " + th, null);
                    }
                }
                catch (NoClassDefFoundError ncdfe) {
                    String errMsg = StringTools.trim(ncdfe.getMessage());
                    if (errMsg.startsWith("javax/servlet")) {
                        CheckInstall.println("    ERROR: Invalid CATALINA_HOME definition, unable to perform Servlet level validation.");
                        CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "CATALINA_HOME is likely pointing to an invalid Tomcat installation", "Check directory referenced by CATALINA_HOME");
                    } else {
                        CheckInstall.println("    ERROR: Required class not found, unable to perform Servlet level validation.");
                        CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "Unable to load class " + errMsg, "Check directory referenced by CATALINA_HOME");
                    }
                }
                catch (Throwable th) {
                    CheckInstall.println("    ERROR: Unable to load 'Track.class', unable to perform Servlet level validation.");
                    CheckInstall.addError("Servlet level PrivateLabelLoader checks on 'private.xml' were not performed.", "Error loading 'Track': " + th, null);
                }
            }
        }
        String privateXML = "private.xml";
        ReportFactory.setIgnoreMissingReports((boolean)false);
        BasicPrivateLabelLoader.loadPrivateLabelXML();
        if (BasicPrivateLabelLoader.hasParsingErrors()) {
            CheckInstall.println("    ERROR: Errors were encountered while parsing '" + privateXML + "'.");
            CheckInstall.addError("Full '" + privateXML + "' checks were not performed.", "Errors were encountered while parsing '" + privateXML + "'", FIX_PREVIOUS_ERRORS);
        } else {
            BasicPrivateLabel defaultPrivLabel;
            if (!BasicPrivateLabelLoader.isTrackServlet()) {
                CheckInstall.println("    ERROR: '" + privateXML + "' not fully loaded (possible classpath issue?)");
                CheckInstall.addError("Full '" + privateXML + "' checks may not be performed due to possible classpath issues.", "Possible incorrect command execution directory, or missing './build/track/WEB-INF/classes' directory.  This condition may cause false errors/warnings to be reported", "Make sure './build/track/WEB-INF/classes' exists, then re-run this installation check from the OpenGTS installation directory.");
            }
            OrderedSet<BasicPrivateLabel> privLabelSet = new OrderedSet<BasicPrivateLabel>(true);
            if (BasicPrivateLabelLoader.hasParsingWarnings()) {
                int WC17 = CheckInstall.countWarning("Warnings were encountered while parsing '" + privateXML + "'");
                CheckInstall.println("    WARNING[" + WC17 + "]: Warnings were encountered while parsing '" + privateXML + "'");
            }
            if ((defaultPrivLabel = BasicPrivateLabelLoader.getDefaultPrivateLabel()) != null) {
                privLabelSet.add(defaultPrivLabel);
            } else {
                int WC18 = CheckInstall.countWarning("'" + privateXML + "' does not define a default 'Domain'");
                CheckInstall.println("    WARNING[" + WC18 + "]: '" + privateXML + "' does not define a default 'Domain'.");
            }
            Collection<String> privLabelNames = BasicPrivateLabelLoader.getPrivateLabelNames();
            for (String privLabelName : privLabelNames) {
                BasicPrivateLabel privLabel = BasicPrivateLabelLoader.getPrivateLabel(privLabelName);
                if (privLabel != null) {
                    if (privLabelSet.contains(privLabel)) continue;
                    privLabelSet.add(privLabel);
                    continue;
                }
                CheckInstall.println("    ERROR: Unexpected error PrivateLabelName not found: " + privLabelName);
                CheckInstall.addError("Unexpected error PrivateLabelName not found: " + privLabelName, "Errors were encountered while parsing 'private.xml'", FIX_PREVIOUS_ERRORS);
            }
            CheckInstall.printVariable("(Domain count)", String.valueOf(privLabelSet.size()), "");
            int domainNdx = 1;
            for (BasicPrivateLabel privLabel : privLabelSet) {
                String name = privLabel.getDomainName();
                String host = privLabel.getHostName();
                String alias = StringTools.join(privLabel.getHostAliasNames(), ", ");
                boolean isDefault = name.equals("default");
                boolean skipDefaultEMailChecks = isDefault && RTConfig.getBoolean(PROP_skipDefaultEMailChecks, false);
                boolean skipDefaultMapChecks = isDefault && RTConfig.getBoolean(PROP_skipDefaultMapChecks, false);
                StringBuffer nameInfo = new StringBuffer();
                nameInfo.append(privLabel.getLocale().toString());
                if (privLabel.getAccountLogin()) {
                    nameInfo.append(", accountLogin");
                    String da = privLabel.getDefaultLoginAccount();
                    if (!StringTools.isBlank(da)) {
                        nameInfo.append("[\"").append(da).append("\"]");
                    }
                }
                if (privLabel.getUserLogin()) {
                    nameInfo.append(", userLogin");
                    String du = privLabel.getDefaultLoginUser();
                    if (!StringTools.isBlank(du)) {
                        nameInfo.append("[\"").append(du).append("\"]");
                    }
                }
                if (privLabel.getAllowEmailLogin()) {
                    nameInfo.append(", emailLogin");
                }
                if (privLabel.getEnableDemo()) {
                    nameInfo.append(", demo");
                }
                if (privLabel.isRestricted()) {
                    nameInfo.append(", restricted");
                }
                CheckInstall.printVariable(domainNdx++ + ") " + name, nameInfo.toString(), "");
                CheckInstall.printVariable("   (host)", " " + host, "");
                if (!StringTools.isBlank(alias)) {
                    CheckInstall.printVariable("   (alias)", " " + alias, "");
                }
                try {
                    PasswordHandler pwh = privLabel.getPasswordHandler();
                    if (pwh != null) {
                        String pwhCN = StringTools.className(pwh);
                        if (pwh instanceof GeneralPasswordHandler) {
                            GeneralPasswordHandler gph = (GeneralPasswordHandler)pwh;
                            pwhCN = pwhCN + ":" + gph.getEncodingString();
                        }
                        CheckInstall.printVariable("   (password handler)", " " + pwh.getName(), "(" + pwhCN + ")");
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                if (!skipDefaultEMailChecks) {
                    int WC2;
                    String[] email = privLabel.getEMailAddresses();
                    int emailErrors = 0;
                    for (int e = 0; e < email.length; ++e) {
                        if (!email[e].endsWith("example.com")) continue;
                        if (hasSMTPHost) {
                            CheckInstall.println("    ERROR: EMail address has not been customized: " + email[e]);
                            if (emailErrors == 0) {
                                CheckInstall.addError("EMail addresses for Domain '" + name + "' have not been customized.", null, "Customize EMail address, then re-run this installation check.");
                            }
                        } else {
                            WC2 = CheckInstall.countWarning("EMail address has not been customized: " + email[e]);
                            CheckInstall.println("    WARNING[" + WC2 + "]: EMail address has not been customized: " + email[e]);
                        }
                        ++emailErrors;
                    }
                    if (privLabel.getBooleanProperty("reportMenu.enableReportEmail", true)) {
                        String frEmail = privLabel.getEventNotificationFrom();
                        if (emailIsFunctional == -1) {
                            int WC19 = CheckInstall.countWarning("Report email defined, but SMTP not configured");
                            CheckInstall.println("    WARNING[" + WC19 + "]: Property 'reportMenu.enableReportEmail' defined, but SMTP has not been configured.");
                        } else if (StringTools.isBlank(frEmail)) {
                            WC2 = CheckInstall.countWarning("Report email defined, but no 'From' address configured");
                            CheckInstall.println("    WARNING:[" + WC2 + "] Property 'reportMenu.enableReportEmail' defined, but no 'From' configured.");
                        } else if (emailIsFunctional == 0) {
                            WC2 = CheckInstall.countWarning("Report email defined, but SMTP port not accessible");
                            CheckInstall.println("    WARNING[" + WC2 + "]: Property 'reportMenu.enableReportEmail' defined, but SMTP port not accessible.");
                        }
                    }
                }
                try {
                    if (privLabel instanceof PrivateLabel) {
                        PrivateLabel pl = (PrivateLabel)privLabel;
                        MapProvider mp = pl.getMapProvider();
                        if (mp == null) {
                            if (BasicPrivateLabelLoader.isTrackServlet()) {
                                CheckInstall.println("    ERROR: No active MapProvider defined [" + name + "]");
                                CheckInstall.addError("Domain '" + name + "' is missing an active MapProvider declaration.", null, "Add a MapProvider declaration to this Domain, then re-run this installation check");
                            } else {
                                int WC20 = CheckInstall.countWarning("Make sure Domain '" + name + "' has an active MapProvider");
                                CheckInstall.println("    WARNING[" + WC20 + "]: Make sure this Domain has an active MapProvider declaration.");
                            }
                        } else {
                            MapProviderAdapter mpa;
                            String mpDesc = mp.getName();
                            if (mp instanceof MapProviderAdapter && !StringTools.isBlank((mpa = (MapProviderAdapter)mp).getAuthorization())) {
                                mpDesc = mpDesc + "(key)";
                            }
                            CheckInstall.printVariable("   (map provider)", " " + mpDesc, "");
                            if (!skipDefaultMapChecks && mp instanceof MapProviderAdapter && !((MapProviderAdapter)mp).validate()) {
                                String mpName = mp.getName();
                                CheckInstall.println("    ERROR: MapProvider '" + mpName + "' returned a validation error");
                                CheckInstall.addError("MapProvider '" + mpName + "' returned a validation error for Domain '" + name + "'", null, FIX_PREVIOUS_ERRORS);
                            }
                        }
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    ReverseGeocodeProvider rgp = privLabel.getReverseGeocodeProvider();
                    if (rgp != null) {
                        ReverseGeocodeProvider frgp;
                        ReverseGeocodeProviderAdapter rgpa;
                        String rgDesc = rgp.getName();
                        if (rgp instanceof ReverseGeocodeProviderAdapter && !StringTools.isBlank((rgpa = (ReverseGeocodeProviderAdapter)rgp).getAuthorization())) {
                            rgDesc = rgDesc + "(key)";
                        }
                        if ((frgp = rgp.getFailoverReverseGeocodeProvider()) != null) {
                            rgDesc = rgDesc + " [failover=" + frgp.getName() + "]";
                        }
                        CheckInstall.printVariable("   (reverse-geocoder)", " " + rgDesc, "");
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    GeocodeProvider gcp = privLabel.getGeocodeProvider();
                    if (gcp != null) {
                        GeocodeProviderAdapter gcpa;
                        String gcDesc = gcp.getName();
                        if (gcp instanceof GeocodeProviderAdapter && !StringTools.isBlank((gcpa = (GeocodeProviderAdapter)gcp).getAuthorization())) {
                            gcDesc = gcDesc + "(key)";
                        }
                        CheckInstall.printVariable("   (geocoder)", " " + gcDesc, "");
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    MobileLocationProvider mlp = privLabel.getMobileLocationProvider();
                    if (mlp != null) {
                        MobileLocationProviderAdapter mlpa;
                        String mlpDesc = mlp.getName();
                        if (mlp instanceof MobileLocationProviderAdapter && !StringTools.isBlank((mlpa = (MobileLocationProviderAdapter)((Object)mlp)).getAuthorization())) {
                            mlpDesc = mlpDesc + "(key)";
                        }
                        CheckInstall.printVariable("   (mobile location)", " " + mlpDesc, "");
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                if (RTConfig.getBoolean(ARG_privateLabelDetail, false)) {
                    privLabel.pushRTProperties();
                    CheckInstall.printVariable("   http.userAgent", " " + RTConfig.getString("http.userAgent", "<default>"), "");
                    privLabel.popRTProperties();
                }
                String dftAcctID = privLabel.getDefaultLoginAccount();
                boolean dftAcctExists = false;
                if (!StringTools.isBlank(dftAcctID)) {
                    try {
                        dftAcctExists = Account.exists(dftAcctID);
                    }
                    catch (DBException dbe) {
                        int WC21 = CheckInstall.countWarning("DB Error when checking DefaultLoginAccount '" + dftAcctID + "' existence");
                        CheckInstall.println("    WARNING[" + WC21 + "]: DB Error determining if 'DefaultLoginAccount' exists.");
                        dftAcctExists = true;
                    }
                }
                if (!privLabel.getAccountLogin() && !privLabel.getAllowEmailLogin()) {
                    if (!dftAcctExists) {
                        if (StringTools.isBlank(dftAcctID)) {
                            CheckInstall.println("    ERROR: 'accountLogin' is false, and DefaultLoginAccount is blank.");
                            CheckInstall.addError("'accountLogin' is false, and DefaultLoginAccount is blank.", "'accountLogin' is false, 'emailLogin' is false, and no account-id has been specified on the 'DefaultLoginAccount' tag", FIX_PREVIOUS_ERRORS);
                        } else {
                            CheckInstall.println("    ERROR: 'accountLogin' is false, and account '" + dftAcctID + "' does not exist.");
                            CheckInstall.addError("accountLogin='false', and account '" + dftAcctID + "' does not exist.", "accountLogin='false', emailLogin='false', and account-id '" + dftAcctID + "' " + "specified on the 'DefaultLoginAccount' tag does not exist", FIX_PREVIOUS_ERRORS);
                        }
                    }
                } else if (!privLabel.getAccountLogin() && privLabel.getAllowEmailLogin() && !StringTools.isBlank(dftAcctID)) {
                    CheckInstall.println("    ERROR: DefaultLoginAccount specified when emailLogin='true'.");
                    CheckInstall.addError("DefaultLoginAccount specified when emailLogin='true' and accountLogin='false'", "emailLogin='true', accountLogin='false', and a non-blank account-id has been specified on the 'DefaultLoginAccount' tag", FIX_PREVIOUS_ERRORS);
                }
                if (dftAcctExists || StringTools.isBlank(dftAcctID)) continue;
                int WC22 = CheckInstall.countWarning("DefaultLoginAccount '" + dftAcctID + "' does not exist");
                CheckInstall.println("    WARNING[" + WC22 + "]: DefaultLoginAccount '" + dftAcctID + "' does not exist");
            }
        }
        CheckInstall.println("");
        CheckInstall.println("Device Communication Servers (registered):");
        Set<String> dcUndefSet = ListTools.toSet(DCServerFactory.getUndefinedServerList());
        List<DCServerConfig> dcServerList = DCServerFactory.getServerConfigList(true);
        if (dcServerList.isEmpty()) {
            CheckInstall.printVariable("   (none)", "", "");
        } else {
            int ndx = 1;
            gtsHomeStr = env_GTS_HOME != null ? env_GTS_HOME.toString() : "";
            for (DCServerConfig dcs : dcServerList) {
                String name = dcs.getName();
                if (dcs.serverJarExists()) {
                    String ndxStr = StringTools.padLeft(String.valueOf(ndx++), ' ', 2);
                    File[] jarPath = dcs.getRunningJarPath();
                    boolean running = !ListTools.isEmpty(jarPath);
                    String dcsDesc = dcs.getDescription();
                    String dcsPorts = dcs.getPortsString();
                    CheckInstall.printVariable(ndxStr + ") " + name, "[" + dcsPorts + "] " + dcsDesc + (running ? " (running)" : ""), "");
                    if (!running) continue;
                    for (int d = 0; d < jarPath.length; ++d) {
                        File logFile;
                        boolean logExists;
                        String jarPathStr = jarPath[d].toString();
                        CheckInstall.printVariable("     (running)", " " + jarPathStr, "");
                        if (!StringTools.isBlank(gtsHomeStr) && !jarPathStr.startsWith(gtsHomeStr)) {
                            int WC23 = CheckInstall.countWarning("DCServer jar path is not in the current GTS_HOME path: " + name);
                            CheckInstall.println("    WARNING[" + WC23 + "]: DCServer jar path is not in the current GTS_HOME path");
                        }
                        boolean bl = logExists = (logFile = DCServerConfig.getLogFilePath(jarPath[d])) != null && logFile.isFile();
                        if (!logExists) continue;
                        CheckInstall.printVariable("     (logfile)", " " + logFile.toString(), "");
                    }
                    String[] cmds = dcs.getCommandList();
                    if (ListTools.isEmpty(cmds)) continue;
                    String cmdList = StringTools.join(cmds, ", ");
                    CheckInstall.printVariable("     (commands)", " " + cmdList, "");
                    continue;
                }
                if (dcs.isJarOptional()) {
                    String ndxStr = StringTools.padLeft(String.valueOf(ndx++), ' ', 2);
                    String dcsDesc = dcs.getDescription();
                    String dcsPorts = dcs.getPortsString();
                    CheckInstall.printVariable(ndxStr + ") " + name, "[" + dcsPorts + "] " + dcsDesc + " (no jar)", "");
                    continue;
                }
                if (!dcUndefSet.contains(name)) continue;
                String ndxStr = StringTools.padLeft(String.valueOf(ndx++), ' ', 2);
                CheckInstall.printVariable(ndxStr + ") " + name, dcs.toString(false), "");
                int WC24 = CheckInstall.countWarning("Referenced server jar does not exist: " + name);
                CheckInstall.println("    WARNING[" + WC24 + "]: Server jar referenced in runtime config not found: " + name);
            }
        }
        boolean cronBorderCrossing = false;
        Vector<String> cronReportCron = null;
        Object cron = null;
        try {
            MethodAction ma = new MethodAction("org.opengts.extra.util.Cron");
            cron = ma.invoke();
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (cron != null) {
            CheckInstall.println("");
            CheckInstall.println("Crontab Configuration:");
            gtsHomeStr = env_GTS_HOME != null ? env_GTS_HOME.toString() : ".";
            String crontabFileName = null;
            File crontabFile = null;
            String[] crontabList = new String[]{"crontab/crontab.xml", "crontab/cronRuleFactoryLite.xml"};
            for (int ctf = 0; ctf < crontabList.length; ++ctf) {
                File crontab = new File(gtsHomeStr, crontabList[ctf]);
                if (!FileTools.isFile(crontab)) continue;
                crontabFileName = crontabList[ctf];
                crontabFile = crontab;
                break;
            }
            if (!FileTools.isFile(crontabFile)) {
                CheckInstall.printVariable("Crontab file", "(not found)", "");
            } else {
                CheckInstall.printVariable("Crontab file", crontabFileName, "");
                try {
                    MethodAction maLoad = new MethodAction(cron, "load", File.class);
                    maLoad.invoke(crontabFile);
                    MethodAction maJobList = new MethodAction(cron, "getJobNames");
                    String[] jobNames = (String[])maJobList.invoke();
                    CheckInstall.printVariable("Active Job Count", String.valueOf(ListTools.size(jobNames)), "");
                    MethodAction maJobDesc = new MethodAction(cron, "getJobDescription", String.class);
                    for (String jn : jobNames) {
                        String jobDesc = (String)maJobDesc.invoke(jn);
                        CheckInstall.printVariable(LS_FILE_PFX + jn, jobDesc, "");
                        if (StringTools.startsWithIgnoreCase(jn, "ReportCron")) {
                            String rptTags;
                            int p;
                            if (cronReportCron == null) {
                                cronReportCron = new Vector<String>();
                            }
                            if ((p = jobDesc.indexOf("-tag=")) < 0) continue;
                            int s = jobDesc.indexOf(" ", p += "-tag=".length());
                            String string2 = rptTags = s > p ? jobDesc.substring(p, s) : jobDesc.substring(p);
                            if (StringTools.isBlank(rptTags)) continue;
                            for (String rt : StringTools.split(rptTags, ',')) {
                                cronReportCron.add(rt);
                            }
                            continue;
                        }
                        if (!StringTools.startsWithIgnoreCase(jn, "BorderCrossing")) continue;
                        cronBorderCrossing = true;
                    }
                }
                catch (Throwable th) {
                    int WC25 = CheckInstall.countWarning("Unable to load crontab file: " + crontabFileName);
                    CheckInstall.println("    WARNING[" + WC25 + "]: Unable to load crontab file: " + crontabFileName);
                    Print.logException("Cron query", th);
                }
            }
            if (cronReportCron != null) {
                String reportJobAdmin;
                Vector<String> rptJobTags = new Vector<String>();
                try {
                    MethodAction maTagMap = new MethodAction((Object)"org.opengts.extra.tables.ReportJob", "GetIntervalTagMap");
                    Map iTagMap = (Map)maTagMap.invoke();
                    if (iTagMap != null) {
                        for (Object tn : iTagMap.keySet()) {
                            rptJobTags.add(tn.toString());
                        }
                    }
                }
                catch (Throwable th) {
                    // empty catch block
                }
                CheckInstall.printVariable("ReportJob tags", StringTools.join(rptJobTags, ","), "");
                CheckInstall.printVariable("ReportCron tags", StringTools.join(cronReportCron, ","), "");
                for (String rjt : rptJobTags) {
                    if (rjt.equalsIgnoreCase("none") || ListTools.containsIgnoreCase(cronReportCron, rjt)) continue;
                    int WC26 = CheckInstall.countWarning("Define 'ReportCron_" + rjt + "' (tag '" + rjt + "') in '" + crontabFileName + "'");
                    CheckInstall.println("    WARNING[" + WC26 + "]: ReportCron does not define tag: " + rjt);
                }
                if (!RTConfig.getBoolean("track.enableService", false)) {
                    int WC27 = CheckInstall.countWarning("'track.enableService' required for ReportCron use");
                    CheckInstall.println("    WARNING[" + WC27 + "]: Enable '" + "track.enableService" + "' for ReportCron use");
                }
                if (!RTConfig.getBoolean(reportJobAdmin = "Domain.WebPages.ReportJobAdmin", false)) {
                    int WC28 = CheckInstall.countWarning("'" + reportJobAdmin + "' required for ReportCron use");
                    CheckInstall.println("    WARNING[" + WC28 + "]: Enable '" + reportJobAdmin + "' for ReportCron use");
                }
            }
            if (cronBorderCrossing) {
                CheckInstall.printVariable("BorderCrossingCron", "true", "");
                String startupBorderCrossing = "startupInit.Device.BorderCrossingFieldInfo";
                if (!RTConfig.getBoolean(startupBorderCrossing, false)) {
                    int WC29 = CheckInstall.countWarning("'" + startupBorderCrossing + "' required for BorderCrossing use");
                    CheckInstall.println("    WARNING[" + WC29 + "]: Enable '" + startupBorderCrossing + "' for BorderCrossing use");
                }
            }
        }
        if (env_GTS_LINKS != null && env_GTS_LINKS.isDirectory()) {
            String envVar;
            CheckInstall.println("");
            CheckInstall.println("Recommended symbolic links:");
            File link = new File(env_GTS_LINKS, "gts");
            File target = FileTools.getRealFile(link);
            File expect = env_GTS_HOME;
            String string3 = envVar = OSTools.isWindows() ? "%GTS_HOME%" : "$GTS_HOME";
            if (OSTools.isWindows() && FileTools.isCygwinSymlink(target)) {
                target = FileTools.getCygwinSymlinkFile(target, true);
            }
            if (target == null) {
                CheckInstall.printVariable(link.toString(), "?", "");
                int WC30 = CheckInstall.countWarning("Symbolic Link does not exist: " + link.toString());
                CheckInstall.println("    WARNING[" + WC30 + "]: Symbolic link does not exist, or is invalid: " + link.toString());
                recommendations.append("- Recommend creating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!target.equals(expect)) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
                int WC31 = CheckInstall.countWarning("Symbolic Link is not up to date: " + link.toString());
                CheckInstall.println("    WARNING[" + WC31 + "]: Symbolic link is not up to date: " + link.toString());
                recommendations.append("- Recommend recreating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     rm " + link + "\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!link.toString().equals(target.toString())) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
            } else if (OSTools.isWindows()) {
                CheckInstall.printVariable(link.toString(), "(Windows link?)", "");
            } else {
                CheckInstall.printVariable(link.toString(), "--", "");
            }
            link = new File(env_GTS_LINKS, "java");
            target = FileTools.getRealFile(link);
            expect = env_JAVA_HOME;
            String string4 = envVar = OSTools.isWindows() ? "%JAVA_HOME%" : "$JAVA_HOME";
            if (OSTools.isWindows() && FileTools.isCygwinSymlink(target)) {
                target = FileTools.getCygwinSymlinkFile(target, true);
            }
            if (target == null) {
                CheckInstall.printVariable(link.toString(), "?", "");
                int WC32 = CheckInstall.countWarning("Symbolic Link does not exist: " + link.toString());
                CheckInstall.println("    WARNING[" + WC32 + "]: Symbolic link does not exist, or is invalid: " + link.toString());
                recommendations.append("- Recommend creating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!target.equals(expect)) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
                int WC33 = CheckInstall.countWarning("Symbolic Link is not up to date: " + link.toString());
                CheckInstall.println("    WARNING[" + WC33 + "]: Symbolic link is not up to date: " + link.toString());
                recommendations.append("- Recommend recreating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     rm " + link + "\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!link.toString().equals(target.toString())) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
            } else if (OSTools.isWindows()) {
                CheckInstall.printVariable(link.toString(), "(Windows link?)", "");
            } else {
                CheckInstall.printVariable(link.toString(), "--", "");
            }
            link = new File(env_GTS_LINKS, "tomcat");
            target = FileTools.getRealFile(link);
            expect = env_CATALINA_HOME;
            String string5 = envVar = OSTools.isWindows() ? "%CATALINA_HOME%" : "$CATALINA_HOME";
            if (OSTools.isWindows() && FileTools.isCygwinSymlink(target)) {
                target = FileTools.getCygwinSymlinkFile(target, true);
            }
            if (target == null) {
                CheckInstall.printVariable(link.toString(), "?", "");
                int WC34 = CheckInstall.countWarning("Symbolic Link does not exist, or is invalid: " + link.toString());
                CheckInstall.println("    WARNING[" + WC34 + "]: Symbolic link does not exist: " + link.toString());
                recommendations.append("- Recommend creating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!target.equals(expect)) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
                int WC35 = CheckInstall.countWarning("Symbolic Link is not up to date: " + link.toString());
                CheckInstall.println("    WARNING[" + WC35 + "]: Symbolic link is not up to date: " + link.toString());
                recommendations.append("- Recommend recreating " + link + " symbolic link to point to " + envVar + ":\n");
                recommendations.append("     rm " + link + "\n");
                recommendations.append("     ln -s " + expect + " " + link + "\n");
            } else if (!link.toString().equals(target.toString())) {
                CheckInstall.printVariable(link.toString(), target.toString(), "");
            } else if (OSTools.isWindows()) {
                CheckInstall.printVariable(link.toString(), "(Windows link?)", "");
            } else {
                CheckInstall.printVariable(link.toString(), "--", "");
            }
        }
        CheckInstall.println("");
        CheckInstall.println(eqSep);
        int rtnCode = 0;
        CheckInstall.println("");
        if (!CheckInstall.getErrors().isEmpty()) {
            CheckInstall.println("** Found " + CheckInstall.getErrors().size() + " Error(s)!");
            CheckInstall.println(StringTools.replicateString("*", sepWidth));
            int ndx = 1;
            for (String[] err : CheckInstall.getErrors()) {
                CheckInstall.println(ndx++ + ") " + err[0]);
                if (!StringTools.isBlank(err[1])) {
                    CheckInstall.wrapPrintln("   [Reason: " + err[1] + "]", ' ');
                }
                if (err.length > 2 && !StringTools.isBlank(err[2])) {
                    CheckInstall.wrapPrintln("   [Fix: " + err[2] + "]", ' ');
                }
                if (err.length > 3 && err[3].equals("false")) continue;
                rtnCode = 1;
            }
            CheckInstall.println(StringTools.replicateString("*", sepWidth));
        } else {
            CheckInstall.println("No errors reported");
        }
        CheckInstall.println("");
        if (warnCount > 0) {
            CheckInstall.println("-- Found " + warnCount + " Warning(s):");
            for (String warnMsg : CheckInstall.getWarnings()) {
                CheckInstall.wrapPrintln(warnMsg, ' ');
            }
        } else {
            CheckInstall.println("No warnings reported");
        }
        if (recommendations.length() > 0) {
            CheckInstall.println("");
            CheckInstall.println("-- Recommendations:");
            CheckInstall.println(recommendations.toString().trim());
        }
        CheckInstall.println("");
        CheckInstall.println(eqSep);
        CheckInstall.println(eqSep);
        System.exit(rtnCode);
    }

    private static StringBuffer getLinkRecommendation(StringBuffer sb, AccumulatorLong index, File link, File target, File expected, String envVarName) {
        if (link != null) {
            if (target == null) {
                int n = (int)index.next();
                sb.append(n + ") Symbolic link: " + link + " (does not exist)\n");
                sb.append("   Recommend creating symbolic link to point to " + envVarName + ":\n");
                sb.append("     ln -s " + expected + " " + link + "\n");
            } else if (!target.equals(expected)) {
                int n = (int)index.next();
                sb.append(n + ") Symbolic link: " + link + " (exists, but does not point to the current installation)\n");
                sb.append("   Recommend recreating symbolic link to point to " + envVarName + ":\n");
                sb.append("     rm " + link + "\n");
                sb.append("     ln -s " + expected + " " + link + "\n");
            } else {
                int n = (int)index.next();
                sb.append(n + ") Symbolic link: " + link + " (exists, and is up to date)\n");
            }
        }
        return sb;
    }

    public static interface OutputHandler {
        public void checkInstallOutput(String var1);
    }
}

