/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.dbinfo;

import java.awt.Component;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.opt.ui.VTreeViewer;
import org.opengts.util.StringTools;

public class DBTableInformation
extends VBox {
    private static final String ROW_DESCRIPTION = "description";
    private static final String ROW_ROW_COUNT = "rowCount";
    private static final String ROW_EDITABLE = "editable";
    private static final String ROW_RECORD_CLASS = "recordClass";
    private static final String ROW_KEY_CLASS = "keyClass";
    private static final String ROW_KEY_TYPE = "keyType";
    private static final String ROW_ALT_KEY_LIST = "altKeyList";
    private VTreeViewer treeViewer = null;
    private VLabelValue labelValue = null;

    public DBTableInformation(VTreeViewer treeViewer) {
        super(null, null, true);
        this.treeViewer = treeViewer;
        this.init();
    }

    public void init() {
        this.labelValue = new VLabelValue(null, null, false);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)this.labelValue, this.getDefaultGBC());
        VTextArea descText = new VTextArea(5, 40);
        descText.setLineWrap(true);
        descText.setReadOnly(true);
        VTextField rowCount = new VTextField(10);
        rowCount.setReadOnly(true);
        VTextField editable = new VTextField(6);
        editable.setReadOnly(true);
        VTextField keyClass = new VTextField(40);
        keyClass.setReadOnly(true);
        VTextField recordClass = new VTextField(40);
        recordClass.setReadOnly(true);
        VTextField keyType = new VTextField(20);
        keyType.setReadOnly(true);
        VTextField altKeyList = new VTextField(32);
        altKeyList.setReadOnly(true);
        this.labelValue.addRow("Description", (VBox)descText, ROW_DESCRIPTION);
        this.labelValue.addRow("Row Count", (VBox)rowCount, ROW_ROW_COUNT);
        this.labelValue.addRow("Editable?", (VBox)editable, ROW_EDITABLE);
        this.labelValue.addRow("Record Class", (VBox)recordClass, ROW_RECORD_CLASS);
        this.labelValue.addRow("Key Class", (VBox)keyClass, ROW_KEY_CLASS);
        this.labelValue.addRow("Key Type", (VBox)keyType, ROW_KEY_TYPE);
        this.labelValue.addRow("Alternate Keys", (VBox)altKeyList, ROW_ALT_KEY_LIST);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 3, 1);
        this.add((Component)new VFiller(), this.getDefaultGBC());
    }

    public VTreeViewer getVTreeViewer() {
        return this.treeViewer;
    }

    public VTree getVTree() {
        VTreeViewer tv = this.getVTreeViewer();
        return tv != null ? tv.getVTree() : null;
    }

    public VTreeNode getSelectedNode() {
        VTree tree = this.getVTree();
        return tree != null ? tree.getSelectedNode() : null;
    }

    public DBFactory<? extends DBRecord> getSelectedDBFactory() {
        VTreeNode node = this.getSelectedNode();
        Object usrObj = node != null ? node.getUserObject() : null;
        return (DBFactory)usrObj;
    }

    public void refresh() {
        DBFactory<? extends DBRecord> dbf = this.getSelectedDBFactory();
        if (dbf == null) {
            this.labelValue.setRowValue(ROW_DESCRIPTION, null);
            this.labelValue.setRowValue(ROW_ROW_COUNT, null);
            this.labelValue.setRowValue(ROW_EDITABLE, "false");
            this.labelValue.setRowValue(ROW_RECORD_CLASS, null);
            this.labelValue.setRowValue(ROW_KEY_CLASS, null);
            this.labelValue.setRowValue(ROW_KEY_TYPE, null);
            this.labelValue.setRowValue(ROW_ALT_KEY_LIST, "");
            return;
        }
        this.labelValue.setRowValue(ROW_DESCRIPTION, dbf.getDescription(null));
        try {
            long rcdCnt = dbf.getRecordCount("", false);
            this.labelValue.setRowValue(ROW_ROW_COUNT, String.valueOf(rcdCnt));
        }
        catch (DBException dbe) {
            this.labelValue.setRowValue(ROW_ROW_COUNT, "error");
        }
        this.labelValue.setRowValue(ROW_EDITABLE, String.valueOf(dbf.isEditable()));
        this.labelValue.setRowValue(ROW_RECORD_CLASS, dbf.getRecordClass().getName());
        this.labelValue.setRowValue(ROW_KEY_CLASS, dbf.getKeyClass().getName());
        this.labelValue.setRowValue(ROW_KEY_TYPE, dbf.getKeyType());
        this.labelValue.setRowValue(ROW_ALT_KEY_LIST, StringTools.join((String[])dbf.getAlternateIndexNames(), (String)","));
    }
}

