/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.dbinfo;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VPopupMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VTable;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.opt.ui.VTreeViewer;
import org.opengts.util.ColorTools;
import org.opengts.util.Print;

public class DBActualColumns
extends VTable
implements VPopupMenuProvider {
    private static final Color BACKGROUND_MISSING = new Color(255, 200, 200);
    private static final Color BACKGROUND_ERROR = new Color(255, 200, 200);
    private static final Color BACKGROUND_NEW = new Color(255, 255, 158);
    private static VTable.VColumnInfo[] columns = new VTable.VColumnInfo[]{new VTable.VColumnInfo("field.numb", "##", 70, true), new VTable.VColumnInfo("field.name", "Field Name", 350, true), new VTable.VColumnInfo("field.desc", "Description", 600, true), new VTable.VColumnInfo("field.type", "SQL Type", 400, false), new VTable.VColumnInfo("field.key", "Key?", 130, false)};
    private VTreeViewer treeViewer = null;

    public DBActualColumns(VTreeViewer treeViewer) {
        super(null, null, true);
        this.treeViewer = treeViewer;
        this.setTableColumns(columns);
        this.getTableView().setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new DBFieldRenderer(this)));
        this.setContextMenu(this);
    }

    public JPopupMenu getPopupMenu() {
        boolean dropColumn;
        DBFieldRow row = (DBFieldRow)this.getSelectedRow();
        if (row == null) {
            return null;
        }
        final DBFactory dbFact = this.getSelectedDBFactory();
        if (dbFact == null) {
            return null;
        }
        boolean alterType = false;
        boolean alterKey = false;
        boolean bl = dropColumn = row.hasActualColumn() && !row.hasDefinedColumn();
        if (!dropColumn) {
            if (row.hasActualColumn() && row.hasDefinedColumn()) {
                alterType = !row.areTypesEquivalent();
                boolean bl2 = alterKey = !alterType && !row.areKeysEquivalent();
            }
            if (!alterType && !alterKey) {
                return null;
            }
        }
        final DBField defField = row.getDefinedField();
        final DBField actField = row.getActualField();
        VPopupMenu popup = new VPopupMenu("Alter Column");
        if (dropColumn) {
            popup.add((Action)new AbstractAction("Drop Column"){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DBActualColumns.this.dropActualColumn(dbFact, defField, actField);
                }
            }).setEnabled(GTSAdmin.DBConnectionOK());
        } else {
            if (alterType) {
                popup.add((Action)new AbstractAction("Alter Column Type"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        DBActualColumns.this.alterColumnType(dbFact, defField, actField);
                    }
                }).setEnabled(GTSAdmin.DBConnectionOK());
            }
            if (alterKey) {
                boolean actIsKey;
                boolean bl3 = actIsKey = actField != null && actField.isKeyField();
                if (actIsKey || defField != null && defField.isPrimaryKey()) {
                    popup.add((Action)new AbstractAction("Rebuild Primary Key Index"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            DBActualColumns.this.rebuildPrimaryIndex(dbFact);
                        }
                    }).setEnabled(GTSAdmin.DBConnectionOK());
                }
                if (actIsKey || defField.isAlternateKey()) {
                    popup.add((Action)new AbstractAction("Rebuild Alternate Key Index"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            DBActualColumns.this.rebuildAlternateIndex(dbFact);
                        }
                    }).setEnabled(GTSAdmin.DBConnectionOK());
                }
            }
        }
        return popup;
    }

    private void alterColumnType(DBFactory dbFact, DBField definedField, DBField actualField) {
        Print.logInfo((String)("Altering column: " + definedField), (Object[])new Object[0]);
        try {
            dbFact.addColumns(new DBField[]{definedField}, 0);
            GTSAdmin.getInstance().refreshSelectedNode();
            GTSAdmin.getInstance().updateFactoryNodes();
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to alter column", (Throwable)dbe);
        }
    }

    private void rebuildPrimaryIndex(DBFactory dbFact) {
        Print.logInfo((String)"Recreating Primary Key", (Object[])new Object[0]);
        boolean ok = VOptionPane.showYesNoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Are you sure you want to rebuild the Primary Key Index?", (String)"Confirm Rebuild Primary Key");
        if (ok) {
            try {
                dbFact.recreatePrimaryKey();
                GTSAdmin.getInstance().refreshSelectedNode();
                GTSAdmin.getInstance().updateFactoryNodes();
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to rebuild primary index", (Throwable)dbe);
                VOptionPane.showErrorDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Unable to alter table key field", (String)"Error Altering Table Keys");
            }
        }
    }

    private void rebuildAlternateIndex(DBFactory dbFact) {
        Print.logInfo((String)"Recreating Alternate Key", (Object[])new Object[0]);
        boolean ok = VOptionPane.showYesNoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Are you sure you want to rebuild the Alternate Index?", (String)"Confirm Rebuild Alternate Index");
        if (ok) {
            try {
                dbFact.recreateAlternateIndexes();
                GTSAdmin.getInstance().refreshSelectedNode();
                GTSAdmin.getInstance().updateFactoryNodes();
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to rebuild alternate index", (Throwable)dbe);
                VOptionPane.showErrorDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Unable to alter table key field", (String)"Error Altering Table Keys");
            }
        }
    }

    private void dropActualColumn(DBFactory dbFact, DBField definedField, DBField actualField) {
        Print.logInfo((String)("Drop column: " + actualField), (Object[])new Object[0]);
        boolean ok = VOptionPane.showYesNoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)("Are you sure you want to drop column '" + actualField + "'?"), (String)"Confirm Drop Column");
        if (ok) {
            try {
                dbFact.dropColumn(actualField);
                GTSAdmin.getInstance().refreshSelectedNode();
                GTSAdmin.getInstance().updateFactoryNodes();
            }
            catch (DBException dbe) {
                Print.logException((String)"Unable to alter column", (Throwable)dbe);
            }
        }
    }

    public VTreeViewer getVTreeViewer() {
        return this.treeViewer;
    }

    public VTree getVTree() {
        VTreeViewer tv = this.getVTreeViewer();
        return tv != null ? tv.getVTree() : null;
    }

    public VTreeNode getSelectedNode() {
        VTree tree = this.getVTree();
        return tree != null ? tree.getSelectedNode() : null;
    }

    public DBFactory getSelectedDBFactory() {
        VTreeNode node = this.getSelectedNode();
        Object usrObj = node != null ? node.getUserObject() : null;
        return (DBFactory)usrObj;
    }

    public int getErrors(DBFactory dbFact) {
        if (!GTSAdmin.DBConnectionOK()) {
            return 2;
        }
        return this._refresh(dbFact, false);
    }

    public void refresh() {
        DBFactory dbf = this.getSelectedDBFactory();
        if (dbf == null) {
            this.clearTableData();
            return;
        }
        this._refresh(dbf, true);
    }

    protected int _refresh(DBFactory dbf, boolean updateTable) {
        if (dbf == null) {
            return 2;
        }
        boolean hasErrors = false;
        boolean hasWarnings = false;
        DBField[] definedFields = dbf.getFields();
        try {
            DBField[] actualFields = dbf.getExistingColumns(true);
            Vector<DBFieldRow> tableRows = new Vector<DBFieldRow>();
            for (int a = 0; a < actualFields.length; ++a) {
                DBField afld = actualFields[a];
                DBField foundDefFld = null;
                for (int d = 0; d < definedFields.length; ++d) {
                    DBField dfld = definedFields[d];
                    if (!afld.getName().equalsIgnoreCase(dfld.getName())) continue;
                    foundDefFld = dfld;
                    break;
                }
                if (foundDefFld == null) {
                    hasWarnings = true;
                }
                tableRows.add(new DBFieldRow(a, afld, foundDefFld));
            }
            int index = actualFields.length;
            for (int d = 0; d < definedFields.length; ++d) {
                String atype;
                DBField afld = null;
                DBField dfld = definedFields[d];
                for (int a = 0; a < actualFields.length; ++a) {
                    DBField af = actualFields[a];
                    if (!af.getName().equalsIgnoreCase(dfld.getName())) continue;
                    afld = af;
                    break;
                }
                if (afld == null) {
                    hasErrors = true;
                    tableRows.add(new DBFieldRow(index++, null, dfld));
                    continue;
                }
                String dtype = DBProvider.getDataTypeFromSqlType((String)dfld.getSqlType());
                if (!DBProvider.areTypesEquivalent((String)dtype, (String)(atype = DBProvider.getDataTypeFromSqlType((String)afld.getSqlType())))) {
                    hasErrors = true;
                    continue;
                }
                if (afld.isPrimaryKey() != dfld.isPrimaryKey()) {
                    hasErrors = true;
                    continue;
                }
                if (afld.isAlternateKey() != dfld.isAlternateKey()) {
                    hasErrors = true;
                    continue;
                }
                if (afld.equalsAlternateIndexes(dfld.getAlternateIndexes())) continue;
                hasErrors = true;
            }
            if (updateTable) {
                this.setTableData(tableRows);
            }
        }
        catch (DBException dbe) {
            Print.logError((String)("Existing Columns: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            if (updateTable) {
                this.clearTableData();
            }
            hasErrors = true;
        }
        return hasErrors ? 2 : (hasWarnings ? 1 : 0);
    }

    public class DBFieldRenderer
    extends VTable.VTableCellRenderer {
        private VTable table = null;

        public DBFieldRenderer(VTable table) {
            this.table = table;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int row, int col) {
            Color bg;
            super.getTableCellRendererComponent(tbl, val, isSel, focus, row, col);
            DBFieldRow fldRow = (DBFieldRow)this.table.getRow(row);
            if (fldRow != null && (bg = fldRow.getBackground(col)) != null) {
                if (isSel) {
                    bg = ColorTools.mix((Color)bg, (Color)tbl.getSelectionBackground(), (float)0.7f);
                }
                this.setBackground(bg);
            }
            return this;
        }
    }

    private static class DBFieldRow
    implements VTable.VTableRow {
        private int index = -1;
        private DBField actFld = null;
        private String actType = null;
        private DBField defFld = null;
        private String defType = null;

        public DBFieldRow(int ndx, DBField aFld, DBField dFld) {
            this.index = ndx;
            this.actFld = aFld;
            this.actType = aFld != null ? DBProvider.getDataTypeFromSqlType((String)aFld.getSqlType()) : null;
            this.defFld = dFld;
            this.defType = dFld != null ? DBProvider.getDataTypeFromSqlType((String)dFld.getSqlType()) : null;
        }

        public Object getRowObject() {
            return this.actFld;
        }

        public DBField getActualField() {
            return this.actFld;
        }

        public DBField getDefinedField() {
            return this.defFld;
        }

        public Object getColumnValue(int col) {
            switch (col) {
                case 0: {
                    if (this.actFld != null) {
                        return new Integer(this.index + 1);
                    }
                    return "";
                }
                case 1: {
                    if (this.actFld != null) {
                        return this.actFld.getName();
                    }
                    return this.defFld.getName();
                }
                case 2: {
                    if (this.defFld != null) {
                        return this.defFld.getTitle(null);
                    }
                    return "";
                }
                case 3: {
                    if (this.actFld != null) {
                        return this.actFld.getSqlType();
                    }
                    return this.defFld.getSqlType();
                }
                case 4: {
                    if (this.actFld != null) {
                        return this.actFld.getIndexNames();
                    }
                    return this.defFld.getIndexNames();
                }
            }
            return "";
        }

        public void setColumnValue(int col, Object value) {
        }

        public boolean isColumnEditable(int col) {
            return false;
        }

        public boolean hasActualColumn() {
            return this.actFld != null;
        }

        public boolean hasDefinedColumn() {
            return this.defFld != null;
        }

        public boolean areTypesEquivalent() {
            return this.hasActualColumn() && this.hasDefinedColumn() ? DBProvider.areTypesEquivalent((String)this.defType, (String)this.actType) : false;
        }

        public boolean areKeysEquivalent() {
            if (this.hasActualColumn() && this.hasDefinedColumn()) {
                if (this.actFld.isPrimaryKey() != this.defFld.isPrimaryKey()) {
                    return false;
                }
                if (this.actFld.isAlternateKey() != this.defFld.isAlternateKey()) {
                    return false;
                }
                return this.actFld.equalsAlternateIndexes(this.defFld.getAlternateIndexes());
            }
            return false;
        }

        public Color getBackground(int col) {
            if (!this.hasActualColumn()) {
                return BACKGROUND_MISSING;
            }
            if (!this.hasDefinedColumn()) {
                return BACKGROUND_NEW;
            }
            switch (col) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    if (!this.areTypesEquivalent()) {
                        return BACKGROUND_ERROR;
                    }
                    return null;
                }
                case 4: {
                    if (!this.areKeysEquivalent()) {
                        return BACKGROUND_ERROR;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

